/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationId)).setter(UpdateApplicationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::author)).setter(UpdateApplicationRequest.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomePageUrl").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::homePageUrl)).setter(UpdateApplicationRequest.setter(Builder::homePageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::labels)).setter(UpdateApplicationRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> README_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadmeBody").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::readmeBody)).setter(UpdateApplicationRequest.setter(Builder::readmeBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeBody").build()}).build();
    private static final SdkField<String> README_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadmeUrl").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::readmeUrl)).setter(UpdateApplicationRequest.setter(Builder::readmeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTHOR_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, README_BODY_FIELD, README_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String author;
    private final String description;
    private final String homePageUrl;
    private final List<String> labels;
    private final String readmeBody;
    private final String readmeUrl;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String author() {
        return this.author;
    }

    public final String description() {
        return this.description;
    }

    public final String homePageUrl() {
        return this.homePageUrl;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final String readmeBody() {
        return this.readmeBody;
    }

    public final String readmeUrl() {
        return this.readmeUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.homePageUrl(), other.homePageUrl()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.readmeBody(), other.readmeBody()) && Objects.equals(this.readmeUrl(), other.readmeUrl());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("Description", (Object)this.description()).add("HomePageUrl", (Object)this.homePageUrl()).add("Labels", this.hasLabels() ? this.labels() : null).add("ReadmeBody", (Object)this.readmeBody()).add("ReadmeUrl", (Object)this.readmeUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HomePageUrl": {
                return Optional.ofNullable(clazz.cast(this.homePageUrl()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "ReadmeBody": {
                return Optional.ofNullable(clazz.cast(this.readmeBody()));
            }
            case "ReadmeUrl": {
                return Optional.ofNullable(clazz.cast(this.readmeUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("author", AUTHOR_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("homePageUrl", HOME_PAGE_URL_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("readmeBody", README_BODY_FIELD);
        map.put("readmeUrl", README_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String description;
        private String homePageUrl;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String readmeBody;
        private String readmeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.description(model.description);
            this.homePageUrl(model.homePageUrl);
            this.labels(model.labels);
            this.readmeBody(model.readmeBody);
            this.readmeUrl(model.readmeUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHomePageUrl() {
            return this.homePageUrl;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final String getReadmeBody() {
            return this.readmeBody;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder description(String var1);

        public Builder homePageUrl(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder readmeBody(String var1);

        public Builder readmeUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

