/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RunType {
    CANARY_RUN("CANARY_RUN"),
    DRY_RUN("DRY_RUN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RunType> VALUE_MAP;
    private final String value;

    private RunType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RunType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RunType> knownValues() {
        EnumSet<RunType> knownValues = EnumSet.allOf(RunType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RunType.class, RunType::toString);
    }
}

