/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.EncryptionType;
import software.amazon.awssdk.services.transfer.model.InputFileLocation;
import software.amazon.awssdk.services.transfer.model.OverwriteExisting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecryptStepDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecryptStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DecryptStepDetails.getter(DecryptStepDetails::name)).setter(DecryptStepDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DecryptStepDetails.getter(DecryptStepDetails::typeAsString)).setter(DecryptStepDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SOURCE_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileLocation").getter(DecryptStepDetails.getter(DecryptStepDetails::sourceFileLocation)).setter(DecryptStepDetails.setter(Builder::sourceFileLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileLocation").build()}).build();
    private static final SdkField<String> OVERWRITE_EXISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverwriteExisting").getter(DecryptStepDetails.getter(DecryptStepDetails::overwriteExistingAsString)).setter(DecryptStepDetails.setter(Builder::overwriteExisting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteExisting").build()}).build();
    private static final SdkField<InputFileLocation> DESTINATION_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationFileLocation").getter(DecryptStepDetails.getter(DecryptStepDetails::destinationFileLocation)).setter(DecryptStepDetails.setter(Builder::destinationFileLocation)).constructor(InputFileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFileLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, SOURCE_FILE_LOCATION_FIELD, OVERWRITE_EXISTING_FIELD, DESTINATION_FILE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecryptStepDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String sourceFileLocation;
    private final String overwriteExisting;
    private final InputFileLocation destinationFileLocation;

    private DecryptStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.sourceFileLocation = builder.sourceFileLocation;
        this.overwriteExisting = builder.overwriteExisting;
        this.destinationFileLocation = builder.destinationFileLocation;
    }

    public final String name() {
        return this.name;
    }

    public final EncryptionType type() {
        return EncryptionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String sourceFileLocation() {
        return this.sourceFileLocation;
    }

    public final OverwriteExisting overwriteExisting() {
        return OverwriteExisting.fromValue(this.overwriteExisting);
    }

    public final String overwriteExistingAsString() {
        return this.overwriteExisting;
    }

    public final InputFileLocation destinationFileLocation() {
        return this.destinationFileLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteExistingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationFileLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptStepDetails)) {
            return false;
        }
        DecryptStepDetails other = (DecryptStepDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.sourceFileLocation(), other.sourceFileLocation()) && Objects.equals(this.overwriteExistingAsString(), other.overwriteExistingAsString()) && Objects.equals(this.destinationFileLocation(), other.destinationFileLocation());
    }

    public final String toString() {
        return ToString.builder((String)"DecryptStepDetails").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SourceFileLocation", (Object)this.sourceFileLocation()).add("OverwriteExisting", (Object)this.overwriteExistingAsString()).add("DestinationFileLocation", (Object)this.destinationFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SourceFileLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceFileLocation()));
            }
            case "OverwriteExisting": {
                return Optional.ofNullable(clazz.cast(this.overwriteExistingAsString()));
            }
            case "DestinationFileLocation": {
                return Optional.ofNullable(clazz.cast(this.destinationFileLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SourceFileLocation", SOURCE_FILE_LOCATION_FIELD);
        map.put("OverwriteExisting", OVERWRITE_EXISTING_FIELD);
        map.put("DestinationFileLocation", DESTINATION_FILE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecryptStepDetails, T> g) {
        return obj -> g.apply((DecryptStepDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String sourceFileLocation;
        private String overwriteExisting;
        private InputFileLocation destinationFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptStepDetails model) {
            this.name(model.name);
            this.type(model.type);
            this.sourceFileLocation(model.sourceFileLocation);
            this.overwriteExisting(model.overwriteExisting);
            this.destinationFileLocation(model.destinationFileLocation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSourceFileLocation() {
            return this.sourceFileLocation;
        }

        public final void setSourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
        }

        @Override
        public final Builder sourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
            return this;
        }

        public final String getOverwriteExisting() {
            return this.overwriteExisting;
        }

        public final void setOverwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
        }

        @Override
        public final Builder overwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        @Override
        public final Builder overwriteExisting(OverwriteExisting overwriteExisting) {
            this.overwriteExisting(overwriteExisting == null ? null : overwriteExisting.toString());
            return this;
        }

        public final InputFileLocation.Builder getDestinationFileLocation() {
            return this.destinationFileLocation != null ? this.destinationFileLocation.toBuilder() : null;
        }

        public final void setDestinationFileLocation(InputFileLocation.BuilderImpl destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation != null ? destinationFileLocation.build() : null;
        }

        @Override
        public final Builder destinationFileLocation(InputFileLocation destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation;
            return this;
        }

        public DecryptStepDetails build() {
            return new DecryptStepDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecryptStepDetails> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(EncryptionType var1);

        public Builder sourceFileLocation(String var1);

        public Builder overwriteExisting(String var1);

        public Builder overwriteExisting(OverwriteExisting var1);

        public Builder destinationFileLocation(InputFileLocation var1);

        default public Builder destinationFileLocation(Consumer<InputFileLocation.Builder> destinationFileLocation) {
            return this.destinationFileLocation((InputFileLocation)((InputFileLocation.Builder)InputFileLocation.builder().applyMutation(destinationFileLocation)).build());
        }
    }
}

