/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.ExecutionResults;
import software.amazon.awssdk.services.transfer.model.ExecutionStatus;
import software.amazon.awssdk.services.transfer.model.FileLocation;
import software.amazon.awssdk.services.transfer.model.LoggingConfiguration;
import software.amazon.awssdk.services.transfer.model.PosixProfile;
import software.amazon.awssdk.services.transfer.model.ServiceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedExecution> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(DescribedExecution.getter(DescribedExecution::executionId)).setter(DescribedExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<FileLocation> INITIAL_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialFileLocation").getter(DescribedExecution.getter(DescribedExecution::initialFileLocation)).setter(DescribedExecution.setter(Builder::initialFileLocation)).constructor(FileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialFileLocation").build()}).build();
    private static final SdkField<ServiceMetadata> SERVICE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceMetadata").getter(DescribedExecution.getter(DescribedExecution::serviceMetadata)).setter(DescribedExecution.setter(Builder::serviceMetadata)).constructor(ServiceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceMetadata").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(DescribedExecution.getter(DescribedExecution::executionRole)).setter(DescribedExecution.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(DescribedExecution.getter(DescribedExecution::loggingConfiguration)).setter(DescribedExecution.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<PosixProfile> POSIX_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixProfile").getter(DescribedExecution.getter(DescribedExecution::posixProfile)).setter(DescribedExecution.setter(Builder::posixProfile)).constructor(PosixProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixProfile").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribedExecution.getter(DescribedExecution::statusAsString)).setter(DescribedExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ExecutionResults> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Results").getter(DescribedExecution.getter(DescribedExecution::results)).setter(DescribedExecution.setter(Builder::results)).constructor(ExecutionResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, INITIAL_FILE_LOCATION_FIELD, SERVICE_METADATA_FIELD, EXECUTION_ROLE_FIELD, LOGGING_CONFIGURATION_FIELD, POSIX_PROFILE_FIELD, STATUS_FIELD, RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final FileLocation initialFileLocation;
    private final ServiceMetadata serviceMetadata;
    private final String executionRole;
    private final LoggingConfiguration loggingConfiguration;
    private final PosixProfile posixProfile;
    private final String status;
    private final ExecutionResults results;

    private DescribedExecution(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.initialFileLocation = builder.initialFileLocation;
        this.serviceMetadata = builder.serviceMetadata;
        this.executionRole = builder.executionRole;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.posixProfile = builder.posixProfile;
        this.status = builder.status;
        this.results = builder.results;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final FileLocation initialFileLocation() {
        return this.initialFileLocation;
    }

    public final ServiceMetadata serviceMetadata() {
        return this.serviceMetadata;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final PosixProfile posixProfile() {
        return this.posixProfile;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExecutionResults results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedExecution)) {
            return false;
        }
        DescribedExecution other = (DescribedExecution)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.initialFileLocation(), other.initialFileLocation()) && Objects.equals(this.serviceMetadata(), other.serviceMetadata()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.posixProfile(), other.posixProfile()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedExecution").add("ExecutionId", (Object)this.executionId()).add("InitialFileLocation", (Object)this.initialFileLocation()).add("ServiceMetadata", (Object)this.serviceMetadata()).add("ExecutionRole", (Object)this.executionRole()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("PosixProfile", (Object)this.posixProfile()).add("Status", (Object)this.statusAsString()).add("Results", (Object)this.results()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "InitialFileLocation": {
                return Optional.ofNullable(clazz.cast(this.initialFileLocation()));
            }
            case "ServiceMetadata": {
                return Optional.ofNullable(clazz.cast(this.serviceMetadata()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "PosixProfile": {
                return Optional.ofNullable(clazz.cast(this.posixProfile()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionId", EXECUTION_ID_FIELD);
        map.put("InitialFileLocation", INITIAL_FILE_LOCATION_FIELD);
        map.put("ServiceMetadata", SERVICE_METADATA_FIELD);
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("PosixProfile", POSIX_PROFILE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedExecution, T> g) {
        return obj -> g.apply((DescribedExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private FileLocation initialFileLocation;
        private ServiceMetadata serviceMetadata;
        private String executionRole;
        private LoggingConfiguration loggingConfiguration;
        private PosixProfile posixProfile;
        private String status;
        private ExecutionResults results;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedExecution model) {
            this.executionId(model.executionId);
            this.initialFileLocation(model.initialFileLocation);
            this.serviceMetadata(model.serviceMetadata);
            this.executionRole(model.executionRole);
            this.loggingConfiguration(model.loggingConfiguration);
            this.posixProfile(model.posixProfile);
            this.status(model.status);
            this.results(model.results);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final FileLocation.Builder getInitialFileLocation() {
            return this.initialFileLocation != null ? this.initialFileLocation.toBuilder() : null;
        }

        public final void setInitialFileLocation(FileLocation.BuilderImpl initialFileLocation) {
            this.initialFileLocation = initialFileLocation != null ? initialFileLocation.build() : null;
        }

        @Override
        public final Builder initialFileLocation(FileLocation initialFileLocation) {
            this.initialFileLocation = initialFileLocation;
            return this;
        }

        public final ServiceMetadata.Builder getServiceMetadata() {
            return this.serviceMetadata != null ? this.serviceMetadata.toBuilder() : null;
        }

        public final void setServiceMetadata(ServiceMetadata.BuilderImpl serviceMetadata) {
            this.serviceMetadata = serviceMetadata != null ? serviceMetadata.build() : null;
        }

        @Override
        public final Builder serviceMetadata(ServiceMetadata serviceMetadata) {
            this.serviceMetadata = serviceMetadata;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final PosixProfile.Builder getPosixProfile() {
            return this.posixProfile != null ? this.posixProfile.toBuilder() : null;
        }

        public final void setPosixProfile(PosixProfile.BuilderImpl posixProfile) {
            this.posixProfile = posixProfile != null ? posixProfile.build() : null;
        }

        @Override
        public final Builder posixProfile(PosixProfile posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ExecutionResults.Builder getResults() {
            return this.results != null ? this.results.toBuilder() : null;
        }

        public final void setResults(ExecutionResults.BuilderImpl results) {
            this.results = results != null ? results.build() : null;
        }

        @Override
        public final Builder results(ExecutionResults results) {
            this.results = results;
            return this;
        }

        public DescribedExecution build() {
            return new DescribedExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedExecution> {
        public Builder executionId(String var1);

        public Builder initialFileLocation(FileLocation var1);

        default public Builder initialFileLocation(Consumer<FileLocation.Builder> initialFileLocation) {
            return this.initialFileLocation((FileLocation)((FileLocation.Builder)FileLocation.builder().applyMutation(initialFileLocation)).build());
        }

        public Builder serviceMetadata(ServiceMetadata var1);

        default public Builder serviceMetadata(Consumer<ServiceMetadata.Builder> serviceMetadata) {
            return this.serviceMetadata((ServiceMetadata)((ServiceMetadata.Builder)ServiceMetadata.builder().applyMutation(serviceMetadata)).build());
        }

        public Builder executionRole(String var1);

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder posixProfile(PosixProfile var1);

        default public Builder posixProfile(Consumer<PosixProfile.Builder> posixProfile) {
            return this.posixProfile((PosixProfile)((PosixProfile.Builder)PosixProfile.builder().applyMutation(posixProfile)).build());
        }

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder results(ExecutionResults var1);

        default public Builder results(Consumer<ExecutionResults.Builder> results) {
            return this.results((ExecutionResults)((ExecutionResults.Builder)ExecutionResults.builder().applyMutation(results)).build());
        }
    }
}

