/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.CustomStepStatus;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendWorkflowStepStateRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, SendWorkflowStepStateRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowId").getter(SendWorkflowStepStateRequest.getter(SendWorkflowStepStateRequest::workflowId)).setter(SendWorkflowStepStateRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(SendWorkflowStepStateRequest.getter(SendWorkflowStepStateRequest::executionId)).setter(SendWorkflowStepStateRequest.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(SendWorkflowStepStateRequest.getter(SendWorkflowStepStateRequest::token)).setter(SendWorkflowStepStateRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SendWorkflowStepStateRequest.getter(SendWorkflowStepStateRequest::statusAsString)).setter(SendWorkflowStepStateRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, EXECUTION_ID_FIELD, TOKEN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendWorkflowStepStateRequest.memberNameToFieldInitializer();
    private final String workflowId;
    private final String executionId;
    private final String token;
    private final String status;

    private SendWorkflowStepStateRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.executionId = builder.executionId;
        this.token = builder.token;
        this.status = builder.status;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String token() {
        return this.token;
    }

    public final CustomStepStatus status() {
        return CustomStepStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendWorkflowStepStateRequest)) {
            return false;
        }
        SendWorkflowStepStateRequest other = (SendWorkflowStepStateRequest)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SendWorkflowStepStateRequest").add("WorkflowId", (Object)this.workflowId()).add("ExecutionId", (Object)this.executionId()).add("Token", (Object)this.token()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("ExecutionId", EXECUTION_ID_FIELD);
        map.put("Token", TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendWorkflowStepStateRequest, T> g) {
        return obj -> g.apply((SendWorkflowStepStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String workflowId;
        private String executionId;
        private String token;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SendWorkflowStepStateRequest model) {
            super(model);
            this.workflowId(model.workflowId);
            this.executionId(model.executionId);
            this.token(model.token);
            this.status(model.status);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomStepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendWorkflowStepStateRequest build() {
            return new SendWorkflowStepStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendWorkflowStepStateRequest> {
        public Builder workflowId(String var1);

        public Builder executionId(String var1);

        public Builder token(String var1);

        public Builder status(String var1);

        public Builder status(CustomStepStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

