/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.OrderType;
import software.amazon.awssdk.services.workdocs.model.UserFilterType;
import software.amazon.awssdk.services.workdocs.model.UserSortType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUsersRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeUsersRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(DescribeUsersRequest.getter(DescribeUsersRequest::authenticationToken)).setter(DescribeUsersRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(DescribeUsersRequest.getter(DescribeUsersRequest::organizationId)).setter(DescribeUsersRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationId").build()}).build();
    private static final SdkField<String> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserIds").getter(DescribeUsersRequest.getter(DescribeUsersRequest::userIds)).setter(DescribeUsersRequest.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userIds").build()}).build();
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Query").getter(DescribeUsersRequest.getter(DescribeUsersRequest::query)).setter(DescribeUsersRequest.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("query").build()}).build();
    private static final SdkField<String> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Include").getter(DescribeUsersRequest.getter(DescribeUsersRequest::includeAsString)).setter(DescribeUsersRequest.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("include").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(DescribeUsersRequest.getter(DescribeUsersRequest::orderAsString)).setter(DescribeUsersRequest.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sort").getter(DescribeUsersRequest.getter(DescribeUsersRequest::sortAsString)).setter(DescribeUsersRequest.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sort").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeUsersRequest.getter(DescribeUsersRequest::marker)).setter(DescribeUsersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeUsersRequest.getter(DescribeUsersRequest::limit)).setter(DescribeUsersRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fields").getter(DescribeUsersRequest.getter(DescribeUsersRequest::fields)).setter(DescribeUsersRequest.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fields").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, ORGANIZATION_ID_FIELD, USER_IDS_FIELD, QUERY_FIELD, INCLUDE_FIELD, ORDER_FIELD, SORT_FIELD, MARKER_FIELD, LIMIT_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeUsersRequest.memberNameToFieldInitializer();
    private final String authenticationToken;
    private final String organizationId;
    private final String userIds;
    private final String query;
    private final String include;
    private final String order;
    private final String sort;
    private final String marker;
    private final Integer limit;
    private final String fields;

    private DescribeUsersRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.organizationId = builder.organizationId;
        this.userIds = builder.userIds;
        this.query = builder.query;
        this.include = builder.include;
        this.order = builder.order;
        this.sort = builder.sort;
        this.marker = builder.marker;
        this.limit = builder.limit;
        this.fields = builder.fields;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String userIds() {
        return this.userIds;
    }

    public final String query() {
        return this.query;
    }

    public final UserFilterType include() {
        return UserFilterType.fromValue(this.include);
    }

    public final String includeAsString() {
        return this.include;
    }

    public final OrderType order() {
        return OrderType.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public final UserSortType sort() {
        return UserSortType.fromValue(this.sort);
    }

    public final String sortAsString() {
        return this.sort;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String fields() {
        return this.fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersRequest)) {
            return false;
        }
        DescribeUsersRequest other = (DescribeUsersRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.includeAsString(), other.includeAsString()) && Objects.equals(this.orderAsString(), other.orderAsString()) && Objects.equals(this.sortAsString(), other.sortAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUsersRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("OrganizationId", (Object)this.organizationId()).add("UserIds", (Object)this.userIds()).add("Query", (Object)(this.query() == null ? null : "*** Sensitive Data Redacted ***")).add("Include", (Object)this.includeAsString()).add("Order", (Object)this.orderAsString()).add("Sort", (Object)this.sortAsString()).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).add("Fields", (Object)this.fields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.includeAsString()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sortAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("organizationId", ORGANIZATION_ID_FIELD);
        map.put("userIds", USER_IDS_FIELD);
        map.put("query", QUERY_FIELD);
        map.put("include", INCLUDE_FIELD);
        map.put("order", ORDER_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsersRequest, T> g) {
        return obj -> g.apply((DescribeUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String organizationId;
        private String userIds;
        private String query;
        private String include;
        private String order;
        private String sort;
        private String marker;
        private Integer limit;
        private String fields;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.organizationId(model.organizationId);
            this.userIds(model.userIds);
            this.query(model.query);
            this.include(model.include);
            this.order(model.order);
            this.sort(model.sort);
            this.marker(model.marker);
            this.limit(model.limit);
            this.fields(model.fields);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserIds() {
            return this.userIds;
        }

        public final void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        @Override
        public final Builder userIds(String userIds) {
            this.userIds = userIds;
            return this;
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getInclude() {
            return this.include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(UserFilterType include) {
            this.include(include == null ? null : include.toString());
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final String getSort() {
            return this.sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(UserSortType sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getFields() {
            return this.fields;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUsersRequest build() {
            return new DescribeUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUsersRequest> {
        public Builder authenticationToken(String var1);

        public Builder organizationId(String var1);

        public Builder userIds(String var1);

        public Builder query(String var1);

        public Builder include(String var1);

        public Builder include(UserFilterType var1);

        public Builder order(String var1);

        public Builder order(OrderType var1);

        public Builder sort(String var1);

        public Builder sort(UserSortType var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder fields(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

