/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.UploadMetadata;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateDocumentVersionUploadResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, InitiateDocumentVersionUploadResponse> {
    private static final SdkField<DocumentMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(InitiateDocumentVersionUploadResponse.getter(InitiateDocumentVersionUploadResponse::metadata)).setter(InitiateDocumentVersionUploadResponse.setter(Builder::metadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<UploadMetadata> UPLOAD_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UploadMetadata").getter(InitiateDocumentVersionUploadResponse.getter(InitiateDocumentVersionUploadResponse::uploadMetadata)).setter(InitiateDocumentVersionUploadResponse.setter(Builder::uploadMetadata)).constructor(UploadMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, UPLOAD_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InitiateDocumentVersionUploadResponse.memberNameToFieldInitializer();
    private final DocumentMetadata metadata;
    private final UploadMetadata uploadMetadata;

    private InitiateDocumentVersionUploadResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.uploadMetadata = builder.uploadMetadata;
    }

    public final DocumentMetadata metadata() {
        return this.metadata;
    }

    public final UploadMetadata uploadMetadata() {
        return this.uploadMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateDocumentVersionUploadResponse)) {
            return false;
        }
        InitiateDocumentVersionUploadResponse other = (InitiateDocumentVersionUploadResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.uploadMetadata(), other.uploadMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"InitiateDocumentVersionUploadResponse").add("Metadata", (Object)this.metadata()).add("UploadMetadata", (Object)this.uploadMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "UploadMetadata": {
                return Optional.ofNullable(clazz.cast(this.uploadMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Metadata", METADATA_FIELD);
        map.put("UploadMetadata", UPLOAD_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitiateDocumentVersionUploadResponse, T> g) {
        return obj -> g.apply((InitiateDocumentVersionUploadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata metadata;
        private UploadMetadata uploadMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateDocumentVersionUploadResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.uploadMetadata(model.uploadMetadata);
        }

        public final DocumentMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final UploadMetadata.Builder getUploadMetadata() {
            return this.uploadMetadata != null ? this.uploadMetadata.toBuilder() : null;
        }

        public final void setUploadMetadata(UploadMetadata.BuilderImpl uploadMetadata) {
            this.uploadMetadata = uploadMetadata != null ? uploadMetadata.build() : null;
        }

        @Override
        public final Builder uploadMetadata(UploadMetadata uploadMetadata) {
            this.uploadMetadata = uploadMetadata;
            return this;
        }

        @Override
        public InitiateDocumentVersionUploadResponse build() {
            return new InitiateDocumentVersionUploadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitiateDocumentVersionUploadResponse> {
        public Builder metadata(DocumentMetadata var1);

        default public Builder metadata(Consumer<DocumentMetadata.Builder> metadata) {
            return this.metadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder uploadMetadata(UploadMetadata var1);

        default public Builder uploadMetadata(Consumer<UploadMetadata.Builder> uploadMetadata) {
            return this.uploadMetadata((UploadMetadata)((UploadMetadata.Builder)UploadMetadata.builder().applyMutation(uploadMetadata)).build());
        }
    }
}

