/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.Event;
import software.amazon.awssdk.services.workspacesweb.model.EventsCopier;
import software.amazon.awssdk.services.workspacesweb.model.Unit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventFilter> {
    private static final SdkField<Unit> ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("all").getter(EventFilter.getter(EventFilter::all)).setter(EventFilter.setter(Builder::all)).constructor(Unit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("all").build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("include").getter(EventFilter.getter(EventFilter::includeAsStrings)).setter(EventFilter.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, INCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Unit all;
    private final List<String> include;
    private final Type type;

    private EventFilter(BuilderImpl builder) {
        this.all = builder.all;
        this.include = builder.include;
        this.type = builder.type;
    }

    public final Unit all() {
        return this.all;
    }

    public final List<Event> include() {
        return EventsCopier.copyStringToEnum(this.include);
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public final List<String> includeAsStrings() {
        return this.include;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.all());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.includeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        return Objects.equals(this.all(), other.all()) && this.hasInclude() == other.hasInclude() && Objects.equals(this.includeAsStrings(), other.includeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventFilter").add("All", (Object)this.all()).add("Include", this.hasInclude() ? this.includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "all": {
                return Optional.ofNullable(clazz.cast(this.all()));
            }
            case "include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public static EventFilter fromAll(Unit all) {
        return (EventFilter)EventFilter.builder().all(all).build();
    }

    public static EventFilter fromAll(Consumer<Unit.Builder> all) {
        Unit.Builder builder = Unit.builder();
        all.accept(builder);
        return EventFilter.fromAll((Unit)builder.build());
    }

    public static EventFilter fromIncludeWithStrings(List<String> includeWithStrings) {
        return (EventFilter)EventFilter.builder().includeWithStrings(includeWithStrings).build();
    }

    public static EventFilter fromInclude(List<Event> includeWithStrings) {
        return (EventFilter)EventFilter.builder().include(includeWithStrings).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("all", ALL_FIELD);
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ALL,
        INCLUDE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Unit all;
        private List<String> include = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            this.all(model.all);
            this.includeWithStrings(model.include);
        }

        public final Unit.Builder getAll() {
            return this.all != null ? this.all.toBuilder() : null;
        }

        public final void setAll(Unit.BuilderImpl all) {
            Unit oldValue = this.all;
            this.all = all != null ? all.build() : null;
            this.handleUnionValueChange(Type.ALL, oldValue, this.all);
        }

        @Override
        public final Builder all(Unit all) {
            Unit oldValue = this.all;
            this.all = all;
            this.handleUnionValueChange(Type.ALL, oldValue, this.all);
            return this;
        }

        public final Collection<String> getInclude() {
            if (this.include instanceof SdkAutoConstructList) {
                return null;
            }
            return this.include;
        }

        public final void setInclude(Collection<String> include) {
            List<String> oldValue = this.include;
            this.include = EventsCopier.copy(include);
            this.handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            List<String> oldValue = this.include;
            this.include = EventsCopier.copy(include);
            this.handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String ... include) {
            this.includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<Event> include) {
            List<String> oldValue = this.include;
            this.include = EventsCopier.copyEnumToString(include);
            this.handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(Event ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        public EventFilter build() {
            return new EventFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventFilter> {
        public Builder all(Unit var1);

        default public Builder all(Consumer<Unit.Builder> all) {
            return this.all((Unit)((Unit.Builder)Unit.builder().applyMutation(all)).build());
        }

        public Builder includeWithStrings(Collection<String> var1);

        public Builder includeWithStrings(String ... var1);

        public Builder include(Collection<Event> var1);

        public Builder include(Event ... var1);
    }
}

