/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Edge;
import software.amazon.awssdk.services.xray.model.EdgeListCopier;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReferenceId").getter(Service.getter(Service::referenceId)).setter(Service.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Service.getter(Service::name)).setter(Service.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(Service.getter(Service::names)).setter(Service.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Root").getter(Service.getter(Service::root)).setter(Service.setter(Builder::root)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Root").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Service.getter(Service::accountId)).setter(Service.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Service.getter(Service::type)).setter(Service.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Service.getter(Service::state)).setter(Service.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Service.getter(Service::startTime)).setter(Service.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Service.getter(Service::endTime)).setter(Service.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Edges").getter(Service.getter(Service::edges)).setter(Service.setter(Builder::edges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Edge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceStatistics> SUMMARY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SummaryStatistics").getter(Service.getter(Service::summaryStatistics)).setter(Service.setter(Builder::summaryStatistics)).constructor(ServiceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryStatistics").build()}).build();
    private static final SdkField<List<HistogramEntry>> DURATION_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DurationHistogram").getter(Service.getter(Service::durationHistogram)).setter(Service.setter(Builder::durationHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseTimeHistogram").getter(Service.getter(Service::responseTimeHistogram)).setter(Service.setter(Builder::responseTimeHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, NAME_FIELD, NAMES_FIELD, ROOT_FIELD, ACCOUNT_ID_FIELD, TYPE_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD, EDGES_FIELD, SUMMARY_STATISTICS_FIELD, DURATION_HISTOGRAM_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Service.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer referenceId;
    private final String name;
    private final List<String> names;
    private final Boolean root;
    private final String accountId;
    private final String type;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Edge> edges;
    private final ServiceStatistics summaryStatistics;
    private final List<HistogramEntry> durationHistogram;
    private final List<HistogramEntry> responseTimeHistogram;

    private Service(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.name = builder.name;
        this.names = builder.names;
        this.root = builder.root;
        this.accountId = builder.accountId;
        this.type = builder.type;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.edges = builder.edges;
        this.summaryStatistics = builder.summaryStatistics;
        this.durationHistogram = builder.durationHistogram;
        this.responseTimeHistogram = builder.responseTimeHistogram;
    }

    public final Integer referenceId() {
        return this.referenceId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final Boolean root() {
        return this.root;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String type() {
        return this.type;
    }

    public final String state() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasEdges() {
        return this.edges != null && !(this.edges instanceof SdkAutoConstructList);
    }

    public final List<Edge> edges() {
        return this.edges;
    }

    public final ServiceStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public final boolean hasDurationHistogram() {
        return this.durationHistogram != null && !(this.durationHistogram instanceof SdkAutoConstructList);
    }

    public final List<HistogramEntry> durationHistogram() {
        return this.durationHistogram;
    }

    public final boolean hasResponseTimeHistogram() {
        return this.responseTimeHistogram != null && !(this.responseTimeHistogram instanceof SdkAutoConstructList);
    }

    public final List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.root());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdges() ? this.edges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDurationHistogram() ? this.durationHistogram() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.name(), other.name()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.root(), other.root()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasEdges() == other.hasEdges() && Objects.equals(this.edges(), other.edges()) && Objects.equals(this.summaryStatistics(), other.summaryStatistics()) && this.hasDurationHistogram() == other.hasDurationHistogram() && Objects.equals(this.durationHistogram(), other.durationHistogram()) && this.hasResponseTimeHistogram() == other.hasResponseTimeHistogram() && Objects.equals(this.responseTimeHistogram(), other.responseTimeHistogram());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("ReferenceId", (Object)this.referenceId()).add("Name", (Object)this.name()).add("Names", this.hasNames() ? this.names() : null).add("Root", (Object)this.root()).add("AccountId", (Object)this.accountId()).add("Type", (Object)this.type()).add("State", (Object)this.state()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Edges", this.hasEdges() ? this.edges() : null).add("SummaryStatistics", (Object)this.summaryStatistics()).add("DurationHistogram", this.hasDurationHistogram() ? this.durationHistogram() : null).add("ResponseTimeHistogram", this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Root": {
                return Optional.ofNullable(clazz.cast(this.root()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Edges": {
                return Optional.ofNullable(clazz.cast(this.edges()));
            }
            case "SummaryStatistics": {
                return Optional.ofNullable(clazz.cast(this.summaryStatistics()));
            }
            case "DurationHistogram": {
                return Optional.ofNullable(clazz.cast(this.durationHistogram()));
            }
            case "ResponseTimeHistogram": {
                return Optional.ofNullable(clazz.cast(this.responseTimeHistogram()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Root", ROOT_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Edges", EDGES_FIELD);
        map.put("SummaryStatistics", SUMMARY_STATISTICS_FIELD);
        map.put("DurationHistogram", DURATION_HISTOGRAM_FIELD);
        map.put("ResponseTimeHistogram", RESPONSE_TIME_HISTOGRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private String name;
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private Boolean root;
        private String accountId;
        private String type;
        private String state;
        private Instant startTime;
        private Instant endTime;
        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();
        private ServiceStatistics summaryStatistics;
        private List<HistogramEntry> durationHistogram = DefaultSdkAutoConstructList.getInstance();
        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.referenceId(model.referenceId);
            this.name(model.name);
            this.names(model.names);
            this.root(model.root);
            this.accountId(model.accountId);
            this.type(model.type);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.edges(model.edges);
            this.summaryStatistics(model.summaryStatistics);
            this.durationHistogram(model.durationHistogram);
            this.responseTimeHistogram(model.responseTimeHistogram);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final Boolean getRoot() {
            return this.root;
        }

        public final void setRoot(Boolean root) {
            this.root = root;
        }

        @Override
        public final Builder root(Boolean root) {
            this.root = root;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder> ... edges) {
            this.edges(Stream.of(edges).map(c -> (Edge)((Edge.Builder)Edge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServiceStatistics.Builder getSummaryStatistics() {
            return this.summaryStatistics != null ? this.summaryStatistics.toBuilder() : null;
        }

        public final void setSummaryStatistics(ServiceStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        @Override
        public final Builder summaryStatistics(ServiceStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final List<HistogramEntry.Builder> getDurationHistogram() {
            List<HistogramEntry.Builder> result = HistogramCopier.copyToBuilder(this.durationHistogram);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDurationHistogram(Collection<HistogramEntry.BuilderImpl> durationHistogram) {
            this.durationHistogram = HistogramCopier.copyFromBuilder(durationHistogram);
        }

        @Override
        public final Builder durationHistogram(Collection<HistogramEntry> durationHistogram) {
            this.durationHistogram = HistogramCopier.copy(durationHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durationHistogram(HistogramEntry ... durationHistogram) {
            this.durationHistogram(Arrays.asList(durationHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durationHistogram(Consumer<HistogramEntry.Builder> ... durationHistogram) {
            this.durationHistogram(Stream.of(durationHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HistogramEntry.Builder> getResponseTimeHistogram() {
            List<HistogramEntry.Builder> result = HistogramCopier.copyToBuilder(this.responseTimeHistogram);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... responseTimeHistogram) {
            this.responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder referenceId(Integer var1);

        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder root(Boolean var1);

        public Builder accountId(String var1);

        public Builder type(String var1);

        public Builder state(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder edges(Collection<Edge> var1);

        public Builder edges(Edge ... var1);

        public Builder edges(Consumer<Edge.Builder> ... var1);

        public Builder summaryStatistics(ServiceStatistics var1);

        default public Builder summaryStatistics(Consumer<ServiceStatistics.Builder> summaryStatistics) {
            return this.summaryStatistics((ServiceStatistics)((ServiceStatistics.Builder)ServiceStatistics.builder().applyMutation(summaryStatistics)).build());
        }

        public Builder durationHistogram(Collection<HistogramEntry> var1);

        public Builder durationHistogram(HistogramEntry ... var1);

        public Builder durationHistogram(Consumer<HistogramEntry.Builder> ... var1);

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... var1);
    }
}

