/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetInsightEventsRequest;
import software.amazon.awssdk.services.xray.model.GetInsightEventsResponse;

public class GetInsightEventsIterable
implements SdkIterable<GetInsightEventsResponse> {
    private final XRayClient client;
    private final GetInsightEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInsightEventsIterable(XRayClient client, GetInsightEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetInsightEventsResponseFetcher();
    }

    public Iterator<GetInsightEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetInsightEventsResponseFetcher
    implements SyncPageFetcher<GetInsightEventsResponse> {
        private GetInsightEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInsightEventsResponse nextPage(GetInsightEventsResponse previousPage) {
            if (previousPage == null) {
                return GetInsightEventsIterable.this.client.getInsightEvents(GetInsightEventsIterable.this.firstRequest);
            }
            return GetInsightEventsIterable.this.client.getInsightEvents((GetInsightEventsRequest)((Object)GetInsightEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

