/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.channel;

import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelInboundHandlerAdapter;
import com.suning.api.link.io.netty.util.ReferenceCountUtil;
import com.suning.api.link.io.netty.util.internal.TypeParameterMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    protected SimpleChannelInboundHandler() {
        this(true);
    }

    protected SimpleChannelInboundHandler(boolean autoRelease) {
        this.matcher = TypeParameterMatcher.find(this, SimpleChannelInboundHandler.class, "I");
        this.autoRelease = autoRelease;
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType) {
        this(inboundMessageType, true);
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType, boolean autoRelease) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
        this.autoRelease = autoRelease;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            if (this.acceptInboundMessage(msg)) {
                Object imsg = msg;
                this.channelRead0(ctx, imsg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
            Object var6_5 = null;
            if (!this.autoRelease || !release) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!this.autoRelease || !release) throw throwable;
            ReferenceCountUtil.release(msg);
            throw throwable;
        }
        ReferenceCountUtil.release(msg);
    }

    protected abstract void channelRead0(ChannelHandlerContext var1, I var2) throws Exception;
}

