/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.channel;

import com.suning.api.link.io.netty.channel.Channel;
import com.suning.api.link.io.netty.channel.ChannelFuture;
import com.suning.api.link.io.netty.channel.ChannelFutureListener;
import com.suning.api.link.io.netty.channel.ChannelPromise;
import com.suning.api.link.io.netty.channel.SingleThreadEventLoop;
import com.suning.api.link.io.netty.channel.ThreadPerChannelEventLoopGroup;

public class ThreadPerChannelEventLoop
extends SingleThreadEventLoop {
    private final ThreadPerChannelEventLoopGroup parent;
    private Channel ch;

    public ThreadPerChannelEventLoop(ThreadPerChannelEventLoopGroup parent) {
        super(parent, parent.threadFactory, true);
        this.parent = parent;
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return super.register(channel, promise).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ThreadPerChannelEventLoop.this.ch = future.channel();
                } else {
                    ThreadPerChannelEventLoop.this.deregister();
                }
            }
        });
    }

    protected void run() {
        while (true) {
            Runnable task;
            if ((task = this.takeTask()) != null) {
                task.run();
                this.updateLastExecutionTime();
            }
            Channel ch = this.ch;
            if (this.isShuttingDown()) {
                if (ch != null) {
                    ch.unsafe().close(ch.unsafe().voidPromise());
                }
                if (!this.confirmShutdown()) continue;
                break;
            }
            if (ch == null || ch.isRegistered()) continue;
            this.runAllTasks();
            this.deregister();
        }
    }

    protected void deregister() {
        this.ch = null;
        this.parent.activeChildren.remove(this);
        this.parent.idleChildren.add(this);
    }
}

