/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec;

import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.buffer.Unpooled;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelInboundHandlerAdapter;
import com.suning.api.link.io.netty.handler.codec.CodecUtil;
import com.suning.api.link.io.netty.handler.codec.DecoderException;
import com.suning.api.link.io.netty.util.internal.RecyclableArrayList;
import com.suning.api.link.io.netty.util.internal.StringUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    ByteBuf cumulation;
    private boolean singleDecode;
    private boolean decodeWasNull;
    private boolean first;

    protected ByteToMessageDecoder() {
        CodecUtil.ensureNotSharable(this);
    }

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ByteBuf buf = this.internalBuffer();
        int readable = buf.readableBytes();
        if (buf.isReadable()) {
            ByteBuf bytes = buf.readBytes(readable);
            buf.release();
            ctx.fireChannelRead(bytes);
        } else {
            buf.release();
        }
        this.cumulation = null;
        ctx.fireChannelReadComplete();
        this.handlerRemoved0(ctx);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int size2222;
        RecyclableArrayList out;
        block14: {
            if (!(msg instanceof ByteBuf)) {
                ctx.fireChannelRead(msg);
                return;
            }
            out = RecyclableArrayList.newInstance();
            try {
                try {
                    ByteBuf data = (ByteBuf)msg;
                    boolean bl = this.first = this.cumulation == null;
                    if (this.first) {
                        this.cumulation = data;
                    } else {
                        if (this.cumulation.writerIndex() > this.cumulation.maxCapacity() - data.readableBytes() || this.cumulation.refCnt() > 1) {
                            this.expandCumulation(ctx, data.readableBytes());
                        }
                        this.cumulation.writeBytes(data);
                        data.release();
                    }
                    this.callDecode(ctx, this.cumulation, out);
                }
                catch (DecoderException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new DecoderException(t);
                }
                Object var6_7 = null;
                if (this.cumulation == null || this.cumulation.isReadable()) break block14;
            }
            catch (Throwable throwable) {
                int size2222;
                Object var6_8 = null;
                if (this.cumulation != null && !this.cumulation.isReadable()) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                this.decodeWasNull = (size2222 = out.size()) == 0;
                int i = 0;
                while (true) {
                    if (i >= size2222) {
                        out.recycle();
                        throw throwable;
                    }
                    ctx.fireChannelRead(out.get(i));
                    ++i;
                }
            }
            this.cumulation.release();
            this.cumulation = null;
        }
        this.decodeWasNull = (size2222 = out.size()) == 0;
        for (int i = 0; i < size2222; ++i) {
            ctx.fireChannelRead(out.get(i));
        }
        out.recycle();
    }

    private void expandCumulation(ChannelHandlerContext ctx, int readable) {
        ByteBuf oldCumulation = this.cumulation;
        this.cumulation = ctx.alloc().buffer(oldCumulation.readableBytes() + readable);
        this.cumulation.writeBytes(oldCumulation);
        oldCumulation.release();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        ctx.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object v0;
        RecyclableArrayList out;
        block16: {
            block15: {
                out = RecyclableArrayList.newInstance();
                if (this.cumulation != null) {
                    this.callDecode(ctx, this.cumulation, out);
                    this.decodeLast(ctx, this.cumulation, out);
                    break block15;
                }
                this.decodeLast(ctx, Unpooled.EMPTY_BUFFER, out);
            }
            Object var5_3 = null;
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int size = out.size();
                for (int i = 0; i < size; ++i) {
                    ctx.fireChannelRead(out.get(i));
                }
                if (size > 0) {
                    ctx.fireChannelReadComplete();
                }
                ctx.fireChannelInactive();
                v0 = null;
                break block16;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block16;
                catch (DecoderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DecoderException(e);
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var5_4 = null;
                try {
                    if (this.cumulation != null) {
                        this.cumulation.release();
                        this.cumulation = null;
                    }
                    int size = out.size();
                    for (int i = 0; i < size; ++i) {
                        ctx.fireChannelRead(out.get(i));
                    }
                    if (size > 0) {
                        ctx.fireChannelReadComplete();
                    }
                    ctx.fireChannelInactive();
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var9_12 = v1;
                out.recycle();
                throw throwable;
            }
        }
        Object var9_11 = v0;
        out.recycle();
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        try {
            while (in.isReadable()) {
                int outSize = out.size();
                int oldInputLength = in.readableBytes();
                this.decode(ctx, in, out);
                if (!ctx.isRemoved()) {
                    if (outSize == out.size()) {
                        if (oldInputLength != in.readableBytes()) continue;
                    } else {
                        if (oldInputLength == in.readableBytes()) {
                            throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                        }
                        if (!this.isSingleDecode()) continue;
                    }
                }
                break;
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }
}

