/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec;

import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.handler.codec.ByteToMessageDecoder;
import com.suning.api.link.io.netty.handler.codec.DecoderException;
import com.suning.api.link.io.netty.handler.codec.ReplayingDecoderBuffer;
import com.suning.api.link.io.netty.util.Signal;
import com.suning.api.link.io.netty.util.internal.RecyclableArrayList;
import com.suning.api.link.io.netty.util.internal.StringUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = Signal.valueOf(ReplayingDecoder.class.getName() + ".REPLAY");
    private final ReplayingDecoderBuffer replayable = new ReplayingDecoderBuffer();
    private S state;
    private int checkpoint = -1;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(S initialState) {
        this.state = initialState;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S state) {
        this.checkpoint();
        this.state(state);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S newState) {
        S oldState = this.state;
        this.state = newState;
        return oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block19: {
            RecyclableArrayList out = RecyclableArrayList.newInstance();
            this.replayable.terminate();
            this.callDecode(ctx, this.internalBuffer(), out);
            this.decodeLast(ctx, this.replayable, out);
            Object var5_3 = null;
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int size = out.size();
                for (int i = 0; i < size; ++i) {
                    ctx.fireChannelRead(out.get(i));
                }
                if (size > 0) {
                    ctx.fireChannelReadComplete();
                }
                ctx.fireChannelInactive();
                Object var9_12 = null;
                out.recycle();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                out.recycle();
                throw throwable;
            }
            {
                break block19;
            }
            {
                catch (Signal replay) {
                    replay.expect(REPLAY);
                    Object var5_4 = null;
                    try {
                        if (this.cumulation != null) {
                            this.cumulation.release();
                            this.cumulation = null;
                        }
                        int size = out.size();
                        for (int i = 0; i < size; ++i) {
                            ctx.fireChannelRead(out.get(i));
                        }
                        if (size > 0) {
                            ctx.fireChannelReadComplete();
                        }
                        ctx.fireChannelInactive();
                        Object var9_14 = null;
                        out.recycle();
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        out.recycle();
                        throw throwable;
                    }
                    {
                        break block19;
                    }
                }
                catch (DecoderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DecoderException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (this.cumulation != null) {
                        this.cumulation.release();
                        this.cumulation = null;
                    }
                    int size = out.size();
                    for (int i = 0; i < size; ++i) {
                        ctx.fireChannelRead(out.get(i));
                    }
                    if (size > 0) {
                        ctx.fireChannelReadComplete();
                    }
                    ctx.fireChannelInactive();
                    Object var9_16 = null;
                    out.recycle();
                }
                catch (Throwable throwable2) {
                    Object var9_17 = null;
                    out.recycle();
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        this.replayable.setCumulation(in);
        try {
            while (in.isReadable()) {
                int oldReaderIndex = this.checkpoint = in.readerIndex();
                int outSize = out.size();
                S oldState = this.state;
                int oldInputLength = in.readableBytes();
                try {
                    this.decode(ctx, this.replayable, out);
                    if (ctx.isRemoved()) {
                        return;
                    }
                    if (outSize == out.size()) {
                        if (oldInputLength != in.readableBytes() || oldState != this.state) continue;
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() must consume the inbound " + "data or change its state if it did not decode anything.");
                    }
                }
                catch (Signal replay) {
                    replay.expect(REPLAY);
                    if (ctx.isRemoved()) {
                        return;
                    }
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) return;
                    in.readerIndex(checkpoint);
                    return;
                }
                if (oldReaderIndex == in.readerIndex() && oldState == this.state) {
                    throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() method must consume the inbound data " + "or change its state if it decoded something.");
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
    }
}

