/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec.serialization;

import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.buffer.ByteBufOutputStream;
import com.suning.api.link.io.netty.channel.ChannelHandler;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.handler.codec.MessageToByteEncoder;
import com.suning.api.link.io.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(msg);
        oout.flush();
        oout.close();
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

