/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.douyin.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.douyin.constant.DouyinGiftCountCalculationTimeEnum;
import tech.ordinaryroad.live.chat.client.codec.douyin.constant.DouyinRoomStatusEnum;
import tech.ordinaryroad.live.chat.client.codec.douyin.msg.DouyinGiftMsg;
import tech.ordinaryroad.live.chat.client.codec.douyin.protobuf.GiftMessage;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatHttpUtil;

public class DouyinApis {
    private static final Logger log = LoggerFactory.getLogger(DouyinApis.class);
    public static final String KEY_COOKIE_TTWID = "ttwid";
    public static final String KEY_COOKIE_MS_TOKEN = "msToken";
    public static final String KEY_COOKIE_AC_NONCE = "__ac_nonce";
    public static final String MS_TOKEN_BASE_STRING = "abcdefghijklmnopqrstuvwxyz0123456789=_";
    public static final int MS_TOKEN_LENGTH = 116;
    public static final int AC_NONCE_LENGTH = 21;
    public static final String PATTERN_USER_UNIQUE_ID = "\\\\\"user_unique_id\\\\\":\\\\\"(\\d+)\\\\\"";
    public static final String PATTERN_ROOM_ID = "\\\\\"roomId\\\\\":\\\\\"(\\d+)\\\\\"";
    public static final String PATTERN_ROOM_STATUS = "\\\\\"status_str\\\\\":\\\\\"(\\d+)\\\\\"";
    private static final TimedCache<String, GiftMessage> DOUYIN_GIFT_MSG_CACHE = new TimedCache(300000L, new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomInitResult roomInit(Object roomId, String cookie, RoomInitResult roomInitResult) {
        Map cookieMap = OrLiveChatCookieUtil.parseCookieString((String)cookie);
        HttpResponse response1 = OrLiveChatHttpUtil.createGet((String)"https://live.douyin.com/").cookie(cookie).execute();
        try {
            RoomInitResult roomInitResult2;
            block13: {
                String ttwid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_TTWID, () -> response1.getCookie(KEY_COOKIE_TTWID).getValue());
                String msToken = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_MS_TOKEN, () -> RandomUtil.randomString((String)MS_TOKEN_BASE_STRING, (int)116));
                String __ac_nonce = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)KEY_COOKIE_AC_NONCE, () -> RandomUtil.randomString((int)21));
                HttpResponse response2 = OrLiveChatHttpUtil.createGet((String)("https://live.douyin.com/" + roomId)).cookie(StrUtil.emptyToDefault((CharSequence)cookie, (String)("ttwid=" + ttwid + "; " + KEY_COOKIE_MS_TOKEN + "=" + msToken + "; " + KEY_COOKIE_AC_NONCE + "=" + __ac_nonce))).execute();
                try {
                    int roomStatus;
                    long realRoomId;
                    if (response2.getStatus() != 200) {
                        throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
                    }
                    String body2 = response2.body();
                    String user_unique_id = StrUtil.emptyToDefault((CharSequence)ReUtil.getGroup1((String)PATTERN_USER_UNIQUE_ID, (CharSequence)body2), (String)String.valueOf(RandomUtil.randomLong((long)7300000000000000000L, (long)7999999999999999999L)));
                    String realRoomIdString = ReUtil.getGroup1((String)PATTERN_ROOM_ID, (CharSequence)body2);
                    try {
                        realRoomId = NumberUtil.parseLong((String)realRoomIdString);
                    }
                    catch (Exception e) {
                        throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
                    }
                    String roomStatusString = ReUtil.getGroup1((String)PATTERN_ROOM_STATUS, (CharSequence)body2);
                    try {
                        roomStatus = NumberUtil.parseInt((String)roomStatusString);
                    }
                    catch (Exception e) {
                        throw new BaseException("\u83b7\u53d6" + roomId + "\u76f4\u64ad\u95f4\u72b6\u6001\u5931\u8d25");
                    }
                    roomInitResult = Optional.ofNullable(roomInitResult).orElseGet(() -> RoomInitResult.builder().build());
                    roomInitResult.setTtwid(ttwid);
                    roomInitResult.setMsToken(msToken);
                    roomInitResult.setAcNonce(__ac_nonce);
                    roomInitResult.setRealRoomId(realRoomId);
                    roomInitResult.setUserUniqueId(user_unique_id);
                    roomInitResult.setRoomStatus(DouyinRoomStatusEnum.getByCode(roomStatus));
                    roomInitResult2 = roomInitResult;
                    if (Collections.singletonList(response2).get(0) == null) break block13;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(response2).get(0) != null) {
                        response2.close();
                    }
                    throw throwable;
                }
                response2.close();
            }
            return roomInitResult2;
        }
        finally {
            if (Collections.singletonList(response1).get(0) != null) {
                response1.close();
            }
        }
    }

    public static RoomInitResult roomInit(Object roomId, String cookie) {
        return DouyinApis.roomInit(roomId, cookie, null);
    }

    public static RoomInitResult roomInit(Object roomId) {
        return DouyinApis.roomInit(roomId, null, null);
    }

    public static RoomInitResult roomInit(Object roomId, RoomInitResult roomInitResult) {
        return DouyinApis.roomInit(roomId, null, roomInitResult);
    }

    public static int calculateGiftCount(DouyinGiftMsg msg, DouyinGiftCountCalculationTimeEnum calculationTimeEnum) {
        if (msg == null || msg.getMsg() == null) {
            return 0;
        }
        GiftMessage giftMessage = msg.getMsg();
        long giftCount = 0L;
        if (calculationTimeEnum == DouyinGiftCountCalculationTimeEnum.COMBO_END) {
            if (!giftMessage.getGift().getCombo() || giftMessage.getRepeatEnd() == 1) {
                long comboCount = giftMessage.getComboCount();
                if (giftMessage.getGroupCount() != 1L) {
                    comboCount = giftMessage.getGroupCount() * comboCount;
                }
                giftCount = comboCount;
            }
        } else {
            long groupId = giftMessage.getGroupId();
            long giftId = giftMessage.getGiftId();
            String key = groupId + "-" + msg.getUid() + "-" + giftId;
            if (DOUYIN_GIFT_MSG_CACHE.containsKey((Object)key)) {
                GiftMessage giftMessageByGroupId = (GiftMessage)DOUYIN_GIFT_MSG_CACHE.get((Object)key);
                long repeatCountByGroupId = giftMessageByGroupId.getRepeatCount();
                giftCount = giftMessage.getRepeatCount() - repeatCountByGroupId;
            } else {
                giftCount = giftMessage.getRepeatCount();
            }
            if (giftCount > 0L) {
                DOUYIN_GIFT_MSG_CACHE.put((Object)key, (Object)giftMessage);
            }
        }
        msg.setCalculatedGiftCount((int)giftCount);
        return (int)giftCount;
    }

    public static class RoomInitResult {
        private String ttwid;
        private String msToken;
        private String acNonce;
        private long realRoomId;
        private String userUniqueId;
        private DouyinRoomStatusEnum roomStatus;

        public static RoomInitResultBuilder builder() {
            return new RoomInitResultBuilder();
        }

        public String getTtwid() {
            return this.ttwid;
        }

        public String getMsToken() {
            return this.msToken;
        }

        public String getAcNonce() {
            return this.acNonce;
        }

        public long getRealRoomId() {
            return this.realRoomId;
        }

        public String getUserUniqueId() {
            return this.userUniqueId;
        }

        public DouyinRoomStatusEnum getRoomStatus() {
            return this.roomStatus;
        }

        public void setTtwid(String ttwid) {
            this.ttwid = ttwid;
        }

        public void setMsToken(String msToken) {
            this.msToken = msToken;
        }

        public void setAcNonce(String acNonce) {
            this.acNonce = acNonce;
        }

        public void setRealRoomId(long realRoomId) {
            this.realRoomId = realRoomId;
        }

        public void setUserUniqueId(String userUniqueId) {
            this.userUniqueId = userUniqueId;
        }

        public void setRoomStatus(DouyinRoomStatusEnum roomStatus) {
            this.roomStatus = roomStatus;
        }

        public RoomInitResult(String ttwid, String msToken, String acNonce, long realRoomId, String userUniqueId, DouyinRoomStatusEnum roomStatus) {
            this.ttwid = ttwid;
            this.msToken = msToken;
            this.acNonce = acNonce;
            this.realRoomId = realRoomId;
            this.userUniqueId = userUniqueId;
            this.roomStatus = roomStatus;
        }

        public RoomInitResult() {
        }

        public static class RoomInitResultBuilder {
            private String ttwid;
            private String msToken;
            private String acNonce;
            private long realRoomId;
            private String userUniqueId;
            private DouyinRoomStatusEnum roomStatus;

            RoomInitResultBuilder() {
            }

            public RoomInitResultBuilder ttwid(String ttwid) {
                this.ttwid = ttwid;
                return this;
            }

            public RoomInitResultBuilder msToken(String msToken) {
                this.msToken = msToken;
                return this;
            }

            public RoomInitResultBuilder acNonce(String acNonce) {
                this.acNonce = acNonce;
                return this;
            }

            public RoomInitResultBuilder realRoomId(long realRoomId) {
                this.realRoomId = realRoomId;
                return this;
            }

            public RoomInitResultBuilder userUniqueId(String userUniqueId) {
                this.userUniqueId = userUniqueId;
                return this;
            }

            public RoomInitResultBuilder roomStatus(DouyinRoomStatusEnum roomStatus) {
                this.roomStatus = roomStatus;
                return this;
            }

            public RoomInitResult build() {
                return new RoomInitResult(this.ttwid, this.msToken, this.acNonce, this.realRoomId, this.userUniqueId, this.roomStatus);
            }

            public String toString() {
                return "DouyinApis.RoomInitResult.RoomInitResultBuilder(ttwid=" + this.ttwid + ", msToken=" + this.msToken + ", acNonce=" + this.acNonce + ", realRoomId=" + this.realRoomId + ", userUniqueId=" + this.userUniqueId + ", roomStatus=" + (Object)((Object)this.roomStatus) + ")";
            }
        }
    }
}

