/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.huya.msg;

import cn.hutool.core.collection.CollUtil;
import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.TarsStructBase;
import java.util.List;
import java.util.Optional;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaOperationEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.base.BaseHuyaMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.BadgeInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.BulletFormat;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.ContentFormat;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.DecorationInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.MessageContentExpand;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.MessageTagInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.SendMessageFormat;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.SenderInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.UidNickName;
import tech.ordinaryroad.live.chat.client.codec.huya.util.HuyaCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IDanmuMsg;

public class MessageNoticeMsg
extends BaseHuyaMsg
implements IDanmuMsg {
    private SenderInfo tUserInfo = new SenderInfo();
    private long lTid;
    private long lSid;
    private String sContent = "";
    private int iShowMode;
    private ContentFormat tFormat = new ContentFormat();
    private BulletFormat tBulletFormat = new BulletFormat();
    private int iTermType;
    private List<DecorationInfo> vDecorationPrefix = CollUtil.newArrayList((Object[])new DecorationInfo[]{new DecorationInfo()});
    private List<DecorationInfo> vDecorationSuffix = CollUtil.newArrayList((Object[])new DecorationInfo[]{new DecorationInfo()});
    private List<UidNickName> vAtSomeone = CollUtil.newArrayList((Object[])new UidNickName[]{new UidNickName()});
    private long lPid;
    private List<DecorationInfo> vBulletPrefix = CollUtil.newArrayList((Object[])new DecorationInfo[]{new DecorationInfo()});
    private String sIconUrl = "";
    private int iType;
    private List<DecorationInfo> vBulletSuffix = CollUtil.newArrayList((Object[])new DecorationInfo[]{new DecorationInfo()});
    private List<MessageTagInfo> vTagInfo = CollUtil.newArrayList((Object[])new MessageTagInfo[]{new MessageTagInfo()});
    private SendMessageFormat tSenceFormat = new SendMessageFormat();
    private MessageContentExpand tContentExpand = new MessageContentExpand();
    private int iMessageMode;
    private BadgeInfo badgeInfo;

    public MessageNoticeMsg(TarsInputStream is) {
        this.readFrom(is);
    }

    public void writeTo(TarsOutputStream os) {
        os.write((TarsStructBase)this.tUserInfo, 0);
        os.write(this.lTid, 1);
        os.write(this.lSid, 2);
        os.write(this.sContent, 3);
        os.write(this.iShowMode, 4);
        os.write((TarsStructBase)this.tFormat, 5);
        os.write((TarsStructBase)this.tBulletFormat, 6);
        os.write(this.iTermType, 7);
        os.write(this.vDecorationPrefix, 8);
        os.write(this.vDecorationSuffix, 9);
        os.write(this.vAtSomeone, 10);
        os.write(this.lPid, 11);
        os.write(this.vBulletPrefix, 12);
        os.write(this.sIconUrl, 13);
        os.write(this.iType, 14);
        os.write(this.vBulletSuffix, 15);
        os.write(this.vTagInfo, 16);
        os.write((TarsStructBase)this.tSenceFormat, 17);
        os.write((TarsStructBase)this.tContentExpand, 18);
        os.write(this.iMessageMode, 19);
    }

    public void readFrom(TarsInputStream is) {
        this.tUserInfo = (SenderInfo)is.directRead((TarsStructBase)this.tUserInfo, 0, false);
        this.lTid = is.read(this.lTid, 1, false);
        this.lSid = is.read(this.lSid, 2, false);
        this.sContent = is.readString(3, false);
        this.iShowMode = is.read(this.iShowMode, 4, false);
        this.tFormat = (ContentFormat)is.directRead((TarsStructBase)this.tFormat, 5, false);
        this.tBulletFormat = (BulletFormat)is.directRead((TarsStructBase)this.tBulletFormat, 6, false);
        this.iTermType = is.read(this.iTermType, 7, false);
        this.vDecorationPrefix = is.readArray(this.vDecorationPrefix, 8, false);
        this.vDecorationSuffix = is.readArray(this.vDecorationSuffix, 9, false);
        this.vAtSomeone = is.readArray(this.vAtSomeone, 10, false);
        this.lPid = is.read(this.lPid, 11, false);
        this.vBulletPrefix = is.readArray(this.vBulletPrefix, 12, false);
        this.sIconUrl = is.read(this.sIconUrl, 13, false);
        this.iType = is.read(this.iType, 14, false);
        this.vBulletSuffix = is.readArray(this.vBulletSuffix, 15, false);
        this.vTagInfo = is.readArray(this.vTagInfo, 16, false);
        this.tSenceFormat = (SendMessageFormat)is.directRead((TarsStructBase)this.tSenceFormat, 17, false);
        this.tContentExpand = (MessageContentExpand)is.directRead((TarsStructBase)this.tContentExpand, 18, false);
        this.iMessageMode = is.read(this.iMessageMode, 19, false);
        for (DecorationInfo decorationPrefix : this.vDecorationPrefix) {
            TarsStructBase tarsStructBase;
            Optional<? extends TarsStructBase> optional = HuyaCodecUtil.decodeDecorationInfo(decorationPrefix);
            if (!optional.isPresent() || !((tarsStructBase = optional.get()) instanceof BadgeInfo)) continue;
            this.badgeInfo = (BadgeInfo)tarsStructBase;
            break;
        }
    }

    @Override
    public HuyaOperationEnum getOperationEnum() {
        return HuyaOperationEnum.EWSCmdS2C_MsgPushReq;
    }

    public String getBadgeName() {
        if (this.badgeInfo == null) {
            return "";
        }
        return this.badgeInfo.getSBadgeName();
    }

    public byte getBadgeLevel() {
        if (this.badgeInfo == null) {
            return 0;
        }
        return (byte)this.badgeInfo.getIBadgeLevel();
    }

    public String getUid() {
        if (this.tUserInfo == null) {
            return null;
        }
        return Long.toString(this.tUserInfo.getLUid());
    }

    public String getUsername() {
        if (this.tUserInfo == null) {
            return "";
        }
        return this.tUserInfo.getSNickName();
    }

    public String getUserAvatar() {
        if (this.tUserInfo == null) {
            return "";
        }
        return this.tUserInfo.getSAvatarUrl();
    }

    public String getContent() {
        return this.sContent;
    }

    public SenderInfo getTUserInfo() {
        return this.tUserInfo;
    }

    public long getLTid() {
        return this.lTid;
    }

    public long getLSid() {
        return this.lSid;
    }

    public String getSContent() {
        return this.sContent;
    }

    public int getIShowMode() {
        return this.iShowMode;
    }

    public ContentFormat getTFormat() {
        return this.tFormat;
    }

    public BulletFormat getTBulletFormat() {
        return this.tBulletFormat;
    }

    public int getITermType() {
        return this.iTermType;
    }

    public List<DecorationInfo> getVDecorationPrefix() {
        return this.vDecorationPrefix;
    }

    public List<DecorationInfo> getVDecorationSuffix() {
        return this.vDecorationSuffix;
    }

    public List<UidNickName> getVAtSomeone() {
        return this.vAtSomeone;
    }

    public long getLPid() {
        return this.lPid;
    }

    public List<DecorationInfo> getVBulletPrefix() {
        return this.vBulletPrefix;
    }

    public String getSIconUrl() {
        return this.sIconUrl;
    }

    public int getIType() {
        return this.iType;
    }

    public List<DecorationInfo> getVBulletSuffix() {
        return this.vBulletSuffix;
    }

    public List<MessageTagInfo> getVTagInfo() {
        return this.vTagInfo;
    }

    public SendMessageFormat getTSenceFormat() {
        return this.tSenceFormat;
    }

    public MessageContentExpand getTContentExpand() {
        return this.tContentExpand;
    }

    public int getIMessageMode() {
        return this.iMessageMode;
    }

    public BadgeInfo getBadgeInfo() {
        return this.badgeInfo;
    }

    public void setTUserInfo(SenderInfo tUserInfo) {
        this.tUserInfo = tUserInfo;
    }

    public void setLTid(long lTid) {
        this.lTid = lTid;
    }

    public void setLSid(long lSid) {
        this.lSid = lSid;
    }

    public void setSContent(String sContent) {
        this.sContent = sContent;
    }

    public void setIShowMode(int iShowMode) {
        this.iShowMode = iShowMode;
    }

    public void setTFormat(ContentFormat tFormat) {
        this.tFormat = tFormat;
    }

    public void setTBulletFormat(BulletFormat tBulletFormat) {
        this.tBulletFormat = tBulletFormat;
    }

    public void setITermType(int iTermType) {
        this.iTermType = iTermType;
    }

    public void setVDecorationPrefix(List<DecorationInfo> vDecorationPrefix) {
        this.vDecorationPrefix = vDecorationPrefix;
    }

    public void setVDecorationSuffix(List<DecorationInfo> vDecorationSuffix) {
        this.vDecorationSuffix = vDecorationSuffix;
    }

    public void setVAtSomeone(List<UidNickName> vAtSomeone) {
        this.vAtSomeone = vAtSomeone;
    }

    public void setLPid(long lPid) {
        this.lPid = lPid;
    }

    public void setVBulletPrefix(List<DecorationInfo> vBulletPrefix) {
        this.vBulletPrefix = vBulletPrefix;
    }

    public void setSIconUrl(String sIconUrl) {
        this.sIconUrl = sIconUrl;
    }

    public void setIType(int iType) {
        this.iType = iType;
    }

    public void setVBulletSuffix(List<DecorationInfo> vBulletSuffix) {
        this.vBulletSuffix = vBulletSuffix;
    }

    public void setVTagInfo(List<MessageTagInfo> vTagInfo) {
        this.vTagInfo = vTagInfo;
    }

    public void setTSenceFormat(SendMessageFormat tSenceFormat) {
        this.tSenceFormat = tSenceFormat;
    }

    public void setTContentExpand(MessageContentExpand tContentExpand) {
        this.tContentExpand = tContentExpand;
    }

    public void setIMessageMode(int iMessageMode) {
        this.iMessageMode = iMessageMode;
    }

    public void setBadgeInfo(BadgeInfo badgeInfo) {
        this.badgeInfo = badgeInfo;
    }

    public MessageNoticeMsg(SenderInfo tUserInfo, long lTid, long lSid, String sContent, int iShowMode, ContentFormat tFormat, BulletFormat tBulletFormat, int iTermType, List<DecorationInfo> vDecorationPrefix, List<DecorationInfo> vDecorationSuffix, List<UidNickName> vAtSomeone, long lPid, List<DecorationInfo> vBulletPrefix, String sIconUrl, int iType, List<DecorationInfo> vBulletSuffix, List<MessageTagInfo> vTagInfo, SendMessageFormat tSenceFormat, MessageContentExpand tContentExpand, int iMessageMode, BadgeInfo badgeInfo) {
        this.tUserInfo = tUserInfo;
        this.lTid = lTid;
        this.lSid = lSid;
        this.sContent = sContent;
        this.iShowMode = iShowMode;
        this.tFormat = tFormat;
        this.tBulletFormat = tBulletFormat;
        this.iTermType = iTermType;
        this.vDecorationPrefix = vDecorationPrefix;
        this.vDecorationSuffix = vDecorationSuffix;
        this.vAtSomeone = vAtSomeone;
        this.lPid = lPid;
        this.vBulletPrefix = vBulletPrefix;
        this.sIconUrl = sIconUrl;
        this.iType = iType;
        this.vBulletSuffix = vBulletSuffix;
        this.vTagInfo = vTagInfo;
        this.tSenceFormat = tSenceFormat;
        this.tContentExpand = tContentExpand;
        this.iMessageMode = iMessageMode;
        this.badgeInfo = badgeInfo;
    }

    public MessageNoticeMsg() {
    }
}

