/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.douyin.netty.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.douyin.constant.DouyinPayloadTypeEnum;
import tech.ordinaryroad.live.chat.client.codec.douyin.msg.DouyinCmdMsg;
import tech.ordinaryroad.live.chat.client.codec.douyin.msg.DouyinMsg;
import tech.ordinaryroad.live.chat.client.codec.douyin.msg.base.IDouyinMsg;
import tech.ordinaryroad.live.chat.client.codec.douyin.protobuf.HeadersList;
import tech.ordinaryroad.live.chat.client.codec.douyin.protobuf.PushFrame;
import tech.ordinaryroad.live.chat.client.codec.douyin.protobuf.Response;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.servers.netty.client.handler.BinaryWebSocketFrameToMessageCodec;

public class DouyinCodecHandler
extends BinaryWebSocketFrameToMessageCodec<IDouyinMsg> {
    private static final Logger log = LoggerFactory.getLogger(DouyinCodecHandler.class);

    protected void encode(ChannelHandlerContext ctx, IDouyinMsg msg, List<Object> out) throws Exception {
        if (!(msg instanceof DouyinMsg)) {
            throw new BaseException("\u6682\u4e0d\u652f\u6301" + msg.getClass());
        }
        out.add(new BinaryWebSocketFrame(ctx.alloc().buffer().writeBytes(((DouyinMsg)msg).getMsg().toByteArray())));
    }

    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame msg, List<Object> out) throws Exception {
        byte[] bytes;
        PushFrame pushFrame = PushFrame.parseFrom((ByteBuffer)msg.content().nioBuffer());
        String compressType = null;
        if (CollUtil.isNotEmpty((Collection)pushFrame.getHeadersListList())) {
            for (HeadersList headersList : pushFrame.getHeadersListList()) {
                if (!"compress_type".equals(headersList.getKey())) continue;
                compressType = headersList.getValue();
            }
        }
        if (StrUtil.isBlank(compressType) || "none".equals(compressType)) {
            bytes = pushFrame.getPayload().toByteArray();
        } else if ("gzip".equalsIgnoreCase(compressType)) {
            ByteString payload = pushFrame.getPayload();
            bytes = ZipUtil.unGzip((InputStream)payload.newInput());
        } else {
            if (log.isWarnEnabled()) {
                log.warn("\u6682\u4e0d\u652f\u6301\u7684\u538b\u7f29\u65b9\u5f0f: {}", compressType);
            }
            return;
        }
        String payloadType = pushFrame.getPayloadType();
        DouyinPayloadTypeEnum payloadTypeEnum = DouyinPayloadTypeEnum.getByCode((String)payloadType);
        if (payloadTypeEnum == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u6682\u4e0d\u652f\u6301\u7684payloadType: {}", (Object)payloadType);
            }
            return;
        }
        switch (payloadTypeEnum) {
            case MSG: {
                Response response = Response.parseFrom((byte[])bytes);
                if (response.getNeedAck()) {
                    PushFrame ack = PushFrame.newBuilder().setLogId(pushFrame.getLogId()).setPayloadType(DouyinPayloadTypeEnum.ACK.getCode()).setPayload(response.getInternalExtBytes()).build();
                    ctx.writeAndFlush((Object)ack);
                }
                out.addAll(response.getMessagesListList().stream().map(DouyinCmdMsg::new).collect(Collectors.toList()));
                return;
            }
        }
    }
}

