/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.servers.netty.client.base;

import cn.hutool.core.util.StrUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseConnectionListener;
import tech.ordinaryroad.live.chat.client.commons.base.listener.IBaseMsgListener;
import tech.ordinaryroad.live.chat.client.commons.base.msg.IMsg;
import tech.ordinaryroad.live.chat.client.commons.client.BaseLiveChatClient;
import tech.ordinaryroad.live.chat.client.commons.client.enums.ClientStatusEnums;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatUrlUtil;
import tech.ordinaryroad.live.chat.client.servers.netty.client.config.BaseNettyClientConfig;
import tech.ordinaryroad.live.chat.client.servers.netty.handler.base.BaseBinaryFrameHandler;
import tech.ordinaryroad.live.chat.client.servers.netty.handler.base.BaseConnectionHandler;

public abstract class BaseNettyClient<Config extends BaseNettyClientConfig, CmdEnum extends Enum<CmdEnum>, Msg extends IMsg, MsgListener extends IBaseMsgListener<BinaryFrameHandler, CmdEnum>, ConnectionHandler extends BaseConnectionHandler<ConnectionHandler>, BinaryFrameHandler extends BaseBinaryFrameHandler<BinaryFrameHandler, CmdEnum, Msg, MsgListener>>
extends BaseLiveChatClient<Config, MsgListener>
implements IBaseConnectionListener<ConnectionHandler> {
    private static final Logger log = LoggerFactory.getLogger(BaseNettyClient.class);
    private final EventLoopGroup workerGroup;
    private final Bootstrap bootstrap = new Bootstrap();
    private ConnectionHandler connectionHandler;
    private IBaseConnectionListener<ConnectionHandler> connectionListener;
    private Channel channel;
    private URI websocketUri;
    protected IBaseConnectionListener<ConnectionHandler> clientConnectionListener = this;
    private volatile long lastSendDanmuTimeInMillis;

    protected void initChannel(SocketChannel channel) {
    }

    public abstract ConnectionHandler initConnectionHandler(IBaseConnectionListener<ConnectionHandler> var1);

    protected BaseNettyClient(Config config, EventLoopGroup workerGroup, IBaseConnectionListener<ConnectionHandler> connectionListener) {
        super(config);
        this.workerGroup = workerGroup;
        this.connectionListener = connectionListener;
    }

    public void onConnected(ConnectionHandler connectionHandler) {
        this.setStatus(ClientStatusEnums.CONNECTED);
        if (this.connectionListener != null) {
            this.connectionListener.onConnected(connectionHandler);
        }
    }

    public void onConnectFailed(ConnectionHandler connectionHandler) {
        this.setStatus(ClientStatusEnums.CONNECT_FAILED);
        if (this.connectionListener != null) {
            this.connectionListener.onConnectFailed(connectionHandler);
        }
    }

    public void onDisconnected(ConnectionHandler connectionHandler) {
        this.setStatus(ClientStatusEnums.DISCONNECTED);
        this.tryReconnect();
        if (this.connectionListener != null) {
            this.connectionListener.onDisconnected(connectionHandler);
        }
    }

    public void init() {
        if (this.checkStatus(ClientStatusEnums.INITIALIZED)) {
            return;
        }
        this.connectionHandler = this.initConnectionHandler(this);
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.setStatus(ClientStatusEnums.INITIALIZED);
    }

    public void connect(Runnable success, Consumer<Throwable> failed) {
        if (this.cancelReconnect) {
            this.cancelReconnect = false;
        }
        if (!this.checkStatus(ClientStatusEnums.INITIALIZED)) {
            return;
        }
        if (this.getStatus() == ClientStatusEnums.CONNECTED) {
            return;
        }
        if (this.getStatus() != ClientStatusEnums.RECONNECTING) {
            this.setStatus(ClientStatusEnums.CONNECTING);
        }
        String webSocketUriString = this.getWebSocketUriString();
        final int port = OrLiveChatUrlUtil.getWebSocketUriPort((String)webSocketUriString);
        try {
            this.websocketUri = new URI(webSocketUriString);
        }
        catch (URISyntaxException e) {
            log.error("WebSocket\u5730\u5740\u89e3\u6790\u5931\u8d25 " + webSocketUriString, (Throwable)e);
            failed.accept(e);
            return;
        }
        ((Bootstrap)this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                String socks5ProxyHost = ((BaseNettyClientConfig)BaseNettyClient.this.getConfig()).getSocks5ProxyHost();
                if (StrUtil.isNotBlank((CharSequence)socks5ProxyHost)) {
                    int socks5ProxyPort = ((BaseNettyClientConfig)BaseNettyClient.this.getConfig()).getSocks5ProxyPort();
                    pipeline.addFirst(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(socks5ProxyHost, socks5ProxyPort), ((BaseNettyClientConfig)BaseNettyClient.this.getConfig()).getSocks5ProxyUsername(), ((BaseNettyClientConfig)BaseNettyClient.this.getConfig()).getSocks5ProxyPassword())});
                    if (log.isDebugEnabled()) {
                        log.debug("\u5df2\u542f\u7528Socks5\u4ee3\u7406");
                    }
                }
                if (pipeline.get(SslHandler.class) != null) {
                    pipeline.remove(SslHandler.class);
                }
                if ("wss".equalsIgnoreCase(OrLiveChatUrlUtil.getScheme((String)BaseNettyClient.this.getWebSocketUriString()))) {
                    pipeline.addLast(new ChannelHandler[]{SslContextBuilder.forClient().build().newHandler(ch.alloc(), BaseNettyClient.this.websocketUri.getHost(), port)});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(((BaseNettyClientConfig)BaseNettyClient.this.getConfig()).getAggregatorMaxContentLength())});
                pipeline.addLast(new ChannelHandler[]{(ChannelHandler)BaseNettyClient.this.connectionHandler.getWebSocketProtocolHandler().get()});
                pipeline.addLast(new ChannelHandler[]{BaseNettyClient.this.connectionHandler});
                BaseNettyClient.this.initChannel(ch);
            }
        })).connect(this.websocketUri.getHost(), port).addListener((GenericFutureListener)((ChannelFutureListener)connectFuture -> {
            if (connectFuture.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8fde\u63a5\u5efa\u7acb\u6210\u529f\uff01");
                }
                this.channel = connectFuture.channel();
                this.connectionHandler.getHandshakePromise().addListener((GenericFutureListener)((ChannelFutureListener)handshakeFuture -> {
                    if (handshakeFuture.isSuccess()) {
                        try {
                            this.connectionHandler.sendAuthRequest(this.channel);
                            if (success != null) {
                                this.channel.eventLoop().execute(success);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u8ba4\u8bc1\u5305\u53d1\u9001\u5931\u8d25\uff0c\u65ad\u5f00\u8fde\u63a5", (Throwable)e);
                            this.disconnect();
                        }
                    }
                }));
            } else {
                log.error("\u8fde\u63a5\u5efa\u7acb\u5931\u8d25", connectFuture.cause());
                this.onConnectFailed(this.connectionHandler);
                if (failed != null) {
                    failed.accept(connectFuture.cause());
                }
            }
        }));
    }

    public void disconnect() {
        if (this.channel == null) {
            return;
        }
        this.channel.close();
    }

    protected void tryReconnect() {
        if (this.cancelReconnect) {
            this.cancelReconnect = false;
            return;
        }
        if (!((BaseNettyClientConfig)this.getConfig()).isAutoReconnect()) {
            return;
        }
        if (log.isWarnEnabled()) {
            Object roomId = ((BaseNettyClientConfig)this.getConfig()).getRoomId();
            log.warn("{}s\u540e\u5c06\u91cd\u65b0\u8fde\u63a5 {}", (Object)((BaseNettyClientConfig)this.getConfig()).getReconnectDelay(), roomId == null ? ((BaseNettyClientConfig)this.getConfig()).getWebsocketUri() : roomId);
        }
        this.workerGroup.schedule(() -> {
            this.setStatus(ClientStatusEnums.RECONNECTING);
            this.connect();
        }, (long)((BaseNettyClientConfig)this.getConfig()).getReconnectDelay(), TimeUnit.SECONDS);
    }

    public void send(Object msg, Runnable success, Consumer<Throwable> failed) {
        if (this.getStatus() != ClientStatusEnums.CONNECTED) {
            return;
        }
        ChannelFuture future = this.channel.writeAndFlush(msg);
        if (success != null || failed != null) {
            future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    if (success != null) {
                        channelFuture.channel().eventLoop().execute(success);
                    }
                } else if (failed != null) {
                    channelFuture.channel().eventLoop().execute(() -> failed.accept(channelFuture.cause()));
                }
            }));
        }
    }

    public void destroy() {
        this.cancelReconnect = true;
        this.workerGroup.shutdownGracefully().addListener(future -> {
            if (!future.isSuccess()) {
                throw new BaseException("client\u9500\u6bc1\u5931\u8d25", future.cause());
            }
            this.setStatus(ClientStatusEnums.DESTROYED);
            super.destroy();
        });
    }

    protected String getWebSocketUriString() {
        return ((BaseNettyClientConfig)this.getConfig()).getWebsocketUri();
    }

    protected void setStatus(ClientStatusEnums status) {
        if (log.isDebugEnabled() && this.getStatus() != status) {
            log.debug("{} \u72b6\u6001\u53d8\u5316 {} => {}\n", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.getStatus(), status});
        }
        super.setStatus(status);
    }

    public void sendDanmu(Object danmu, Runnable success, Consumer<Throwable> failed) {
        throw new BaseException("\u6682\u672a\u652f\u6301\u8be5\u529f\u80fd");
    }

    public void clickLike(int count, Runnable success, Consumer<Throwable> failed) {
        throw new BaseException("\u6682\u672a\u652f\u6301\u8be5\u529f\u80fd");
    }

    protected boolean checkCanSendDanmu(boolean checkConnected) {
        if (checkConnected && this.getStatus() != ClientStatusEnums.CONNECTED) {
            throw new BaseException("\u8fde\u63a5\u672a\u5efa\u7acb\uff0c\u65e0\u6cd5\u53d1\u9001\u5f39\u5e55");
        }
        if (System.currentTimeMillis() - this.lastSendDanmuTimeInMillis <= ((BaseNettyClientConfig)this.getConfig()).getMinSendDanmuPeriod()) {
            if (log.isWarnEnabled()) {
                log.warn("\u53d1\u9001\u5f39\u5e55\u9891\u7387\u8fc7\u5feb\uff0c\u5ffd\u7565\u8be5\u6b21\u53d1\u9001");
            }
            return false;
        }
        return true;
    }

    protected boolean checkCanSendDanmu() {
        return this.checkCanSendDanmu(true);
    }

    protected void finishSendDanmu() {
        this.lastSendDanmuTimeInMillis = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("\u5f39\u5e55\u53d1\u9001\u5b8c\u6210");
        }
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public URI getWebsocketUri() {
        return this.websocketUri;
    }
}

