/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.config.RpcConfig;
import top.ibase4j.core.support.Pagination;
import top.ibase4j.core.support.context.ApplicationContextHolder;
import top.ibase4j.core.support.http.HttpCode;
import top.ibase4j.core.support.http.SessionUser;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.WebUtil;

public abstract class AbstractController
implements InitializingBean {
    protected Logger logger = LogManager.getLogger();
    private RpcConfig.EnableDubboReference enableDubbo = new RpcConfig.EnableDubboReference();
    private RpcConfig.EnableMotan enableMotan = new RpcConfig.EnableMotan();
    private ApplicationConfig dubboApplication;
    private com.alibaba.dubbo.config.RegistryConfig dubboRegistry;
    private ProtocolConfig motanProtocol;
    private RegistryConfig motanRegistry;
    private static final Map<String, Object> serviceFactory = InstanceUtil.newHashMap();

    public void afterPropertiesSet() throws Exception {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object v = field.get(this);
            Class<?> cls = field.getType();
            if (v == null && cls.getSimpleName().toLowerCase().contains("service")) {
                v = this.getService(cls);
                field.set(this, v);
            }
            field.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object getService(Class<?> cls) {
        String clsName = cls.getName();
        Object v = serviceFactory.get(clsName);
        if (v != null) return v;
        Class<?> clazz = cls;
        // MONITORENTER : clazz
        if (v == null) {
            this.logger.info("*****Autowire {}*****", cls);
            if (this.enableDubbo.matches(null, null)) {
                if (this.dubboApplication == null || this.dubboRegistry == null) {
                    Class<AbstractController> clazz2 = AbstractController.class;
                    // MONITORENTER : top.ibase4j.core.base.AbstractController.class
                    if (this.dubboApplication == null) {
                        this.dubboApplication = ApplicationContextHolder.getBean(ApplicationConfig.class);
                    }
                    if (this.dubboRegistry == null) {
                        this.dubboRegistry = ApplicationContextHolder.getBean(com.alibaba.dubbo.config.RegistryConfig.class);
                    }
                    // MONITOREXIT : clazz2
                }
                ReferenceConfig reference = new ReferenceConfig();
                reference.setApplication(this.dubboApplication);
                reference.setRegistry(this.dubboRegistry);
                reference.setInterface(cls);
                v = reference.get();
            } else if (this.enableMotan.matches(null, null)) {
                RefererConfig reference;
                if (this.motanProtocol == null || this.motanRegistry == null) {
                    reference = AbstractController.class;
                    // MONITORENTER : top.ibase4j.core.base.AbstractController.class
                    if (this.motanProtocol == null) {
                        this.motanProtocol = ApplicationContextHolder.getBean(ProtocolConfig.class);
                    }
                    if (this.motanRegistry == null) {
                        this.motanRegistry = ApplicationContextHolder.getBean(RegistryConfig.class);
                    }
                    // MONITOREXIT : reference
                }
                reference = new RefererConfig();
                reference.setProtocol(this.motanProtocol);
                reference.setRegistry(this.motanRegistry);
                reference.setInterface(cls);
                v = reference.getRef();
            } else {
                v = ApplicationContextHolder.getBean(cls);
            }
            this.logger.info("*****{} Autowired*****", cls);
            serviceFactory.put(clsName, v);
        }
        // MONITOREXIT : clazz
        return v;
    }

    protected SessionUser getCurrUser() {
        return (SessionUser)SecurityUtils.getSubject().getPrincipal();
    }

    protected Long getCurrUser(HttpServletRequest request) {
        SessionUser user = WebUtil.getCurrentUser(request);
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap() {
        return this.setSuccessModelMap(new ModelMap(), null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap) {
        return this.setSuccessModelMap(modelMap, null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(Object data) {
        return this.setModelMap(new ModelMap(), HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap, Object data) {
        return this.setModelMap(modelMap, HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code) {
        return this.setModelMap(new ModelMap(), code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(String code, String msg) {
        return this.setModelMap(new ModelMap(), code, msg, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code) {
        return this.setModelMap(modelMap, code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code, Object data) {
        return this.setModelMap(new ModelMap(), code, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(String code, String msg, Object data) {
        return this.setModelMap(new ModelMap(), code, msg, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code, Object data) {
        return this.setModelMap(modelMap, code.value().toString(), code.msg(), data);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, String code, String msg, Object data) {
        if (!modelMap.isEmpty()) {
            LinkedHashMap map = InstanceUtil.newLinkedHashMap();
            map.putAll(modelMap);
            modelMap.clear();
            for (String key : map.keySet()) {
                if (key.startsWith("org.springframework.validation.BindingResult") || key.equals("void")) continue;
                modelMap.put((Object)key, map.get(key));
            }
        }
        if (data != null) {
            if (data instanceof Pagination) {
                Pagination page = (Pagination)data;
                modelMap.put((Object)"rows", page.getRecords());
                modelMap.put((Object)"current", (Object)page.getCurrent());
                modelMap.put((Object)"size", (Object)page.getSize());
                modelMap.put((Object)"pages", (Object)page.getPages());
                modelMap.put((Object)"total", (Object)page.getTotal());
            } else if (data instanceof List) {
                modelMap.put((Object)"rows", data);
                modelMap.put((Object)"total", (Object)((List)data).size());
            } else {
                modelMap.put((Object)"data", data);
            }
        }
        modelMap.put((Object)"code", (Object)code);
        modelMap.put((Object)"msg", (Object)msg);
        modelMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
        this.logger.info("response===>{}", (Object)JSON.toJSONString((Object)modelMap));
        return ResponseEntity.ok((Object)modelMap);
    }
}

