/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;
import top.ibase4j.core.base.BaseMapper;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.BaseService;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.support.Pagination;
import top.ibase4j.core.support.cache.CacheKey;
import top.ibase4j.core.support.dbcp.HandleDataSource;
import top.ibase4j.core.support.generator.Sequence;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PageUtil;
import top.ibase4j.core.util.ThreadUtil;

public class BaseServiceImpl<T extends BaseModel, M extends BaseMapper<T>>
implements BaseService<T> {
    protected Logger logger = LogManager.getLogger();
    @Autowired
    protected M mapper;
    private static ExecutorService executorService = ThreadUtil.threadPool(1, 100, 30);

    @Override
    @Transactional
    public void del(List<Long> ids, Long userId) {
        ids.forEach(id -> this.del((Long)id, userId));
    }

    @Override
    @Transactional
    public void del(Long id, Long userId) {
        try {
            T record = this.getById(id);
            ((BaseModel)record).setEnable(0);
            ((BaseModel)record).setUpdateTime(new Date());
            ((BaseModel)record).setUpdateBy(userId);
            this.mapper.updateById(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void delete(Long id) {
        try {
            this.mapper.deleteById((Serializable)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public Integer deleteByEntity(T t) {
        EntityWrapper wrapper = new EntityWrapper(t);
        return this.mapper.delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public Integer deleteByMap(Map<String, Object> columnMap) {
        return this.mapper.deleteByMap(columnMap);
    }

    public Pagination<Map<String, Object>> getPageMap(Page<Long> ids) {
        if (ids != null) {
            Pagination<Map<String, Object>> page = new Pagination<Map<String, Object>>(ids.getCurrent(), ids.getRecords().size());
            page.setTotal(ids.getTotal());
            ArrayList records = InstanceUtil.newArrayList();
            String datasource = HandleDataSource.getDataSource();
            IntStream.range(0, ids.getRecords().size()).forEach(i -> records.add(null));
            IntStream.range(0, ids.getRecords().size()).parallel().forEach(i -> {
                HandleDataSource.putDataSource(datasource);
                records.set(i, InstanceUtil.transBean2Map(this.getById((Long)ids.getRecords().get(i))));
            });
            page.setRecords(records);
            return page;
        }
        return new Pagination<Map<String, Object>>();
    }

    @Override
    public Pagination<T> query(Map<String, Object> params) {
        Page<Long> page = PageUtil.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page);
    }

    @Override
    public Pagination<T> query(T entity, Pagination<T> rowBounds) {
        Page page = new Page();
        try {
            PropertyUtils.copyProperties((Object)page, rowBounds);
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
        }
        List<Long> ids = this.mapper.selectIdPage((RowBounds)page, entity);
        page.setRecords(ids);
        return this.getPage((Page<Long>)page);
    }

    @Override
    public Pagination<T> queryFromDB(T entity, Pagination<T> rowBounds) {
        Page page = new Page();
        try {
            PropertyUtils.copyProperties((Object)page, rowBounds);
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
        }
        EntityWrapper wrapper = new EntityWrapper(entity);
        List list = this.mapper.selectPage((RowBounds)page, (Wrapper)wrapper);
        list.forEach(t -> this.saveCache(t));
        Pagination pager = new Pagination(page.getCurrent(), page.getSize());
        pager.setRecords(list);
        pager.setTotal(page.getTotal());
        return pager;
    }

    @Override
    public Pagination<T> queryFromDB(Map<String, Object> params) {
        Page<Long> page = PageUtil.getPage(params);
        List<BaseModel> list = this.mapper.selectPage((RowBounds)page, params);
        list.forEach(t -> this.saveCache(t));
        Pagination<BaseModel> pager = new Pagination<BaseModel>(page.getCurrent(), page.getSize());
        pager.setRecords(list);
        pager.setTotal(page.getTotal());
        return pager;
    }

    @Override
    public List<T> queryListFromDB(Map<String, Object> params) {
        return this.mapper.selectByMap(params);
    }

    @Override
    public List<T> queryListFromDB(T entity) {
        EntityWrapper wrapper = new EntityWrapper(entity);
        return this.mapper.selectList((Wrapper)wrapper);
    }

    @Override
    public Integer count(T entity) {
        EntityWrapper wrapper = new EntityWrapper(entity);
        return this.mapper.selectCount((Wrapper)wrapper);
    }

    @Override
    public Integer count(Map<String, Object> params) {
        return this.mapper.selectCount(params);
    }

    @Override
    public T queryById(Long id) {
        return this.queryById(id, 1);
    }

    @Override
    public List<T> queryList(Map<String, Object> params) {
        if (DataUtil.isEmpty(params.get("orderBy"))) {
            params.put("orderBy", "id_");
        }
        List<Long> ids = this.mapper.selectIdPage(params);
        List<T> list = this.queryList(ids);
        return list;
    }

    @Override
    public List<T> queryList(T params) {
        List<Long> ids = this.mapper.selectIdPage(params);
        List<T> list = this.queryList(ids);
        return list;
    }

    @Override
    public List<T> queryList(List<Long> ids) {
        ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            String datasource = HandleDataSource.getDataSource();
            IntStream.range(0, ids.size()).forEach(i -> list.add(null));
            IntStream.range(0, ids.size()).parallel().forEach(i -> {
                HandleDataSource.putDataSource(datasource);
                list.set(i, this.getById((Long)ids.get(i)));
            });
        }
        return list;
    }

    @Override
    public <K> List<K> queryList(List<Long> ids, Class<K> cls) {
        ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            String datasource = HandleDataSource.getDataSource();
            IntStream.range(0, ids.size()).forEach(i -> list.add(null));
            IntStream.range(0, ids.size()).parallel().forEach(i -> {
                HandleDataSource.putDataSource(datasource);
                T t = this.getById((Long)ids.get(i));
                Object k = InstanceUtil.to(t, cls);
                list.set(i, k);
            });
        }
        return list;
    }

    @Override
    public T selectOne(T entity) {
        BaseModel t = (BaseModel)this.mapper.selectOne(entity);
        this.saveCache(t);
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public T update(T record) {
        try {
            ((BaseModel)record).setUpdateTime(new Date());
            if (((BaseModel)record).getId() == null) {
                ((BaseModel)record).setCreateTime(new Date());
                this.mapper.insert(record);
            } else {
                String requestId = Sequence.next().toString();
                String lockKey = this.getLockKey("U" + ((BaseModel)record).getId());
                if (CacheUtil.getLock(lockKey, "\u66f4\u65b0", requestId)) {
                    try {
                        this.mapper.updateById(record);
                    }
                    finally {
                        CacheUtil.unLock(lockKey, requestId);
                    }
                } else {
                    throw new RuntimeException("\u6570\u636e\u4e0d\u4e00\u81f4!\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7f16\u8f91!");
                }
            }
            record = (BaseModel)this.mapper.selectById((Serializable)((BaseModel)record).getId());
            this.saveCache(record);
        }
        catch (DuplicateKeyException e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55.");
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            throw new RuntimeException(ExceptionUtil.getStackTraceAsString(e));
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public T updateAllColumn(T record) {
        try {
            ((BaseModel)record).setUpdateTime(new Date());
            if (((BaseModel)record).getId() == null) {
                ((BaseModel)record).setCreateTime(new Date());
                this.mapper.insert(record);
            } else {
                String requestId = Sequence.next().toString();
                String lockKey = this.getLockKey("U" + ((BaseModel)record).getId());
                if (CacheUtil.getLock(lockKey, "\u66f4\u65b0\u6240\u6709\u5b57\u6bb5", requestId)) {
                    try {
                        this.mapper.updateAllColumnById(record);
                    }
                    finally {
                        CacheUtil.unLock(lockKey, requestId);
                    }
                } else {
                    throw new RuntimeException("\u6570\u636e\u4e0d\u4e00\u81f4!\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7f16\u8f91!");
                }
            }
            record = (BaseModel)this.mapper.selectById((Serializable)((BaseModel)record).getId());
            this.saveCache(record);
        }
        catch (DuplicateKeyException e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            throw new RuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55.");
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            throw new RuntimeException(ExceptionUtil.getStackTraceAsString(e));
        }
        return record;
    }

    @Override
    public boolean updateAllColumnBatch(List<T> entityList) {
        return this.updateAllColumnBatch(entityList, 30);
    }

    @Override
    public boolean updateAllColumnBatch(List<T> entityList, int batchSize) {
        return this.updateBatch(entityList, batchSize, false);
    }

    @Override
    public boolean updateBatch(List<T> entityList) {
        return this.updateBatch(entityList, 30);
    }

    @Override
    public boolean updateBatch(List<T> entityList, int batchSize) {
        return this.updateBatch(entityList, batchSize, true);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), (int)0);
    }

    protected String getLockKey(Object id) {
        CacheKey cacheKey = CacheKey.getInstance(this.getClass());
        StringBuilder sb = new StringBuilder();
        if (cacheKey == null) {
            sb.append(this.getClass().getName());
        } else {
            sb.append(cacheKey.getValue());
        }
        return sb.append(":LOCK:").append(id).toString();
    }

    @Override
    protected <P> Pagination<P> query(Map<String, Object> params, Class<P> cls) {
        Page<Long> page = PageUtil.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page, cls);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    private T getById(Long id) {
        return this.queryById(id, 1);
    }

    protected Pagination<T> getPage(Page<Long> ids) {
        if (ids != null) {
            Pagination page = new Pagination(ids.getCurrent(), ids.getRecords().size());
            page.setTotal(ids.getTotal());
            ArrayList records = InstanceUtil.newArrayList();
            String datasource = HandleDataSource.getDataSource();
            IntStream.range(0, ids.getRecords().size()).forEach(i -> records.add(null));
            IntStream.range(0, ids.getRecords().size()).parallel().forEach(i -> {
                HandleDataSource.putDataSource(datasource);
                records.set(i, this.getById((Long)ids.getRecords().get(i)));
            });
            page.setRecords(records);
            return page;
        }
        return new Pagination();
    }

    private <K> Pagination<K> getPage(Page<Long> ids, Class<K> cls) {
        if (ids != null) {
            Pagination page = new Pagination(ids.getCurrent(), ids.getRecords().size());
            page.setTotal(ids.getTotal());
            ArrayList records = InstanceUtil.newArrayList();
            String datasource = HandleDataSource.getDataSource();
            IntStream.range(0, ids.getRecords().size()).forEach(i -> records.add(null));
            IntStream.range(0, ids.getRecords().size()).parallel().forEach(i -> {
                HandleDataSource.putDataSource(datasource);
                records.set(i, InstanceUtil.to(this.getById((Long)ids.getRecords().get(i)), cls));
            });
            page.setRecords(records);
            return page;
        }
        return new Pagination();
    }

    private void saveCache(T record) {
        if (record == null) {
            return;
        }
        final CacheKey key = CacheKey.getInstance(this.getClass());
        if (key != null) {
            try {
                CacheUtil.getCache().set(key.getValue() + ":" + ((BaseModel)record).getId(), (Serializable)record, key.getTimeToLive());
            }
            catch (Exception e) {
                this.logger.error(ExceptionUtil.getStackTraceAsString(e));
                executorService.execute(new Runnable((BaseModel)record){
                    final /* synthetic */ BaseModel val$record;
                    {
                        this.val$record = baseModel;
                    }

                    @Override
                    public void run() {
                        BaseServiceImpl.this.deleteCache(key.getValue() + ":" + this.val$record.getId(), 1);
                    }
                });
            }
        }
    }

    private void deleteCache(String key, int times) {
        try {
            CacheUtil.getCache().del(key);
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            ThreadUtil.sleep(10, Math.min(Integer.MAX_VALUE, times * 100));
            this.deleteCache(key, times + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T queryById(Long id, int times) {
        CacheKey key = CacheKey.getInstance(this.getClass());
        BaseModel record = null;
        if (key != null) {
            try {
                record = (BaseModel)CacheUtil.getCache().get(key.getValue() + ":" + id, key.getTimeToLive());
            }
            catch (Exception e) {
                this.logger.error(ExceptionUtil.getStackTraceAsString(e));
            }
        }
        if (record == null) {
            String requestId;
            String lockKey = this.getLockKey(id);
            if (CacheUtil.getLock(lockKey, "\u6839\u636eID\u67e5\u8be2\u6570\u636e", requestId = Sequence.next().toString())) {
                try {
                    record = (BaseModel)this.mapper.selectById((Serializable)id);
                    this.saveCache(record);
                }
                finally {
                    CacheUtil.unLock(lockKey, requestId);
                }
            } else if (times > 3) {
                record = (BaseModel)this.mapper.selectById((Serializable)id);
                this.saveCache(record);
            } else {
                this.logger.info(this.getClass().getSimpleName() + ":" + id + " retry getById.");
                ThreadUtil.sleep(1, 20);
                return this.queryById(id, times + 1);
            }
        }
        return (T)record;
    }

    private boolean updateBatch(List<T> entityList, int batchSize, boolean selective) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            IntStream.range(0, entityList.size()).forEach(i -> {
                if (selective) {
                    this.update((BaseModel)entityList.get(i));
                } else {
                    this.updateAllColumn((BaseModel)entityList.get(i));
                }
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
            });
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        return true;
    }
}

