/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import top.ibase4j.core.config.DubboBaseConfig;
import top.ibase4j.core.util.PropertiesUtil;

public class RpcConfig {

    @Configuration
    @Conditional(value={EnableMotan.class})
    @ImportResource(value={"classpath*:spring/motan.xml"})
    static class MotanConfig {
        MotanConfig() {
        }
    }

    @Configuration
    @Conditional(value={EnableDubboReference.class})
    static class DubboConsumerConfig
    extends DubboBaseConfig {
        DubboConsumerConfig() {
        }

        @Bean
        public ConsumerConfig consumer() {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            consumerConfig.setLoadbalance("leastactive");
            consumerConfig.setTimeout(Integer.valueOf(PropertiesUtil.getInt("rpc.request.timeout", 20000)));
            consumerConfig.setRetries(Integer.valueOf(PropertiesUtil.getInt("rpc.consumer.retries", 0)));
            consumerConfig.setCheck(Boolean.valueOf(false));
            return consumerConfig;
        }
    }

    @Configuration
    @Conditional(value={EnableDubboService.class})
    @DubboComponentScan(value={"${rpc.package}"})
    static class DubboServiceConfig
    extends DubboBaseConfig {
        DubboServiceConfig() {
        }

        @Bean
        public ProviderConfig provider() {
            ProviderConfig providerConfig = new ProviderConfig();
            providerConfig.setFilter("dataSourceAspect,default");
            return providerConfig;
        }

        @Bean
        public ProtocolConfig protocol() {
            ProtocolConfig protocolConfig = new ProtocolConfig();
            protocolConfig.setPort(Integer.valueOf(PropertiesUtil.getInt("rpc.protocol.port", 20880)));
            protocolConfig.setThreadpool("cached");
            protocolConfig.setThreads(Integer.valueOf(PropertiesUtil.getInt("rpc.protocol.maxThread", 100)));
            protocolConfig.setPayload(Integer.valueOf(PropertiesUtil.getInt("rpc.protocol.maxContentLength", 0x100000)));
            return protocolConfig;
        }
    }

    public static class EnableMotan
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "motan".equals(PropertiesUtil.getString("rpc.type"));
        }
    }

    public static class EnableDubboReference
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "dubbo".equals(PropertiesUtil.getString("rpc.type")) && "Y".equals(PropertiesUtil.getString("rpc.dubbo.reference"));
        }
    }

    public static class EnableDubboService
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "dubbo".equals(PropertiesUtil.getString("rpc.type")) && "Y".equals(PropertiesUtil.getString("rpc.dubbo.service"));
        }
    }
}

