/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import top.ibase4j.core.interceptor.BaseInterceptor;
import top.ibase4j.core.support.http.HttpCode;
import top.ibase4j.core.support.http.SessionUser;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class MaliciousRequestInterceptor
extends BaseInterceptor {
    private boolean allRequest = false;
    private boolean containsParamter = true;
    private int minRequestIntervalTime = 100;
    private int maxMaliciousTimes = 0;
    private List<String> whiteUrls;
    private int _size = 0;

    public MaliciousRequestInterceptor() {
        String path = MaliciousRequestInterceptor.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/mrqWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SessionUser userId;
        String url = request.getServletPath();
        if (url.endsWith("/unauthorized") || url.endsWith("/forbidden") || WebUtil.isWhiteRequest(url, this._size, this.whiteUrls)) {
            return super.preHandle(request, response, handler);
        }
        if (this.containsParamter) {
            url = url + JSON.toJSONString(WebUtil.getParameterMap(request));
        }
        String user = (userId = WebUtil.getCurrentUser(request)) != null ? userId.toString() : WebUtil.getHost(request) + request.getHeader("USER-AGENT");
        String preRequest = (String)CacheUtil.getCache().getFire("iBase4J:PREREQUEST" + user);
        Long preRequestTime = (Long)CacheUtil.getCache().getFire("iBase4J:PREREQUEST_TIME" + user);
        int seconds = this.minRequestIntervalTime;
        if (preRequestTime != null && preRequest != null) {
            if ((url.equals(preRequest) || this.allRequest) && System.currentTimeMillis() - preRequestTime < (long)this.minRequestIntervalTime) {
                Integer maliciousRequestTimes = (Integer)CacheUtil.getCache().getFire("iBase4J:MALICIOUS_REQUEST_TIMES" + user);
                if (maliciousRequestTimes == null) {
                    maliciousRequestTimes = 1;
                } else {
                    Integer n = maliciousRequestTimes;
                    Integer n2 = maliciousRequestTimes = Integer.valueOf(maliciousRequestTimes + 1);
                }
                CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, maliciousRequestTimes, seconds);
                if (maliciousRequestTimes > this.maxMaliciousTimes) {
                    CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, Integer.valueOf(0), seconds);
                    logger.warn("To intercept a malicious request : {}", (Object)url);
                    return WebUtil.write((ServletResponse)response, HttpCode.MULTI_STATUS.value(), HttpCode.MULTI_STATUS.msg());
                }
            } else {
                CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, Integer.valueOf(0), seconds);
            }
        }
        CacheUtil.getCache().set("iBase4J:PREREQUEST" + user, (Serializable)((Object)url), seconds);
        CacheUtil.getCache().set("iBase4J:PREREQUEST_TIME" + user, Long.valueOf(System.currentTimeMillis()), seconds);
        return super.preHandle(request, response, handler);
    }

    public MaliciousRequestInterceptor setAllRequest(boolean allRequest) {
        this.allRequest = allRequest;
        return this;
    }

    public MaliciousRequestInterceptor setContainsParamter(boolean containsParamter) {
        this.containsParamter = containsParamter;
        return this;
    }

    public MaliciousRequestInterceptor setMinRequestIntervalTime(int minRequestIntervalTime) {
        this.minRequestIntervalTime = minRequestIntervalTime;
        return this;
    }

    public MaliciousRequestInterceptor setMaxMaliciousTimes(int maxMaliciousTimes) {
        this.maxMaliciousTimes = maxMaliciousTimes;
        return this;
    }
}

