/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.context;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class OrderedProperties
extends Properties {
    private List<Object> keyList = new ArrayList<Object>();

    public OrderedProperties() {
    }

    public OrderedProperties(String path) throws IOException {
        try (FileInputStream is = new FileInputStream(path);){
            this.load(is);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + path);
        }
    }

    public OrderedProperties(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            this.load(is);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + file.getAbsolutePath());
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.removeKeyIfExists(key);
        this.keyList.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.removeKeyIfExists(key);
        return super.remove(key);
    }

    private void removeKeyIfExists(Object key) {
        this.keyList.remove(key);
    }

    public List<Object> getKeyList() {
        return this.keyList;
    }

    public void store(String path) throws IOException {
        this.store(path, "UTF-8");
    }

    public void store(String path, String charset) throws IOException {
        block27: {
            if (path != null && !"".equals(path)) {
                try (FileOutputStream os = new FileOutputStream(path);
                     BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, charset));){
                    this.store(bw, null);
                    break block27;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                }
            }
            throw new RuntimeException("\u5b58\u50a8\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return new EnumerationAdapter<Object>(this.keyList);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return new EnumerationAdapter<Object>(this.keyList);
    }

    private class EnumerationAdapter<T>
    implements Enumeration<T> {
        private int index = 0;
        private final List<T> list;
        private final boolean isEmpty;

        public EnumerationAdapter(List<T> list) {
            this.list = list;
            this.isEmpty = list.isEmpty();
        }

        @Override
        public boolean hasMoreElements() {
            return !this.isEmpty && this.index < this.list.size();
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                return this.list.get(this.index++);
            }
            return null;
        }
    }
}

