/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.monitor;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.SpiderListener;
import us.codecraft.webmagic.monitor.SpiderStatus;
import us.codecraft.webmagic.monitor.SpiderStatusMXBean;
import us.codecraft.webmagic.utils.Experimental;
import us.codecraft.webmagic.utils.UrlUtils;

@Experimental
public class SpiderMonitor {
    private static final SpiderMonitor INSTANCE = new SpiderMonitor();
    private MBeanServer mbeanServer;
    private String jmxServerName = "WebMagic";
    private List<SpiderStatusMXBean> spiderStatuses = new ArrayList<SpiderStatusMXBean>();

    protected SpiderMonitor() {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public synchronized SpiderMonitor register(Spider ... spiders) throws JMException {
        for (Spider spider : spiders) {
            MonitorSpiderListener monitorSpiderListener = new MonitorSpiderListener();
            if (spider.getSpiderListeners() == null) {
                ArrayList<MonitorSpiderListener> spiderListeners = new ArrayList<MonitorSpiderListener>();
                spiderListeners.add(monitorSpiderListener);
                spider.setSpiderListeners(spiderListeners);
            } else {
                spider.getSpiderListeners().add(monitorSpiderListener);
            }
            SpiderStatusMXBean spiderStatusMBean = this.getSpiderStatusMBean(spider, monitorSpiderListener);
            this.registerMBean(spiderStatusMBean);
            this.spiderStatuses.add(spiderStatusMBean);
        }
        return this;
    }

    protected SpiderStatusMXBean getSpiderStatusMBean(Spider spider, MonitorSpiderListener monitorSpiderListener) {
        return new SpiderStatus(spider, monitorSpiderListener);
    }

    protected List<SpiderStatusMXBean> getSpiderStatuses() {
        return this.spiderStatuses;
    }

    public static SpiderMonitor instance() {
        return INSTANCE;
    }

    protected void registerMBean(SpiderStatusMXBean spiderStatus) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objName = new ObjectName(this.jmxServerName + ":name=" + UrlUtils.removePort((String)spiderStatus.getName()));
        this.mbeanServer.registerMBean(spiderStatus, objName);
    }

    public class MonitorSpiderListener
    implements SpiderListener {
        private final AtomicInteger successCount = new AtomicInteger(0);
        private final AtomicInteger errorCount = new AtomicInteger(0);
        private List<String> errorUrls = Collections.synchronizedList(new ArrayList());

        public void onSuccess(Request request) {
            this.successCount.incrementAndGet();
        }

        public void onError(Request request, Exception e) {
            this.errorUrls.add(request.getUrl());
            this.errorCount.incrementAndGet();
        }

        public AtomicInteger getSuccessCount() {
            return this.successCount;
        }

        public AtomicInteger getErrorCount() {
            return this.errorCount;
        }

        public List<String> getErrorUrls() {
            return this.errorUrls;
        }
    }
}

