/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.math.NumberUtils;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.BloomFilterDuplicateRemover;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;

public class FileCacheQueueScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler,
Closeable {
    private String filePath = System.getProperty("java.io.tmpdir");
    private String fileUrlAllName = ".urls.txt";
    private Task task;
    private String fileCursor = ".cursor.txt";
    private PrintWriter fileUrlWriter;
    private PrintWriter fileCursorWriter;
    private AtomicInteger cursor = new AtomicInteger();
    private AtomicBoolean inited = new AtomicBoolean(false);
    private BlockingQueue<Request> queue;
    private ScheduledExecutorService flushThreadPool;

    public FileCacheQueueScheduler(String filePath) {
        if (!((String)filePath).endsWith("/") && !((String)filePath).endsWith("\\")) {
            filePath = (String)filePath + "/";
        }
        this.filePath = filePath;
        this.initDuplicateRemover();
    }

    private void flush() {
        this.fileUrlWriter.flush();
        this.fileCursorWriter.flush();
    }

    private void init(Task task) {
        this.task = task;
        File file = new File(this.filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.readFile();
        this.initWriter();
        this.initFlushThread();
        this.inited.set(true);
        this.logger.info("init cache scheduler success");
    }

    private void initDuplicateRemover() {
        BloomFilterDuplicateRemover bloomFilterDuplicateRemover = new BloomFilterDuplicateRemover(this.filePath.hashCode());
        this.setDuplicateRemover(bloomFilterDuplicateRemover);
    }

    private void initFlushThread() {
        this.flushThreadPool = Executors.newScheduledThreadPool(1);
        this.flushThreadPool.scheduleAtFixedRate(this::flush, 10L, 10L, TimeUnit.SECONDS);
    }

    private void initWriter() {
        try {
            this.fileUrlWriter = new PrintWriter(new FileWriter(this.getFileName(this.fileUrlAllName), true));
            this.fileCursorWriter = new PrintWriter(new FileWriter(this.getFileName(this.fileCursor), false));
        }
        catch (IOException e) {
            throw new RuntimeException("init cache scheduler error", e);
        }
    }

    private void readFile() {
        try {
            this.queue = new LinkedBlockingQueue<Request>();
            this.readCursorFile();
            this.readUrlFile();
        }
        catch (FileNotFoundException e) {
            this.logger.info("init cache file " + this.getFileName(this.fileUrlAllName));
        }
        catch (IOException e) {
            this.logger.error("init file error", (Throwable)e);
        }
    }

    private void readUrlFile() throws IOException {
        try (BufferedReader fileUrlReader = new BufferedReader(new FileReader(this.getFileName(this.fileUrlAllName)));){
            String line;
            int lineReaded = 0;
            while ((line = fileUrlReader.readLine()) != null) {
                Request request = this.deserializeRequest(line);
                this.getDuplicateRemover().isDuplicate(request, null);
                if (++lineReaded <= this.cursor.get()) continue;
                this.queue.add(request);
            }
        }
    }

    private void readCursorFile() throws IOException {
        String fileName = this.getFileName(this.fileCursor);
        try (BufferedReader fileCursorReader = new BufferedReader(new FileReader(fileName));){
            String line;
            String lastLine = null;
            while ((line = fileCursorReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                lastLine = line;
            }
            if (lastLine != null) {
                this.cursor.set(NumberUtils.toInt((String)line));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flushThreadPool.shutdown();
        this.fileUrlWriter.close();
        this.fileCursorWriter.close();
    }

    private String getFileName(String filename) {
        return this.filePath + this.task.getUUID() + filename;
    }

    protected void pushWhenNoDuplicate(Request request, Task task) {
        if (!this.inited.get()) {
            this.init(task);
        }
        this.queue.add(request);
        this.fileUrlWriter.println(this.serializeRequest(request));
    }

    public synchronized Request poll(Task task) {
        if (!this.inited.get()) {
            this.init(task);
        }
        this.fileCursorWriter.println(this.cursor.incrementAndGet());
        return (Request)this.queue.poll();
    }

    public int getLeftRequestsCount(Task task) {
        return this.queue.size();
    }

    public int getTotalRequestsCount(Task task) {
        return this.getDuplicateRemover().getTotalRequestsCount(task);
    }

    protected String serializeRequest(Request request) {
        return request.getUrl();
    }

    protected Request deserializeRequest(String line) {
        return new Request(line);
    }
}

