/*
 * Decompiled with CFR 0.152.
 */
package wicket.authorization.strategies.role.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import wicket.authorization.Action;
import wicket.authorization.strategies.role.Roles;

final class ActionPermissions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Action, Roles> rolesForAction = new HashMap<Action, Roles>();

    ActionPermissions() {
    }

    public final void authorize(Action action, Roles rolesToAdd) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        if (rolesToAdd == null) {
            throw new IllegalArgumentException("Argument rolesToAdd cannot be null");
        }
        Roles roles = this.rolesForAction.get(action);
        if (roles == null) {
            roles = new Roles();
            this.rolesForAction.put(action, roles);
        }
        roles.addAll(rolesToAdd);
    }

    public final void authorizeAll(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        this.rolesForAction.remove(action);
    }

    public final Roles rolesFor(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        return this.rolesForAction.get(action);
    }

    public final void unauthorize(Action action, Roles rolesToRemove) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        if (rolesToRemove == null) {
            throw new IllegalArgumentException("Argument rolesToRemove cannot be null");
        }
        Roles roles = this.rolesForAction.get(action);
        if (roles != null) {
            roles.removeAll(rolesToRemove);
        }
        if (roles.size() == 0) {
            roles.add("wicket:NO_ROLE");
        }
    }
}

