/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.controller;

import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import xyz.erupt.ai.constants.ChatSenderType;
import xyz.erupt.ai.core.LlmCore;
import xyz.erupt.ai.model.Chat;
import xyz.erupt.ai.model.ChatMessage;
import xyz.erupt.ai.model.LLM;
import xyz.erupt.ai.model.LLMAgent;
import xyz.erupt.ai.service.LLMService;
import xyz.erupt.ai.vo.SseBody;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.view.R;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.annotation.EruptLoginAuth;
import xyz.erupt.upms.model.EruptUserVo;
import xyz.erupt.upms.service.EruptUserService;

@RestController
@RequestMapping(value={"/erupt-api/ai/chat"})
public class ChatController {
    @Resource
    private EruptDao eruptDao;
    @Resource
    private LLMService llmService;
    @Resource
    private EruptUserService eruptUserService;

    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    @GetMapping(value={"/send"}, produces={"text/event-stream"})
    @Transactional
    public SseEmitter send(@RequestParam Long chatId, @RequestParam String message, @RequestParam(required=false) Long llmId, @RequestParam(required=false) Long agentId) {
        LLM llmModel = llmId == null ? (LLM)((Object)this.eruptDao.lambdaQuery(LLM.class).eq(LLM::getDefaultLLM, (Object)true).eq(LLM::getEnable, (Object)true).limit(Integer.valueOf(1)).one()) : (LLM)((Object)this.eruptDao.find(LLM.class, (Object)llmId));
        SseEmitter emitter = new SseEmitter();
        if (llmModel == null) {
            emitter.send((Object)GsonFactory.getGson().toJson((Object)new SseBody("No LLM available")), MediaType.TEXT_EVENT_STREAM);
            emitter.complete();
        } else {
            LlmCore llm = LlmCore.getLLM(llmModel.getLlm());
            ChatMessage chatMessage = ChatMessage.create(chatId, llmModel.getLlm(), llmModel.getModel(), ChatSenderType.USER, message, 0L);
            this.eruptDao.persist((Object)chatMessage);
            Chat chat = (Chat)((Object)this.eruptDao.find(Chat.class, (Object)chatId));
            LLMAgent llmAgent = null;
            if (null != agentId) {
                llmAgent = (LLMAgent)((Object)this.eruptDao.find(LLMAgent.class, (Object)agentId));
            }
            this.llmService.sendSse(MetaContext.get(), llmAgent, emitter, llm, llmModel, chatMessage, this.llmService.geneCompletionPrompt(chat, llmAgent, llmModel.getMaxContext()));
        }
        return emitter;
    }

    @EruptLoginAuth
    @PostMapping(value={"/create_chat"})
    @Transactional
    public R<Long> createChat(@RequestParam String title) {
        Chat chat = new Chat();
        if (title.length() > 100) {
            title = title.substring(0, 100);
        }
        chat.setTitle(title);
        chat.setCreatedTime(LocalDateTime.now());
        chat.setEruptUser(new EruptUserVo(this.eruptUserService.getCurrentUid()));
        this.eruptDao.persist((Object)chat);
        return R.ok((Object)chat.getId());
    }

    @EruptLoginAuth
    @GetMapping(value={"/delete_chat"})
    @Transactional
    public R<Void> deleteChat(@RequestParam Long chatId) {
        Chat chat = (Chat)((Object)this.eruptDao.find(Chat.class, (Object)chatId));
        chat.setDeleted(true);
        return R.ok();
    }

    @EruptLoginAuth
    @GetMapping(value={"/chats"})
    public R<List<Chat>> chats() {
        return R.ok((Object)this.eruptDao.lambdaQuery(Chat.class).with(Chat::getEruptUser).eq(BaseModel::getId, (Object)this.eruptUserService.getCurrentUid()).with().orderByDesc(Chat::getCreatedTime).list());
    }

    @EruptLoginAuth
    @GetMapping(value={"/messages"})
    public R<List<ChatMessage>> messages(@RequestParam Long chatId, @RequestParam Integer size, @RequestParam(defaultValue="1") Integer index) {
        return R.ok((Object)this.eruptDao.lambdaQuery(ChatMessage.class).eq(ChatMessage::getChatId, (Object)chatId).orderByDesc(ChatMessage::getCreatedAt).offset(Integer.valueOf((index - 1) * size)).limit(size).list());
    }
}

