/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.controller;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.ai.annotation.AiParam;
import xyz.erupt.ai.call.AiFunctionCall;
import xyz.erupt.ai.call.AiFunctionManager;
import xyz.erupt.ai.config.AiMCPProp;
import xyz.erupt.ai.util.McpUtil;
import xyz.erupt.ai.vo.OpenAiVo;
import xyz.erupt.core.util.EruptInformation;

@RestController
public class McpController {
    @Resource
    private AiMCPProp mcpProp;
    private static final String MCP_CALL_API = "/mcp/call";

    @GetMapping(value={"/openapi.json"})
    public OpenAiVo eruptAi() {
        OpenAiVo openAiVo = new OpenAiVo();
        OpenAiVo.Info info = new OpenAiVo.Info();
        info.setTitle(this.mcpProp.getName());
        info.setVersion(EruptInformation.getEruptVersion());
        info.setDescription(this.mcpProp.getDescription());
        openAiVo.setInfo(info);
        openAiVo.setServers(new OpenAiVo.Server[]{new OpenAiVo.Server(this.mcpProp.getApiDomain())});
        for (Map.Entry<String, AiFunctionCall> entry : AiFunctionManager.getAiFunctions().entrySet()) {
            OpenAiVo.Path path = new OpenAiVo.Path();
            openAiVo.getPaths().put("/mcp/call/" + entry.getKey(), path);
            OpenAiVo.PathPost post = new OpenAiVo.PathPost();
            path.setPost(post);
            post.setSummary(entry.getValue().description());
            post.setOperationId(entry.getKey());
            ArrayList<String> required = new ArrayList<String>();
            HashMap<String, OpenAiVo.SchemaProperties> properties = new HashMap<String, OpenAiVo.SchemaProperties>();
            for (Field field : entry.getValue().getClass().getDeclaredFields()) {
                AiParam aiParam = field.getDeclaredAnnotation(AiParam.class);
                if (null == aiParam) continue;
                if (aiParam.required()) {
                    required.add(field.getName());
                }
                OpenAiVo.SchemaProperties schemaProperties = new OpenAiVo.SchemaProperties();
                schemaProperties.setType(McpUtil.toMcp(field.getType()));
                schemaProperties.setDescription(aiParam.description());
                properties.put(field.getName(), schemaProperties);
            }
            OpenAiVo.RequestBody requestBody = new OpenAiVo.RequestBody();
            post.setRequestBody(requestBody);
            requestBody.setRequired(!properties.isEmpty());
            OpenAiVo.ApplicationType applicationType = new OpenAiVo.ApplicationType();
            requestBody.getContent().put("application/json", applicationType);
            OpenAiVo.Schema schema = new OpenAiVo.Schema();
            applicationType.setSchema(schema);
            schema.setType("object");
            schema.setRequired(required);
            schema.setProperties(properties);
            OpenAiVo.Response response = new OpenAiVo.Response();
            post.getResponses().put(200, response);
            response.setDescription("Success");
            OpenAiVo.ApplicationType applicationType2 = new OpenAiVo.ApplicationType();
            OpenAiVo.Schema schema2 = new OpenAiVo.Schema();
            schema2.setType(McpUtil.toMcp(String.class));
            schema2.setRequired(new ArrayList<String>());
            applicationType2.setSchema(schema2);
            response.getContent().put("text/plain", applicationType2);
        }
        return openAiVo;
    }

    @PostMapping(value={"/mcp/call/{code}"})
    public String mcpCall(@PathVariable String code, @RequestBody(required=false) Map<String, Object> params) {
        AiFunctionCall aiFunctionCall = AiFunctionManager.getAiFunctions().get(code);
        if (null != params) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Field field = aiFunctionCall.getClass().getDeclaredField(entry.getKey());
                field.setAccessible(true);
                field.set(aiFunctionCall, entry.getValue());
                field.setAccessible(false);
            }
        }
        return aiFunctionCall.call(null);
    }
}

