/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.model;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import xyz.erupt.ai.constants.ChatSenderType;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.ViewType;
import xyz.erupt.core.util.EruptTableStyle;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.linq.lambda.LambdaSee;

@Erupt(name="\u4f1a\u8bdd\u7ba1\u7406", dataProxy={ChatMessage.class})
@Table(name="e_ai_chat_message")
@Entity
@EruptI18n
public class ChatMessage
extends BaseModel
implements DataProxy<ChatMessage> {
    private Long chatId;
    private String llm;
    private String model;
    @EruptField(views={@View(title="\u53d1\u9001\u4eba")})
    @Enumerated(value=EnumType.STRING)
    private ChatSenderType senderType;
    @EruptField(views={@View(title="\u53d1\u9001\u5185\u5bb9", type=ViewType.HTML)})
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String content;
    @EruptField(views={@View(title="\u53d1\u9001\u65f6\u95f4", type=ViewType.HTML)})
    private LocalDateTime createdAt;
    private Long tokens;

    public static ChatMessage create(Long chatId, String llm, String model, ChatSenderType senderType, String content, Long tokens) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setChatId(chatId);
        chatMessage.setLlm(llm);
        chatMessage.setModel(model);
        chatMessage.setSenderType(senderType);
        chatMessage.setContent(content);
        chatMessage.setCreatedAt(LocalDateTime.now());
        chatMessage.setTokens(tokens);
        return chatMessage;
    }

    public void afterFetch(Collection<Map<String, Object>> list) {
        String senderType = LambdaSee.field(ChatMessage::getSenderType);
        for (Map<String, Object> map : list) {
            if (map.get(senderType) != ChatSenderType.MODEL) continue;
            EruptTableStyle.cellColor(map, (String)senderType, (String)"#09f");
        }
    }

    public Long getChatId() {
        return this.chatId;
    }

    public String getLlm() {
        return this.llm;
    }

    public String getModel() {
        return this.model;
    }

    public ChatSenderType getSenderType() {
        return this.senderType;
    }

    public String getContent() {
        return this.content;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Long getTokens() {
        return this.tokens;
    }

    public void setChatId(Long chatId) {
        this.chatId = chatId;
    }

    public void setLlm(String llm) {
        this.llm = llm;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSenderType(ChatSenderType senderType) {
        this.senderType = senderType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setTokens(Long tokens) {
        this.tokens = tokens;
    }
}

