/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import xyz.erupt.ai.core.LlmConfig;
import xyz.erupt.ai.core.LlmCore;
import xyz.erupt.ai.core.LlmRequest;
import xyz.erupt.ai.model.LLMDataProxy;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.ViewType;
import xyz.erupt.annotation.sub_field.sub_edit.BoolType;
import xyz.erupt.annotation.sub_field.sub_edit.ChoiceType;
import xyz.erupt.annotation.sub_field.sub_edit.CodeEditorType;
import xyz.erupt.annotation.sub_field.sub_edit.Search;
import xyz.erupt.annotation.sub_field.sub_edit.SliderType;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.jpa.model.MetaModelUpdateVo;

@Erupt(name="\u5927\u8bed\u8a00\u6a21\u578b", dataProxy={LLMDataProxy.class}, orderBy="sort", rowOperation={@RowOperation(title="\u5bf9\u8bdd\u6d4b\u8bd5", icon="fa fa-comments", tpl=@Tpl(path="/tpl/llm-chat.ftl", height="85vh", tplHandler=LLMDataProxy.class), mode=RowOperation.Mode.SINGLE, type=RowOperation.Type.TPL), @RowOperation(title="\u9ed8\u8ba4\u5bf9\u8bdd\u6a21\u578b", icon="fa fa-magic", ifExpr="item.defaultLLM == '\u00d7'", mode=RowOperation.Mode.SINGLE, operationHandler=LLMDataProxy.class)})
@Table(name="e_ai_llm")
@Entity
@EruptI18n
public class LLM
extends MetaModelUpdateVo {
    @EruptField(views={@View(title="\u6a21\u578b\u540d\u79f0")}, edit=@Edit(title="\u6a21\u578b\u540d\u79f0", notNull=true, search=@Search(vague=true)))
    private String name;
    @EruptField(views={@View(title="\u5927\u8bed\u8a00\u6a21\u578b")}, edit=@Edit(title="\u5927\u8bed\u8a00\u6a21\u578b", type=EditType.CHOICE, notNull=true, search=@Search, choiceType=@ChoiceType(fetchHandler={LlmCore.H.class}, trigger=LLMDataProxy.class)))
    private String llm;
    @EruptField(views={@View(title="\u6a21\u578b\u7248\u672c")}, edit=@Edit(title="\u6a21\u578b\u7248\u672c", notNull=true, search=@Search(vague=true)))
    private String model;
    @Column(length=2000)
    @EruptField(views={@View(title="API \u57df\u540d")}, edit=@Edit(title="API \u57df\u540d", notNull=true))
    private String apiUrl;
    @EruptField(views={@View(title="API Key", type=ViewType.HTML, width="80px")}, edit=@Edit(title="API Key"))
    private String apiKey;
    @EruptField(views={@View(title="\u4e0a\u4e0b\u6587\u8bb0\u5fc6\u8f6e\u6b21")}, edit=@Edit(title="\u4e0a\u4e0b\u6587\u8bb0\u5fc6\u8f6e\u6b21", notNull=true, type=EditType.SLIDER, sliderType=@SliderType(max=100)))
    private Integer maxContext = 20;
    @EruptField(views={@View(title="\u72b6\u6001", sortable=true)}, edit=@Edit(title="\u72b6\u6001", search=@Search, type=EditType.BOOLEAN, notNull=true, boolType=@BoolType(trueText="\u6fc0\u6d3b", falseText="\u9501\u5b9a")))
    private Boolean enable = true;
    @EruptField(views={@View(title="\u9ed8\u8ba4\u5bf9\u8bdd\u6a21\u578b")}, edit=@Edit(title="\u9ed8\u8ba4\u5bf9\u8bdd\u6a21\u578b", show=false, boolType=@BoolType(trueText="\u2713", falseText="\u00d7")))
    private Boolean defaultLLM = false;
    @EruptField(views={@View(title="\u4f7f\u7528\u987a\u5e8f", sortable=true)}, edit=@Edit(title="\u4f7f\u7528\u987a\u5e8f", notNull=true))
    private Integer sort = 0;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @EruptField(views={@View(title="\u6a21\u578b\u914d\u7f6e")}, edit=@Edit(title="\u6a21\u578b\u914d\u7f6e", type=EditType.CODE_EDITOR, notNull=true, codeEditType=@CodeEditorType(language="json")))
    private String config;
    @Column(length=2000)
    @EruptField(views={@View(title="\u5907\u6ce8", type=ViewType.HTML)}, edit=@Edit(title="\u5907\u6ce8", type=EditType.TEXTAREA))
    private String remark;

    public LlmRequest toLlmRequest() {
        LlmConfig llmConfig = (LlmConfig)GsonFactory.getGson().fromJson(this.config, LlmConfig.class);
        LlmRequest llmRequest = llmConfig.toLlmRequest();
        llmRequest.setUrl(this.apiUrl);
        llmRequest.setApiKey(this.apiKey);
        llmRequest.setModel(this.model);
        return llmRequest;
    }

    public String getName() {
        return this.name;
    }

    public String getLlm() {
        return this.llm;
    }

    public String getModel() {
        return this.model;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Integer getMaxContext() {
        return this.maxContext;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Boolean getDefaultLLM() {
        return this.defaultLLM;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getConfig() {
        return this.config;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLlm(String llm) {
        this.llm = llm;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setMaxContext(Integer maxContext) {
        this.maxContext = maxContext;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setDefaultLLM(Boolean defaultLLM) {
        this.defaultLLM = defaultLLM;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

