/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import xyz.erupt.ai.config.AiProp;
import xyz.erupt.ai.core.LlmCore;
import xyz.erupt.ai.model.LLM;
import xyz.erupt.annotation.fun.ChoiceTrigger;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.linq.lambda.LambdaSee;

@Component
public class LLMDataProxy
implements DataProxy<LLM>,
Tpl.TplHandler,
ChoiceTrigger,
OperationHandler<LLM, Void> {
    @Resource
    private EruptDao eruptDao;
    @Resource
    private AiProp aiProp;
    public static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();

    public void beforeAdd(LLM llm) {
        llm.setDefaultLLM(this.eruptDao.lambdaQuery(LLM.class).count() == 0L);
    }

    public void bindTplData(Map<String, Object> binding, String[] params) {
        binding.put("x", this.aiProp);
    }

    public Map<String, Object> trigger(Object code, String[] params) {
        if (null != code && !"null".equals(code)) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put(LambdaSee.field(LLM::getModel), LlmCore.getLLM(code.toString()).model());
            ret.put(LambdaSee.field(LLM::getApiUrl), LlmCore.getLLM(code.toString()).api());
            ret.put(LambdaSee.field(LLM::getApiKey), "");
            ret.put(LambdaSee.field(LLM::getConfig), gson.toJson((Object)LlmCore.getLLM(code.toString()).config()));
            return ret;
        }
        return Collections.emptyMap();
    }

    @Transactional
    public String exec(List<LLM> data, Void o, String[] param) {
        for (LLM llm : this.eruptDao.lambdaQuery(LLM.class).eq(LLM::getDefaultLLM, (Object)true).list()) {
            llm.setDefaultLLM(false);
            this.eruptDao.merge((Object)llm);
        }
        ((LLM)((Object)this.eruptDao.find(LLM.class, (Object)data.get(0).getId()))).setDefaultLLM(true);
        return "";
    }
}

