/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import xyz.erupt.ai.call.AiFunctionManager;
import xyz.erupt.ai.config.AiProp;
import xyz.erupt.ai.constants.ChatSenderType;
import xyz.erupt.ai.constants.MessageRole;
import xyz.erupt.ai.core.LlmCore;
import xyz.erupt.ai.core.LlmRequest;
import xyz.erupt.ai.handler.EruptPromptHandler;
import xyz.erupt.ai.model.Chat;
import xyz.erupt.ai.model.ChatMessage;
import xyz.erupt.ai.model.LLM;
import xyz.erupt.ai.model.LLMAgent;
import xyz.erupt.ai.pojo.ChatCompletionMessage;
import xyz.erupt.ai.vo.SseBody;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.jpa.dao.EruptDao;

@Service
public class LLMService {
    private static final Logger log = LoggerFactory.getLogger(LLMService.class);
    @Resource
    private AiProp aiProp;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private AiFunctionManager aiFunctionManager;
    private static final int MESSAGE_TS = 100;

    public String send(String prompt) {
        return this.send(prompt, Collections.emptyList());
    }

    public String send(String prompt, List<ChatCompletionMessage> assistantPrompt) {
        return this.send((LLM)((Object)this.eruptDao.lambdaQuery(LLM.class).eq(LLM::getDefaultLLM, (Object)true).eq(LLM::getEnable, (Object)true).limit(Integer.valueOf(1)).one()), prompt, assistantPrompt);
    }

    public String send(LLM llm, String prompt) {
        return this.send(llm, prompt, Collections.emptyList());
    }

    public String send(LLM llmConfig, String prompt, List<ChatCompletionMessage> assistantPrompt) {
        if (null == llmConfig) {
            throw new EruptWebApiRuntimeException("Not found LLM config");
        }
        return LlmCore.getLLM(llmConfig.getLlm()).chat(llmConfig.toLlmRequest(), prompt, assistantPrompt).getMessageStr();
    }

    public List<ChatCompletionMessage> geneCompletionPrompt(Chat chat, LLMAgent llmAgent, Integer contextTurn) {
        ArrayList<ChatCompletionMessage> chatCompletionMessages = new ArrayList<ChatCompletionMessage>();
        chatCompletionMessages.add(new ChatCompletionMessage(MessageRole.system, this.aiProp.getSystemPrompt()));
        if (null != llmAgent) {
            if (null == llmAgent.getPromptHandler()) {
                chatCompletionMessages.add(new ChatCompletionMessage(MessageRole.system, llmAgent.getPrompt()));
            } else {
                chatCompletionMessages.add(new ChatCompletionMessage(MessageRole.system, ((EruptPromptHandler)EruptSpringUtil.getBeanByPath((String)llmAgent.getPromptHandler(), EruptPromptHandler.class)).handle(llmAgent.getPrompt())));
            }
        } else {
            chatCompletionMessages.add(new ChatCompletionMessage(MessageRole.system, this.aiFunctionManager.getFunctionCallPrompt()));
        }
        List chatMessages = this.eruptDao.lambdaQuery(ChatMessage.class).eq(ChatMessage::getChatId, (Object)chat.getId()).isNotNull(ChatMessage::getContent).orderByDesc(ChatMessage::getCreatedAt).limit(Integer.valueOf(contextTurn + 1)).list();
        Collections.reverse(chatMessages);
        chatMessages.forEach(it -> chatCompletionMessages.add(new ChatCompletionMessage(it.getSenderType() == ChatSenderType.USER ? MessageRole.user : MessageRole.assistant, it.getContent())));
        return chatCompletionMessages;
    }

    @Async
    @Transactional
    public void sendSse(MetaContext metaContext, LLMAgent llmAgent, SseEmitter emitter, LlmCore llm, LLM llmModal, ChatMessage chatMessage, List<ChatCompletionMessage> completionMessage) {
        try {
            MetaContext.set((MetaContext)metaContext);
            LlmRequest llmRequest = llmModal.toLlmRequest();
            if (null != llmAgent) {
                llmAgent.mergeToLLmRequest(llmModal);
            }
            llm.chatSse(llmRequest, chatMessage.getContent(), completionMessage, it -> {
                if (it.isFinish()) {
                    String msg = it.getOutput().toString();
                    if (it.getOutput().toString().length() <= 100 || it.isError()) {
                        msg = this.sendMessage(emitter, it.getOutput().toString(), llmModal, chatMessage, completionMessage);
                    }
                    chatMessage.setTokens(Long.valueOf(it.getUsage().getPrompt_tokens()));
                    this.eruptDao.mergeAndFlush((Object)chatMessage);
                    this.eruptDao.persistAndFlush((Object)ChatMessage.create(chatMessage.getChatId(), llmModal.getLlm(), llmModal.getModel(), ChatSenderType.MODEL, msg, Long.valueOf(it.getUsage().getCompletion_tokens())));
                    emitter.complete();
                } else if (it.getOutput().toString().length() > 100) {
                    if (it.isPending()) {
                        this.sendMessage(emitter, it.getOutput().toString(), llmModal, chatMessage, completionMessage);
                        it.setPending(false);
                    } else {
                        this.sendMessage(emitter, it.getCurrMessage(), llmModal, chatMessage, completionMessage);
                    }
                } else {
                    it.setPending(true);
                }
            });
        }
        catch (Exception e) {
            this.eruptDao.persistAndFlush((Object)ChatMessage.create(chatMessage.getChatId(), llmModal.getLlm(), llmModal.getModel(), ChatSenderType.MODEL, e.getMessage(), 0L));
            emitter.send((Object)GsonFactory.getGson().toJson((Object)new SseBody(e.getMessage())), MediaType.TEXT_EVENT_STREAM);
            emitter.complete();
        }
    }

    private String sendMessage(SseEmitter emitter, String userMessage, LLM llm, ChatMessage chatMessage, List<ChatCompletionMessage> userContext) {
        if (this.aiFunctionManager.exist(userMessage.trim())) {
            String functionMessage = this.aiFunctionManager.call(userMessage, llm, chatMessage.getContent(), userContext);
            try {
                emitter.send((Object)GsonFactory.getGson().toJson((Object)new SseBody(functionMessage)), MediaType.TEXT_EVENT_STREAM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return functionMessage;
        }
        try {
            emitter.send((Object)GsonFactory.getGson().toJson((Object)new SseBody(userMessage)), MediaType.TEXT_EVENT_STREAM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userMessage;
    }
}

