/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import xyz.erupt.ai.model.LLM;
import xyz.erupt.ai.model.LLMAgent;
import xyz.erupt.core.annotation.EruptScan;
import xyz.erupt.core.module.EruptModule;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.module.ModuleInfo;
import xyz.erupt.upms.prop.EruptAppProp;

@Configuration
@ComponentScan
@EruptScan
@EntityScan
@EnableConfigurationProperties
@EnableAsync
public class EruptAiAutoConfiguration
implements EruptModule {
    @Resource
    private EruptAppProp eruptAppProp;

    @PostConstruct
    public void post() {
        this.eruptAppProp.registerProp("erupt-ai", (Object)true);
    }

    public ModuleInfo info() {
        return ModuleInfo.builder().name("erupt-ai").build();
    }

    public void run() {
        super.run();
    }

    public List<MetaMenu> initMenus() {
        ArrayList<MetaMenu> menus = new ArrayList<MetaMenu>();
        menus.add(MetaMenu.createRootMenu((String)"$ai", (String)"\u5927\u6a21\u578b\u7ba1\u7406", (String)"fa fa-rocket", (Integer)25));
        menus.add(MetaMenu.createEruptClassMenu(LLM.class, (MetaMenu)((MetaMenu)menus.get(0)), (Integer)10));
        menus.add(MetaMenu.createEruptClassMenu(LLMAgent.class, (MetaMenu)((MetaMenu)menus.get(0)), (Integer)20));
        return menus;
    }

    static {
        EruptModuleInvoke.addEruptModule(EruptAiAutoConfiguration.class);
    }
}

