/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import xyz.erupt.ai.constants.MessageRole;
import xyz.erupt.ai.core.LlmCore;
import xyz.erupt.ai.core.LlmRequest;
import xyz.erupt.ai.core.SseListener;
import xyz.erupt.ai.pojo.ChatCompletion;
import xyz.erupt.ai.pojo.ChatCompletionMessage;
import xyz.erupt.ai.pojo.ChatCompletionResponse;
import xyz.erupt.ai.pojo.ChatCompletionStreamResponse;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.context.MetaContext;

@Component
public abstract class OpenAi
extends LlmCore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenAi.class);
    private final Gson gson = new GsonBuilder().create();

    public String chatApiPath() {
        return "/v1/chat/completions";
    }

    @Override
    public ChatCompletionResponse chat(LlmRequest llmRequest, String userPrompt, List<ChatCompletionMessage> assistantPrompt) {
        ChatCompletionResponse chatCompletionResponse;
        block9: {
            assistantPrompt.add(new ChatCompletionMessage(MessageRole.user, userPrompt));
            ChatCompletion completion = ChatCompletion.builder().model(llmRequest.getModel()).stream(false).messages(assistantPrompt).build();
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((String)this.gson.toJson((Object)completion), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
            Request request = new Request.Builder().url(llmRequest.getUrl() + this.chatApiPath()).post(body).addHeader("Authorization", "Bearer " + llmRequest.getApiKey()).build();
            Response response = client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Failed to get response from server: " + response.body());
                }
                chatCompletionResponse = (ChatCompletionResponse)GsonFactory.getGson().fromJson(null == response.body() ? null : response.body().string(), ChatCompletionResponse.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to execute HTTP request", e);
                }
            }
            response.close();
        }
        return chatCompletionResponse;
    }

    @Override
    public void chatSse(final LlmRequest llmRequest, String userPrompt, List<ChatCompletionMessage> assistantPrompt, final Consumer<SseListener> listener) {
        ChatCompletion completion = ChatCompletion.builder().model(llmRequest.getModel()).messages(assistantPrompt).stream(true).build();
        completion.setResponse_format((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("type", String.valueOf((Object)llmRequest.getResponseFormat()));
            }
        });
        completion.setTopP(llmRequest.getTop_p());
        completion.setTemperature(llmRequest.getTemperature());
        OkHttpClient client = new OkHttpClient();
        RequestBody body = RequestBody.create((String)this.gson.toJson((Object)completion), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(llmRequest.getUrl() + this.chatApiPath()).post(body).addHeader("Accept", "text/event-stream").addHeader("Authorization", "Bearer " + llmRequest.getApiKey()).build();
        final MetaContext metaContext = MetaContext.get();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                if (call == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                log.error("Failed to get response from server", (Throwable)e);
                SseListener sseListener = new SseListener();
                sseListener.setError(true);
                sseListener.setFinish(true);
                sseListener.getOutput().append(e.getMessage());
                sseListener.setCurrMessage(e.getMessage());
                listener.accept(sseListener);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (call == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (response == null) {
                    2.$$$reportNull$$$0(3);
                }
                MetaContext.set((MetaContext)metaContext);
                try (ResponseBody responseBody = response.body();){
                    if (responseBody != null) {
                        BufferedSource source = responseBody.source();
                        SseListener sseListener = new SseListener();
                        while (!source.exhausted()) {
                            String line = source.readUtf8Line();
                            if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                            if (!response.isSuccessful()) {
                                this.onFailure(call, new IOException(line));
                                continue;
                            }
                            try {
                                if (line.startsWith("data: ")) {
                                    line = line.substring(6);
                                }
                                if ("[DONE]".equalsIgnoreCase(line)) {
                                    sseListener.setFinish(true);
                                    listener.accept(sseListener);
                                    continue;
                                }
                                ChatCompletionStreamResponse chatCompletionStreamResponse = (ChatCompletionStreamResponse)GsonFactory.getGson().fromJson(line, ChatCompletionStreamResponse.class);
                                sseListener.setCurrData(line);
                                StringBuilder sb = new StringBuilder();
                                for (ChatCompletionStreamResponse.Choice choice : chatCompletionStreamResponse.getChoices()) {
                                    if (null != choice.getUsage()) {
                                        sseListener.setUsage(sseListener.getUsage().plus(choice.getUsage()));
                                    }
                                    if (choice.getDelta() == null || choice.getDelta().getContent() == null) continue;
                                    sseListener.getOutput().append(choice.getDelta().getContent());
                                    sb.append(choice.getDelta().getContent());
                                }
                                sseListener.setCurrMessage(sb.toString());
                                listener.accept(sseListener);
                            }
                            catch (Exception e) {
                                this.onFailure(call, new IOException(e));
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "response";
                        break;
                    }
                }
                objectArray2[1] = "xyz/erupt/ai/core/OpenAi$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFailure";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

