/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import xyz.erupt.ai.constants.ChatSenderType;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.ViewType;
import xyz.erupt.core.util.EruptTableStyle;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.linq.lambda.LambdaSee;

@Erupt(name="\u4f1a\u8bdd\u7ba1\u7406", dataProxy={ChatMessage.class})
@Table(name="e_ai_chat_message")
@Entity
@EruptI18n
public class ChatMessage
extends BaseModel
implements DataProxy<ChatMessage> {
    private Long chatId;
    private String llm;
    private String model;
    @EruptField(views={@View(title="\u53d1\u9001\u4eba")})
    @Enumerated(value=EnumType.STRING)
    @Column(columnDefinition="varchar(100)")
    private ChatSenderType senderType;
    @EruptField(views={@View(title="\u53d1\u9001\u5185\u5bb9", type=ViewType.HTML)})
    @Column(length=0xA00000)
    private String content;
    @EruptField(views={@View(title="\u53d1\u9001\u65f6\u95f4", type=ViewType.HTML)})
    private LocalDateTime createdAt;
    private Long tokens;

    public static ChatMessage create(Long chatId, String llm, String model, ChatSenderType senderType, String content, Long tokens) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setChatId(chatId);
        chatMessage.setLlm(llm);
        chatMessage.setModel(model);
        chatMessage.setSenderType(senderType);
        chatMessage.setContent(content);
        chatMessage.setCreatedAt(LocalDateTime.now());
        chatMessage.setTokens(tokens);
        return chatMessage;
    }

    public void afterFetch(Collection<Map<String, Object>> list) {
        String senderType = LambdaSee.field(ChatMessage::getSenderType);
        for (Map<String, Object> map : list) {
            if (map.get(senderType) != ChatSenderType.MODEL) continue;
            EruptTableStyle.cellColor(map, (String)senderType, (String)"#09f");
        }
    }

    @Generated
    public Long getChatId() {
        return this.chatId;
    }

    @Generated
    public String getLlm() {
        return this.llm;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public ChatSenderType getSenderType() {
        return this.senderType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Long getTokens() {
        return this.tokens;
    }

    @Generated
    public void setChatId(Long chatId) {
        this.chatId = chatId;
    }

    @Generated
    public void setLlm(String llm) {
        this.llm = llm;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setSenderType(ChatSenderType senderType) {
        this.senderType = senderType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setTokens(Long tokens) {
        this.tokens = tokens;
    }

    @Generated
    public ChatMessage() {
    }
}

