/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.ai.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import xyz.erupt.ai.core.LlmConfig;
import xyz.erupt.ai.core.LlmRequest;
import xyz.erupt.ai.handler.DynamicPromptFetch;
import xyz.erupt.ai.model.LLM;
import xyz.erupt.ai.model.LLMDataProxy;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.ChoiceType;
import xyz.erupt.annotation.sub_field.sub_edit.CodeEditorType;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.jpa.model.MetaModelUpdateVo;

@Erupt(name="\u667a\u80fd\u4f53", dataProxy={LLMAgent.class})
@Table(name="e_ai_llm_agent")
@Entity
@EruptI18n
public class LLMAgent
extends MetaModelUpdateVo
implements DataProxy<LLMAgent> {
    @EruptField(views={@View(title="\u540d\u79f0")}, edit=@Edit(title="\u540d\u79f0", notNull=true))
    private String name;
    @EruptField(views={@View(title="\u662f\u5426\u542f\u7528")}, edit=@Edit(title="\u662f\u5426\u542f\u7528", notNull=true))
    private Boolean enable = true;
    @EruptField(views={@View(title="\u63d0\u793a\u8bcd\u5904\u7406\u5668")}, edit=@Edit(title="\u63d0\u793a\u8bcd\u5904\u7406\u5668", type=EditType.CHOICE, choiceType=@ChoiceType(fetchHandler={DynamicPromptFetch.class})))
    @JsonIgnore
    private String promptHandler;
    @Column(length=0xA00000)
    @EruptField(views={@View(title="\u667a\u80fd\u4f53\u53c2\u6570")}, edit=@Edit(title="\u667a\u80fd\u4f53\u53c2\u6570", type=EditType.CODE_EDITOR, notNull=true, codeEditType=@CodeEditorType(language="json")))
    @JsonIgnore
    private String config;
    @JsonIgnore
    @Column(length=0xA00000)
    @EruptField(views={@View(title="\u63d0\u793a\u8bcd")}, edit=@Edit(title="\u63d0\u793a\u8bcd", type=EditType.CODE_EDITOR, codeEditType=@CodeEditorType(language="python")))
    private String prompt;
    @Column(length=2000)
    @EruptField(views={@View(title="\u80fd\u529b\u63cf\u8ff0")}, edit=@Edit(title="\u80fd\u529b\u63cf\u8ff0", type=EditType.TEXTAREA))
    private String remark;

    public void addBehavior(LLMAgent llmAgent) {
        llmAgent.setConfig(LLMDataProxy.gson.toJson((Object)new LlmConfig()));
    }

    public void mergeToLLmRequest(LLM llm) {
        LlmRequest llmRequest = llm.toLlmRequest();
        LlmConfig llmConfig = (LlmConfig)GsonFactory.getGson().fromJson(this.config, LlmConfig.class);
        BeanUtils.copyProperties((Object)llmConfig, (Object)llmRequest);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getPromptHandler() {
        return this.promptHandler;
    }

    @Generated
    public String getConfig() {
        return this.config;
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public String getRemark() {
        return this.remark;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setPromptHandler(String promptHandler) {
        this.promptHandler = promptHandler;
    }

    @Generated
    public void setConfig(String config) {
        this.config = config;
    }

    @Generated
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Generated
    public void setRemark(String remark) {
        this.remark = remark;
    }
}

