/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.dao;

import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.config.Comment;
import xyz.erupt.jpa.dao.EruptLambdaQuery;
import xyz.erupt.jpa.service.EntityManagerService;

@Component
public class EruptDao {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EntityManagerService entityManagerService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Deprecated
    public <T> T findById(Class<T> clazz, Object id) {
        this.entityManager.clear();
        return (T)this.entityManager.find(clazz, id);
    }

    public <T> T find(Class<T> clazz, Object id) {
        return (T)this.entityManager.find(clazz, id);
    }

    public void detach(Object obj) {
        this.entityManager.detach(obj);
    }

    public void persist(Object obj) {
        this.entityManager.persist(obj);
    }

    @Transactional
    public void persistAndFlush(Object obj) {
        this.persist(obj);
        this.flush();
    }

    public <T> T merge(T t) {
        return (T)this.entityManager.merge(t);
    }

    @Transactional
    public <T> T mergeAndFlush(T t) {
        try {
            T t2 = this.merge(t);
            return t2;
        }
        finally {
            this.flush();
        }
    }

    public void delete(Object obj) {
        if (this.entityManager.contains(obj)) {
            this.entityManager.remove(obj);
        } else {
            this.entityManager.remove(this.entityManager.merge(obj));
        }
    }

    @Transactional
    public void deleteAndFlush(Object obj) {
        try {
            this.delete(obj);
        }
        finally {
            this.flush();
        }
    }

    public void flush() {
        this.entityManager.flush();
    }

    @Comment(value="\u6839\u636e\u6570\u636e\u6e90\u540d\u79f0\u83b7\u53d6 EntityManager \u6ce8\u610f\uff1a\u5fc5\u987b\u624b\u52a8\u6267\u884c entityManager.close() \u65b9\u6cd5")
    public EntityManager getEntityManager(String name) {
        return this.entityManagerService.findEntityManager(name);
    }

    public <T> EruptLambdaQuery<T> lambdaQuery(Class<T> eruptClass) {
        return new EruptLambdaQuery<T>(this.entityManager, eruptClass);
    }

    public <T> EruptLambdaQuery<T> lambdaQuery(EntityManager entityManager, Class<T> eruptClass) {
        return new EruptLambdaQuery<T>(entityManager, eruptClass);
    }

    public <T> T persistIfNotExist(Class<T> eruptClass, T obj, String field, final String val) throws NonUniqueResultException {
        T t = this.lambdaQuery(eruptClass).addCondition(field + " = :val", (Map<String, Object>)new HashMap<String, Object>(1){
            {
                super(initialCapacity);
                this.put("val", val);
            }
        }).one();
        if (null == t) {
            this.entityManager.persist(obj);
            this.entityManager.flush();
            return obj;
        }
        return t;
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }
}

