/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.controller;

import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptInformation;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.monitor.vo.Platform;
import xyz.erupt.monitor.vo.Server;

@RestController
@RequestMapping(value={"/erupt-api/erupt-monitor/server.html"})
public class MonitorServerController {
    @Resource
    private EruptProp eruptProp;

    @GetMapping(value={"/info"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.MENU)
    public Server info(Boolean waitCpu) {
        return new Server(waitCpu);
    }

    @GetMapping(value={"/platform"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.MENU)
    public Platform getPlatformInfo() {
        Platform platform = new Platform();
        AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
        platform.setUploadPath(null == attachmentProxy ? this.eruptProp.getUploadPath() : attachmentProxy.fileDomain());
        platform.setSessionStrategy(this.eruptProp.isRedisSession() ? "redis" : "servlet");
        platform.setEruptCount(EruptCoreService.getErupts().size());
        platform.setEruptModules(EruptCoreService.getModules());
        platform.setEruptVersion(EruptInformation.getEruptVersion());
        return platform;
    }
}

