/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.text.DecimalFormat;
import lombok.Generated;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import xyz.erupt.monitor.util.SystemUtil;

public class Mem {
    private String total;
    private String used;
    private String free;
    private String usage;

    Mem(SystemInfo systemInfo) {
        GlobalMemory memory = systemInfo.getHardware().getMemory();
        long totalByte = memory.getTotal();
        long availableByte = memory.getAvailable();
        this.setTotal(SystemUtil.formatByte(totalByte));
        this.setUsed(SystemUtil.formatByte(totalByte - availableByte));
        this.setFree(SystemUtil.formatByte(availableByte));
        this.setUsage(new DecimalFormat("#.##%").format((double)(totalByte - availableByte) * 1.0 / (double)totalByte));
    }

    @Generated
    public String getTotal() {
        return this.total;
    }

    @Generated
    public String getUsed() {
        return this.used;
    }

    @Generated
    public String getFree() {
        return this.free;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public void setTotal(String total) {
        this.total = total;
    }

    @Generated
    public void setUsed(String used) {
        this.used = used;
    }

    @Generated
    public void setFree(String free) {
        this.free = free;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }
}

