/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.monitor.vo.Cpu;
import xyz.erupt.monitor.vo.Gpu;
import xyz.erupt.monitor.vo.Jvm;
import xyz.erupt.monitor.vo.Mem;
import xyz.erupt.monitor.vo.Sys;
import xyz.erupt.monitor.vo.SysFile;

public class Server {
    private Cpu cpu;
    private Mem mem;
    private Jvm jvm;
    private Sys sys;
    private List<Gpu> gpus;
    private List<SysFile> sysFiles;
    private Date startupDate;
    private String runDay;

    public Server(Boolean waitCpu) {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        this.setCpu(new Cpu(si, waitCpu));
        this.setMem(new Mem(si));
        this.setJvm(new Jvm());
        this.setSys(new Sys());
        this.setGpus(si.getHardware().getGraphicsCards().stream().map(Gpu::new).collect(Collectors.toList()));
        this.setSysFiles(os.getFileSystem().getFileStores().stream().map(SysFile::new).collect(Collectors.toList()));
        long startupDate = EruptSpringUtil.getApplicationContext().getStartupDate();
        this.setStartupDate(new Date(startupDate));
        this.setRunDay(this.zhDateDiff(this.getStartupDate()));
    }

    private String zhDateDiff(Date date) {
        long l = System.currentTimeMillis() - date.getTime();
        long days = l / 86400000L;
        long hours = l / 3600000L - days * 24L;
        long mins = l / 60000L - days * 24L * 60L - hours * 60L;
        return String.format("%s%s%s", days > 0L ? days + " days " : "", hours > 0L ? hours + " hours " : "", mins + " minutes").trim();
    }

    @Generated
    public Cpu getCpu() {
        return this.cpu;
    }

    @Generated
    public Mem getMem() {
        return this.mem;
    }

    @Generated
    public Jvm getJvm() {
        return this.jvm;
    }

    @Generated
    public Sys getSys() {
        return this.sys;
    }

    @Generated
    public List<Gpu> getGpus() {
        return this.gpus;
    }

    @Generated
    public List<SysFile> getSysFiles() {
        return this.sysFiles;
    }

    @Generated
    public Date getStartupDate() {
        return this.startupDate;
    }

    @Generated
    public String getRunDay() {
        return this.runDay;
    }

    @Generated
    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setMem(Mem mem) {
        this.mem = mem;
    }

    @Generated
    public void setJvm(Jvm jvm) {
        this.jvm = jvm;
    }

    @Generated
    public void setSys(Sys sys) {
        this.sys = sys;
    }

    @Generated
    public void setGpus(List<Gpu> gpus) {
        this.gpus = gpus;
    }

    @Generated
    public void setSysFiles(List<SysFile> sysFiles) {
        this.sysFiles = sysFiles;
    }

    @Generated
    public void setStartupDate(Date startupDate) {
        this.startupDate = startupDate;
    }

    @Generated
    public void setRunDay(String runDay) {
        this.runDay = runDay;
    }
}

