/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo.redis;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import xyz.erupt.monitor.vo.redis.RedisCmdStat;

public class RedisInfo {
    private String version;
    private String port;
    private String day;
    private String clientNum;
    private String totalMem;
    private String usedMem;
    private Long keyNum;
    private boolean isCluster;
    private boolean isAOF;
    private List<RedisCmdStat> redisCmdStat;

    public RedisInfo(RedisConnectionFactory redisConnectionFactory) {
        RedisConnection redisConnection = redisConnectionFactory.getConnection();
        Optional.of(redisConnection.info("commandstats")).ifPresent(commandStats -> {
            String cs = "cmdstat_";
            this.redisCmdStat = commandStats.stringPropertyNames().stream().filter(it -> it.startsWith(cs)).map(it -> new RedisCmdStat(StringUtils.removeStart((String)it, (String)cs), StringUtils.substringBetween((String)commandStats.getProperty((String)it), (String)"calls=", (String)",usec"))).collect(Collectors.toList());
        });
        Optional.of(redisConnection.info()).ifPresent(properties -> {
            String aofEnabled;
            this.setKeyNum(redisConnection.serverCommands().dbSize());
            this.setVersion(properties.getProperty("redis_version"));
            this.setUsedMem(properties.getProperty("used_memory_human"));
            if ("0".equals(properties.getProperty("maxmemory"))) {
                this.setTotalMem(properties.getProperty("total_system_memory_human"));
            } else {
                this.setTotalMem(properties.getProperty("maxmemory_human"));
            }
            this.setPort(properties.getProperty("tcp_port"));
            this.setDay(properties.getProperty("uptime_in_days"));
            this.setClientNum(properties.getProperty("connected_clients"));
            this.setPort(properties.getProperty("tcp_port"));
            String clusterEnabled = properties.getProperty("cluster_enabled");
            if (null != clusterEnabled) {
                this.setCluster(Integer.parseInt(clusterEnabled) > 0);
            }
            if (null != (aofEnabled = properties.getProperty("aof_enabled"))) {
                this.setAOF(Integer.parseInt(aofEnabled) != 0);
            }
        });
        redisConnection.close();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getDay() {
        return this.day;
    }

    @Generated
    public String getClientNum() {
        return this.clientNum;
    }

    @Generated
    public String getTotalMem() {
        return this.totalMem;
    }

    @Generated
    public String getUsedMem() {
        return this.usedMem;
    }

    @Generated
    public Long getKeyNum() {
        return this.keyNum;
    }

    @Generated
    public boolean isCluster() {
        return this.isCluster;
    }

    @Generated
    public boolean isAOF() {
        return this.isAOF;
    }

    @Generated
    public List<RedisCmdStat> getRedisCmdStat() {
        return this.redisCmdStat;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setDay(String day) {
        this.day = day;
    }

    @Generated
    public void setClientNum(String clientNum) {
        this.clientNum = clientNum;
    }

    @Generated
    public void setTotalMem(String totalMem) {
        this.totalMem = totalMem;
    }

    @Generated
    public void setUsedMem(String usedMem) {
        this.usedMem = usedMem;
    }

    @Generated
    public void setKeyNum(Long keyNum) {
        this.keyNum = keyNum;
    }

    @Generated
    public void setCluster(boolean isCluster) {
        this.isCluster = isCluster;
    }

    @Generated
    public void setAOF(boolean isAOF) {
        this.isAOF = isAOF;
    }

    @Generated
    public void setRedisCmdStat(List<RedisCmdStat> redisCmdStat) {
        this.redisCmdStat = redisCmdStat;
    }
}

