/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.service;

import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.tl.RequestBodyTL;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.log.EruptOperateLog;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.util.IpUtil;

@Service
public class OperationService {
    @Resource
    private EntityManager entityManager;
    @Resource
    private EruptSecurityProp eruptSecurityProp;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptContextService eruptContextService;

    @Transactional
    public void record(Object handler, Exception ex) {
        if (this.eruptSecurityProp.isRecordOperateLog() && handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Optional.ofNullable((EruptRecordOperate)handlerMethod.getMethodAnnotation(EruptRecordOperate.class)).ifPresent(eruptRecordOperate -> {
                EruptOperateLog operate = new EruptOperateLog();
                if (eruptRecordOperate.dynamicConfig().isInterface()) {
                    operate.setApiName(eruptRecordOperate.value());
                } else {
                    String eruptName = this.request.getHeader("erupt");
                    eruptName = Optional.ofNullable(eruptName).orElse(this.request.getParameter("_erupt"));
                    EruptRecordOperate.DynamicConfig dynamicConfig = (EruptRecordOperate.DynamicConfig)EruptSpringUtil.getBean((Class)eruptRecordOperate.dynamicConfig());
                    if (!dynamicConfig.canRecord(eruptName, handlerMethod.getMethod())) {
                        return;
                    }
                    operate.setApiName(dynamicConfig.naming(eruptRecordOperate.value(), Optional.ofNullable(this.eruptContextService.getCurrentEruptMenu()).orElse(new EruptMenu()).getName(), eruptName, handlerMethod.getMethod()));
                }
                operate.setIp(IpUtil.getIpAddr((HttpServletRequest)this.request));
                operate.setRegion(IpUtil.getCityInfo((String)operate.getIp()));
                operate.setStatus(Boolean.valueOf(true));
                operate.setReqMethod(this.request.getMethod());
                operate.setReqAddr(this.request.getRequestURL().toString());
                operate.setOperateUser(MetaContext.getUser().getName());
                operate.setCreateTime(new Date());
                operate.setTotalTime(Long.valueOf(operate.getCreateTime().getTime() - RequestBodyTL.get().getDate()));
                Optional.ofNullable(ex).ifPresent(e -> {
                    String errorInfo = ExceptionUtils.getStackTrace((Throwable)e);
                    operate.setErrorInfo(errorInfo.length() > 4000 ? errorInfo.substring(0, 4000) : errorInfo);
                    operate.setStatus(Boolean.valueOf(false));
                });
                Object param = RequestBodyTL.get().getBody();
                operate.setReqParam(null == param ? this.findRequestParamVal(this.request) : param.toString());
                RequestBodyTL.remove();
                this.entityManager.persist((Object)operate);
            });
        }
    }

    private String findRequestParamVal(HttpServletRequest request) {
        if (!request.getParameterMap().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            request.getParameterMap().forEach((key, value) -> sb.append((String)key).append("=").append(Arrays.toString(value)).append("\n"));
            return sb.toString();
        }
        return null;
    }
}

