/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.config;

import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.interceptor.EruptSecurityInterceptor;
import xyz.erupt.security.interceptor.EruptSuperInterceptor;
import xyz.erupt.security.interceptor.HttpServletRequestFilter;

@Configuration
public class MvcInterceptor
implements WebMvcConfigurer {
    @Resource
    private EruptSecurityInterceptor eruptSecurityInterceptor;
    @Resource
    private EruptSuperInterceptor eruptSuperInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.eruptSuperInterceptor).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.eruptSecurityInterceptor).addPathPatterns(new String[]{"/erupt-api/**"});
    }

    @Bean
    public FilterRegistrationBean<HttpServletRequestFilter> registerAuthFilter(EruptSecurityProp eruptSecurityProp) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HttpServletRequestFilter(eruptSecurityProp));
        registration.addUrlPatterns(new String[]{"/erupt-api/*"});
        registration.setName(HttpServletRequestFilter.class.getSimpleName());
        registration.setOrder(1);
        return registration;
    }
}

