/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.context.MetaUser;
import xyz.erupt.core.module.MetaUserinfo;
import xyz.erupt.upms.annotation.EruptLoginAuth;
import xyz.erupt.upms.annotation.EruptMenuAuth;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptSuperInterceptor
implements AsyncHandlerInterceptor {
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private EruptUserService eruptUserService;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws IOException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            EruptLoginAuth eruptAuth = (EruptLoginAuth)handlerMethod.getMethodAnnotation(EruptLoginAuth.class);
            EruptMenuAuth eruptMenuAuth = (EruptMenuAuth)handlerMethod.getMethodAnnotation(EruptMenuAuth.class);
            if (null != eruptAuth || null != eruptMenuAuth) {
                String token = request.getHeader("token");
                if (null == token) {
                    token = request.getParameter("_token");
                }
                if (null == token || null == this.sessionService.get("erupt-auth:token:" + token)) {
                    response.setStatus(HttpStatus.UNAUTHORIZED.value());
                    response.sendError(HttpStatus.UNAUTHORIZED.value());
                    return false;
                }
                MetaUserinfo metaUserinfo = this.eruptUserService.getSimpleUserInfo();
                MetaContext.registerToken((String)token);
                MetaContext.register((MetaUser)new MetaUser(metaUserinfo.getId(), metaUserinfo.getAccount(), metaUserinfo.getUsername()));
            }
            if (null != eruptMenuAuth && null == this.eruptUserService.getEruptMenuByValue(eruptMenuAuth.value())) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
        }
        return true;
    }
}

