amis.define('node_modules/pdfjs-dist/build/pdf.mjs', function(require, exports, module, define) {

  "use strict";
  /**
   * @licstart The following is the entire license notice for the
   * JavaScript code in this page
   *
   * Copyright 2023 Mozilla Foundation
   *
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   *
   * @licend The above is the entire license notice for the
   * JavaScript code in this page
   */
  var _a, _Util_getExtremumOnCurve, _Util_getExtremum, _DOMFilterFactory_instances, _DOMFilterFactory__cache, _DOMFilterFactory__defs, _DOMFilterFactory_docId, _DOMFilterFactory_document, _DOMFilterFactory__hcmCache, _DOMFilterFactory_id, _DOMFilterFactory_cache_get, _DOMFilterFactory_hcmCache_get, _DOMFilterFactory_defs_get, _DOMFilterFactory_createTables, _DOMFilterFactory_addLuminosityConversion, _DOMFilterFactory_addGrayConversion, _DOMFilterFactory_createFilter, _DOMFilterFactory_appendFeFunc, _DOMFilterFactory_addTransferMapConversion, _DOMFilterFactory_addTransferMapAlphaConversion, _DOMFilterFactory_getRGB, _EditorToolbar_instances, _b, _EditorToolbar_toolbar, _EditorToolbar_colorPicker, _EditorToolbar_editor, _EditorToolbar_buttons, _EditorToolbar_pointerDown, _EditorToolbar_focusIn, _EditorToolbar_focusOut, _EditorToolbar_addListenersToElement, _EditorToolbar_addDeleteButton, _EditorToolbar_divider_get, _HighlightToolbar_instances, _HighlightToolbar_buttons, _HighlightToolbar_toolbar, _HighlightToolbar_uiManager, _HighlightToolbar_render, _HighlightToolbar_getLastPoint, _HighlightToolbar_addHighlightButton, _IdManager_id, _ImageManager_instances, _ImageManager_baseId, _ImageManager_id, _ImageManager_cache, _ImageManager_get, _CommandManager_commands, _CommandManager_locked, _CommandManager_maxSize, _CommandManager_position, _KeyboardManager_instances, _KeyboardManager_serialize, _AnnotationStorage_instances, _AnnotationStorage_modified, _AnnotationStorage_storage, _AnnotationStorage_setModified, _PrintAnnotationStorage_serializable, _FontLoader_systemFonts, _CanvasGraphics_instances, _CanvasGraphics_restoreInitialState, _CanvasGraphics_drawFilter, _MessageHandler_instances, _MessageHandler_createStreamSink, _MessageHandler_processStreamMessage, _MessageHandler_deleteStreamController, _Metadata_metadataMap, _Metadata_data, _OptionalContentGroup_isDisplay, _OptionalContentGroup_isPrint, _OptionalContentGroup_userSet, _OptionalContentGroup_visible, _OptionalContentConfig_instances, _OptionalContentConfig_cachedGetHash, _OptionalContentConfig_groups, _OptionalContentConfig_initialHash, _OptionalContentConfig_order, _OptionalContentConfig_evaluateVisibilityExpression, _PDFPageProxy_instances, _PDFPageProxy_delayedCleanupTimeout, _PDFPageProxy_pendingCleanup, _PDFPageProxy_tryCleanup, _PDFPageProxy_abortDelayedCleanup, _LoopbackPort_listeners, _LoopbackPort_deferred, _c, _PDFWorker_workerPorts, _PDFWorker_mainThreadWorkerMessageHandler_get, _WorkerTransport_instances, _WorkerTransport_methodPromises, _WorkerTransport_pageCache, _WorkerTransport_pagePromises, _WorkerTransport_pageRefCache, _WorkerTransport_passwordCapability, _WorkerTransport_cacheSimpleMethod, _PDFObjects_instances, _PDFObjects_objs, _PDFObjects_ensureObj, _RenderTask_internalRenderTask, _AnnotationElement_instances, _AnnotationElement_updates, _AnnotationElement_hasBorder, _AnnotationElement_popupElement, _AnnotationElement_setRectEdited, _LinkAnnotationElement_instances, _LinkAnnotationElement_setInternalLink, _LinkAnnotationElement_bindAttachment, _LinkAnnotationElement_bindSetOCGState, _PopupElement_instances, _PopupElement_boundKeyDown, _PopupElement_boundHide, _PopupElement_boundShow, _PopupElement_boundToggle, _PopupElement_color, _PopupElement_container, _PopupElement_contentsObj, _PopupElement_dateObj, _PopupElement_elements, _PopupElement_parent, _PopupElement_parentRect, _PopupElement_pinned, _PopupElement_popup, _PopupElement_position, _PopupElement_rect, _PopupElement_richText, _PopupElement_titleObj, _PopupElement_updates, _PopupElement_wasVisible, _PopupElement_html_get, _PopupElement_fontSize_get, _PopupElement_fontColor_get, _PopupElement_makePopupContent, _PopupElement_keyDown, _PopupElement_setPosition, _PopupElement_toggle, _PopupElement_show, _PopupElement_hide, _LineAnnotationElement_line, _SquareAnnotationElement_square, _CircleAnnotationElement_circle, _PolylineAnnotationElement_polyline, _InkAnnotationElement_polylines, _FileAttachmentAnnotationElement_instances, _FileAttachmentAnnotationElement_trigger, _FileAttachmentAnnotationElement_download, _AnnotationLayer_instances, _AnnotationLayer_accessibilityManager, _AnnotationLayer_annotationCanvasMap, _AnnotationLayer_editableAnnotations, _AnnotationLayer_appendElement, _AnnotationLayer_setAnnotationCanvasMap, _Outliner_instances, _Outliner_box, _Outliner_verticalEdges, _Outliner_intervals, _Outliner_getOutlines, _Outliner_binarySearch, _Outliner_insert, _Outliner_remove, _Outliner_breakEdge, _HighlightOutline_box, _HighlightOutline_outlines, _FreeHighlightOutline_instances, _FreeHighlightOutline_box, _FreeHighlightOutline_bbox, _FreeHighlightOutline_innerMargin, _FreeHighlightOutline_isLTR, _FreeHighlightOutline_points, _FreeHighlightOutline_scaleFactor, _FreeHighlightOutline_outline, _FreeHighlightOutline_rescale, _FreeHighlightOutline_rescaleAndSwap, _FreeHighlightOutline_computeMinMax, _ColorPicker_instances, _ColorPicker_boundKeyDown, _ColorPicker_boundPointerDown, _ColorPicker_button, _ColorPicker_buttonSwatch, _ColorPicker_defaultColor, _ColorPicker_dropdown, _ColorPicker_dropdownWasFromKeyboard, _ColorPicker_isMainColorPicker, _ColorPicker_editor, _ColorPicker_eventBus, _ColorPicker_uiManager, _ColorPicker_type, _ColorPicker_getDropdownRoot, _ColorPicker_colorSelect, _ColorPicker_keyDown, _ColorPicker_openDropdown, _ColorPicker_pointerDown, _ColorPicker_isDropdownVisible_get, _DrawLayer_instances, _d, _DrawLayer_parent, _DrawLayer_id, _DrawLayer_mapping, _DrawLayer_toUpdate, _DrawLayer_setBox, _DrawLayer_createSVG, _DrawLayer_createClipPath;
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.version = exports.updateTextLayer = exports.shadow = exports.setLayerDimensions = exports.renderTextLayer = exports.normalizeUnicode = exports.noContextMenu = exports.isPdfFile = exports.isDataScheme = exports.getXfaPageViewport = exports.getPdfFilenameFromUrl = exports.getFilenameFromUrl = exports.getDocument = exports.fetchData = exports.createValidAbsoluteUrl = exports.build = exports.XfaLayer = exports.VerbosityLevel = exports.Util = exports.UnexpectedResponseException = exports.TextLayer = exports.RenderingCancelledException = exports.PixelsPerInch = exports.PermissionFlag = exports.PasswordResponses = exports.PDFWorker = exports.PDFDateString = exports.PDFDataRangeTransport = exports.Outliner = exports.OPS = exports.MissingPDFException = exports.InvalidPDFException = exports.ImageKind = exports.GlobalWorkerOptions = exports.FeatureTest = exports.DrawLayer = exports.DOMSVGFactory = exports.ColorPicker = exports.CMapCompressionType = exports.AnnotationMode = exports.AnnotationLayer = exports.AnnotationEditorUIManager = exports.AnnotationEditorType = exports.AnnotationEditorParamsType = exports.AnnotationEditorLayer = exports.AbortException = void 0;
  var tslib_1 = require("3f733ee");
  /******/ // The require scope
  /******/ var __webpack_require__ = {};
  /******/
  /************************************************************************/
  /******/ /* webpack/runtime/define property getters */
  /******/ (function () {
      /******/ // define getter functions for harmony exports
      /******/ __webpack_require__.d = function (exports, definition) {
          /******/ for (var key in definition) {
              /******/ if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
                  /******/ Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
                  /******/ }
              /******/ }
          /******/ 
      };
      /******/ 
  })();
  /******/
  /******/ /* webpack/runtime/hasOwnProperty shorthand */
  /******/ (function () {
      /******/ __webpack_require__.o = function (obj, prop) { return (Object.prototype.hasOwnProperty.call(obj, prop)); };
      /******/ 
  })();
  /******/
  /************************************************************************/
  var __webpack_exports__ = globalThis.pdfjsLib = {};
  // EXPORTS
  __webpack_require__.d(__webpack_exports__, {
      AbortException: function () { return ( /* reexport */AbortException); },
      AnnotationEditorLayer: function () { return ( /* reexport */AnnotationEditorLayer); },
      AnnotationEditorParamsType: function () { return ( /* reexport */AnnotationEditorParamsType); },
      AnnotationEditorType: function () { return ( /* reexport */AnnotationEditorType); },
      AnnotationEditorUIManager: function () { return ( /* reexport */AnnotationEditorUIManager); },
      AnnotationLayer: function () { return ( /* reexport */AnnotationLayer); },
      AnnotationMode: function () { return ( /* reexport */AnnotationMode); },
      CMapCompressionType: function () { return ( /* reexport */CMapCompressionType); },
      ColorPicker: function () { return ( /* reexport */ColorPicker); },
      DOMSVGFactory: function () { return ( /* reexport */DOMSVGFactory); },
      DrawLayer: function () { return ( /* reexport */DrawLayer); },
      FeatureTest: function () { return ( /* reexport */util_FeatureTest); },
      GlobalWorkerOptions: function () { return ( /* reexport */GlobalWorkerOptions); },
      ImageKind: function () { return ( /* reexport */util_ImageKind); },
      InvalidPDFException: function () { return ( /* reexport */InvalidPDFException); },
      MissingPDFException: function () { return ( /* reexport */MissingPDFException); },
      OPS: function () { return ( /* reexport */OPS); },
      Outliner: function () { return ( /* reexport */Outliner); },
      PDFDataRangeTransport: function () { return ( /* reexport */PDFDataRangeTransport); },
      PDFDateString: function () { return ( /* reexport */PDFDateString); },
      PDFWorker: function () { return ( /* reexport */PDFWorker); },
      PasswordResponses: function () { return ( /* reexport */PasswordResponses); },
      PermissionFlag: function () { return ( /* reexport */PermissionFlag); },
      PixelsPerInch: function () { return ( /* reexport */PixelsPerInch); },
      RenderingCancelledException: function () { return ( /* reexport */RenderingCancelledException); },
      TextLayer: function () { return ( /* reexport */TextLayer); },
      UnexpectedResponseException: function () { return ( /* reexport */UnexpectedResponseException); },
      Util: function () { return ( /* reexport */Util); },
      VerbosityLevel: function () { return ( /* reexport */VerbosityLevel); },
      XfaLayer: function () { return ( /* reexport */XfaLayer); },
      build: function () { return ( /* reexport */build); },
      createValidAbsoluteUrl: function () { return ( /* reexport */createValidAbsoluteUrl); },
      fetchData: function () { return ( /* reexport */fetchData); },
      getDocument: function () { return ( /* reexport */getDocument); },
      getFilenameFromUrl: function () { return ( /* reexport */getFilenameFromUrl); },
      getPdfFilenameFromUrl: function () { return ( /* reexport */getPdfFilenameFromUrl); },
      getXfaPageViewport: function () { return ( /* reexport */getXfaPageViewport); },
      isDataScheme: function () { return ( /* reexport */isDataScheme); },
      isPdfFile: function () { return ( /* reexport */isPdfFile); },
      noContextMenu: function () { return ( /* reexport */noContextMenu); },
      normalizeUnicode: function () { return ( /* reexport */normalizeUnicode); },
      renderTextLayer: function () { return ( /* reexport */renderTextLayer); },
      setLayerDimensions: function () { return ( /* reexport */setLayerDimensions); },
      shadow: function () { return ( /* reexport */shadow); },
      updateTextLayer: function () { return ( /* reexport */updateTextLayer); },
      version: function () { return ( /* reexport */version); }
  });
  ; // CONCATENATED MODULE: ./src/shared/util.js
  var isNodeJS = "undefined" === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
  var IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
  var FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
  var MAX_IMAGE_SIZE_TO_CACHE = 10e6;
  var LINE_FACTOR = 1.35;
  var LINE_DESCENT_FACTOR = 0.35;
  var BASELINE_FACTOR = LINE_DESCENT_FACTOR / LINE_FACTOR;
  var RenderingIntentFlag = {
      ANY: 0x01,
      DISPLAY: 0x02,
      PRINT: 0x04,
      SAVE: 0x08,
      ANNOTATIONS_FORMS: 0x10,
      ANNOTATIONS_STORAGE: 0x20,
      ANNOTATIONS_DISABLE: 0x40,
      OPLIST: 0x100
  };
  var AnnotationMode = {
      DISABLE: 0,
      ENABLE: 1,
      ENABLE_FORMS: 2,
      ENABLE_STORAGE: 3
  };
  var AnnotationEditorPrefix = "pdfjs_internal_editor_";
  var AnnotationEditorType = {
      DISABLE: -1,
      NONE: 0,
      FREETEXT: 3,
      HIGHLIGHT: 9,
      STAMP: 13,
      INK: 15
  };
  var AnnotationEditorParamsType = {
      RESIZE: 1,
      CREATE: 2,
      FREETEXT_SIZE: 11,
      FREETEXT_COLOR: 12,
      FREETEXT_OPACITY: 13,
      INK_COLOR: 21,
      INK_THICKNESS: 22,
      INK_OPACITY: 23,
      HIGHLIGHT_COLOR: 31,
      HIGHLIGHT_DEFAULT_COLOR: 32,
      HIGHLIGHT_THICKNESS: 33,
      HIGHLIGHT_FREE: 34,
      HIGHLIGHT_SHOW_ALL: 35
  };
  var PermissionFlag = {
      PRINT: 0x04,
      MODIFY_CONTENTS: 0x08,
      COPY: 0x10,
      MODIFY_ANNOTATIONS: 0x20,
      FILL_INTERACTIVE_FORMS: 0x100,
      COPY_FOR_ACCESSIBILITY: 0x200,
      ASSEMBLE: 0x400,
      PRINT_HIGH_QUALITY: 0x800
  };
  var TextRenderingMode = {
      FILL: 0,
      STROKE: 1,
      FILL_STROKE: 2,
      INVISIBLE: 3,
      FILL_ADD_TO_PATH: 4,
      STROKE_ADD_TO_PATH: 5,
      FILL_STROKE_ADD_TO_PATH: 6,
      ADD_TO_PATH: 7,
      FILL_STROKE_MASK: 3,
      ADD_TO_PATH_FLAG: 4
  };
  var util_ImageKind = {
      GRAYSCALE_1BPP: 1,
      RGB_24BPP: 2,
      RGBA_32BPP: 3
  };
  var AnnotationType = {
      TEXT: 1,
      LINK: 2,
      FREETEXT: 3,
      LINE: 4,
      SQUARE: 5,
      CIRCLE: 6,
      POLYGON: 7,
      POLYLINE: 8,
      HIGHLIGHT: 9,
      UNDERLINE: 10,
      SQUIGGLY: 11,
      STRIKEOUT: 12,
      STAMP: 13,
      CARET: 14,
      INK: 15,
      POPUP: 16,
      FILEATTACHMENT: 17,
      SOUND: 18,
      MOVIE: 19,
      WIDGET: 20,
      SCREEN: 21,
      PRINTERMARK: 22,
      TRAPNET: 23,
      WATERMARK: 24,
      THREED: 25,
      REDACT: 26
  };
  var AnnotationReplyType = {
      GROUP: "Group",
      REPLY: "R"
  };
  var AnnotationFlag = {
      INVISIBLE: 0x01,
      HIDDEN: 0x02,
      PRINT: 0x04,
      NOZOOM: 0x08,
      NOROTATE: 0x10,
      NOVIEW: 0x20,
      READONLY: 0x40,
      LOCKED: 0x80,
      TOGGLENOVIEW: 0x100,
      LOCKEDCONTENTS: 0x200
  };
  var AnnotationFieldFlag = {
      READONLY: 0x0000001,
      REQUIRED: 0x0000002,
      NOEXPORT: 0x0000004,
      MULTILINE: 0x0001000,
      PASSWORD: 0x0002000,
      NOTOGGLETOOFF: 0x0004000,
      RADIO: 0x0008000,
      PUSHBUTTON: 0x0010000,
      COMBO: 0x0020000,
      EDIT: 0x0040000,
      SORT: 0x0080000,
      FILESELECT: 0x0100000,
      MULTISELECT: 0x0200000,
      DONOTSPELLCHECK: 0x0400000,
      DONOTSCROLL: 0x0800000,
      COMB: 0x1000000,
      RICHTEXT: 0x2000000,
      RADIOSINUNISON: 0x2000000,
      COMMITONSELCHANGE: 0x4000000
  };
  var AnnotationBorderStyleType = {
      SOLID: 1,
      DASHED: 2,
      BEVELED: 3,
      INSET: 4,
      UNDERLINE: 5
  };
  var AnnotationActionEventType = {
      E: "Mouse Enter",
      X: "Mouse Exit",
      D: "Mouse Down",
      U: "Mouse Up",
      Fo: "Focus",
      Bl: "Blur",
      PO: "PageOpen",
      PC: "PageClose",
      PV: "PageVisible",
      PI: "PageInvisible",
      K: "Keystroke",
      F: "Format",
      V: "Validate",
      C: "Calculate"
  };
  var DocumentActionEventType = {
      WC: "WillClose",
      WS: "WillSave",
      DS: "DidSave",
      WP: "WillPrint",
      DP: "DidPrint"
  };
  var PageActionEventType = {
      O: "PageOpen",
      C: "PageClose"
  };
  var VerbosityLevel = {
      ERRORS: 0,
      WARNINGS: 1,
      INFOS: 5
  };
  var CMapCompressionType = {
      NONE: 0,
      BINARY: 1
  };
  var OPS = {
      dependency: 1,
      setLineWidth: 2,
      setLineCap: 3,
      setLineJoin: 4,
      setMiterLimit: 5,
      setDash: 6,
      setRenderingIntent: 7,
      setFlatness: 8,
      setGState: 9,
      save: 10,
      restore: 11,
      transform: 12,
      moveTo: 13,
      lineTo: 14,
      curveTo: 15,
      curveTo2: 16,
      curveTo3: 17,
      closePath: 18,
      rectangle: 19,
      stroke: 20,
      closeStroke: 21,
      fill: 22,
      eoFill: 23,
      fillStroke: 24,
      eoFillStroke: 25,
      closeFillStroke: 26,
      closeEOFillStroke: 27,
      endPath: 28,
      clip: 29,
      eoClip: 30,
      beginText: 31,
      endText: 32,
      setCharSpacing: 33,
      setWordSpacing: 34,
      setHScale: 35,
      setLeading: 36,
      setFont: 37,
      setTextRenderingMode: 38,
      setTextRise: 39,
      moveText: 40,
      setLeadingMoveText: 41,
      setTextMatrix: 42,
      nextLine: 43,
      showText: 44,
      showSpacedText: 45,
      nextLineShowText: 46,
      nextLineSetSpacingShowText: 47,
      setCharWidth: 48,
      setCharWidthAndBounds: 49,
      setStrokeColorSpace: 50,
      setFillColorSpace: 51,
      setStrokeColor: 52,
      setStrokeColorN: 53,
      setFillColor: 54,
      setFillColorN: 55,
      setStrokeGray: 56,
      setFillGray: 57,
      setStrokeRGBColor: 58,
      setFillRGBColor: 59,
      setStrokeCMYKColor: 60,
      setFillCMYKColor: 61,
      shadingFill: 62,
      beginInlineImage: 63,
      beginImageData: 64,
      endInlineImage: 65,
      paintXObject: 66,
      markPoint: 67,
      markPointProps: 68,
      beginMarkedContent: 69,
      beginMarkedContentProps: 70,
      endMarkedContent: 71,
      beginCompat: 72,
      endCompat: 73,
      paintFormXObjectBegin: 74,
      paintFormXObjectEnd: 75,
      beginGroup: 76,
      endGroup: 77,
      beginAnnotation: 80,
      endAnnotation: 81,
      paintImageMaskXObject: 83,
      paintImageMaskXObjectGroup: 84,
      paintImageXObject: 85,
      paintInlineImageXObject: 86,
      paintInlineImageXObjectGroup: 87,
      paintImageXObjectRepeat: 88,
      paintImageMaskXObjectRepeat: 89,
      paintSolidColorImageMask: 90,
      constructPath: 91
  };
  var PasswordResponses = {
      NEED_PASSWORD: 1,
      INCORRECT_PASSWORD: 2
  };
  var verbosity = VerbosityLevel.WARNINGS;
  function setVerbosityLevel(level) {
      if (Number.isInteger(level)) {
          verbosity = level;
      }
  }
  function getVerbosityLevel() {
      return verbosity;
  }
  function info(msg) {
      if (verbosity >= VerbosityLevel.INFOS) {
          console.log("Info: ".concat(msg));
      }
  }
  function warn(msg) {
      if (verbosity >= VerbosityLevel.WARNINGS) {
          console.log("Warning: ".concat(msg));
      }
  }
  function unreachable(msg) {
      throw new Error(msg);
  }
  function assert(cond, msg) {
      if (!cond) {
          unreachable(msg);
      }
  }
  function _isValidProtocol(url) {
      switch (url === null || url === void 0 ? void 0 : url.protocol) {
          case "http:":
          case "https:":
          case "ftp:":
          case "mailto:":
          case "tel:":
              return true;
          default:
              return false;
      }
  }
  function createValidAbsoluteUrl(url, baseUrl, options) {
      if (baseUrl === void 0) { baseUrl = null; }
      if (options === void 0) { options = null; }
      if (!url) {
          return null;
      }
      try {
          if (options && typeof url === "string") {
              if (options.addDefaultProtocol && url.startsWith("www.")) {
                  var dots = url.match(/\./g);
                  if ((dots === null || dots === void 0 ? void 0 : dots.length) >= 2) {
                      url = "http://".concat(url);
                  }
              }
              if (options.tryConvertEncoding) {
                  try {
                      url = stringToUTF8String(url);
                  }
                  catch (_e) { }
              }
          }
          var absoluteUrl = baseUrl ? new URL(url, baseUrl) : new URL(url);
          if (_isValidProtocol(absoluteUrl)) {
              return absoluteUrl;
          }
      }
      catch (_f) { }
      return null;
  }
  function shadow(obj, prop, value, nonSerializable) {
      if (nonSerializable === void 0) { nonSerializable = false; }
      Object.defineProperty(obj, prop, {
          value: value,
          enumerable: !nonSerializable,
          configurable: true,
          writable: false
      });
      return value;
  }
  var BaseException = function BaseExceptionClosure() {
      function BaseException(message, name) {
          if (this.constructor === BaseException) {
              unreachable("Cannot initialize BaseException.");
          }
          this.message = message;
          this.name = name;
      }
      BaseException.prototype = new Error();
      BaseException.constructor = BaseException;
      return BaseException;
  }();
  var PasswordException = /** @class */ (function (_super) {
      tslib_1.__extends(PasswordException, _super);
      function PasswordException(msg, code) {
          var _this = _super.call(this, msg, "PasswordException") || this;
          _this.code = code;
          return _this;
      }
      return PasswordException;
  }(BaseException));
  var UnknownErrorException = /** @class */ (function (_super) {
      tslib_1.__extends(UnknownErrorException, _super);
      function UnknownErrorException(msg, details) {
          var _this = _super.call(this, msg, "UnknownErrorException") || this;
          _this.details = details;
          return _this;
      }
      return UnknownErrorException;
  }(BaseException));
  var InvalidPDFException = /** @class */ (function (_super) {
      tslib_1.__extends(InvalidPDFException, _super);
      function InvalidPDFException(msg) {
          return _super.call(this, msg, "InvalidPDFException") || this;
      }
      return InvalidPDFException;
  }(BaseException));
  var MissingPDFException = /** @class */ (function (_super) {
      tslib_1.__extends(MissingPDFException, _super);
      function MissingPDFException(msg) {
          return _super.call(this, msg, "MissingPDFException") || this;
      }
      return MissingPDFException;
  }(BaseException));
  var UnexpectedResponseException = /** @class */ (function (_super) {
      tslib_1.__extends(UnexpectedResponseException, _super);
      function UnexpectedResponseException(msg, status) {
          var _this = _super.call(this, msg, "UnexpectedResponseException") || this;
          _this.status = status;
          return _this;
      }
      return UnexpectedResponseException;
  }(BaseException));
  var FormatError = /** @class */ (function (_super) {
      tslib_1.__extends(FormatError, _super);
      function FormatError(msg) {
          return _super.call(this, msg, "FormatError") || this;
      }
      return FormatError;
  }(BaseException));
  var AbortException = /** @class */ (function (_super) {
      tslib_1.__extends(AbortException, _super);
      function AbortException(msg) {
          return _super.call(this, msg, "AbortException") || this;
      }
      return AbortException;
  }(BaseException));
  function bytesToString(bytes) {
      if (typeof bytes !== "object" || (bytes === null || bytes === void 0 ? void 0 : bytes.length) === undefined) {
          unreachable("Invalid argument for bytesToString");
      }
      var length = bytes.length;
      var MAX_ARGUMENT_COUNT = 8192;
      if (length < MAX_ARGUMENT_COUNT) {
          return String.fromCharCode.apply(null, bytes);
      }
      var strBuf = [];
      for (var i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
          var chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
          var chunk = bytes.subarray(i, chunkEnd);
          strBuf.push(String.fromCharCode.apply(null, chunk));
      }
      return strBuf.join("");
  }
  function stringToBytes(str) {
      if (typeof str !== "string") {
          unreachable("Invalid argument for stringToBytes");
      }
      var length = str.length;
      var bytes = new Uint8Array(length);
      for (var i = 0; i < length; ++i) {
          bytes[i] = str.charCodeAt(i) & 0xff;
      }
      return bytes;
  }
  function string32(value) {
      return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
  }
  function objectSize(obj) {
      return Object.keys(obj).length;
  }
  function objectFromMap(map) {
      var obj = Object.create(null);
      for (var _i = 0, map_1 = map; _i < map_1.length; _i++) {
          var _e = map_1[_i], key = _e[0], value = _e[1];
          obj[key] = value;
      }
      return obj;
  }
  function isLittleEndian() {
      var buffer8 = new Uint8Array(4);
      buffer8[0] = 1;
      var view32 = new Uint32Array(buffer8.buffer, 0, 1);
      return view32[0] === 1;
  }
  function isEvalSupported() {
      try {
          new Function("");
          return true;
      }
      catch (_e) {
          return false;
      }
  }
  var util_FeatureTest = /** @class */ (function () {
      function util_FeatureTest() {
      }
      Object.defineProperty(util_FeatureTest, "isLittleEndian", {
          get: function () {
              return shadow(this, "isLittleEndian", isLittleEndian());
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(util_FeatureTest, "isEvalSupported", {
          get: function () {
              return shadow(this, "isEvalSupported", isEvalSupported());
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(util_FeatureTest, "isOffscreenCanvasSupported", {
          get: function () {
              return shadow(this, "isOffscreenCanvasSupported", typeof OffscreenCanvas !== "undefined");
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(util_FeatureTest, "platform", {
          get: function () {
              if (typeof navigator !== "undefined" && typeof (navigator === null || navigator === void 0 ? void 0 : navigator.platform) === "string") {
                  return shadow(this, "platform", {
                      isMac: navigator.platform.includes("Mac")
                  });
              }
              return shadow(this, "platform", {
                  isMac: false
              });
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(util_FeatureTest, "isCSSRoundSupported", {
          get: function () {
              var _e, _f;
              return shadow(this, "isCSSRoundSupported", (_f = (_e = globalThis.CSS) === null || _e === void 0 ? void 0 : _e.supports) === null || _f === void 0 ? void 0 : _f.call(_e, "width: round(1.5px, 1px)"));
          },
          enumerable: false,
          configurable: true
      });
      return util_FeatureTest;
  }());
  var hexNumbers = Array.from(Array(256).keys(), function (n) { return n.toString(16).padStart(2, "0"); });
  var Util = /** @class */ (function () {
      function Util() {
      }
      Util.makeHexColor = function (r, g, b) {
          return "#".concat(hexNumbers[r]).concat(hexNumbers[g]).concat(hexNumbers[b]);
      };
      Util.scaleMinMax = function (transform, minMax) {
          var temp;
          if (transform[0]) {
              if (transform[0] < 0) {
                  temp = minMax[0];
                  minMax[0] = minMax[2];
                  minMax[2] = temp;
              }
              minMax[0] *= transform[0];
              minMax[2] *= transform[0];
              if (transform[3] < 0) {
                  temp = minMax[1];
                  minMax[1] = minMax[3];
                  minMax[3] = temp;
              }
              minMax[1] *= transform[3];
              minMax[3] *= transform[3];
          }
          else {
              temp = minMax[0];
              minMax[0] = minMax[1];
              minMax[1] = temp;
              temp = minMax[2];
              minMax[2] = minMax[3];
              minMax[3] = temp;
              if (transform[1] < 0) {
                  temp = minMax[1];
                  minMax[1] = minMax[3];
                  minMax[3] = temp;
              }
              minMax[1] *= transform[1];
              minMax[3] *= transform[1];
              if (transform[2] < 0) {
                  temp = minMax[0];
                  minMax[0] = minMax[2];
                  minMax[2] = temp;
              }
              minMax[0] *= transform[2];
              minMax[2] *= transform[2];
          }
          minMax[0] += transform[4];
          minMax[1] += transform[5];
          minMax[2] += transform[4];
          minMax[3] += transform[5];
      };
      Util.transform = function (m1, m2) {
          return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
      };
      Util.applyTransform = function (p, m) {
          var xt = p[0] * m[0] + p[1] * m[2] + m[4];
          var yt = p[0] * m[1] + p[1] * m[3] + m[5];
          return [xt, yt];
      };
      Util.applyInverseTransform = function (p, m) {
          var d = m[0] * m[3] - m[1] * m[2];
          var xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
          var yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
          return [xt, yt];
      };
      Util.getAxialAlignedBoundingBox = function (r, m) {
          var p1 = this.applyTransform(r, m);
          var p2 = this.applyTransform(r.slice(2, 4), m);
          var p3 = this.applyTransform([r[0], r[3]], m);
          var p4 = this.applyTransform([r[2], r[1]], m);
          return [Math.min(p1[0], p2[0], p3[0], p4[0]), Math.min(p1[1], p2[1], p3[1], p4[1]), Math.max(p1[0], p2[0], p3[0], p4[0]), Math.max(p1[1], p2[1], p3[1], p4[1])];
      };
      Util.inverseTransform = function (m) {
          var d = m[0] * m[3] - m[1] * m[2];
          return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
      };
      Util.singularValueDecompose2dScale = function (m) {
          var transpose = [m[0], m[2], m[1], m[3]];
          var a = m[0] * transpose[0] + m[1] * transpose[2];
          var b = m[0] * transpose[1] + m[1] * transpose[3];
          var c = m[2] * transpose[0] + m[3] * transpose[2];
          var d = m[2] * transpose[1] + m[3] * transpose[3];
          var first = (a + d) / 2;
          var second = Math.sqrt(Math.pow((a + d), 2) - 4 * (a * d - c * b)) / 2;
          var sx = first + second || 1;
          var sy = first - second || 1;
          return [Math.sqrt(sx), Math.sqrt(sy)];
      };
      Util.normalizeRect = function (rect) {
          var r = rect.slice(0);
          if (rect[0] > rect[2]) {
              r[0] = rect[2];
              r[2] = rect[0];
          }
          if (rect[1] > rect[3]) {
              r[1] = rect[3];
              r[3] = rect[1];
          }
          return r;
      };
      Util.intersect = function (rect1, rect2) {
          var xLow = Math.max(Math.min(rect1[0], rect1[2]), Math.min(rect2[0], rect2[2]));
          var xHigh = Math.min(Math.max(rect1[0], rect1[2]), Math.max(rect2[0], rect2[2]));
          if (xLow > xHigh) {
              return null;
          }
          var yLow = Math.max(Math.min(rect1[1], rect1[3]), Math.min(rect2[1], rect2[3]));
          var yHigh = Math.min(Math.max(rect1[1], rect1[3]), Math.max(rect2[1], rect2[3]));
          if (yLow > yHigh) {
              return null;
          }
          return [xLow, yLow, xHigh, yHigh];
      };
      Util.bezierBoundingBox = function (x0, y0, x1, y1, x2, y2, x3, y3, minMax) {
          if (minMax) {
              minMax[0] = Math.min(minMax[0], x0, x3);
              minMax[1] = Math.min(minMax[1], y0, y3);
              minMax[2] = Math.max(minMax[2], x0, x3);
              minMax[3] = Math.max(minMax[3], y0, y3);
          }
          else {
              minMax = [Math.min(x0, x3), Math.min(y0, y3), Math.max(x0, x3), Math.max(y0, y3)];
          }
          tslib_1.__classPrivateFieldGet(this, _a, "m", _Util_getExtremum).call(this, x0, x1, x2, x3, y0, y1, y2, y3, 3 * (-x0 + 3 * (x1 - x2) + x3), 6 * (x0 - 2 * x1 + x2), 3 * (x1 - x0), minMax);
          tslib_1.__classPrivateFieldGet(this, _a, "m", _Util_getExtremum).call(this, x0, x1, x2, x3, y0, y1, y2, y3, 3 * (-y0 + 3 * (y1 - y2) + y3), 6 * (y0 - 2 * y1 + y2), 3 * (y1 - y0), minMax);
          return minMax;
      };
      return Util;
  }());
  _a = Util, _Util_getExtremumOnCurve = function _Util_getExtremumOnCurve(x0, x1, x2, x3, y0, y1, y2, y3, t, minMax) {
      if (t <= 0 || t >= 1) {
          return;
      }
      var mt = 1 - t;
      var tt = t * t;
      var ttt = tt * t;
      var x = mt * (mt * (mt * x0 + 3 * t * x1) + 3 * tt * x2) + ttt * x3;
      var y = mt * (mt * (mt * y0 + 3 * t * y1) + 3 * tt * y2) + ttt * y3;
      minMax[0] = Math.min(minMax[0], x);
      minMax[1] = Math.min(minMax[1], y);
      minMax[2] = Math.max(minMax[2], x);
      minMax[3] = Math.max(minMax[3], y);
  }, _Util_getExtremum = function _Util_getExtremum(x0, x1, x2, x3, y0, y1, y2, y3, a, b, c, minMax) {
      if (Math.abs(a) < 1e-12) {
          if (Math.abs(b) >= 1e-12) {
              tslib_1.__classPrivateFieldGet(this, _a, "m", _Util_getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, -c / b, minMax);
          }
          return;
      }
      var delta = Math.pow(b, 2) - 4 * c * a;
      if (delta < 0) {
          return;
      }
      var sqrtDelta = Math.sqrt(delta);
      var a2 = 2 * a;
      tslib_1.__classPrivateFieldGet(this, _a, "m", _Util_getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, (-b + sqrtDelta) / a2, minMax);
      tslib_1.__classPrivateFieldGet(this, _a, "m", _Util_getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, (-b - sqrtDelta) / a2, minMax);
  };
  var PDFStringTranslateTable = ( /* unused pure expression or super */null && ([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2d8, 0x2c7, 0x2c6, 0x2d9, 0x2dd, 0x2db, 0x2da, 0x2dc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203a, 0x2212, 0x2030, 0x201e, 0x201c, 0x201d, 0x2018, 0x2019, 0x201a, 0x2122, 0xfb01, 0xfb02, 0x141, 0x152, 0x160, 0x178, 0x17d, 0x131, 0x142, 0x153, 0x161, 0x17e, 0, 0x20ac]));
  function stringToPDFString(str) {
      if (str[0] >= "\xEF") {
          var encoding = void 0;
          if (str[0] === "\xFE" && str[1] === "\xFF") {
              encoding = "utf-16be";
              if (str.length % 2 === 1) {
                  str = str.slice(0, -1);
              }
          }
          else if (str[0] === "\xFF" && str[1] === "\xFE") {
              encoding = "utf-16le";
              if (str.length % 2 === 1) {
                  str = str.slice(0, -1);
              }
          }
          else if (str[0] === "\xEF" && str[1] === "\xBB" && str[2] === "\xBF") {
              encoding = "utf-8";
          }
          if (encoding) {
              try {
                  var decoder = new TextDecoder(encoding, {
                      fatal: true
                  });
                  var buffer = stringToBytes(str);
                  var decoded = decoder.decode(buffer);
                  if (!decoded.includes("\x1b")) {
                      return decoded;
                  }
                  return decoded.replaceAll(/\x1b[^\x1b]*(?:\x1b|$)/g, "");
              }
              catch (ex) {
                  warn("stringToPDFString: \"".concat(ex, "\"."));
              }
          }
      }
      var strBuf = [];
      for (var i = 0, ii = str.length; i < ii; i++) {
          var charCode = str.charCodeAt(i);
          if (charCode === 0x1b) {
              while (++i < ii && str.charCodeAt(i) !== 0x1b) { }
              continue;
          }
          var code = PDFStringTranslateTable[charCode];
          strBuf.push(code ? String.fromCharCode(code) : str.charAt(i));
      }
      return strBuf.join("");
  }
  function stringToUTF8String(str) {
      return decodeURIComponent(escape(str));
  }
  function utf8StringToString(str) {
      return unescape(encodeURIComponent(str));
  }
  function isArrayEqual(arr1, arr2) {
      if (arr1.length !== arr2.length) {
          return false;
      }
      for (var i = 0, ii = arr1.length; i < ii; i++) {
          if (arr1[i] !== arr2[i]) {
              return false;
          }
      }
      return true;
  }
  function getModificationDate(date) {
      if (date === void 0) { date = new Date(); }
      var buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
      return buffer.join("");
  }
  var NormalizeRegex = null;
  var NormalizationMap = null;
  function normalizeUnicode(str) {
      if (!NormalizeRegex) {
          NormalizeRegex = /([\u00a0\u00b5\u037e\u0eb3\u2000-\u200a\u202f\u2126\ufb00-\ufb04\ufb06\ufb20-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufba1\ufba4-\ufba9\ufbae-\ufbb1\ufbd3-\ufbdc\ufbde-\ufbe7\ufbea-\ufbf8\ufbfc-\ufbfd\ufc00-\ufc5d\ufc64-\ufcf1\ufcf5-\ufd3d\ufd88\ufdf4\ufdfa-\ufdfb\ufe71\ufe77\ufe79\ufe7b\ufe7d]+)|(\ufb05+)/gu;
          NormalizationMap = new Map([["ﬅ", "ſt"]]);
      }
      return str.replaceAll(NormalizeRegex, function (_, p1, p2) { return p1 ? p1.normalize("NFKC") : NormalizationMap.get(p2); });
  }
  function getUuid() {
      if (typeof crypto !== "undefined" && typeof (crypto === null || crypto === void 0 ? void 0 : crypto.randomUUID) === "function") {
          return crypto.randomUUID();
      }
      var buf = new Uint8Array(32);
      if (typeof crypto !== "undefined" && typeof (crypto === null || crypto === void 0 ? void 0 : crypto.getRandomValues) === "function") {
          crypto.getRandomValues(buf);
      }
      else {
          for (var i = 0; i < 32; i++) {
              buf[i] = Math.floor(Math.random() * 255);
          }
      }
      return bytesToString(buf);
  }
  var AnnotationPrefix = "pdfjs_internal_id_";
  var FontRenderOps = {
      BEZIER_CURVE_TO: 0,
      MOVE_TO: 1,
      LINE_TO: 2,
      QUADRATIC_CURVE_TO: 3,
      RESTORE: 4,
      SAVE: 5,
      SCALE: 6,
      TRANSFORM: 7,
      TRANSLATE: 8
  };
  ; // CONCATENATED MODULE: ./src/display/base_factory.js
  var BaseFilterFactory = /** @class */ (function () {
      function BaseFilterFactory() {
          if (this.constructor === BaseFilterFactory) {
              unreachable("Cannot initialize BaseFilterFactory.");
          }
      }
      BaseFilterFactory.prototype.addFilter = function (maps) {
          return "none";
      };
      BaseFilterFactory.prototype.addHCMFilter = function (fgColor, bgColor) {
          return "none";
      };
      BaseFilterFactory.prototype.addAlphaFilter = function (map) {
          return "none";
      };
      BaseFilterFactory.prototype.addLuminosityFilter = function (map) {
          return "none";
      };
      BaseFilterFactory.prototype.addHighlightHCMFilter = function (filterName, fgColor, bgColor, newFgColor, newBgColor) {
          return "none";
      };
      BaseFilterFactory.prototype.destroy = function (keepHCM) {
          if (keepHCM === void 0) { keepHCM = false; }
      };
      return BaseFilterFactory;
  }());
  var BaseCanvasFactory = /** @class */ (function () {
      function BaseCanvasFactory() {
          if (this.constructor === BaseCanvasFactory) {
              unreachable("Cannot initialize BaseCanvasFactory.");
          }
      }
      BaseCanvasFactory.prototype.create = function (width, height) {
          if (width <= 0 || height <= 0) {
              throw new Error("Invalid canvas size");
          }
          var canvas = this._createCanvas(width, height);
          return {
              canvas: canvas,
              context: canvas.getContext("2d")
          };
      };
      BaseCanvasFactory.prototype.reset = function (canvasAndContext, width, height) {
          if (!canvasAndContext.canvas) {
              throw new Error("Canvas is not specified");
          }
          if (width <= 0 || height <= 0) {
              throw new Error("Invalid canvas size");
          }
          canvasAndContext.canvas.width = width;
          canvasAndContext.canvas.height = height;
      };
      BaseCanvasFactory.prototype.destroy = function (canvasAndContext) {
          if (!canvasAndContext.canvas) {
              throw new Error("Canvas is not specified");
          }
          canvasAndContext.canvas.width = 0;
          canvasAndContext.canvas.height = 0;
          canvasAndContext.canvas = null;
          canvasAndContext.context = null;
      };
      BaseCanvasFactory.prototype._createCanvas = function (width, height) {
          unreachable("Abstract method `_createCanvas` called.");
      };
      return BaseCanvasFactory;
  }());
  var BaseCMapReaderFactory = /** @class */ (function () {
      function BaseCMapReaderFactory(_e) {
          var _f = _e.baseUrl, baseUrl = _f === void 0 ? null : _f, _g = _e.isCompressed, isCompressed = _g === void 0 ? true : _g;
          if (this.constructor === BaseCMapReaderFactory) {
              unreachable("Cannot initialize BaseCMapReaderFactory.");
          }
          this.baseUrl = baseUrl;
          this.isCompressed = isCompressed;
      }
      BaseCMapReaderFactory.prototype.fetch = function (_e) {
          var name = _e.name;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var url, compressionType;
              var _this = this;
              return tslib_1.__generator(this, function (_f) {
                  if (!this.baseUrl) {
                      throw new Error('The CMap "baseUrl" parameter must be specified, ensure that ' + 'the "cMapUrl" and "cMapPacked" API parameters are provided.');
                  }
                  if (!name) {
                      throw new Error("CMap name must be specified.");
                  }
                  url = this.baseUrl + name + (this.isCompressed ? ".bcmap" : "");
                  compressionType = this.isCompressed ? CMapCompressionType.BINARY : CMapCompressionType.NONE;
                  return [2 /*return*/, this._fetchData(url, compressionType).catch(function (reason) {
                          throw new Error("Unable to load ".concat(_this.isCompressed ? "binary " : "", "CMap at: ").concat(url));
                      })];
              });
          });
      };
      BaseCMapReaderFactory.prototype._fetchData = function (url, compressionType) {
          unreachable("Abstract method `_fetchData` called.");
      };
      return BaseCMapReaderFactory;
  }());
  var BaseStandardFontDataFactory = /** @class */ (function () {
      function BaseStandardFontDataFactory(_e) {
          var _f = _e.baseUrl, baseUrl = _f === void 0 ? null : _f;
          if (this.constructor === BaseStandardFontDataFactory) {
              unreachable("Cannot initialize BaseStandardFontDataFactory.");
          }
          this.baseUrl = baseUrl;
      }
      BaseStandardFontDataFactory.prototype.fetch = function (_e) {
          var filename = _e.filename;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var url;
              return tslib_1.__generator(this, function (_f) {
                  if (!this.baseUrl) {
                      throw new Error('The standard font "baseUrl" parameter must be specified, ensure that ' + 'the "standardFontDataUrl" API parameter is provided.');
                  }
                  if (!filename) {
                      throw new Error("Font filename must be specified.");
                  }
                  url = "".concat(this.baseUrl).concat(filename);
                  return [2 /*return*/, this._fetchData(url).catch(function (reason) {
                          throw new Error("Unable to load font data at: ".concat(url));
                      })];
              });
          });
      };
      BaseStandardFontDataFactory.prototype._fetchData = function (url) {
          unreachable("Abstract method `_fetchData` called.");
      };
      return BaseStandardFontDataFactory;
  }());
  var BaseSVGFactory = /** @class */ (function () {
      function BaseSVGFactory() {
          if (this.constructor === BaseSVGFactory) {
              unreachable("Cannot initialize BaseSVGFactory.");
          }
      }
      BaseSVGFactory.prototype.create = function (width, height, skipDimensions) {
          if (skipDimensions === void 0) { skipDimensions = false; }
          if (width <= 0 || height <= 0) {
              throw new Error("Invalid SVG dimensions");
          }
          var svg = this._createSVG("svg:svg");
          svg.setAttribute("version", "1.1");
          if (!skipDimensions) {
              svg.setAttribute("width", "".concat(width, "px"));
              svg.setAttribute("height", "".concat(height, "px"));
          }
          svg.setAttribute("preserveAspectRatio", "none");
          svg.setAttribute("viewBox", "0 0 ".concat(width, " ").concat(height));
          return svg;
      };
      BaseSVGFactory.prototype.createElement = function (type) {
          if (typeof type !== "string") {
              throw new Error("Invalid SVG element type");
          }
          return this._createSVG(type);
      };
      BaseSVGFactory.prototype._createSVG = function (type) {
          unreachable("Abstract method `_createSVG` called.");
      };
      return BaseSVGFactory;
  }());
  ; // CONCATENATED MODULE: ./src/display/display_utils.js
  var SVG_NS = "http://www.w3.org/2000/svg";
  var PixelsPerInch = /** @class */ (function () {
      function PixelsPerInch() {
      }
      var _e;
      _e = PixelsPerInch;
      PixelsPerInch.CSS = 96.0;
      PixelsPerInch.PDF = 72.0;
      PixelsPerInch.PDF_TO_CSS_UNITS = _e.CSS / _e.PDF;
      return PixelsPerInch;
  }());
  var DOMFilterFactory = /** @class */ (function (_super) {
      tslib_1.__extends(DOMFilterFactory, _super);
      function DOMFilterFactory(_f) {
          var _g = _f === void 0 ? {} : _f, docId = _g.docId, _h = _g.ownerDocument, ownerDocument = _h === void 0 ? globalThis.document : _h;
          var _this = _super.call(this) || this;
          _DOMFilterFactory_instances.add(_this);
          _DOMFilterFactory__cache.set(_this, void 0);
          _DOMFilterFactory__defs.set(_this, void 0);
          _DOMFilterFactory_docId.set(_this, void 0);
          _DOMFilterFactory_document.set(_this, void 0);
          _DOMFilterFactory__hcmCache.set(_this, void 0);
          _DOMFilterFactory_id.set(_this, 0);
          tslib_1.__classPrivateFieldSet(_this, _DOMFilterFactory_docId, docId, "f");
          tslib_1.__classPrivateFieldSet(_this, _DOMFilterFactory_document, ownerDocument, "f");
          return _this;
      }
      DOMFilterFactory.prototype.addFilter = function (maps) {
          var _f, _g;
          if (!maps) {
              return "none";
          }
          var value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(maps);
          if (value) {
              return value;
          }
          var _h = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createTables).call(this, maps), tableR = _h[0], tableG = _h[1], tableB = _h[2];
          var key = maps.length === 1 ? tableR : "".concat(tableR).concat(tableG).concat(tableB);
          value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(key);
          if (value) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(maps, value);
              return value;
          }
          var id = "g_".concat(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_docId, "f"), "_transfer_map_").concat((tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory_id, (_g = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_id, "f"), _f = _g++, _g), "f"), _f));
          var url = "url(#".concat(id, ")");
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(maps, url);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(key, url);
          var filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createFilter).call(this, id);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapConversion).call(this, tableR, tableG, tableB, filter);
          return url;
      };
      DOMFilterFactory.prototype.addHCMFilter = function (fgColor, bgColor) {
          var _f;
          var key = "".concat(fgColor, "-").concat(bgColor);
          var filterName = "base";
          var info = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_hcmCache_get).get(filterName);
          if ((info === null || info === void 0 ? void 0 : info.key) === key) {
              return info.url;
          }
          if (info) {
              (_f = info.filter) === null || _f === void 0 ? void 0 : _f.remove();
              info.key = key;
              info.url = "none";
              info.filter = null;
          }
          else {
              info = {
                  key: key,
                  url: "none",
                  filter: null
              };
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_hcmCache_get).set(filterName, info);
          }
          if (!fgColor || !bgColor) {
              return info.url;
          }
          var fgRGB = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_getRGB).call(this, fgColor);
          fgColor = Util.makeHexColor.apply(Util, fgRGB);
          var bgRGB = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_getRGB).call(this, bgColor);
          bgColor = Util.makeHexColor.apply(Util, bgRGB);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_defs_get).style.color = "";
          if (fgColor === "#000000" && bgColor === "#ffffff" || fgColor === bgColor) {
              return info.url;
          }
          var map = new Array(256);
          for (var i = 0; i <= 255; i++) {
              var x = i / 255;
              map[i] = x <= 0.03928 ? x / 12.92 : Math.pow(((x + 0.055) / 1.055), 2.4);
          }
          var table = map.join(",");
          var id = "g_".concat(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_docId, "f"), "_hcm_filter");
          var filter = info.filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createFilter).call(this, id);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapConversion).call(this, table, table, table, filter);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addGrayConversion).call(this, filter);
          var getSteps = function (c, n) {
              var start = fgRGB[c] / 255;
              var end = bgRGB[c] / 255;
              var arr = new Array(n + 1);
              for (var i = 0; i <= n; i++) {
                  arr[i] = start + i / n * (end - start);
              }
              return arr.join(",");
          };
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapConversion).call(this, getSteps(0, 5), getSteps(1, 5), getSteps(2, 5), filter);
          info.url = "url(#".concat(id, ")");
          return info.url;
      };
      DOMFilterFactory.prototype.addAlphaFilter = function (map) {
          var _f, _g;
          var value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(map);
          if (value) {
              return value;
          }
          var tableA = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createTables).call(this, [map])[0];
          var key = "alpha_".concat(tableA);
          value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(key);
          if (value) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(map, value);
              return value;
          }
          var id = "g_".concat(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_docId, "f"), "_alpha_map_").concat((tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory_id, (_g = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_id, "f"), _f = _g++, _g), "f"), _f));
          var url = "url(#".concat(id, ")");
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(map, url);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(key, url);
          var filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createFilter).call(this, id);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapAlphaConversion).call(this, tableA, filter);
          return url;
      };
      DOMFilterFactory.prototype.addLuminosityFilter = function (map) {
          var _f, _g;
          var value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(map || "luminosity");
          if (value) {
              return value;
          }
          var tableA, key;
          if (map) {
              tableA = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createTables).call(this, [map])[0];
              key = "luminosity_".concat(tableA);
          }
          else {
              key = "luminosity";
          }
          value = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).get(key);
          if (value) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(map, value);
              return value;
          }
          var id = "g_".concat(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_docId, "f"), "_luminosity_map_").concat((tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory_id, (_g = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_id, "f"), _f = _g++, _g), "f"), _f));
          var url = "url(#".concat(id, ")");
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(map, url);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_cache_get).set(key, url);
          var filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createFilter).call(this, id);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addLuminosityConversion).call(this, filter);
          if (map) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapAlphaConversion).call(this, tableA, filter);
          }
          return url;
      };
      DOMFilterFactory.prototype.addHighlightHCMFilter = function (filterName, fgColor, bgColor, newFgColor, newBgColor) {
          var _f;
          var _g;
          var key = "".concat(fgColor, "-").concat(bgColor, "-").concat(newFgColor, "-").concat(newBgColor);
          var info = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_hcmCache_get).get(filterName);
          if ((info === null || info === void 0 ? void 0 : info.key) === key) {
              return info.url;
          }
          if (info) {
              (_g = info.filter) === null || _g === void 0 ? void 0 : _g.remove();
              info.key = key;
              info.url = "none";
              info.filter = null;
          }
          else {
              info = {
                  key: key,
                  url: "none",
                  filter: null
              };
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_hcmCache_get).set(filterName, info);
          }
          if (!fgColor || !bgColor) {
              return info.url;
          }
          var _h = [fgColor, bgColor].map(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_getRGB).bind(this)), fgRGB = _h[0], bgRGB = _h[1];
          var fgGray = Math.round(0.2126 * fgRGB[0] + 0.7152 * fgRGB[1] + 0.0722 * fgRGB[2]);
          var bgGray = Math.round(0.2126 * bgRGB[0] + 0.7152 * bgRGB[1] + 0.0722 * bgRGB[2]);
          var _j = [newFgColor, newBgColor].map(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_getRGB).bind(this)), newFgRGB = _j[0], newBgRGB = _j[1];
          if (bgGray < fgGray) {
              _f = [bgGray, fgGray, newBgRGB, newFgRGB], fgGray = _f[0], bgGray = _f[1], newFgRGB = _f[2], newBgRGB = _f[3];
          }
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_defs_get).style.color = "";
          var getSteps = function (fg, bg, n) {
              var arr = new Array(256);
              var step = (bgGray - fgGray) / n;
              var newStart = fg / 255;
              var newStep = (bg - fg) / (255 * n);
              var prev = 0;
              for (var i = 0; i <= n; i++) {
                  var k = Math.round(fgGray + i * step);
                  var value = newStart + i * newStep;
                  for (var j = prev; j <= k; j++) {
                      arr[j] = value;
                  }
                  prev = k + 1;
              }
              for (var i = prev; i < 256; i++) {
                  arr[i] = arr[prev - 1];
              }
              return arr.join(",");
          };
          var id = "g_".concat(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_docId, "f"), "_hcm_").concat(filterName, "_filter");
          var filter = info.filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_createFilter).call(this, id);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addGrayConversion).call(this, filter);
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_addTransferMapConversion).call(this, getSteps(newFgRGB[0], newBgRGB[0], 5), getSteps(newFgRGB[1], newBgRGB[1], 5), getSteps(newFgRGB[2], newBgRGB[2], 5), filter);
          info.url = "url(#".concat(id, ")");
          return info.url;
      };
      DOMFilterFactory.prototype.destroy = function (keepHCM) {
          if (keepHCM === void 0) { keepHCM = false; }
          if (keepHCM && tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_hcmCache_get).size !== 0) {
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__defs, "f")) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__defs, "f").parentNode.parentNode.remove();
              tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory__defs, null, "f");
          }
          if (tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__cache, "f")) {
              tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__cache, "f").clear();
              tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory__cache, null, "f");
          }
          tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory_id, 0, "f");
      };
      return DOMFilterFactory;
  }(BaseFilterFactory));
  _DOMFilterFactory__cache = new WeakMap(), _DOMFilterFactory__defs = new WeakMap(), _DOMFilterFactory_docId = new WeakMap(), _DOMFilterFactory_document = new WeakMap(), _DOMFilterFactory__hcmCache = new WeakMap(), _DOMFilterFactory_id = new WeakMap(), _DOMFilterFactory_instances = new WeakSet(), _DOMFilterFactory_cache_get = function _DOMFilterFactory_cache_get() {
      return tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory__cache, tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__cache, "f") || new Map(), "f");
  }, _DOMFilterFactory_hcmCache_get = function _DOMFilterFactory_hcmCache_get() {
      return tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory__hcmCache, tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__hcmCache, "f") || new Map(), "f");
  }, _DOMFilterFactory_defs_get = function _DOMFilterFactory_defs_get() {
      if (!tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__defs, "f")) {
          var div = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElement("div");
          var style = div.style;
          style.visibility = "hidden";
          style.contain = "strict";
          style.width = style.height = 0;
          style.position = "absolute";
          style.top = style.left = 0;
          style.zIndex = -1;
          var svg = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "svg");
          svg.setAttribute("width", 0);
          svg.setAttribute("height", 0);
          tslib_1.__classPrivateFieldSet(this, _DOMFilterFactory__defs, tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "defs"), "f");
          div.append(svg);
          svg.append(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__defs, "f"));
          tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").body.append(div);
      }
      return tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory__defs, "f");
  }, _DOMFilterFactory_createTables = function _DOMFilterFactory_createTables(maps) {
      if (maps.length === 1) {
          var mapR_1 = maps[0];
          var buffer = new Array(256);
          for (var i = 0; i < 256; i++) {
              buffer[i] = mapR_1[i] / 255;
          }
          var table = buffer.join(",");
          return [table, table, table];
      }
      var mapR = maps[0], mapG = maps[1], mapB = maps[2];
      var bufferR = new Array(256);
      var bufferG = new Array(256);
      var bufferB = new Array(256);
      for (var i = 0; i < 256; i++) {
          bufferR[i] = mapR[i] / 255;
          bufferG[i] = mapG[i] / 255;
          bufferB[i] = mapB[i] / 255;
      }
      return [bufferR.join(","), bufferG.join(","), bufferB.join(",")];
  }, _DOMFilterFactory_addLuminosityConversion = function _DOMFilterFactory_addLuminosityConversion(filter) {
      var feColorMatrix = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "feColorMatrix");
      feColorMatrix.setAttribute("type", "matrix");
      feColorMatrix.setAttribute("values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0.59 0.11 0 0");
      filter.append(feColorMatrix);
  }, _DOMFilterFactory_addGrayConversion = function _DOMFilterFactory_addGrayConversion(filter) {
      var feColorMatrix = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "feColorMatrix");
      feColorMatrix.setAttribute("type", "matrix");
      feColorMatrix.setAttribute("values", "0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0 0 0 1 0");
      filter.append(feColorMatrix);
  }, _DOMFilterFactory_createFilter = function _DOMFilterFactory_createFilter(id) {
      var filter = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "filter");
      filter.setAttribute("color-interpolation-filters", "sRGB");
      filter.setAttribute("id", id);
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_defs_get).append(filter);
      return filter;
  }, _DOMFilterFactory_appendFeFunc = function _DOMFilterFactory_appendFeFunc(feComponentTransfer, func, table) {
      var feFunc = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, func);
      feFunc.setAttribute("type", "discrete");
      feFunc.setAttribute("tableValues", table);
      feComponentTransfer.append(feFunc);
  }, _DOMFilterFactory_addTransferMapConversion = function _DOMFilterFactory_addTransferMapConversion(rTable, gTable, bTable, filter) {
      var feComponentTransfer = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "feComponentTransfer");
      filter.append(feComponentTransfer);
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_appendFeFunc).call(this, feComponentTransfer, "feFuncR", rTable);
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_appendFeFunc).call(this, feComponentTransfer, "feFuncG", gTable);
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_appendFeFunc).call(this, feComponentTransfer, "feFuncB", bTable);
  }, _DOMFilterFactory_addTransferMapAlphaConversion = function _DOMFilterFactory_addTransferMapAlphaConversion(aTable, filter) {
      var feComponentTransfer = tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_document, "f").createElementNS(SVG_NS, "feComponentTransfer");
      filter.append(feComponentTransfer);
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "m", _DOMFilterFactory_appendFeFunc).call(this, feComponentTransfer, "feFuncA", aTable);
  }, _DOMFilterFactory_getRGB = function _DOMFilterFactory_getRGB(color) {
      tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_defs_get).style.color = color;
      return getRGB(getComputedStyle(tslib_1.__classPrivateFieldGet(this, _DOMFilterFactory_instances, "a", _DOMFilterFactory_defs_get)).getPropertyValue("color"));
  };
  var DOMCanvasFactory = /** @class */ (function (_super) {
      tslib_1.__extends(DOMCanvasFactory, _super);
      function DOMCanvasFactory(_f) {
          var _g = _f === void 0 ? {} : _f, _h = _g.ownerDocument, ownerDocument = _h === void 0 ? globalThis.document : _h;
          var _this = _super.call(this) || this;
          _this._document = ownerDocument;
          return _this;
      }
      DOMCanvasFactory.prototype._createCanvas = function (width, height) {
          var canvas = this._document.createElement("canvas");
          canvas.width = width;
          canvas.height = height;
          return canvas;
      };
      return DOMCanvasFactory;
  }(BaseCanvasFactory));
  function fetchData(url, type) {
      if (type === void 0) { type = "text"; }
      return tslib_1.__awaiter(this, void 0, void 0, function () {
          var response;
          return tslib_1.__generator(this, function (_f) {
              switch (_f.label) {
                  case 0:
                      if (!isValidFetchUrl(url, document.baseURI)) return [3 /*break*/, 2];
                      return [4 /*yield*/, fetch(url)];
                  case 1:
                      response = _f.sent();
                      if (!response.ok) {
                          throw new Error(response.statusText);
                      }
                      switch (type) {
                          case "arraybuffer":
                              return [2 /*return*/, response.arrayBuffer()];
                          case "blob":
                              return [2 /*return*/, response.blob()];
                          case "json":
                              return [2 /*return*/, response.json()];
                      }
                      return [2 /*return*/, response.text()];
                  case 2: return [2 /*return*/, new Promise(function (resolve, reject) {
                          var request = new XMLHttpRequest();
                          request.open("GET", url, true);
                          request.responseType = type;
                          request.onreadystatechange = function () {
                              if (request.readyState !== XMLHttpRequest.DONE) {
                                  return;
                              }
                              if (request.status === 200 || request.status === 0) {
                                  switch (type) {
                                      case "arraybuffer":
                                      case "blob":
                                      case "json":
                                          resolve(request.response);
                                          return;
                                  }
                                  resolve(request.responseText);
                                  return;
                              }
                              reject(new Error(request.statusText));
                          };
                          request.send(null);
                      })];
              }
          });
      });
  }
  var DOMCMapReaderFactory = /** @class */ (function (_super) {
      tslib_1.__extends(DOMCMapReaderFactory, _super);
      function DOMCMapReaderFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      DOMCMapReaderFactory.prototype._fetchData = function (url, compressionType) {
          return fetchData(url, this.isCompressed ? "arraybuffer" : "text").then(function (data) { return ({
              cMapData: data instanceof ArrayBuffer ? new Uint8Array(data) : stringToBytes(data),
              compressionType: compressionType
          }); });
      };
      return DOMCMapReaderFactory;
  }(BaseCMapReaderFactory));
  var DOMStandardFontDataFactory = /** @class */ (function (_super) {
      tslib_1.__extends(DOMStandardFontDataFactory, _super);
      function DOMStandardFontDataFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      DOMStandardFontDataFactory.prototype._fetchData = function (url) {
          return fetchData(url, "arraybuffer").then(function (data) { return new Uint8Array(data); });
      };
      return DOMStandardFontDataFactory;
  }(BaseStandardFontDataFactory));
  var DOMSVGFactory = /** @class */ (function (_super) {
      tslib_1.__extends(DOMSVGFactory, _super);
      function DOMSVGFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      DOMSVGFactory.prototype._createSVG = function (type) {
          return document.createElementNS(SVG_NS, type);
      };
      return DOMSVGFactory;
  }(BaseSVGFactory));
  var PageViewport = /** @class */ (function () {
      function PageViewport(_f) {
          var viewBox = _f.viewBox, scale = _f.scale, rotation = _f.rotation, _g = _f.offsetX, offsetX = _g === void 0 ? 0 : _g, _h = _f.offsetY, offsetY = _h === void 0 ? 0 : _h, _j = _f.dontFlip, dontFlip = _j === void 0 ? false : _j;
          this.viewBox = viewBox;
          this.scale = scale;
          this.rotation = rotation;
          this.offsetX = offsetX;
          this.offsetY = offsetY;
          var centerX = (viewBox[2] + viewBox[0]) / 2;
          var centerY = (viewBox[3] + viewBox[1]) / 2;
          var rotateA, rotateB, rotateC, rotateD;
          rotation %= 360;
          if (rotation < 0) {
              rotation += 360;
          }
          switch (rotation) {
              case 180:
                  rotateA = -1;
                  rotateB = 0;
                  rotateC = 0;
                  rotateD = 1;
                  break;
              case 90:
                  rotateA = 0;
                  rotateB = 1;
                  rotateC = 1;
                  rotateD = 0;
                  break;
              case 270:
                  rotateA = 0;
                  rotateB = -1;
                  rotateC = -1;
                  rotateD = 0;
                  break;
              case 0:
                  rotateA = 1;
                  rotateB = 0;
                  rotateC = 0;
                  rotateD = -1;
                  break;
              default:
                  throw new Error("PageViewport: Invalid rotation, must be a multiple of 90 degrees.");
          }
          if (dontFlip) {
              rotateC = -rotateC;
              rotateD = -rotateD;
          }
          var offsetCanvasX, offsetCanvasY;
          var width, height;
          if (rotateA === 0) {
              offsetCanvasX = Math.abs(centerY - viewBox[1]) * scale + offsetX;
              offsetCanvasY = Math.abs(centerX - viewBox[0]) * scale + offsetY;
              width = (viewBox[3] - viewBox[1]) * scale;
              height = (viewBox[2] - viewBox[0]) * scale;
          }
          else {
              offsetCanvasX = Math.abs(centerX - viewBox[0]) * scale + offsetX;
              offsetCanvasY = Math.abs(centerY - viewBox[1]) * scale + offsetY;
              width = (viewBox[2] - viewBox[0]) * scale;
              height = (viewBox[3] - viewBox[1]) * scale;
          }
          this.transform = [rotateA * scale, rotateB * scale, rotateC * scale, rotateD * scale, offsetCanvasX - rotateA * scale * centerX - rotateC * scale * centerY, offsetCanvasY - rotateB * scale * centerX - rotateD * scale * centerY];
          this.width = width;
          this.height = height;
      }
      Object.defineProperty(PageViewport.prototype, "rawDims", {
          get: function () {
              var viewBox = this.viewBox;
              return shadow(this, "rawDims", {
                  pageWidth: viewBox[2] - viewBox[0],
                  pageHeight: viewBox[3] - viewBox[1],
                  pageX: viewBox[0],
                  pageY: viewBox[1]
              });
          },
          enumerable: false,
          configurable: true
      });
      PageViewport.prototype.clone = function (_f) {
          var _g = _f === void 0 ? {} : _f, _h = _g.scale, scale = _h === void 0 ? this.scale : _h, _j = _g.rotation, rotation = _j === void 0 ? this.rotation : _j, _k = _g.offsetX, offsetX = _k === void 0 ? this.offsetX : _k, _l = _g.offsetY, offsetY = _l === void 0 ? this.offsetY : _l, _m = _g.dontFlip, dontFlip = _m === void 0 ? false : _m;
          return new PageViewport({
              viewBox: this.viewBox.slice(),
              scale: scale,
              rotation: rotation,
              offsetX: offsetX,
              offsetY: offsetY,
              dontFlip: dontFlip
          });
      };
      PageViewport.prototype.convertToViewportPoint = function (x, y) {
          return Util.applyTransform([x, y], this.transform);
      };
      PageViewport.prototype.convertToViewportRectangle = function (rect) {
          var topLeft = Util.applyTransform([rect[0], rect[1]], this.transform);
          var bottomRight = Util.applyTransform([rect[2], rect[3]], this.transform);
          return [topLeft[0], topLeft[1], bottomRight[0], bottomRight[1]];
      };
      PageViewport.prototype.convertToPdfPoint = function (x, y) {
          return Util.applyInverseTransform([x, y], this.transform);
      };
      return PageViewport;
  }());
  var RenderingCancelledException = /** @class */ (function (_super) {
      tslib_1.__extends(RenderingCancelledException, _super);
      function RenderingCancelledException(msg, extraDelay) {
          if (extraDelay === void 0) { extraDelay = 0; }
          var _this = _super.call(this, msg, "RenderingCancelledException") || this;
          _this.extraDelay = extraDelay;
          return _this;
      }
      return RenderingCancelledException;
  }(BaseException));
  function isDataScheme(url) {
      var ii = url.length;
      var i = 0;
      while (i < ii && url[i].trim() === "") {
          i++;
      }
      return url.substring(i, i + 5).toLowerCase() === "data:";
  }
  function isPdfFile(filename) {
      return typeof filename === "string" && /\.pdf$/i.test(filename);
  }
  function getFilenameFromUrl(url) {
      url = url.split(/[#?]/, 1)[0];
      return url.substring(url.lastIndexOf("/") + 1);
  }
  function getPdfFilenameFromUrl(url, defaultFilename) {
      if (defaultFilename === void 0) { defaultFilename = "document.pdf"; }
      if (typeof url !== "string") {
          return defaultFilename;
      }
      if (isDataScheme(url)) {
          warn('getPdfFilenameFromUrl: ignore "data:"-URL for performance reasons.');
          return defaultFilename;
      }
      var reURI = /^(?:(?:[^:]+:)?\/\/[^/]+)?([^?#]*)(\?[^#]*)?(#.*)?$/;
      var reFilename = /[^/?#=]+\.pdf\b(?!.*\.pdf\b)/i;
      var splitURI = reURI.exec(url);
      var suggestedFilename = reFilename.exec(splitURI[1]) || reFilename.exec(splitURI[2]) || reFilename.exec(splitURI[3]);
      if (suggestedFilename) {
          suggestedFilename = suggestedFilename[0];
          if (suggestedFilename.includes("%")) {
              try {
                  suggestedFilename = reFilename.exec(decodeURIComponent(suggestedFilename))[0];
              }
              catch (_f) { }
          }
      }
      return suggestedFilename || defaultFilename;
  }
  var StatTimer = /** @class */ (function () {
      function StatTimer() {
          this.started = Object.create(null);
          this.times = [];
      }
      StatTimer.prototype.time = function (name) {
          if (name in this.started) {
              warn("Timer is already running for ".concat(name));
          }
          this.started[name] = Date.now();
      };
      StatTimer.prototype.timeEnd = function (name) {
          if (!(name in this.started)) {
              warn("Timer has not been started for ".concat(name));
          }
          this.times.push({
              name: name,
              start: this.started[name],
              end: Date.now()
          });
          delete this.started[name];
      };
      StatTimer.prototype.toString = function () {
          var outBuf = [];
          var longest = 0;
          for (var _i = 0, _f = this.times; _i < _f.length; _i++) {
              var name = _f[_i].name;
              longest = Math.max(name.length, longest);
          }
          for (var _g = 0, _h = this.times; _g < _h.length; _g++) {
              var _j = _h[_g], name = _j.name, start = _j.start, end = _j.end;
              outBuf.push("".concat(name.padEnd(longest), " ").concat(end - start, "ms\n"));
          }
          return outBuf.join("");
      };
      return StatTimer;
  }());
  function isValidFetchUrl(url, baseUrl) {
      try {
          var protocol = (baseUrl ? new URL(url, baseUrl) : new URL(url)).protocol;
          return protocol === "http:" || protocol === "https:";
      }
      catch (_f) {
          return false;
      }
  }
  function noContextMenu(e) {
      e.preventDefault();
  }
  function deprecated(details) {
      console.log("Deprecated API usage: " + details);
  }
  var pdfDateStringRegex;
  var PDFDateString = /** @class */ (function () {
      function PDFDateString() {
      }
      PDFDateString.toDateObject = function (input) {
          if (!input || typeof input !== "string") {
              return null;
          }
          pdfDateStringRegex || (pdfDateStringRegex = new RegExp("^D:" + "(\\d{4})" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "([Z|+|-])?" + "(\\d{2})?" + "'?" + "(\\d{2})?" + "'?"));
          var matches = pdfDateStringRegex.exec(input);
          if (!matches) {
              return null;
          }
          var year = parseInt(matches[1], 10);
          var month = parseInt(matches[2], 10);
          month = month >= 1 && month <= 12 ? month - 1 : 0;
          var day = parseInt(matches[3], 10);
          day = day >= 1 && day <= 31 ? day : 1;
          var hour = parseInt(matches[4], 10);
          hour = hour >= 0 && hour <= 23 ? hour : 0;
          var minute = parseInt(matches[5], 10);
          minute = minute >= 0 && minute <= 59 ? minute : 0;
          var second = parseInt(matches[6], 10);
          second = second >= 0 && second <= 59 ? second : 0;
          var universalTimeRelation = matches[7] || "Z";
          var offsetHour = parseInt(matches[8], 10);
          offsetHour = offsetHour >= 0 && offsetHour <= 23 ? offsetHour : 0;
          var offsetMinute = parseInt(matches[9], 10) || 0;
          offsetMinute = offsetMinute >= 0 && offsetMinute <= 59 ? offsetMinute : 0;
          if (universalTimeRelation === "-") {
              hour += offsetHour;
              minute += offsetMinute;
          }
          else if (universalTimeRelation === "+") {
              hour -= offsetHour;
              minute -= offsetMinute;
          }
          return new Date(Date.UTC(year, month, day, hour, minute, second));
      };
      return PDFDateString;
  }());
  function getXfaPageViewport(xfaPage, _f) {
      var _g = _f.scale, scale = _g === void 0 ? 1 : _g, _h = _f.rotation, rotation = _h === void 0 ? 0 : _h;
      var _j = xfaPage.attributes.style, width = _j.width, height = _j.height;
      var viewBox = [0, 0, parseInt(width), parseInt(height)];
      return new PageViewport({
          viewBox: viewBox,
          scale: scale,
          rotation: rotation
      });
  }
  function getRGB(color) {
      if (color.startsWith("#")) {
          var colorRGB = parseInt(color.slice(1), 16);
          return [(colorRGB & 0xff0000) >> 16, (colorRGB & 0x00ff00) >> 8, colorRGB & 0x0000ff];
      }
      if (color.startsWith("rgb(")) {
          return color.slice(4, -1).split(",").map(function (x) { return parseInt(x); });
      }
      if (color.startsWith("rgba(")) {
          return color.slice(5, -1).split(",").map(function (x) { return parseInt(x); }).slice(0, 3);
      }
      warn("Not a valid color format: \"".concat(color, "\""));
      return [0, 0, 0];
  }
  function getColorValues(colors) {
      var span = document.createElement("span");
      span.style.visibility = "hidden";
      document.body.append(span);
      for (var _i = 0, _f = colors.keys(); _i < _f.length; _i++) {
          var name = _f[_i];
          span.style.color = name;
          var computedColor = window.getComputedStyle(span).color;
          colors.set(name, getRGB(computedColor));
      }
      span.remove();
  }
  function getCurrentTransform(ctx) {
      var _f = ctx.getTransform(), a = _f.a, b = _f.b, c = _f.c, d = _f.d, e = _f.e, f = _f.f;
      return [a, b, c, d, e, f];
  }
  function getCurrentTransformInverse(ctx) {
      var _f = ctx.getTransform().invertSelf(), a = _f.a, b = _f.b, c = _f.c, d = _f.d, e = _f.e, f = _f.f;
      return [a, b, c, d, e, f];
  }
  function setLayerDimensions(div, viewport, mustFlip, mustRotate) {
      if (mustFlip === void 0) { mustFlip = false; }
      if (mustRotate === void 0) { mustRotate = true; }
      if (viewport instanceof PageViewport) {
          var _f = viewport.rawDims, pageWidth = _f.pageWidth, pageHeight = _f.pageHeight;
          var style = div.style;
          var useRound = util_FeatureTest.isCSSRoundSupported;
          var w = "var(--scale-factor) * ".concat(pageWidth, "px"), h = "var(--scale-factor) * ".concat(pageHeight, "px");
          var widthStr = useRound ? "round(".concat(w, ", 1px)") : "calc(".concat(w, ")"), heightStr = useRound ? "round(".concat(h, ", 1px)") : "calc(".concat(h, ")");
          if (!mustFlip || viewport.rotation % 180 === 0) {
              style.width = widthStr;
              style.height = heightStr;
          }
          else {
              style.width = heightStr;
              style.height = widthStr;
          }
      }
      if (mustRotate) {
          div.setAttribute("data-main-rotation", viewport.rotation);
      }
  }
  ; // CONCATENATED MODULE: ./src/display/editor/toolbar.js
  var EditorToolbar = /** @class */ (function () {
      function EditorToolbar(editor) {
          _EditorToolbar_instances.add(this);
          _EditorToolbar_toolbar.set(this, null);
          _EditorToolbar_colorPicker.set(this, null);
          _EditorToolbar_editor.set(this, void 0);
          _EditorToolbar_buttons.set(this, null);
          tslib_1.__classPrivateFieldSet(this, _EditorToolbar_editor, editor, "f");
      }
      EditorToolbar.prototype.render = function () {
          var editToolbar = tslib_1.__classPrivateFieldSet(this, _EditorToolbar_toolbar, document.createElement("div"), "f");
          editToolbar.className = "editToolbar";
          editToolbar.setAttribute("role", "toolbar");
          editToolbar.addEventListener("contextmenu", noContextMenu);
          editToolbar.addEventListener("pointerdown", tslib_1.__classPrivateFieldGet(EditorToolbar, _b, "m", _EditorToolbar_pointerDown));
          var buttons = tslib_1.__classPrivateFieldSet(this, _EditorToolbar_buttons, document.createElement("div"), "f");
          buttons.className = "buttons";
          editToolbar.append(buttons);
          var position = tslib_1.__classPrivateFieldGet(this, _EditorToolbar_editor, "f").toolbarPosition;
          if (position) {
              var style = editToolbar.style;
              var x = tslib_1.__classPrivateFieldGet(this, _EditorToolbar_editor, "f")._uiManager.direction === "ltr" ? 1 - position[0] : position[0];
              style.insetInlineEnd = "".concat(100 * x, "%");
              style.top = "calc(".concat(100 * position[1], "% + var(--editor-toolbar-vert-offset))");
          }
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_addDeleteButton).call(this);
          return editToolbar;
      };
      EditorToolbar.prototype.hide = function () {
          var _f;
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_toolbar, "f").classList.add("hidden");
          (_f = tslib_1.__classPrivateFieldGet(this, _EditorToolbar_colorPicker, "f")) === null || _f === void 0 ? void 0 : _f.hideDropdown();
      };
      EditorToolbar.prototype.show = function () {
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_toolbar, "f").classList.remove("hidden");
      };
      EditorToolbar.prototype.addAltTextButton = function (button) {
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_addListenersToElement).call(this, button);
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_buttons, "f").prepend(button, tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "a", _EditorToolbar_divider_get));
      };
      EditorToolbar.prototype.addColorPicker = function (colorPicker) {
          tslib_1.__classPrivateFieldSet(this, _EditorToolbar_colorPicker, colorPicker, "f");
          var button = colorPicker.renderButton();
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_addListenersToElement).call(this, button);
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_buttons, "f").prepend(button, tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "a", _EditorToolbar_divider_get));
      };
      EditorToolbar.prototype.remove = function () {
          var _f;
          tslib_1.__classPrivateFieldGet(this, _EditorToolbar_toolbar, "f").remove();
          (_f = tslib_1.__classPrivateFieldGet(this, _EditorToolbar_colorPicker, "f")) === null || _f === void 0 ? void 0 : _f.destroy();
          tslib_1.__classPrivateFieldSet(this, _EditorToolbar_colorPicker, null, "f");
      };
      return EditorToolbar;
  }());
  _b = EditorToolbar, _EditorToolbar_toolbar = new WeakMap(), _EditorToolbar_colorPicker = new WeakMap(), _EditorToolbar_editor = new WeakMap(), _EditorToolbar_buttons = new WeakMap(), _EditorToolbar_instances = new WeakSet(), _EditorToolbar_pointerDown = function _EditorToolbar_pointerDown(e) {
      e.stopPropagation();
  }, _EditorToolbar_focusIn = function _EditorToolbar_focusIn(e) {
      tslib_1.__classPrivateFieldGet(this, _EditorToolbar_editor, "f")._focusEventsAllowed = false;
      e.preventDefault();
      e.stopPropagation();
  }, _EditorToolbar_focusOut = function _EditorToolbar_focusOut(e) {
      tslib_1.__classPrivateFieldGet(this, _EditorToolbar_editor, "f")._focusEventsAllowed = true;
      e.preventDefault();
      e.stopPropagation();
  }, _EditorToolbar_addListenersToElement = function _EditorToolbar_addListenersToElement(element) {
      element.addEventListener("focusin", tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_focusIn).bind(this), {
          capture: true
      });
      element.addEventListener("focusout", tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_focusOut).bind(this), {
          capture: true
      });
      element.addEventListener("contextmenu", noContextMenu);
  }, _EditorToolbar_addDeleteButton = function _EditorToolbar_addDeleteButton() {
      var _this = this;
      var button = document.createElement("button");
      button.className = "delete";
      button.tabIndex = 0;
      button.setAttribute("data-l10n-id", "pdfjs-editor-remove-".concat(tslib_1.__classPrivateFieldGet(this, _EditorToolbar_editor, "f").editorType, "-button"));
      tslib_1.__classPrivateFieldGet(this, _EditorToolbar_instances, "m", _EditorToolbar_addListenersToElement).call(this, button);
      button.addEventListener("click", function (e) {
          tslib_1.__classPrivateFieldGet(_this, _EditorToolbar_editor, "f")._uiManager.delete();
      });
      tslib_1.__classPrivateFieldGet(this, _EditorToolbar_buttons, "f").append(button);
  }, _EditorToolbar_divider_get = function _EditorToolbar_divider_get() {
      var divider = document.createElement("div");
      divider.className = "divider";
      return divider;
  };
  var HighlightToolbar = /** @class */ (function () {
      function HighlightToolbar(uiManager) {
          _HighlightToolbar_instances.add(this);
          _HighlightToolbar_buttons.set(this, null);
          _HighlightToolbar_toolbar.set(this, null);
          _HighlightToolbar_uiManager.set(this, void 0);
          tslib_1.__classPrivateFieldSet(this, _HighlightToolbar_uiManager, uiManager, "f");
      }
      HighlightToolbar.prototype.show = function (parent, boxes, isLTR) {
          var _f = tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_instances, "m", _HighlightToolbar_getLastPoint).call(this, boxes, isLTR), x = _f[0], y = _f[1];
          var style = tslib_1.__classPrivateFieldSet(this, _HighlightToolbar_toolbar, tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_toolbar, "f") || tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_instances, "m", _HighlightToolbar_render).call(this), "f").style;
          parent.append(tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_toolbar, "f"));
          style.insetInlineEnd = "".concat(100 * x, "%");
          style.top = "calc(".concat(100 * y, "% + var(--editor-toolbar-vert-offset))");
      };
      HighlightToolbar.prototype.hide = function () {
          tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_toolbar, "f").remove();
      };
      return HighlightToolbar;
  }());
  _HighlightToolbar_buttons = new WeakMap(), _HighlightToolbar_toolbar = new WeakMap(), _HighlightToolbar_uiManager = new WeakMap(), _HighlightToolbar_instances = new WeakSet(), _HighlightToolbar_render = function _HighlightToolbar_render() {
      var editToolbar = tslib_1.__classPrivateFieldSet(this, _HighlightToolbar_toolbar, document.createElement("div"), "f");
      editToolbar.className = "editToolbar";
      editToolbar.setAttribute("role", "toolbar");
      editToolbar.addEventListener("contextmenu", noContextMenu);
      var buttons = tslib_1.__classPrivateFieldSet(this, _HighlightToolbar_buttons, document.createElement("div"), "f");
      buttons.className = "buttons";
      editToolbar.append(buttons);
      tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_instances, "m", _HighlightToolbar_addHighlightButton).call(this);
      return editToolbar;
  }, _HighlightToolbar_getLastPoint = function _HighlightToolbar_getLastPoint(boxes, isLTR) {
      var lastY = 0;
      var lastX = 0;
      for (var _i = 0, boxes_1 = boxes; _i < boxes_1.length; _i++) {
          var box = boxes_1[_i];
          var y = box.y + box.height;
          if (y < lastY) {
              continue;
          }
          var x = box.x + (isLTR ? box.width : 0);
          if (y > lastY) {
              lastX = x;
              lastY = y;
              continue;
          }
          if (isLTR) {
              if (x > lastX) {
                  lastX = x;
              }
          }
          else if (x < lastX) {
              lastX = x;
          }
      }
      return [isLTR ? 1 - lastX : lastX, lastY];
  }, _HighlightToolbar_addHighlightButton = function _HighlightToolbar_addHighlightButton() {
      var _this = this;
      var button = document.createElement("button");
      button.className = "highlightButton";
      button.tabIndex = 0;
      button.setAttribute("data-l10n-id", "pdfjs-highlight-floating-button1");
      var span = document.createElement("span");
      button.append(span);
      span.className = "visuallyHidden";
      span.setAttribute("data-l10n-id", "pdfjs-highlight-floating-button-label");
      button.addEventListener("contextmenu", noContextMenu);
      button.addEventListener("click", function () {
          tslib_1.__classPrivateFieldGet(_this, _HighlightToolbar_uiManager, "f").highlightSelection("floating_button");
      });
      tslib_1.__classPrivateFieldGet(this, _HighlightToolbar_buttons, "f").append(button);
  };
  ; // CONCATENATED MODULE: ./src/display/editor/tools.js
  function bindEvents(obj, element, names) {
      for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
          var name = names_1[_i];
          element.addEventListener(name, obj[name].bind(obj));
      }
  }
  function opacityToHex(opacity) {
      return Math.round(Math.min(255, Math.max(1, 255 * opacity))).toString(16).padStart(2, "0");
  }
  var IdManager = /** @class */ (function () {
      function IdManager() {
          _IdManager_id.set(this, 0);
      }
      Object.defineProperty(IdManager.prototype, "id", {
          get: function () {
              var _f, _g;
              return "".concat(AnnotationEditorPrefix).concat((tslib_1.__classPrivateFieldSet(this, _IdManager_id, (_g = tslib_1.__classPrivateFieldGet(this, _IdManager_id, "f"), _f = _g++, _g), "f"), _f));
          },
          enumerable: false,
          configurable: true
      });
      return IdManager;
  }());
  _IdManager_id = new WeakMap();
  var ImageManager = /** @class */ (function () {
      function ImageManager() {
          _ImageManager_instances.add(this);
          _ImageManager_baseId.set(this, getUuid());
          _ImageManager_id.set(this, 0);
          _ImageManager_cache.set(this, null);
      }
      Object.defineProperty(ImageManager, "_isSVGFittingCanvas", {
          get: function () {
              var svg = "data:image/svg+xml;charset=UTF-8,<svg viewBox=\"0 0 1 1\" width=\"1\" height=\"1\" xmlns=\"http://www.w3.org/2000/svg\"><rect width=\"1\" height=\"1\" style=\"fill:red;\"/></svg>";
              var canvas = new OffscreenCanvas(1, 3);
              var ctx = canvas.getContext("2d");
              var image = new Image();
              image.src = svg;
              var promise = image.decode().then(function () {
                  ctx.drawImage(image, 0, 0, 1, 1, 0, 0, 1, 3);
                  return new Uint32Array(ctx.getImageData(0, 0, 1, 1).data.buffer)[0] === 0;
              });
              return shadow(this, "_isSVGFittingCanvas", promise);
          },
          enumerable: false,
          configurable: true
      });
      ImageManager.prototype.getFromFile = function (file) {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var lastModified, name, size, type;
              return tslib_1.__generator(this, function (_f) {
                  lastModified = file.lastModified, name = file.name, size = file.size, type = file.type;
                  return [2 /*return*/, tslib_1.__classPrivateFieldGet(this, _ImageManager_instances, "m", _ImageManager_get).call(this, "".concat(lastModified, "_").concat(name, "_").concat(size, "_").concat(type), file)];
              });
          });
      };
      ImageManager.prototype.getFromUrl = function (url) {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              return tslib_1.__generator(this, function (_f) {
                  return [2 /*return*/, tslib_1.__classPrivateFieldGet(this, _ImageManager_instances, "m", _ImageManager_get).call(this, url, url)];
              });
          });
      };
      ImageManager.prototype.getFromId = function (id) {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var data;
              return tslib_1.__generator(this, function (_f) {
                  tslib_1.__classPrivateFieldSet(this, _ImageManager_cache, tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f") || new Map(), "f");
                  data = tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").get(id);
                  if (!data) {
                      return [2 /*return*/, null];
                  }
                  if (data.bitmap) {
                      data.refCounter += 1;
                      return [2 /*return*/, data];
                  }
                  if (data.file) {
                      return [2 /*return*/, this.getFromFile(data.file)];
                  }
                  return [2 /*return*/, this.getFromUrl(data.url)];
              });
          });
      };
      ImageManager.prototype.getSvgUrl = function (id) {
          var data = tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").get(id);
          if (!(data === null || data === void 0 ? void 0 : data.isSvg)) {
              return null;
          }
          return data.svgUrl;
      };
      ImageManager.prototype.deleteId = function (id) {
          tslib_1.__classPrivateFieldSet(this, _ImageManager_cache, tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f") || new Map(), "f");
          var data = tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").get(id);
          if (!data) {
              return;
          }
          data.refCounter -= 1;
          if (data.refCounter !== 0) {
              return;
          }
          data.bitmap = null;
      };
      ImageManager.prototype.isValidId = function (id) {
          return id.startsWith("image_".concat(tslib_1.__classPrivateFieldGet(this, _ImageManager_baseId, "f"), "_"));
      };
      return ImageManager;
  }());
  _ImageManager_baseId = new WeakMap(), _ImageManager_id = new WeakMap(), _ImageManager_cache = new WeakMap(), _ImageManager_instances = new WeakSet(), _ImageManager_get = function _ImageManager_get(key, rawData) {
      var _f, _g;
      return tslib_1.__awaiter(this, void 0, void 0, function () {
          var data, image, mustRemoveAspectRatioPromise_1, fileReader_1, imageElement_1, imagePromise, _h, e_1;
          var _this = this;
          return tslib_1.__generator(this, function (_j) {
              switch (_j.label) {
                  case 0:
                      tslib_1.__classPrivateFieldSet(this, _ImageManager_cache, tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f") || new Map(), "f");
                      data = tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").get(key);
                      if (data === null) {
                          return [2 /*return*/, null];
                      }
                      if (data === null || data === void 0 ? void 0 : data.bitmap) {
                          data.refCounter += 1;
                          return [2 /*return*/, data];
                      }
                      _j.label = 1;
                  case 1:
                      _j.trys.push([1, 9, , 10]);
                      data || (data = {
                          bitmap: null,
                          id: "image_".concat(tslib_1.__classPrivateFieldGet(this, _ImageManager_baseId, "f"), "_").concat((tslib_1.__classPrivateFieldSet(this, _ImageManager_id, (_g = tslib_1.__classPrivateFieldGet(this, _ImageManager_id, "f"), _f = _g++, _g), "f"), _f)),
                          refCounter: 0,
                          isSvg: false
                      });
                      image = void 0;
                      if (!(typeof rawData === "string")) return [3 /*break*/, 3];
                      data.url = rawData;
                      return [4 /*yield*/, fetchData(rawData, "blob")];
                  case 2:
                      image = _j.sent();
                      return [3 /*break*/, 4];
                  case 3:
                      image = data.file = rawData;
                      _j.label = 4;
                  case 4:
                      if (!(image.type === "image/svg+xml")) return [3 /*break*/, 6];
                      mustRemoveAspectRatioPromise_1 = ImageManager._isSVGFittingCanvas;
                      fileReader_1 = new FileReader();
                      imageElement_1 = new Image();
                      imagePromise = new Promise(function (resolve, reject) {
                          imageElement_1.onload = function () {
                              data.bitmap = imageElement_1;
                              data.isSvg = true;
                              resolve();
                          };
                          fileReader_1.onload = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                              var url, _f;
                              return tslib_1.__generator(this, function (_g) {
                                  switch (_g.label) {
                                      case 0:
                                          url = data.svgUrl = fileReader_1.result;
                                          _f = imageElement_1;
                                          return [4 /*yield*/, mustRemoveAspectRatioPromise_1];
                                      case 1:
                                          _f.src = (_g.sent()) ? "".concat(url, "#svgView(preserveAspectRatio(none))") : url;
                                          return [2 /*return*/];
                                  }
                              });
                          }); };
                          imageElement_1.onerror = fileReader_1.onerror = reject;
                      });
                      fileReader_1.readAsDataURL(image);
                      return [4 /*yield*/, imagePromise];
                  case 5:
                      _j.sent();
                      return [3 /*break*/, 8];
                  case 6:
                      _h = data;
                      return [4 /*yield*/, createImageBitmap(image)];
                  case 7:
                      _h.bitmap = _j.sent();
                      _j.label = 8;
                  case 8:
                      data.refCounter = 1;
                      return [3 /*break*/, 10];
                  case 9:
                      e_1 = _j.sent();
                      console.error(e_1);
                      data = null;
                      return [3 /*break*/, 10];
                  case 10:
                      tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").set(key, data);
                      if (data) {
                          tslib_1.__classPrivateFieldGet(this, _ImageManager_cache, "f").set(data.id, data);
                      }
                      return [2 /*return*/, data];
              }
          });
      });
  };
  var CommandManager = /** @class */ (function () {
      function CommandManager(maxSize) {
          if (maxSize === void 0) { maxSize = 128; }
          _CommandManager_commands.set(this, []);
          _CommandManager_locked.set(this, false);
          _CommandManager_maxSize.set(this, void 0);
          _CommandManager_position.set(this, -1);
          tslib_1.__classPrivateFieldSet(this, _CommandManager_maxSize, maxSize, "f");
      }
      CommandManager.prototype.add = function (_f) {
          var cmd = _f.cmd, undo = _f.undo, post = _f.post, mustExec = _f.mustExec, _g = _f.type, type = _g === void 0 ? NaN : _g, _h = _f.overwriteIfSameType, overwriteIfSameType = _h === void 0 ? false : _h, _j = _f.keepUndo, keepUndo = _j === void 0 ? false : _j;
          if (mustExec) {
              cmd();
          }
          if (tslib_1.__classPrivateFieldGet(this, _CommandManager_locked, "f")) {
              return;
          }
          var save = {
              cmd: cmd,
              undo: undo,
              post: post,
              type: type
          };
          if (tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") === -1) {
              if (tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").length > 0) {
                  tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").length = 0;
              }
              tslib_1.__classPrivateFieldSet(this, _CommandManager_position, 0, "f");
              tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").push(save);
              return;
          }
          if (overwriteIfSameType && tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f")[tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f")].type === type) {
              if (keepUndo) {
                  save.undo = tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f")[tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f")].undo;
              }
              tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f")[tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f")] = save;
              return;
          }
          var next = tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") + 1;
          if (next === tslib_1.__classPrivateFieldGet(this, _CommandManager_maxSize, "f")) {
              tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").splice(0, 1);
          }
          else {
              tslib_1.__classPrivateFieldSet(this, _CommandManager_position, next, "f");
              if (next < tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").length) {
                  tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").splice(next);
              }
          }
          tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").push(save);
      };
      CommandManager.prototype.undo = function () {
          if (tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") === -1) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _CommandManager_locked, true, "f");
          var _f = tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f")[tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f")], undo = _f.undo, post = _f.post;
          undo();
          post === null || post === void 0 ? void 0 : post();
          tslib_1.__classPrivateFieldSet(this, _CommandManager_locked, false, "f");
          tslib_1.__classPrivateFieldSet(this, _CommandManager_position, tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") - 1, "f");
      };
      CommandManager.prototype.redo = function () {
          if (tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") < tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").length - 1) {
              tslib_1.__classPrivateFieldSet(this, _CommandManager_position, tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") + 1, "f");
              tslib_1.__classPrivateFieldSet(this, _CommandManager_locked, true, "f");
              var _f = tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f")[tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f")], cmd = _f.cmd, post = _f.post;
              cmd();
              post === null || post === void 0 ? void 0 : post();
              tslib_1.__classPrivateFieldSet(this, _CommandManager_locked, false, "f");
          }
      };
      CommandManager.prototype.hasSomethingToUndo = function () {
          return tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") !== -1;
      };
      CommandManager.prototype.hasSomethingToRedo = function () {
          return tslib_1.__classPrivateFieldGet(this, _CommandManager_position, "f") < tslib_1.__classPrivateFieldGet(this, _CommandManager_commands, "f").length - 1;
      };
      CommandManager.prototype.destroy = function () {
          tslib_1.__classPrivateFieldSet(this, _CommandManager_commands, null, "f");
      };
      return CommandManager;
  }());
  _CommandManager_commands = new WeakMap(), _CommandManager_locked = new WeakMap(), _CommandManager_maxSize = new WeakMap(), _CommandManager_position = new WeakMap();
  var KeyboardManager = /** @class */ (function () {
      function KeyboardManager(callbacks) {
          _KeyboardManager_instances.add(this);
          this.buffer = [];
          this.callbacks = new Map();
          this.allKeys = new Set();
          var isMac = util_FeatureTest.platform.isMac;
          for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
              var _f = callbacks_1[_i], keys = _f[0], callback = _f[1], _g = _f[2], options = _g === void 0 ? {} : _g;
              for (var _h = 0, keys_1 = keys; _h < keys_1.length; _h++) {
                  var key = keys_1[_h];
                  var isMacKey = key.startsWith("mac+");
                  if (isMac && isMacKey) {
                      this.callbacks.set(key.slice(4), {
                          callback: callback,
                          options: options
                      });
                      this.allKeys.add(key.split("+").at(-1));
                  }
                  else if (!isMac && !isMacKey) {
                      this.callbacks.set(key, {
                          callback: callback,
                          options: options
                      });
                      this.allKeys.add(key.split("+").at(-1));
                  }
              }
          }
      }
      KeyboardManager.prototype.exec = function (self, event) {
          if (!this.allKeys.has(event.key)) {
              return;
          }
          var info = this.callbacks.get(tslib_1.__classPrivateFieldGet(this, _KeyboardManager_instances, "m", _KeyboardManager_serialize).call(this, event));
          if (!info) {
              return;
          }
          var callback = info.callback, _f = info.options, _g = _f.bubbles, bubbles = _g === void 0 ? false : _g, _h = _f.args, args = _h === void 0 ? [] : _h, _j = _f.checker, checker = _j === void 0 ? null : _j;
          if (checker && !checker(self, event)) {
              return;
          }
          callback.bind.apply(callback, tslib_1.__spreadArray(tslib_1.__spreadArray([self], args, false), [event], false))();
          if (!bubbles) {
              event.stopPropagation();
              event.preventDefault();
          }
      };
      return KeyboardManager;
  }());
  _KeyboardManager_instances = new WeakSet(), _KeyboardManager_serialize = function _KeyboardManager_serialize(event) {
      if (event.altKey) {
          this.buffer.push("alt");
      }
      if (event.ctrlKey) {
          this.buffer.push("ctrl");
      }
      if (event.metaKey) {
          this.buffer.push("meta");
      }
      if (event.shiftKey) {
          this.buffer.push("shift");
      }
      this.buffer.push(event.key);
      var str = this.buffer.join("+");
      this.buffer.length = 0;
      return str;
  };
  var ColorManager = /** @class */ (function () {
      function ColorManager() {
      }
      Object.defineProperty(ColorManager.prototype, "_colors", {
          get: function () {
              var colors = new Map([["CanvasText", null], ["Canvas", null]]);
              getColorValues(colors);
              return shadow(this, "_colors", colors);
          },
          enumerable: false,
          configurable: true
      });
      ColorManager.prototype.convert = function (color) {
          var rgb = getRGB(color);
          if (!window.matchMedia("(forced-colors: active)").matches) {
              return rgb;
          }
          for (var _i = 0, _f = this._colors; _i < _f.length; _i++) {
              var _g = _f[_i], name = _g[0], RGB = _g[1];
              if (RGB.every(function (x, i) { return x === rgb[i]; })) {
                  return ColorManager._colorsMapping.get(name);
              }
          }
          return rgb;
      };
      ColorManager.prototype.getHexCode = function (name) {
          var rgb = this._colors.get(name);
          if (!rgb) {
              return name;
          }
          return Util.makeHexColor.apply(Util, rgb);
      };
      ColorManager._colorsMapping = new Map([["CanvasText", [0, 0, 0]], ["Canvas", [255, 255, 255]]]);
      return ColorManager;
  }());
  var AnnotationEditorUIManager = /** @class */ (function () {
      function AnnotationEditorUIManager(container, viewer, altTextManager, eventBus, pdfDocument, pageColors, highlightColors, enableHighlightFloatingButton, mlManager) {
          _AnnotationEditorUIManager_instances.add(this);
          _AnnotationEditorUIManager_activeEditor.set(this, null);
          _AnnotationEditorUIManager_allEditors.set(this, new Map());
          _AnnotationEditorUIManager_allLayers.set(this, new Map());
          _AnnotationEditorUIManager_altTextManager.set(this, null);
          _AnnotationEditorUIManager_annotationStorage.set(this, null);
          _AnnotationEditorUIManager_changedExistingAnnotations.set(this, null);
          _AnnotationEditorUIManager_commandManager.set(this, new CommandManager());
          _AnnotationEditorUIManager_currentPageIndex.set(this, 0);
          _AnnotationEditorUIManager_deletedAnnotationsElementIds.set(this, new Set());
          _AnnotationEditorUIManager_draggingEditors.set(this, null);
          _AnnotationEditorUIManager_editorTypes.set(this, null);
          _AnnotationEditorUIManager_editorsToRescale.set(this, new Set());
          _AnnotationEditorUIManager_enableHighlightFloatingButton.set(this, false);
          _AnnotationEditorUIManager_filterFactory.set(this, null);
          _AnnotationEditorUIManager_focusMainContainerTimeoutId.set(this, null);
          _AnnotationEditorUIManager_highlightColors.set(this, null);
          _AnnotationEditorUIManager_highlightWhenShiftUp.set(this, false);
          _AnnotationEditorUIManager_highlightToolbar.set(this, null);
          _AnnotationEditorUIManager_idManager.set(this, new IdManager());
          _AnnotationEditorUIManager_isEnabled.set(this, false);
          _AnnotationEditorUIManager_isWaiting.set(this, false);
          _AnnotationEditorUIManager_lastActiveElement.set(this, null);
          _AnnotationEditorUIManager_mainHighlightColorPicker.set(this, null);
          _AnnotationEditorUIManager_mlManager.set(this, null);
          _AnnotationEditorUIManager_mode.set(this, AnnotationEditorType.NONE);
          _AnnotationEditorUIManager_selectedEditors.set(this, new Set());
          _AnnotationEditorUIManager_selectedTextNode.set(this, null);
          _AnnotationEditorUIManager_pageColors.set(this, null);
          _AnnotationEditorUIManager_showAllStates.set(this, null);
          _AnnotationEditorUIManager_boundBlur.set(this, this.blur.bind(this));
          _AnnotationEditorUIManager_boundFocus.set(this, this.focus.bind(this));
          _AnnotationEditorUIManager_boundCopy.set(this, this.copy.bind(this));
          _AnnotationEditorUIManager_boundCut.set(this, this.cut.bind(this));
          _AnnotationEditorUIManager_boundPaste.set(this, this.paste.bind(this));
          _AnnotationEditorUIManager_boundKeydown.set(this, this.keydown.bind(this));
          _AnnotationEditorUIManager_boundKeyup.set(this, this.keyup.bind(this));
          _AnnotationEditorUIManager_boundOnEditingAction.set(this, this.onEditingAction.bind(this));
          _AnnotationEditorUIManager_boundOnPageChanging.set(this, this.onPageChanging.bind(this));
          _AnnotationEditorUIManager_boundOnScaleChanging.set(this, this.onScaleChanging.bind(this));
          _AnnotationEditorUIManager_boundSelectionChange.set(this, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_selectionChange).bind(this));
          _AnnotationEditorUIManager_boundOnRotationChanging.set(this, this.onRotationChanging.bind(this));
          _AnnotationEditorUIManager_previousStates.set(this, {
              isEditing: false,
              isEmpty: true,
              hasSomethingToUndo: false,
              hasSomethingToRedo: false,
              hasSelectedEditor: false,
              hasSelectedText: false
          });
          _AnnotationEditorUIManager_translation.set(this, [0, 0]);
          _AnnotationEditorUIManager_translationTimeoutId.set(this, null);
          _AnnotationEditorUIManager_container.set(this, null);
          _AnnotationEditorUIManager_viewer.set(this, null);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_container, container, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_viewer, viewer, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_altTextManager, altTextManager, "f");
          this._eventBus = eventBus;
          this._eventBus._on("editingaction", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnEditingAction, "f"));
          this._eventBus._on("pagechanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnPageChanging, "f"));
          this._eventBus._on("scalechanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnScaleChanging, "f"));
          this._eventBus._on("rotationchanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnRotationChanging, "f"));
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addSelectionListener).call(this);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addKeyboardManager).call(this);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_annotationStorage, pdfDocument.annotationStorage, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_filterFactory, pdfDocument.filterFactory, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_pageColors, pageColors, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightColors, highlightColors || null, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_enableHighlightFloatingButton, enableHighlightFloatingButton, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_mlManager, mlManager || null, "f");
          this.viewParameters = {
              realScale: PixelsPerInch.PDF_TO_CSS_UNITS,
              rotation: 0
          };
          this.isShiftKeyDown = false;
      }
      Object.defineProperty(AnnotationEditorUIManager, "_keyboardManager", {
          get: function () {
              var proto = AnnotationEditorUIManager.prototype;
              var arrowChecker = function (self) { return tslib_1.__classPrivateFieldGet(self, _AnnotationEditorUIManager_container, "f").contains(document.activeElement) && document.activeElement.tagName !== "BUTTON" && self.hasSomethingToControl(); };
              var textInputChecker = function (_self, _f) {
                  var el = _f.target;
                  if (el instanceof HTMLInputElement) {
                      var type = el.type;
                      return type !== "text" && type !== "number";
                  }
                  return true;
              };
              var small = this.TRANSLATE_SMALL;
              var big = this.TRANSLATE_BIG;
              return shadow(this, "_keyboardManager", new KeyboardManager([[["ctrl+a", "mac+meta+a"], proto.selectAll, {
                          checker: textInputChecker
                      }], [["ctrl+z", "mac+meta+z"], proto.undo, {
                          checker: textInputChecker
                      }], [["ctrl+y", "ctrl+shift+z", "mac+meta+shift+z", "ctrl+shift+Z", "mac+meta+shift+Z"], proto.redo, {
                          checker: textInputChecker
                      }], [["Backspace", "alt+Backspace", "ctrl+Backspace", "shift+Backspace", "mac+Backspace", "mac+alt+Backspace", "mac+ctrl+Backspace", "Delete", "ctrl+Delete", "shift+Delete", "mac+Delete"], proto.delete, {
                          checker: textInputChecker
                      }], [["Enter", "mac+Enter"], proto.addNewEditorFromKeyboard, {
                          checker: function (self, _f) {
                              var el = _f.target;
                              return !(el instanceof HTMLButtonElement) && tslib_1.__classPrivateFieldGet(self, _AnnotationEditorUIManager_container, "f").contains(el) && !self.isEnterHandled;
                          }
                      }], [[" ", "mac+ "], proto.addNewEditorFromKeyboard, {
                          checker: function (self, _f) {
                              var el = _f.target;
                              return !(el instanceof HTMLButtonElement) && tslib_1.__classPrivateFieldGet(self, _AnnotationEditorUIManager_container, "f").contains(document.activeElement);
                          }
                      }], [["Escape", "mac+Escape"], proto.unselectAll], [["ArrowLeft", "mac+ArrowLeft"], proto.translateSelectedEditors, {
                          args: [-small, 0],
                          checker: arrowChecker
                      }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], proto.translateSelectedEditors, {
                          args: [-big, 0],
                          checker: arrowChecker
                      }], [["ArrowRight", "mac+ArrowRight"], proto.translateSelectedEditors, {
                          args: [small, 0],
                          checker: arrowChecker
                      }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], proto.translateSelectedEditors, {
                          args: [big, 0],
                          checker: arrowChecker
                      }], [["ArrowUp", "mac+ArrowUp"], proto.translateSelectedEditors, {
                          args: [0, -small],
                          checker: arrowChecker
                      }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], proto.translateSelectedEditors, {
                          args: [0, -big],
                          checker: arrowChecker
                      }], [["ArrowDown", "mac+ArrowDown"], proto.translateSelectedEditors, {
                          args: [0, small],
                          checker: arrowChecker
                      }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], proto.translateSelectedEditors, {
                          args: [0, big],
                          checker: arrowChecker
                      }]]));
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.destroy = function () {
          var _f, _g;
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeKeyboardManager).call(this);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeFocusManager).call(this);
          this._eventBus._off("editingaction", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnEditingAction, "f"));
          this._eventBus._off("pagechanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnPageChanging, "f"));
          this._eventBus._off("scalechanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnScaleChanging, "f"));
          this._eventBus._off("rotationchanging", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundOnRotationChanging, "f"));
          for (var _i = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _h.length; _i++) {
              var layer = _h[_i];
              layer.destroy();
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorsToRescale, "f").clear();
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_activeEditor, null, "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").destroy();
          (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_altTextManager, "f")) === null || _f === void 0 ? void 0 : _f.destroy();
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f")) === null || _g === void 0 ? void 0 : _g.hide();
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightToolbar, null, "f");
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, "f"));
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, null, "f");
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translationTimeoutId, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translationTimeoutId, "f"));
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_translationTimeoutId, null, "f");
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeSelectionListener).call(this);
      };
      AnnotationEditorUIManager.prototype.mlGuess = function (data) {
          var _f;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              return tslib_1.__generator(this, function (_g) {
                  return [2 /*return*/, ((_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mlManager, "f")) === null || _f === void 0 ? void 0 : _f.guess(data)) || null];
              });
          });
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "hasMLManager", {
          get: function () {
              return !!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mlManager, "f");
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorUIManager.prototype, "hcmFilter", {
          get: function () {
              return shadow(this, "hcmFilter", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_pageColors, "f") ? tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_filterFactory, "f").addHCMFilter(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_pageColors, "f").foreground, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_pageColors, "f").background) : "none");
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorUIManager.prototype, "direction", {
          get: function () {
              return shadow(this, "direction", getComputedStyle(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_container, "f")).direction);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorUIManager.prototype, "highlightColors", {
          get: function () {
              return shadow(this, "highlightColors", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightColors, "f") ? new Map(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightColors, "f").split(",").map(function (pair) { return pair.split("=").map(function (x) { return x.trim(); }); })) : null);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorUIManager.prototype, "highlightColorNames", {
          get: function () {
              return shadow(this, "highlightColorNames", this.highlightColors ? new Map(Array.from(this.highlightColors, function (e) { return e.reverse(); })) : null);
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.setMainHighlightColorPicker = function (colorPicker) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_mainHighlightColorPicker, colorPicker, "f");
      };
      AnnotationEditorUIManager.prototype.editAltText = function (editor) {
          var _f;
          (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_altTextManager, "f")) === null || _f === void 0 ? void 0 : _f.editAltText(this, editor);
      };
      AnnotationEditorUIManager.prototype.onPageChanging = function (_f) {
          var pageNumber = _f.pageNumber;
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_currentPageIndex, pageNumber - 1, "f");
      };
      AnnotationEditorUIManager.prototype.focusMainContainer = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_container, "f").focus();
      };
      AnnotationEditorUIManager.prototype.findParent = function (x, y) {
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
              var layer = _f[_i];
              var _g = layer.div.getBoundingClientRect(), layerX = _g.x, layerY = _g.y, width = _g.width, height = _g.height;
              if (x >= layerX && x <= layerX + width && y >= layerY && y <= layerY + height) {
                  return layer;
              }
          }
          return null;
      };
      AnnotationEditorUIManager.prototype.disableUserSelect = function (value) {
          if (value === void 0) { value = false; }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_viewer, "f").classList.toggle("noUserSelect", value);
      };
      AnnotationEditorUIManager.prototype.addShouldRescale = function (editor) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorsToRescale, "f").add(editor);
      };
      AnnotationEditorUIManager.prototype.removeShouldRescale = function (editor) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorsToRescale, "f").delete(editor);
      };
      AnnotationEditorUIManager.prototype.onScaleChanging = function (_f) {
          var scale = _f.scale;
          this.commitOrRemove();
          this.viewParameters.realScale = scale * PixelsPerInch.PDF_TO_CSS_UNITS;
          for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorsToRescale, "f"); _i < _g.length; _i++) {
              var editor = _g[_i];
              editor.onScaleChanging();
          }
      };
      AnnotationEditorUIManager.prototype.onRotationChanging = function (_f) {
          var pagesRotation = _f.pagesRotation;
          this.commitOrRemove();
          this.viewParameters.rotation = pagesRotation;
      };
      AnnotationEditorUIManager.prototype.highlightSelection = function (methodOfCreation) {
          if (methodOfCreation === void 0) { methodOfCreation = ""; }
          var selection = document.getSelection();
          if (!selection || selection.isCollapsed) {
              return;
          }
          var anchorNode = selection.anchorNode, anchorOffset = selection.anchorOffset, focusNode = selection.focusNode, focusOffset = selection.focusOffset;
          var text = selection.toString();
          var anchorElement = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_getAnchorElementForSelection).call(this, selection);
          var textLayer = anchorElement.closest(".textLayer");
          var boxes = this.getSelectionBoxes(textLayer);
          if (!boxes) {
              return;
          }
          selection.empty();
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === AnnotationEditorType.NONE) {
              this._eventBus.dispatch("showannotationeditorui", {
                  source: this,
                  mode: AnnotationEditorType.HIGHLIGHT
              });
              this.showAllEditors("highlight", true, true);
          }
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
              var layer = _f[_i];
              if (layer.hasTextLayer(textLayer)) {
                  layer.createAndAddNewEditor({
                      x: 0,
                      y: 0
                  }, false, {
                      methodOfCreation: methodOfCreation,
                      boxes: boxes,
                      anchorNode: anchorNode,
                      anchorOffset: anchorOffset,
                      focusNode: focusNode,
                      focusOffset: focusOffset,
                      text: text
                  });
                  break;
              }
          }
      };
      AnnotationEditorUIManager.prototype.addToAnnotationStorage = function (editor) {
          if (!editor.isEmpty() && tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_annotationStorage, "f") && !tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_annotationStorage, "f").has(editor.id)) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_annotationStorage, "f").setValue(editor.id, editor);
          }
      };
      AnnotationEditorUIManager.prototype.blur = function () {
          this.isShiftKeyDown = false;
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightWhenShiftUp, "f")) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightWhenShiftUp, false, "f");
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_onSelectEnd).call(this, "main_toolbar");
          }
          if (!this.hasSelection) {
              return;
          }
          var activeElement = document.activeElement;
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var editor = _f[_i];
              if (editor.div.contains(activeElement)) {
                  tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_lastActiveElement, [editor, activeElement], "f");
                  editor._focusEventsAllowed = false;
                  break;
              }
          }
      };
      AnnotationEditorUIManager.prototype.focus = function () {
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_lastActiveElement, "f")) {
              return;
          }
          var _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_lastActiveElement, "f"), lastEditor = _f[0], lastActiveElement = _f[1];
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_lastActiveElement, null, "f");
          lastActiveElement.addEventListener("focusin", function () {
              lastEditor._focusEventsAllowed = true;
          }, {
              once: true
          });
          lastActiveElement.focus();
      };
      AnnotationEditorUIManager.prototype.addEditListeners = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addKeyboardManager).call(this);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addCopyPasteListeners).call(this);
      };
      AnnotationEditorUIManager.prototype.removeEditListeners = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeKeyboardManager).call(this);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeCopyPasteListeners).call(this);
      };
      AnnotationEditorUIManager.prototype.copy = function (event) {
          var _f;
          event.preventDefault();
          (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f")) === null || _f === void 0 ? void 0 : _f.commitOrRemove();
          if (!this.hasSelection) {
              return;
          }
          var editors = [];
          for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _g.length; _i++) {
              var editor = _g[_i];
              var serialized = editor.serialize(true);
              if (serialized) {
                  editors.push(serialized);
              }
          }
          if (editors.length === 0) {
              return;
          }
          event.clipboardData.setData("application/pdfjs", JSON.stringify(editors));
      };
      AnnotationEditorUIManager.prototype.cut = function (event) {
          this.copy(event);
          this.delete();
      };
      AnnotationEditorUIManager.prototype.paste = function (event) {
          var _this = this;
          event.preventDefault();
          var clipboardData = event.clipboardData;
          for (var _i = 0, _f = clipboardData.items; _i < _f.length; _i++) {
              var item = _f[_i];
              for (var _g = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorTypes, "f"); _g < _h.length; _g++) {
                  var editorType = _h[_g];
                  if (editorType.isHandlingMimeForPasting(item.type)) {
                      editorType.paste(item, this.currentLayer);
                      return;
                  }
              }
          }
          var data = clipboardData.getData("application/pdfjs");
          if (!data) {
              return;
          }
          try {
              data = JSON.parse(data);
          }
          catch (ex) {
              warn("paste: \"".concat(ex.message, "\"."));
              return;
          }
          if (!Array.isArray(data)) {
              return;
          }
          this.unselectAll();
          var layer = this.currentLayer;
          try {
              var newEditors_1 = [];
              for (var _j = 0, data_1 = data; _j < data_1.length; _j++) {
                  var editor = data_1[_j];
                  var deserializedEditor = layer.deserialize(editor);
                  if (!deserializedEditor) {
                      return;
                  }
                  newEditors_1.push(deserializedEditor);
              }
              var cmd = function () {
                  for (var _i = 0, newEditors_2 = newEditors_1; _i < newEditors_2.length; _i++) {
                      var editor = newEditors_2[_i];
                      tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addEditorToLayer).call(_this, editor);
                  }
                  tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_selectEditors).call(_this, newEditors_1);
              };
              var undo = function () {
                  for (var _i = 0, newEditors_3 = newEditors_1; _i < newEditors_3.length; _i++) {
                      var editor = newEditors_3[_i];
                      editor.remove();
                  }
              };
              this.addCommands({
                  cmd: cmd,
                  undo: undo,
                  mustExec: true
              });
          }
          catch (ex) {
              warn("paste: \"".concat(ex.message, "\"."));
          }
      };
      AnnotationEditorUIManager.prototype.keydown = function (event) {
          if (!this.isShiftKeyDown && event.key === "Shift") {
              this.isShiftKeyDown = true;
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") !== AnnotationEditorType.NONE && !this.isEditorHandlingKeyboard) {
              AnnotationEditorUIManager._keyboardManager.exec(this, event);
          }
      };
      AnnotationEditorUIManager.prototype.keyup = function (event) {
          if (this.isShiftKeyDown && event.key === "Shift") {
              this.isShiftKeyDown = false;
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightWhenShiftUp, "f")) {
                  tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightWhenShiftUp, false, "f");
                  tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_onSelectEnd).call(this, "main_toolbar");
              }
          }
      };
      AnnotationEditorUIManager.prototype.onEditingAction = function (_f) {
          var name = _f.name;
          switch (name) {
              case "undo":
              case "redo":
              case "delete":
              case "selectAll":
                  this[name]();
                  break;
              case "highlightSelection":
                  this.highlightSelection("context_menu");
                  break;
          }
      };
      AnnotationEditorUIManager.prototype.setEditingState = function (isEditing) {
          if (isEditing) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addFocusManager).call(this);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addCopyPasteListeners).call(this);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
                  isEditing: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") !== AnnotationEditorType.NONE,
                  isEmpty: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_isEmpty).call(this),
                  hasSomethingToUndo: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").hasSomethingToUndo(),
                  hasSomethingToRedo: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").hasSomethingToRedo(),
                  hasSelectedEditor: false
              });
          }
          else {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeFocusManager).call(this);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_removeCopyPasteListeners).call(this);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
                  isEditing: false
              });
              this.disableUserSelect(false);
          }
      };
      AnnotationEditorUIManager.prototype.registerEditorTypes = function (types) {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorTypes, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_editorTypes, types, "f");
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorTypes, "f"); _i < _f.length; _i++) {
              var editorType = _f[_i];
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, editorType.defaultPropertiesToUpdate);
          }
      };
      AnnotationEditorUIManager.prototype.getId = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_idManager, "f").id;
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "currentLayer", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").get(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_currentPageIndex, "f"));
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.getLayer = function (pageIndex) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").get(pageIndex);
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "currentPageIndex", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_currentPageIndex, "f");
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.addLayer = function (layer) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").set(layer.pageIndex, layer);
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_isEnabled, "f")) {
              layer.enable();
          }
          else {
              layer.disable();
          }
      };
      AnnotationEditorUIManager.prototype.removeLayer = function (layer) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").delete(layer.pageIndex);
      };
      AnnotationEditorUIManager.prototype.updateMode = function (mode, editId, isFromKeyboard) {
          if (editId === void 0) { editId = null; }
          if (isFromKeyboard === void 0) { isFromKeyboard = false; }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === mode) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_mode, mode, "f");
          if (mode === AnnotationEditorType.NONE) {
              this.setEditingState(false);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_disableAll).call(this);
              return;
          }
          this.setEditingState(true);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_enableAll).call(this);
          this.unselectAll();
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
              var layer = _f[_i];
              layer.updateMode(mode);
          }
          if (!editId && isFromKeyboard) {
              this.addNewEditorFromKeyboard();
              return;
          }
          if (!editId) {
              return;
          }
          for (var _g = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _g < _h.length; _g++) {
              var editor = _h[_g];
              if (editor.annotationElementId === editId) {
                  this.setSelected(editor);
                  editor.enterInEditMode();
                  break;
              }
          }
      };
      AnnotationEditorUIManager.prototype.addNewEditorFromKeyboard = function () {
          if (this.currentLayer.canCreateNewEmptyEditor()) {
              this.currentLayer.addNewEditor();
          }
      };
      AnnotationEditorUIManager.prototype.updateToolbar = function (mode) {
          if (mode === tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f")) {
              return;
          }
          this._eventBus.dispatch("switchannotationeditormode", {
              source: this,
              mode: mode
          });
      };
      AnnotationEditorUIManager.prototype.updateParams = function (type, value) {
          var _f;
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorTypes, "f")) {
              return;
          }
          switch (type) {
              case AnnotationEditorParamsType.CREATE:
                  this.currentLayer.addNewEditor();
                  return;
              case AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR:
                  (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mainHighlightColorPicker, "f")) === null || _f === void 0 ? void 0 : _f.updateColor(value);
                  break;
              case AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL:
                  this._eventBus.dispatch("reporttelemetry", {
                      source: this,
                      details: {
                          type: "editing",
                          data: {
                              type: "highlight",
                              action: "toggle_visibility"
                          }
                      }
                  });
                  (tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_showAllStates, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_showAllStates, "f") || new Map(), "f")).set(type, value);
                  this.showAllEditors("highlight", value);
                  break;
          }
          for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _g.length; _i++) {
              var editor = _g[_i];
              editor.updateParams(type, value);
          }
          for (var _h = 0, _j = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_editorTypes, "f"); _h < _j.length; _h++) {
              var editorType = _j[_h];
              editorType.updateDefaultParams(type, value);
          }
      };
      AnnotationEditorUIManager.prototype.showAllEditors = function (type, visible, updateButton) {
          var _f, _g;
          if (updateButton === void 0) { updateButton = false; }
          for (var _i = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _i < _h.length; _i++) {
              var editor = _h[_i];
              if (editor.editorType === type) {
                  editor.show(visible);
              }
          }
          var state = (_g = (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_showAllStates, "f")) === null || _f === void 0 ? void 0 : _f.get(AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL)) !== null && _g !== void 0 ? _g : true;
          if (state !== visible) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, [[AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL, visible]]);
          }
      };
      AnnotationEditorUIManager.prototype.enableWaiting = function (mustWait) {
          if (mustWait === void 0) { mustWait = false; }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_isWaiting, "f") === mustWait) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_isWaiting, mustWait, "f");
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
              var layer = _f[_i];
              if (mustWait) {
                  layer.disableClick();
              }
              else {
                  layer.enableClick();
              }
              layer.div.classList.toggle("waiting", mustWait);
          }
      };
      AnnotationEditorUIManager.prototype.getEditors = function (pageIndex) {
          var editors = [];
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _i < _f.length; _i++) {
              var editor = _f[_i];
              if (editor.pageIndex === pageIndex) {
                  editors.push(editor);
              }
          }
          return editors;
      };
      AnnotationEditorUIManager.prototype.getEditor = function (id) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").get(id);
      };
      AnnotationEditorUIManager.prototype.addEditor = function (editor) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").set(editor.id, editor);
      };
      AnnotationEditorUIManager.prototype.removeEditor = function (editor) {
          var _this = this;
          var _f;
          if (editor.div.contains(document.activeElement)) {
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, "f")) {
                  clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, "f"));
              }
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, setTimeout(function () {
                  _this.focusMainContainer();
                  tslib_1.__classPrivateFieldSet(_this, _AnnotationEditorUIManager_focusMainContainerTimeoutId, null, "f");
              }, 0), "f");
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").delete(editor.id);
          this.unselect(editor);
          if (!editor.annotationElementId || !tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_deletedAnnotationsElementIds, "f").has(editor.annotationElementId)) {
              (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_annotationStorage, "f")) === null || _f === void 0 ? void 0 : _f.remove(editor.id);
          }
      };
      AnnotationEditorUIManager.prototype.addDeletedAnnotationElement = function (editor) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_deletedAnnotationsElementIds, "f").add(editor.annotationElementId);
          this.addChangedExistingAnnotation(editor);
          editor.deleted = true;
      };
      AnnotationEditorUIManager.prototype.isDeletedAnnotationElement = function (annotationElementId) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_deletedAnnotationsElementIds, "f").has(annotationElementId);
      };
      AnnotationEditorUIManager.prototype.removeDeletedAnnotationElement = function (editor) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_deletedAnnotationsElementIds, "f").delete(editor.annotationElementId);
          this.removeChangedExistingAnnotation(editor);
          editor.deleted = false;
      };
      AnnotationEditorUIManager.prototype.setActiveEditor = function (editor) {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f") === editor) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_activeEditor, editor, "f");
          if (editor) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, editor.propertiesToUpdate);
          }
      };
      AnnotationEditorUIManager.prototype.updateUI = function (editor) {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "a", _AnnotationEditorUIManager_lastSelectedEditor_get) === editor) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, editor.propertiesToUpdate);
          }
      };
      AnnotationEditorUIManager.prototype.toggleSelected = function (editor) {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").has(editor)) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").delete(editor);
              editor.unselect();
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
                  hasSelectedEditor: this.hasSelection
              });
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").add(editor);
          editor.select();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, editor.propertiesToUpdate);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedEditor: true
          });
      };
      AnnotationEditorUIManager.prototype.setSelected = function (editor) {
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var ed = _f[_i];
              if (ed !== editor) {
                  ed.unselect();
              }
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").add(editor);
          editor.select();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, editor.propertiesToUpdate);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedEditor: true
          });
      };
      AnnotationEditorUIManager.prototype.isSelected = function (editor) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").has(editor);
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "firstSelectedEditor", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").values().next().value;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.unselect = function (editor) {
          editor.unselect();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").delete(editor);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedEditor: this.hasSelection
          });
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "hasSelection", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").size !== 0;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorUIManager.prototype, "isEnterHandled", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").size === 1 && this.firstSelectedEditor.isEnterHandled;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.undo = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").undo();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSomethingToUndo: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").hasSomethingToUndo(),
              hasSomethingToRedo: true,
              isEmpty: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_isEmpty).call(this)
          });
      };
      AnnotationEditorUIManager.prototype.redo = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").redo();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSomethingToUndo: true,
              hasSomethingToRedo: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").hasSomethingToRedo(),
              isEmpty: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_isEmpty).call(this)
          });
      };
      AnnotationEditorUIManager.prototype.addCommands = function (params) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_commandManager, "f").add(params);
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSomethingToUndo: true,
              hasSomethingToRedo: false,
              isEmpty: tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_isEmpty).call(this)
          });
      };
      AnnotationEditorUIManager.prototype.delete = function () {
          var _this = this;
          this.commitOrRemove();
          if (!this.hasSelection) {
              return;
          }
          var editors = tslib_1.__spreadArray([], tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"), true);
          var cmd = function () {
              for (var _i = 0, editors_1 = editors; _i < editors_1.length; _i++) {
                  var editor = editors_1[_i];
                  editor.remove();
              }
          };
          var undo = function () {
              for (var _i = 0, editors_2 = editors; _i < editors_2.length; _i++) {
                  var editor = editors_2[_i];
                  tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_addEditorToLayer).call(_this, editor);
              }
          };
          this.addCommands({
              cmd: cmd,
              undo: undo,
              mustExec: true
          });
      };
      AnnotationEditorUIManager.prototype.commitOrRemove = function () {
          var _f;
          (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f")) === null || _f === void 0 ? void 0 : _f.commitOrRemove();
      };
      AnnotationEditorUIManager.prototype.hasSomethingToControl = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f") || this.hasSelection;
      };
      AnnotationEditorUIManager.prototype.selectAll = function () {
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var editor = _f[_i];
              editor.commit();
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_selectEditors).call(this, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values());
      };
      AnnotationEditorUIManager.prototype.unselectAll = function () {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f")) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f").commitOrRemove();
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") !== AnnotationEditorType.NONE) {
                  return;
              }
          }
          if (!this.hasSelection) {
              return;
          }
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var editor = _f[_i];
              editor.unselect();
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedEditor: false
          });
      };
      AnnotationEditorUIManager.prototype.translateSelectedEditors = function (x, y, noCommit) {
          var _this = this;
          if (noCommit === void 0) { noCommit = false; }
          if (!noCommit) {
              this.commitOrRemove();
          }
          if (!this.hasSelection) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translation, "f")[0] += x;
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translation, "f")[1] += y;
          var _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translation, "f"), totalX = _f[0], totalY = _f[1];
          var editors = tslib_1.__spreadArray([], tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"), true);
          var TIME_TO_WAIT = 1000;
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translationTimeoutId, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_translationTimeoutId, "f"));
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_translationTimeoutId, setTimeout(function () {
              tslib_1.__classPrivateFieldSet(_this, _AnnotationEditorUIManager_translationTimeoutId, null, "f");
              tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_translation, "f")[0] = tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_translation, "f")[1] = 0;
              _this.addCommands({
                  cmd: function () {
                      for (var _i = 0, editors_4 = editors; _i < editors_4.length; _i++) {
                          var editor = editors_4[_i];
                          if (tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_allEditors, "f").has(editor.id)) {
                              editor.translateInPage(totalX, totalY);
                          }
                      }
                  },
                  undo: function () {
                      for (var _i = 0, editors_5 = editors; _i < editors_5.length; _i++) {
                          var editor = editors_5[_i];
                          if (tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_allEditors, "f").has(editor.id)) {
                              editor.translateInPage(-totalX, -totalY);
                          }
                      }
                  },
                  mustExec: false
              });
          }, TIME_TO_WAIT), "f");
          for (var _i = 0, editors_3 = editors; _i < editors_3.length; _i++) {
              var editor = editors_3[_i];
              editor.translateInPage(x, y);
          }
      };
      AnnotationEditorUIManager.prototype.setUpDragSession = function () {
          if (!this.hasSelection) {
              return;
          }
          this.disableUserSelect(true);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_draggingEditors, new Map(), "f");
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var editor = _f[_i];
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_draggingEditors, "f").set(editor, {
                  savedX: editor.x,
                  savedY: editor.y,
                  savedPageIndex: editor.pageIndex,
                  newX: 0,
                  newY: 0,
                  newPageIndex: -1
              });
          }
      };
      AnnotationEditorUIManager.prototype.endDragSession = function () {
          var _this = this;
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_draggingEditors, "f")) {
              return false;
          }
          this.disableUserSelect(false);
          var map = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_draggingEditors, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_draggingEditors, null, "f");
          var mustBeAddedInUndoStack = false;
          for (var _i = 0, map_2 = map; _i < map_2.length; _i++) {
              var _f = map_2[_i], _g = _f[0], x = _g.x, y = _g.y, pageIndex = _g.pageIndex, value = _f[1];
              value.newX = x;
              value.newY = y;
              value.newPageIndex = pageIndex;
              mustBeAddedInUndoStack || (mustBeAddedInUndoStack = x !== value.savedX || y !== value.savedY || pageIndex !== value.savedPageIndex);
          }
          if (!mustBeAddedInUndoStack) {
              return false;
          }
          var move = function (editor, x, y, pageIndex) {
              if (tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_allEditors, "f").has(editor.id)) {
                  var parent = tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_allLayers, "f").get(pageIndex);
                  if (parent) {
                      editor._setParentAndPosition(parent, x, y);
                  }
                  else {
                      editor.pageIndex = pageIndex;
                      editor.x = x;
                      editor.y = y;
                  }
              }
          };
          this.addCommands({
              cmd: function () {
                  for (var _i = 0, map_3 = map; _i < map_3.length; _i++) {
                      var _f = map_3[_i], editor = _f[0], _g = _f[1], newX = _g.newX, newY = _g.newY, newPageIndex = _g.newPageIndex;
                      move(editor, newX, newY, newPageIndex);
                  }
              },
              undo: function () {
                  for (var _i = 0, map_4 = map; _i < map_4.length; _i++) {
                      var _f = map_4[_i], editor = _f[0], _g = _f[1], savedX = _g.savedX, savedY = _g.savedY, savedPageIndex = _g.savedPageIndex;
                      move(editor, savedX, savedY, savedPageIndex);
                  }
              },
              mustExec: true
          });
          return true;
      };
      AnnotationEditorUIManager.prototype.dragSelectedEditors = function (tx, ty) {
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_draggingEditors, "f")) {
              return;
          }
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_draggingEditors, "f").keys(); _i < _f.length; _i++) {
              var editor = _f[_i];
              editor.drag(tx, ty);
          }
      };
      AnnotationEditorUIManager.prototype.rebuild = function (editor) {
          if (editor.parent === null) {
              var parent = this.getLayer(editor.pageIndex);
              if (parent) {
                  parent.changeParent(editor);
                  parent.addOrRebuild(editor);
              }
              else {
                  this.addEditor(editor);
                  this.addToAnnotationStorage(editor);
                  editor.rebuild();
              }
          }
          else {
              editor.parent.addOrRebuild(editor);
          }
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "isEditorHandlingKeyboard", {
          get: function () {
              var _f;
              return ((_f = this.getActive()) === null || _f === void 0 ? void 0 : _f.shouldGetKeyboardEvents()) || tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").size === 1 && this.firstSelectedEditor.shouldGetKeyboardEvents();
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.isActive = function (editor) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f") === editor;
      };
      AnnotationEditorUIManager.prototype.getActive = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_activeEditor, "f");
      };
      AnnotationEditorUIManager.prototype.getMode = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f");
      };
      Object.defineProperty(AnnotationEditorUIManager.prototype, "imageManager", {
          get: function () {
              return shadow(this, "imageManager", new ImageManager());
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorUIManager.prototype.getSelectionBoxes = function (textLayer) {
          if (!textLayer) {
              return null;
          }
          var selection = document.getSelection();
          for (var i = 0, ii = selection.rangeCount; i < ii; i++) {
              if (!textLayer.contains(selection.getRangeAt(i).commonAncestorContainer)) {
                  return null;
              }
          }
          var _f = textLayer.getBoundingClientRect(), layerX = _f.x, layerY = _f.y, parentWidth = _f.width, parentHeight = _f.height;
          var rotator;
          switch (textLayer.getAttribute("data-main-rotation")) {
              case "90":
                  rotator = function (x, y, w, h) { return ({
                      x: (y - layerY) / parentHeight,
                      y: 1 - (x + w - layerX) / parentWidth,
                      width: h / parentHeight,
                      height: w / parentWidth
                  }); };
                  break;
              case "180":
                  rotator = function (x, y, w, h) { return ({
                      x: 1 - (x + w - layerX) / parentWidth,
                      y: 1 - (y + h - layerY) / parentHeight,
                      width: w / parentWidth,
                      height: h / parentHeight
                  }); };
                  break;
              case "270":
                  rotator = function (x, y, w, h) { return ({
                      x: 1 - (y + h - layerY) / parentHeight,
                      y: (x - layerX) / parentWidth,
                      width: h / parentHeight,
                      height: w / parentWidth
                  }); };
                  break;
              default:
                  rotator = function (x, y, w, h) { return ({
                      x: (x - layerX) / parentWidth,
                      y: (y - layerY) / parentHeight,
                      width: w / parentWidth,
                      height: h / parentHeight
                  }); };
                  break;
          }
          var boxes = [];
          for (var i = 0, ii = selection.rangeCount; i < ii; i++) {
              var range = selection.getRangeAt(i);
              if (range.collapsed) {
                  continue;
              }
              for (var _i = 0, _g = range.getClientRects(); _i < _g.length; _i++) {
                  var _h = _g[_i], x = _h.x, y = _h.y, width = _h.width, height = _h.height;
                  if (width === 0 || height === 0) {
                      continue;
                  }
                  boxes.push(rotator(x, y, width, height));
              }
          }
          return boxes.length === 0 ? null : boxes;
      };
      AnnotationEditorUIManager.prototype.addChangedExistingAnnotation = function (_f) {
          var annotationElementId = _f.annotationElementId, id = _f.id;
          (tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_changedExistingAnnotations, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_changedExistingAnnotations, "f") || new Map(), "f")).set(annotationElementId, id);
      };
      AnnotationEditorUIManager.prototype.removeChangedExistingAnnotation = function (_f) {
          var _g;
          var annotationElementId = _f.annotationElementId;
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_changedExistingAnnotations, "f")) === null || _g === void 0 ? void 0 : _g.delete(annotationElementId);
      };
      AnnotationEditorUIManager.prototype.renderAnnotationElement = function (annotation) {
          var _f;
          var editorId = (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_changedExistingAnnotations, "f")) === null || _f === void 0 ? void 0 : _f.get(annotation.data.id);
          if (!editorId) {
              return;
          }
          var editor = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_annotationStorage, "f").getRawValue(editorId);
          if (!editor) {
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === AnnotationEditorType.NONE && !editor.hasBeenModified) {
              return;
          }
          editor.renderAnnotationElement(annotation);
      };
      var _AnnotationEditorUIManager_instances, _AnnotationEditorUIManager_activeEditor, _AnnotationEditorUIManager_allEditors, _AnnotationEditorUIManager_allLayers, _AnnotationEditorUIManager_altTextManager, _AnnotationEditorUIManager_annotationStorage, _AnnotationEditorUIManager_changedExistingAnnotations, _AnnotationEditorUIManager_commandManager, _AnnotationEditorUIManager_currentPageIndex, _AnnotationEditorUIManager_deletedAnnotationsElementIds, _AnnotationEditorUIManager_draggingEditors, _AnnotationEditorUIManager_editorTypes, _AnnotationEditorUIManager_editorsToRescale, _AnnotationEditorUIManager_enableHighlightFloatingButton, _AnnotationEditorUIManager_filterFactory, _AnnotationEditorUIManager_focusMainContainerTimeoutId, _AnnotationEditorUIManager_highlightColors, _AnnotationEditorUIManager_highlightWhenShiftUp, _AnnotationEditorUIManager_highlightToolbar, _AnnotationEditorUIManager_idManager, _AnnotationEditorUIManager_isEnabled, _AnnotationEditorUIManager_isWaiting, _AnnotationEditorUIManager_lastActiveElement, _AnnotationEditorUIManager_mainHighlightColorPicker, _AnnotationEditorUIManager_mlManager, _AnnotationEditorUIManager_mode, _AnnotationEditorUIManager_selectedEditors, _AnnotationEditorUIManager_selectedTextNode, _AnnotationEditorUIManager_pageColors, _AnnotationEditorUIManager_showAllStates, _AnnotationEditorUIManager_boundBlur, _AnnotationEditorUIManager_boundFocus, _AnnotationEditorUIManager_boundCopy, _AnnotationEditorUIManager_boundCut, _AnnotationEditorUIManager_boundPaste, _AnnotationEditorUIManager_boundKeydown, _AnnotationEditorUIManager_boundKeyup, _AnnotationEditorUIManager_boundOnEditingAction, _AnnotationEditorUIManager_boundOnPageChanging, _AnnotationEditorUIManager_boundOnScaleChanging, _AnnotationEditorUIManager_boundSelectionChange, _AnnotationEditorUIManager_boundOnRotationChanging, _AnnotationEditorUIManager_previousStates, _AnnotationEditorUIManager_translation, _AnnotationEditorUIManager_translationTimeoutId, _AnnotationEditorUIManager_container, _AnnotationEditorUIManager_viewer, _AnnotationEditorUIManager_getAnchorElementForSelection, _AnnotationEditorUIManager_displayHighlightToolbar, _AnnotationEditorUIManager_selectionChange, _AnnotationEditorUIManager_onSelectEnd, _AnnotationEditorUIManager_addSelectionListener, _AnnotationEditorUIManager_removeSelectionListener, _AnnotationEditorUIManager_addFocusManager, _AnnotationEditorUIManager_removeFocusManager, _AnnotationEditorUIManager_addKeyboardManager, _AnnotationEditorUIManager_removeKeyboardManager, _AnnotationEditorUIManager_addCopyPasteListeners, _AnnotationEditorUIManager_removeCopyPasteListeners, _AnnotationEditorUIManager_dispatchUpdateStates, _AnnotationEditorUIManager_dispatchUpdateUI, _AnnotationEditorUIManager_enableAll, _AnnotationEditorUIManager_disableAll, _AnnotationEditorUIManager_addEditorToLayer, _AnnotationEditorUIManager_lastSelectedEditor_get, _AnnotationEditorUIManager_isEmpty, _AnnotationEditorUIManager_selectEditors;
      _AnnotationEditorUIManager_activeEditor = new WeakMap(), _AnnotationEditorUIManager_allEditors = new WeakMap(), _AnnotationEditorUIManager_allLayers = new WeakMap(), _AnnotationEditorUIManager_altTextManager = new WeakMap(), _AnnotationEditorUIManager_annotationStorage = new WeakMap(), _AnnotationEditorUIManager_changedExistingAnnotations = new WeakMap(), _AnnotationEditorUIManager_commandManager = new WeakMap(), _AnnotationEditorUIManager_currentPageIndex = new WeakMap(), _AnnotationEditorUIManager_deletedAnnotationsElementIds = new WeakMap(), _AnnotationEditorUIManager_draggingEditors = new WeakMap(), _AnnotationEditorUIManager_editorTypes = new WeakMap(), _AnnotationEditorUIManager_editorsToRescale = new WeakMap(), _AnnotationEditorUIManager_enableHighlightFloatingButton = new WeakMap(), _AnnotationEditorUIManager_filterFactory = new WeakMap(), _AnnotationEditorUIManager_focusMainContainerTimeoutId = new WeakMap(), _AnnotationEditorUIManager_highlightColors = new WeakMap(), _AnnotationEditorUIManager_highlightWhenShiftUp = new WeakMap(), _AnnotationEditorUIManager_highlightToolbar = new WeakMap(), _AnnotationEditorUIManager_idManager = new WeakMap(), _AnnotationEditorUIManager_isEnabled = new WeakMap(), _AnnotationEditorUIManager_isWaiting = new WeakMap(), _AnnotationEditorUIManager_lastActiveElement = new WeakMap(), _AnnotationEditorUIManager_mainHighlightColorPicker = new WeakMap(), _AnnotationEditorUIManager_mlManager = new WeakMap(), _AnnotationEditorUIManager_mode = new WeakMap(), _AnnotationEditorUIManager_selectedEditors = new WeakMap(), _AnnotationEditorUIManager_selectedTextNode = new WeakMap(), _AnnotationEditorUIManager_pageColors = new WeakMap(), _AnnotationEditorUIManager_showAllStates = new WeakMap(), _AnnotationEditorUIManager_boundBlur = new WeakMap(), _AnnotationEditorUIManager_boundFocus = new WeakMap(), _AnnotationEditorUIManager_boundCopy = new WeakMap(), _AnnotationEditorUIManager_boundCut = new WeakMap(), _AnnotationEditorUIManager_boundPaste = new WeakMap(), _AnnotationEditorUIManager_boundKeydown = new WeakMap(), _AnnotationEditorUIManager_boundKeyup = new WeakMap(), _AnnotationEditorUIManager_boundOnEditingAction = new WeakMap(), _AnnotationEditorUIManager_boundOnPageChanging = new WeakMap(), _AnnotationEditorUIManager_boundOnScaleChanging = new WeakMap(), _AnnotationEditorUIManager_boundSelectionChange = new WeakMap(), _AnnotationEditorUIManager_boundOnRotationChanging = new WeakMap(), _AnnotationEditorUIManager_previousStates = new WeakMap(), _AnnotationEditorUIManager_translation = new WeakMap(), _AnnotationEditorUIManager_translationTimeoutId = new WeakMap(), _AnnotationEditorUIManager_container = new WeakMap(), _AnnotationEditorUIManager_viewer = new WeakMap(), _AnnotationEditorUIManager_instances = new WeakSet(), _AnnotationEditorUIManager_getAnchorElementForSelection = function _AnnotationEditorUIManager_getAnchorElementForSelection(_f) {
          var anchorNode = _f.anchorNode;
          return anchorNode.nodeType === Node.TEXT_NODE ? anchorNode.parentElement : anchorNode;
      }, _AnnotationEditorUIManager_displayHighlightToolbar = function _AnnotationEditorUIManager_displayHighlightToolbar() {
          var selection = document.getSelection();
          if (!selection || selection.isCollapsed) {
              return;
          }
          var anchorElement = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_getAnchorElementForSelection).call(this, selection);
          var textLayer = anchorElement.closest(".textLayer");
          var boxes = this.getSelectionBoxes(textLayer);
          if (!boxes) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightToolbar, tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f") || new HighlightToolbar(this), "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f").show(textLayer, boxes, this.direction === "ltr");
      }, _AnnotationEditorUIManager_selectionChange = function _AnnotationEditorUIManager_selectionChange() {
          var _this = this;
          var _f, _g, _h;
          var selection = document.getSelection();
          if (!selection || selection.isCollapsed) {
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedTextNode, "f")) {
                  (_f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f")) === null || _f === void 0 ? void 0 : _f.hide();
                  tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_selectedTextNode, null, "f");
                  tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
                      hasSelectedText: false
                  });
              }
              return;
          }
          var anchorNode = selection.anchorNode;
          if (anchorNode === tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedTextNode, "f")) {
              return;
          }
          var anchorElement = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_getAnchorElementForSelection).call(this, selection);
          var textLayer = anchorElement.closest(".textLayer");
          if (!textLayer) {
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedTextNode, "f")) {
                  (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f")) === null || _g === void 0 ? void 0 : _g.hide();
                  tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_selectedTextNode, null, "f");
                  tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
                      hasSelectedText: false
                  });
              }
              return;
          }
          (_h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_highlightToolbar, "f")) === null || _h === void 0 ? void 0 : _h.hide();
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_selectedTextNode, anchorNode, "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedText: true
          });
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") !== AnnotationEditorType.HIGHLIGHT && tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") !== AnnotationEditorType.NONE) {
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === AnnotationEditorType.HIGHLIGHT) {
              this.showAllEditors("highlight", true, true);
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_highlightWhenShiftUp, this.isShiftKeyDown, "f");
          if (!this.isShiftKeyDown) {
              var pointerup_1 = function (e) {
                  if (e.type === "pointerup" && e.button !== 0) {
                      return;
                  }
                  window.removeEventListener("pointerup", pointerup_1);
                  window.removeEventListener("blur", pointerup_1);
                  if (e.type === "pointerup") {
                      tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_onSelectEnd).call(_this, "main_toolbar");
                  }
              };
              window.addEventListener("pointerup", pointerup_1);
              window.addEventListener("blur", pointerup_1);
          }
      }, _AnnotationEditorUIManager_onSelectEnd = function _AnnotationEditorUIManager_onSelectEnd(methodOfCreation) {
          if (methodOfCreation === void 0) { methodOfCreation = ""; }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === AnnotationEditorType.HIGHLIGHT) {
              this.highlightSelection(methodOfCreation);
          }
          else if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_enableHighlightFloatingButton, "f")) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_displayHighlightToolbar).call(this);
          }
      }, _AnnotationEditorUIManager_addSelectionListener = function _AnnotationEditorUIManager_addSelectionListener() {
          document.addEventListener("selectionchange", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundSelectionChange, "f"));
      }, _AnnotationEditorUIManager_removeSelectionListener = function _AnnotationEditorUIManager_removeSelectionListener() {
          document.removeEventListener("selectionchange", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundSelectionChange, "f"));
      }, _AnnotationEditorUIManager_addFocusManager = function _AnnotationEditorUIManager_addFocusManager() {
          window.addEventListener("focus", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundFocus, "f"));
          window.addEventListener("blur", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundBlur, "f"));
      }, _AnnotationEditorUIManager_removeFocusManager = function _AnnotationEditorUIManager_removeFocusManager() {
          window.removeEventListener("focus", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundFocus, "f"));
          window.removeEventListener("blur", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundBlur, "f"));
      }, _AnnotationEditorUIManager_addKeyboardManager = function _AnnotationEditorUIManager_addKeyboardManager() {
          window.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundKeydown, "f"));
          window.addEventListener("keyup", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundKeyup, "f"));
      }, _AnnotationEditorUIManager_removeKeyboardManager = function _AnnotationEditorUIManager_removeKeyboardManager() {
          window.removeEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundKeydown, "f"));
          window.removeEventListener("keyup", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundKeyup, "f"));
      }, _AnnotationEditorUIManager_addCopyPasteListeners = function _AnnotationEditorUIManager_addCopyPasteListeners() {
          document.addEventListener("copy", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundCopy, "f"));
          document.addEventListener("cut", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundCut, "f"));
          document.addEventListener("paste", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundPaste, "f"));
      }, _AnnotationEditorUIManager_removeCopyPasteListeners = function _AnnotationEditorUIManager_removeCopyPasteListeners() {
          document.removeEventListener("copy", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundCopy, "f"));
          document.removeEventListener("cut", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundCut, "f"));
          document.removeEventListener("paste", tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_boundPaste, "f"));
      }, _AnnotationEditorUIManager_dispatchUpdateStates = function _AnnotationEditorUIManager_dispatchUpdateStates(details) {
          var _this = this;
          var hasChanged = Object.entries(details).some(function (_f) {
              var key = _f[0], value = _f[1];
              return tslib_1.__classPrivateFieldGet(_this, _AnnotationEditorUIManager_previousStates, "f")[key] !== value;
          });
          if (hasChanged) {
              this._eventBus.dispatch("annotationeditorstateschanged", {
                  source: this,
                  details: Object.assign(tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_previousStates, "f"), details)
              });
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_mode, "f") === AnnotationEditorType.HIGHLIGHT && details.hasSelectedEditor === false) {
                  tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateUI).call(this, [[AnnotationEditorParamsType.HIGHLIGHT_FREE, true]]);
              }
          }
      }, _AnnotationEditorUIManager_dispatchUpdateUI = function _AnnotationEditorUIManager_dispatchUpdateUI(details) {
          this._eventBus.dispatch("annotationeditorparamschanged", {
              source: this,
              details: details
          });
      }, _AnnotationEditorUIManager_enableAll = function _AnnotationEditorUIManager_enableAll() {
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_isEnabled, "f")) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_isEnabled, true, "f");
              for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
                  var layer = _f[_i];
                  layer.enable();
              }
              for (var _g = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _g < _h.length; _g++) {
                  var editor = _h[_g];
                  editor.enable();
              }
          }
      }, _AnnotationEditorUIManager_disableAll = function _AnnotationEditorUIManager_disableAll() {
          this.unselectAll();
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_isEnabled, "f")) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditorUIManager_isEnabled, false, "f");
              for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").values(); _i < _f.length; _i++) {
                  var layer = _f[_i];
                  layer.disable();
              }
              for (var _g = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _g < _h.length; _g++) {
                  var editor = _h[_g];
                  editor.disable();
              }
          }
      }, _AnnotationEditorUIManager_addEditorToLayer = function _AnnotationEditorUIManager_addEditorToLayer(editor) {
          var layer = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allLayers, "f").get(editor.pageIndex);
          if (layer) {
              layer.addOrRebuild(editor);
          }
          else {
              this.addEditor(editor);
              this.addToAnnotationStorage(editor);
          }
      }, _AnnotationEditorUIManager_lastSelectedEditor_get = function _AnnotationEditorUIManager_lastSelectedEditor_get() {
          var ed = null;
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              ed = _f[_i];
          }
          return ed;
      }, _AnnotationEditorUIManager_isEmpty = function _AnnotationEditorUIManager_isEmpty() {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").size === 0) {
              return true;
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").size === 1) {
              for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_allEditors, "f").values(); _i < _f.length; _i++) {
                  var editor = _f[_i];
                  return editor.isEmpty();
              }
          }
          return false;
      }, _AnnotationEditorUIManager_selectEditors = function _AnnotationEditorUIManager_selectEditors(editors) {
          for (var _i = 0, _f = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f"); _i < _f.length; _i++) {
              var editor = _f[_i];
              editor.unselect();
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").clear();
          for (var _g = 0, editors_6 = editors; _g < editors_6.length; _g++) {
              var editor = editors_6[_g];
              if (editor.isEmpty()) {
                  continue;
              }
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_selectedEditors, "f").add(editor);
              editor.select();
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorUIManager_instances, "m", _AnnotationEditorUIManager_dispatchUpdateStates).call(this, {
              hasSelectedEditor: this.hasSelection
          });
      };
      AnnotationEditorUIManager.TRANSLATE_SMALL = 1;
      AnnotationEditorUIManager.TRANSLATE_BIG = 10;
      return AnnotationEditorUIManager;
  }());
  ; // CONCATENATED MODULE: ./src/display/editor/alt_text.js
  var AltText = /** @class */ (function () {
      function AltText(editor) {
          _AltText_instances.add(this);
          _AltText_altText.set(this, "");
          _AltText_altTextDecorative.set(this, false);
          _AltText_altTextButton.set(this, null);
          _AltText_altTextTooltip.set(this, null);
          _AltText_altTextTooltipTimeout.set(this, null);
          _AltText_altTextWasFromKeyBoard.set(this, false);
          _AltText_editor.set(this, null);
          tslib_1.__classPrivateFieldSet(this, _AltText_editor, editor, "f");
      }
      AltText.initialize = function (l10nPromise) {
          AltText._l10nPromise || (AltText._l10nPromise = l10nPromise);
      };
      AltText.prototype.render = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var altText, msg, onClick;
              var _this = this;
              return tslib_1.__generator(this, function (_f) {
                  switch (_f.label) {
                      case 0:
                          altText = tslib_1.__classPrivateFieldSet(this, _AltText_altTextButton, document.createElement("button"), "f");
                          altText.className = "altText";
                          return [4 /*yield*/, AltText._l10nPromise.get("pdfjs-editor-alt-text-button-label")];
                      case 1:
                          msg = _f.sent();
                          altText.textContent = msg;
                          altText.setAttribute("aria-label", msg);
                          altText.tabIndex = "0";
                          altText.addEventListener("contextmenu", noContextMenu);
                          altText.addEventListener("pointerdown", function (event) { return event.stopPropagation(); });
                          onClick = function (event) {
                              event.preventDefault();
                              tslib_1.__classPrivateFieldGet(_this, _AltText_editor, "f")._uiManager.editAltText(tslib_1.__classPrivateFieldGet(_this, _AltText_editor, "f"));
                          };
                          altText.addEventListener("click", onClick, {
                              capture: true
                          });
                          altText.addEventListener("keydown", function (event) {
                              if (event.target === altText && event.key === "Enter") {
                                  tslib_1.__classPrivateFieldSet(_this, _AltText_altTextWasFromKeyBoard, true, "f");
                                  onClick(event);
                              }
                          });
                          return [4 /*yield*/, tslib_1.__classPrivateFieldGet(this, _AltText_instances, "m", _AltText_setState).call(this)];
                      case 2:
                          _f.sent();
                          return [2 /*return*/, altText];
                  }
              });
          });
      };
      AltText.prototype.finish = function () {
          if (!tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f").focus({
              focusVisible: tslib_1.__classPrivateFieldGet(this, _AltText_altTextWasFromKeyBoard, "f")
          });
          tslib_1.__classPrivateFieldSet(this, _AltText_altTextWasFromKeyBoard, false, "f");
      };
      AltText.prototype.isEmpty = function () {
          return !tslib_1.__classPrivateFieldGet(this, _AltText_altText, "f") && !tslib_1.__classPrivateFieldGet(this, _AltText_altTextDecorative, "f");
      };
      Object.defineProperty(AltText.prototype, "data", {
          get: function () {
              return {
                  altText: tslib_1.__classPrivateFieldGet(this, _AltText_altText, "f"),
                  decorative: tslib_1.__classPrivateFieldGet(this, _AltText_altTextDecorative, "f")
              };
          },
          set: function (_f) {
              var altText = _f.altText, decorative = _f.decorative;
              if (tslib_1.__classPrivateFieldGet(this, _AltText_altText, "f") === altText && tslib_1.__classPrivateFieldGet(this, _AltText_altTextDecorative, "f") === decorative) {
                  return;
              }
              tslib_1.__classPrivateFieldSet(this, _AltText_altText, altText, "f");
              tslib_1.__classPrivateFieldSet(this, _AltText_altTextDecorative, decorative, "f");
              tslib_1.__classPrivateFieldGet(this, _AltText_instances, "m", _AltText_setState).call(this);
          },
          enumerable: false,
          configurable: true
      });
      AltText.prototype.toggle = function (enabled) {
          if (enabled === void 0) { enabled = false; }
          if (!tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f")) {
              return;
          }
          if (!enabled && tslib_1.__classPrivateFieldGet(this, _AltText_altTextTooltipTimeout, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AltText_altTextTooltipTimeout, "f"));
              tslib_1.__classPrivateFieldSet(this, _AltText_altTextTooltipTimeout, null, "f");
          }
          tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f").disabled = !enabled;
      };
      AltText.prototype.destroy = function () {
          var _f;
          (_f = tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f")) === null || _f === void 0 ? void 0 : _f.remove();
          tslib_1.__classPrivateFieldSet(this, _AltText_altTextButton, null, "f");
          tslib_1.__classPrivateFieldSet(this, _AltText_altTextTooltip, null, "f");
      };
      var _AltText_instances, _AltText_altText, _AltText_altTextDecorative, _AltText_altTextButton, _AltText_altTextTooltip, _AltText_altTextTooltipTimeout, _AltText_altTextWasFromKeyBoard, _AltText_editor, _AltText_setState;
      _AltText_altText = new WeakMap(), _AltText_altTextDecorative = new WeakMap(), _AltText_altTextButton = new WeakMap(), _AltText_altTextTooltip = new WeakMap(), _AltText_altTextTooltipTimeout = new WeakMap(), _AltText_altTextWasFromKeyBoard = new WeakMap(), _AltText_editor = new WeakMap(), _AltText_instances = new WeakSet(), _AltText_setState = function _AltText_setState() {
          var _f;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var button, tooltip, id, DELAY_TO_SHOW_TOOLTIP_1, _g, _h, element;
              var _this = this;
              return tslib_1.__generator(this, function (_j) {
                  switch (_j.label) {
                      case 0:
                          button = tslib_1.__classPrivateFieldGet(this, _AltText_altTextButton, "f");
                          if (!button) {
                              return [2 /*return*/];
                          }
                          if (!tslib_1.__classPrivateFieldGet(this, _AltText_altText, "f") && !tslib_1.__classPrivateFieldGet(this, _AltText_altTextDecorative, "f")) {
                              button.classList.remove("done");
                              (_f = tslib_1.__classPrivateFieldGet(this, _AltText_altTextTooltip, "f")) === null || _f === void 0 ? void 0 : _f.remove();
                              return [2 /*return*/];
                          }
                          button.classList.add("done");
                          AltText._l10nPromise.get("pdfjs-editor-alt-text-edit-button-label").then(function (msg) {
                              button.setAttribute("aria-label", msg);
                          });
                          tooltip = tslib_1.__classPrivateFieldGet(this, _AltText_altTextTooltip, "f");
                          if (!tooltip) {
                              tslib_1.__classPrivateFieldSet(this, _AltText_altTextTooltip, tooltip = document.createElement("span"), "f");
                              tooltip.className = "tooltip";
                              tooltip.setAttribute("role", "tooltip");
                              id = tooltip.id = "alt-text-tooltip-".concat(tslib_1.__classPrivateFieldGet(this, _AltText_editor, "f").id);
                              button.setAttribute("aria-describedby", id);
                              DELAY_TO_SHOW_TOOLTIP_1 = 100;
                              button.addEventListener("mouseenter", function () {
                                  tslib_1.__classPrivateFieldSet(_this, _AltText_altTextTooltipTimeout, setTimeout(function () {
                                      tslib_1.__classPrivateFieldSet(_this, _AltText_altTextTooltipTimeout, null, "f");
                                      tslib_1.__classPrivateFieldGet(_this, _AltText_altTextTooltip, "f").classList.add("show");
                                      tslib_1.__classPrivateFieldGet(_this, _AltText_editor, "f")._reportTelemetry({
                                          action: "alt_text_tooltip"
                                      });
                                  }, DELAY_TO_SHOW_TOOLTIP_1), "f");
                              });
                              button.addEventListener("mouseleave", function () {
                                  var _f;
                                  if (tslib_1.__classPrivateFieldGet(_this, _AltText_altTextTooltipTimeout, "f")) {
                                      clearTimeout(tslib_1.__classPrivateFieldGet(_this, _AltText_altTextTooltipTimeout, "f"));
                                      tslib_1.__classPrivateFieldSet(_this, _AltText_altTextTooltipTimeout, null, "f");
                                  }
                                  (_f = tslib_1.__classPrivateFieldGet(_this, _AltText_altTextTooltip, "f")) === null || _f === void 0 ? void 0 : _f.classList.remove("show");
                              });
                          }
                          _g = tooltip;
                          if (!tslib_1.__classPrivateFieldGet(this, _AltText_altTextDecorative, "f")) return [3 /*break*/, 2];
                          return [4 /*yield*/, AltText._l10nPromise.get("pdfjs-editor-alt-text-decorative-tooltip")];
                      case 1:
                          _h = _j.sent();
                          return [3 /*break*/, 3];
                      case 2:
                          _h = tslib_1.__classPrivateFieldGet(this, _AltText_altText, "f");
                          _j.label = 3;
                      case 3:
                          _g.innerText = _h;
                          if (!tooltip.parentNode) {
                              button.append(tooltip);
                          }
                          element = tslib_1.__classPrivateFieldGet(this, _AltText_editor, "f").getImageForAltText();
                          element === null || element === void 0 ? void 0 : element.setAttribute("aria-describedby", tooltip.id);
                          return [2 /*return*/];
                  }
              });
          });
      };
      AltText._l10nPromise = null;
      return AltText;
  }());
  ; // CONCATENATED MODULE: ./src/display/editor/editor.js
  var AnnotationEditor = /** @class */ (function () {
      function AnnotationEditor(parameters) {
          _AnnotationEditor_instances.add(this);
          _AnnotationEditor_allResizerDivs.set(this, null);
          _AnnotationEditor_altText.set(this, null);
          _AnnotationEditor_disabled.set(this, false);
          _AnnotationEditor_keepAspectRatio.set(this, false);
          _AnnotationEditor_resizersDiv.set(this, null);
          _AnnotationEditor_savedDimensions.set(this, null);
          _AnnotationEditor_boundFocusin.set(this, this.focusin.bind(this));
          _AnnotationEditor_boundFocusout.set(this, this.focusout.bind(this));
          _AnnotationEditor_editToolbar.set(this, null);
          _AnnotationEditor_focusedResizerName.set(this, "");
          _AnnotationEditor_hasBeenClicked.set(this, false);
          _AnnotationEditor_initialPosition.set(this, null);
          _AnnotationEditor_isEditing.set(this, false);
          _AnnotationEditor_isInEditMode.set(this, false);
          _AnnotationEditor_isResizerEnabledForKeyboard.set(this, false);
          _AnnotationEditor_moveInDOMTimeout.set(this, null);
          _AnnotationEditor_prevDragX.set(this, 0);
          _AnnotationEditor_prevDragY.set(this, 0);
          _AnnotationEditor_telemetryTimeouts.set(this, null);
          this._initialOptions = Object.create(null);
          this._isVisible = true;
          this._uiManager = null;
          this._focusEventsAllowed = true;
          this._l10nPromise = null;
          _AnnotationEditor_isDraggable.set(this, false);
          _AnnotationEditor_zIndex.set(this, AnnotationEditor._zIndex++);
          if (this.constructor === AnnotationEditor) {
              unreachable("Cannot initialize AnnotationEditor.");
          }
          this.parent = parameters.parent;
          this.id = parameters.id;
          this.width = this.height = null;
          this.pageIndex = parameters.parent.pageIndex;
          this.name = parameters.name;
          this.div = null;
          this._uiManager = parameters.uiManager;
          this.annotationElementId = null;
          this._willKeepAspectRatio = false;
          this._initialOptions.isCentered = parameters.isCentered;
          this._structTreeParentId = null;
          var _g = this.parent.viewport, rotation = _g.rotation, _h = _g.rawDims, pageWidth = _h.pageWidth, pageHeight = _h.pageHeight, pageX = _h.pageX, pageY = _h.pageY;
          this.rotation = rotation;
          this.pageRotation = (360 + rotation - this._uiManager.viewParameters.rotation) % 360;
          this.pageDimensions = [pageWidth, pageHeight];
          this.pageTranslation = [pageX, pageY];
          var _j = this.parentDimensions, width = _j[0], height = _j[1];
          this.x = parameters.x / width;
          this.y = parameters.y / height;
          this.isAttachedToDOM = false;
          this.deleted = false;
      }
      Object.defineProperty(AnnotationEditor, "_resizerKeyboardManager", {
          get: function () {
              var resize = AnnotationEditor.prototype._resizeWithKeyboard;
              var small = AnnotationEditorUIManager.TRANSLATE_SMALL;
              var big = AnnotationEditorUIManager.TRANSLATE_BIG;
              return shadow(this, "_resizerKeyboardManager", new KeyboardManager([[["ArrowLeft", "mac+ArrowLeft"], resize, {
                          args: [-small, 0]
                      }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], resize, {
                          args: [-big, 0]
                      }], [["ArrowRight", "mac+ArrowRight"], resize, {
                          args: [small, 0]
                      }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], resize, {
                          args: [big, 0]
                      }], [["ArrowUp", "mac+ArrowUp"], resize, {
                          args: [0, -small]
                      }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], resize, {
                          args: [0, -big]
                      }], [["ArrowDown", "mac+ArrowDown"], resize, {
                          args: [0, small]
                      }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], resize, {
                          args: [0, big]
                      }], [["Escape", "mac+Escape"], AnnotationEditor.prototype._stopResizingWithKeyboard]]));
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "editorType", {
          get: function () {
              return Object.getPrototypeOf(this).constructor._type;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor, "_defaultLineColor", {
          get: function () {
              return shadow(this, "_defaultLineColor", this._colorManager.getHexCode("CanvasText"));
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.deleteAnnotationElement = function (editor) {
          var fakeEditor = new FakeEditor({
              id: editor.parent.getNextId(),
              parent: editor.parent,
              uiManager: editor._uiManager
          });
          fakeEditor.annotationElementId = editor.annotationElementId;
          fakeEditor.deleted = true;
          fakeEditor._uiManager.addToAnnotationStorage(fakeEditor);
      };
      AnnotationEditor.initialize = function (l10n, _uiManager, options) {
          AnnotationEditor._l10nPromise || (AnnotationEditor._l10nPromise = new Map(["pdfjs-editor-alt-text-button-label", "pdfjs-editor-alt-text-edit-button-label", "pdfjs-editor-alt-text-decorative-tooltip", "pdfjs-editor-resizer-label-topLeft", "pdfjs-editor-resizer-label-topMiddle", "pdfjs-editor-resizer-label-topRight", "pdfjs-editor-resizer-label-middleRight", "pdfjs-editor-resizer-label-bottomRight", "pdfjs-editor-resizer-label-bottomMiddle", "pdfjs-editor-resizer-label-bottomLeft", "pdfjs-editor-resizer-label-middleLeft"].map(function (str) { return [str, l10n.get(str.replaceAll(/([A-Z])/g, function (c) { return "-".concat(c.toLowerCase()); }))]; })));
          if (options === null || options === void 0 ? void 0 : options.strings) {
              for (var _i = 0, _g = options.strings; _i < _g.length; _i++) {
                  var str = _g[_i];
                  AnnotationEditor._l10nPromise.set(str, l10n.get(str));
              }
          }
          if (AnnotationEditor._borderLineWidth !== -1) {
              return;
          }
          var style = getComputedStyle(document.documentElement);
          AnnotationEditor._borderLineWidth = parseFloat(style.getPropertyValue("--outline-width")) || 0;
      };
      AnnotationEditor.updateDefaultParams = function (_type, _value) { };
      Object.defineProperty(AnnotationEditor, "defaultPropertiesToUpdate", {
          get: function () {
              return [];
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.isHandlingMimeForPasting = function (mime) {
          return false;
      };
      AnnotationEditor.paste = function (item, parent) {
          unreachable("Not implemented");
      };
      Object.defineProperty(AnnotationEditor.prototype, "propertiesToUpdate", {
          get: function () {
              return [];
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "_isDraggable", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isDraggable, "f");
          },
          set: function (value) {
              var _g;
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isDraggable, value, "f");
              (_g = this.div) === null || _g === void 0 ? void 0 : _g.classList.toggle("draggable", value);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "isEnterHandled", {
          get: function () {
              return true;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.center = function () {
          var _g = this.pageDimensions, pageWidth = _g[0], pageHeight = _g[1];
          switch (this.parentRotation) {
              case 90:
                  this.x -= this.height * pageHeight / (pageWidth * 2);
                  this.y += this.width * pageWidth / (pageHeight * 2);
                  break;
              case 180:
                  this.x += this.width / 2;
                  this.y += this.height / 2;
                  break;
              case 270:
                  this.x += this.height * pageHeight / (pageWidth * 2);
                  this.y -= this.width * pageWidth / (pageHeight * 2);
                  break;
              default:
                  this.x -= this.width / 2;
                  this.y -= this.height / 2;
                  break;
          }
          this.fixAndSetPosition();
      };
      AnnotationEditor.prototype.addCommands = function (params) {
          this._uiManager.addCommands(params);
      };
      Object.defineProperty(AnnotationEditor.prototype, "currentLayer", {
          get: function () {
              return this._uiManager.currentLayer;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.setInBackground = function () {
          this.div.style.zIndex = 0;
      };
      AnnotationEditor.prototype.setInForeground = function () {
          this.div.style.zIndex = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_zIndex, "f");
      };
      AnnotationEditor.prototype.setParent = function (parent) {
          if (parent !== null) {
              this.pageIndex = parent.pageIndex;
              this.pageDimensions = parent.pageDimensions;
          }
          else {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_stopResizing).call(this);
          }
          this.parent = parent;
      };
      AnnotationEditor.prototype.focusin = function (event) {
          if (!this._focusEventsAllowed) {
              return;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_hasBeenClicked, "f")) {
              this.parent.setSelected(this);
          }
          else {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_hasBeenClicked, false, "f");
          }
      };
      AnnotationEditor.prototype.focusout = function (event) {
          var _g;
          if (!this._focusEventsAllowed) {
              return;
          }
          if (!this.isAttachedToDOM) {
              return;
          }
          var target = event.relatedTarget;
          if (target === null || target === void 0 ? void 0 : target.closest("#".concat(this.id))) {
              return;
          }
          event.preventDefault();
          if (!((_g = this.parent) === null || _g === void 0 ? void 0 : _g.isMultipleSelection)) {
              this.commitOrRemove();
          }
      };
      AnnotationEditor.prototype.commitOrRemove = function () {
          if (this.isEmpty()) {
              this.remove();
          }
          else {
              this.commit();
          }
      };
      AnnotationEditor.prototype.commit = function () {
          this.addToAnnotationStorage();
      };
      AnnotationEditor.prototype.addToAnnotationStorage = function () {
          this._uiManager.addToAnnotationStorage(this);
      };
      AnnotationEditor.prototype.setAt = function (x, y, tx, ty) {
          var _g;
          var _h = this.parentDimensions, width = _h[0], height = _h[1];
          _g = this.screenToPageTranslation(tx, ty), tx = _g[0], ty = _g[1];
          this.x = (x + tx) / width;
          this.y = (y + ty) / height;
          this.fixAndSetPosition();
      };
      AnnotationEditor.prototype.translate = function (x, y) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_translate).call(this, this.parentDimensions, x, y);
      };
      AnnotationEditor.prototype.translateInPage = function (x, y) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_initialPosition, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_initialPosition, "f") || [this.x, this.y], "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_translate).call(this, this.pageDimensions, x, y);
          this.div.scrollIntoView({
              block: "nearest"
          });
      };
      AnnotationEditor.prototype.drag = function (tx, ty) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_initialPosition, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_initialPosition, "f") || [this.x, this.y], "f");
          var _g = this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
          this.x += tx / parentWidth;
          this.y += ty / parentHeight;
          if (this.parent && (this.x < 0 || this.x > 1 || this.y < 0 || this.y > 1)) {
              var _h = this.div.getBoundingClientRect(), x_1 = _h.x, y_1 = _h.y;
              if (this.parent.findNewParent(this, x_1, y_1)) {
                  this.x -= Math.floor(this.x);
                  this.y -= Math.floor(this.y);
              }
          }
          var _j = this, x = _j.x, y = _j.y;
          var _k = this.getBaseTranslation(), bx = _k[0], by = _k[1];
          x += bx;
          y += by;
          this.div.style.left = "".concat((100 * x).toFixed(2), "%");
          this.div.style.top = "".concat((100 * y).toFixed(2), "%");
          this.div.scrollIntoView({
              block: "nearest"
          });
      };
      Object.defineProperty(AnnotationEditor.prototype, "_hasBeenMoved", {
          get: function () {
              return !!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_initialPosition, "f") && (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_initialPosition, "f")[0] !== this.x || tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_initialPosition, "f")[1] !== this.y);
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.getBaseTranslation = function () {
          var _g = this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
          var _borderLineWidth = AnnotationEditor._borderLineWidth;
          var x = _borderLineWidth / parentWidth;
          var y = _borderLineWidth / parentHeight;
          switch (this.rotation) {
              case 90:
                  return [-x, y];
              case 180:
                  return [x, y];
              case 270:
                  return [x, -y];
              default:
                  return [-x, -y];
          }
      };
      Object.defineProperty(AnnotationEditor.prototype, "_mustFixPosition", {
          get: function () {
              return true;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.fixAndSetPosition = function (rotation) {
          if (rotation === void 0) { rotation = this.rotation; }
          var _g = this.pageDimensions, pageWidth = _g[0], pageHeight = _g[1];
          var _h = this, x = _h.x, y = _h.y, width = _h.width, height = _h.height;
          width *= pageWidth;
          height *= pageHeight;
          x *= pageWidth;
          y *= pageHeight;
          if (this._mustFixPosition) {
              switch (rotation) {
                  case 0:
                      x = Math.max(0, Math.min(pageWidth - width, x));
                      y = Math.max(0, Math.min(pageHeight - height, y));
                      break;
                  case 90:
                      x = Math.max(0, Math.min(pageWidth - height, x));
                      y = Math.min(pageHeight, Math.max(width, y));
                      break;
                  case 180:
                      x = Math.min(pageWidth, Math.max(width, x));
                      y = Math.min(pageHeight, Math.max(height, y));
                      break;
                  case 270:
                      x = Math.min(pageWidth, Math.max(height, x));
                      y = Math.max(0, Math.min(pageHeight - width, y));
                      break;
              }
          }
          this.x = x /= pageWidth;
          this.y = y /= pageHeight;
          var _j = this.getBaseTranslation(), bx = _j[0], by = _j[1];
          x += bx;
          y += by;
          var style = this.div.style;
          style.left = "".concat((100 * x).toFixed(2), "%");
          style.top = "".concat((100 * y).toFixed(2), "%");
          this.moveInDOM();
      };
      AnnotationEditor.prototype.screenToPageTranslation = function (x, y) {
          return tslib_1.__classPrivateFieldGet(AnnotationEditor, _f, "m", _AnnotationEditor_rotatePoint).call(AnnotationEditor, x, y, this.parentRotation);
      };
      AnnotationEditor.prototype.pageTranslationToScreen = function (x, y) {
          return tslib_1.__classPrivateFieldGet(AnnotationEditor, _f, "m", _AnnotationEditor_rotatePoint).call(AnnotationEditor, x, y, 360 - this.parentRotation);
      };
      Object.defineProperty(AnnotationEditor.prototype, "parentScale", {
          get: function () {
              return this._uiManager.viewParameters.realScale;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "parentRotation", {
          get: function () {
              return (this._uiManager.viewParameters.rotation + this.pageRotation) % 360;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "parentDimensions", {
          get: function () {
              var _g = this, parentScale = _g.parentScale, _h = _g.pageDimensions, pageWidth = _h[0], pageHeight = _h[1];
              var scaledWidth = pageWidth * parentScale;
              var scaledHeight = pageHeight * parentScale;
              return util_FeatureTest.isCSSRoundSupported ? [Math.round(scaledWidth), Math.round(scaledHeight)] : [scaledWidth, scaledHeight];
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.setDims = function (width, height) {
          var _g = this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
          this.div.style.width = "".concat((100 * width / parentWidth).toFixed(2), "%");
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_keepAspectRatio, "f")) {
              this.div.style.height = "".concat((100 * height / parentHeight).toFixed(2), "%");
          }
      };
      AnnotationEditor.prototype.fixDims = function () {
          var style = this.div.style;
          var height = style.height, width = style.width;
          var widthPercent = width.endsWith("%");
          var heightPercent = !tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_keepAspectRatio, "f") && height.endsWith("%");
          if (widthPercent && heightPercent) {
              return;
          }
          var _g = this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
          if (!widthPercent) {
              style.width = "".concat((100 * parseFloat(width) / parentWidth).toFixed(2), "%");
          }
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_keepAspectRatio, "f") && !heightPercent) {
              style.height = "".concat((100 * parseFloat(height) / parentHeight).toFixed(2), "%");
          }
      };
      AnnotationEditor.prototype.getInitialTranslation = function () {
          return [0, 0];
      };
      AnnotationEditor.prototype.altTextFinish = function () {
          var _g;
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.finish();
      };
      AnnotationEditor.prototype.addEditToolbar = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var _g, _h;
              return tslib_1.__generator(this, function (_j) {
                  switch (_j.label) {
                      case 0:
                          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f") || tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isInEditMode, "f")) {
                              return [2 /*return*/, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")];
                          }
                          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_editToolbar, new EditorToolbar(this), "f");
                          this.div.append(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f").render());
                          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) return [3 /*break*/, 2];
                          _h = (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")).addAltTextButton;
                          return [4 /*yield*/, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f").render()];
                      case 1:
                          _h.apply(_g, [_j.sent()]);
                          _j.label = 2;
                      case 2: return [2 /*return*/, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")];
                  }
              });
          });
      };
      AnnotationEditor.prototype.removeEditToolbar = function () {
          var _g;
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f").remove();
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_editToolbar, null, "f");
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.destroy();
      };
      AnnotationEditor.prototype.getClientDimensions = function () {
          return this.div.getBoundingClientRect();
      };
      AnnotationEditor.prototype.addAltTextButton = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              return tslib_1.__generator(this, function (_g) {
                  switch (_g.label) {
                      case 0:
                          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) {
                              return [2 /*return*/];
                          }
                          AltText.initialize(AnnotationEditor._l10nPromise);
                          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_altText, new AltText(this), "f");
                          return [4 /*yield*/, this.addEditToolbar()];
                      case 1:
                          _g.sent();
                          return [2 /*return*/];
                  }
              });
          });
      };
      Object.defineProperty(AnnotationEditor.prototype, "altTextData", {
          get: function () {
              var _g;
              return (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.data;
          },
          set: function (data) {
              if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) {
                  return;
              }
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f").data = data;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.hasAltText = function () {
          var _g;
          return !((_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.isEmpty());
      };
      AnnotationEditor.prototype.render = function () {
          this.div = document.createElement("div");
          this.div.setAttribute("data-editor-rotation", (360 - this.rotation) % 360);
          this.div.className = this.name;
          this.div.setAttribute("id", this.id);
          this.div.tabIndex = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_disabled, "f") ? -1 : 0;
          if (!this._isVisible) {
              this.div.classList.add("hidden");
          }
          this.setInForeground();
          this.div.addEventListener("focusin", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusin, "f"));
          this.div.addEventListener("focusout", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusout, "f"));
          var _g = this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
          if (this.parentRotation % 180 !== 0) {
              this.div.style.maxWidth = "".concat((100 * parentHeight / parentWidth).toFixed(2), "%");
              this.div.style.maxHeight = "".concat((100 * parentWidth / parentHeight).toFixed(2), "%");
          }
          var _h = this.getInitialTranslation(), tx = _h[0], ty = _h[1];
          this.translate(tx, ty);
          bindEvents(this, this.div, ["pointerdown"]);
          return this.div;
      };
      AnnotationEditor.prototype.pointerdown = function (event) {
          var isMac = util_FeatureTest.platform.isMac;
          if (event.button !== 0 || event.ctrlKey && isMac) {
              event.preventDefault();
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_hasBeenClicked, true, "f");
          if (this._isDraggable) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_setUpDragSession).call(this, event);
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_selectOnPointerEvent).call(this, event);
      };
      AnnotationEditor.prototype.moveInDOM = function () {
          var _this = this;
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_moveInDOMTimeout, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_moveInDOMTimeout, "f"));
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_moveInDOMTimeout, setTimeout(function () {
              var _g;
              tslib_1.__classPrivateFieldSet(_this, _AnnotationEditor_moveInDOMTimeout, null, "f");
              (_g = _this.parent) === null || _g === void 0 ? void 0 : _g.moveEditorInDOM(_this);
          }, 0), "f");
      };
      AnnotationEditor.prototype._setParentAndPosition = function (parent, x, y) {
          parent.changeParent(this);
          this.x = x;
          this.y = y;
          this.fixAndSetPosition();
      };
      AnnotationEditor.prototype.getRect = function (tx, ty, rotation) {
          if (rotation === void 0) { rotation = this.rotation; }
          var scale = this.parentScale;
          var _g = this.pageDimensions, pageWidth = _g[0], pageHeight = _g[1];
          var _h = this.pageTranslation, pageX = _h[0], pageY = _h[1];
          var shiftX = tx / scale;
          var shiftY = ty / scale;
          var x = this.x * pageWidth;
          var y = this.y * pageHeight;
          var width = this.width * pageWidth;
          var height = this.height * pageHeight;
          switch (rotation) {
              case 0:
                  return [x + shiftX + pageX, pageHeight - y - shiftY - height + pageY, x + shiftX + width + pageX, pageHeight - y - shiftY + pageY];
              case 90:
                  return [x + shiftY + pageX, pageHeight - y + shiftX + pageY, x + shiftY + height + pageX, pageHeight - y + shiftX + width + pageY];
              case 180:
                  return [x - shiftX - width + pageX, pageHeight - y + shiftY + pageY, x - shiftX + pageX, pageHeight - y + shiftY + height + pageY];
              case 270:
                  return [x - shiftY - height + pageX, pageHeight - y - shiftX - width + pageY, x - shiftY + pageX, pageHeight - y - shiftX + pageY];
              default:
                  throw new Error("Invalid rotation");
          }
      };
      AnnotationEditor.prototype.getRectInCurrentCoords = function (rect, pageHeight) {
          var x1 = rect[0], y1 = rect[1], x2 = rect[2], y2 = rect[3];
          var width = x2 - x1;
          var height = y2 - y1;
          switch (this.rotation) {
              case 0:
                  return [x1, pageHeight - y2, width, height];
              case 90:
                  return [x1, pageHeight - y1, height, width];
              case 180:
                  return [x2, pageHeight - y1, width, height];
              case 270:
                  return [x2, pageHeight - y2, height, width];
              default:
                  throw new Error("Invalid rotation");
          }
      };
      AnnotationEditor.prototype.onceAdded = function () { };
      AnnotationEditor.prototype.isEmpty = function () {
          return false;
      };
      AnnotationEditor.prototype.enableEditMode = function () {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isInEditMode, true, "f");
      };
      AnnotationEditor.prototype.disableEditMode = function () {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isInEditMode, false, "f");
      };
      AnnotationEditor.prototype.isInEditMode = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isInEditMode, "f");
      };
      AnnotationEditor.prototype.shouldGetKeyboardEvents = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isResizerEnabledForKeyboard, "f");
      };
      AnnotationEditor.prototype.needsToBeRebuilt = function () {
          return this.div && !this.isAttachedToDOM;
      };
      AnnotationEditor.prototype.rebuild = function () {
          var _g, _h;
          (_g = this.div) === null || _g === void 0 ? void 0 : _g.addEventListener("focusin", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusin, "f"));
          (_h = this.div) === null || _h === void 0 ? void 0 : _h.addEventListener("focusout", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusout, "f"));
      };
      AnnotationEditor.prototype.rotate = function (_angle) { };
      AnnotationEditor.prototype.serialize = function (isForCopying, context) {
          if (isForCopying === void 0) { isForCopying = false; }
          if (context === void 0) { context = null; }
          unreachable("An editor must be serializable");
      };
      AnnotationEditor.deserialize = function (data, parent, uiManager) {
          var editor = new this.prototype.constructor({
              parent: parent,
              id: parent.getNextId(),
              uiManager: uiManager
          });
          editor.rotation = data.rotation;
          var _g = editor.pageDimensions, pageWidth = _g[0], pageHeight = _g[1];
          var _h = editor.getRectInCurrentCoords(data.rect, pageHeight), x = _h[0], y = _h[1], width = _h[2], height = _h[3];
          editor.x = x / pageWidth;
          editor.y = y / pageHeight;
          editor.width = width / pageWidth;
          editor.height = height / pageHeight;
          return editor;
      };
      Object.defineProperty(AnnotationEditor.prototype, "hasBeenModified", {
          get: function () {
              return !!this.annotationElementId && (this.deleted || this.serialize() !== null);
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.remove = function () {
          this.div.removeEventListener("focusin", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusin, "f"));
          this.div.removeEventListener("focusout", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_boundFocusout, "f"));
          if (!this.isEmpty()) {
              this.commit();
          }
          if (this.parent) {
              this.parent.remove(this);
          }
          else {
              this._uiManager.removeEditor(this);
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_moveInDOMTimeout, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_moveInDOMTimeout, "f"));
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_moveInDOMTimeout, null, "f");
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_stopResizing).call(this);
          this.removeEditToolbar();
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_telemetryTimeouts, "f")) {
              for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_telemetryTimeouts, "f").values(); _i < _g.length; _i++) {
                  var timeout = _g[_i];
                  clearTimeout(timeout);
              }
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_telemetryTimeouts, null, "f");
          }
          this.parent = null;
      };
      Object.defineProperty(AnnotationEditor.prototype, "isResizable", {
          get: function () {
              return false;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.makeResizable = function () {
          if (this.isResizable) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_createResizers).call(this);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").classList.remove("hidden");
              bindEvents(this, this.div, ["keydown"]);
          }
      };
      Object.defineProperty(AnnotationEditor.prototype, "toolbarPosition", {
          get: function () {
              return null;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.keydown = function (event) {
          if (!this.isResizable || event.target !== this.div || event.key !== "Enter") {
              return;
          }
          this._uiManager.setSelected(this);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_savedDimensions, {
              savedX: this.x,
              savedY: this.y,
              savedWidth: this.width,
              savedHeight: this.height
          }, "f");
          var children = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").children;
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f")) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_allResizerDivs, Array.from(children), "f");
              var boundResizerKeydown = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerKeydown).bind(this);
              var boundResizerBlur = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerBlur).bind(this);
              var _loop_1 = function (div) {
                  var name = div.getAttribute("data-resizer-name");
                  div.setAttribute("role", "spinbutton");
                  div.addEventListener("keydown", boundResizerKeydown);
                  div.addEventListener("blur", boundResizerBlur);
                  div.addEventListener("focus", tslib_1.__classPrivateFieldGet(this_1, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerFocus).bind(this_1, name));
                  AnnotationEditor._l10nPromise.get("pdfjs-editor-resizer-label-".concat(name)).then(function (msg) { return div.setAttribute("aria-label", msg); });
              };
              var this_1 = this;
              for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f"); _i < _g.length; _i++) {
                  var div = _g[_i];
                  _loop_1(div);
              }
          }
          var first = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f")[0];
          var firstPosition = 0;
          for (var _h = 0, children_1 = children; _h < children_1.length; _h++) {
              var div = children_1[_h];
              if (div === first) {
                  break;
              }
              firstPosition++;
          }
          var nextFirstPosition = (360 - this.rotation + this.parentRotation) % 360 / 90 * (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f").length / 4);
          if (nextFirstPosition !== firstPosition) {
              if (nextFirstPosition < firstPosition) {
                  for (var i_1 = 0; i_1 < firstPosition - nextFirstPosition; i_1++) {
                      tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").append(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").firstChild);
                  }
              }
              else if (nextFirstPosition > firstPosition) {
                  for (var i_2 = 0; i_2 < nextFirstPosition - firstPosition; i_2++) {
                      tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").firstChild.before(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").lastChild);
                  }
              }
              var i = 0;
              var _loop_2 = function (child) {
                  var div = tslib_1.__classPrivateFieldGet(this_2, _AnnotationEditor_allResizerDivs, "f")[i++];
                  var name = div.getAttribute("data-resizer-name");
                  AnnotationEditor._l10nPromise.get("pdfjs-editor-resizer-label-".concat(name)).then(function (msg) { return child.setAttribute("aria-label", msg); });
              };
              var this_2 = this;
              for (var _j = 0, children_2 = children; _j < children_2.length; _j++) {
                  var child = children_2[_j];
                  _loop_2(child);
              }
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_setResizerTabIndex).call(this, 0);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isResizerEnabledForKeyboard, true, "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").firstChild.focus({
              focusVisible: true
          });
          event.preventDefault();
          event.stopImmediatePropagation();
      };
      AnnotationEditor.prototype._resizeWithKeyboard = function (x, y) {
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isResizerEnabledForKeyboard, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerPointermove).call(this, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_focusedResizerName, "f"), {
              movementX: x,
              movementY: y
          });
      };
      AnnotationEditor.prototype._stopResizingWithKeyboard = function () {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_stopResizing).call(this);
          this.div.focus();
      };
      AnnotationEditor.prototype.select = function () {
          var _this = this;
          var _g, _h;
          this.makeResizable();
          (_g = this.div) === null || _g === void 0 ? void 0 : _g.classList.add("selectedEditor");
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")) {
              this.addEditToolbar().then(function () {
                  var _g, _h;
                  if ((_g = _this.div) === null || _g === void 0 ? void 0 : _g.classList.contains("selectedEditor")) {
                      (_h = tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_editToolbar, "f")) === null || _h === void 0 ? void 0 : _h.show();
                  }
              });
              return;
          }
          (_h = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")) === null || _h === void 0 ? void 0 : _h.show();
      };
      AnnotationEditor.prototype.unselect = function () {
          var _g, _h, _j, _k;
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f")) === null || _g === void 0 ? void 0 : _g.classList.add("hidden");
          (_h = this.div) === null || _h === void 0 ? void 0 : _h.classList.remove("selectedEditor");
          if ((_j = this.div) === null || _j === void 0 ? void 0 : _j.contains(document.activeElement)) {
              this._uiManager.currentLayer.div.focus({
                  preventScroll: true
              });
          }
          (_k = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_editToolbar, "f")) === null || _k === void 0 ? void 0 : _k.hide();
      };
      AnnotationEditor.prototype.updateParams = function (type, value) { };
      AnnotationEditor.prototype.disableEditing = function () { };
      AnnotationEditor.prototype.enableEditing = function () { };
      AnnotationEditor.prototype.enterInEditMode = function () { };
      AnnotationEditor.prototype.getImageForAltText = function () {
          return null;
      };
      Object.defineProperty(AnnotationEditor.prototype, "contentDiv", {
          get: function () {
              return this.div;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "isEditing", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isEditing, "f");
          },
          set: function (value) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isEditing, value, "f");
              if (!this.parent) {
                  return;
              }
              if (value) {
                  this.parent.setSelected(this);
                  this.parent.setActiveEditor(this);
              }
              else {
                  this.parent.setActiveEditor(null);
              }
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype.setAspectRatio = function (width, height) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_keepAspectRatio, true, "f");
          var aspectRatio = width / height;
          var style = this.div.style;
          style.aspectRatio = aspectRatio;
          style.height = "auto";
      };
      Object.defineProperty(AnnotationEditor, "MIN_SIZE", {
          get: function () {
              return 16;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.canCreateNewEmptyEditor = function () {
          return true;
      };
      Object.defineProperty(AnnotationEditor.prototype, "telemetryInitialData", {
          get: function () {
              return {
                  action: "added"
              };
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditor.prototype, "telemetryFinalData", {
          get: function () {
              return null;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditor.prototype._reportTelemetry = function (data, mustWait) {
          var _this = this;
          if (mustWait === void 0) { mustWait = false; }
          if (mustWait) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_telemetryTimeouts, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_telemetryTimeouts, "f") || new Map(), "f");
              var action_1 = data.action;
              var timeout = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_telemetryTimeouts, "f").get(action_1);
              if (timeout) {
                  clearTimeout(timeout);
              }
              timeout = setTimeout(function () {
                  _this._reportTelemetry(data);
                  tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_telemetryTimeouts, "f").delete(action_1);
                  if (tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_telemetryTimeouts, "f").size === 0) {
                      tslib_1.__classPrivateFieldSet(_this, _AnnotationEditor_telemetryTimeouts, null, "f");
                  }
              }, AnnotationEditor._telemetryTimeout);
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_telemetryTimeouts, "f").set(action_1, timeout);
              return;
          }
          data.type || (data.type = this.editorType);
          this._uiManager._eventBus.dispatch("reporttelemetry", {
              source: this,
              details: {
                  type: "editing",
                  data: data
              }
          });
      };
      AnnotationEditor.prototype.show = function (visible) {
          if (visible === void 0) { visible = this._isVisible; }
          this.div.classList.toggle("hidden", !visible);
          this._isVisible = visible;
      };
      AnnotationEditor.prototype.enable = function () {
          if (this.div) {
              this.div.tabIndex = 0;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_disabled, false, "f");
      };
      AnnotationEditor.prototype.disable = function () {
          if (this.div) {
              this.div.tabIndex = -1;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_disabled, true, "f");
      };
      AnnotationEditor.prototype.renderAnnotationElement = function (annotation) {
          var content = annotation.container.querySelector(".annotationContent");
          if (!content) {
              content = document.createElement("div");
              content.classList.add("annotationContent", this.editorType);
              annotation.container.prepend(content);
          }
          else if (content.nodeName === "CANVAS") {
              var canvas = content;
              content = document.createElement("div");
              content.classList.add("annotationContent", this.editorType);
              canvas.before(content);
          }
          return content;
      };
      AnnotationEditor.prototype.resetAnnotationElement = function (annotation) {
          var firstChild = annotation.container.firstChild;
          if (firstChild.nodeName === "DIV" && firstChild.classList.contains("annotationContent")) {
              firstChild.remove();
          }
      };
      var _AnnotationEditor_instances, _f, _AnnotationEditor_allResizerDivs, _AnnotationEditor_altText, _AnnotationEditor_disabled, _AnnotationEditor_keepAspectRatio, _AnnotationEditor_resizersDiv, _AnnotationEditor_savedDimensions, _AnnotationEditor_boundFocusin, _AnnotationEditor_boundFocusout, _AnnotationEditor_editToolbar, _AnnotationEditor_focusedResizerName, _AnnotationEditor_hasBeenClicked, _AnnotationEditor_initialPosition, _AnnotationEditor_isEditing, _AnnotationEditor_isInEditMode, _AnnotationEditor_isResizerEnabledForKeyboard, _AnnotationEditor_moveInDOMTimeout, _AnnotationEditor_prevDragX, _AnnotationEditor_prevDragY, _AnnotationEditor_telemetryTimeouts, _AnnotationEditor_isDraggable, _AnnotationEditor_zIndex, _AnnotationEditor_translate, _AnnotationEditor_rotatePoint, _AnnotationEditor_getRotationMatrix, _AnnotationEditor_createResizers, _AnnotationEditor_resizerPointerdown, _AnnotationEditor_addResizeToUndoStack, _AnnotationEditor_resizerPointermove, _AnnotationEditor_selectOnPointerEvent, _AnnotationEditor_setUpDragSession, _AnnotationEditor_resizerKeydown, _AnnotationEditor_resizerBlur, _AnnotationEditor_resizerFocus, _AnnotationEditor_setResizerTabIndex, _AnnotationEditor_stopResizing;
      _f = AnnotationEditor, _AnnotationEditor_allResizerDivs = new WeakMap(), _AnnotationEditor_altText = new WeakMap(), _AnnotationEditor_disabled = new WeakMap(), _AnnotationEditor_keepAspectRatio = new WeakMap(), _AnnotationEditor_resizersDiv = new WeakMap(), _AnnotationEditor_savedDimensions = new WeakMap(), _AnnotationEditor_boundFocusin = new WeakMap(), _AnnotationEditor_boundFocusout = new WeakMap(), _AnnotationEditor_editToolbar = new WeakMap(), _AnnotationEditor_focusedResizerName = new WeakMap(), _AnnotationEditor_hasBeenClicked = new WeakMap(), _AnnotationEditor_initialPosition = new WeakMap(), _AnnotationEditor_isEditing = new WeakMap(), _AnnotationEditor_isInEditMode = new WeakMap(), _AnnotationEditor_isResizerEnabledForKeyboard = new WeakMap(), _AnnotationEditor_moveInDOMTimeout = new WeakMap(), _AnnotationEditor_prevDragX = new WeakMap(), _AnnotationEditor_prevDragY = new WeakMap(), _AnnotationEditor_telemetryTimeouts = new WeakMap(), _AnnotationEditor_isDraggable = new WeakMap(), _AnnotationEditor_zIndex = new WeakMap(), _AnnotationEditor_instances = new WeakSet(), _AnnotationEditor_translate = function _AnnotationEditor_translate(_g, x, y) {
          var _h;
          var width = _g[0], height = _g[1];
          _h = this.screenToPageTranslation(x, y), x = _h[0], y = _h[1];
          this.x += x / width;
          this.y += y / height;
          this.fixAndSetPosition();
      }, _AnnotationEditor_rotatePoint = function _AnnotationEditor_rotatePoint(x, y, angle) {
          switch (angle) {
              case 90:
                  return [y, -x];
              case 180:
                  return [-x, -y];
              case 270:
                  return [-y, x];
              default:
                  return [x, y];
          }
      }, _AnnotationEditor_getRotationMatrix = function _AnnotationEditor_getRotationMatrix(rotation) {
          switch (rotation) {
              case 90:
                  {
                      var _g = this.pageDimensions, pageWidth = _g[0], pageHeight = _g[1];
                      return [0, -pageWidth / pageHeight, pageHeight / pageWidth, 0];
                  }
              case 180:
                  return [-1, 0, 0, -1];
              case 270:
                  {
                      var _h = this.pageDimensions, pageWidth = _h[0], pageHeight = _h[1];
                      return [0, pageWidth / pageHeight, -pageHeight / pageWidth, 0];
                  }
              default:
                  return [1, 0, 0, 1];
          }
      }, _AnnotationEditor_createResizers = function _AnnotationEditor_createResizers() {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_resizersDiv, document.createElement("div"), "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").classList.add("resizers");
          var classes = this._willKeepAspectRatio ? ["topLeft", "topRight", "bottomRight", "bottomLeft"] : ["topLeft", "topMiddle", "topRight", "middleRight", "bottomRight", "bottomMiddle", "bottomLeft", "middleLeft"];
          for (var _i = 0, classes_1 = classes; _i < classes_1.length; _i++) {
              var name = classes_1[_i];
              var div = document.createElement("div");
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f").append(div);
              div.classList.add("resizer", name);
              div.setAttribute("data-resizer-name", name);
              div.addEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerPointerdown).bind(this, name));
              div.addEventListener("contextmenu", noContextMenu);
              div.tabIndex = -1;
          }
          this.div.prepend(tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f"));
      }, _AnnotationEditor_resizerPointerdown = function _AnnotationEditor_resizerPointerdown(name, event) {
          var _this = this;
          var _g;
          event.preventDefault();
          var isMac = util_FeatureTest.platform.isMac;
          if (event.button !== 0 || event.ctrlKey && isMac) {
              return;
          }
          (_g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.toggle(false);
          var boundResizerPointermove = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_resizerPointermove).bind(this, name);
          var savedDraggable = this._isDraggable;
          this._isDraggable = false;
          var pointerMoveOptions = {
              passive: true,
              capture: true
          };
          this.parent.togglePointerEvents(false);
          window.addEventListener("pointermove", boundResizerPointermove, pointerMoveOptions);
          window.addEventListener("contextmenu", noContextMenu);
          var savedX = this.x;
          var savedY = this.y;
          var savedWidth = this.width;
          var savedHeight = this.height;
          var savedParentCursor = this.parent.div.style.cursor;
          var savedCursor = this.div.style.cursor;
          this.div.style.cursor = this.parent.div.style.cursor = window.getComputedStyle(event.target).cursor;
          var pointerUpCallback = function () {
              var _g;
              _this.parent.togglePointerEvents(true);
              (_g = tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_altText, "f")) === null || _g === void 0 ? void 0 : _g.toggle(true);
              _this._isDraggable = savedDraggable;
              window.removeEventListener("pointerup", pointerUpCallback);
              window.removeEventListener("blur", pointerUpCallback);
              window.removeEventListener("pointermove", boundResizerPointermove, pointerMoveOptions);
              window.removeEventListener("contextmenu", noContextMenu);
              _this.parent.div.style.cursor = savedParentCursor;
              _this.div.style.cursor = savedCursor;
              tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_instances, "m", _AnnotationEditor_addResizeToUndoStack).call(_this, savedX, savedY, savedWidth, savedHeight);
          };
          window.addEventListener("pointerup", pointerUpCallback);
          window.addEventListener("blur", pointerUpCallback);
      }, _AnnotationEditor_addResizeToUndoStack = function _AnnotationEditor_addResizeToUndoStack(savedX, savedY, savedWidth, savedHeight) {
          var _this = this;
          var newX = this.x;
          var newY = this.y;
          var newWidth = this.width;
          var newHeight = this.height;
          if (newX === savedX && newY === savedY && newWidth === savedWidth && newHeight === savedHeight) {
              return;
          }
          this.addCommands({
              cmd: function () {
                  _this.width = newWidth;
                  _this.height = newHeight;
                  _this.x = newX;
                  _this.y = newY;
                  var _g = _this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
                  _this.setDims(parentWidth * newWidth, parentHeight * newHeight);
                  _this.fixAndSetPosition();
              },
              undo: function () {
                  _this.width = savedWidth;
                  _this.height = savedHeight;
                  _this.x = savedX;
                  _this.y = savedY;
                  var _g = _this.parentDimensions, parentWidth = _g[0], parentHeight = _g[1];
                  _this.setDims(parentWidth * savedWidth, parentHeight * savedHeight);
                  _this.fixAndSetPosition();
              },
              mustExec: true
          });
      }, _AnnotationEditor_resizerPointermove = function _AnnotationEditor_resizerPointermove(name, event) {
          var _g;
          var _h = this.parentDimensions, parentWidth = _h[0], parentHeight = _h[1];
          var savedX = this.x;
          var savedY = this.y;
          var savedWidth = this.width;
          var savedHeight = this.height;
          var minWidth = AnnotationEditor.MIN_SIZE / parentWidth;
          var minHeight = AnnotationEditor.MIN_SIZE / parentHeight;
          var round = function (x) { return Math.round(x * 10000) / 10000; };
          var rotationMatrix = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_getRotationMatrix).call(this, this.rotation);
          var transf = function (x, y) { return [rotationMatrix[0] * x + rotationMatrix[2] * y, rotationMatrix[1] * x + rotationMatrix[3] * y]; };
          var invRotationMatrix = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_getRotationMatrix).call(this, 360 - this.rotation);
          var invTransf = function (x, y) { return [invRotationMatrix[0] * x + invRotationMatrix[2] * y, invRotationMatrix[1] * x + invRotationMatrix[3] * y]; };
          var getPoint;
          var getOpposite;
          var isDiagonal = false;
          var isHorizontal = false;
          switch (name) {
              case "topLeft":
                  isDiagonal = true;
                  getPoint = function (w, h) { return [0, 0]; };
                  getOpposite = function (w, h) { return [w, h]; };
                  break;
              case "topMiddle":
                  getPoint = function (w, h) { return [w / 2, 0]; };
                  getOpposite = function (w, h) { return [w / 2, h]; };
                  break;
              case "topRight":
                  isDiagonal = true;
                  getPoint = function (w, h) { return [w, 0]; };
                  getOpposite = function (w, h) { return [0, h]; };
                  break;
              case "middleRight":
                  isHorizontal = true;
                  getPoint = function (w, h) { return [w, h / 2]; };
                  getOpposite = function (w, h) { return [0, h / 2]; };
                  break;
              case "bottomRight":
                  isDiagonal = true;
                  getPoint = function (w, h) { return [w, h]; };
                  getOpposite = function (w, h) { return [0, 0]; };
                  break;
              case "bottomMiddle":
                  getPoint = function (w, h) { return [w / 2, h]; };
                  getOpposite = function (w, h) { return [w / 2, 0]; };
                  break;
              case "bottomLeft":
                  isDiagonal = true;
                  getPoint = function (w, h) { return [0, h]; };
                  getOpposite = function (w, h) { return [w, 0]; };
                  break;
              case "middleLeft":
                  isHorizontal = true;
                  getPoint = function (w, h) { return [0, h / 2]; };
                  getOpposite = function (w, h) { return [w, h / 2]; };
                  break;
          }
          var point = getPoint(savedWidth, savedHeight);
          var oppositePoint = getOpposite(savedWidth, savedHeight);
          var transfOppositePoint = transf.apply(void 0, oppositePoint);
          var oppositeX = round(savedX + transfOppositePoint[0]);
          var oppositeY = round(savedY + transfOppositePoint[1]);
          var ratioX = 1;
          var ratioY = 1;
          var _j = this.screenToPageTranslation(event.movementX, event.movementY), deltaX = _j[0], deltaY = _j[1];
          _g = invTransf(deltaX / parentWidth, deltaY / parentHeight), deltaX = _g[0], deltaY = _g[1];
          if (isDiagonal) {
              var oldDiag = Math.hypot(savedWidth, savedHeight);
              ratioX = ratioY = Math.max(Math.min(Math.hypot(oppositePoint[0] - point[0] - deltaX, oppositePoint[1] - point[1] - deltaY) / oldDiag, 1 / savedWidth, 1 / savedHeight), minWidth / savedWidth, minHeight / savedHeight);
          }
          else if (isHorizontal) {
              ratioX = Math.max(minWidth, Math.min(1, Math.abs(oppositePoint[0] - point[0] - deltaX))) / savedWidth;
          }
          else {
              ratioY = Math.max(minHeight, Math.min(1, Math.abs(oppositePoint[1] - point[1] - deltaY))) / savedHeight;
          }
          var newWidth = round(savedWidth * ratioX);
          var newHeight = round(savedHeight * ratioY);
          transfOppositePoint = transf.apply(void 0, getOpposite(newWidth, newHeight));
          var newX = oppositeX - transfOppositePoint[0];
          var newY = oppositeY - transfOppositePoint[1];
          this.width = newWidth;
          this.height = newHeight;
          this.x = newX;
          this.y = newY;
          this.setDims(parentWidth * newWidth, parentHeight * newHeight);
          this.fixAndSetPosition();
      }, _AnnotationEditor_selectOnPointerEvent = function _AnnotationEditor_selectOnPointerEvent(event) {
          var isMac = util_FeatureTest.platform.isMac;
          if (event.ctrlKey && !isMac || event.shiftKey || event.metaKey && isMac) {
              this.parent.toggleSelected(this);
          }
          else {
              this.parent.setSelected(this);
          }
      }, _AnnotationEditor_setUpDragSession = function _AnnotationEditor_setUpDragSession(event) {
          var _this = this;
          var isSelected = this._uiManager.isSelected(this);
          this._uiManager.setUpDragSession();
          var pointerMoveOptions, pointerMoveCallback;
          if (isSelected) {
              this.div.classList.add("moving");
              pointerMoveOptions = {
                  passive: true,
                  capture: true
              };
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_prevDragX, event.clientX, "f");
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_prevDragY, event.clientY, "f");
              pointerMoveCallback = function (e) {
                  var x = e.clientX, y = e.clientY;
                  var _g = _this.screenToPageTranslation(x - tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_prevDragX, "f"), y - tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_prevDragY, "f")), tx = _g[0], ty = _g[1];
                  tslib_1.__classPrivateFieldSet(_this, _AnnotationEditor_prevDragX, x, "f");
                  tslib_1.__classPrivateFieldSet(_this, _AnnotationEditor_prevDragY, y, "f");
                  _this._uiManager.dragSelectedEditors(tx, ty);
              };
              window.addEventListener("pointermove", pointerMoveCallback, pointerMoveOptions);
          }
          var pointerUpCallback = function () {
              window.removeEventListener("pointerup", pointerUpCallback);
              window.removeEventListener("blur", pointerUpCallback);
              if (isSelected) {
                  _this.div.classList.remove("moving");
                  window.removeEventListener("pointermove", pointerMoveCallback, pointerMoveOptions);
              }
              tslib_1.__classPrivateFieldSet(_this, _AnnotationEditor_hasBeenClicked, false, "f");
              if (!_this._uiManager.endDragSession()) {
                  tslib_1.__classPrivateFieldGet(_this, _AnnotationEditor_instances, "m", _AnnotationEditor_selectOnPointerEvent).call(_this, event);
              }
          };
          window.addEventListener("pointerup", pointerUpCallback);
          window.addEventListener("blur", pointerUpCallback);
      }, _AnnotationEditor_resizerKeydown = function _AnnotationEditor_resizerKeydown(event) {
          AnnotationEditor._resizerKeyboardManager.exec(this, event);
      }, _AnnotationEditor_resizerBlur = function _AnnotationEditor_resizerBlur(event) {
          var _g;
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isResizerEnabledForKeyboard, "f") && ((_g = event.relatedTarget) === null || _g === void 0 ? void 0 : _g.parentNode) !== tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_resizersDiv, "f")) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_stopResizing).call(this);
          }
      }, _AnnotationEditor_resizerFocus = function _AnnotationEditor_resizerFocus(name) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_focusedResizerName, tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_isResizerEnabledForKeyboard, "f") ? name : "", "f");
      }, _AnnotationEditor_setResizerTabIndex = function _AnnotationEditor_setResizerTabIndex(value) {
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f")) {
              return;
          }
          for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_allResizerDivs, "f"); _i < _g.length; _i++) {
              var div = _g[_i];
              div.tabIndex = value;
          }
      }, _AnnotationEditor_stopResizing = function _AnnotationEditor_stopResizing() {
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_isResizerEnabledForKeyboard, false, "f");
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_setResizerTabIndex).call(this, -1);
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_savedDimensions, "f")) {
              var _g = tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_savedDimensions, "f"), savedX = _g.savedX, savedY = _g.savedY, savedWidth = _g.savedWidth, savedHeight = _g.savedHeight;
              tslib_1.__classPrivateFieldGet(this, _AnnotationEditor_instances, "m", _AnnotationEditor_addResizeToUndoStack).call(this, savedX, savedY, savedWidth, savedHeight);
              tslib_1.__classPrivateFieldSet(this, _AnnotationEditor_savedDimensions, null, "f");
          }
      };
      AnnotationEditor._borderLineWidth = -1;
      AnnotationEditor._colorManager = new ColorManager();
      AnnotationEditor._zIndex = 1;
      AnnotationEditor._telemetryTimeout = 1000;
      return AnnotationEditor;
  }());
  var FakeEditor = /** @class */ (function (_super) {
      tslib_1.__extends(FakeEditor, _super);
      function FakeEditor(params) {
          var _this = _super.call(this, params) || this;
          _this.annotationElementId = params.annotationElementId;
          _this.deleted = true;
          return _this;
      }
      FakeEditor.prototype.serialize = function () {
          return {
              id: this.annotationElementId,
              deleted: true,
              pageIndex: this.pageIndex
          };
      };
      return FakeEditor;
  }(AnnotationEditor));
  ; // CONCATENATED MODULE: ./src/shared/murmurhash3.js
  var SEED = 0xc3d2e1f0;
  var MASK_HIGH = 0xffff0000;
  var MASK_LOW = 0xffff;
  var MurmurHash3_64 = /** @class */ (function () {
      function MurmurHash3_64(seed) {
          this.h1 = seed ? seed & 0xffffffff : SEED;
          this.h2 = seed ? seed & 0xffffffff : SEED;
      }
      MurmurHash3_64.prototype.update = function (input) {
          var data, length;
          if (typeof input === "string") {
              data = new Uint8Array(input.length * 2);
              length = 0;
              for (var i = 0, ii = input.length; i < ii; i++) {
                  var code = input.charCodeAt(i);
                  if (code <= 0xff) {
                      data[length++] = code;
                  }
                  else {
                      data[length++] = code >>> 8;
                      data[length++] = code & 0xff;
                  }
              }
          }
          else if (ArrayBuffer.isView(input)) {
              data = input.slice();
              length = data.byteLength;
          }
          else {
              throw new Error("Invalid data format, must be a string or TypedArray.");
          }
          var blockCounts = length >> 2;
          var tailLength = length - blockCounts * 4;
          var dataUint32 = new Uint32Array(data.buffer, 0, blockCounts);
          var k1 = 0, k2 = 0;
          var h1 = this.h1, h2 = this.h2;
          var C1 = 0xcc9e2d51, C2 = 0x1b873593;
          var C1_LOW = C1 & MASK_LOW, C2_LOW = C2 & MASK_LOW;
          for (var i = 0; i < blockCounts; i++) {
              if (i & 1) {
                  k1 = dataUint32[i];
                  k1 = k1 * C1 & MASK_HIGH | k1 * C1_LOW & MASK_LOW;
                  k1 = k1 << 15 | k1 >>> 17;
                  k1 = k1 * C2 & MASK_HIGH | k1 * C2_LOW & MASK_LOW;
                  h1 ^= k1;
                  h1 = h1 << 13 | h1 >>> 19;
                  h1 = h1 * 5 + 0xe6546b64;
              }
              else {
                  k2 = dataUint32[i];
                  k2 = k2 * C1 & MASK_HIGH | k2 * C1_LOW & MASK_LOW;
                  k2 = k2 << 15 | k2 >>> 17;
                  k2 = k2 * C2 & MASK_HIGH | k2 * C2_LOW & MASK_LOW;
                  h2 ^= k2;
                  h2 = h2 << 13 | h2 >>> 19;
                  h2 = h2 * 5 + 0xe6546b64;
              }
          }
          k1 = 0;
          switch (tailLength) {
              case 3:
                  k1 ^= data[blockCounts * 4 + 2] << 16;
              case 2:
                  k1 ^= data[blockCounts * 4 + 1] << 8;
              case 1:
                  k1 ^= data[blockCounts * 4];
                  k1 = k1 * C1 & MASK_HIGH | k1 * C1_LOW & MASK_LOW;
                  k1 = k1 << 15 | k1 >>> 17;
                  k1 = k1 * C2 & MASK_HIGH | k1 * C2_LOW & MASK_LOW;
                  if (blockCounts & 1) {
                      h1 ^= k1;
                  }
                  else {
                      h2 ^= k1;
                  }
          }
          this.h1 = h1;
          this.h2 = h2;
      };
      MurmurHash3_64.prototype.hexdigest = function () {
          var h1 = this.h1, h2 = this.h2;
          h1 ^= h2 >>> 1;
          h1 = h1 * 0xed558ccd & MASK_HIGH | h1 * 0x8ccd & MASK_LOW;
          h2 = h2 * 0xff51afd7 & MASK_HIGH | ((h2 << 16 | h1 >>> 16) * 0xafd7ed55 & MASK_HIGH) >>> 16;
          h1 ^= h2 >>> 1;
          h1 = h1 * 0x1a85ec53 & MASK_HIGH | h1 * 0xec53 & MASK_LOW;
          h2 = h2 * 0xc4ceb9fe & MASK_HIGH | ((h2 << 16 | h1 >>> 16) * 0xb9fe1a85 & MASK_HIGH) >>> 16;
          h1 ^= h2 >>> 1;
          return (h1 >>> 0).toString(16).padStart(8, "0") + (h2 >>> 0).toString(16).padStart(8, "0");
      };
      return MurmurHash3_64;
  }());
  ; // CONCATENATED MODULE: ./src/display/annotation_storage.js
  var SerializableEmpty = Object.freeze({
      map: null,
      hash: "",
      transfer: undefined
  });
  var AnnotationStorage = /** @class */ (function () {
      function AnnotationStorage() {
          _AnnotationStorage_instances.add(this);
          _AnnotationStorage_modified.set(this, false);
          _AnnotationStorage_storage.set(this, new Map());
          this.onSetModified = null;
          this.onResetModified = null;
          this.onAnnotationEditor = null;
      }
      AnnotationStorage.prototype.getValue = function (key, defaultValue) {
          var value = tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").get(key);
          if (value === undefined) {
              return defaultValue;
          }
          return Object.assign(defaultValue, value);
      };
      AnnotationStorage.prototype.getRawValue = function (key) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").get(key);
      };
      AnnotationStorage.prototype.remove = function (key) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").delete(key);
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").size === 0) {
              this.resetModified();
          }
          if (typeof this.onAnnotationEditor === "function") {
              for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").values(); _i < _g.length; _i++) {
                  var value = _g[_i];
                  if (value instanceof AnnotationEditor) {
                      return;
                  }
              }
              this.onAnnotationEditor(null);
          }
      };
      AnnotationStorage.prototype.setValue = function (key, value) {
          var obj = tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").get(key);
          var modified = false;
          if (obj !== undefined) {
              for (var _i = 0, _g = Object.entries(value); _i < _g.length; _i++) {
                  var _h = _g[_i], entry = _h[0], val = _h[1];
                  if (obj[entry] !== val) {
                      modified = true;
                      obj[entry] = val;
                  }
              }
          }
          else {
              modified = true;
              tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").set(key, value);
          }
          if (modified) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_instances, "m", _AnnotationStorage_setModified).call(this);
          }
          if (value instanceof AnnotationEditor && typeof this.onAnnotationEditor === "function") {
              this.onAnnotationEditor(value.constructor._type);
          }
      };
      AnnotationStorage.prototype.has = function (key) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").has(key);
      };
      AnnotationStorage.prototype.getAll = function () {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").size > 0 ? objectFromMap(tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f")) : null;
      };
      AnnotationStorage.prototype.setAll = function (obj) {
          for (var _i = 0, _g = Object.entries(obj); _i < _g.length; _i++) {
              var _h = _g[_i], key = _h[0], val = _h[1];
              this.setValue(key, val);
          }
      };
      Object.defineProperty(AnnotationStorage.prototype, "size", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").size;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationStorage.prototype.resetModified = function () {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_modified, "f")) {
              tslib_1.__classPrivateFieldSet(this, _AnnotationStorage_modified, false, "f");
              if (typeof this.onResetModified === "function") {
                  this.onResetModified();
              }
          }
      };
      Object.defineProperty(AnnotationStorage.prototype, "print", {
          get: function () {
              return new PrintAnnotationStorage(this);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationStorage.prototype, "serializable", {
          get: function () {
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").size === 0) {
                  return SerializableEmpty;
              }
              var map = new Map(), hash = new MurmurHash3_64(), transfer = [];
              var context = Object.create(null);
              var hasBitmap = false;
              for (var _i = 0, _g = tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f"); _i < _g.length; _i++) {
                  var _h = _g[_i], key = _h[0], val = _h[1];
                  var serialized = val instanceof AnnotationEditor ? val.serialize(false, context) : val;
                  if (serialized) {
                      map.set(key, serialized);
                      hash.update("".concat(key, ":").concat(JSON.stringify(serialized)));
                      hasBitmap || (hasBitmap = !!serialized.bitmap);
                  }
              }
              if (hasBitmap) {
                  for (var _j = 0, _k = map.values(); _j < _k.length; _j++) {
                      var value = _k[_j];
                      if (value.bitmap) {
                          transfer.push(value.bitmap);
                      }
                  }
              }
              return map.size > 0 ? {
                  map: map,
                  hash: hash.hexdigest(),
                  transfer: transfer
              } : SerializableEmpty;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationStorage.prototype, "editorStats", {
          get: function () {
              var _g;
              var stats = null;
              var typeToEditor = new Map();
              for (var _i = 0, _h = tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_storage, "f").values(); _i < _h.length; _i++) {
                  var value = _h[_i];
                  if (!(value instanceof AnnotationEditor)) {
                      continue;
                  }
                  var editorStats = value.telemetryFinalData;
                  if (!editorStats) {
                      continue;
                  }
                  var type = editorStats.type;
                  if (!typeToEditor.has(type)) {
                      typeToEditor.set(type, Object.getPrototypeOf(value).constructor);
                  }
                  stats || (stats = Object.create(null));
                  var map = stats[type] || (stats[type] = new Map());
                  for (var _j = 0, _k = Object.entries(editorStats); _j < _k.length; _j++) {
                      var _l = _k[_j], key = _l[0], val = _l[1];
                      if (key === "type") {
                          continue;
                      }
                      var counters = map.get(key);
                      if (!counters) {
                          counters = new Map();
                          map.set(key, counters);
                      }
                      var count = (_g = counters.get(val)) !== null && _g !== void 0 ? _g : 0;
                      counters.set(val, count + 1);
                  }
              }
              for (var _m = 0, typeToEditor_1 = typeToEditor; _m < typeToEditor_1.length; _m++) {
                  var _o = typeToEditor_1[_m], type = _o[0], editor = _o[1];
                  stats[type] = editor.computeTelemetryFinalData(stats[type]);
              }
              return stats;
          },
          enumerable: false,
          configurable: true
      });
      return AnnotationStorage;
  }());
  _AnnotationStorage_modified = new WeakMap(), _AnnotationStorage_storage = new WeakMap(), _AnnotationStorage_instances = new WeakSet(), _AnnotationStorage_setModified = function _AnnotationStorage_setModified() {
      if (!tslib_1.__classPrivateFieldGet(this, _AnnotationStorage_modified, "f")) {
          tslib_1.__classPrivateFieldSet(this, _AnnotationStorage_modified, true, "f");
          if (typeof this.onSetModified === "function") {
              this.onSetModified();
          }
      }
  };
  var PrintAnnotationStorage = /** @class */ (function (_super) {
      tslib_1.__extends(PrintAnnotationStorage, _super);
      function PrintAnnotationStorage(parent) {
          var _this = _super.call(this) || this;
          _PrintAnnotationStorage_serializable.set(_this, void 0);
          var _g = parent.serializable, map = _g.map, hash = _g.hash, transfer = _g.transfer;
          var clone = structuredClone(map, transfer ? {
              transfer: transfer
          } : null);
          tslib_1.__classPrivateFieldSet(_this, _PrintAnnotationStorage_serializable, {
              map: clone,
              hash: hash,
              transfer: transfer
          }, "f");
          return _this;
      }
      Object.defineProperty(PrintAnnotationStorage.prototype, "print", {
          get: function () {
              unreachable("Should not call PrintAnnotationStorage.print");
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PrintAnnotationStorage.prototype, "serializable", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _PrintAnnotationStorage_serializable, "f");
          },
          enumerable: false,
          configurable: true
      });
      return PrintAnnotationStorage;
  }(AnnotationStorage));
  _PrintAnnotationStorage_serializable = new WeakMap();
  ; // CONCATENATED MODULE: ./src/display/font_loader.js
  var FontLoader = /** @class */ (function () {
      function FontLoader(_g) {
          var _h = _g.ownerDocument, ownerDocument = _h === void 0 ? globalThis.document : _h, _j = _g.styleElement, styleElement = _j === void 0 ? null : _j;
          _FontLoader_systemFonts.set(this, new Set());
          this._document = ownerDocument;
          this.nativeFontFaces = new Set();
          this.styleElement = null;
          this.loadingRequests = [];
          this.loadTestFontId = 0;
      }
      FontLoader.prototype.addNativeFontFace = function (nativeFontFace) {
          this.nativeFontFaces.add(nativeFontFace);
          this._document.fonts.add(nativeFontFace);
      };
      FontLoader.prototype.removeNativeFontFace = function (nativeFontFace) {
          this.nativeFontFaces.delete(nativeFontFace);
          this._document.fonts.delete(nativeFontFace);
      };
      FontLoader.prototype.insertRule = function (rule) {
          if (!this.styleElement) {
              this.styleElement = this._document.createElement("style");
              this._document.documentElement.getElementsByTagName("head")[0].append(this.styleElement);
          }
          var styleSheet = this.styleElement.sheet;
          styleSheet.insertRule(rule, styleSheet.cssRules.length);
      };
      FontLoader.prototype.clear = function () {
          for (var _i = 0, _g = this.nativeFontFaces; _i < _g.length; _i++) {
              var nativeFontFace = _g[_i];
              this._document.fonts.delete(nativeFontFace);
          }
          this.nativeFontFaces.clear();
          tslib_1.__classPrivateFieldGet(this, _FontLoader_systemFonts, "f").clear();
          if (this.styleElement) {
              this.styleElement.remove();
              this.styleElement = null;
          }
      };
      FontLoader.prototype.loadSystemFont = function (_g) {
          var info = _g.systemFontInfo, _inspectFont = _g._inspectFont;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var loadedName, src, style, fontFace, _h;
              return tslib_1.__generator(this, function (_j) {
                  switch (_j.label) {
                      case 0:
                          if (!info || tslib_1.__classPrivateFieldGet(this, _FontLoader_systemFonts, "f").has(info.loadedName)) {
                              return [2 /*return*/];
                          }
                          assert(!this.disableFontFace, "loadSystemFont shouldn't be called when `disableFontFace` is set.");
                          if (!this.isFontLoadingAPISupported) return [3 /*break*/, 5];
                          loadedName = info.loadedName, src = info.src, style = info.style;
                          fontFace = new FontFace(loadedName, src, style);
                          this.addNativeFontFace(fontFace);
                          _j.label = 1;
                      case 1:
                          _j.trys.push([1, 3, , 4]);
                          return [4 /*yield*/, fontFace.load()];
                      case 2:
                          _j.sent();
                          tslib_1.__classPrivateFieldGet(this, _FontLoader_systemFonts, "f").add(loadedName);
                          _inspectFont === null || _inspectFont === void 0 ? void 0 : _inspectFont(info);
                          return [3 /*break*/, 4];
                      case 3:
                          _h = _j.sent();
                          warn("Cannot load system font: ".concat(info.baseFontName, ", installing it could help to improve PDF rendering."));
                          this.removeNativeFontFace(fontFace);
                          return [3 /*break*/, 4];
                      case 4: return [2 /*return*/];
                      case 5:
                          unreachable("Not implemented: loadSystemFont without the Font Loading API.");
                          return [2 /*return*/];
                  }
              });
          });
      };
      FontLoader.prototype.bind = function (font) {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var nativeFontFace, ex_1, rule;
              var _this = this;
              return tslib_1.__generator(this, function (_g) {
                  switch (_g.label) {
                      case 0:
                          if (font.attached || font.missingFile && !font.systemFontInfo) {
                              return [2 /*return*/];
                          }
                          font.attached = true;
                          if (!font.systemFontInfo) return [3 /*break*/, 2];
                          return [4 /*yield*/, this.loadSystemFont(font)];
                      case 1:
                          _g.sent();
                          return [2 /*return*/];
                      case 2:
                          if (!this.isFontLoadingAPISupported) return [3 /*break*/, 7];
                          nativeFontFace = font.createNativeFontFace();
                          if (!nativeFontFace) return [3 /*break*/, 6];
                          this.addNativeFontFace(nativeFontFace);
                          _g.label = 3;
                      case 3:
                          _g.trys.push([3, 5, , 6]);
                          return [4 /*yield*/, nativeFontFace.loaded];
                      case 4:
                          _g.sent();
                          return [3 /*break*/, 6];
                      case 5:
                          ex_1 = _g.sent();
                          warn("Failed to load font '".concat(nativeFontFace.family, "': '").concat(ex_1, "'."));
                          font.disableFontFace = true;
                          throw ex_1;
                      case 6: return [2 /*return*/];
                      case 7:
                          rule = font.createFontFaceRule();
                          if (!rule) return [3 /*break*/, 9];
                          this.insertRule(rule);
                          if (this.isSyncFontLoadingSupported) {
                              return [2 /*return*/];
                          }
                          return [4 /*yield*/, new Promise(function (resolve) {
                                  var request = _this._queueLoadingCallback(resolve);
                                  _this._prepareFontLoadEvent(font, request);
                              })];
                      case 8:
                          _g.sent();
                          _g.label = 9;
                      case 9: return [2 /*return*/];
                  }
              });
          });
      };
      Object.defineProperty(FontLoader.prototype, "isFontLoadingAPISupported", {
          get: function () {
              var _g;
              var hasFonts = !!((_g = this._document) === null || _g === void 0 ? void 0 : _g.fonts);
              return shadow(this, "isFontLoadingAPISupported", hasFonts);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(FontLoader.prototype, "isSyncFontLoadingSupported", {
          get: function () {
              var supported = false;
              if (isNodeJS) {
                  supported = true;
              }
              else if (typeof navigator !== "undefined" && typeof (navigator === null || navigator === void 0 ? void 0 : navigator.userAgent) === "string" && /Mozilla\/5.0.*?rv:\d+.*? Gecko/.test(navigator.userAgent)) {
                  supported = true;
              }
              return shadow(this, "isSyncFontLoadingSupported", supported);
          },
          enumerable: false,
          configurable: true
      });
      FontLoader.prototype._queueLoadingCallback = function (callback) {
          function completeRequest() {
              assert(!request.done, "completeRequest() cannot be called twice.");
              request.done = true;
              while (loadingRequests.length > 0 && loadingRequests[0].done) {
                  var otherRequest = loadingRequests.shift();
                  setTimeout(otherRequest.callback, 0);
              }
          }
          var loadingRequests = this.loadingRequests;
          var request = {
              done: false,
              complete: completeRequest,
              callback: callback
          };
          loadingRequests.push(request);
          return request;
      };
      Object.defineProperty(FontLoader.prototype, "_loadTestFont", {
          get: function () {
              var testFont = atob("T1RUTwALAIAAAwAwQ0ZGIDHtZg4AAAOYAAAAgUZGVE1lkzZwAAAEHAAAABxHREVGABQA" + "FQAABDgAAAAeT1MvMlYNYwkAAAEgAAAAYGNtYXABDQLUAAACNAAAAUJoZWFk/xVFDQAA" + "ALwAAAA2aGhlYQdkA+oAAAD0AAAAJGhtdHgD6AAAAAAEWAAAAAZtYXhwAAJQAAAAARgA" + "AAAGbmFtZVjmdH4AAAGAAAAAsXBvc3T/hgAzAAADeAAAACAAAQAAAAEAALZRFsRfDzz1" + "AAsD6AAAAADOBOTLAAAAAM4KHDwAAAAAA+gDIQAAAAgAAgAAAAAAAAABAAADIQAAAFoD" + "6AAAAAAD6AABAAAAAAAAAAAAAAAAAAAAAQAAUAAAAgAAAAQD6AH0AAUAAAKKArwAAACM" + "AooCvAAAAeAAMQECAAACAAYJAAAAAAAAAAAAAQAAAAAAAAAAAAAAAFBmRWQAwAAuAC4D" + "IP84AFoDIQAAAAAAAQAAAAAAAAAAACAAIAABAAAADgCuAAEAAAAAAAAAAQAAAAEAAAAA" + "AAEAAQAAAAEAAAAAAAIAAQAAAAEAAAAAAAMAAQAAAAEAAAAAAAQAAQAAAAEAAAAAAAUA" + "AQAAAAEAAAAAAAYAAQAAAAMAAQQJAAAAAgABAAMAAQQJAAEAAgABAAMAAQQJAAIAAgAB" + "AAMAAQQJAAMAAgABAAMAAQQJAAQAAgABAAMAAQQJAAUAAgABAAMAAQQJAAYAAgABWABY" + "AAAAAAAAAwAAAAMAAAAcAAEAAAAAADwAAwABAAAAHAAEACAAAAAEAAQAAQAAAC7//wAA" + "AC7////TAAEAAAAAAAABBgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAD/gwAyAAAAAQAAAAAAAAAAAAAAAAAA" + "AAABAAQEAAEBAQJYAAEBASH4DwD4GwHEAvgcA/gXBIwMAYuL+nz5tQXkD5j3CBLnEQAC" + "AQEBIVhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYAAABAQAADwACAQEEE/t3" + "Dov6fAH6fAT+fPp8+nwHDosMCvm1Cvm1DAz6fBQAAAAAAAABAAAAAMmJbzEAAAAAzgTj" + "FQAAAADOBOQpAAEAAAAAAAAADAAUAAQAAAABAAAAAgABAAAAAAAAAAAD6AAAAAAAAA==");
              return shadow(this, "_loadTestFont", testFont);
          },
          enumerable: false,
          configurable: true
      });
      FontLoader.prototype._prepareFontLoadEvent = function (font, request) {
          function int32(data, offset) {
              return data.charCodeAt(offset) << 24 | data.charCodeAt(offset + 1) << 16 | data.charCodeAt(offset + 2) << 8 | data.charCodeAt(offset + 3) & 0xff;
          }
          function spliceString(s, offset, remove, insert) {
              var chunk1 = s.substring(0, offset);
              var chunk2 = s.substring(offset + remove);
              return chunk1 + insert + chunk2;
          }
          var i, ii;
          var canvas = this._document.createElement("canvas");
          canvas.width = 1;
          canvas.height = 1;
          var ctx = canvas.getContext("2d");
          var called = 0;
          function isFontReady(name, callback) {
              if (++called > 30) {
                  warn("Load test font never loaded.");
                  callback();
                  return;
              }
              ctx.font = "30px " + name;
              ctx.fillText(".", 0, 20);
              var imageData = ctx.getImageData(0, 0, 1, 1);
              if (imageData.data[3] > 0) {
                  callback();
                  return;
              }
              setTimeout(isFontReady.bind(null, name, callback));
          }
          var loadTestFontId = "lt".concat(Date.now()).concat(this.loadTestFontId++);
          var data = this._loadTestFont;
          var COMMENT_OFFSET = 976;
          data = spliceString(data, COMMENT_OFFSET, loadTestFontId.length, loadTestFontId);
          var CFF_CHECKSUM_OFFSET = 16;
          var XXXX_VALUE = 0x58585858;
          var checksum = int32(data, CFF_CHECKSUM_OFFSET);
          for (i = 0, ii = loadTestFontId.length - 3; i < ii; i += 4) {
              checksum = checksum - XXXX_VALUE + int32(loadTestFontId, i) | 0;
          }
          if (i < loadTestFontId.length) {
              checksum = checksum - XXXX_VALUE + int32(loadTestFontId + "XXX", i) | 0;
          }
          data = spliceString(data, CFF_CHECKSUM_OFFSET, 4, string32(checksum));
          var url = "url(data:font/opentype;base64,".concat(btoa(data), ");");
          var rule = "@font-face {font-family:\"".concat(loadTestFontId, "\";src:").concat(url, "}");
          this.insertRule(rule);
          var div = this._document.createElement("div");
          div.style.visibility = "hidden";
          div.style.width = div.style.height = "10px";
          div.style.position = "absolute";
          div.style.top = div.style.left = "0px";
          for (var _i = 0, _g = [font.loadedName, loadTestFontId]; _i < _g.length; _i++) {
              var name = _g[_i];
              var span = this._document.createElement("span");
              span.textContent = "Hi";
              span.style.fontFamily = name;
              div.append(span);
          }
          this._document.body.append(div);
          isFontReady(loadTestFontId, function () {
              div.remove();
              request.complete();
          });
      };
      return FontLoader;
  }());
  _FontLoader_systemFonts = new WeakMap();
  var FontFaceObject = /** @class */ (function () {
      function FontFaceObject(translatedData, _g) {
          var _h = _g.disableFontFace, disableFontFace = _h === void 0 ? false : _h, _j = _g.inspectFont, inspectFont = _j === void 0 ? null : _j;
          this.compiledGlyphs = Object.create(null);
          for (var i in translatedData) {
              this[i] = translatedData[i];
          }
          this.disableFontFace = disableFontFace === true;
          this._inspectFont = inspectFont;
      }
      FontFaceObject.prototype.createNativeFontFace = function () {
          var _g;
          if (!this.data || this.disableFontFace) {
              return null;
          }
          var nativeFontFace;
          if (!this.cssFontInfo) {
              nativeFontFace = new FontFace(this.loadedName, this.data, {});
          }
          else {
              var css = {
                  weight: this.cssFontInfo.fontWeight
              };
              if (this.cssFontInfo.italicAngle) {
                  css.style = "oblique ".concat(this.cssFontInfo.italicAngle, "deg");
              }
              nativeFontFace = new FontFace(this.cssFontInfo.fontFamily, this.data, css);
          }
          (_g = this._inspectFont) === null || _g === void 0 ? void 0 : _g.call(this, this);
          return nativeFontFace;
      };
      FontFaceObject.prototype.createFontFaceRule = function () {
          var _g;
          if (!this.data || this.disableFontFace) {
              return null;
          }
          var data = bytesToString(this.data);
          var url = "url(data:".concat(this.mimetype, ";base64,").concat(btoa(data), ");");
          var rule;
          if (!this.cssFontInfo) {
              rule = "@font-face {font-family:\"".concat(this.loadedName, "\";src:").concat(url, "}");
          }
          else {
              var css = "font-weight: ".concat(this.cssFontInfo.fontWeight, ";");
              if (this.cssFontInfo.italicAngle) {
                  css += "font-style: oblique ".concat(this.cssFontInfo.italicAngle, "deg;");
              }
              rule = "@font-face {font-family:\"".concat(this.cssFontInfo.fontFamily, "\";").concat(css, "src:").concat(url, "}");
          }
          (_g = this._inspectFont) === null || _g === void 0 ? void 0 : _g.call(this, this, url);
          return rule;
      };
      FontFaceObject.prototype.getPathGenerator = function (objs, character) {
          if (this.compiledGlyphs[character] !== undefined) {
              return this.compiledGlyphs[character];
          }
          var cmds;
          try {
              cmds = objs.get(this.loadedName + "_path_" + character);
          }
          catch (ex) {
              warn("getPathGenerator - ignoring character: \"".concat(ex, "\"."));
          }
          if (!Array.isArray(cmds) || cmds.length === 0) {
              return this.compiledGlyphs[character] = function (c, size) { };
          }
          var commands = [];
          var _loop_3 = function (i, ii) {
              switch (cmds[i++]) {
                  case FontRenderOps.BEZIER_CURVE_TO:
                      {
                          var _g = cmds.slice(i, i + 6), a_1 = _g[0], b_1 = _g[1], c_1 = _g[2], d_1 = _g[3], e_2 = _g[4], f_1 = _g[5];
                          commands.push(function (ctx) { return ctx.bezierCurveTo(a_1, b_1, c_1, d_1, e_2, f_1); });
                          i += 6;
                      }
                      break;
                  case FontRenderOps.MOVE_TO:
                      {
                          var _h = cmds.slice(i, i + 2), a_2 = _h[0], b_2 = _h[1];
                          commands.push(function (ctx) { return ctx.moveTo(a_2, b_2); });
                          i += 2;
                      }
                      break;
                  case FontRenderOps.LINE_TO:
                      {
                          var _j = cmds.slice(i, i + 2), a_3 = _j[0], b_3 = _j[1];
                          commands.push(function (ctx) { return ctx.lineTo(a_3, b_3); });
                          i += 2;
                      }
                      break;
                  case FontRenderOps.QUADRATIC_CURVE_TO:
                      {
                          var _k = cmds.slice(i, i + 4), a_4 = _k[0], b_4 = _k[1], c_2 = _k[2], d_2 = _k[3];
                          commands.push(function (ctx) { return ctx.quadraticCurveTo(a_4, b_4, c_2, d_2); });
                          i += 4;
                      }
                      break;
                  case FontRenderOps.RESTORE:
                      commands.push(function (ctx) { return ctx.restore(); });
                      break;
                  case FontRenderOps.SAVE:
                      commands.push(function (ctx) { return ctx.save(); });
                      break;
                  case FontRenderOps.SCALE:
                      assert(commands.length === 2, "Scale command is only valid at the third position.");
                      break;
                  case FontRenderOps.TRANSFORM:
                      {
                          var _l = cmds.slice(i, i + 6), a_5 = _l[0], b_5 = _l[1], c_3 = _l[2], d_3 = _l[3], e_3 = _l[4], f_2 = _l[5];
                          commands.push(function (ctx) { return ctx.transform(a_5, b_5, c_3, d_3, e_3, f_2); });
                          i += 6;
                      }
                      break;
                  case FontRenderOps.TRANSLATE:
                      {
                          var _m = cmds.slice(i, i + 2), a_6 = _m[0], b_6 = _m[1];
                          commands.push(function (ctx) { return ctx.translate(a_6, b_6); });
                          i += 2;
                      }
                      break;
              }
              out_i_1 = i;
          };
          var out_i_1;
          for (var i = 0, ii = cmds.length; i < ii;) {
              _loop_3(i, ii);
              i = out_i_1;
          }
          return this.compiledGlyphs[character] = function glyphDrawer(ctx, size) {
              commands[0](ctx);
              commands[1](ctx);
              ctx.scale(size, -size);
              for (var i = 2, ii = commands.length; i < ii; i++) {
                  commands[i](ctx);
              }
          };
      };
      return FontFaceObject;
  }());
  ; // CONCATENATED MODULE: ./src/display/node_utils.js
  if (isNodeJS) {
      var packageCapability = Promise.withResolvers();
      var packageMap = null;
      var loadPackages = function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
          var fs, http, https, url, canvas, path2d;
          return tslib_1.__generator(this, function (_g) {
              switch (_g.label) {
                  case 0: return [4 /*yield*/, Promise.resolve().then(function () { return tslib_1.__importStar(require(/*webpackIgnore: true*/ "fs")); })];
                  case 1:
                      fs = _g.sent();
                      return [4 /*yield*/, Promise.resolve().then(function () { return tslib_1.__importStar(require(/*webpackIgnore: true*/ "http")); })];
                  case 2:
                      http = _g.sent();
                      return [4 /*yield*/, Promise.resolve().then(function () { return tslib_1.__importStar(require(/*webpackIgnore: true*/ "https")); })];
                  case 3:
                      https = _g.sent();
                      return [4 /*yield*/, Promise.resolve().then(function () { return tslib_1.__importStar(require(/*webpackIgnore: true*/ "url")); })];
                  case 4:
                      url = _g.sent();
                      return [2 /*return*/, new Map(Object.entries({
                              fs: fs,
                              http: http,
                              https: https,
                              url: url,
                              canvas: canvas,
                              path2d: path2d
                          }))];
              }
          });
      }); };
      loadPackages().then(function (map) {
          packageMap = map;
          packageCapability.resolve();
      }, function (reason) {
          warn("loadPackages: ".concat(reason));
          packageMap = new Map();
          packageCapability.resolve();
      });
  }
  var NodePackages = /** @class */ (function () {
      function NodePackages() {
      }
      Object.defineProperty(NodePackages, "promise", {
          get: function () {
              return packageCapability.promise;
          },
          enumerable: false,
          configurable: true
      });
      NodePackages.get = function (name) {
          return packageMap === null || packageMap === void 0 ? void 0 : packageMap.get(name);
      };
      return NodePackages;
  }());
  var node_utils_fetchData = function (url) {
      var fs = NodePackages.get("fs");
      return fs.promises.readFile(url).then(function (data) { return new Uint8Array(data); });
  };
  var NodeFilterFactory = /** @class */ (function (_super) {
      tslib_1.__extends(NodeFilterFactory, _super);
      function NodeFilterFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      return NodeFilterFactory;
  }(BaseFilterFactory));
  var NodeCanvasFactory = /** @class */ (function (_super) {
      tslib_1.__extends(NodeCanvasFactory, _super);
      function NodeCanvasFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      NodeCanvasFactory.prototype._createCanvas = function (width, height) {
          var canvas = NodePackages.get("canvas");
          return canvas.createCanvas(width, height);
      };
      return NodeCanvasFactory;
  }(BaseCanvasFactory));
  var NodeCMapReaderFactory = /** @class */ (function (_super) {
      tslib_1.__extends(NodeCMapReaderFactory, _super);
      function NodeCMapReaderFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      NodeCMapReaderFactory.prototype._fetchData = function (url, compressionType) {
          return node_utils_fetchData(url).then(function (data) { return ({
              cMapData: data,
              compressionType: compressionType
          }); });
      };
      return NodeCMapReaderFactory;
  }(BaseCMapReaderFactory));
  var NodeStandardFontDataFactory = /** @class */ (function (_super) {
      tslib_1.__extends(NodeStandardFontDataFactory, _super);
      function NodeStandardFontDataFactory() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      NodeStandardFontDataFactory.prototype._fetchData = function (url) {
          return node_utils_fetchData(url);
      };
      return NodeStandardFontDataFactory;
  }(BaseStandardFontDataFactory));
  ; // CONCATENATED MODULE: ./src/display/pattern_helper.js
  var PathType = {
      FILL: "Fill",
      STROKE: "Stroke",
      SHADING: "Shading"
  };
  function applyBoundingBox(ctx, bbox) {
      if (!bbox) {
          return;
      }
      var width = bbox[2] - bbox[0];
      var height = bbox[3] - bbox[1];
      var region = new Path2D();
      region.rect(bbox[0], bbox[1], width, height);
      ctx.clip(region);
  }
  var BaseShadingPattern = /** @class */ (function () {
      function BaseShadingPattern() {
          if (this.constructor === BaseShadingPattern) {
              unreachable("Cannot initialize BaseShadingPattern.");
          }
      }
      BaseShadingPattern.prototype.getPattern = function () {
          unreachable("Abstract method `getPattern` called.");
      };
      return BaseShadingPattern;
  }());
  var RadialAxialShadingPattern = /** @class */ (function (_super) {
      tslib_1.__extends(RadialAxialShadingPattern, _super);
      function RadialAxialShadingPattern(IR) {
          var _this = _super.call(this) || this;
          _this._type = IR[1];
          _this._bbox = IR[2];
          _this._colorStops = IR[3];
          _this._p0 = IR[4];
          _this._p1 = IR[5];
          _this._r0 = IR[6];
          _this._r1 = IR[7];
          _this.matrix = null;
          return _this;
      }
      RadialAxialShadingPattern.prototype._createGradient = function (ctx) {
          var grad;
          if (this._type === "axial") {
              grad = ctx.createLinearGradient(this._p0[0], this._p0[1], this._p1[0], this._p1[1]);
          }
          else if (this._type === "radial") {
              grad = ctx.createRadialGradient(this._p0[0], this._p0[1], this._r0, this._p1[0], this._p1[1], this._r1);
          }
          for (var _i = 0, _g = this._colorStops; _i < _g.length; _i++) {
              var colorStop = _g[_i];
              grad.addColorStop(colorStop[0], colorStop[1]);
          }
          return grad;
      };
      RadialAxialShadingPattern.prototype.getPattern = function (ctx, owner, inverse, pathType) {
          var pattern;
          if (pathType === PathType.STROKE || pathType === PathType.FILL) {
              var ownerBBox = owner.current.getClippedPathBoundingBox(pathType, getCurrentTransform(ctx)) || [0, 0, 0, 0];
              var width = Math.ceil(ownerBBox[2] - ownerBBox[0]) || 1;
              var height = Math.ceil(ownerBBox[3] - ownerBBox[1]) || 1;
              var tmpCanvas = owner.cachedCanvases.getCanvas("pattern", width, height, true);
              var tmpCtx = tmpCanvas.context;
              tmpCtx.clearRect(0, 0, tmpCtx.canvas.width, tmpCtx.canvas.height);
              tmpCtx.beginPath();
              tmpCtx.rect(0, 0, tmpCtx.canvas.width, tmpCtx.canvas.height);
              tmpCtx.translate(-ownerBBox[0], -ownerBBox[1]);
              inverse = Util.transform(inverse, [1, 0, 0, 1, ownerBBox[0], ownerBBox[1]]);
              tmpCtx.transform.apply(tmpCtx, owner.baseTransform);
              if (this.matrix) {
                  tmpCtx.transform.apply(tmpCtx, this.matrix);
              }
              applyBoundingBox(tmpCtx, this._bbox);
              tmpCtx.fillStyle = this._createGradient(tmpCtx);
              tmpCtx.fill();
              pattern = ctx.createPattern(tmpCanvas.canvas, "no-repeat");
              var domMatrix = new DOMMatrix(inverse);
              pattern.setTransform(domMatrix);
          }
          else {
              applyBoundingBox(ctx, this._bbox);
              pattern = this._createGradient(ctx);
          }
          return pattern;
      };
      return RadialAxialShadingPattern;
  }(BaseShadingPattern));
  function drawTriangle(data, context, p1, p2, p3, c1, c2, c3) {
      var coords = context.coords, colors = context.colors;
      var bytes = data.data, rowSize = data.width * 4;
      var tmp;
      if (coords[p1 + 1] > coords[p2 + 1]) {
          tmp = p1;
          p1 = p2;
          p2 = tmp;
          tmp = c1;
          c1 = c2;
          c2 = tmp;
      }
      if (coords[p2 + 1] > coords[p3 + 1]) {
          tmp = p2;
          p2 = p3;
          p3 = tmp;
          tmp = c2;
          c2 = c3;
          c3 = tmp;
      }
      if (coords[p1 + 1] > coords[p2 + 1]) {
          tmp = p1;
          p1 = p2;
          p2 = tmp;
          tmp = c1;
          c1 = c2;
          c2 = tmp;
      }
      var x1 = (coords[p1] + context.offsetX) * context.scaleX;
      var y1 = (coords[p1 + 1] + context.offsetY) * context.scaleY;
      var x2 = (coords[p2] + context.offsetX) * context.scaleX;
      var y2 = (coords[p2 + 1] + context.offsetY) * context.scaleY;
      var x3 = (coords[p3] + context.offsetX) * context.scaleX;
      var y3 = (coords[p3 + 1] + context.offsetY) * context.scaleY;
      if (y1 >= y3) {
          return;
      }
      var c1r = colors[c1], c1g = colors[c1 + 1], c1b = colors[c1 + 2];
      var c2r = colors[c2], c2g = colors[c2 + 1], c2b = colors[c2 + 2];
      var c3r = colors[c3], c3g = colors[c3 + 1], c3b = colors[c3 + 2];
      var minY = Math.round(y1), maxY = Math.round(y3);
      var xa, car, cag, cab;
      var xb, cbr, cbg, cbb;
      for (var y = minY; y <= maxY; y++) {
          if (y < y2) {
              var k_1 = y < y1 ? 0 : (y1 - y) / (y1 - y2);
              xa = x1 - (x1 - x2) * k_1;
              car = c1r - (c1r - c2r) * k_1;
              cag = c1g - (c1g - c2g) * k_1;
              cab = c1b - (c1b - c2b) * k_1;
          }
          else {
              var k_2 = void 0;
              if (y > y3) {
                  k_2 = 1;
              }
              else if (y2 === y3) {
                  k_2 = 0;
              }
              else {
                  k_2 = (y2 - y) / (y2 - y3);
              }
              xa = x2 - (x2 - x3) * k_2;
              car = c2r - (c2r - c3r) * k_2;
              cag = c2g - (c2g - c3g) * k_2;
              cab = c2b - (c2b - c3b) * k_2;
          }
          var k = void 0;
          if (y < y1) {
              k = 0;
          }
          else if (y > y3) {
              k = 1;
          }
          else {
              k = (y1 - y) / (y1 - y3);
          }
          xb = x1 - (x1 - x3) * k;
          cbr = c1r - (c1r - c3r) * k;
          cbg = c1g - (c1g - c3g) * k;
          cbb = c1b - (c1b - c3b) * k;
          var x1_ = Math.round(Math.min(xa, xb));
          var x2_ = Math.round(Math.max(xa, xb));
          var j = rowSize * y + x1_ * 4;
          for (var x = x1_; x <= x2_; x++) {
              k = (xa - x) / (xa - xb);
              if (k < 0) {
                  k = 0;
              }
              else if (k > 1) {
                  k = 1;
              }
              bytes[j++] = car - (car - cbr) * k | 0;
              bytes[j++] = cag - (cag - cbg) * k | 0;
              bytes[j++] = cab - (cab - cbb) * k | 0;
              bytes[j++] = 255;
          }
      }
  }
  function drawFigure(data, figure, context) {
      var ps = figure.coords;
      var cs = figure.colors;
      var i, ii;
      switch (figure.type) {
          case "lattice":
              var verticesPerRow = figure.verticesPerRow;
              var rows = Math.floor(ps.length / verticesPerRow) - 1;
              var cols = verticesPerRow - 1;
              for (i = 0; i < rows; i++) {
                  var q = i * verticesPerRow;
                  for (var j = 0; j < cols; j++, q++) {
                      drawTriangle(data, context, ps[q], ps[q + 1], ps[q + verticesPerRow], cs[q], cs[q + 1], cs[q + verticesPerRow]);
                      drawTriangle(data, context, ps[q + verticesPerRow + 1], ps[q + 1], ps[q + verticesPerRow], cs[q + verticesPerRow + 1], cs[q + 1], cs[q + verticesPerRow]);
                  }
              }
              break;
          case "triangles":
              for (i = 0, ii = ps.length; i < ii; i += 3) {
                  drawTriangle(data, context, ps[i], ps[i + 1], ps[i + 2], cs[i], cs[i + 1], cs[i + 2]);
              }
              break;
          default:
              throw new Error("illegal figure");
      }
  }
  var MeshShadingPattern = /** @class */ (function (_super) {
      tslib_1.__extends(MeshShadingPattern, _super);
      function MeshShadingPattern(IR) {
          var _this = _super.call(this) || this;
          _this._coords = IR[2];
          _this._colors = IR[3];
          _this._figures = IR[4];
          _this._bounds = IR[5];
          _this._bbox = IR[7];
          _this._background = IR[8];
          _this.matrix = null;
          return _this;
      }
      MeshShadingPattern.prototype._createMeshCanvas = function (combinedScale, backgroundColor, cachedCanvases) {
          var EXPECTED_SCALE = 1.1;
          var MAX_PATTERN_SIZE = 3000;
          var BORDER_SIZE = 2;
          var offsetX = Math.floor(this._bounds[0]);
          var offsetY = Math.floor(this._bounds[1]);
          var boundsWidth = Math.ceil(this._bounds[2]) - offsetX;
          var boundsHeight = Math.ceil(this._bounds[3]) - offsetY;
          var width = Math.min(Math.ceil(Math.abs(boundsWidth * combinedScale[0] * EXPECTED_SCALE)), MAX_PATTERN_SIZE);
          var height = Math.min(Math.ceil(Math.abs(boundsHeight * combinedScale[1] * EXPECTED_SCALE)), MAX_PATTERN_SIZE);
          var scaleX = boundsWidth / width;
          var scaleY = boundsHeight / height;
          var context = {
              coords: this._coords,
              colors: this._colors,
              offsetX: -offsetX,
              offsetY: -offsetY,
              scaleX: 1 / scaleX,
              scaleY: 1 / scaleY
          };
          var paddedWidth = width + BORDER_SIZE * 2;
          var paddedHeight = height + BORDER_SIZE * 2;
          var tmpCanvas = cachedCanvases.getCanvas("mesh", paddedWidth, paddedHeight, false);
          var tmpCtx = tmpCanvas.context;
          var data = tmpCtx.createImageData(width, height);
          if (backgroundColor) {
              var bytes = data.data;
              for (var i = 0, ii = bytes.length; i < ii; i += 4) {
                  bytes[i] = backgroundColor[0];
                  bytes[i + 1] = backgroundColor[1];
                  bytes[i + 2] = backgroundColor[2];
                  bytes[i + 3] = 255;
              }
          }
          for (var _i = 0, _g = this._figures; _i < _g.length; _i++) {
              var figure = _g[_i];
              drawFigure(data, figure, context);
          }
          tmpCtx.putImageData(data, BORDER_SIZE, BORDER_SIZE);
          var canvas = tmpCanvas.canvas;
          return {
              canvas: canvas,
              offsetX: offsetX - BORDER_SIZE * scaleX,
              offsetY: offsetY - BORDER_SIZE * scaleY,
              scaleX: scaleX,
              scaleY: scaleY
          };
      };
      MeshShadingPattern.prototype.getPattern = function (ctx, owner, inverse, pathType) {
          applyBoundingBox(ctx, this._bbox);
          var scale;
          if (pathType === PathType.SHADING) {
              scale = Util.singularValueDecompose2dScale(getCurrentTransform(ctx));
          }
          else {
              scale = Util.singularValueDecompose2dScale(owner.baseTransform);
              if (this.matrix) {
                  var matrixScale = Util.singularValueDecompose2dScale(this.matrix);
                  scale = [scale[0] * matrixScale[0], scale[1] * matrixScale[1]];
              }
          }
          var temporaryPatternCanvas = this._createMeshCanvas(scale, pathType === PathType.SHADING ? null : this._background, owner.cachedCanvases);
          if (pathType !== PathType.SHADING) {
              ctx.setTransform.apply(ctx, owner.baseTransform);
              if (this.matrix) {
                  ctx.transform.apply(ctx, this.matrix);
              }
          }
          ctx.translate(temporaryPatternCanvas.offsetX, temporaryPatternCanvas.offsetY);
          ctx.scale(temporaryPatternCanvas.scaleX, temporaryPatternCanvas.scaleY);
          return ctx.createPattern(temporaryPatternCanvas.canvas, "no-repeat");
      };
      return MeshShadingPattern;
  }(BaseShadingPattern));
  var DummyShadingPattern = /** @class */ (function (_super) {
      tslib_1.__extends(DummyShadingPattern, _super);
      function DummyShadingPattern() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      DummyShadingPattern.prototype.getPattern = function () {
          return "hotpink";
      };
      return DummyShadingPattern;
  }(BaseShadingPattern));
  function getShadingPattern(IR) {
      switch (IR[0]) {
          case "RadialAxial":
              return new RadialAxialShadingPattern(IR);
          case "Mesh":
              return new MeshShadingPattern(IR);
          case "Dummy":
              return new DummyShadingPattern();
      }
      throw new Error("Unknown IR type: ".concat(IR[0]));
  }
  var PaintType = {
      COLORED: 1,
      UNCOLORED: 2
  };
  var TilingPattern = /** @class */ (function () {
      function TilingPattern(IR, color, ctx, canvasGraphicsFactory, baseTransform) {
          this.operatorList = IR[2];
          this.matrix = IR[3];
          this.bbox = IR[4];
          this.xstep = IR[5];
          this.ystep = IR[6];
          this.paintType = IR[7];
          this.tilingType = IR[8];
          this.color = color;
          this.ctx = ctx;
          this.canvasGraphicsFactory = canvasGraphicsFactory;
          this.baseTransform = baseTransform;
      }
      TilingPattern.prototype.createPatternCanvas = function (owner) {
          var operatorList = this.operatorList;
          var bbox = this.bbox;
          var xstep = this.xstep;
          var ystep = this.ystep;
          var paintType = this.paintType;
          var tilingType = this.tilingType;
          var color = this.color;
          var canvasGraphicsFactory = this.canvasGraphicsFactory;
          info("TilingType: " + tilingType);
          var x0 = bbox[0], y0 = bbox[1], x1 = bbox[2], y1 = bbox[3];
          var matrixScale = Util.singularValueDecompose2dScale(this.matrix);
          var curMatrixScale = Util.singularValueDecompose2dScale(this.baseTransform);
          var combinedScale = [matrixScale[0] * curMatrixScale[0], matrixScale[1] * curMatrixScale[1]];
          var dimx = this.getSizeAndScale(xstep, this.ctx.canvas.width, combinedScale[0]);
          var dimy = this.getSizeAndScale(ystep, this.ctx.canvas.height, combinedScale[1]);
          var tmpCanvas = owner.cachedCanvases.getCanvas("pattern", dimx.size, dimy.size, true);
          var tmpCtx = tmpCanvas.context;
          var graphics = canvasGraphicsFactory.createCanvasGraphics(tmpCtx);
          graphics.groupLevel = owner.groupLevel;
          this.setFillAndStrokeStyleToContext(graphics, paintType, color);
          var adjustedX0 = x0;
          var adjustedY0 = y0;
          var adjustedX1 = x1;
          var adjustedY1 = y1;
          if (x0 < 0) {
              adjustedX0 = 0;
              adjustedX1 += Math.abs(x0);
          }
          if (y0 < 0) {
              adjustedY0 = 0;
              adjustedY1 += Math.abs(y0);
          }
          tmpCtx.translate(-(dimx.scale * adjustedX0), -(dimy.scale * adjustedY0));
          graphics.transform(dimx.scale, 0, 0, dimy.scale, 0, 0);
          tmpCtx.save();
          this.clipBbox(graphics, adjustedX0, adjustedY0, adjustedX1, adjustedY1);
          graphics.baseTransform = getCurrentTransform(graphics.ctx);
          graphics.executeOperatorList(operatorList);
          graphics.endDrawing();
          return {
              canvas: tmpCanvas.canvas,
              scaleX: dimx.scale,
              scaleY: dimy.scale,
              offsetX: adjustedX0,
              offsetY: adjustedY0
          };
      };
      TilingPattern.prototype.getSizeAndScale = function (step, realOutputSize, scale) {
          step = Math.abs(step);
          var maxSize = Math.max(TilingPattern.MAX_PATTERN_SIZE, realOutputSize);
          var size = Math.ceil(step * scale);
          if (size >= maxSize) {
              size = maxSize;
          }
          else {
              scale = size / step;
          }
          return {
              scale: scale,
              size: size
          };
      };
      TilingPattern.prototype.clipBbox = function (graphics, x0, y0, x1, y1) {
          var bboxWidth = x1 - x0;
          var bboxHeight = y1 - y0;
          graphics.ctx.rect(x0, y0, bboxWidth, bboxHeight);
          graphics.current.updateRectMinMax(getCurrentTransform(graphics.ctx), [x0, y0, x1, y1]);
          graphics.clip();
          graphics.endPath();
      };
      TilingPattern.prototype.setFillAndStrokeStyleToContext = function (graphics, paintType, color) {
          var context = graphics.ctx, current = graphics.current;
          switch (paintType) {
              case PaintType.COLORED:
                  var ctx = this.ctx;
                  context.fillStyle = ctx.fillStyle;
                  context.strokeStyle = ctx.strokeStyle;
                  current.fillColor = ctx.fillStyle;
                  current.strokeColor = ctx.strokeStyle;
                  break;
              case PaintType.UNCOLORED:
                  var cssColor = Util.makeHexColor(color[0], color[1], color[2]);
                  context.fillStyle = cssColor;
                  context.strokeStyle = cssColor;
                  current.fillColor = cssColor;
                  current.strokeColor = cssColor;
                  break;
              default:
                  throw new FormatError("Unsupported paint type: ".concat(paintType));
          }
      };
      TilingPattern.prototype.getPattern = function (ctx, owner, inverse, pathType) {
          var matrix = inverse;
          if (pathType !== PathType.SHADING) {
              matrix = Util.transform(matrix, owner.baseTransform);
              if (this.matrix) {
                  matrix = Util.transform(matrix, this.matrix);
              }
          }
          var temporaryPatternCanvas = this.createPatternCanvas(owner);
          var domMatrix = new DOMMatrix(matrix);
          domMatrix = domMatrix.translate(temporaryPatternCanvas.offsetX, temporaryPatternCanvas.offsetY);
          domMatrix = domMatrix.scale(1 / temporaryPatternCanvas.scaleX, 1 / temporaryPatternCanvas.scaleY);
          var pattern = ctx.createPattern(temporaryPatternCanvas.canvas, "repeat");
          pattern.setTransform(domMatrix);
          return pattern;
      };
      TilingPattern.MAX_PATTERN_SIZE = 3000;
      return TilingPattern;
  }());
  ; // CONCATENATED MODULE: ./src/shared/image_utils.js
  function convertToRGBA(params) {
      switch (params.kind) {
          case ImageKind.GRAYSCALE_1BPP:
              return convertBlackAndWhiteToRGBA(params);
          case ImageKind.RGB_24BPP:
              return convertRGBToRGBA(params);
      }
      return null;
  }
  function convertBlackAndWhiteToRGBA(_g) {
      var src = _g.src, _h = _g.srcPos, srcPos = _h === void 0 ? 0 : _h, dest = _g.dest, width = _g.width, height = _g.height, _j = _g.nonBlackColor, nonBlackColor = _j === void 0 ? 0xffffffff : _j, _k = _g.inverseDecode, inverseDecode = _k === void 0 ? false : _k;
      var black = util_FeatureTest.isLittleEndian ? 0xff000000 : 0x000000ff;
      var _l = inverseDecode ? [nonBlackColor, black] : [black, nonBlackColor], zeroMapping = _l[0], oneMapping = _l[1];
      var widthInSource = width >> 3;
      var widthRemainder = width & 7;
      var srcLength = src.length;
      dest = new Uint32Array(dest.buffer);
      var destPos = 0;
      for (var i = 0; i < height; i++) {
          for (var max = srcPos + widthInSource; srcPos < max; srcPos++) {
              var elem_1 = srcPos < srcLength ? src[srcPos] : 255;
              dest[destPos++] = elem_1 & 128 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 64 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 32 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 16 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 8 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 4 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 2 ? oneMapping : zeroMapping;
              dest[destPos++] = elem_1 & 1 ? oneMapping : zeroMapping;
          }
          if (widthRemainder === 0) {
              continue;
          }
          var elem = srcPos < srcLength ? src[srcPos++] : 255;
          for (var j = 0; j < widthRemainder; j++) {
              dest[destPos++] = elem & 1 << 7 - j ? oneMapping : zeroMapping;
          }
      }
      return {
          srcPos: srcPos,
          destPos: destPos
      };
  }
  function convertRGBToRGBA(_g) {
      var src = _g.src, _h = _g.srcPos, srcPos = _h === void 0 ? 0 : _h, dest = _g.dest, _j = _g.destPos, destPos = _j === void 0 ? 0 : _j, width = _g.width, height = _g.height;
      var i = 0;
      var len32 = src.length >> 2;
      var src32 = new Uint32Array(src.buffer, srcPos, len32);
      if (FeatureTest.isLittleEndian) {
          for (; i < len32 - 2; i += 3, destPos += 4) {
              var s1 = src32[i];
              var s2 = src32[i + 1];
              var s3 = src32[i + 2];
              dest[destPos] = s1 | 0xff000000;
              dest[destPos + 1] = s1 >>> 24 | s2 << 8 | 0xff000000;
              dest[destPos + 2] = s2 >>> 16 | s3 << 16 | 0xff000000;
              dest[destPos + 3] = s3 >>> 8 | 0xff000000;
          }
          for (var j = i * 4, jj = src.length; j < jj; j += 3) {
              dest[destPos++] = src[j] | src[j + 1] << 8 | src[j + 2] << 16 | 0xff000000;
          }
      }
      else {
          for (; i < len32 - 2; i += 3, destPos += 4) {
              var s1 = src32[i];
              var s2 = src32[i + 1];
              var s3 = src32[i + 2];
              dest[destPos] = s1 | 0xff;
              dest[destPos + 1] = s1 << 24 | s2 >>> 8 | 0xff;
              dest[destPos + 2] = s2 << 16 | s3 >>> 16 | 0xff;
              dest[destPos + 3] = s3 << 8 | 0xff;
          }
          for (var j = i * 4, jj = src.length; j < jj; j += 3) {
              dest[destPos++] = src[j] << 24 | src[j + 1] << 16 | src[j + 2] << 8 | 0xff;
          }
      }
      return {
          srcPos: srcPos,
          destPos: destPos
      };
  }
  function grayToRGBA(src, dest) {
      if (FeatureTest.isLittleEndian) {
          for (var i = 0, ii = src.length; i < ii; i++) {
              dest[i] = src[i] * 0x10101 | 0xff000000;
          }
      }
      else {
          for (var i = 0, ii = src.length; i < ii; i++) {
              dest[i] = src[i] * 0x1010100 | 0x000000ff;
          }
      }
  }
  ; // CONCATENATED MODULE: ./src/display/canvas.js
  var MIN_FONT_SIZE = 16;
  var MAX_FONT_SIZE = 100;
  var EXECUTION_TIME = 15;
  var EXECUTION_STEPS = 10;
  var MAX_SIZE_TO_COMPILE = 1000;
  var FULL_CHUNK_HEIGHT = 16;
  function mirrorContextOperations(ctx, destCtx) {
      if (ctx._removeMirroring) {
          throw new Error("Context is already forwarding operations.");
      }
      ctx.__originalSave = ctx.save;
      ctx.__originalRestore = ctx.restore;
      ctx.__originalRotate = ctx.rotate;
      ctx.__originalScale = ctx.scale;
      ctx.__originalTranslate = ctx.translate;
      ctx.__originalTransform = ctx.transform;
      ctx.__originalSetTransform = ctx.setTransform;
      ctx.__originalResetTransform = ctx.resetTransform;
      ctx.__originalClip = ctx.clip;
      ctx.__originalMoveTo = ctx.moveTo;
      ctx.__originalLineTo = ctx.lineTo;
      ctx.__originalBezierCurveTo = ctx.bezierCurveTo;
      ctx.__originalRect = ctx.rect;
      ctx.__originalClosePath = ctx.closePath;
      ctx.__originalBeginPath = ctx.beginPath;
      ctx._removeMirroring = function () {
          ctx.save = ctx.__originalSave;
          ctx.restore = ctx.__originalRestore;
          ctx.rotate = ctx.__originalRotate;
          ctx.scale = ctx.__originalScale;
          ctx.translate = ctx.__originalTranslate;
          ctx.transform = ctx.__originalTransform;
          ctx.setTransform = ctx.__originalSetTransform;
          ctx.resetTransform = ctx.__originalResetTransform;
          ctx.clip = ctx.__originalClip;
          ctx.moveTo = ctx.__originalMoveTo;
          ctx.lineTo = ctx.__originalLineTo;
          ctx.bezierCurveTo = ctx.__originalBezierCurveTo;
          ctx.rect = ctx.__originalRect;
          ctx.closePath = ctx.__originalClosePath;
          ctx.beginPath = ctx.__originalBeginPath;
          delete ctx._removeMirroring;
      };
      ctx.save = function ctxSave() {
          destCtx.save();
          this.__originalSave();
      };
      ctx.restore = function ctxRestore() {
          destCtx.restore();
          this.__originalRestore();
      };
      ctx.translate = function ctxTranslate(x, y) {
          destCtx.translate(x, y);
          this.__originalTranslate(x, y);
      };
      ctx.scale = function ctxScale(x, y) {
          destCtx.scale(x, y);
          this.__originalScale(x, y);
      };
      ctx.transform = function ctxTransform(a, b, c, d, e, f) {
          destCtx.transform(a, b, c, d, e, f);
          this.__originalTransform(a, b, c, d, e, f);
      };
      ctx.setTransform = function ctxSetTransform(a, b, c, d, e, f) {
          destCtx.setTransform(a, b, c, d, e, f);
          this.__originalSetTransform(a, b, c, d, e, f);
      };
      ctx.resetTransform = function ctxResetTransform() {
          destCtx.resetTransform();
          this.__originalResetTransform();
      };
      ctx.rotate = function ctxRotate(angle) {
          destCtx.rotate(angle);
          this.__originalRotate(angle);
      };
      ctx.clip = function ctxRotate(rule) {
          destCtx.clip(rule);
          this.__originalClip(rule);
      };
      ctx.moveTo = function (x, y) {
          destCtx.moveTo(x, y);
          this.__originalMoveTo(x, y);
      };
      ctx.lineTo = function (x, y) {
          destCtx.lineTo(x, y);
          this.__originalLineTo(x, y);
      };
      ctx.bezierCurveTo = function (cp1x, cp1y, cp2x, cp2y, x, y) {
          destCtx.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
          this.__originalBezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
      };
      ctx.rect = function (x, y, width, height) {
          destCtx.rect(x, y, width, height);
          this.__originalRect(x, y, width, height);
      };
      ctx.closePath = function () {
          destCtx.closePath();
          this.__originalClosePath();
      };
      ctx.beginPath = function () {
          destCtx.beginPath();
          this.__originalBeginPath();
      };
  }
  var CachedCanvases = /** @class */ (function () {
      function CachedCanvases(canvasFactory) {
          this.canvasFactory = canvasFactory;
          this.cache = Object.create(null);
      }
      CachedCanvases.prototype.getCanvas = function (id, width, height) {
          var canvasEntry;
          if (this.cache[id] !== undefined) {
              canvasEntry = this.cache[id];
              this.canvasFactory.reset(canvasEntry, width, height);
          }
          else {
              canvasEntry = this.canvasFactory.create(width, height);
              this.cache[id] = canvasEntry;
          }
          return canvasEntry;
      };
      CachedCanvases.prototype.delete = function (id) {
          delete this.cache[id];
      };
      CachedCanvases.prototype.clear = function () {
          for (var id in this.cache) {
              var canvasEntry = this.cache[id];
              this.canvasFactory.destroy(canvasEntry);
              delete this.cache[id];
          }
      };
      return CachedCanvases;
  }());
  function drawImageAtIntegerCoords(ctx, srcImg, srcX, srcY, srcW, srcH, destX, destY, destW, destH) {
      var _g = getCurrentTransform(ctx), a = _g[0], b = _g[1], c = _g[2], d = _g[3], tx = _g[4], ty = _g[5];
      if (b === 0 && c === 0) {
          var tlX = destX * a + tx;
          var rTlX = Math.round(tlX);
          var tlY = destY * d + ty;
          var rTlY = Math.round(tlY);
          var brX = (destX + destW) * a + tx;
          var rWidth = Math.abs(Math.round(brX) - rTlX) || 1;
          var brY = (destY + destH) * d + ty;
          var rHeight = Math.abs(Math.round(brY) - rTlY) || 1;
          ctx.setTransform(Math.sign(a), 0, 0, Math.sign(d), rTlX, rTlY);
          ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, 0, 0, rWidth, rHeight);
          ctx.setTransform(a, b, c, d, tx, ty);
          return [rWidth, rHeight];
      }
      if (a === 0 && d === 0) {
          var tlX = destY * c + tx;
          var rTlX = Math.round(tlX);
          var tlY = destX * b + ty;
          var rTlY = Math.round(tlY);
          var brX = (destY + destH) * c + tx;
          var rWidth = Math.abs(Math.round(brX) - rTlX) || 1;
          var brY = (destX + destW) * b + ty;
          var rHeight = Math.abs(Math.round(brY) - rTlY) || 1;
          ctx.setTransform(0, Math.sign(b), Math.sign(c), 0, rTlX, rTlY);
          ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, 0, 0, rHeight, rWidth);
          ctx.setTransform(a, b, c, d, tx, ty);
          return [rHeight, rWidth];
      }
      ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, destX, destY, destW, destH);
      var scaleX = Math.hypot(a, b);
      var scaleY = Math.hypot(c, d);
      return [scaleX * destW, scaleY * destH];
  }
  function compileType3Glyph(imgData) {
      var width = imgData.width, height = imgData.height;
      if (width > MAX_SIZE_TO_COMPILE || height > MAX_SIZE_TO_COMPILE) {
          return null;
      }
      var POINT_TO_PROCESS_LIMIT = 1000;
      var POINT_TYPES = new Uint8Array([0, 2, 4, 0, 1, 0, 5, 4, 8, 10, 0, 8, 0, 2, 1, 0]);
      var width1 = width + 1;
      var points = new Uint8Array(width1 * (height + 1));
      var i, j, j0;
      var lineSize = width + 7 & ~7;
      var data = new Uint8Array(lineSize * height), pos = 0;
      for (var _i = 0, _g = imgData.data; _i < _g.length; _i++) {
          var elem = _g[_i];
          var mask = 128;
          while (mask > 0) {
              data[pos++] = elem & mask ? 0 : 255;
              mask >>= 1;
          }
      }
      var count = 0;
      pos = 0;
      if (data[pos] !== 0) {
          points[0] = 1;
          ++count;
      }
      for (j = 1; j < width; j++) {
          if (data[pos] !== data[pos + 1]) {
              points[j] = data[pos] ? 2 : 1;
              ++count;
          }
          pos++;
      }
      if (data[pos] !== 0) {
          points[j] = 2;
          ++count;
      }
      for (i = 1; i < height; i++) {
          pos = i * lineSize;
          j0 = i * width1;
          if (data[pos - lineSize] !== data[pos]) {
              points[j0] = data[pos] ? 1 : 8;
              ++count;
          }
          var sum = (data[pos] ? 4 : 0) + (data[pos - lineSize] ? 8 : 0);
          for (j = 1; j < width; j++) {
              sum = (sum >> 2) + (data[pos + 1] ? 4 : 0) + (data[pos - lineSize + 1] ? 8 : 0);
              if (POINT_TYPES[sum]) {
                  points[j0 + j] = POINT_TYPES[sum];
                  ++count;
              }
              pos++;
          }
          if (data[pos - lineSize] !== data[pos]) {
              points[j0 + j] = data[pos] ? 2 : 4;
              ++count;
          }
          if (count > POINT_TO_PROCESS_LIMIT) {
              return null;
          }
      }
      pos = lineSize * (height - 1);
      j0 = i * width1;
      if (data[pos] !== 0) {
          points[j0] = 8;
          ++count;
      }
      for (j = 1; j < width; j++) {
          if (data[pos] !== data[pos + 1]) {
              points[j0 + j] = data[pos] ? 4 : 8;
              ++count;
          }
          pos++;
      }
      if (data[pos] !== 0) {
          points[j0 + j] = 4;
          ++count;
      }
      if (count > POINT_TO_PROCESS_LIMIT) {
          return null;
      }
      var steps = new Int32Array([0, width1, -1, 0, -width1, 0, 0, 0, 1]);
      var path = new Path2D();
      for (i = 0; count && i <= height; i++) {
          var p = i * width1;
          var end = p + width;
          while (p < end && !points[p]) {
              p++;
          }
          if (p === end) {
              continue;
          }
          path.moveTo(p % width1, i);
          var p0 = p;
          var type = points[p];
          do {
              var step = steps[type];
              do {
                  p += step;
              } while (!points[p]);
              var pp = points[p];
              if (pp !== 5 && pp !== 10) {
                  type = pp;
                  points[p] = 0;
              }
              else {
                  type = pp & 0x33 * type >> 4;
                  points[p] &= type >> 2 | type << 2;
              }
              path.lineTo(p % width1, p / width1 | 0);
              if (!points[p]) {
                  --count;
              }
          } while (p0 !== p);
          --i;
      }
      data = null;
      points = null;
      var drawOutline = function (c) {
          c.save();
          c.scale(1 / width, -1 / height);
          c.translate(0, -height);
          c.fill(path);
          c.beginPath();
          c.restore();
      };
      return drawOutline;
  }
  var CanvasExtraState = /** @class */ (function () {
      function CanvasExtraState(width, height) {
          this.alphaIsShape = false;
          this.fontSize = 0;
          this.fontSizeScale = 1;
          this.textMatrix = IDENTITY_MATRIX;
          this.textMatrixScale = 1;
          this.fontMatrix = FONT_IDENTITY_MATRIX;
          this.leading = 0;
          this.x = 0;
          this.y = 0;
          this.lineX = 0;
          this.lineY = 0;
          this.charSpacing = 0;
          this.wordSpacing = 0;
          this.textHScale = 1;
          this.textRenderingMode = TextRenderingMode.FILL;
          this.textRise = 0;
          this.fillColor = "#000000";
          this.strokeColor = "#000000";
          this.patternFill = false;
          this.fillAlpha = 1;
          this.strokeAlpha = 1;
          this.lineWidth = 1;
          this.activeSMask = null;
          this.transferMaps = "none";
          this.startNewPathAndClipBox([0, 0, width, height]);
      }
      CanvasExtraState.prototype.clone = function () {
          var clone = Object.create(this);
          clone.clipBox = this.clipBox.slice();
          return clone;
      };
      CanvasExtraState.prototype.setCurrentPoint = function (x, y) {
          this.x = x;
          this.y = y;
      };
      CanvasExtraState.prototype.updatePathMinMax = function (transform, x, y) {
          var _g;
          _g = Util.applyTransform([x, y], transform), x = _g[0], y = _g[1];
          this.minX = Math.min(this.minX, x);
          this.minY = Math.min(this.minY, y);
          this.maxX = Math.max(this.maxX, x);
          this.maxY = Math.max(this.maxY, y);
      };
      CanvasExtraState.prototype.updateRectMinMax = function (transform, rect) {
          var p1 = Util.applyTransform(rect, transform);
          var p2 = Util.applyTransform(rect.slice(2), transform);
          var p3 = Util.applyTransform([rect[0], rect[3]], transform);
          var p4 = Util.applyTransform([rect[2], rect[1]], transform);
          this.minX = Math.min(this.minX, p1[0], p2[0], p3[0], p4[0]);
          this.minY = Math.min(this.minY, p1[1], p2[1], p3[1], p4[1]);
          this.maxX = Math.max(this.maxX, p1[0], p2[0], p3[0], p4[0]);
          this.maxY = Math.max(this.maxY, p1[1], p2[1], p3[1], p4[1]);
      };
      CanvasExtraState.prototype.updateScalingPathMinMax = function (transform, minMax) {
          Util.scaleMinMax(transform, minMax);
          this.minX = Math.min(this.minX, minMax[0]);
          this.minY = Math.min(this.minY, minMax[1]);
          this.maxX = Math.max(this.maxX, minMax[2]);
          this.maxY = Math.max(this.maxY, minMax[3]);
      };
      CanvasExtraState.prototype.updateCurvePathMinMax = function (transform, x0, y0, x1, y1, x2, y2, x3, y3, minMax) {
          var box = Util.bezierBoundingBox(x0, y0, x1, y1, x2, y2, x3, y3, minMax);
          if (minMax) {
              return;
          }
          this.updateRectMinMax(transform, box);
      };
      CanvasExtraState.prototype.getPathBoundingBox = function (pathType, transform) {
          if (pathType === void 0) { pathType = PathType.FILL; }
          if (transform === void 0) { transform = null; }
          var box = [this.minX, this.minY, this.maxX, this.maxY];
          if (pathType === PathType.STROKE) {
              if (!transform) {
                  unreachable("Stroke bounding box must include transform.");
              }
              var scale = Util.singularValueDecompose2dScale(transform);
              var xStrokePad = scale[0] * this.lineWidth / 2;
              var yStrokePad = scale[1] * this.lineWidth / 2;
              box[0] -= xStrokePad;
              box[1] -= yStrokePad;
              box[2] += xStrokePad;
              box[3] += yStrokePad;
          }
          return box;
      };
      CanvasExtraState.prototype.updateClipFromPath = function () {
          var intersect = Util.intersect(this.clipBox, this.getPathBoundingBox());
          this.startNewPathAndClipBox(intersect || [0, 0, 0, 0]);
      };
      CanvasExtraState.prototype.isEmptyClip = function () {
          return this.minX === Infinity;
      };
      CanvasExtraState.prototype.startNewPathAndClipBox = function (box) {
          this.clipBox = box;
          this.minX = Infinity;
          this.minY = Infinity;
          this.maxX = 0;
          this.maxY = 0;
      };
      CanvasExtraState.prototype.getClippedPathBoundingBox = function (pathType, transform) {
          if (pathType === void 0) { pathType = PathType.FILL; }
          if (transform === void 0) { transform = null; }
          return Util.intersect(this.clipBox, this.getPathBoundingBox(pathType, transform));
      };
      return CanvasExtraState;
  }());
  function putBinaryImageData(ctx, imgData) {
      if (typeof ImageData !== "undefined" && imgData instanceof ImageData) {
          ctx.putImageData(imgData, 0, 0);
          return;
      }
      var height = imgData.height, width = imgData.width;
      var partialChunkHeight = height % FULL_CHUNK_HEIGHT;
      var fullChunks = (height - partialChunkHeight) / FULL_CHUNK_HEIGHT;
      var totalChunks = partialChunkHeight === 0 ? fullChunks : fullChunks + 1;
      var chunkImgData = ctx.createImageData(width, FULL_CHUNK_HEIGHT);
      var srcPos = 0, destPos;
      var src = imgData.data;
      var dest = chunkImgData.data;
      var i, j, thisChunkHeight, elemsInThisChunk;
      if (imgData.kind === util_ImageKind.GRAYSCALE_1BPP) {
          var srcLength = src.byteLength;
          var dest32 = new Uint32Array(dest.buffer, 0, dest.byteLength >> 2);
          var dest32DataLength = dest32.length;
          var fullSrcDiff = width + 7 >> 3;
          var white = 0xffffffff;
          var black = util_FeatureTest.isLittleEndian ? 0xff000000 : 0x000000ff;
          for (i = 0; i < totalChunks; i++) {
              thisChunkHeight = i < fullChunks ? FULL_CHUNK_HEIGHT : partialChunkHeight;
              destPos = 0;
              for (j = 0; j < thisChunkHeight; j++) {
                  var srcDiff = srcLength - srcPos;
                  var k = 0;
                  var kEnd = srcDiff > fullSrcDiff ? width : srcDiff * 8 - 7;
                  var kEndUnrolled = kEnd & ~7;
                  var mask = 0;
                  var srcByte = 0;
                  for (; k < kEndUnrolled; k += 8) {
                      srcByte = src[srcPos++];
                      dest32[destPos++] = srcByte & 128 ? white : black;
                      dest32[destPos++] = srcByte & 64 ? white : black;
                      dest32[destPos++] = srcByte & 32 ? white : black;
                      dest32[destPos++] = srcByte & 16 ? white : black;
                      dest32[destPos++] = srcByte & 8 ? white : black;
                      dest32[destPos++] = srcByte & 4 ? white : black;
                      dest32[destPos++] = srcByte & 2 ? white : black;
                      dest32[destPos++] = srcByte & 1 ? white : black;
                  }
                  for (; k < kEnd; k++) {
                      if (mask === 0) {
                          srcByte = src[srcPos++];
                          mask = 128;
                      }
                      dest32[destPos++] = srcByte & mask ? white : black;
                      mask >>= 1;
                  }
              }
              while (destPos < dest32DataLength) {
                  dest32[destPos++] = 0;
              }
              ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
          }
      }
      else if (imgData.kind === util_ImageKind.RGBA_32BPP) {
          j = 0;
          elemsInThisChunk = width * FULL_CHUNK_HEIGHT * 4;
          for (i = 0; i < fullChunks; i++) {
              dest.set(src.subarray(srcPos, srcPos + elemsInThisChunk));
              srcPos += elemsInThisChunk;
              ctx.putImageData(chunkImgData, 0, j);
              j += FULL_CHUNK_HEIGHT;
          }
          if (i < totalChunks) {
              elemsInThisChunk = width * partialChunkHeight * 4;
              dest.set(src.subarray(srcPos, srcPos + elemsInThisChunk));
              ctx.putImageData(chunkImgData, 0, j);
          }
      }
      else if (imgData.kind === util_ImageKind.RGB_24BPP) {
          thisChunkHeight = FULL_CHUNK_HEIGHT;
          elemsInThisChunk = width * thisChunkHeight;
          for (i = 0; i < totalChunks; i++) {
              if (i >= fullChunks) {
                  thisChunkHeight = partialChunkHeight;
                  elemsInThisChunk = width * thisChunkHeight;
              }
              destPos = 0;
              for (j = elemsInThisChunk; j--;) {
                  dest[destPos++] = src[srcPos++];
                  dest[destPos++] = src[srcPos++];
                  dest[destPos++] = src[srcPos++];
                  dest[destPos++] = 255;
              }
              ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
          }
      }
      else {
          throw new Error("bad image kind: ".concat(imgData.kind));
      }
  }
  function putBinaryImageMask(ctx, imgData) {
      if (imgData.bitmap) {
          ctx.drawImage(imgData.bitmap, 0, 0);
          return;
      }
      var height = imgData.height, width = imgData.width;
      var partialChunkHeight = height % FULL_CHUNK_HEIGHT;
      var fullChunks = (height - partialChunkHeight) / FULL_CHUNK_HEIGHT;
      var totalChunks = partialChunkHeight === 0 ? fullChunks : fullChunks + 1;
      var chunkImgData = ctx.createImageData(width, FULL_CHUNK_HEIGHT);
      var srcPos = 0;
      var src = imgData.data;
      var dest = chunkImgData.data;
      for (var i = 0; i < totalChunks; i++) {
          var thisChunkHeight = i < fullChunks ? FULL_CHUNK_HEIGHT : partialChunkHeight;
          (srcPos = convertBlackAndWhiteToRGBA({
              src: src,
              srcPos: srcPos,
              dest: dest,
              width: width,
              height: thisChunkHeight,
              nonBlackColor: 0
          }).srcPos);
          ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
      }
  }
  function copyCtxState(sourceCtx, destCtx) {
      var properties = ["strokeStyle", "fillStyle", "fillRule", "globalAlpha", "lineWidth", "lineCap", "lineJoin", "miterLimit", "globalCompositeOperation", "font", "filter"];
      for (var _i = 0, properties_1 = properties; _i < properties_1.length; _i++) {
          var property = properties_1[_i];
          if (sourceCtx[property] !== undefined) {
              destCtx[property] = sourceCtx[property];
          }
      }
      if (sourceCtx.setLineDash !== undefined) {
          destCtx.setLineDash(sourceCtx.getLineDash());
          destCtx.lineDashOffset = sourceCtx.lineDashOffset;
      }
  }
  function resetCtxToDefault(ctx) {
      ctx.strokeStyle = ctx.fillStyle = "#000000";
      ctx.fillRule = "nonzero";
      ctx.globalAlpha = 1;
      ctx.lineWidth = 1;
      ctx.lineCap = "butt";
      ctx.lineJoin = "miter";
      ctx.miterLimit = 10;
      ctx.globalCompositeOperation = "source-over";
      ctx.font = "10px sans-serif";
      if (ctx.setLineDash !== undefined) {
          ctx.setLineDash([]);
          ctx.lineDashOffset = 0;
      }
      if (!isNodeJS) {
          var filter = ctx.filter;
          if (filter !== "none" && filter !== "") {
              ctx.filter = "none";
          }
      }
  }
  function getImageSmoothingEnabled(transform, interpolate) {
      if (interpolate) {
          return true;
      }
      var scale = Util.singularValueDecompose2dScale(transform);
      scale[0] = Math.fround(scale[0]);
      scale[1] = Math.fround(scale[1]);
      var actualScale = Math.fround((globalThis.devicePixelRatio || 1) * PixelsPerInch.PDF_TO_CSS_UNITS);
      return scale[0] <= actualScale && scale[1] <= actualScale;
  }
  var LINE_CAP_STYLES = ["butt", "round", "square"];
  var LINE_JOIN_STYLES = ["miter", "round", "bevel"];
  var NORMAL_CLIP = {};
  var EO_CLIP = {};
  var CanvasGraphics = /** @class */ (function () {
      function CanvasGraphics(canvasCtx, commonObjs, objs, canvasFactory, filterFactory, _g, annotationCanvasMap, pageColors) {
          var optionalContentConfig = _g.optionalContentConfig, _h = _g.markedContentStack, markedContentStack = _h === void 0 ? null : _h;
          _CanvasGraphics_instances.add(this);
          this.ctx = canvasCtx;
          this.current = new CanvasExtraState(this.ctx.canvas.width, this.ctx.canvas.height);
          this.stateStack = [];
          this.pendingClip = null;
          this.pendingEOFill = false;
          this.res = null;
          this.xobjs = null;
          this.commonObjs = commonObjs;
          this.objs = objs;
          this.canvasFactory = canvasFactory;
          this.filterFactory = filterFactory;
          this.groupStack = [];
          this.processingType3 = null;
          this.baseTransform = null;
          this.baseTransformStack = [];
          this.groupLevel = 0;
          this.smaskStack = [];
          this.smaskCounter = 0;
          this.tempSMask = null;
          this.suspendedCtx = null;
          this.contentVisible = true;
          this.markedContentStack = markedContentStack || [];
          this.optionalContentConfig = optionalContentConfig;
          this.cachedCanvases = new CachedCanvases(this.canvasFactory);
          this.cachedPatterns = new Map();
          this.annotationCanvasMap = annotationCanvasMap;
          this.viewportScale = 1;
          this.outputScaleX = 1;
          this.outputScaleY = 1;
          this.pageColors = pageColors;
          this._cachedScaleForStroking = [-1, 0];
          this._cachedGetSinglePixelWidth = null;
          this._cachedBitmapsMap = new Map();
      }
      CanvasGraphics.prototype.getObject = function (data, fallback) {
          if (fallback === void 0) { fallback = null; }
          if (typeof data === "string") {
              return data.startsWith("g_") ? this.commonObjs.get(data) : this.objs.get(data);
          }
          return fallback;
      };
      CanvasGraphics.prototype.beginDrawing = function (_g) {
          var _h, _j, _k;
          var transform = _g.transform, viewport = _g.viewport, _l = _g.transparency, transparency = _l === void 0 ? false : _l, _m = _g.background, background = _m === void 0 ? null : _m;
          var width = this.ctx.canvas.width;
          var height = this.ctx.canvas.height;
          var savedFillStyle = this.ctx.fillStyle;
          this.ctx.fillStyle = background || "#ffffff";
          this.ctx.fillRect(0, 0, width, height);
          this.ctx.fillStyle = savedFillStyle;
          if (transparency) {
              var transparentCanvas = this.cachedCanvases.getCanvas("transparent", width, height);
              this.compositeCtx = this.ctx;
              this.transparentCanvas = transparentCanvas.canvas;
              this.ctx = transparentCanvas.context;
              this.ctx.save();
              (_h = this.ctx).transform.apply(_h, getCurrentTransform(this.compositeCtx));
          }
          this.ctx.save();
          resetCtxToDefault(this.ctx);
          if (transform) {
              (_j = this.ctx).transform.apply(_j, transform);
              this.outputScaleX = transform[0];
              this.outputScaleY = transform[0];
          }
          (_k = this.ctx).transform.apply(_k, viewport.transform);
          this.viewportScale = viewport.scale;
          this.baseTransform = getCurrentTransform(this.ctx);
      };
      CanvasGraphics.prototype.executeOperatorList = function (operatorList, executionStartIdx, continueCallback, stepper) {
          var argsArray = operatorList.argsArray;
          var fnArray = operatorList.fnArray;
          var i = executionStartIdx || 0;
          var argsArrayLen = argsArray.length;
          if (argsArrayLen === i) {
              return i;
          }
          var chunkOperations = argsArrayLen - i > EXECUTION_STEPS && typeof continueCallback === "function";
          var endTime = chunkOperations ? Date.now() + EXECUTION_TIME : 0;
          var steps = 0;
          var commonObjs = this.commonObjs;
          var objs = this.objs;
          var fnId;
          while (true) {
              if (stepper !== undefined && i === stepper.nextBreakPoint) {
                  stepper.breakIt(i, continueCallback);
                  return i;
              }
              fnId = fnArray[i];
              if (fnId !== OPS.dependency) {
                  this[fnId].apply(this, argsArray[i]);
              }
              else {
                  for (var _i = 0, _g = argsArray[i]; _i < _g.length; _i++) {
                      var depObjId = _g[_i];
                      var objsPool = depObjId.startsWith("g_") ? commonObjs : objs;
                      if (!objsPool.has(depObjId)) {
                          objsPool.get(depObjId, continueCallback);
                          return i;
                      }
                  }
              }
              i++;
              if (i === argsArrayLen) {
                  return i;
              }
              if (chunkOperations && ++steps > EXECUTION_STEPS) {
                  if (Date.now() > endTime) {
                      continueCallback();
                      return i;
                  }
                  steps = 0;
              }
          }
      };
      CanvasGraphics.prototype.endDrawing = function () {
          tslib_1.__classPrivateFieldGet(this, _CanvasGraphics_instances, "m", _CanvasGraphics_restoreInitialState).call(this);
          this.cachedCanvases.clear();
          this.cachedPatterns.clear();
          for (var _i = 0, _g = this._cachedBitmapsMap.values(); _i < _g.length; _i++) {
              var cache = _g[_i];
              for (var _h = 0, _j = cache.values(); _h < _j.length; _h++) {
                  var canvas = _j[_h];
                  if (typeof HTMLCanvasElement !== "undefined" && canvas instanceof HTMLCanvasElement) {
                      canvas.width = canvas.height = 0;
                  }
              }
              cache.clear();
          }
          this._cachedBitmapsMap.clear();
          tslib_1.__classPrivateFieldGet(this, _CanvasGraphics_instances, "m", _CanvasGraphics_drawFilter).call(this);
      };
      CanvasGraphics.prototype._scaleImage = function (img, inverseTransform) {
          var width = img.width;
          var height = img.height;
          var widthScale = Math.max(Math.hypot(inverseTransform[0], inverseTransform[1]), 1);
          var heightScale = Math.max(Math.hypot(inverseTransform[2], inverseTransform[3]), 1);
          var paintWidth = width, paintHeight = height;
          var tmpCanvasId = "prescale1";
          var tmpCanvas, tmpCtx;
          while (widthScale > 2 && paintWidth > 1 || heightScale > 2 && paintHeight > 1) {
              var newWidth = paintWidth, newHeight = paintHeight;
              if (widthScale > 2 && paintWidth > 1) {
                  newWidth = paintWidth >= 16384 ? Math.floor(paintWidth / 2) - 1 || 1 : Math.ceil(paintWidth / 2);
                  widthScale /= paintWidth / newWidth;
              }
              if (heightScale > 2 && paintHeight > 1) {
                  newHeight = paintHeight >= 16384 ? Math.floor(paintHeight / 2) - 1 || 1 : Math.ceil(paintHeight) / 2;
                  heightScale /= paintHeight / newHeight;
              }
              tmpCanvas = this.cachedCanvases.getCanvas(tmpCanvasId, newWidth, newHeight);
              tmpCtx = tmpCanvas.context;
              tmpCtx.clearRect(0, 0, newWidth, newHeight);
              tmpCtx.drawImage(img, 0, 0, paintWidth, paintHeight, 0, 0, newWidth, newHeight);
              img = tmpCanvas.canvas;
              paintWidth = newWidth;
              paintHeight = newHeight;
              tmpCanvasId = tmpCanvasId === "prescale1" ? "prescale2" : "prescale1";
          }
          return {
              img: img,
              paintWidth: paintWidth,
              paintHeight: paintHeight
          };
      };
      CanvasGraphics.prototype._createMaskCanvas = function (img) {
          var ctx = this.ctx;
          var width = img.width, height = img.height;
          var fillColor = this.current.fillColor;
          var isPatternFill = this.current.patternFill;
          var currentTransform = getCurrentTransform(ctx);
          var cache, cacheKey, scaled, maskCanvas;
          if ((img.bitmap || img.data) && img.count > 1) {
              var mainKey = img.bitmap || img.data.buffer;
              cacheKey = JSON.stringify(isPatternFill ? currentTransform : [currentTransform.slice(0, 4), fillColor]);
              cache = this._cachedBitmapsMap.get(mainKey);
              if (!cache) {
                  cache = new Map();
                  this._cachedBitmapsMap.set(mainKey, cache);
              }
              var cachedImage = cache.get(cacheKey);
              if (cachedImage && !isPatternFill) {
                  var offsetX_1 = Math.round(Math.min(currentTransform[0], currentTransform[2]) + currentTransform[4]);
                  var offsetY_1 = Math.round(Math.min(currentTransform[1], currentTransform[3]) + currentTransform[5]);
                  return {
                      canvas: cachedImage,
                      offsetX: offsetX_1,
                      offsetY: offsetY_1
                  };
              }
              scaled = cachedImage;
          }
          if (!scaled) {
              maskCanvas = this.cachedCanvases.getCanvas("maskCanvas", width, height);
              putBinaryImageMask(maskCanvas.context, img);
          }
          var maskToCanvas = Util.transform(currentTransform, [1 / width, 0, 0, -1 / height, 0, 0]);
          maskToCanvas = Util.transform(maskToCanvas, [1, 0, 0, 1, 0, -height]);
          var _g = Util.getAxialAlignedBoundingBox([0, 0, width, height], maskToCanvas), minX = _g[0], minY = _g[1], maxX = _g[2], maxY = _g[3];
          var drawnWidth = Math.round(maxX - minX) || 1;
          var drawnHeight = Math.round(maxY - minY) || 1;
          var fillCanvas = this.cachedCanvases.getCanvas("fillCanvas", drawnWidth, drawnHeight);
          var fillCtx = fillCanvas.context;
          var offsetX = minX;
          var offsetY = minY;
          fillCtx.translate(-offsetX, -offsetY);
          fillCtx.transform.apply(fillCtx, maskToCanvas);
          if (!scaled) {
              scaled = this._scaleImage(maskCanvas.canvas, getCurrentTransformInverse(fillCtx));
              scaled = scaled.img;
              if (cache && isPatternFill) {
                  cache.set(cacheKey, scaled);
              }
          }
          fillCtx.imageSmoothingEnabled = getImageSmoothingEnabled(getCurrentTransform(fillCtx), img.interpolate);
          drawImageAtIntegerCoords(fillCtx, scaled, 0, 0, scaled.width, scaled.height, 0, 0, width, height);
          fillCtx.globalCompositeOperation = "source-in";
          var inverse = Util.transform(getCurrentTransformInverse(fillCtx), [1, 0, 0, 1, -offsetX, -offsetY]);
          fillCtx.fillStyle = isPatternFill ? fillColor.getPattern(ctx, this, inverse, PathType.FILL) : fillColor;
          fillCtx.fillRect(0, 0, width, height);
          if (cache && !isPatternFill) {
              this.cachedCanvases.delete("fillCanvas");
              cache.set(cacheKey, fillCanvas.canvas);
          }
          return {
              canvas: fillCanvas.canvas,
              offsetX: Math.round(offsetX),
              offsetY: Math.round(offsetY)
          };
      };
      CanvasGraphics.prototype.setLineWidth = function (width) {
          if (width !== this.current.lineWidth) {
              this._cachedScaleForStroking[0] = -1;
          }
          this.current.lineWidth = width;
          this.ctx.lineWidth = width;
      };
      CanvasGraphics.prototype.setLineCap = function (style) {
          this.ctx.lineCap = LINE_CAP_STYLES[style];
      };
      CanvasGraphics.prototype.setLineJoin = function (style) {
          this.ctx.lineJoin = LINE_JOIN_STYLES[style];
      };
      CanvasGraphics.prototype.setMiterLimit = function (limit) {
          this.ctx.miterLimit = limit;
      };
      CanvasGraphics.prototype.setDash = function (dashArray, dashPhase) {
          var ctx = this.ctx;
          if (ctx.setLineDash !== undefined) {
              ctx.setLineDash(dashArray);
              ctx.lineDashOffset = dashPhase;
          }
      };
      CanvasGraphics.prototype.setRenderingIntent = function (intent) { };
      CanvasGraphics.prototype.setFlatness = function (flatness) { };
      CanvasGraphics.prototype.setGState = function (states) {
          for (var _i = 0, states_1 = states; _i < states_1.length; _i++) {
              var _g = states_1[_i], key = _g[0], value = _g[1];
              switch (key) {
                  case "LW":
                      this.setLineWidth(value);
                      break;
                  case "LC":
                      this.setLineCap(value);
                      break;
                  case "LJ":
                      this.setLineJoin(value);
                      break;
                  case "ML":
                      this.setMiterLimit(value);
                      break;
                  case "D":
                      this.setDash(value[0], value[1]);
                      break;
                  case "RI":
                      this.setRenderingIntent(value);
                      break;
                  case "FL":
                      this.setFlatness(value);
                      break;
                  case "Font":
                      this.setFont(value[0], value[1]);
                      break;
                  case "CA":
                      this.current.strokeAlpha = value;
                      break;
                  case "ca":
                      this.current.fillAlpha = value;
                      this.ctx.globalAlpha = value;
                      break;
                  case "BM":
                      this.ctx.globalCompositeOperation = value;
                      break;
                  case "SMask":
                      this.current.activeSMask = value ? this.tempSMask : null;
                      this.tempSMask = null;
                      this.checkSMaskState();
                      break;
                  case "TR":
                      this.ctx.filter = this.current.transferMaps = this.filterFactory.addFilter(value);
                      break;
              }
          }
      };
      Object.defineProperty(CanvasGraphics.prototype, "inSMaskMode", {
          get: function () {
              return !!this.suspendedCtx;
          },
          enumerable: false,
          configurable: true
      });
      CanvasGraphics.prototype.checkSMaskState = function () {
          var inSMaskMode = this.inSMaskMode;
          if (this.current.activeSMask && !inSMaskMode) {
              this.beginSMaskMode();
          }
          else if (!this.current.activeSMask && inSMaskMode) {
              this.endSMaskMode();
          }
      };
      CanvasGraphics.prototype.beginSMaskMode = function () {
          if (this.inSMaskMode) {
              throw new Error("beginSMaskMode called while already in smask mode");
          }
          var drawnWidth = this.ctx.canvas.width;
          var drawnHeight = this.ctx.canvas.height;
          var cacheId = "smaskGroupAt" + this.groupLevel;
          var scratchCanvas = this.cachedCanvases.getCanvas(cacheId, drawnWidth, drawnHeight);
          this.suspendedCtx = this.ctx;
          this.ctx = scratchCanvas.context;
          var ctx = this.ctx;
          ctx.setTransform.apply(ctx, getCurrentTransform(this.suspendedCtx));
          copyCtxState(this.suspendedCtx, ctx);
          mirrorContextOperations(ctx, this.suspendedCtx);
          this.setGState([["BM", "source-over"], ["ca", 1], ["CA", 1]]);
      };
      CanvasGraphics.prototype.endSMaskMode = function () {
          if (!this.inSMaskMode) {
              throw new Error("endSMaskMode called while not in smask mode");
          }
          this.ctx._removeMirroring();
          copyCtxState(this.ctx, this.suspendedCtx);
          this.ctx = this.suspendedCtx;
          this.suspendedCtx = null;
      };
      CanvasGraphics.prototype.compose = function (dirtyBox) {
          if (!this.current.activeSMask) {
              return;
          }
          if (!dirtyBox) {
              dirtyBox = [0, 0, this.ctx.canvas.width, this.ctx.canvas.height];
          }
          else {
              dirtyBox[0] = Math.floor(dirtyBox[0]);
              dirtyBox[1] = Math.floor(dirtyBox[1]);
              dirtyBox[2] = Math.ceil(dirtyBox[2]);
              dirtyBox[3] = Math.ceil(dirtyBox[3]);
          }
          var smask = this.current.activeSMask;
          var suspendedCtx = this.suspendedCtx;
          this.composeSMask(suspendedCtx, smask, this.ctx, dirtyBox);
          this.ctx.save();
          this.ctx.setTransform(1, 0, 0, 1, 0, 0);
          this.ctx.clearRect(0, 0, this.ctx.canvas.width, this.ctx.canvas.height);
          this.ctx.restore();
      };
      CanvasGraphics.prototype.composeSMask = function (ctx, smask, layerCtx, layerBox) {
          var layerOffsetX = layerBox[0];
          var layerOffsetY = layerBox[1];
          var layerWidth = layerBox[2] - layerOffsetX;
          var layerHeight = layerBox[3] - layerOffsetY;
          if (layerWidth === 0 || layerHeight === 0) {
              return;
          }
          this.genericComposeSMask(smask.context, layerCtx, layerWidth, layerHeight, smask.subtype, smask.backdrop, smask.transferMap, layerOffsetX, layerOffsetY, smask.offsetX, smask.offsetY);
          ctx.save();
          ctx.globalAlpha = 1;
          ctx.globalCompositeOperation = "source-over";
          ctx.setTransform(1, 0, 0, 1, 0, 0);
          ctx.drawImage(layerCtx.canvas, 0, 0);
          ctx.restore();
      };
      CanvasGraphics.prototype.genericComposeSMask = function (maskCtx, layerCtx, width, height, subtype, backdrop, transferMap, layerOffsetX, layerOffsetY, maskOffsetX, maskOffsetY) {
          var maskCanvas = maskCtx.canvas;
          var maskX = layerOffsetX - maskOffsetX;
          var maskY = layerOffsetY - maskOffsetY;
          if (backdrop) {
              if (maskX < 0 || maskY < 0 || maskX + width > maskCanvas.width || maskY + height > maskCanvas.height) {
                  var canvas = this.cachedCanvases.getCanvas("maskExtension", width, height);
                  var ctx = canvas.context;
                  ctx.drawImage(maskCanvas, -maskX, -maskY);
                  if (backdrop.some(function (c) { return c !== 0; })) {
                      ctx.globalCompositeOperation = "destination-atop";
                      ctx.fillStyle = Util.makeHexColor.apply(Util, backdrop);
                      ctx.fillRect(0, 0, width, height);
                      ctx.globalCompositeOperation = "source-over";
                  }
                  maskCanvas = canvas.canvas;
                  maskX = maskY = 0;
              }
              else if (backdrop.some(function (c) { return c !== 0; })) {
                  maskCtx.save();
                  maskCtx.globalAlpha = 1;
                  maskCtx.setTransform(1, 0, 0, 1, 0, 0);
                  var clip_1 = new Path2D();
                  clip_1.rect(maskX, maskY, width, height);
                  maskCtx.clip(clip_1);
                  maskCtx.globalCompositeOperation = "destination-atop";
                  maskCtx.fillStyle = Util.makeHexColor.apply(Util, backdrop);
                  maskCtx.fillRect(maskX, maskY, width, height);
                  maskCtx.restore();
              }
          }
          layerCtx.save();
          layerCtx.globalAlpha = 1;
          layerCtx.setTransform(1, 0, 0, 1, 0, 0);
          if (subtype === "Alpha" && transferMap) {
              layerCtx.filter = this.filterFactory.addAlphaFilter(transferMap);
          }
          else if (subtype === "Luminosity") {
              layerCtx.filter = this.filterFactory.addLuminosityFilter(transferMap);
          }
          var clip = new Path2D();
          clip.rect(layerOffsetX, layerOffsetY, width, height);
          layerCtx.clip(clip);
          layerCtx.globalCompositeOperation = "destination-in";
          layerCtx.drawImage(maskCanvas, maskX, maskY, width, height, layerOffsetX, layerOffsetY, width, height);
          layerCtx.restore();
      };
      CanvasGraphics.prototype.save = function () {
          if (this.inSMaskMode) {
              copyCtxState(this.ctx, this.suspendedCtx);
              this.suspendedCtx.save();
          }
          else {
              this.ctx.save();
          }
          var old = this.current;
          this.stateStack.push(old);
          this.current = old.clone();
      };
      CanvasGraphics.prototype.restore = function () {
          if (this.stateStack.length === 0 && this.inSMaskMode) {
              this.endSMaskMode();
          }
          if (this.stateStack.length !== 0) {
              this.current = this.stateStack.pop();
              if (this.inSMaskMode) {
                  this.suspendedCtx.restore();
                  copyCtxState(this.suspendedCtx, this.ctx);
              }
              else {
                  this.ctx.restore();
              }
              this.checkSMaskState();
              this.pendingClip = null;
              this._cachedScaleForStroking[0] = -1;
              this._cachedGetSinglePixelWidth = null;
          }
      };
      CanvasGraphics.prototype.transform = function (a, b, c, d, e, f) {
          this.ctx.transform(a, b, c, d, e, f);
          this._cachedScaleForStroking[0] = -1;
          this._cachedGetSinglePixelWidth = null;
      };
      CanvasGraphics.prototype.constructPath = function (ops, args, minMax) {
          var ctx = this.ctx;
          var current = this.current;
          var x = current.x, y = current.y;
          var startX, startY;
          var currentTransform = getCurrentTransform(ctx);
          var isScalingMatrix = currentTransform[0] === 0 && currentTransform[3] === 0 || currentTransform[1] === 0 && currentTransform[2] === 0;
          var minMaxForBezier = isScalingMatrix ? minMax.slice(0) : null;
          for (var i = 0, j = 0, ii = ops.length; i < ii; i++) {
              switch (ops[i] | 0) {
                  case OPS.rectangle:
                      x = args[j++];
                      y = args[j++];
                      var width = args[j++];
                      var height = args[j++];
                      var xw = x + width;
                      var yh = y + height;
                      ctx.moveTo(x, y);
                      if (width === 0 || height === 0) {
                          ctx.lineTo(xw, yh);
                      }
                      else {
                          ctx.lineTo(xw, y);
                          ctx.lineTo(xw, yh);
                          ctx.lineTo(x, yh);
                      }
                      if (!isScalingMatrix) {
                          current.updateRectMinMax(currentTransform, [x, y, xw, yh]);
                      }
                      ctx.closePath();
                      break;
                  case OPS.moveTo:
                      x = args[j++];
                      y = args[j++];
                      ctx.moveTo(x, y);
                      if (!isScalingMatrix) {
                          current.updatePathMinMax(currentTransform, x, y);
                      }
                      break;
                  case OPS.lineTo:
                      x = args[j++];
                      y = args[j++];
                      ctx.lineTo(x, y);
                      if (!isScalingMatrix) {
                          current.updatePathMinMax(currentTransform, x, y);
                      }
                      break;
                  case OPS.curveTo:
                      startX = x;
                      startY = y;
                      x = args[j + 4];
                      y = args[j + 5];
                      ctx.bezierCurveTo(args[j], args[j + 1], args[j + 2], args[j + 3], x, y);
                      current.updateCurvePathMinMax(currentTransform, startX, startY, args[j], args[j + 1], args[j + 2], args[j + 3], x, y, minMaxForBezier);
                      j += 6;
                      break;
                  case OPS.curveTo2:
                      startX = x;
                      startY = y;
                      ctx.bezierCurveTo(x, y, args[j], args[j + 1], args[j + 2], args[j + 3]);
                      current.updateCurvePathMinMax(currentTransform, startX, startY, x, y, args[j], args[j + 1], args[j + 2], args[j + 3], minMaxForBezier);
                      x = args[j + 2];
                      y = args[j + 3];
                      j += 4;
                      break;
                  case OPS.curveTo3:
                      startX = x;
                      startY = y;
                      x = args[j + 2];
                      y = args[j + 3];
                      ctx.bezierCurveTo(args[j], args[j + 1], x, y, x, y);
                      current.updateCurvePathMinMax(currentTransform, startX, startY, args[j], args[j + 1], x, y, x, y, minMaxForBezier);
                      j += 4;
                      break;
                  case OPS.closePath:
                      ctx.closePath();
                      break;
              }
          }
          if (isScalingMatrix) {
              current.updateScalingPathMinMax(currentTransform, minMaxForBezier);
          }
          current.setCurrentPoint(x, y);
      };
      CanvasGraphics.prototype.closePath = function () {
          this.ctx.closePath();
      };
      CanvasGraphics.prototype.stroke = function (consumePath) {
          if (consumePath === void 0) { consumePath = true; }
          var ctx = this.ctx;
          var strokeColor = this.current.strokeColor;
          ctx.globalAlpha = this.current.strokeAlpha;
          if (this.contentVisible) {
              if (typeof strokeColor === "object" && (strokeColor === null || strokeColor === void 0 ? void 0 : strokeColor.getPattern)) {
                  ctx.save();
                  ctx.strokeStyle = strokeColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.STROKE);
                  this.rescaleAndStroke(false);
                  ctx.restore();
              }
              else {
                  this.rescaleAndStroke(true);
              }
          }
          if (consumePath) {
              this.consumePath(this.current.getClippedPathBoundingBox());
          }
          ctx.globalAlpha = this.current.fillAlpha;
      };
      CanvasGraphics.prototype.closeStroke = function () {
          this.closePath();
          this.stroke();
      };
      CanvasGraphics.prototype.fill = function (consumePath) {
          if (consumePath === void 0) { consumePath = true; }
          var ctx = this.ctx;
          var fillColor = this.current.fillColor;
          var isPatternFill = this.current.patternFill;
          var needRestore = false;
          if (isPatternFill) {
              ctx.save();
              ctx.fillStyle = fillColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.FILL);
              needRestore = true;
          }
          var intersect = this.current.getClippedPathBoundingBox();
          if (this.contentVisible && intersect !== null) {
              if (this.pendingEOFill) {
                  ctx.fill("evenodd");
                  this.pendingEOFill = false;
              }
              else {
                  ctx.fill();
              }
          }
          if (needRestore) {
              ctx.restore();
          }
          if (consumePath) {
              this.consumePath(intersect);
          }
      };
      CanvasGraphics.prototype.eoFill = function () {
          this.pendingEOFill = true;
          this.fill();
      };
      CanvasGraphics.prototype.fillStroke = function () {
          this.fill(false);
          this.stroke(false);
          this.consumePath();
      };
      CanvasGraphics.prototype.eoFillStroke = function () {
          this.pendingEOFill = true;
          this.fillStroke();
      };
      CanvasGraphics.prototype.closeFillStroke = function () {
          this.closePath();
          this.fillStroke();
      };
      CanvasGraphics.prototype.closeEOFillStroke = function () {
          this.pendingEOFill = true;
          this.closePath();
          this.fillStroke();
      };
      CanvasGraphics.prototype.endPath = function () {
          this.consumePath();
      };
      CanvasGraphics.prototype.clip = function () {
          this.pendingClip = NORMAL_CLIP;
      };
      CanvasGraphics.prototype.eoClip = function () {
          this.pendingClip = EO_CLIP;
      };
      CanvasGraphics.prototype.beginText = function () {
          this.current.textMatrix = IDENTITY_MATRIX;
          this.current.textMatrixScale = 1;
          this.current.x = this.current.lineX = 0;
          this.current.y = this.current.lineY = 0;
      };
      CanvasGraphics.prototype.endText = function () {
          var paths = this.pendingTextPaths;
          var ctx = this.ctx;
          if (paths === undefined) {
              ctx.beginPath();
              return;
          }
          ctx.save();
          ctx.beginPath();
          for (var _i = 0, paths_1 = paths; _i < paths_1.length; _i++) {
              var path = paths_1[_i];
              ctx.setTransform.apply(ctx, path.transform);
              ctx.translate(path.x, path.y);
              path.addToPath(ctx, path.fontSize);
          }
          ctx.restore();
          ctx.clip();
          ctx.beginPath();
          delete this.pendingTextPaths;
      };
      CanvasGraphics.prototype.setCharSpacing = function (spacing) {
          this.current.charSpacing = spacing;
      };
      CanvasGraphics.prototype.setWordSpacing = function (spacing) {
          this.current.wordSpacing = spacing;
      };
      CanvasGraphics.prototype.setHScale = function (scale) {
          this.current.textHScale = scale / 100;
      };
      CanvasGraphics.prototype.setLeading = function (leading) {
          this.current.leading = -leading;
      };
      CanvasGraphics.prototype.setFont = function (fontRefName, size) {
          var _g;
          var fontObj = this.commonObjs.get(fontRefName);
          var current = this.current;
          if (!fontObj) {
              throw new Error("Can't find font for ".concat(fontRefName));
          }
          current.fontMatrix = fontObj.fontMatrix || FONT_IDENTITY_MATRIX;
          if (current.fontMatrix[0] === 0 || current.fontMatrix[3] === 0) {
              warn("Invalid font matrix for font " + fontRefName);
          }
          if (size < 0) {
              size = -size;
              current.fontDirection = -1;
          }
          else {
              current.fontDirection = 1;
          }
          this.current.font = fontObj;
          this.current.fontSize = size;
          if (fontObj.isType3Font) {
              return;
          }
          var name = fontObj.loadedName || "sans-serif";
          var typeface = ((_g = fontObj.systemFontInfo) === null || _g === void 0 ? void 0 : _g.css) || "\"".concat(name, "\", ").concat(fontObj.fallbackName);
          var bold = "normal";
          if (fontObj.black) {
              bold = "900";
          }
          else if (fontObj.bold) {
              bold = "bold";
          }
          var italic = fontObj.italic ? "italic" : "normal";
          var browserFontSize = size;
          if (size < MIN_FONT_SIZE) {
              browserFontSize = MIN_FONT_SIZE;
          }
          else if (size > MAX_FONT_SIZE) {
              browserFontSize = MAX_FONT_SIZE;
          }
          this.current.fontSizeScale = size / browserFontSize;
          this.ctx.font = "".concat(italic, " ").concat(bold, " ").concat(browserFontSize, "px ").concat(typeface);
      };
      CanvasGraphics.prototype.setTextRenderingMode = function (mode) {
          this.current.textRenderingMode = mode;
      };
      CanvasGraphics.prototype.setTextRise = function (rise) {
          this.current.textRise = rise;
      };
      CanvasGraphics.prototype.moveText = function (x, y) {
          this.current.x = this.current.lineX += x;
          this.current.y = this.current.lineY += y;
      };
      CanvasGraphics.prototype.setLeadingMoveText = function (x, y) {
          this.setLeading(-y);
          this.moveText(x, y);
      };
      CanvasGraphics.prototype.setTextMatrix = function (a, b, c, d, e, f) {
          this.current.textMatrix = [a, b, c, d, e, f];
          this.current.textMatrixScale = Math.hypot(a, b);
          this.current.x = this.current.lineX = 0;
          this.current.y = this.current.lineY = 0;
      };
      CanvasGraphics.prototype.nextLine = function () {
          this.moveText(0, this.current.leading);
      };
      CanvasGraphics.prototype.paintChar = function (character, x, y, patternTransform) {
          var ctx = this.ctx;
          var current = this.current;
          var font = current.font;
          var textRenderingMode = current.textRenderingMode;
          var fontSize = current.fontSize / current.fontSizeScale;
          var fillStrokeMode = textRenderingMode & TextRenderingMode.FILL_STROKE_MASK;
          var isAddToPathSet = !!(textRenderingMode & TextRenderingMode.ADD_TO_PATH_FLAG);
          var patternFill = current.patternFill && !font.missingFile;
          var addToPath;
          if (font.disableFontFace || isAddToPathSet || patternFill) {
              addToPath = font.getPathGenerator(this.commonObjs, character);
          }
          if (font.disableFontFace || patternFill) {
              ctx.save();
              ctx.translate(x, y);
              ctx.beginPath();
              addToPath(ctx, fontSize);
              if (patternTransform) {
                  ctx.setTransform.apply(ctx, patternTransform);
              }
              if (fillStrokeMode === TextRenderingMode.FILL || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
                  ctx.fill();
              }
              if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
                  ctx.stroke();
              }
              ctx.restore();
          }
          else {
              if (fillStrokeMode === TextRenderingMode.FILL || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
                  ctx.fillText(character, x, y);
              }
              if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
                  ctx.strokeText(character, x, y);
              }
          }
          if (isAddToPathSet) {
              var paths = this.pendingTextPaths || (this.pendingTextPaths = []);
              paths.push({
                  transform: getCurrentTransform(ctx),
                  x: x,
                  y: y,
                  fontSize: fontSize,
                  addToPath: addToPath
              });
          }
      };
      Object.defineProperty(CanvasGraphics.prototype, "isFontSubpixelAAEnabled", {
          get: function () {
              var ctx = this.cachedCanvases.getCanvas("isFontSubpixelAAEnabled", 10, 10).context;
              ctx.scale(1.5, 1);
              ctx.fillText("I", 0, 10);
              var data = ctx.getImageData(0, 0, 10, 10).data;
              var enabled = false;
              for (var i = 3; i < data.length; i += 4) {
                  if (data[i] > 0 && data[i] < 255) {
                      enabled = true;
                      break;
                  }
              }
              return shadow(this, "isFontSubpixelAAEnabled", enabled);
          },
          enumerable: false,
          configurable: true
      });
      CanvasGraphics.prototype.showText = function (glyphs) {
          var current = this.current;
          var font = current.font;
          if (font.isType3Font) {
              return this.showType3Text(glyphs);
          }
          var fontSize = current.fontSize;
          if (fontSize === 0) {
              return undefined;
          }
          var ctx = this.ctx;
          var fontSizeScale = current.fontSizeScale;
          var charSpacing = current.charSpacing;
          var wordSpacing = current.wordSpacing;
          var fontDirection = current.fontDirection;
          var textHScale = current.textHScale * fontDirection;
          var glyphsLength = glyphs.length;
          var vertical = font.vertical;
          var spacingDir = vertical ? 1 : -1;
          var defaultVMetrics = font.defaultVMetrics;
          var widthAdvanceScale = fontSize * current.fontMatrix[0];
          var simpleFillText = current.textRenderingMode === TextRenderingMode.FILL && !font.disableFontFace && !current.patternFill;
          ctx.save();
          ctx.transform.apply(ctx, current.textMatrix);
          ctx.translate(current.x, current.y + current.textRise);
          if (fontDirection > 0) {
              ctx.scale(textHScale, -1);
          }
          else {
              ctx.scale(textHScale, 1);
          }
          var patternTransform;
          if (current.patternFill) {
              ctx.save();
              var pattern = current.fillColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.FILL);
              patternTransform = getCurrentTransform(ctx);
              ctx.restore();
              ctx.fillStyle = pattern;
          }
          var lineWidth = current.lineWidth;
          var scale = current.textMatrixScale;
          if (scale === 0 || lineWidth === 0) {
              var fillStrokeMode = current.textRenderingMode & TextRenderingMode.FILL_STROKE_MASK;
              if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
                  lineWidth = this.getSinglePixelWidth();
              }
          }
          else {
              lineWidth /= scale;
          }
          if (fontSizeScale !== 1.0) {
              ctx.scale(fontSizeScale, fontSizeScale);
              lineWidth /= fontSizeScale;
          }
          ctx.lineWidth = lineWidth;
          if (font.isInvalidPDFjsFont) {
              var chars = [];
              var width = 0;
              for (var _i = 0, glyphs_1 = glyphs; _i < glyphs_1.length; _i++) {
                  var glyph = glyphs_1[_i];
                  chars.push(glyph.unicode);
                  width += glyph.width;
              }
              ctx.fillText(chars.join(""), 0, 0);
              current.x += width * widthAdvanceScale * textHScale;
              ctx.restore();
              this.compose();
              return undefined;
          }
          var x = 0, i;
          for (i = 0; i < glyphsLength; ++i) {
              var glyph = glyphs[i];
              if (typeof glyph === "number") {
                  x += spacingDir * glyph * fontSize / 1000;
                  continue;
              }
              var restoreNeeded = false;
              var spacing = (glyph.isSpace ? wordSpacing : 0) + charSpacing;
              var character = glyph.fontChar;
              var accent = glyph.accent;
              var scaledX = void 0, scaledY = void 0;
              var width = glyph.width;
              if (vertical) {
                  var vmetric = glyph.vmetric || defaultVMetrics;
                  var vx = -(glyph.vmetric ? vmetric[1] : width * 0.5) * widthAdvanceScale;
                  var vy = vmetric[2] * widthAdvanceScale;
                  width = vmetric ? -vmetric[0] : width;
                  scaledX = vx / fontSizeScale;
                  scaledY = (x + vy) / fontSizeScale;
              }
              else {
                  scaledX = x / fontSizeScale;
                  scaledY = 0;
              }
              if (font.remeasure && width > 0) {
                  var measuredWidth = ctx.measureText(character).width * 1000 / fontSize * fontSizeScale;
                  if (width < measuredWidth && this.isFontSubpixelAAEnabled) {
                      var characterScaleX = width / measuredWidth;
                      restoreNeeded = true;
                      ctx.save();
                      ctx.scale(characterScaleX, 1);
                      scaledX /= characterScaleX;
                  }
                  else if (width !== measuredWidth) {
                      scaledX += (width - measuredWidth) / 2000 * fontSize / fontSizeScale;
                  }
              }
              if (this.contentVisible && (glyph.isInFont || font.missingFile)) {
                  if (simpleFillText && !accent) {
                      ctx.fillText(character, scaledX, scaledY);
                  }
                  else {
                      this.paintChar(character, scaledX, scaledY, patternTransform);
                      if (accent) {
                          var scaledAccentX = scaledX + fontSize * accent.offset.x / fontSizeScale;
                          var scaledAccentY = scaledY - fontSize * accent.offset.y / fontSizeScale;
                          this.paintChar(accent.fontChar, scaledAccentX, scaledAccentY, patternTransform);
                      }
                  }
              }
              var charWidth = vertical ? width * widthAdvanceScale - spacing * fontDirection : width * widthAdvanceScale + spacing * fontDirection;
              x += charWidth;
              if (restoreNeeded) {
                  ctx.restore();
              }
          }
          if (vertical) {
              current.y -= x;
          }
          else {
              current.x += x * textHScale;
          }
          ctx.restore();
          this.compose();
          return undefined;
      };
      CanvasGraphics.prototype.showType3Text = function (glyphs) {
          var ctx = this.ctx;
          var current = this.current;
          var font = current.font;
          var fontSize = current.fontSize;
          var fontDirection = current.fontDirection;
          var spacingDir = font.vertical ? 1 : -1;
          var charSpacing = current.charSpacing;
          var wordSpacing = current.wordSpacing;
          var textHScale = current.textHScale * fontDirection;
          var fontMatrix = current.fontMatrix || FONT_IDENTITY_MATRIX;
          var glyphsLength = glyphs.length;
          var isTextInvisible = current.textRenderingMode === TextRenderingMode.INVISIBLE;
          var i, glyph, width, spacingLength;
          if (isTextInvisible || fontSize === 0) {
              return;
          }
          this._cachedScaleForStroking[0] = -1;
          this._cachedGetSinglePixelWidth = null;
          ctx.save();
          ctx.transform.apply(ctx, current.textMatrix);
          ctx.translate(current.x, current.y);
          ctx.scale(textHScale, fontDirection);
          for (i = 0; i < glyphsLength; ++i) {
              glyph = glyphs[i];
              if (typeof glyph === "number") {
                  spacingLength = spacingDir * glyph * fontSize / 1000;
                  this.ctx.translate(spacingLength, 0);
                  current.x += spacingLength * textHScale;
                  continue;
              }
              var spacing = (glyph.isSpace ? wordSpacing : 0) + charSpacing;
              var operatorList = font.charProcOperatorList[glyph.operatorListId];
              if (!operatorList) {
                  warn("Type3 character \"".concat(glyph.operatorListId, "\" is not available."));
                  continue;
              }
              if (this.contentVisible) {
                  this.processingType3 = glyph;
                  this.save();
                  ctx.scale(fontSize, fontSize);
                  ctx.transform.apply(ctx, fontMatrix);
                  this.executeOperatorList(operatorList);
                  this.restore();
              }
              var transformed = Util.applyTransform([glyph.width, 0], fontMatrix);
              width = transformed[0] * fontSize + spacing;
              ctx.translate(width, 0);
              current.x += width * textHScale;
          }
          ctx.restore();
          this.processingType3 = null;
      };
      CanvasGraphics.prototype.setCharWidth = function (xWidth, yWidth) { };
      CanvasGraphics.prototype.setCharWidthAndBounds = function (xWidth, yWidth, llx, lly, urx, ury) {
          this.ctx.rect(llx, lly, urx - llx, ury - lly);
          this.ctx.clip();
          this.endPath();
      };
      CanvasGraphics.prototype.getColorN_Pattern = function (IR) {
          var _this = this;
          var pattern;
          if (IR[0] === "TilingPattern") {
              var color = IR[1];
              var baseTransform = this.baseTransform || getCurrentTransform(this.ctx);
              var canvasGraphicsFactory = {
                  createCanvasGraphics: function (ctx) { return new CanvasGraphics(ctx, _this.commonObjs, _this.objs, _this.canvasFactory, _this.filterFactory, {
                      optionalContentConfig: _this.optionalContentConfig,
                      markedContentStack: _this.markedContentStack
                  }); }
              };
              pattern = new TilingPattern(IR, color, this.ctx, canvasGraphicsFactory, baseTransform);
          }
          else {
              pattern = this._getPattern(IR[1], IR[2]);
          }
          return pattern;
      };
      CanvasGraphics.prototype.setStrokeColorN = function () {
          this.current.strokeColor = this.getColorN_Pattern(arguments);
      };
      CanvasGraphics.prototype.setFillColorN = function () {
          this.current.fillColor = this.getColorN_Pattern(arguments);
          this.current.patternFill = true;
      };
      CanvasGraphics.prototype.setStrokeRGBColor = function (r, g, b) {
          var color = Util.makeHexColor(r, g, b);
          this.ctx.strokeStyle = color;
          this.current.strokeColor = color;
      };
      CanvasGraphics.prototype.setFillRGBColor = function (r, g, b) {
          var color = Util.makeHexColor(r, g, b);
          this.ctx.fillStyle = color;
          this.current.fillColor = color;
          this.current.patternFill = false;
      };
      CanvasGraphics.prototype._getPattern = function (objId, matrix) {
          if (matrix === void 0) { matrix = null; }
          var pattern;
          if (this.cachedPatterns.has(objId)) {
              pattern = this.cachedPatterns.get(objId);
          }
          else {
              pattern = getShadingPattern(this.getObject(objId));
              this.cachedPatterns.set(objId, pattern);
          }
          if (matrix) {
              pattern.matrix = matrix;
          }
          return pattern;
      };
      CanvasGraphics.prototype.shadingFill = function (objId) {
          if (!this.contentVisible) {
              return;
          }
          var ctx = this.ctx;
          this.save();
          var pattern = this._getPattern(objId);
          ctx.fillStyle = pattern.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.SHADING);
          var inv = getCurrentTransformInverse(ctx);
          if (inv) {
              var _g = ctx.canvas, width = _g.width, height = _g.height;
              var _h = Util.getAxialAlignedBoundingBox([0, 0, width, height], inv), x0 = _h[0], y0 = _h[1], x1 = _h[2], y1 = _h[3];
              this.ctx.fillRect(x0, y0, x1 - x0, y1 - y0);
          }
          else {
              this.ctx.fillRect(-1e10, -1e10, 2e10, 2e10);
          }
          this.compose(this.current.getClippedPathBoundingBox());
          this.restore();
      };
      CanvasGraphics.prototype.beginInlineImage = function () {
          unreachable("Should not call beginInlineImage");
      };
      CanvasGraphics.prototype.beginImageData = function () {
          unreachable("Should not call beginImageData");
      };
      CanvasGraphics.prototype.paintFormXObjectBegin = function (matrix, bbox) {
          if (!this.contentVisible) {
              return;
          }
          this.save();
          this.baseTransformStack.push(this.baseTransform);
          if (matrix) {
              this.transform.apply(this, matrix);
          }
          this.baseTransform = getCurrentTransform(this.ctx);
          if (bbox) {
              var width = bbox[2] - bbox[0];
              var height = bbox[3] - bbox[1];
              this.ctx.rect(bbox[0], bbox[1], width, height);
              this.current.updateRectMinMax(getCurrentTransform(this.ctx), bbox);
              this.clip();
              this.endPath();
          }
      };
      CanvasGraphics.prototype.paintFormXObjectEnd = function () {
          if (!this.contentVisible) {
              return;
          }
          this.restore();
          this.baseTransform = this.baseTransformStack.pop();
      };
      CanvasGraphics.prototype.beginGroup = function (group) {
          if (!this.contentVisible) {
              return;
          }
          this.save();
          if (this.inSMaskMode) {
              this.endSMaskMode();
              this.current.activeSMask = null;
          }
          var currentCtx = this.ctx;
          if (!group.isolated) {
              info("TODO: Support non-isolated groups.");
          }
          if (group.knockout) {
              warn("Knockout groups not supported.");
          }
          var currentTransform = getCurrentTransform(currentCtx);
          if (group.matrix) {
              currentCtx.transform.apply(currentCtx, group.matrix);
          }
          if (!group.bbox) {
              throw new Error("Bounding box is required.");
          }
          var bounds = Util.getAxialAlignedBoundingBox(group.bbox, getCurrentTransform(currentCtx));
          var canvasBounds = [0, 0, currentCtx.canvas.width, currentCtx.canvas.height];
          bounds = Util.intersect(bounds, canvasBounds) || [0, 0, 0, 0];
          var offsetX = Math.floor(bounds[0]);
          var offsetY = Math.floor(bounds[1]);
          var drawnWidth = Math.max(Math.ceil(bounds[2]) - offsetX, 1);
          var drawnHeight = Math.max(Math.ceil(bounds[3]) - offsetY, 1);
          this.current.startNewPathAndClipBox([0, 0, drawnWidth, drawnHeight]);
          var cacheId = "groupAt" + this.groupLevel;
          if (group.smask) {
              cacheId += "_smask_" + this.smaskCounter++ % 2;
          }
          var scratchCanvas = this.cachedCanvases.getCanvas(cacheId, drawnWidth, drawnHeight);
          var groupCtx = scratchCanvas.context;
          groupCtx.translate(-offsetX, -offsetY);
          groupCtx.transform.apply(groupCtx, currentTransform);
          if (group.smask) {
              this.smaskStack.push({
                  canvas: scratchCanvas.canvas,
                  context: groupCtx,
                  offsetX: offsetX,
                  offsetY: offsetY,
                  subtype: group.smask.subtype,
                  backdrop: group.smask.backdrop,
                  transferMap: group.smask.transferMap || null,
                  startTransformInverse: null
              });
          }
          else {
              currentCtx.setTransform(1, 0, 0, 1, 0, 0);
              currentCtx.translate(offsetX, offsetY);
              currentCtx.save();
          }
          copyCtxState(currentCtx, groupCtx);
          this.ctx = groupCtx;
          this.setGState([["BM", "source-over"], ["ca", 1], ["CA", 1]]);
          this.groupStack.push(currentCtx);
          this.groupLevel++;
      };
      CanvasGraphics.prototype.endGroup = function (group) {
          var _g;
          if (!this.contentVisible) {
              return;
          }
          this.groupLevel--;
          var groupCtx = this.ctx;
          var ctx = this.groupStack.pop();
          this.ctx = ctx;
          this.ctx.imageSmoothingEnabled = false;
          if (group.smask) {
              this.tempSMask = this.smaskStack.pop();
              this.restore();
          }
          else {
              this.ctx.restore();
              var currentMtx = getCurrentTransform(this.ctx);
              this.restore();
              this.ctx.save();
              (_g = this.ctx).setTransform.apply(_g, currentMtx);
              var dirtyBox = Util.getAxialAlignedBoundingBox([0, 0, groupCtx.canvas.width, groupCtx.canvas.height], currentMtx);
              this.ctx.drawImage(groupCtx.canvas, 0, 0);
              this.ctx.restore();
              this.compose(dirtyBox);
          }
      };
      CanvasGraphics.prototype.beginAnnotation = function (id, rect, transform, matrix, hasOwnCanvas) {
          var _g;
          tslib_1.__classPrivateFieldGet(this, _CanvasGraphics_instances, "m", _CanvasGraphics_restoreInitialState).call(this);
          resetCtxToDefault(this.ctx);
          this.ctx.save();
          this.save();
          if (this.baseTransform) {
              (_g = this.ctx).setTransform.apply(_g, this.baseTransform);
          }
          if (rect) {
              var width = rect[2] - rect[0];
              var height = rect[3] - rect[1];
              if (hasOwnCanvas && this.annotationCanvasMap) {
                  transform = transform.slice();
                  transform[4] -= rect[0];
                  transform[5] -= rect[1];
                  rect = rect.slice();
                  rect[0] = rect[1] = 0;
                  rect[2] = width;
                  rect[3] = height;
                  var _h = Util.singularValueDecompose2dScale(getCurrentTransform(this.ctx)), scaleX = _h[0], scaleY = _h[1];
                  var viewportScale = this.viewportScale;
                  var canvasWidth = Math.ceil(width * this.outputScaleX * viewportScale);
                  var canvasHeight = Math.ceil(height * this.outputScaleY * viewportScale);
                  this.annotationCanvas = this.canvasFactory.create(canvasWidth, canvasHeight);
                  var _j = this.annotationCanvas, canvas = _j.canvas, context = _j.context;
                  this.annotationCanvasMap.set(id, canvas);
                  this.annotationCanvas.savedCtx = this.ctx;
                  this.ctx = context;
                  this.ctx.save();
                  this.ctx.setTransform(scaleX, 0, 0, -scaleY, 0, height * scaleY);
                  resetCtxToDefault(this.ctx);
              }
              else {
                  resetCtxToDefault(this.ctx);
                  this.ctx.rect(rect[0], rect[1], width, height);
                  this.ctx.clip();
                  this.endPath();
              }
          }
          this.current = new CanvasExtraState(this.ctx.canvas.width, this.ctx.canvas.height);
          this.transform.apply(this, transform);
          this.transform.apply(this, matrix);
      };
      CanvasGraphics.prototype.endAnnotation = function () {
          if (this.annotationCanvas) {
              this.ctx.restore();
              tslib_1.__classPrivateFieldGet(this, _CanvasGraphics_instances, "m", _CanvasGraphics_drawFilter).call(this);
              this.ctx = this.annotationCanvas.savedCtx;
              delete this.annotationCanvas.savedCtx;
              delete this.annotationCanvas;
          }
      };
      CanvasGraphics.prototype.paintImageMaskXObject = function (img) {
          if (!this.contentVisible) {
              return;
          }
          var count = img.count;
          img = this.getObject(img.data, img);
          img.count = count;
          var ctx = this.ctx;
          var glyph = this.processingType3;
          if (glyph) {
              if (glyph.compiled === undefined) {
                  glyph.compiled = compileType3Glyph(img);
              }
              if (glyph.compiled) {
                  glyph.compiled(ctx);
                  return;
              }
          }
          var mask = this._createMaskCanvas(img);
          var maskCanvas = mask.canvas;
          ctx.save();
          ctx.setTransform(1, 0, 0, 1, 0, 0);
          ctx.drawImage(maskCanvas, mask.offsetX, mask.offsetY);
          ctx.restore();
          this.compose();
      };
      CanvasGraphics.prototype.paintImageMaskXObjectRepeat = function (img, scaleX, skewX, skewY, scaleY, positions) {
          if (skewX === void 0) { skewX = 0; }
          if (skewY === void 0) { skewY = 0; }
          if (!this.contentVisible) {
              return;
          }
          img = this.getObject(img.data, img);
          var ctx = this.ctx;
          ctx.save();
          var currentTransform = getCurrentTransform(ctx);
          ctx.transform(scaleX, skewX, skewY, scaleY, 0, 0);
          var mask = this._createMaskCanvas(img);
          ctx.setTransform(1, 0, 0, 1, mask.offsetX - currentTransform[4], mask.offsetY - currentTransform[5]);
          for (var i = 0, ii = positions.length; i < ii; i += 2) {
              var trans = Util.transform(currentTransform, [scaleX, skewX, skewY, scaleY, positions[i], positions[i + 1]]);
              var _g = Util.applyTransform([0, 0], trans), x = _g[0], y = _g[1];
              ctx.drawImage(mask.canvas, x, y);
          }
          ctx.restore();
          this.compose();
      };
      CanvasGraphics.prototype.paintImageMaskXObjectGroup = function (images) {
          if (!this.contentVisible) {
              return;
          }
          var ctx = this.ctx;
          var fillColor = this.current.fillColor;
          var isPatternFill = this.current.patternFill;
          for (var _i = 0, images_1 = images; _i < images_1.length; _i++) {
              var image = images_1[_i];
              var data = image.data, width = image.width, height = image.height, transform = image.transform;
              var maskCanvas = this.cachedCanvases.getCanvas("maskCanvas", width, height);
              var maskCtx = maskCanvas.context;
              maskCtx.save();
              var img = this.getObject(data, image);
              putBinaryImageMask(maskCtx, img);
              maskCtx.globalCompositeOperation = "source-in";
              maskCtx.fillStyle = isPatternFill ? fillColor.getPattern(maskCtx, this, getCurrentTransformInverse(ctx), PathType.FILL) : fillColor;
              maskCtx.fillRect(0, 0, width, height);
              maskCtx.restore();
              ctx.save();
              ctx.transform.apply(ctx, transform);
              ctx.scale(1, -1);
              drawImageAtIntegerCoords(ctx, maskCanvas.canvas, 0, 0, width, height, 0, -1, 1, 1);
              ctx.restore();
          }
          this.compose();
      };
      CanvasGraphics.prototype.paintImageXObject = function (objId) {
          if (!this.contentVisible) {
              return;
          }
          var imgData = this.getObject(objId);
          if (!imgData) {
              warn("Dependent image isn't ready yet");
              return;
          }
          this.paintInlineImageXObject(imgData);
      };
      CanvasGraphics.prototype.paintImageXObjectRepeat = function (objId, scaleX, scaleY, positions) {
          if (!this.contentVisible) {
              return;
          }
          var imgData = this.getObject(objId);
          if (!imgData) {
              warn("Dependent image isn't ready yet");
              return;
          }
          var width = imgData.width;
          var height = imgData.height;
          var map = [];
          for (var i = 0, ii = positions.length; i < ii; i += 2) {
              map.push({
                  transform: [scaleX, 0, 0, scaleY, positions[i], positions[i + 1]],
                  x: 0,
                  y: 0,
                  w: width,
                  h: height
              });
          }
          this.paintInlineImageXObjectGroup(imgData, map);
      };
      CanvasGraphics.prototype.applyTransferMapsToCanvas = function (ctx) {
          if (this.current.transferMaps !== "none") {
              ctx.filter = this.current.transferMaps;
              ctx.drawImage(ctx.canvas, 0, 0);
              ctx.filter = "none";
          }
          return ctx.canvas;
      };
      CanvasGraphics.prototype.applyTransferMapsToBitmap = function (imgData) {
          if (this.current.transferMaps === "none") {
              return imgData.bitmap;
          }
          var bitmap = imgData.bitmap, width = imgData.width, height = imgData.height;
          var tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", width, height);
          var tmpCtx = tmpCanvas.context;
          tmpCtx.filter = this.current.transferMaps;
          tmpCtx.drawImage(bitmap, 0, 0);
          tmpCtx.filter = "none";
          return tmpCanvas.canvas;
      };
      CanvasGraphics.prototype.paintInlineImageXObject = function (imgData) {
          if (!this.contentVisible) {
              return;
          }
          var width = imgData.width;
          var height = imgData.height;
          var ctx = this.ctx;
          this.save();
          if (!isNodeJS) {
              var filter = ctx.filter;
              if (filter !== "none" && filter !== "") {
                  ctx.filter = "none";
              }
          }
          ctx.scale(1 / width, -1 / height);
          var imgToPaint;
          if (imgData.bitmap) {
              imgToPaint = this.applyTransferMapsToBitmap(imgData);
          }
          else if (typeof HTMLElement === "function" && imgData instanceof HTMLElement || !imgData.data) {
              imgToPaint = imgData;
          }
          else {
              var tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", width, height);
              var tmpCtx = tmpCanvas.context;
              putBinaryImageData(tmpCtx, imgData);
              imgToPaint = this.applyTransferMapsToCanvas(tmpCtx);
          }
          var scaled = this._scaleImage(imgToPaint, getCurrentTransformInverse(ctx));
          ctx.imageSmoothingEnabled = getImageSmoothingEnabled(getCurrentTransform(ctx), imgData.interpolate);
          drawImageAtIntegerCoords(ctx, scaled.img, 0, 0, scaled.paintWidth, scaled.paintHeight, 0, -height, width, height);
          this.compose();
          this.restore();
      };
      CanvasGraphics.prototype.paintInlineImageXObjectGroup = function (imgData, map) {
          if (!this.contentVisible) {
              return;
          }
          var ctx = this.ctx;
          var imgToPaint;
          if (imgData.bitmap) {
              imgToPaint = imgData.bitmap;
          }
          else {
              var w = imgData.width;
              var h = imgData.height;
              var tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", w, h);
              var tmpCtx = tmpCanvas.context;
              putBinaryImageData(tmpCtx, imgData);
              imgToPaint = this.applyTransferMapsToCanvas(tmpCtx);
          }
          for (var _i = 0, map_5 = map; _i < map_5.length; _i++) {
              var entry = map_5[_i];
              ctx.save();
              ctx.transform.apply(ctx, entry.transform);
              ctx.scale(1, -1);
              drawImageAtIntegerCoords(ctx, imgToPaint, entry.x, entry.y, entry.w, entry.h, 0, -1, 1, 1);
              ctx.restore();
          }
          this.compose();
      };
      CanvasGraphics.prototype.paintSolidColorImageMask = function () {
          if (!this.contentVisible) {
              return;
          }
          this.ctx.fillRect(0, 0, 1, 1);
          this.compose();
      };
      CanvasGraphics.prototype.markPoint = function (tag) { };
      CanvasGraphics.prototype.markPointProps = function (tag, properties) { };
      CanvasGraphics.prototype.beginMarkedContent = function (tag) {
          this.markedContentStack.push({
              visible: true
          });
      };
      CanvasGraphics.prototype.beginMarkedContentProps = function (tag, properties) {
          if (tag === "OC") {
              this.markedContentStack.push({
                  visible: this.optionalContentConfig.isVisible(properties)
              });
          }
          else {
              this.markedContentStack.push({
                  visible: true
              });
          }
          this.contentVisible = this.isContentVisible();
      };
      CanvasGraphics.prototype.endMarkedContent = function () {
          this.markedContentStack.pop();
          this.contentVisible = this.isContentVisible();
      };
      CanvasGraphics.prototype.beginCompat = function () { };
      CanvasGraphics.prototype.endCompat = function () { };
      CanvasGraphics.prototype.consumePath = function (clipBox) {
          var isEmpty = this.current.isEmptyClip();
          if (this.pendingClip) {
              this.current.updateClipFromPath();
          }
          if (!this.pendingClip) {
              this.compose(clipBox);
          }
          var ctx = this.ctx;
          if (this.pendingClip) {
              if (!isEmpty) {
                  if (this.pendingClip === EO_CLIP) {
                      ctx.clip("evenodd");
                  }
                  else {
                      ctx.clip();
                  }
              }
              this.pendingClip = null;
          }
          this.current.startNewPathAndClipBox(this.current.clipBox);
          ctx.beginPath();
      };
      CanvasGraphics.prototype.getSinglePixelWidth = function () {
          if (!this._cachedGetSinglePixelWidth) {
              var m = getCurrentTransform(this.ctx);
              if (m[1] === 0 && m[2] === 0) {
                  this._cachedGetSinglePixelWidth = 1 / Math.min(Math.abs(m[0]), Math.abs(m[3]));
              }
              else {
                  var absDet = Math.abs(m[0] * m[3] - m[2] * m[1]);
                  var normX = Math.hypot(m[0], m[2]);
                  var normY = Math.hypot(m[1], m[3]);
                  this._cachedGetSinglePixelWidth = Math.max(normX, normY) / absDet;
              }
          }
          return this._cachedGetSinglePixelWidth;
      };
      CanvasGraphics.prototype.getScaleForStroking = function () {
          if (this._cachedScaleForStroking[0] === -1) {
              var lineWidth = this.current.lineWidth;
              var _g = this.ctx.getTransform(), a = _g.a, b = _g.b, c = _g.c, d = _g.d;
              var scaleX = void 0, scaleY = void 0;
              if (b === 0 && c === 0) {
                  var normX = Math.abs(a);
                  var normY = Math.abs(d);
                  if (normX === normY) {
                      if (lineWidth === 0) {
                          scaleX = scaleY = 1 / normX;
                      }
                      else {
                          var scaledLineWidth = normX * lineWidth;
                          scaleX = scaleY = scaledLineWidth < 1 ? 1 / scaledLineWidth : 1;
                      }
                  }
                  else if (lineWidth === 0) {
                      scaleX = 1 / normX;
                      scaleY = 1 / normY;
                  }
                  else {
                      var scaledXLineWidth = normX * lineWidth;
                      var scaledYLineWidth = normY * lineWidth;
                      scaleX = scaledXLineWidth < 1 ? 1 / scaledXLineWidth : 1;
                      scaleY = scaledYLineWidth < 1 ? 1 / scaledYLineWidth : 1;
                  }
              }
              else {
                  var absDet = Math.abs(a * d - b * c);
                  var normX = Math.hypot(a, b);
                  var normY = Math.hypot(c, d);
                  if (lineWidth === 0) {
                      scaleX = normY / absDet;
                      scaleY = normX / absDet;
                  }
                  else {
                      var baseArea = lineWidth * absDet;
                      scaleX = normY > baseArea ? normY / baseArea : 1;
                      scaleY = normX > baseArea ? normX / baseArea : 1;
                  }
              }
              this._cachedScaleForStroking[0] = scaleX;
              this._cachedScaleForStroking[1] = scaleY;
          }
          return this._cachedScaleForStroking;
      };
      CanvasGraphics.prototype.rescaleAndStroke = function (saveRestore) {
          var ctx = this.ctx;
          var lineWidth = this.current.lineWidth;
          var _g = this.getScaleForStroking(), scaleX = _g[0], scaleY = _g[1];
          ctx.lineWidth = lineWidth || 1;
          if (scaleX === 1 && scaleY === 1) {
              ctx.stroke();
              return;
          }
          var dashes = ctx.getLineDash();
          if (saveRestore) {
              ctx.save();
          }
          ctx.scale(scaleX, scaleY);
          if (dashes.length > 0) {
              var scale_1 = Math.max(scaleX, scaleY);
              ctx.setLineDash(dashes.map(function (x) { return x / scale_1; }));
              ctx.lineDashOffset /= scale_1;
          }
          ctx.stroke();
          if (saveRestore) {
              ctx.restore();
          }
      };
      CanvasGraphics.prototype.isContentVisible = function () {
          for (var i = this.markedContentStack.length - 1; i >= 0; i--) {
              if (!this.markedContentStack[i].visible) {
                  return false;
              }
          }
          return true;
      };
      return CanvasGraphics;
  }());
  _CanvasGraphics_instances = new WeakSet(), _CanvasGraphics_restoreInitialState = function _CanvasGraphics_restoreInitialState() {
      while (this.stateStack.length || this.inSMaskMode) {
          this.restore();
      }
      this.ctx.restore();
      if (this.transparentCanvas) {
          this.ctx = this.compositeCtx;
          this.ctx.save();
          this.ctx.setTransform(1, 0, 0, 1, 0, 0);
          this.ctx.drawImage(this.transparentCanvas, 0, 0);
          this.ctx.restore();
          this.transparentCanvas = null;
      }
  }, _CanvasGraphics_drawFilter = function _CanvasGraphics_drawFilter() {
      if (this.pageColors) {
          var hcmFilterId = this.filterFactory.addHCMFilter(this.pageColors.foreground, this.pageColors.background);
          if (hcmFilterId !== "none") {
              var savedFilter = this.ctx.filter;
              this.ctx.filter = hcmFilterId;
              this.ctx.drawImage(this.ctx.canvas, 0, 0);
              this.ctx.filter = savedFilter;
          }
      }
  };
  for (var op in OPS) {
      if (CanvasGraphics.prototype[op] !== undefined) {
          CanvasGraphics.prototype[OPS[op]] = CanvasGraphics.prototype[op];
      }
  }
  ; // CONCATENATED MODULE: ./src/display/worker_options.js
  var GlobalWorkerOptions = /** @class */ (function () {
      function GlobalWorkerOptions() {
      }
      Object.defineProperty(GlobalWorkerOptions, "workerPort", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _g, "f", _GlobalWorkerOptions_port);
          },
          set: function (val) {
              if (!(typeof Worker !== "undefined" && val instanceof Worker) && val !== null) {
                  throw new Error("Invalid `workerPort` type.");
              }
              tslib_1.__classPrivateFieldSet(this, _g, val, "f", _GlobalWorkerOptions_port);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(GlobalWorkerOptions, "workerSrc", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _g, "f", _GlobalWorkerOptions_src);
          },
          set: function (val) {
              if (typeof val !== "string") {
                  throw new Error("Invalid `workerSrc` type.");
              }
              tslib_1.__classPrivateFieldSet(this, _g, val, "f", _GlobalWorkerOptions_src);
          },
          enumerable: false,
          configurable: true
      });
      var _g, _GlobalWorkerOptions_port, _GlobalWorkerOptions_src;
      _g = GlobalWorkerOptions;
      _GlobalWorkerOptions_port = { value: null };
      _GlobalWorkerOptions_src = { value: "" };
      return GlobalWorkerOptions;
  }());
  ; // CONCATENATED MODULE: ./src/shared/message_handler.js
  var CallbackKind = {
      UNKNOWN: 0,
      DATA: 1,
      ERROR: 2
  };
  var StreamKind = {
      UNKNOWN: 0,
      CANCEL: 1,
      CANCEL_COMPLETE: 2,
      CLOSE: 3,
      ENQUEUE: 4,
      ERROR: 5,
      PULL: 6,
      PULL_COMPLETE: 7,
      START_COMPLETE: 8
  };
  function wrapReason(reason) {
      if (!(reason instanceof Error || typeof reason === "object" && reason !== null)) {
          unreachable('wrapReason: Expected "reason" to be a (possibly cloned) Error.');
      }
      switch (reason.name) {
          case "AbortException":
              return new AbortException(reason.message);
          case "MissingPDFException":
              return new MissingPDFException(reason.message);
          case "PasswordException":
              return new PasswordException(reason.message, reason.code);
          case "UnexpectedResponseException":
              return new UnexpectedResponseException(reason.message, reason.status);
          case "UnknownErrorException":
              return new UnknownErrorException(reason.message, reason.details);
          default:
              return new UnknownErrorException(reason.message, reason.toString());
      }
  }
  var MessageHandler = /** @class */ (function () {
      function MessageHandler(sourceName, targetName, comObj) {
          var _this = this;
          _MessageHandler_instances.add(this);
          this.sourceName = sourceName;
          this.targetName = targetName;
          this.comObj = comObj;
          this.callbackId = 1;
          this.streamId = 1;
          this.streamSinks = Object.create(null);
          this.streamControllers = Object.create(null);
          this.callbackCapabilities = Object.create(null);
          this.actionHandler = Object.create(null);
          this._onComObjOnMessage = function (event) {
              var data = event.data;
              if (data.targetName !== _this.sourceName) {
                  return;
              }
              if (data.stream) {
                  tslib_1.__classPrivateFieldGet(_this, _MessageHandler_instances, "m", _MessageHandler_processStreamMessage).call(_this, data);
                  return;
              }
              if (data.callback) {
                  var callbackId = data.callbackId;
                  var capability = _this.callbackCapabilities[callbackId];
                  if (!capability) {
                      throw new Error("Cannot resolve callback ".concat(callbackId));
                  }
                  delete _this.callbackCapabilities[callbackId];
                  if (data.callback === CallbackKind.DATA) {
                      capability.resolve(data.data);
                  }
                  else if (data.callback === CallbackKind.ERROR) {
                      capability.reject(wrapReason(data.reason));
                  }
                  else {
                      throw new Error("Unexpected callback case");
                  }
                  return;
              }
              var action = _this.actionHandler[data.action];
              if (!action) {
                  throw new Error("Unknown action from worker: ".concat(data.action));
              }
              if (data.callbackId) {
                  var cbSourceName_1 = _this.sourceName;
                  var cbTargetName_1 = data.sourceName;
                  new Promise(function (resolve) {
                      resolve(action(data.data));
                  }).then(function (result) {
                      comObj.postMessage({
                          sourceName: cbSourceName_1,
                          targetName: cbTargetName_1,
                          callback: CallbackKind.DATA,
                          callbackId: data.callbackId,
                          data: result
                      });
                  }, function (reason) {
                      comObj.postMessage({
                          sourceName: cbSourceName_1,
                          targetName: cbTargetName_1,
                          callback: CallbackKind.ERROR,
                          callbackId: data.callbackId,
                          reason: wrapReason(reason)
                      });
                  });
                  return;
              }
              if (data.streamId) {
                  tslib_1.__classPrivateFieldGet(_this, _MessageHandler_instances, "m", _MessageHandler_createStreamSink).call(_this, data);
                  return;
              }
              action(data.data);
          };
          comObj.addEventListener("message", this._onComObjOnMessage);
      }
      MessageHandler.prototype.on = function (actionName, handler) {
          var ah = this.actionHandler;
          if (ah[actionName]) {
              throw new Error("There is already an actionName called \"".concat(actionName, "\""));
          }
          ah[actionName] = handler;
      };
      MessageHandler.prototype.send = function (actionName, data, transfers) {
          this.comObj.postMessage({
              sourceName: this.sourceName,
              targetName: this.targetName,
              action: actionName,
              data: data
          }, transfers);
      };
      MessageHandler.prototype.sendWithPromise = function (actionName, data, transfers) {
          var callbackId = this.callbackId++;
          var capability = Promise.withResolvers();
          this.callbackCapabilities[callbackId] = capability;
          try {
              this.comObj.postMessage({
                  sourceName: this.sourceName,
                  targetName: this.targetName,
                  action: actionName,
                  callbackId: callbackId,
                  data: data
              }, transfers);
          }
          catch (ex) {
              capability.reject(ex);
          }
          return capability.promise;
      };
      MessageHandler.prototype.sendWithStream = function (actionName, data, queueingStrategy, transfers) {
          var _this = this;
          var streamId = this.streamId++, sourceName = this.sourceName, targetName = this.targetName, comObj = this.comObj;
          return new ReadableStream({
              start: function (controller) {
                  var startCapability = Promise.withResolvers();
                  _this.streamControllers[streamId] = {
                      controller: controller,
                      startCall: startCapability,
                      pullCall: null,
                      cancelCall: null,
                      isClosed: false
                  };
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      action: actionName,
                      streamId: streamId,
                      data: data,
                      desiredSize: controller.desiredSize
                  }, transfers);
                  return startCapability.promise;
              },
              pull: function (controller) {
                  var pullCapability = Promise.withResolvers();
                  _this.streamControllers[streamId].pullCall = pullCapability;
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.PULL,
                      streamId: streamId,
                      desiredSize: controller.desiredSize
                  });
                  return pullCapability.promise;
              },
              cancel: function (reason) {
                  assert(reason instanceof Error, "cancel must have a valid reason");
                  var cancelCapability = Promise.withResolvers();
                  _this.streamControllers[streamId].cancelCall = cancelCapability;
                  _this.streamControllers[streamId].isClosed = true;
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.CANCEL,
                      streamId: streamId,
                      reason: wrapReason(reason)
                  });
                  return cancelCapability.promise;
              }
          }, queueingStrategy);
      };
      MessageHandler.prototype.destroy = function () {
          this.comObj.removeEventListener("message", this._onComObjOnMessage);
      };
      return MessageHandler;
  }());
  _MessageHandler_instances = new WeakSet(), _MessageHandler_createStreamSink = function _MessageHandler_createStreamSink(data) {
      var streamId = data.streamId, sourceName = this.sourceName, targetName = data.sourceName, comObj = this.comObj;
      var self = this, action = this.actionHandler[data.action];
      var streamSink = {
          enqueue: function (chunk, size, transfers) {
              if (size === void 0) { size = 1; }
              if (this.isCancelled) {
                  return;
              }
              var lastDesiredSize = this.desiredSize;
              this.desiredSize -= size;
              if (lastDesiredSize > 0 && this.desiredSize <= 0) {
                  this.sinkCapability = Promise.withResolvers();
                  this.ready = this.sinkCapability.promise;
              }
              comObj.postMessage({
                  sourceName: sourceName,
                  targetName: targetName,
                  stream: StreamKind.ENQUEUE,
                  streamId: streamId,
                  chunk: chunk
              }, transfers);
          },
          close: function () {
              if (this.isCancelled) {
                  return;
              }
              this.isCancelled = true;
              comObj.postMessage({
                  sourceName: sourceName,
                  targetName: targetName,
                  stream: StreamKind.CLOSE,
                  streamId: streamId
              });
              delete self.streamSinks[streamId];
          },
          error: function (reason) {
              assert(reason instanceof Error, "error must have a valid reason");
              if (this.isCancelled) {
                  return;
              }
              this.isCancelled = true;
              comObj.postMessage({
                  sourceName: sourceName,
                  targetName: targetName,
                  stream: StreamKind.ERROR,
                  streamId: streamId,
                  reason: wrapReason(reason)
              });
          },
          sinkCapability: Promise.withResolvers(),
          onPull: null,
          onCancel: null,
          isCancelled: false,
          desiredSize: data.desiredSize,
          ready: null
      };
      streamSink.sinkCapability.resolve();
      streamSink.ready = streamSink.sinkCapability.promise;
      this.streamSinks[streamId] = streamSink;
      new Promise(function (resolve) {
          resolve(action(data.data, streamSink));
      }).then(function () {
          comObj.postMessage({
              sourceName: sourceName,
              targetName: targetName,
              stream: StreamKind.START_COMPLETE,
              streamId: streamId,
              success: true
          });
      }, function (reason) {
          comObj.postMessage({
              sourceName: sourceName,
              targetName: targetName,
              stream: StreamKind.START_COMPLETE,
              streamId: streamId,
              reason: wrapReason(reason)
          });
      });
  }, _MessageHandler_processStreamMessage = function _MessageHandler_processStreamMessage(data) {
      var streamId = data.streamId, sourceName = this.sourceName, targetName = data.sourceName, comObj = this.comObj;
      var streamController = this.streamControllers[streamId], streamSink = this.streamSinks[streamId];
      switch (data.stream) {
          case StreamKind.START_COMPLETE:
              if (data.success) {
                  streamController.startCall.resolve();
              }
              else {
                  streamController.startCall.reject(wrapReason(data.reason));
              }
              break;
          case StreamKind.PULL_COMPLETE:
              if (data.success) {
                  streamController.pullCall.resolve();
              }
              else {
                  streamController.pullCall.reject(wrapReason(data.reason));
              }
              break;
          case StreamKind.PULL:
              if (!streamSink) {
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.PULL_COMPLETE,
                      streamId: streamId,
                      success: true
                  });
                  break;
              }
              if (streamSink.desiredSize <= 0 && data.desiredSize > 0) {
                  streamSink.sinkCapability.resolve();
              }
              streamSink.desiredSize = data.desiredSize;
              new Promise(function (resolve) {
                  var _h;
                  resolve((_h = streamSink.onPull) === null || _h === void 0 ? void 0 : _h.call(streamSink));
              }).then(function () {
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.PULL_COMPLETE,
                      streamId: streamId,
                      success: true
                  });
              }, function (reason) {
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.PULL_COMPLETE,
                      streamId: streamId,
                      reason: wrapReason(reason)
                  });
              });
              break;
          case StreamKind.ENQUEUE:
              assert(streamController, "enqueue should have stream controller");
              if (streamController.isClosed) {
                  break;
              }
              streamController.controller.enqueue(data.chunk);
              break;
          case StreamKind.CLOSE:
              assert(streamController, "close should have stream controller");
              if (streamController.isClosed) {
                  break;
              }
              streamController.isClosed = true;
              streamController.controller.close();
              tslib_1.__classPrivateFieldGet(this, _MessageHandler_instances, "m", _MessageHandler_deleteStreamController).call(this, streamController, streamId);
              break;
          case StreamKind.ERROR:
              assert(streamController, "error should have stream controller");
              streamController.controller.error(wrapReason(data.reason));
              tslib_1.__classPrivateFieldGet(this, _MessageHandler_instances, "m", _MessageHandler_deleteStreamController).call(this, streamController, streamId);
              break;
          case StreamKind.CANCEL_COMPLETE:
              if (data.success) {
                  streamController.cancelCall.resolve();
              }
              else {
                  streamController.cancelCall.reject(wrapReason(data.reason));
              }
              tslib_1.__classPrivateFieldGet(this, _MessageHandler_instances, "m", _MessageHandler_deleteStreamController).call(this, streamController, streamId);
              break;
          case StreamKind.CANCEL:
              if (!streamSink) {
                  break;
              }
              new Promise(function (resolve) {
                  var _h;
                  resolve((_h = streamSink.onCancel) === null || _h === void 0 ? void 0 : _h.call(streamSink, wrapReason(data.reason)));
              }).then(function () {
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.CANCEL_COMPLETE,
                      streamId: streamId,
                      success: true
                  });
              }, function (reason) {
                  comObj.postMessage({
                      sourceName: sourceName,
                      targetName: targetName,
                      stream: StreamKind.CANCEL_COMPLETE,
                      streamId: streamId,
                      reason: wrapReason(reason)
                  });
              });
              streamSink.sinkCapability.reject(wrapReason(data.reason));
              streamSink.isCancelled = true;
              delete this.streamSinks[streamId];
              break;
          default:
              throw new Error("Unexpected stream case");
      }
  }, _MessageHandler_deleteStreamController = function _MessageHandler_deleteStreamController(streamController, streamId) {
      var _h, _j, _k;
      return tslib_1.__awaiter(this, void 0, void 0, function () {
          return tslib_1.__generator(this, function (_l) {
              switch (_l.label) {
                  case 0: return [4 /*yield*/, Promise.allSettled([(_h = streamController.startCall) === null || _h === void 0 ? void 0 : _h.promise, (_j = streamController.pullCall) === null || _j === void 0 ? void 0 : _j.promise, (_k = streamController.cancelCall) === null || _k === void 0 ? void 0 : _k.promise])];
                  case 1:
                      _l.sent();
                      delete this.streamControllers[streamId];
                      return [2 /*return*/];
              }
          });
      });
  };
  ; // CONCATENATED MODULE: ./src/display/metadata.js
  var Metadata = /** @class */ (function () {
      function Metadata(_h) {
          var parsedData = _h.parsedData, rawData = _h.rawData;
          _Metadata_metadataMap.set(this, void 0);
          _Metadata_data.set(this, void 0);
          tslib_1.__classPrivateFieldSet(this, _Metadata_metadataMap, parsedData, "f");
          tslib_1.__classPrivateFieldSet(this, _Metadata_data, rawData, "f");
      }
      Metadata.prototype.getRaw = function () {
          return tslib_1.__classPrivateFieldGet(this, _Metadata_data, "f");
      };
      Metadata.prototype.get = function (name) {
          var _h;
          return (_h = tslib_1.__classPrivateFieldGet(this, _Metadata_metadataMap, "f").get(name)) !== null && _h !== void 0 ? _h : null;
      };
      Metadata.prototype.getAll = function () {
          return objectFromMap(tslib_1.__classPrivateFieldGet(this, _Metadata_metadataMap, "f"));
      };
      Metadata.prototype.has = function (name) {
          return tslib_1.__classPrivateFieldGet(this, _Metadata_metadataMap, "f").has(name);
      };
      return Metadata;
  }());
  _Metadata_metadataMap = new WeakMap(), _Metadata_data = new WeakMap();
  ; // CONCATENATED MODULE: ./src/display/optional_content_config.js
  var INTERNAL = Symbol("INTERNAL");
  var OptionalContentGroup = /** @class */ (function () {
      function OptionalContentGroup(renderingIntent, _h) {
          var name = _h.name, intent = _h.intent, usage = _h.usage;
          _OptionalContentGroup_isDisplay.set(this, false);
          _OptionalContentGroup_isPrint.set(this, false);
          _OptionalContentGroup_userSet.set(this, false);
          _OptionalContentGroup_visible.set(this, true);
          tslib_1.__classPrivateFieldSet(this, _OptionalContentGroup_isDisplay, !!(renderingIntent & RenderingIntentFlag.DISPLAY), "f");
          tslib_1.__classPrivateFieldSet(this, _OptionalContentGroup_isPrint, !!(renderingIntent & RenderingIntentFlag.PRINT), "f");
          this.name = name;
          this.intent = intent;
          this.usage = usage;
      }
      Object.defineProperty(OptionalContentGroup.prototype, "visible", {
          get: function () {
              if (tslib_1.__classPrivateFieldGet(this, _OptionalContentGroup_userSet, "f")) {
                  return tslib_1.__classPrivateFieldGet(this, _OptionalContentGroup_visible, "f");
              }
              if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentGroup_visible, "f")) {
                  return false;
              }
              var _h = this.usage, print = _h.print, view = _h.view;
              if (tslib_1.__classPrivateFieldGet(this, _OptionalContentGroup_isDisplay, "f")) {
                  return (view === null || view === void 0 ? void 0 : view.viewState) !== "OFF";
              }
              else if (tslib_1.__classPrivateFieldGet(this, _OptionalContentGroup_isPrint, "f")) {
                  return (print === null || print === void 0 ? void 0 : print.printState) !== "OFF";
              }
              return true;
          },
          enumerable: false,
          configurable: true
      });
      OptionalContentGroup.prototype._setVisible = function (internal, visible, userSet) {
          if (userSet === void 0) { userSet = false; }
          if (internal !== INTERNAL) {
              unreachable("Internal method `_setVisible` called.");
          }
          tslib_1.__classPrivateFieldSet(this, _OptionalContentGroup_userSet, userSet, "f");
          tslib_1.__classPrivateFieldSet(this, _OptionalContentGroup_visible, visible, "f");
      };
      return OptionalContentGroup;
  }());
  _OptionalContentGroup_isDisplay = new WeakMap(), _OptionalContentGroup_isPrint = new WeakMap(), _OptionalContentGroup_userSet = new WeakMap(), _OptionalContentGroup_visible = new WeakMap();
  var OptionalContentConfig = /** @class */ (function () {
      function OptionalContentConfig(data, renderingIntent) {
          if (renderingIntent === void 0) { renderingIntent = RenderingIntentFlag.DISPLAY; }
          _OptionalContentConfig_instances.add(this);
          _OptionalContentConfig_cachedGetHash.set(this, null);
          _OptionalContentConfig_groups.set(this, new Map());
          _OptionalContentConfig_initialHash.set(this, null);
          _OptionalContentConfig_order.set(this, null);
          this.renderingIntent = renderingIntent;
          this.name = null;
          this.creator = null;
          if (data === null) {
              return;
          }
          this.name = data.name;
          this.creator = data.creator;
          tslib_1.__classPrivateFieldSet(this, _OptionalContentConfig_order, data.order, "f");
          for (var _i = 0, _h = data.groups; _i < _h.length; _i++) {
              var group = _h[_i];
              tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").set(group.id, new OptionalContentGroup(renderingIntent, group));
          }
          if (data.baseState === "OFF") {
              for (var _j = 0, _k = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").values(); _j < _k.length; _j++) {
                  var group = _k[_j];
                  group._setVisible(INTERNAL, false);
              }
          }
          for (var _l = 0, _m = data.on; _l < _m.length; _l++) {
              var on = _m[_l];
              tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(on)._setVisible(INTERNAL, true);
          }
          for (var _o = 0, _p = data.off; _o < _p.length; _o++) {
              var off = _p[_o];
              tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(off)._setVisible(INTERNAL, false);
          }
          tslib_1.__classPrivateFieldSet(this, _OptionalContentConfig_initialHash, this.getHash(), "f");
      }
      OptionalContentConfig.prototype.isVisible = function (group) {
          if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").size === 0) {
              return true;
          }
          if (!group) {
              info("Optional content group not defined.");
              return true;
          }
          if (group.type === "OCG") {
              if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(group.id)) {
                  warn("Optional content group not found: ".concat(group.id));
                  return true;
              }
              return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(group.id).visible;
          }
          else if (group.type === "OCMD") {
              if (group.expression) {
                  return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_instances, "m", _OptionalContentConfig_evaluateVisibilityExpression).call(this, group.expression);
              }
              if (!group.policy || group.policy === "AnyOn") {
                  for (var _i = 0, _h = group.ids; _i < _h.length; _i++) {
                      var id = _h[_i];
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(id)) {
                          warn("Optional content group not found: ".concat(id));
                          return true;
                      }
                      if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id).visible) {
                          return true;
                      }
                  }
                  return false;
              }
              else if (group.policy === "AllOn") {
                  for (var _j = 0, _k = group.ids; _j < _k.length; _j++) {
                      var id = _k[_j];
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(id)) {
                          warn("Optional content group not found: ".concat(id));
                          return true;
                      }
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id).visible) {
                          return false;
                      }
                  }
                  return true;
              }
              else if (group.policy === "AnyOff") {
                  for (var _l = 0, _m = group.ids; _l < _m.length; _l++) {
                      var id = _m[_l];
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(id)) {
                          warn("Optional content group not found: ".concat(id));
                          return true;
                      }
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id).visible) {
                          return true;
                      }
                  }
                  return false;
              }
              else if (group.policy === "AllOff") {
                  for (var _o = 0, _p = group.ids; _o < _p.length; _o++) {
                      var id = _p[_o];
                      if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(id)) {
                          warn("Optional content group not found: ".concat(id));
                          return true;
                      }
                      if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id).visible) {
                          return false;
                      }
                  }
                  return true;
              }
              warn("Unknown optional content policy ".concat(group.policy, "."));
              return true;
          }
          warn("Unknown group type ".concat(group.type, "."));
          return true;
      };
      OptionalContentConfig.prototype.setVisibility = function (id, visible) {
          if (visible === void 0) { visible = true; }
          var group = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id);
          if (!group) {
              warn("Optional content group not found: ".concat(id));
              return;
          }
          group._setVisible(INTERNAL, !!visible, true);
          tslib_1.__classPrivateFieldSet(this, _OptionalContentConfig_cachedGetHash, null, "f");
      };
      OptionalContentConfig.prototype.setOCGState = function (_h) {
          var state = _h.state, preserveRB = _h.preserveRB;
          var operator;
          for (var _i = 0, state_1 = state; _i < state_1.length; _i++) {
              var elem = state_1[_i];
              switch (elem) {
                  case "ON":
                  case "OFF":
                  case "Toggle":
                      operator = elem;
                      continue;
              }
              var group = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(elem);
              if (!group) {
                  continue;
              }
              switch (operator) {
                  case "ON":
                      group._setVisible(INTERNAL, true);
                      break;
                  case "OFF":
                      group._setVisible(INTERNAL, false);
                      break;
                  case "Toggle":
                      group._setVisible(INTERNAL, !group.visible);
                      break;
              }
          }
          tslib_1.__classPrivateFieldSet(this, _OptionalContentConfig_cachedGetHash, null, "f");
      };
      Object.defineProperty(OptionalContentConfig.prototype, "hasInitialVisibility", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_initialHash, "f") === null || this.getHash() === tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_initialHash, "f");
          },
          enumerable: false,
          configurable: true
      });
      OptionalContentConfig.prototype.getOrder = function () {
          if (!tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").size) {
              return null;
          }
          if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_order, "f")) {
              return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_order, "f").slice();
          }
          return tslib_1.__spreadArray([], tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").keys(), true);
      };
      OptionalContentConfig.prototype.getGroups = function () {
          return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").size > 0 ? objectFromMap(tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f")) : null;
      };
      OptionalContentConfig.prototype.getGroup = function (id) {
          return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(id) || null;
      };
      OptionalContentConfig.prototype.getHash = function () {
          if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_cachedGetHash, "f") !== null) {
              return tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_cachedGetHash, "f");
          }
          var hash = new MurmurHash3_64();
          for (var _i = 0, _h = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f"); _i < _h.length; _i++) {
              var _j = _h[_i], id = _j[0], group = _j[1];
              hash.update("".concat(id, ":").concat(group.visible));
          }
          return tslib_1.__classPrivateFieldSet(this, _OptionalContentConfig_cachedGetHash, hash.hexdigest(), "f");
      };
      return OptionalContentConfig;
  }());
  _OptionalContentConfig_cachedGetHash = new WeakMap(), _OptionalContentConfig_groups = new WeakMap(), _OptionalContentConfig_initialHash = new WeakMap(), _OptionalContentConfig_order = new WeakMap(), _OptionalContentConfig_instances = new WeakSet(), _OptionalContentConfig_evaluateVisibilityExpression = function _OptionalContentConfig_evaluateVisibilityExpression(array) {
      var length = array.length;
      if (length < 2) {
          return true;
      }
      var operator = array[0];
      for (var i = 1; i < length; i++) {
          var element = array[i];
          var state = void 0;
          if (Array.isArray(element)) {
              state = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_instances, "m", _OptionalContentConfig_evaluateVisibilityExpression).call(this, element);
          }
          else if (tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").has(element)) {
              state = tslib_1.__classPrivateFieldGet(this, _OptionalContentConfig_groups, "f").get(element).visible;
          }
          else {
              warn("Optional content group not found: ".concat(element));
              return true;
          }
          switch (operator) {
              case "And":
                  if (!state) {
                      return false;
                  }
                  break;
              case "Or":
                  if (state) {
                      return true;
                  }
                  break;
              case "Not":
                  return !state;
              default:
                  return true;
          }
      }
      return operator === "And";
  };
  ; // CONCATENATED MODULE: ./src/display/transport_stream.js
  var PDFDataTransportStream = /** @class */ (function () {
      function PDFDataTransportStream(pdfDataRangeTransport, _h) {
          var _j = _h.disableRange, disableRange = _j === void 0 ? false : _j, _k = _h.disableStream, disableStream = _k === void 0 ? false : _k;
          var _this = this;
          assert(pdfDataRangeTransport, 'PDFDataTransportStream - missing required "pdfDataRangeTransport" argument.');
          var length = pdfDataRangeTransport.length, initialData = pdfDataRangeTransport.initialData, progressiveDone = pdfDataRangeTransport.progressiveDone, contentDispositionFilename = pdfDataRangeTransport.contentDispositionFilename;
          this._queuedChunks = [];
          this._progressiveDone = progressiveDone;
          this._contentDispositionFilename = contentDispositionFilename;
          if ((initialData === null || initialData === void 0 ? void 0 : initialData.length) > 0) {
              var buffer = initialData instanceof Uint8Array && initialData.byteLength === initialData.buffer.byteLength ? initialData.buffer : new Uint8Array(initialData).buffer;
              this._queuedChunks.push(buffer);
          }
          this._pdfDataRangeTransport = pdfDataRangeTransport;
          this._isStreamingSupported = !disableStream;
          this._isRangeSupported = !disableRange;
          this._contentLength = length;
          this._fullRequestReader = null;
          this._rangeReaders = [];
          pdfDataRangeTransport.addRangeListener(function (begin, chunk) {
              _this._onReceiveData({
                  begin: begin,
                  chunk: chunk
              });
          });
          pdfDataRangeTransport.addProgressListener(function (loaded, total) {
              _this._onProgress({
                  loaded: loaded,
                  total: total
              });
          });
          pdfDataRangeTransport.addProgressiveReadListener(function (chunk) {
              _this._onReceiveData({
                  chunk: chunk
              });
          });
          pdfDataRangeTransport.addProgressiveDoneListener(function () {
              _this._onProgressiveDone();
          });
          pdfDataRangeTransport.transportReady();
      }
      PDFDataTransportStream.prototype._onReceiveData = function (_h) {
          var begin = _h.begin, chunk = _h.chunk;
          var buffer = chunk instanceof Uint8Array && chunk.byteLength === chunk.buffer.byteLength ? chunk.buffer : new Uint8Array(chunk).buffer;
          if (begin === undefined) {
              if (this._fullRequestReader) {
                  this._fullRequestReader._enqueue(buffer);
              }
              else {
                  this._queuedChunks.push(buffer);
              }
          }
          else {
              var found = this._rangeReaders.some(function (rangeReader) {
                  if (rangeReader._begin !== begin) {
                      return false;
                  }
                  rangeReader._enqueue(buffer);
                  return true;
              });
              assert(found, "_onReceiveData - no `PDFDataTransportStreamRangeReader` instance found.");
          }
      };
      Object.defineProperty(PDFDataTransportStream.prototype, "_progressiveDataLength", {
          get: function () {
              var _h, _j;
              return (_j = (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h._loaded) !== null && _j !== void 0 ? _j : 0;
          },
          enumerable: false,
          configurable: true
      });
      PDFDataTransportStream.prototype._onProgress = function (evt) {
          var _h, _j, _k, _l;
          if (evt.total === undefined) {
              (_j = (_h = this._rangeReaders[0]) === null || _h === void 0 ? void 0 : _h.onProgress) === null || _j === void 0 ? void 0 : _j.call(_h, {
                  loaded: evt.loaded
              });
          }
          else {
              (_l = (_k = this._fullRequestReader) === null || _k === void 0 ? void 0 : _k.onProgress) === null || _l === void 0 ? void 0 : _l.call(_k, {
                  loaded: evt.loaded,
                  total: evt.total
              });
          }
      };
      PDFDataTransportStream.prototype._onProgressiveDone = function () {
          var _h;
          (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h.progressiveDone();
          this._progressiveDone = true;
      };
      PDFDataTransportStream.prototype._removeRangeReader = function (reader) {
          var i = this._rangeReaders.indexOf(reader);
          if (i >= 0) {
              this._rangeReaders.splice(i, 1);
          }
      };
      PDFDataTransportStream.prototype.getFullReader = function () {
          assert(!this._fullRequestReader, "PDFDataTransportStream.getFullReader can only be called once.");
          var queuedChunks = this._queuedChunks;
          this._queuedChunks = null;
          return new PDFDataTransportStreamReader(this, queuedChunks, this._progressiveDone, this._contentDispositionFilename);
      };
      PDFDataTransportStream.prototype.getRangeReader = function (begin, end) {
          if (end <= this._progressiveDataLength) {
              return null;
          }
          var reader = new PDFDataTransportStreamRangeReader(this, begin, end);
          this._pdfDataRangeTransport.requestDataRange(begin, end);
          this._rangeReaders.push(reader);
          return reader;
      };
      PDFDataTransportStream.prototype.cancelAllRequests = function (reason) {
          var _h;
          (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          for (var _i = 0, _j = this._rangeReaders.slice(0); _i < _j.length; _i++) {
              var reader = _j[_i];
              reader.cancel(reason);
          }
          this._pdfDataRangeTransport.abort();
      };
      return PDFDataTransportStream;
  }());
  var PDFDataTransportStreamReader = /** @class */ (function () {
      function PDFDataTransportStreamReader(stream, queuedChunks, progressiveDone, contentDispositionFilename) {
          if (progressiveDone === void 0) { progressiveDone = false; }
          if (contentDispositionFilename === void 0) { contentDispositionFilename = null; }
          this._stream = stream;
          this._done = progressiveDone || false;
          this._filename = isPdfFile(contentDispositionFilename) ? contentDispositionFilename : null;
          this._queuedChunks = queuedChunks || [];
          this._loaded = 0;
          for (var _i = 0, _h = this._queuedChunks; _i < _h.length; _i++) {
              var chunk = _h[_i];
              this._loaded += chunk.byteLength;
          }
          this._requests = [];
          this._headersReady = Promise.resolve();
          stream._fullRequestReader = this;
          this.onProgress = null;
      }
      PDFDataTransportStreamReader.prototype._enqueue = function (chunk) {
          if (this._done) {
              return;
          }
          if (this._requests.length > 0) {
              var requestCapability = this._requests.shift();
              requestCapability.resolve({
                  value: chunk,
                  done: false
              });
          }
          else {
              this._queuedChunks.push(chunk);
          }
          this._loaded += chunk.byteLength;
      };
      Object.defineProperty(PDFDataTransportStreamReader.prototype, "headersReady", {
          get: function () {
              return this._headersReady;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDataTransportStreamReader.prototype, "filename", {
          get: function () {
              return this._filename;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDataTransportStreamReader.prototype, "isRangeSupported", {
          get: function () {
              return this._stream._isRangeSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDataTransportStreamReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._stream._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDataTransportStreamReader.prototype, "contentLength", {
          get: function () {
              return this._stream._contentLength;
          },
          enumerable: false,
          configurable: true
      });
      PDFDataTransportStreamReader.prototype.read = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, requestCapability;
              return tslib_1.__generator(this, function (_h) {
                  if (this._queuedChunks.length > 0) {
                      chunk = this._queuedChunks.shift();
                      return [2 /*return*/, {
                              value: chunk,
                              done: false
                          }];
                  }
                  if (this._done) {
                      return [2 /*return*/, {
                              value: undefined,
                              done: true
                          }];
                  }
                  requestCapability = Promise.withResolvers();
                  this._requests.push(requestCapability);
                  return [2 /*return*/, requestCapability.promise];
              });
          });
      };
      PDFDataTransportStreamReader.prototype.cancel = function (reason) {
          this._done = true;
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
      };
      PDFDataTransportStreamReader.prototype.progressiveDone = function () {
          if (this._done) {
              return;
          }
          this._done = true;
      };
      return PDFDataTransportStreamReader;
  }());
  var PDFDataTransportStreamRangeReader = /** @class */ (function () {
      function PDFDataTransportStreamRangeReader(stream, begin, end) {
          this._stream = stream;
          this._begin = begin;
          this._end = end;
          this._queuedChunk = null;
          this._requests = [];
          this._done = false;
          this.onProgress = null;
      }
      PDFDataTransportStreamRangeReader.prototype._enqueue = function (chunk) {
          if (this._done) {
              return;
          }
          if (this._requests.length === 0) {
              this._queuedChunk = chunk;
          }
          else {
              var requestsCapability = this._requests.shift();
              requestsCapability.resolve({
                  value: chunk,
                  done: false
              });
              for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
                  var requestCapability = _h[_i];
                  requestCapability.resolve({
                      value: undefined,
                      done: true
                  });
              }
              this._requests.length = 0;
          }
          this._done = true;
          this._stream._removeRangeReader(this);
      };
      Object.defineProperty(PDFDataTransportStreamRangeReader.prototype, "isStreamingSupported", {
          get: function () {
              return false;
          },
          enumerable: false,
          configurable: true
      });
      PDFDataTransportStreamRangeReader.prototype.read = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, requestCapability;
              return tslib_1.__generator(this, function (_h) {
                  if (this._queuedChunk) {
                      chunk = this._queuedChunk;
                      this._queuedChunk = null;
                      return [2 /*return*/, {
                              value: chunk,
                              done: false
                          }];
                  }
                  if (this._done) {
                      return [2 /*return*/, {
                              value: undefined,
                              done: true
                          }];
                  }
                  requestCapability = Promise.withResolvers();
                  this._requests.push(requestCapability);
                  return [2 /*return*/, requestCapability.promise];
              });
          });
      };
      PDFDataTransportStreamRangeReader.prototype.cancel = function (reason) {
          this._done = true;
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
          this._stream._removeRangeReader(this);
      };
      return PDFDataTransportStreamRangeReader;
  }());
  ; // CONCATENATED MODULE: ./src/display/content_disposition.js
  function getFilenameFromContentDispositionHeader(contentDisposition) {
      var needsEncodingFixup = true;
      var tmp = toParamRegExp("filename\\*", "i").exec(contentDisposition);
      if (tmp) {
          tmp = tmp[1];
          var filename = rfc2616unquote(tmp);
          filename = unescape(filename);
          filename = rfc5987decode(filename);
          filename = rfc2047decode(filename);
          return fixupEncoding(filename);
      }
      tmp = rfc2231getparam(contentDisposition);
      if (tmp) {
          var filename = rfc2047decode(tmp);
          return fixupEncoding(filename);
      }
      tmp = toParamRegExp("filename", "i").exec(contentDisposition);
      if (tmp) {
          tmp = tmp[1];
          var filename = rfc2616unquote(tmp);
          filename = rfc2047decode(filename);
          return fixupEncoding(filename);
      }
      function toParamRegExp(attributePattern, flags) {
          return new RegExp("(?:^|;)\\s*" + attributePattern + "\\s*=\\s*" + "(" + '[^";\\s][^;\\s]*' + "|" + '"(?:[^"\\\\]|\\\\"?)+"?' + ")", flags);
      }
      function textdecode(encoding, value) {
          if (encoding) {
              if (!/^[\x00-\xFF]+$/.test(value)) {
                  return value;
              }
              try {
                  var decoder = new TextDecoder(encoding, {
                      fatal: true
                  });
                  var buffer = stringToBytes(value);
                  value = decoder.decode(buffer);
                  needsEncodingFixup = false;
              }
              catch (_h) { }
          }
          return value;
      }
      function fixupEncoding(value) {
          if (needsEncodingFixup && /[\x80-\xff]/.test(value)) {
              value = textdecode("utf-8", value);
              if (needsEncodingFixup) {
                  value = textdecode("iso-8859-1", value);
              }
          }
          return value;
      }
      function rfc2231getparam(contentDispositionStr) {
          var matches = [];
          var match;
          var iter = toParamRegExp("filename\\*((?!0\\d)\\d+)(\\*?)", "ig");
          while ((match = iter.exec(contentDispositionStr)) !== null) {
              var n = match[1], quot = match[2], part = match[3];
              n = parseInt(n, 10);
              if (n in matches) {
                  if (n === 0) {
                      break;
                  }
                  continue;
              }
              matches[n] = [quot, part];
          }
          var parts = [];
          for (var n = 0; n < matches.length; ++n) {
              if (!(n in matches)) {
                  break;
              }
              var _h = matches[n], quot = _h[0], part = _h[1];
              part = rfc2616unquote(part);
              if (quot) {
                  part = unescape(part);
                  if (n === 0) {
                      part = rfc5987decode(part);
                  }
              }
              parts.push(part);
          }
          return parts.join("");
      }
      function rfc2616unquote(value) {
          if (value.startsWith('"')) {
              var parts = value.slice(1).split('\\"');
              for (var i = 0; i < parts.length; ++i) {
                  var quotindex = parts[i].indexOf('"');
                  if (quotindex !== -1) {
                      parts[i] = parts[i].slice(0, quotindex);
                      parts.length = i + 1;
                  }
                  parts[i] = parts[i].replaceAll(/\\(.)/g, "$1");
              }
              value = parts.join('"');
          }
          return value;
      }
      function rfc5987decode(extvalue) {
          var encodingend = extvalue.indexOf("'");
          if (encodingend === -1) {
              return extvalue;
          }
          var encoding = extvalue.slice(0, encodingend);
          var langvalue = extvalue.slice(encodingend + 1);
          var value = langvalue.replace(/^[^']*'/, "");
          return textdecode(encoding, value);
      }
      function rfc2047decode(value) {
          if (!value.startsWith("=?") || /[\x00-\x19\x80-\xff]/.test(value)) {
              return value;
          }
          return value.replaceAll(/=\?([\w-]*)\?([QqBb])\?((?:[^?]|\?(?!=))*)\?=/g, function (matches, charset, encoding, text) {
              if (encoding === "q" || encoding === "Q") {
                  text = text.replaceAll("_", " ");
                  text = text.replaceAll(/=([0-9a-fA-F]{2})/g, function (match, hex) {
                      return String.fromCharCode(parseInt(hex, 16));
                  });
                  return textdecode(charset, text);
              }
              try {
                  text = atob(text);
              }
              catch (_h) { }
              return textdecode(charset, text);
          });
      }
      return "";
  }
  ; // CONCATENATED MODULE: ./src/display/network_utils.js
  function validateRangeRequestCapabilities(_h) {
      var getResponseHeader = _h.getResponseHeader, isHttp = _h.isHttp, rangeChunkSize = _h.rangeChunkSize, disableRange = _h.disableRange;
      var returnValues = {
          allowRangeRequests: false,
          suggestedLength: undefined
      };
      var length = parseInt(getResponseHeader("Content-Length"), 10);
      if (!Number.isInteger(length)) {
          return returnValues;
      }
      returnValues.suggestedLength = length;
      if (length <= 2 * rangeChunkSize) {
          return returnValues;
      }
      if (disableRange || !isHttp) {
          return returnValues;
      }
      if (getResponseHeader("Accept-Ranges") !== "bytes") {
          return returnValues;
      }
      var contentEncoding = getResponseHeader("Content-Encoding") || "identity";
      if (contentEncoding !== "identity") {
          return returnValues;
      }
      returnValues.allowRangeRequests = true;
      return returnValues;
  }
  function extractFilenameFromHeader(getResponseHeader) {
      var contentDisposition = getResponseHeader("Content-Disposition");
      if (contentDisposition) {
          var filename = getFilenameFromContentDispositionHeader(contentDisposition);
          if (filename.includes("%")) {
              try {
                  filename = decodeURIComponent(filename);
              }
              catch (_h) { }
          }
          if (isPdfFile(filename)) {
              return filename;
          }
      }
      return null;
  }
  function createResponseStatusError(status, url) {
      if (status === 404 || status === 0 && url.startsWith("file:")) {
          return new MissingPDFException('Missing PDF "' + url + '".');
      }
      return new UnexpectedResponseException("Unexpected server response (".concat(status, ") while retrieving PDF \"").concat(url, "\"."), status);
  }
  function validateResponseStatus(status) {
      return status === 200 || status === 206;
  }
  ; // CONCATENATED MODULE: ./src/display/fetch_stream.js
  function createFetchOptions(headers, withCredentials, abortController) {
      return {
          method: "GET",
          headers: headers,
          signal: abortController.signal,
          mode: "cors",
          credentials: withCredentials ? "include" : "same-origin",
          redirect: "follow"
      };
  }
  function createHeaders(httpHeaders) {
      var headers = new Headers();
      for (var property in httpHeaders) {
          var value = httpHeaders[property];
          if (value === undefined) {
              continue;
          }
          headers.append(property, value);
      }
      return headers;
  }
  function getArrayBuffer(val) {
      if (val instanceof Uint8Array) {
          return val.buffer;
      }
      if (val instanceof ArrayBuffer) {
          return val;
      }
      warn("getArrayBuffer - unexpected data format: ".concat(val));
      return new Uint8Array(val).buffer;
  }
  var PDFFetchStream = /** @class */ (function () {
      function PDFFetchStream(source) {
          this.source = source;
          this.isHttp = /^https?:/i.test(source.url);
          this.httpHeaders = this.isHttp && source.httpHeaders || {};
          this._fullRequestReader = null;
          this._rangeRequestReaders = [];
      }
      Object.defineProperty(PDFFetchStream.prototype, "_progressiveDataLength", {
          get: function () {
              var _h, _j;
              return (_j = (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h._loaded) !== null && _j !== void 0 ? _j : 0;
          },
          enumerable: false,
          configurable: true
      });
      PDFFetchStream.prototype.getFullReader = function () {
          assert(!this._fullRequestReader, "PDFFetchStream.getFullReader can only be called once.");
          this._fullRequestReader = new PDFFetchStreamReader(this);
          return this._fullRequestReader;
      };
      PDFFetchStream.prototype.getRangeReader = function (begin, end) {
          if (end <= this._progressiveDataLength) {
              return null;
          }
          var reader = new PDFFetchStreamRangeReader(this, begin, end);
          this._rangeRequestReaders.push(reader);
          return reader;
      };
      PDFFetchStream.prototype.cancelAllRequests = function (reason) {
          var _h;
          (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          for (var _i = 0, _j = this._rangeRequestReaders.slice(0); _i < _j.length; _i++) {
              var reader = _j[_i];
              reader.cancel(reason);
          }
      };
      return PDFFetchStream;
  }());
  var PDFFetchStreamReader = /** @class */ (function () {
      function PDFFetchStreamReader(stream) {
          var _this = this;
          this._stream = stream;
          this._reader = null;
          this._loaded = 0;
          this._filename = null;
          var source = stream.source;
          this._withCredentials = source.withCredentials || false;
          this._contentLength = source.length;
          this._headersCapability = Promise.withResolvers();
          this._disableRange = source.disableRange || false;
          this._rangeChunkSize = source.rangeChunkSize;
          if (!this._rangeChunkSize && !this._disableRange) {
              this._disableRange = true;
          }
          this._abortController = new AbortController();
          this._isStreamingSupported = !source.disableStream;
          this._isRangeSupported = !source.disableRange;
          this._headers = createHeaders(this._stream.httpHeaders);
          var url = source.url;
          fetch(url, createFetchOptions(this._headers, this._withCredentials, this._abortController)).then(function (response) {
              if (!validateResponseStatus(response.status)) {
                  throw createResponseStatusError(response.status, url);
              }
              _this._reader = response.body.getReader();
              _this._headersCapability.resolve();
              var getResponseHeader = function (name) { return response.headers.get(name); };
              var _h = validateRangeRequestCapabilities({
                  getResponseHeader: getResponseHeader,
                  isHttp: _this._stream.isHttp,
                  rangeChunkSize: _this._rangeChunkSize,
                  disableRange: _this._disableRange
              }), allowRangeRequests = _h.allowRangeRequests, suggestedLength = _h.suggestedLength;
              _this._isRangeSupported = allowRangeRequests;
              _this._contentLength = suggestedLength || _this._contentLength;
              _this._filename = extractFilenameFromHeader(getResponseHeader);
              if (!_this._isStreamingSupported && _this._isRangeSupported) {
                  _this.cancel(new AbortException("Streaming is disabled."));
              }
          }).catch(this._headersCapability.reject);
          this.onProgress = null;
      }
      Object.defineProperty(PDFFetchStreamReader.prototype, "headersReady", {
          get: function () {
              return this._headersCapability.promise;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFFetchStreamReader.prototype, "filename", {
          get: function () {
              return this._filename;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFFetchStreamReader.prototype, "contentLength", {
          get: function () {
              return this._contentLength;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFFetchStreamReader.prototype, "isRangeSupported", {
          get: function () {
              return this._isRangeSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFFetchStreamReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      PDFFetchStreamReader.prototype.read = function () {
          var _h;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var _j, value, done;
              return tslib_1.__generator(this, function (_k) {
                  switch (_k.label) {
                      case 0: return [4 /*yield*/, this._headersCapability.promise];
                      case 1:
                          _k.sent();
                          return [4 /*yield*/, this._reader.read()];
                      case 2:
                          _j = _k.sent(), value = _j.value, done = _j.done;
                          if (done) {
                              return [2 /*return*/, {
                                      value: value,
                                      done: done
                                  }];
                          }
                          this._loaded += value.byteLength;
                          (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
                              loaded: this._loaded,
                              total: this._contentLength
                          });
                          return [2 /*return*/, {
                                  value: getArrayBuffer(value),
                                  done: false
                              }];
                  }
              });
          });
      };
      PDFFetchStreamReader.prototype.cancel = function (reason) {
          var _h;
          (_h = this._reader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          this._abortController.abort();
      };
      return PDFFetchStreamReader;
  }());
  var PDFFetchStreamRangeReader = /** @class */ (function () {
      function PDFFetchStreamRangeReader(stream, begin, end) {
          var _this = this;
          this._stream = stream;
          this._reader = null;
          this._loaded = 0;
          var source = stream.source;
          this._withCredentials = source.withCredentials || false;
          this._readCapability = Promise.withResolvers();
          this._isStreamingSupported = !source.disableStream;
          this._abortController = new AbortController();
          this._headers = createHeaders(this._stream.httpHeaders);
          this._headers.append("Range", "bytes=".concat(begin, "-").concat(end - 1));
          var url = source.url;
          fetch(url, createFetchOptions(this._headers, this._withCredentials, this._abortController)).then(function (response) {
              if (!validateResponseStatus(response.status)) {
                  throw createResponseStatusError(response.status, url);
              }
              _this._readCapability.resolve();
              _this._reader = response.body.getReader();
          }).catch(this._readCapability.reject);
          this.onProgress = null;
      }
      Object.defineProperty(PDFFetchStreamRangeReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      PDFFetchStreamRangeReader.prototype.read = function () {
          var _h;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var _j, value, done;
              return tslib_1.__generator(this, function (_k) {
                  switch (_k.label) {
                      case 0: return [4 /*yield*/, this._readCapability.promise];
                      case 1:
                          _k.sent();
                          return [4 /*yield*/, this._reader.read()];
                      case 2:
                          _j = _k.sent(), value = _j.value, done = _j.done;
                          if (done) {
                              return [2 /*return*/, {
                                      value: value,
                                      done: done
                                  }];
                          }
                          this._loaded += value.byteLength;
                          (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
                              loaded: this._loaded
                          });
                          return [2 /*return*/, {
                                  value: getArrayBuffer(value),
                                  done: false
                              }];
                  }
              });
          });
      };
      PDFFetchStreamRangeReader.prototype.cancel = function (reason) {
          var _h;
          (_h = this._reader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          this._abortController.abort();
      };
      return PDFFetchStreamRangeReader;
  }());
  ; // CONCATENATED MODULE: ./src/display/network.js
  var OK_RESPONSE = 200;
  var PARTIAL_CONTENT_RESPONSE = 206;
  function network_getArrayBuffer(xhr) {
      var data = xhr.response;
      if (typeof data !== "string") {
          return data;
      }
      return stringToBytes(data).buffer;
  }
  var NetworkManager = /** @class */ (function () {
      function NetworkManager(url, args) {
          if (args === void 0) { args = {}; }
          this.url = url;
          this.isHttp = /^https?:/i.test(url);
          this.httpHeaders = this.isHttp && args.httpHeaders || Object.create(null);
          this.withCredentials = args.withCredentials || false;
          this.currXhrId = 0;
          this.pendingRequests = Object.create(null);
      }
      NetworkManager.prototype.requestRange = function (begin, end, listeners) {
          var args = {
              begin: begin,
              end: end
          };
          for (var prop in listeners) {
              args[prop] = listeners[prop];
          }
          return this.request(args);
      };
      NetworkManager.prototype.requestFull = function (listeners) {
          return this.request(listeners);
      };
      NetworkManager.prototype.request = function (args) {
          var xhr = new XMLHttpRequest();
          var xhrId = this.currXhrId++;
          var pendingRequest = this.pendingRequests[xhrId] = {
              xhr: xhr
          };
          xhr.open("GET", this.url);
          xhr.withCredentials = this.withCredentials;
          for (var property in this.httpHeaders) {
              var value = this.httpHeaders[property];
              if (value === undefined) {
                  continue;
              }
              xhr.setRequestHeader(property, value);
          }
          if (this.isHttp && "begin" in args && "end" in args) {
              xhr.setRequestHeader("Range", "bytes=".concat(args.begin, "-").concat(args.end - 1));
              pendingRequest.expectedStatus = PARTIAL_CONTENT_RESPONSE;
          }
          else {
              pendingRequest.expectedStatus = OK_RESPONSE;
          }
          xhr.responseType = "arraybuffer";
          if (args.onError) {
              xhr.onerror = function (evt) {
                  args.onError(xhr.status);
              };
          }
          xhr.onreadystatechange = this.onStateChange.bind(this, xhrId);
          xhr.onprogress = this.onProgress.bind(this, xhrId);
          pendingRequest.onHeadersReceived = args.onHeadersReceived;
          pendingRequest.onDone = args.onDone;
          pendingRequest.onError = args.onError;
          pendingRequest.onProgress = args.onProgress;
          xhr.send(null);
          return xhrId;
      };
      NetworkManager.prototype.onProgress = function (xhrId, evt) {
          var _h;
          var pendingRequest = this.pendingRequests[xhrId];
          if (!pendingRequest) {
              return;
          }
          (_h = pendingRequest.onProgress) === null || _h === void 0 ? void 0 : _h.call(pendingRequest, evt);
      };
      NetworkManager.prototype.onStateChange = function (xhrId, evt) {
          var _h, _j, _k;
          var pendingRequest = this.pendingRequests[xhrId];
          if (!pendingRequest) {
              return;
          }
          var xhr = pendingRequest.xhr;
          if (xhr.readyState >= 2 && pendingRequest.onHeadersReceived) {
              pendingRequest.onHeadersReceived();
              delete pendingRequest.onHeadersReceived;
          }
          if (xhr.readyState !== 4) {
              return;
          }
          if (!(xhrId in this.pendingRequests)) {
              return;
          }
          delete this.pendingRequests[xhrId];
          if (xhr.status === 0 && this.isHttp) {
              (_h = pendingRequest.onError) === null || _h === void 0 ? void 0 : _h.call(pendingRequest, xhr.status);
              return;
          }
          var xhrStatus = xhr.status || OK_RESPONSE;
          var ok_response_on_range_request = xhrStatus === OK_RESPONSE && pendingRequest.expectedStatus === PARTIAL_CONTENT_RESPONSE;
          if (!ok_response_on_range_request && xhrStatus !== pendingRequest.expectedStatus) {
              (_j = pendingRequest.onError) === null || _j === void 0 ? void 0 : _j.call(pendingRequest, xhr.status);
              return;
          }
          var chunk = network_getArrayBuffer(xhr);
          if (xhrStatus === PARTIAL_CONTENT_RESPONSE) {
              var rangeHeader = xhr.getResponseHeader("Content-Range");
              var matches = /bytes (\d+)-(\d+)\/(\d+)/.exec(rangeHeader);
              pendingRequest.onDone({
                  begin: parseInt(matches[1], 10),
                  chunk: chunk
              });
          }
          else if (chunk) {
              pendingRequest.onDone({
                  begin: 0,
                  chunk: chunk
              });
          }
          else {
              (_k = pendingRequest.onError) === null || _k === void 0 ? void 0 : _k.call(pendingRequest, xhr.status);
          }
      };
      NetworkManager.prototype.getRequestXhr = function (xhrId) {
          return this.pendingRequests[xhrId].xhr;
      };
      NetworkManager.prototype.isPendingRequest = function (xhrId) {
          return xhrId in this.pendingRequests;
      };
      NetworkManager.prototype.abortRequest = function (xhrId) {
          var xhr = this.pendingRequests[xhrId].xhr;
          delete this.pendingRequests[xhrId];
          xhr.abort();
      };
      return NetworkManager;
  }());
  var PDFNetworkStream = /** @class */ (function () {
      function PDFNetworkStream(source) {
          this._source = source;
          this._manager = new NetworkManager(source.url, {
              httpHeaders: source.httpHeaders,
              withCredentials: source.withCredentials
          });
          this._rangeChunkSize = source.rangeChunkSize;
          this._fullRequestReader = null;
          this._rangeRequestReaders = [];
      }
      PDFNetworkStream.prototype._onRangeRequestReaderClosed = function (reader) {
          var i = this._rangeRequestReaders.indexOf(reader);
          if (i >= 0) {
              this._rangeRequestReaders.splice(i, 1);
          }
      };
      PDFNetworkStream.prototype.getFullReader = function () {
          assert(!this._fullRequestReader, "PDFNetworkStream.getFullReader can only be called once.");
          this._fullRequestReader = new PDFNetworkStreamFullRequestReader(this._manager, this._source);
          return this._fullRequestReader;
      };
      PDFNetworkStream.prototype.getRangeReader = function (begin, end) {
          var reader = new PDFNetworkStreamRangeRequestReader(this._manager, begin, end);
          reader.onClosed = this._onRangeRequestReaderClosed.bind(this);
          this._rangeRequestReaders.push(reader);
          return reader;
      };
      PDFNetworkStream.prototype.cancelAllRequests = function (reason) {
          var _h;
          (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          for (var _i = 0, _j = this._rangeRequestReaders.slice(0); _i < _j.length; _i++) {
              var reader = _j[_i];
              reader.cancel(reason);
          }
      };
      return PDFNetworkStream;
  }());
  var PDFNetworkStreamFullRequestReader = /** @class */ (function () {
      function PDFNetworkStreamFullRequestReader(manager, source) {
          this._manager = manager;
          var args = {
              onHeadersReceived: this._onHeadersReceived.bind(this),
              onDone: this._onDone.bind(this),
              onError: this._onError.bind(this),
              onProgress: this._onProgress.bind(this)
          };
          this._url = source.url;
          this._fullRequestId = manager.requestFull(args);
          this._headersReceivedCapability = Promise.withResolvers();
          this._disableRange = source.disableRange || false;
          this._contentLength = source.length;
          this._rangeChunkSize = source.rangeChunkSize;
          if (!this._rangeChunkSize && !this._disableRange) {
              this._disableRange = true;
          }
          this._isStreamingSupported = false;
          this._isRangeSupported = false;
          this._cachedChunks = [];
          this._requests = [];
          this._done = false;
          this._storedError = undefined;
          this._filename = null;
          this.onProgress = null;
      }
      PDFNetworkStreamFullRequestReader.prototype._onHeadersReceived = function () {
          var fullRequestXhrId = this._fullRequestId;
          var fullRequestXhr = this._manager.getRequestXhr(fullRequestXhrId);
          var getResponseHeader = function (name) { return fullRequestXhr.getResponseHeader(name); };
          var _h = validateRangeRequestCapabilities({
              getResponseHeader: getResponseHeader,
              isHttp: this._manager.isHttp,
              rangeChunkSize: this._rangeChunkSize,
              disableRange: this._disableRange
          }), allowRangeRequests = _h.allowRangeRequests, suggestedLength = _h.suggestedLength;
          if (allowRangeRequests) {
              this._isRangeSupported = true;
          }
          this._contentLength = suggestedLength || this._contentLength;
          this._filename = extractFilenameFromHeader(getResponseHeader);
          if (this._isRangeSupported) {
              this._manager.abortRequest(fullRequestXhrId);
          }
          this._headersReceivedCapability.resolve();
      };
      PDFNetworkStreamFullRequestReader.prototype._onDone = function (data) {
          if (data) {
              if (this._requests.length > 0) {
                  var requestCapability = this._requests.shift();
                  requestCapability.resolve({
                      value: data.chunk,
                      done: false
                  });
              }
              else {
                  this._cachedChunks.push(data.chunk);
              }
          }
          this._done = true;
          if (this._cachedChunks.length > 0) {
              return;
          }
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
      };
      PDFNetworkStreamFullRequestReader.prototype._onError = function (status) {
          this._storedError = createResponseStatusError(status, this._url);
          this._headersReceivedCapability.reject(this._storedError);
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.reject(this._storedError);
          }
          this._requests.length = 0;
          this._cachedChunks.length = 0;
      };
      PDFNetworkStreamFullRequestReader.prototype._onProgress = function (evt) {
          var _h;
          (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
              loaded: evt.loaded,
              total: evt.lengthComputable ? evt.total : this._contentLength
          });
      };
      Object.defineProperty(PDFNetworkStreamFullRequestReader.prototype, "filename", {
          get: function () {
              return this._filename;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFNetworkStreamFullRequestReader.prototype, "isRangeSupported", {
          get: function () {
              return this._isRangeSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFNetworkStreamFullRequestReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFNetworkStreamFullRequestReader.prototype, "contentLength", {
          get: function () {
              return this._contentLength;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFNetworkStreamFullRequestReader.prototype, "headersReady", {
          get: function () {
              return this._headersReceivedCapability.promise;
          },
          enumerable: false,
          configurable: true
      });
      PDFNetworkStreamFullRequestReader.prototype.read = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, requestCapability;
              return tslib_1.__generator(this, function (_h) {
                  if (this._storedError) {
                      throw this._storedError;
                  }
                  if (this._cachedChunks.length > 0) {
                      chunk = this._cachedChunks.shift();
                      return [2 /*return*/, {
                              value: chunk,
                              done: false
                          }];
                  }
                  if (this._done) {
                      return [2 /*return*/, {
                              value: undefined,
                              done: true
                          }];
                  }
                  requestCapability = Promise.withResolvers();
                  this._requests.push(requestCapability);
                  return [2 /*return*/, requestCapability.promise];
              });
          });
      };
      PDFNetworkStreamFullRequestReader.prototype.cancel = function (reason) {
          this._done = true;
          this._headersReceivedCapability.reject(reason);
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
          if (this._manager.isPendingRequest(this._fullRequestId)) {
              this._manager.abortRequest(this._fullRequestId);
          }
          this._fullRequestReader = null;
      };
      return PDFNetworkStreamFullRequestReader;
  }());
  var PDFNetworkStreamRangeRequestReader = /** @class */ (function () {
      function PDFNetworkStreamRangeRequestReader(manager, begin, end) {
          this._manager = manager;
          var args = {
              onDone: this._onDone.bind(this),
              onError: this._onError.bind(this),
              onProgress: this._onProgress.bind(this)
          };
          this._url = manager.url;
          this._requestId = manager.requestRange(begin, end, args);
          this._requests = [];
          this._queuedChunk = null;
          this._done = false;
          this._storedError = undefined;
          this.onProgress = null;
          this.onClosed = null;
      }
      PDFNetworkStreamRangeRequestReader.prototype._close = function () {
          var _h;
          (_h = this.onClosed) === null || _h === void 0 ? void 0 : _h.call(this, this);
      };
      PDFNetworkStreamRangeRequestReader.prototype._onDone = function (data) {
          var chunk = data.chunk;
          if (this._requests.length > 0) {
              var requestCapability = this._requests.shift();
              requestCapability.resolve({
                  value: chunk,
                  done: false
              });
          }
          else {
              this._queuedChunk = chunk;
          }
          this._done = true;
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
          this._close();
      };
      PDFNetworkStreamRangeRequestReader.prototype._onError = function (status) {
          this._storedError = createResponseStatusError(status, this._url);
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.reject(this._storedError);
          }
          this._requests.length = 0;
          this._queuedChunk = null;
      };
      PDFNetworkStreamRangeRequestReader.prototype._onProgress = function (evt) {
          var _h;
          if (!this.isStreamingSupported) {
              (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
                  loaded: evt.loaded
              });
          }
      };
      Object.defineProperty(PDFNetworkStreamRangeRequestReader.prototype, "isStreamingSupported", {
          get: function () {
              return false;
          },
          enumerable: false,
          configurable: true
      });
      PDFNetworkStreamRangeRequestReader.prototype.read = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, requestCapability;
              return tslib_1.__generator(this, function (_h) {
                  if (this._storedError) {
                      throw this._storedError;
                  }
                  if (this._queuedChunk !== null) {
                      chunk = this._queuedChunk;
                      this._queuedChunk = null;
                      return [2 /*return*/, {
                              value: chunk,
                              done: false
                          }];
                  }
                  if (this._done) {
                      return [2 /*return*/, {
                              value: undefined,
                              done: true
                          }];
                  }
                  requestCapability = Promise.withResolvers();
                  this._requests.push(requestCapability);
                  return [2 /*return*/, requestCapability.promise];
              });
          });
      };
      PDFNetworkStreamRangeRequestReader.prototype.cancel = function (reason) {
          this._done = true;
          for (var _i = 0, _h = this._requests; _i < _h.length; _i++) {
              var requestCapability = _h[_i];
              requestCapability.resolve({
                  value: undefined,
                  done: true
              });
          }
          this._requests.length = 0;
          if (this._manager.isPendingRequest(this._requestId)) {
              this._manager.abortRequest(this._requestId);
          }
          this._close();
      };
      return PDFNetworkStreamRangeRequestReader;
  }());
  ; // CONCATENATED MODULE: ./src/display/node_stream.js
  var fileUriRegex = /^file:\/\/\/[a-zA-Z]:\//;
  function parseUrl(sourceUrl) {
      var url = NodePackages.get("url");
      var parsedUrl = url.parse(sourceUrl);
      if (parsedUrl.protocol === "file:" || parsedUrl.host) {
          return parsedUrl;
      }
      if (/^[a-z]:[/\\]/i.test(sourceUrl)) {
          return url.parse("file:///".concat(sourceUrl));
      }
      if (!parsedUrl.host) {
          parsedUrl.protocol = "file:";
      }
      return parsedUrl;
  }
  var PDFNodeStream = /** @class */ (function () {
      function PDFNodeStream(source) {
          this.source = source;
          this.url = parseUrl(source.url);
          this.isHttp = this.url.protocol === "http:" || this.url.protocol === "https:";
          this.isFsUrl = this.url.protocol === "file:";
          this.httpHeaders = this.isHttp && source.httpHeaders || {};
          this._fullRequestReader = null;
          this._rangeRequestReaders = [];
      }
      Object.defineProperty(PDFNodeStream.prototype, "_progressiveDataLength", {
          get: function () {
              var _h, _j;
              return (_j = (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h._loaded) !== null && _j !== void 0 ? _j : 0;
          },
          enumerable: false,
          configurable: true
      });
      PDFNodeStream.prototype.getFullReader = function () {
          assert(!this._fullRequestReader, "PDFNodeStream.getFullReader can only be called once.");
          this._fullRequestReader = this.isFsUrl ? new PDFNodeStreamFsFullReader(this) : new PDFNodeStreamFullReader(this);
          return this._fullRequestReader;
      };
      PDFNodeStream.prototype.getRangeReader = function (start, end) {
          if (end <= this._progressiveDataLength) {
              return null;
          }
          var rangeReader = this.isFsUrl ? new PDFNodeStreamFsRangeReader(this, start, end) : new PDFNodeStreamRangeReader(this, start, end);
          this._rangeRequestReaders.push(rangeReader);
          return rangeReader;
      };
      PDFNodeStream.prototype.cancelAllRequests = function (reason) {
          var _h;
          (_h = this._fullRequestReader) === null || _h === void 0 ? void 0 : _h.cancel(reason);
          for (var _i = 0, _j = this._rangeRequestReaders.slice(0); _i < _j.length; _i++) {
              var reader = _j[_i];
              reader.cancel(reason);
          }
      };
      return PDFNodeStream;
  }());
  var BaseFullReader = /** @class */ (function () {
      function BaseFullReader(stream) {
          this._url = stream.url;
          this._done = false;
          this._storedError = null;
          this.onProgress = null;
          var source = stream.source;
          this._contentLength = source.length;
          this._loaded = 0;
          this._filename = null;
          this._disableRange = source.disableRange || false;
          this._rangeChunkSize = source.rangeChunkSize;
          if (!this._rangeChunkSize && !this._disableRange) {
              this._disableRange = true;
          }
          this._isStreamingSupported = !source.disableStream;
          this._isRangeSupported = !source.disableRange;
          this._readableStream = null;
          this._readCapability = Promise.withResolvers();
          this._headersCapability = Promise.withResolvers();
      }
      Object.defineProperty(BaseFullReader.prototype, "headersReady", {
          get: function () {
              return this._headersCapability.promise;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(BaseFullReader.prototype, "filename", {
          get: function () {
              return this._filename;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(BaseFullReader.prototype, "contentLength", {
          get: function () {
              return this._contentLength;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(BaseFullReader.prototype, "isRangeSupported", {
          get: function () {
              return this._isRangeSupported;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(BaseFullReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      BaseFullReader.prototype.read = function () {
          var _h;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, buffer;
              return tslib_1.__generator(this, function (_j) {
                  switch (_j.label) {
                      case 0: return [4 /*yield*/, this._readCapability.promise];
                      case 1:
                          _j.sent();
                          if (this._done) {
                              return [2 /*return*/, {
                                      value: undefined,
                                      done: true
                                  }];
                          }
                          if (this._storedError) {
                              throw this._storedError;
                          }
                          chunk = this._readableStream.read();
                          if (chunk === null) {
                              this._readCapability = Promise.withResolvers();
                              return [2 /*return*/, this.read()];
                          }
                          this._loaded += chunk.length;
                          (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
                              loaded: this._loaded,
                              total: this._contentLength
                          });
                          buffer = new Uint8Array(chunk).buffer;
                          return [2 /*return*/, {
                                  value: buffer,
                                  done: false
                              }];
                  }
              });
          });
      };
      BaseFullReader.prototype.cancel = function (reason) {
          if (!this._readableStream) {
              this._error(reason);
              return;
          }
          this._readableStream.destroy(reason);
      };
      BaseFullReader.prototype._error = function (reason) {
          this._storedError = reason;
          this._readCapability.resolve();
      };
      BaseFullReader.prototype._setReadableStream = function (readableStream) {
          var _this = this;
          this._readableStream = readableStream;
          readableStream.on("readable", function () {
              _this._readCapability.resolve();
          });
          readableStream.on("end", function () {
              readableStream.destroy();
              _this._done = true;
              _this._readCapability.resolve();
          });
          readableStream.on("error", function (reason) {
              _this._error(reason);
          });
          if (!this._isStreamingSupported && this._isRangeSupported) {
              this._error(new AbortException("streaming is disabled"));
          }
          if (this._storedError) {
              this._readableStream.destroy(this._storedError);
          }
      };
      return BaseFullReader;
  }());
  var BaseRangeReader = /** @class */ (function () {
      function BaseRangeReader(stream) {
          this._url = stream.url;
          this._done = false;
          this._storedError = null;
          this.onProgress = null;
          this._loaded = 0;
          this._readableStream = null;
          this._readCapability = Promise.withResolvers();
          var source = stream.source;
          this._isStreamingSupported = !source.disableStream;
      }
      Object.defineProperty(BaseRangeReader.prototype, "isStreamingSupported", {
          get: function () {
              return this._isStreamingSupported;
          },
          enumerable: false,
          configurable: true
      });
      BaseRangeReader.prototype.read = function () {
          var _h;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var chunk, buffer;
              return tslib_1.__generator(this, function (_j) {
                  switch (_j.label) {
                      case 0: return [4 /*yield*/, this._readCapability.promise];
                      case 1:
                          _j.sent();
                          if (this._done) {
                              return [2 /*return*/, {
                                      value: undefined,
                                      done: true
                                  }];
                          }
                          if (this._storedError) {
                              throw this._storedError;
                          }
                          chunk = this._readableStream.read();
                          if (chunk === null) {
                              this._readCapability = Promise.withResolvers();
                              return [2 /*return*/, this.read()];
                          }
                          this._loaded += chunk.length;
                          (_h = this.onProgress) === null || _h === void 0 ? void 0 : _h.call(this, {
                              loaded: this._loaded
                          });
                          buffer = new Uint8Array(chunk).buffer;
                          return [2 /*return*/, {
                                  value: buffer,
                                  done: false
                              }];
                  }
              });
          });
      };
      BaseRangeReader.prototype.cancel = function (reason) {
          if (!this._readableStream) {
              this._error(reason);
              return;
          }
          this._readableStream.destroy(reason);
      };
      BaseRangeReader.prototype._error = function (reason) {
          this._storedError = reason;
          this._readCapability.resolve();
      };
      BaseRangeReader.prototype._setReadableStream = function (readableStream) {
          var _this = this;
          this._readableStream = readableStream;
          readableStream.on("readable", function () {
              _this._readCapability.resolve();
          });
          readableStream.on("end", function () {
              readableStream.destroy();
              _this._done = true;
              _this._readCapability.resolve();
          });
          readableStream.on("error", function (reason) {
              _this._error(reason);
          });
          if (this._storedError) {
              this._readableStream.destroy(this._storedError);
          }
      };
      return BaseRangeReader;
  }());
  function createRequestOptions(parsedUrl, headers) {
      return {
          protocol: parsedUrl.protocol,
          auth: parsedUrl.auth,
          host: parsedUrl.hostname,
          port: parsedUrl.port,
          path: parsedUrl.path,
          method: "GET",
          headers: headers
      };
  }
  var PDFNodeStreamFullReader = /** @class */ (function (_super) {
      tslib_1.__extends(PDFNodeStreamFullReader, _super);
      function PDFNodeStreamFullReader(stream) {
          var _this = _super.call(this, stream) || this;
          var handleResponse = function (response) {
              if (response.statusCode === 404) {
                  var error = new MissingPDFException("Missing PDF \"".concat(_this._url, "\"."));
                  _this._storedError = error;
                  _this._headersCapability.reject(error);
                  return;
              }
              _this._headersCapability.resolve();
              _this._setReadableStream(response);
              var getResponseHeader = function (name) { return _this._readableStream.headers[name.toLowerCase()]; };
              var _h = validateRangeRequestCapabilities({
                  getResponseHeader: getResponseHeader,
                  isHttp: stream.isHttp,
                  rangeChunkSize: _this._rangeChunkSize,
                  disableRange: _this._disableRange
              }), allowRangeRequests = _h.allowRangeRequests, suggestedLength = _h.suggestedLength;
              _this._isRangeSupported = allowRangeRequests;
              _this._contentLength = suggestedLength || _this._contentLength;
              _this._filename = extractFilenameFromHeader(getResponseHeader);
          };
          _this._request = null;
          if (_this._url.protocol === "http:") {
              var http = NodePackages.get("http");
              _this._request = http.request(createRequestOptions(_this._url, stream.httpHeaders), handleResponse);
          }
          else {
              var https = NodePackages.get("https");
              _this._request = https.request(createRequestOptions(_this._url, stream.httpHeaders), handleResponse);
          }
          _this._request.on("error", function (reason) {
              _this._storedError = reason;
              _this._headersCapability.reject(reason);
          });
          _this._request.end();
          return _this;
      }
      return PDFNodeStreamFullReader;
  }(BaseFullReader));
  var PDFNodeStreamRangeReader = /** @class */ (function (_super) {
      tslib_1.__extends(PDFNodeStreamRangeReader, _super);
      function PDFNodeStreamRangeReader(stream, start, end) {
          var _this = _super.call(this, stream) || this;
          _this._httpHeaders = {};
          for (var property in stream.httpHeaders) {
              var value = stream.httpHeaders[property];
              if (value === undefined) {
                  continue;
              }
              _this._httpHeaders[property] = value;
          }
          _this._httpHeaders.Range = "bytes=".concat(start, "-").concat(end - 1);
          var handleResponse = function (response) {
              if (response.statusCode === 404) {
                  var error = new MissingPDFException("Missing PDF \"".concat(_this._url, "\"."));
                  _this._storedError = error;
                  return;
              }
              _this._setReadableStream(response);
          };
          _this._request = null;
          if (_this._url.protocol === "http:") {
              var http = NodePackages.get("http");
              _this._request = http.request(createRequestOptions(_this._url, _this._httpHeaders), handleResponse);
          }
          else {
              var https = NodePackages.get("https");
              _this._request = https.request(createRequestOptions(_this._url, _this._httpHeaders), handleResponse);
          }
          _this._request.on("error", function (reason) {
              _this._storedError = reason;
          });
          _this._request.end();
          return _this;
      }
      return PDFNodeStreamRangeReader;
  }(BaseRangeReader));
  var PDFNodeStreamFsFullReader = /** @class */ (function (_super) {
      tslib_1.__extends(PDFNodeStreamFsFullReader, _super);
      function PDFNodeStreamFsFullReader(stream) {
          var _this = _super.call(this, stream) || this;
          var path = decodeURIComponent(_this._url.path);
          if (fileUriRegex.test(_this._url.href)) {
              path = path.replace(/^\//, "");
          }
          var fs = NodePackages.get("fs");
          fs.promises.lstat(path).then(function (stat) {
              _this._contentLength = stat.size;
              _this._setReadableStream(fs.createReadStream(path));
              _this._headersCapability.resolve();
          }, function (error) {
              if (error.code === "ENOENT") {
                  error = new MissingPDFException("Missing PDF \"".concat(path, "\"."));
              }
              _this._storedError = error;
              _this._headersCapability.reject(error);
          });
          return _this;
      }
      return PDFNodeStreamFsFullReader;
  }(BaseFullReader));
  var PDFNodeStreamFsRangeReader = /** @class */ (function (_super) {
      tslib_1.__extends(PDFNodeStreamFsRangeReader, _super);
      function PDFNodeStreamFsRangeReader(stream, start, end) {
          var _this = _super.call(this, stream) || this;
          var path = decodeURIComponent(_this._url.path);
          if (fileUriRegex.test(_this._url.href)) {
              path = path.replace(/^\//, "");
          }
          var fs = NodePackages.get("fs");
          _this._setReadableStream(fs.createReadStream(path, {
              start: start,
              end: end - 1
          }));
          return _this;
      }
      return PDFNodeStreamFsRangeReader;
  }(BaseRangeReader));
  ; // CONCATENATED MODULE: ./src/display/text_layer.js
  var MAX_TEXT_DIVS_TO_RENDER = 100000;
  var DEFAULT_FONT_SIZE = 30;
  var DEFAULT_FONT_ASCENT = 0.8;
  var TextLayer = /** @class */ (function () {
      function TextLayer(_j) {
          var textContentSource = _j.textContentSource, container = _j.container, viewport = _j.viewport;
          var _this = this;
          var _k;
          _TextLayer_instances.add(this);
          _TextLayer_capability.set(this, Promise.withResolvers());
          _TextLayer_container.set(this, null);
          _TextLayer_disableProcessItems.set(this, false);
          _TextLayer_fontInspectorEnabled.set(this, !!((_k = globalThis.FontInspector) === null || _k === void 0 ? void 0 : _k.enabled));
          _TextLayer_lang.set(this, null);
          _TextLayer_layoutTextParams.set(this, null);
          _TextLayer_pageHeight.set(this, 0);
          _TextLayer_pageWidth.set(this, 0);
          _TextLayer_reader.set(this, null);
          _TextLayer_rootContainer.set(this, null);
          _TextLayer_rotation.set(this, 0);
          _TextLayer_scale.set(this, 0);
          _TextLayer_styleCache.set(this, Object.create(null));
          _TextLayer_textContentItemsStr.set(this, []);
          _TextLayer_textContentSource.set(this, null);
          _TextLayer_textDivs.set(this, []);
          _TextLayer_textDivProperties.set(this, new WeakMap());
          _TextLayer_transform.set(this, null);
          if (textContentSource instanceof ReadableStream) {
              tslib_1.__classPrivateFieldSet(this, _TextLayer_textContentSource, textContentSource, "f");
          }
          else if (typeof textContentSource === "object") {
              tslib_1.__classPrivateFieldSet(this, _TextLayer_textContentSource, new ReadableStream({
                  start: function (controller) {
                      controller.enqueue(textContentSource);
                      controller.close();
                  }
              }), "f");
          }
          else {
              throw new Error('No "textContentSource" parameter specified.');
          }
          tslib_1.__classPrivateFieldSet(this, _TextLayer_container, tslib_1.__classPrivateFieldSet(this, _TextLayer_rootContainer, container, "f"), "f");
          tslib_1.__classPrivateFieldSet(this, _TextLayer_scale, viewport.scale * (globalThis.devicePixelRatio || 1), "f");
          tslib_1.__classPrivateFieldSet(this, _TextLayer_rotation, viewport.rotation, "f");
          tslib_1.__classPrivateFieldSet(this, _TextLayer_layoutTextParams, {
              prevFontSize: null,
              prevFontFamily: null,
              div: null,
              properties: null,
              ctx: null
          }, "f");
          var _l = viewport.rawDims, pageWidth = _l.pageWidth, pageHeight = _l.pageHeight, pageX = _l.pageX, pageY = _l.pageY;
          tslib_1.__classPrivateFieldSet(this, _TextLayer_transform, [1, 0, 0, -1, -pageX, pageY + pageHeight], "f");
          tslib_1.__classPrivateFieldSet(this, _TextLayer_pageWidth, pageWidth, "f");
          tslib_1.__classPrivateFieldSet(this, _TextLayer_pageHeight, pageHeight, "f");
          setLayerDimensions(container, viewport);
          tslib_1.__classPrivateFieldGet(this, _TextLayer_capability, "f").promise.catch(function () { }).then(function () {
              tslib_1.__classPrivateFieldGet(TextLayer, _h, "f", _TextLayer_pendingTextLayers).delete(_this);
              tslib_1.__classPrivateFieldSet(_this, _TextLayer_layoutTextParams, null, "f");
              tslib_1.__classPrivateFieldSet(_this, _TextLayer_styleCache, null, "f");
          });
      }
      TextLayer.prototype.render = function () {
          var _this = this;
          var pump = function () {
              tslib_1.__classPrivateFieldGet(_this, _TextLayer_reader, "f").read().then(function (_j) {
                  var _k;
                  var value = _j.value, done = _j.done;
                  if (done) {
                      tslib_1.__classPrivateFieldGet(_this, _TextLayer_capability, "f").resolve();
                      return;
                  }
                  tslib_1.__classPrivateFieldSet(_this, _TextLayer_lang, (_k = tslib_1.__classPrivateFieldGet(_this, _TextLayer_lang, "f")) !== null && _k !== void 0 ? _k : value.lang, "f");
                  Object.assign(tslib_1.__classPrivateFieldGet(_this, _TextLayer_styleCache, "f"), value.styles);
                  tslib_1.__classPrivateFieldGet(_this, _TextLayer_instances, "m", _TextLayer_processItems).call(_this, value.items);
                  pump();
              }, tslib_1.__classPrivateFieldGet(_this, _TextLayer_capability, "f").reject);
          };
          tslib_1.__classPrivateFieldSet(this, _TextLayer_reader, tslib_1.__classPrivateFieldGet(this, _TextLayer_textContentSource, "f").getReader(), "f");
          tslib_1.__classPrivateFieldGet(TextLayer, _h, "f", _TextLayer_pendingTextLayers).add(this);
          pump();
          return tslib_1.__classPrivateFieldGet(this, _TextLayer_capability, "f").promise;
      };
      TextLayer.prototype.update = function (_j) {
          var viewport = _j.viewport, _k = _j.onBefore, onBefore = _k === void 0 ? null : _k;
          var scale = viewport.scale * (globalThis.devicePixelRatio || 1);
          var rotation = viewport.rotation;
          if (rotation !== tslib_1.__classPrivateFieldGet(this, _TextLayer_rotation, "f")) {
              onBefore === null || onBefore === void 0 ? void 0 : onBefore();
              tslib_1.__classPrivateFieldSet(this, _TextLayer_rotation, rotation, "f");
              setLayerDimensions(tslib_1.__classPrivateFieldGet(this, _TextLayer_rootContainer, "f"), {
                  rotation: rotation
              });
          }
          if (scale !== tslib_1.__classPrivateFieldGet(this, _TextLayer_scale, "f")) {
              onBefore === null || onBefore === void 0 ? void 0 : onBefore();
              tslib_1.__classPrivateFieldSet(this, _TextLayer_scale, scale, "f");
              var params = {
                  prevFontSize: null,
                  prevFontFamily: null,
                  div: null,
                  properties: null,
                  ctx: tslib_1.__classPrivateFieldGet(TextLayer, _h, "m", _TextLayer_getCtx).call(TextLayer, tslib_1.__classPrivateFieldGet(this, _TextLayer_lang, "f"))
              };
              for (var _i = 0, _l = tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivs, "f"); _i < _l.length; _i++) {
                  var div = _l[_i];
                  params.properties = tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivProperties, "f").get(div);
                  params.div = div;
                  tslib_1.__classPrivateFieldGet(this, _TextLayer_instances, "m", _TextLayer_layout).call(this, params);
              }
          }
      };
      TextLayer.prototype.cancel = function () {
          var _j;
          var abortEx = new AbortException("TextLayer task cancelled.");
          (_j = tslib_1.__classPrivateFieldGet(this, _TextLayer_reader, "f")) === null || _j === void 0 ? void 0 : _j.cancel(abortEx).catch(function () { });
          tslib_1.__classPrivateFieldSet(this, _TextLayer_reader, null, "f");
          tslib_1.__classPrivateFieldGet(this, _TextLayer_capability, "f").reject(abortEx);
      };
      Object.defineProperty(TextLayer.prototype, "textDivs", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivs, "f");
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(TextLayer.prototype, "textContentItemsStr", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _TextLayer_textContentItemsStr, "f");
          },
          enumerable: false,
          configurable: true
      });
      TextLayer.cleanup = function () {
          if (tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_pendingTextLayers).size > 0) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_ascentCache).clear();
          for (var _i = 0, _j = tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_canvasContexts).values(); _i < _j.length; _i++) {
              var canvas = _j[_i].canvas;
              canvas.remove();
          }
          tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_canvasContexts).clear();
      };
      var _TextLayer_instances, _h, _TextLayer_capability, _TextLayer_container, _TextLayer_disableProcessItems, _TextLayer_fontInspectorEnabled, _TextLayer_lang, _TextLayer_layoutTextParams, _TextLayer_pageHeight, _TextLayer_pageWidth, _TextLayer_reader, _TextLayer_rootContainer, _TextLayer_rotation, _TextLayer_scale, _TextLayer_styleCache, _TextLayer_textContentItemsStr, _TextLayer_textContentSource, _TextLayer_textDivs, _TextLayer_textDivProperties, _TextLayer_transform, _TextLayer_ascentCache, _TextLayer_canvasContexts, _TextLayer_pendingTextLayers, _TextLayer_processItems, _TextLayer_appendText, _TextLayer_layout, _TextLayer_getCtx, _TextLayer_getAscent;
      _h = TextLayer, _TextLayer_capability = new WeakMap(), _TextLayer_container = new WeakMap(), _TextLayer_disableProcessItems = new WeakMap(), _TextLayer_fontInspectorEnabled = new WeakMap(), _TextLayer_lang = new WeakMap(), _TextLayer_layoutTextParams = new WeakMap(), _TextLayer_pageHeight = new WeakMap(), _TextLayer_pageWidth = new WeakMap(), _TextLayer_reader = new WeakMap(), _TextLayer_rootContainer = new WeakMap(), _TextLayer_rotation = new WeakMap(), _TextLayer_scale = new WeakMap(), _TextLayer_styleCache = new WeakMap(), _TextLayer_textContentItemsStr = new WeakMap(), _TextLayer_textContentSource = new WeakMap(), _TextLayer_textDivs = new WeakMap(), _TextLayer_textDivProperties = new WeakMap(), _TextLayer_transform = new WeakMap(), _TextLayer_instances = new WeakSet(), _TextLayer_processItems = function _TextLayer_processItems(items) {
          var _j;
          if (tslib_1.__classPrivateFieldGet(this, _TextLayer_disableProcessItems, "f")) {
              return;
          }
          (_j = tslib_1.__classPrivateFieldGet(this, _TextLayer_layoutTextParams, "f")).ctx || (_j.ctx = tslib_1.__classPrivateFieldGet(TextLayer, _h, "m", _TextLayer_getCtx).call(TextLayer, tslib_1.__classPrivateFieldGet(this, _TextLayer_lang, "f")));
          var textDivs = tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivs, "f"), textContentItemsStr = tslib_1.__classPrivateFieldGet(this, _TextLayer_textContentItemsStr, "f");
          for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
              var item = items_1[_i];
              if (textDivs.length > MAX_TEXT_DIVS_TO_RENDER) {
                  warn("Ignoring additional textDivs for performance reasons.");
                  tslib_1.__classPrivateFieldSet(this, _TextLayer_disableProcessItems, true, "f");
                  return;
              }
              if (item.str === undefined) {
                  if (item.type === "beginMarkedContentProps" || item.type === "beginMarkedContent") {
                      var parent = tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f");
                      tslib_1.__classPrivateFieldSet(this, _TextLayer_container, document.createElement("span"), "f");
                      tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f").classList.add("markedContent");
                      if (item.id !== null) {
                          tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f").setAttribute("id", "".concat(item.id));
                      }
                      parent.append(tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f"));
                  }
                  else if (item.type === "endMarkedContent") {
                      tslib_1.__classPrivateFieldSet(this, _TextLayer_container, tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f").parentNode, "f");
                  }
                  continue;
              }
              textContentItemsStr.push(item.str);
              tslib_1.__classPrivateFieldGet(this, _TextLayer_instances, "m", _TextLayer_appendText).call(this, item);
          }
      }, _TextLayer_appendText = function _TextLayer_appendText(geom) {
          var textDiv = document.createElement("span");
          var textDivProperties = {
              angle: 0,
              canvasWidth: 0,
              hasText: geom.str !== "",
              hasEOL: geom.hasEOL,
              fontSize: 0
          };
          tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivs, "f").push(textDiv);
          var tx = Util.transform(tslib_1.__classPrivateFieldGet(this, _TextLayer_transform, "f"), geom.transform);
          var angle = Math.atan2(tx[1], tx[0]);
          var style = tslib_1.__classPrivateFieldGet(this, _TextLayer_styleCache, "f")[geom.fontName];
          if (style.vertical) {
              angle += Math.PI / 2;
          }
          var fontFamily = tslib_1.__classPrivateFieldGet(this, _TextLayer_fontInspectorEnabled, "f") && style.fontSubstitution || style.fontFamily;
          var fontHeight = Math.hypot(tx[2], tx[3]);
          var fontAscent = fontHeight * tslib_1.__classPrivateFieldGet(TextLayer, _h, "m", _TextLayer_getAscent).call(TextLayer, fontFamily, tslib_1.__classPrivateFieldGet(this, _TextLayer_lang, "f"));
          var left, top;
          if (angle === 0) {
              left = tx[4];
              top = tx[5] - fontAscent;
          }
          else {
              left = tx[4] + fontAscent * Math.sin(angle);
              top = tx[5] - fontAscent * Math.cos(angle);
          }
          var scaleFactorStr = "calc(var(--scale-factor)*";
          var divStyle = textDiv.style;
          if (tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f") === tslib_1.__classPrivateFieldGet(this, _TextLayer_rootContainer, "f")) {
              divStyle.left = "".concat((100 * left / tslib_1.__classPrivateFieldGet(this, _TextLayer_pageWidth, "f")).toFixed(2), "%");
              divStyle.top = "".concat((100 * top / tslib_1.__classPrivateFieldGet(this, _TextLayer_pageHeight, "f")).toFixed(2), "%");
          }
          else {
              divStyle.left = "".concat(scaleFactorStr).concat(left.toFixed(2), "px)");
              divStyle.top = "".concat(scaleFactorStr).concat(top.toFixed(2), "px)");
          }
          divStyle.fontSize = "".concat(scaleFactorStr).concat(fontHeight.toFixed(2), "px)");
          divStyle.fontFamily = fontFamily;
          textDivProperties.fontSize = fontHeight;
          textDiv.setAttribute("role", "presentation");
          textDiv.textContent = geom.str;
          textDiv.dir = geom.dir;
          if (tslib_1.__classPrivateFieldGet(this, _TextLayer_fontInspectorEnabled, "f")) {
              textDiv.dataset.fontName = style.fontSubstitutionLoadedName || geom.fontName;
          }
          if (angle !== 0) {
              textDivProperties.angle = angle * (180 / Math.PI);
          }
          var shouldScaleText = false;
          if (geom.str.length > 1) {
              shouldScaleText = true;
          }
          else if (geom.str !== " " && geom.transform[0] !== geom.transform[3]) {
              var absScaleX = Math.abs(geom.transform[0]), absScaleY = Math.abs(geom.transform[3]);
              if (absScaleX !== absScaleY && Math.max(absScaleX, absScaleY) / Math.min(absScaleX, absScaleY) > 1.5) {
                  shouldScaleText = true;
              }
          }
          if (shouldScaleText) {
              textDivProperties.canvasWidth = style.vertical ? geom.height : geom.width;
          }
          tslib_1.__classPrivateFieldGet(this, _TextLayer_textDivProperties, "f").set(textDiv, textDivProperties);
          tslib_1.__classPrivateFieldGet(this, _TextLayer_layoutTextParams, "f").div = textDiv;
          tslib_1.__classPrivateFieldGet(this, _TextLayer_layoutTextParams, "f").properties = textDivProperties;
          tslib_1.__classPrivateFieldGet(this, _TextLayer_instances, "m", _TextLayer_layout).call(this, tslib_1.__classPrivateFieldGet(this, _TextLayer_layoutTextParams, "f"));
          if (textDivProperties.hasText) {
              tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f").append(textDiv);
          }
          if (textDivProperties.hasEOL) {
              var br = document.createElement("br");
              br.setAttribute("role", "presentation");
              tslib_1.__classPrivateFieldGet(this, _TextLayer_container, "f").append(br);
          }
      }, _TextLayer_layout = function _TextLayer_layout(params) {
          var div = params.div, properties = params.properties, ctx = params.ctx, prevFontSize = params.prevFontSize, prevFontFamily = params.prevFontFamily;
          var style = div.style;
          var transform = "";
          if (properties.canvasWidth !== 0 && properties.hasText) {
              var fontFamily = style.fontFamily;
              var canvasWidth = properties.canvasWidth, fontSize = properties.fontSize;
              if (prevFontSize !== fontSize || prevFontFamily !== fontFamily) {
                  ctx.font = "".concat(fontSize * tslib_1.__classPrivateFieldGet(this, _TextLayer_scale, "f"), "px ").concat(fontFamily);
                  params.prevFontSize = fontSize;
                  params.prevFontFamily = fontFamily;
              }
              var width = ctx.measureText(div.textContent).width;
              if (width > 0) {
                  transform = "scaleX(".concat(canvasWidth * tslib_1.__classPrivateFieldGet(this, _TextLayer_scale, "f") / width, ")");
              }
          }
          if (properties.angle !== 0) {
              transform = "rotate(".concat(properties.angle, "deg) ").concat(transform);
          }
          if (transform.length > 0) {
              style.transform = transform;
          }
      }, _TextLayer_getCtx = function _TextLayer_getCtx(lang) {
          if (lang === void 0) { lang = null; }
          var canvasContext = tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_canvasContexts).get(lang || (lang = ""));
          if (!canvasContext) {
              var canvas = document.createElement("canvas");
              canvas.className = "hiddenCanvasElement";
              canvas.lang = lang;
              document.body.append(canvas);
              canvasContext = canvas.getContext("2d", {
                  alpha: false
              });
              tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_canvasContexts).set(lang, canvasContext);
          }
          return canvasContext;
      }, _TextLayer_getAscent = function _TextLayer_getAscent(fontFamily, lang) {
          var cachedAscent = tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_ascentCache).get(fontFamily);
          if (cachedAscent) {
              return cachedAscent;
          }
          var ctx = tslib_1.__classPrivateFieldGet(this, _h, "m", _TextLayer_getCtx).call(this, lang);
          var savedFont = ctx.font;
          ctx.canvas.width = ctx.canvas.height = DEFAULT_FONT_SIZE;
          ctx.font = "".concat(DEFAULT_FONT_SIZE, "px ").concat(fontFamily);
          var metrics = ctx.measureText("");
          var ascent = metrics.fontBoundingBoxAscent;
          var descent = Math.abs(metrics.fontBoundingBoxDescent);
          if (ascent) {
              var ratio_1 = ascent / (ascent + descent);
              tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_ascentCache).set(fontFamily, ratio_1);
              ctx.canvas.width = ctx.canvas.height = 0;
              ctx.font = savedFont;
              return ratio_1;
          }
          ctx.strokeStyle = "red";
          ctx.clearRect(0, 0, DEFAULT_FONT_SIZE, DEFAULT_FONT_SIZE);
          ctx.strokeText("g", 0, 0);
          var pixels = ctx.getImageData(0, 0, DEFAULT_FONT_SIZE, DEFAULT_FONT_SIZE).data;
          descent = 0;
          for (var i = pixels.length - 1 - 3; i >= 0; i -= 4) {
              if (pixels[i] > 0) {
                  descent = Math.ceil(i / 4 / DEFAULT_FONT_SIZE);
                  break;
              }
          }
          ctx.clearRect(0, 0, DEFAULT_FONT_SIZE, DEFAULT_FONT_SIZE);
          ctx.strokeText("A", 0, DEFAULT_FONT_SIZE);
          pixels = ctx.getImageData(0, 0, DEFAULT_FONT_SIZE, DEFAULT_FONT_SIZE).data;
          ascent = 0;
          for (var i = 0, ii = pixels.length; i < ii; i += 4) {
              if (pixels[i] > 0) {
                  ascent = DEFAULT_FONT_SIZE - Math.floor(i / 4 / DEFAULT_FONT_SIZE);
                  break;
              }
          }
          ctx.canvas.width = ctx.canvas.height = 0;
          ctx.font = savedFont;
          var ratio = ascent ? ascent / (ascent + descent) : DEFAULT_FONT_ASCENT;
          tslib_1.__classPrivateFieldGet(this, _h, "f", _TextLayer_ascentCache).set(fontFamily, ratio);
          return ratio;
      };
      _TextLayer_ascentCache = { value: new Map() };
      _TextLayer_canvasContexts = { value: new Map() };
      _TextLayer_pendingTextLayers = { value: new Set() };
      return TextLayer;
  }());
  function renderTextLayer() {
      deprecated("`renderTextLayer`, please use `TextLayer` instead.");
      var _j = arguments[0], textContentSource = _j.textContentSource, container = _j.container, viewport = _j.viewport, rest = tslib_1.__rest(_j, ["textContentSource", "container", "viewport"]);
      var restKeys = Object.keys(rest);
      if (restKeys.length > 0) {
          warn("Ignoring `renderTextLayer` parameters: " + restKeys.join(", "));
      }
      var textLayer = new TextLayer({
          textContentSource: textContentSource,
          container: container,
          viewport: viewport
      });
      var textDivs = textLayer.textDivs, textContentItemsStr = textLayer.textContentItemsStr;
      var promise = textLayer.render();
      return {
          promise: promise,
          textDivs: textDivs,
          textContentItemsStr: textContentItemsStr
      };
  }
  function updateTextLayer() {
      deprecated("`updateTextLayer`, please use `TextLayer` instead.");
  }
  ; // CONCATENATED MODULE: ./src/display/xfa_text.js
  var XfaText = /** @class */ (function () {
      function XfaText() {
      }
      XfaText.textContent = function (xfa) {
          var items = [];
          var output = {
              items: items,
              styles: Object.create(null)
          };
          function walk(node) {
              var _j;
              if (!node) {
                  return;
              }
              var str = null;
              var name = node.name;
              if (name === "#text") {
                  str = node.value;
              }
              else if (!XfaText.shouldBuildText(name)) {
                  return;
              }
              else if ((_j = node === null || node === void 0 ? void 0 : node.attributes) === null || _j === void 0 ? void 0 : _j.textContent) {
                  str = node.attributes.textContent;
              }
              else if (node.value) {
                  str = node.value;
              }
              if (str !== null) {
                  items.push({
                      str: str
                  });
              }
              if (!node.children) {
                  return;
              }
              for (var _i = 0, _k = node.children; _i < _k.length; _i++) {
                  var child = _k[_i];
                  walk(child);
              }
          }
          walk(xfa);
          return output;
      };
      XfaText.shouldBuildText = function (name) {
          return !(name === "textarea" || name === "input" || name === "option" || name === "select");
      };
      return XfaText;
  }());
  ; // CONCATENATED MODULE: ./src/display/api.js
  var DEFAULT_RANGE_CHUNK_SIZE = 65536;
  var RENDERING_CANCELLED_TIMEOUT = 100;
  var DELAYED_CLEANUP_TIMEOUT = 5000;
  var DefaultCanvasFactory = isNodeJS ? NodeCanvasFactory : DOMCanvasFactory;
  var DefaultCMapReaderFactory = isNodeJS ? NodeCMapReaderFactory : DOMCMapReaderFactory;
  var DefaultFilterFactory = isNodeJS ? NodeFilterFactory : DOMFilterFactory;
  var DefaultStandardFontDataFactory = isNodeJS ? NodeStandardFontDataFactory : DOMStandardFontDataFactory;
  function getDocument(src) {
      var _j, _k;
      if (typeof src === "string" || src instanceof URL) {
          src = {
              url: src
          };
      }
      else if (src instanceof ArrayBuffer || ArrayBuffer.isView(src)) {
          src = {
              data: src
          };
      }
      if (typeof src !== "object") {
          throw new Error("Invalid parameter in getDocument, need parameter object.");
      }
      if (!src.url && !src.data && !src.range) {
          throw new Error("Invalid parameter object: need either .data, .range or .url");
      }
      var task = new PDFDocumentLoadingTask();
      var docId = task.docId;
      var url = src.url ? getUrlProp(src.url) : null;
      var data = src.data ? getDataProp(src.data) : null;
      var httpHeaders = src.httpHeaders || null;
      var withCredentials = src.withCredentials === true;
      var password = (_j = src.password) !== null && _j !== void 0 ? _j : null;
      var rangeTransport = src.range instanceof PDFDataRangeTransport ? src.range : null;
      var rangeChunkSize = Number.isInteger(src.rangeChunkSize) && src.rangeChunkSize > 0 ? src.rangeChunkSize : DEFAULT_RANGE_CHUNK_SIZE;
      var worker = src.worker instanceof PDFWorker ? src.worker : null;
      var verbosity = src.verbosity;
      var docBaseUrl = typeof src.docBaseUrl === "string" && !isDataScheme(src.docBaseUrl) ? src.docBaseUrl : null;
      var cMapUrl = typeof src.cMapUrl === "string" ? src.cMapUrl : null;
      var cMapPacked = src.cMapPacked !== false;
      var CMapReaderFactory = src.CMapReaderFactory || DefaultCMapReaderFactory;
      var standardFontDataUrl = typeof src.standardFontDataUrl === "string" ? src.standardFontDataUrl : null;
      var StandardFontDataFactory = src.StandardFontDataFactory || DefaultStandardFontDataFactory;
      var ignoreErrors = src.stopAtErrors !== true;
      var maxImageSize = Number.isInteger(src.maxImageSize) && src.maxImageSize > -1 ? src.maxImageSize : -1;
      var isEvalSupported = src.isEvalSupported !== false;
      var isOffscreenCanvasSupported = typeof src.isOffscreenCanvasSupported === "boolean" ? src.isOffscreenCanvasSupported : !isNodeJS;
      var canvasMaxAreaInBytes = Number.isInteger(src.canvasMaxAreaInBytes) ? src.canvasMaxAreaInBytes : -1;
      var disableFontFace = typeof src.disableFontFace === "boolean" ? src.disableFontFace : isNodeJS;
      var fontExtraProperties = src.fontExtraProperties === true;
      var enableXfa = src.enableXfa === true;
      var ownerDocument = src.ownerDocument || globalThis.document;
      var disableRange = src.disableRange === true;
      var disableStream = src.disableStream === true;
      var disableAutoFetch = src.disableAutoFetch === true;
      var pdfBug = src.pdfBug === true;
      var length = rangeTransport ? rangeTransport.length : (_k = src.length) !== null && _k !== void 0 ? _k : NaN;
      var useSystemFonts = typeof src.useSystemFonts === "boolean" ? src.useSystemFonts : !isNodeJS && !disableFontFace;
      var useWorkerFetch = typeof src.useWorkerFetch === "boolean" ? src.useWorkerFetch : CMapReaderFactory === DOMCMapReaderFactory && StandardFontDataFactory === DOMStandardFontDataFactory && cMapUrl && standardFontDataUrl && isValidFetchUrl(cMapUrl, document.baseURI) && isValidFetchUrl(standardFontDataUrl, document.baseURI);
      var canvasFactory = src.canvasFactory || new DefaultCanvasFactory({
          ownerDocument: ownerDocument
      });
      var filterFactory = src.filterFactory || new DefaultFilterFactory({
          docId: docId,
          ownerDocument: ownerDocument
      });
      var styleElement = null;
      setVerbosityLevel(verbosity);
      var transportFactory = {
          canvasFactory: canvasFactory,
          filterFactory: filterFactory
      };
      if (!useWorkerFetch) {
          transportFactory.cMapReaderFactory = new CMapReaderFactory({
              baseUrl: cMapUrl,
              isCompressed: cMapPacked
          });
          transportFactory.standardFontDataFactory = new StandardFontDataFactory({
              baseUrl: standardFontDataUrl
          });
      }
      if (!worker) {
          var workerParams = {
              verbosity: verbosity,
              port: GlobalWorkerOptions.workerPort
          };
          worker = workerParams.port ? PDFWorker.fromPort(workerParams) : new PDFWorker(workerParams);
          task._worker = worker;
      }
      var docParams = {
          docId: docId,
          apiVersion: "4.3.136",
          data: data,
          password: password,
          disableAutoFetch: disableAutoFetch,
          rangeChunkSize: rangeChunkSize,
          length: length,
          docBaseUrl: docBaseUrl,
          enableXfa: enableXfa,
          evaluatorOptions: {
              maxImageSize: maxImageSize,
              disableFontFace: disableFontFace,
              ignoreErrors: ignoreErrors,
              isEvalSupported: isEvalSupported,
              isOffscreenCanvasSupported: isOffscreenCanvasSupported,
              canvasMaxAreaInBytes: canvasMaxAreaInBytes,
              fontExtraProperties: fontExtraProperties,
              useSystemFonts: useSystemFonts,
              cMapUrl: useWorkerFetch ? cMapUrl : null,
              standardFontDataUrl: useWorkerFetch ? standardFontDataUrl : null
          }
      };
      var transportParams = {
          disableFontFace: disableFontFace,
          fontExtraProperties: fontExtraProperties,
          ownerDocument: ownerDocument,
          pdfBug: pdfBug,
          styleElement: styleElement,
          loadingParams: {
              disableAutoFetch: disableAutoFetch,
              enableXfa: enableXfa
          }
      };
      worker.promise.then(function () {
          if (task.destroyed) {
              throw new Error("Loading aborted");
          }
          if (worker.destroyed) {
              throw new Error("Worker was destroyed");
          }
          var workerIdPromise = worker.messageHandler.sendWithPromise("GetDocRequest", docParams, data ? [data.buffer] : null);
          var networkStream;
          if (rangeTransport) {
              networkStream = new PDFDataTransportStream(rangeTransport, {
                  disableRange: disableRange,
                  disableStream: disableStream
              });
          }
          else if (!data) {
              var createPDFNetworkStream = function (params) {
                  if (isNodeJS) {
                      var isFetchSupported = function () {
                          return typeof fetch !== "undefined" && typeof Response !== "undefined" && "body" in Response.prototype;
                      };
                      return isFetchSupported() && isValidFetchUrl(params.url) ? new PDFFetchStream(params) : new PDFNodeStream(params);
                  }
                  return isValidFetchUrl(params.url) ? new PDFFetchStream(params) : new PDFNetworkStream(params);
              };
              networkStream = createPDFNetworkStream({
                  url: url,
                  length: length,
                  httpHeaders: httpHeaders,
                  withCredentials: withCredentials,
                  rangeChunkSize: rangeChunkSize,
                  disableRange: disableRange,
                  disableStream: disableStream
              });
          }
          return workerIdPromise.then(function (workerId) {
              if (task.destroyed) {
                  throw new Error("Loading aborted");
              }
              if (worker.destroyed) {
                  throw new Error("Worker was destroyed");
              }
              var messageHandler = new MessageHandler(docId, workerId, worker.port);
              var transport = new WorkerTransport(messageHandler, task, networkStream, transportParams, transportFactory);
              task._transport = transport;
              messageHandler.send("Ready", null);
          });
      }).catch(task._capability.reject);
      return task;
  }
  function getUrlProp(val) {
      if (val instanceof URL) {
          return val.href;
      }
      try {
          return new URL(val, window.location).href;
      }
      catch (_j) {
          if (isNodeJS && typeof val === "string") {
              return val;
          }
      }
      throw new Error("Invalid PDF url data: " + "either string or URL-object is expected in the url property.");
  }
  function getDataProp(val) {
      if (isNodeJS && typeof Buffer !== "undefined" && val instanceof Buffer) {
          throw new Error("Please provide binary data as `Uint8Array`, rather than `Buffer`.");
      }
      if (val instanceof Uint8Array && val.byteLength === val.buffer.byteLength) {
          return val;
      }
      if (typeof val === "string") {
          return stringToBytes(val);
      }
      if (val instanceof ArrayBuffer || ArrayBuffer.isView(val) || typeof val === "object" && !isNaN(val === null || val === void 0 ? void 0 : val.length)) {
          return new Uint8Array(val);
      }
      throw new Error("Invalid PDF binary data: either TypedArray, " + "string, or array-like object is expected in the data property.");
  }
  function isRefProxy(ref) {
      return typeof ref === "object" && Number.isInteger(ref === null || ref === void 0 ? void 0 : ref.num) && ref.num >= 0 && Number.isInteger(ref === null || ref === void 0 ? void 0 : ref.gen) && ref.gen >= 0;
  }
  var PDFDocumentLoadingTask = /** @class */ (function () {
      function PDFDocumentLoadingTask() {
          var _k, _l, _m;
          this._capability = Promise.withResolvers();
          this._transport = null;
          this._worker = null;
          this.docId = "d".concat((tslib_1.__classPrivateFieldSet(_k = PDFDocumentLoadingTask, _j, (_m = tslib_1.__classPrivateFieldGet(_k, _j, "f", _PDFDocumentLoadingTask_docId), _l = _m++, _m), "f", _PDFDocumentLoadingTask_docId), _l));
          this.destroyed = false;
          this.onPassword = null;
          this.onProgress = null;
      }
      Object.defineProperty(PDFDocumentLoadingTask.prototype, "promise", {
          get: function () {
              return this._capability.promise;
          },
          enumerable: false,
          configurable: true
      });
      PDFDocumentLoadingTask.prototype.destroy = function () {
          var _k, _l, _m;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var ex_2;
              return tslib_1.__generator(this, function (_o) {
                  switch (_o.label) {
                      case 0:
                          this.destroyed = true;
                          _o.label = 1;
                      case 1:
                          _o.trys.push([1, 3, , 4]);
                          if ((_k = this._worker) === null || _k === void 0 ? void 0 : _k.port) {
                              this._worker._pendingDestroy = true;
                          }
                          return [4 /*yield*/, ((_l = this._transport) === null || _l === void 0 ? void 0 : _l.destroy())];
                      case 2:
                          _o.sent();
                          return [3 /*break*/, 4];
                      case 3:
                          ex_2 = _o.sent();
                          if ((_m = this._worker) === null || _m === void 0 ? void 0 : _m.port) {
                              delete this._worker._pendingDestroy;
                          }
                          throw ex_2;
                      case 4:
                          this._transport = null;
                          if (this._worker) {
                              this._worker.destroy();
                              this._worker = null;
                          }
                          return [2 /*return*/];
                  }
              });
          });
      };
      var _j, _PDFDocumentLoadingTask_docId;
      _j = PDFDocumentLoadingTask;
      _PDFDocumentLoadingTask_docId = { value: 0 };
      return PDFDocumentLoadingTask;
  }());
  var PDFDataRangeTransport = /** @class */ (function () {
      function PDFDataRangeTransport(length, initialData, progressiveDone, contentDispositionFilename) {
          if (progressiveDone === void 0) { progressiveDone = false; }
          if (contentDispositionFilename === void 0) { contentDispositionFilename = null; }
          this.length = length;
          this.initialData = initialData;
          this.progressiveDone = progressiveDone;
          this.contentDispositionFilename = contentDispositionFilename;
          this._rangeListeners = [];
          this._progressListeners = [];
          this._progressiveReadListeners = [];
          this._progressiveDoneListeners = [];
          this._readyCapability = Promise.withResolvers();
      }
      PDFDataRangeTransport.prototype.addRangeListener = function (listener) {
          this._rangeListeners.push(listener);
      };
      PDFDataRangeTransport.prototype.addProgressListener = function (listener) {
          this._progressListeners.push(listener);
      };
      PDFDataRangeTransport.prototype.addProgressiveReadListener = function (listener) {
          this._progressiveReadListeners.push(listener);
      };
      PDFDataRangeTransport.prototype.addProgressiveDoneListener = function (listener) {
          this._progressiveDoneListeners.push(listener);
      };
      PDFDataRangeTransport.prototype.onDataRange = function (begin, chunk) {
          for (var _i = 0, _k = this._rangeListeners; _i < _k.length; _i++) {
              var listener = _k[_i];
              listener(begin, chunk);
          }
      };
      PDFDataRangeTransport.prototype.onDataProgress = function (loaded, total) {
          var _this = this;
          this._readyCapability.promise.then(function () {
              for (var _i = 0, _k = _this._progressListeners; _i < _k.length; _i++) {
                  var listener = _k[_i];
                  listener(loaded, total);
              }
          });
      };
      PDFDataRangeTransport.prototype.onDataProgressiveRead = function (chunk) {
          var _this = this;
          this._readyCapability.promise.then(function () {
              for (var _i = 0, _k = _this._progressiveReadListeners; _i < _k.length; _i++) {
                  var listener = _k[_i];
                  listener(chunk);
              }
          });
      };
      PDFDataRangeTransport.prototype.onDataProgressiveDone = function () {
          var _this = this;
          this._readyCapability.promise.then(function () {
              for (var _i = 0, _k = _this._progressiveDoneListeners; _i < _k.length; _i++) {
                  var listener = _k[_i];
                  listener();
              }
          });
      };
      PDFDataRangeTransport.prototype.transportReady = function () {
          this._readyCapability.resolve();
      };
      PDFDataRangeTransport.prototype.requestDataRange = function (begin, end) {
          unreachable("Abstract method PDFDataRangeTransport.requestDataRange");
      };
      PDFDataRangeTransport.prototype.abort = function () { };
      return PDFDataRangeTransport;
  }());
  var PDFDocumentProxy = /** @class */ (function () {
      function PDFDocumentProxy(pdfInfo, transport) {
          this._pdfInfo = pdfInfo;
          this._transport = transport;
      }
      Object.defineProperty(PDFDocumentProxy.prototype, "annotationStorage", {
          get: function () {
              return this._transport.annotationStorage;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "filterFactory", {
          get: function () {
              return this._transport.filterFactory;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "numPages", {
          get: function () {
              return this._pdfInfo.numPages;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "fingerprints", {
          get: function () {
              return this._pdfInfo.fingerprints;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "isPureXfa", {
          get: function () {
              return shadow(this, "isPureXfa", !!this._transport._htmlForXfa);
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "allXfaHtml", {
          get: function () {
              return this._transport._htmlForXfa;
          },
          enumerable: false,
          configurable: true
      });
      PDFDocumentProxy.prototype.getPage = function (pageNumber) {
          return this._transport.getPage(pageNumber);
      };
      PDFDocumentProxy.prototype.getPageIndex = function (ref) {
          return this._transport.getPageIndex(ref);
      };
      PDFDocumentProxy.prototype.getDestinations = function () {
          return this._transport.getDestinations();
      };
      PDFDocumentProxy.prototype.getDestination = function (id) {
          return this._transport.getDestination(id);
      };
      PDFDocumentProxy.prototype.getPageLabels = function () {
          return this._transport.getPageLabels();
      };
      PDFDocumentProxy.prototype.getPageLayout = function () {
          return this._transport.getPageLayout();
      };
      PDFDocumentProxy.prototype.getPageMode = function () {
          return this._transport.getPageMode();
      };
      PDFDocumentProxy.prototype.getViewerPreferences = function () {
          return this._transport.getViewerPreferences();
      };
      PDFDocumentProxy.prototype.getOpenAction = function () {
          return this._transport.getOpenAction();
      };
      PDFDocumentProxy.prototype.getAttachments = function () {
          return this._transport.getAttachments();
      };
      PDFDocumentProxy.prototype.getJSActions = function () {
          return this._transport.getDocJSActions();
      };
      PDFDocumentProxy.prototype.getOutline = function () {
          return this._transport.getOutline();
      };
      PDFDocumentProxy.prototype.getOptionalContentConfig = function (_k) {
          var _l = _k === void 0 ? {} : _k, _m = _l.intent, intent = _m === void 0 ? "display" : _m;
          var renderingIntent = this._transport.getRenderingIntent(intent).renderingIntent;
          return this._transport.getOptionalContentConfig(renderingIntent);
      };
      PDFDocumentProxy.prototype.getPermissions = function () {
          return this._transport.getPermissions();
      };
      PDFDocumentProxy.prototype.getMetadata = function () {
          return this._transport.getMetadata();
      };
      PDFDocumentProxy.prototype.getMarkInfo = function () {
          return this._transport.getMarkInfo();
      };
      PDFDocumentProxy.prototype.getData = function () {
          return this._transport.getData();
      };
      PDFDocumentProxy.prototype.saveDocument = function () {
          return this._transport.saveDocument();
      };
      PDFDocumentProxy.prototype.getDownloadInfo = function () {
          return this._transport.downloadInfoCapability.promise;
      };
      PDFDocumentProxy.prototype.cleanup = function (keepLoadedFonts) {
          if (keepLoadedFonts === void 0) { keepLoadedFonts = false; }
          return this._transport.startCleanup(keepLoadedFonts || this.isPureXfa);
      };
      PDFDocumentProxy.prototype.destroy = function () {
          return this.loadingTask.destroy();
      };
      PDFDocumentProxy.prototype.cachedPageNumber = function (ref) {
          return this._transport.cachedPageNumber(ref);
      };
      Object.defineProperty(PDFDocumentProxy.prototype, "loadingParams", {
          get: function () {
              return this._transport.loadingParams;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFDocumentProxy.prototype, "loadingTask", {
          get: function () {
              return this._transport.loadingTask;
          },
          enumerable: false,
          configurable: true
      });
      PDFDocumentProxy.prototype.getFieldObjects = function () {
          return this._transport.getFieldObjects();
      };
      PDFDocumentProxy.prototype.hasJSActions = function () {
          return this._transport.hasJSActions();
      };
      PDFDocumentProxy.prototype.getCalculationOrderIds = function () {
          return this._transport.getCalculationOrderIds();
      };
      return PDFDocumentProxy;
  }());
  var PDFPageProxy = /** @class */ (function () {
      function PDFPageProxy(pageIndex, pageInfo, transport, pdfBug) {
          if (pdfBug === void 0) { pdfBug = false; }
          _PDFPageProxy_instances.add(this);
          _PDFPageProxy_delayedCleanupTimeout.set(this, null);
          _PDFPageProxy_pendingCleanup.set(this, false);
          this._pageIndex = pageIndex;
          this._pageInfo = pageInfo;
          this._transport = transport;
          this._stats = pdfBug ? new StatTimer() : null;
          this._pdfBug = pdfBug;
          this.commonObjs = transport.commonObjs;
          this.objs = new PDFObjects();
          this._maybeCleanupAfterRender = false;
          this._intentStates = new Map();
          this.destroyed = false;
      }
      Object.defineProperty(PDFPageProxy.prototype, "pageNumber", {
          get: function () {
              return this._pageIndex + 1;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFPageProxy.prototype, "rotate", {
          get: function () {
              return this._pageInfo.rotate;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFPageProxy.prototype, "ref", {
          get: function () {
              return this._pageInfo.ref;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFPageProxy.prototype, "userUnit", {
          get: function () {
              return this._pageInfo.userUnit;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFPageProxy.prototype, "view", {
          get: function () {
              return this._pageInfo.view;
          },
          enumerable: false,
          configurable: true
      });
      PDFPageProxy.prototype.getViewport = function (_k) {
          var _l = _k === void 0 ? {} : _k, scale = _l.scale, _m = _l.rotation, rotation = _m === void 0 ? this.rotate : _m, _o = _l.offsetX, offsetX = _o === void 0 ? 0 : _o, _p = _l.offsetY, offsetY = _p === void 0 ? 0 : _p, _q = _l.dontFlip, dontFlip = _q === void 0 ? false : _q;
          return new PageViewport({
              viewBox: this.view,
              scale: scale,
              rotation: rotation,
              offsetX: offsetX,
              offsetY: offsetY,
              dontFlip: dontFlip
          });
      };
      PDFPageProxy.prototype.getAnnotations = function (_k) {
          var _l = _k === void 0 ? {} : _k, _m = _l.intent, intent = _m === void 0 ? "display" : _m;
          var renderingIntent = this._transport.getRenderingIntent(intent).renderingIntent;
          return this._transport.getAnnotations(this._pageIndex, renderingIntent);
      };
      PDFPageProxy.prototype.getJSActions = function () {
          return this._transport.getPageJSActions(this._pageIndex);
      };
      Object.defineProperty(PDFPageProxy.prototype, "filterFactory", {
          get: function () {
              return this._transport.filterFactory;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFPageProxy.prototype, "isPureXfa", {
          get: function () {
              return shadow(this, "isPureXfa", !!this._transport._htmlForXfa);
          },
          enumerable: false,
          configurable: true
      });
      PDFPageProxy.prototype.getXfa = function () {
          var _k;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              return tslib_1.__generator(this, function (_l) {
                  return [2 /*return*/, ((_k = this._transport._htmlForXfa) === null || _k === void 0 ? void 0 : _k.children[this._pageIndex]) || null];
              });
          });
      };
      PDFPageProxy.prototype.render = function (_k) {
          var _this = this;
          var _l, _m;
          var canvasContext = _k.canvasContext, viewport = _k.viewport, _o = _k.intent, intent = _o === void 0 ? "display" : _o, _p = _k.annotationMode, annotationMode = _p === void 0 ? AnnotationMode.ENABLE : _p, _q = _k.transform, transform = _q === void 0 ? null : _q, _r = _k.background, background = _r === void 0 ? null : _r, _s = _k.optionalContentConfigPromise, optionalContentConfigPromise = _s === void 0 ? null : _s, _t = _k.annotationCanvasMap, annotationCanvasMap = _t === void 0 ? null : _t, _u = _k.pageColors, pageColors = _u === void 0 ? null : _u, _v = _k.printAnnotationStorage, printAnnotationStorage = _v === void 0 ? null : _v;
          (_l = this._stats) === null || _l === void 0 ? void 0 : _l.time("Overall");
          var intentArgs = this._transport.getRenderingIntent(intent, annotationMode, printAnnotationStorage);
          var renderingIntent = intentArgs.renderingIntent, cacheKey = intentArgs.cacheKey;
          tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_pendingCleanup, false, "f");
          tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_instances, "m", _PDFPageProxy_abortDelayedCleanup).call(this);
          optionalContentConfigPromise || (optionalContentConfigPromise = this._transport.getOptionalContentConfig(renderingIntent));
          var intentState = this._intentStates.get(cacheKey);
          if (!intentState) {
              intentState = Object.create(null);
              this._intentStates.set(cacheKey, intentState);
          }
          if (intentState.streamReaderCancelTimeout) {
              clearTimeout(intentState.streamReaderCancelTimeout);
              intentState.streamReaderCancelTimeout = null;
          }
          var intentPrint = !!(renderingIntent & RenderingIntentFlag.PRINT);
          if (!intentState.displayReadyCapability) {
              intentState.displayReadyCapability = Promise.withResolvers();
              intentState.operatorList = {
                  fnArray: [],
                  argsArray: [],
                  lastChunk: false,
                  separateAnnots: null
              };
              (_m = this._stats) === null || _m === void 0 ? void 0 : _m.time("Page Request");
              this._pumpOperatorList(intentArgs);
          }
          var complete = function (error) {
              var _k;
              intentState.renderTasks.delete(internalRenderTask);
              if (_this._maybeCleanupAfterRender || intentPrint) {
                  tslib_1.__classPrivateFieldSet(_this, _PDFPageProxy_pendingCleanup, true, "f");
              }
              tslib_1.__classPrivateFieldGet(_this, _PDFPageProxy_instances, "m", _PDFPageProxy_tryCleanup).call(_this, !intentPrint);
              if (error) {
                  internalRenderTask.capability.reject(error);
                  _this._abortOperatorList({
                      intentState: intentState,
                      reason: error instanceof Error ? error : new Error(error)
                  });
              }
              else {
                  internalRenderTask.capability.resolve();
              }
              if (_this._stats) {
                  _this._stats.timeEnd("Rendering");
                  _this._stats.timeEnd("Overall");
                  if ((_k = globalThis.Stats) === null || _k === void 0 ? void 0 : _k.enabled) {
                      globalThis.Stats.add(_this.pageNumber, _this._stats);
                  }
              }
          };
          var internalRenderTask = new InternalRenderTask({
              callback: complete,
              params: {
                  canvasContext: canvasContext,
                  viewport: viewport,
                  transform: transform,
                  background: background
              },
              objs: this.objs,
              commonObjs: this.commonObjs,
              annotationCanvasMap: annotationCanvasMap,
              operatorList: intentState.operatorList,
              pageIndex: this._pageIndex,
              canvasFactory: this._transport.canvasFactory,
              filterFactory: this._transport.filterFactory,
              useRequestAnimationFrame: !intentPrint,
              pdfBug: this._pdfBug,
              pageColors: pageColors
          });
          (intentState.renderTasks || (intentState.renderTasks = new Set())).add(internalRenderTask);
          var renderTask = internalRenderTask.task;
          Promise.all([intentState.displayReadyCapability.promise, optionalContentConfigPromise]).then(function (_k) {
              var _l;
              var transparency = _k[0], optionalContentConfig = _k[1];
              if (_this.destroyed) {
                  complete();
                  return;
              }
              (_l = _this._stats) === null || _l === void 0 ? void 0 : _l.time("Rendering");
              if (!(optionalContentConfig.renderingIntent & renderingIntent)) {
                  throw new Error("Must use the same `intent`-argument when calling the `PDFPageProxy.render` " + "and `PDFDocumentProxy.getOptionalContentConfig` methods.");
              }
              internalRenderTask.initializeGraphics({
                  transparency: transparency,
                  optionalContentConfig: optionalContentConfig
              });
              internalRenderTask.operatorListChanged();
          }).catch(complete);
          return renderTask;
      };
      PDFPageProxy.prototype.getOperatorList = function (_k) {
          var _l;
          var _m = _k === void 0 ? {} : _k, _o = _m.intent, intent = _o === void 0 ? "display" : _o, _p = _m.annotationMode, annotationMode = _p === void 0 ? AnnotationMode.ENABLE : _p, _q = _m.printAnnotationStorage, printAnnotationStorage = _q === void 0 ? null : _q;
          function operatorListChanged() {
              if (intentState.operatorList.lastChunk) {
                  intentState.opListReadCapability.resolve(intentState.operatorList);
                  intentState.renderTasks.delete(opListTask);
              }
          }
          var intentArgs = this._transport.getRenderingIntent(intent, annotationMode, printAnnotationStorage, true);
          var intentState = this._intentStates.get(intentArgs.cacheKey);
          if (!intentState) {
              intentState = Object.create(null);
              this._intentStates.set(intentArgs.cacheKey, intentState);
          }
          var opListTask;
          if (!intentState.opListReadCapability) {
              opListTask = Object.create(null);
              opListTask.operatorListChanged = operatorListChanged;
              intentState.opListReadCapability = Promise.withResolvers();
              (intentState.renderTasks || (intentState.renderTasks = new Set())).add(opListTask);
              intentState.operatorList = {
                  fnArray: [],
                  argsArray: [],
                  lastChunk: false,
                  separateAnnots: null
              };
              (_l = this._stats) === null || _l === void 0 ? void 0 : _l.time("Page Request");
              this._pumpOperatorList(intentArgs);
          }
          return intentState.opListReadCapability.promise;
      };
      PDFPageProxy.prototype.streamTextContent = function (_k) {
          var _l = _k === void 0 ? {} : _k, _m = _l.includeMarkedContent, includeMarkedContent = _m === void 0 ? false : _m, _o = _l.disableNormalization, disableNormalization = _o === void 0 ? false : _o;
          var TEXT_CONTENT_CHUNK_SIZE = 100;
          return this._transport.messageHandler.sendWithStream("GetTextContent", {
              pageIndex: this._pageIndex,
              includeMarkedContent: includeMarkedContent === true,
              disableNormalization: disableNormalization === true
          }, {
              highWaterMark: TEXT_CONTENT_CHUNK_SIZE,
              size: function (textContent) {
                  return textContent.items.length;
              }
          });
      };
      PDFPageProxy.prototype.getTextContent = function (params) {
          if (params === void 0) { params = {}; }
          if (this._transport._htmlForXfa) {
              return this.getXfa().then(function (xfa) { return XfaText.textContent(xfa); });
          }
          var readableStream = this.streamTextContent(params);
          return new Promise(function (resolve, reject) {
              function pump() {
                  reader.read().then(function (_k) {
                      var _l;
                      var _m;
                      var value = _k.value, done = _k.done;
                      if (done) {
                          resolve(textContent);
                          return;
                      }
                      (_m = textContent.lang) !== null && _m !== void 0 ? _m : (textContent.lang = value.lang);
                      Object.assign(textContent.styles, value.styles);
                      (_l = textContent.items).push.apply(_l, value.items);
                      pump();
                  }, reject);
              }
              var reader = readableStream.getReader();
              var textContent = {
                  items: [],
                  styles: Object.create(null),
                  lang: null
              };
              pump();
          });
      };
      PDFPageProxy.prototype.getStructTree = function () {
          return this._transport.getStructTree(this._pageIndex);
      };
      PDFPageProxy.prototype._destroy = function () {
          this.destroyed = true;
          var waitOn = [];
          for (var _i = 0, _k = this._intentStates.values(); _i < _k.length; _i++) {
              var intentState = _k[_i];
              this._abortOperatorList({
                  intentState: intentState,
                  reason: new Error("Page was destroyed."),
                  force: true
              });
              if (intentState.opListReadCapability) {
                  continue;
              }
              for (var _l = 0, _m = intentState.renderTasks; _l < _m.length; _l++) {
                  var internalRenderTask = _m[_l];
                  waitOn.push(internalRenderTask.completed);
                  internalRenderTask.cancel();
              }
          }
          this.objs.clear();
          tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_pendingCleanup, false, "f");
          tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_instances, "m", _PDFPageProxy_abortDelayedCleanup).call(this);
          return Promise.all(waitOn);
      };
      PDFPageProxy.prototype.cleanup = function (resetStats) {
          if (resetStats === void 0) { resetStats = false; }
          tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_pendingCleanup, true, "f");
          var success = tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_instances, "m", _PDFPageProxy_tryCleanup).call(this, false);
          if (resetStats && success) {
              this._stats && (this._stats = new StatTimer());
          }
          return success;
      };
      PDFPageProxy.prototype._startRenderPage = function (transparency, cacheKey) {
          var _k, _l;
          var intentState = this._intentStates.get(cacheKey);
          if (!intentState) {
              return;
          }
          (_k = this._stats) === null || _k === void 0 ? void 0 : _k.timeEnd("Page Request");
          (_l = intentState.displayReadyCapability) === null || _l === void 0 ? void 0 : _l.resolve(transparency);
      };
      PDFPageProxy.prototype._renderPageChunk = function (operatorListChunk, intentState) {
          for (var i = 0, ii = operatorListChunk.length; i < ii; i++) {
              intentState.operatorList.fnArray.push(operatorListChunk.fnArray[i]);
              intentState.operatorList.argsArray.push(operatorListChunk.argsArray[i]);
          }
          intentState.operatorList.lastChunk = operatorListChunk.lastChunk;
          intentState.operatorList.separateAnnots = operatorListChunk.separateAnnots;
          for (var _i = 0, _k = intentState.renderTasks; _i < _k.length; _i++) {
              var internalRenderTask = _k[_i];
              internalRenderTask.operatorListChanged();
          }
          if (operatorListChunk.lastChunk) {
              tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_instances, "m", _PDFPageProxy_tryCleanup).call(this, true);
          }
      };
      PDFPageProxy.prototype._pumpOperatorList = function (_k) {
          var _this = this;
          var renderingIntent = _k.renderingIntent, cacheKey = _k.cacheKey, annotationStorageSerializable = _k.annotationStorageSerializable;
          var map = annotationStorageSerializable.map, transfer = annotationStorageSerializable.transfer;
          var readableStream = this._transport.messageHandler.sendWithStream("GetOperatorList", {
              pageIndex: this._pageIndex,
              intent: renderingIntent,
              cacheKey: cacheKey,
              annotationStorage: map
          }, transfer);
          var reader = readableStream.getReader();
          var intentState = this._intentStates.get(cacheKey);
          intentState.streamReader = reader;
          var pump = function () {
              reader.read().then(function (_k) {
                  var value = _k.value, done = _k.done;
                  if (done) {
                      intentState.streamReader = null;
                      return;
                  }
                  if (_this._transport.destroyed) {
                      return;
                  }
                  _this._renderPageChunk(value, intentState);
                  pump();
              }, function (reason) {
                  intentState.streamReader = null;
                  if (_this._transport.destroyed) {
                      return;
                  }
                  if (intentState.operatorList) {
                      intentState.operatorList.lastChunk = true;
                      for (var _i = 0, _k = intentState.renderTasks; _i < _k.length; _i++) {
                          var internalRenderTask = _k[_i];
                          internalRenderTask.operatorListChanged();
                      }
                      tslib_1.__classPrivateFieldGet(_this, _PDFPageProxy_instances, "m", _PDFPageProxy_tryCleanup).call(_this, true);
                  }
                  if (intentState.displayReadyCapability) {
                      intentState.displayReadyCapability.reject(reason);
                  }
                  else if (intentState.opListReadCapability) {
                      intentState.opListReadCapability.reject(reason);
                  }
                  else {
                      throw reason;
                  }
              });
          };
          pump();
      };
      PDFPageProxy.prototype._abortOperatorList = function (_k) {
          var _this = this;
          var intentState = _k.intentState, reason = _k.reason, _l = _k.force, force = _l === void 0 ? false : _l;
          if (!intentState.streamReader) {
              return;
          }
          if (intentState.streamReaderCancelTimeout) {
              clearTimeout(intentState.streamReaderCancelTimeout);
              intentState.streamReaderCancelTimeout = null;
          }
          if (!force) {
              if (intentState.renderTasks.size > 0) {
                  return;
              }
              if (reason instanceof RenderingCancelledException) {
                  var delay = RENDERING_CANCELLED_TIMEOUT;
                  if (reason.extraDelay > 0 && reason.extraDelay < 1000) {
                      delay += reason.extraDelay;
                  }
                  intentState.streamReaderCancelTimeout = setTimeout(function () {
                      intentState.streamReaderCancelTimeout = null;
                      _this._abortOperatorList({
                          intentState: intentState,
                          reason: reason,
                          force: true
                      });
                  }, delay);
                  return;
              }
          }
          intentState.streamReader.cancel(new AbortException(reason.message)).catch(function () { });
          intentState.streamReader = null;
          if (this._transport.destroyed) {
              return;
          }
          for (var _i = 0, _m = this._intentStates; _i < _m.length; _i++) {
              var _o = _m[_i], curCacheKey = _o[0], curIntentState = _o[1];
              if (curIntentState === intentState) {
                  this._intentStates.delete(curCacheKey);
                  break;
              }
          }
          this.cleanup();
      };
      Object.defineProperty(PDFPageProxy.prototype, "stats", {
          get: function () {
              return this._stats;
          },
          enumerable: false,
          configurable: true
      });
      return PDFPageProxy;
  }());
  _PDFPageProxy_delayedCleanupTimeout = new WeakMap(), _PDFPageProxy_pendingCleanup = new WeakMap(), _PDFPageProxy_instances = new WeakSet(), _PDFPageProxy_tryCleanup = function _PDFPageProxy_tryCleanup(delayed) {
      var _this = this;
      if (delayed === void 0) { delayed = false; }
      tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_instances, "m", _PDFPageProxy_abortDelayedCleanup).call(this);
      if (!tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_pendingCleanup, "f") || this.destroyed) {
          return false;
      }
      if (delayed) {
          tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_delayedCleanupTimeout, setTimeout(function () {
              tslib_1.__classPrivateFieldSet(_this, _PDFPageProxy_delayedCleanupTimeout, null, "f");
              tslib_1.__classPrivateFieldGet(_this, _PDFPageProxy_instances, "m", _PDFPageProxy_tryCleanup).call(_this, false);
          }, DELAYED_CLEANUP_TIMEOUT), "f");
          return false;
      }
      for (var _i = 0, _k = this._intentStates.values(); _i < _k.length; _i++) {
          var _l = _k[_i], renderTasks = _l.renderTasks, operatorList = _l.operatorList;
          if (renderTasks.size > 0 || !operatorList.lastChunk) {
              return false;
          }
      }
      this._intentStates.clear();
      this.objs.clear();
      tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_pendingCleanup, false, "f");
      return true;
  }, _PDFPageProxy_abortDelayedCleanup = function _PDFPageProxy_abortDelayedCleanup() {
      if (tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_delayedCleanupTimeout, "f")) {
          clearTimeout(tslib_1.__classPrivateFieldGet(this, _PDFPageProxy_delayedCleanupTimeout, "f"));
          tslib_1.__classPrivateFieldSet(this, _PDFPageProxy_delayedCleanupTimeout, null, "f");
      }
  };
  var LoopbackPort = /** @class */ (function () {
      function LoopbackPort() {
          _LoopbackPort_listeners.set(this, new Set());
          _LoopbackPort_deferred.set(this, Promise.resolve());
      }
      LoopbackPort.prototype.postMessage = function (obj, transfer) {
          var _this = this;
          var event = {
              data: structuredClone(obj, transfer ? {
                  transfer: transfer
              } : null)
          };
          tslib_1.__classPrivateFieldGet(this, _LoopbackPort_deferred, "f").then(function () {
              for (var _i = 0, _k = tslib_1.__classPrivateFieldGet(_this, _LoopbackPort_listeners, "f"); _i < _k.length; _i++) {
                  var listener = _k[_i];
                  listener.call(_this, event);
              }
          });
      };
      LoopbackPort.prototype.addEventListener = function (name, listener) {
          tslib_1.__classPrivateFieldGet(this, _LoopbackPort_listeners, "f").add(listener);
      };
      LoopbackPort.prototype.removeEventListener = function (name, listener) {
          tslib_1.__classPrivateFieldGet(this, _LoopbackPort_listeners, "f").delete(listener);
      };
      LoopbackPort.prototype.terminate = function () {
          tslib_1.__classPrivateFieldGet(this, _LoopbackPort_listeners, "f").clear();
      };
      return LoopbackPort;
  }());
  _LoopbackPort_listeners = new WeakMap(), _LoopbackPort_deferred = new WeakMap();
  var PDFWorkerUtil = {
      isWorkerDisabled: false,
      fakeWorkerId: 0
  };
  {
      if (isNodeJS) {
          PDFWorkerUtil.isWorkerDisabled = true;
          GlobalWorkerOptions.workerSrc || (GlobalWorkerOptions.workerSrc = "./pdf.worker.mjs");
      }
      PDFWorkerUtil.isSameOrigin = function (baseUrl, otherUrl) {
          var base;
          try {
              base = new URL(baseUrl);
              if (!base.origin || base.origin === "null") {
                  return false;
              }
          }
          catch (_k) {
              return false;
          }
          var other = new URL(otherUrl, base);
          return base.origin === other.origin;
      };
      PDFWorkerUtil.createCDNWrapper = function (url) {
          var wrapper = "await import(\"".concat(url, "\");");
          return URL.createObjectURL(new Blob([wrapper], {
              type: "text/javascript"
          }));
      };
  }
  var PDFWorker = /** @class */ (function () {
      function PDFWorker(_k) {
          var _l = _k === void 0 ? {} : _k, _m = _l.name, name = _m === void 0 ? null : _m, _o = _l.port, port = _o === void 0 ? null : _o, _p = _l.verbosity, verbosity = _p === void 0 ? getVerbosityLevel() : _p;
          var _q;
          var _r;
          this.name = name;
          this.destroyed = false;
          this.verbosity = verbosity;
          this._readyCapability = Promise.withResolvers();
          this._port = null;
          this._webWorker = null;
          this._messageHandler = null;
          if (port) {
              if ((_q = tslib_1.__classPrivateFieldGet(PDFWorker, _c, "f", _PDFWorker_workerPorts)) === null || _q === void 0 ? void 0 : _q.has(port)) {
                  throw new Error("Cannot use more than one PDFWorker per port.");
              }
              (tslib_1.__classPrivateFieldSet(_r = PDFWorker, _c, tslib_1.__classPrivateFieldGet(_r, _c, "f", _PDFWorker_workerPorts) || new WeakMap(), "f", _PDFWorker_workerPorts)).set(port, this);
              this._initializeFromPort(port);
              return;
          }
          this._initialize();
      }
      Object.defineProperty(PDFWorker.prototype, "promise", {
          get: function () {
              if (isNodeJS) {
                  return Promise.all([NodePackages.promise, this._readyCapability.promise]);
              }
              return this._readyCapability.promise;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFWorker.prototype, "port", {
          get: function () {
              return this._port;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFWorker.prototype, "messageHandler", {
          get: function () {
              return this._messageHandler;
          },
          enumerable: false,
          configurable: true
      });
      PDFWorker.prototype._initializeFromPort = function (port) {
          this._port = port;
          this._messageHandler = new MessageHandler("main", "worker", port);
          this._messageHandler.on("ready", function () { });
          this._readyCapability.resolve();
          this._messageHandler.send("configure", {
              verbosity: this.verbosity
          });
      };
      PDFWorker.prototype._initialize = function () {
          var _this = this;
          if (!PDFWorkerUtil.isWorkerDisabled && !tslib_1.__classPrivateFieldGet(PDFWorker, _c, "a", _PDFWorker_mainThreadWorkerMessageHandler_get)) {
              var workerSrc = PDFWorker.workerSrc;
              try {
                  if (!PDFWorkerUtil.isSameOrigin(window.location.href, workerSrc)) {
                      workerSrc = PDFWorkerUtil.createCDNWrapper(new URL(workerSrc, window.location).href);
                  }
                  var worker_1 = new Worker(workerSrc, {
                      type: "module"
                  });
                  var messageHandler_1 = new MessageHandler("main", "worker", worker_1);
                  var terminateEarly_1 = function () {
                      worker_1.removeEventListener("error", onWorkerError_1);
                      messageHandler_1.destroy();
                      worker_1.terminate();
                      if (_this.destroyed) {
                          _this._readyCapability.reject(new Error("Worker was destroyed"));
                      }
                      else {
                          _this._setupFakeWorker();
                      }
                  };
                  var onWorkerError_1 = function () {
                      if (!_this._webWorker) {
                          terminateEarly_1();
                      }
                  };
                  worker_1.addEventListener("error", onWorkerError_1);
                  messageHandler_1.on("test", function (data) {
                      worker_1.removeEventListener("error", onWorkerError_1);
                      if (_this.destroyed) {
                          terminateEarly_1();
                          return;
                      }
                      if (data) {
                          _this._messageHandler = messageHandler_1;
                          _this._port = worker_1;
                          _this._webWorker = worker_1;
                          _this._readyCapability.resolve();
                          messageHandler_1.send("configure", {
                              verbosity: _this.verbosity
                          });
                      }
                      else {
                          _this._setupFakeWorker();
                          messageHandler_1.destroy();
                          worker_1.terminate();
                      }
                  });
                  messageHandler_1.on("ready", function (data) {
                      worker_1.removeEventListener("error", onWorkerError_1);
                      if (_this.destroyed) {
                          terminateEarly_1();
                          return;
                      }
                      try {
                          sendTest_1();
                      }
                      catch (_k) {
                          _this._setupFakeWorker();
                      }
                  });
                  var sendTest_1 = function () {
                      var testObj = new Uint8Array();
                      messageHandler_1.send("test", testObj, [testObj.buffer]);
                  };
                  sendTest_1();
                  return;
              }
              catch (_k) {
                  info("The worker has been disabled.");
              }
          }
          this._setupFakeWorker();
      };
      PDFWorker.prototype._setupFakeWorker = function () {
          var _this = this;
          if (!PDFWorkerUtil.isWorkerDisabled) {
              warn("Setting up fake worker.");
              PDFWorkerUtil.isWorkerDisabled = true;
          }
          PDFWorker._setupFakeWorkerGlobal.then(function (WorkerMessageHandler) {
              if (_this.destroyed) {
                  _this._readyCapability.reject(new Error("Worker was destroyed"));
                  return;
              }
              var port = new LoopbackPort();
              _this._port = port;
              var id = "fake".concat(PDFWorkerUtil.fakeWorkerId++);
              var workerHandler = new MessageHandler(id + "_worker", id, port);
              WorkerMessageHandler.setup(workerHandler, port);
              var messageHandler = new MessageHandler(id, id + "_worker", port);
              _this._messageHandler = messageHandler;
              _this._readyCapability.resolve();
              messageHandler.send("configure", {
                  verbosity: _this.verbosity
              });
          }).catch(function (reason) {
              _this._readyCapability.reject(new Error("Setting up fake worker failed: \"".concat(reason.message, "\".")));
          });
      };
      PDFWorker.prototype.destroy = function () {
          var _k;
          this.destroyed = true;
          if (this._webWorker) {
              this._webWorker.terminate();
              this._webWorker = null;
          }
          (_k = tslib_1.__classPrivateFieldGet(PDFWorker, _c, "f", _PDFWorker_workerPorts)) === null || _k === void 0 ? void 0 : _k.delete(this._port);
          this._port = null;
          if (this._messageHandler) {
              this._messageHandler.destroy();
              this._messageHandler = null;
          }
      };
      PDFWorker.fromPort = function (params) {
          var _k;
          if (!(params === null || params === void 0 ? void 0 : params.port)) {
              throw new Error("PDFWorker.fromPort - invalid method signature.");
          }
          var cachedPort = (_k = tslib_1.__classPrivateFieldGet(this, _c, "f", _PDFWorker_workerPorts)) === null || _k === void 0 ? void 0 : _k.get(params.port);
          if (cachedPort) {
              if (cachedPort._pendingDestroy) {
                  throw new Error("PDFWorker.fromPort - the worker is being destroyed.\n" + "Please remember to await `PDFDocumentLoadingTask.destroy()`-calls.");
              }
              return cachedPort;
          }
          return new PDFWorker(params);
      };
      Object.defineProperty(PDFWorker, "workerSrc", {
          get: function () {
              if (GlobalWorkerOptions.workerSrc) {
                  return GlobalWorkerOptions.workerSrc;
              }
              throw new Error('No "GlobalWorkerOptions.workerSrc" specified.');
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(PDFWorker, "_setupFakeWorkerGlobal", {
          get: function () {
              var _this = this;
              var loader = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                  var worker;
                  return tslib_1.__generator(this, function (_k) {
                      var _l;
                      switch (_k.label) {
                          case 0:
                              if (tslib_1.__classPrivateFieldGet(this, _c, "a", _PDFWorker_mainThreadWorkerMessageHandler_get)) {
                                  return [2 /*return*/, tslib_1.__classPrivateFieldGet(this, _c, "a", _PDFWorker_mainThreadWorkerMessageHandler_get)];
                              }
                              return [4 /*yield*/, (_l = this.workerSrc, Promise.resolve().then(function () { return tslib_1.__importStar(require(_l)); }))];
                          case 1:
                              worker = _k.sent();
                              return [2 /*return*/, worker.WorkerMessageHandler];
                      }
                  });
              }); };
              return shadow(this, "_setupFakeWorkerGlobal", loader());
          },
          enumerable: false,
          configurable: true
      });
      return PDFWorker;
  }());
  _c = PDFWorker, _PDFWorker_mainThreadWorkerMessageHandler_get = function _PDFWorker_mainThreadWorkerMessageHandler_get() {
      var _k;
      try {
          return ((_k = globalThis.pdfjsWorker) === null || _k === void 0 ? void 0 : _k.WorkerMessageHandler) || null;
      }
      catch (_l) {
          return null;
      }
  };
  _PDFWorker_workerPorts = { value: void 0 };
  var WorkerTransport = /** @class */ (function () {
      function WorkerTransport(messageHandler, loadingTask, networkStream, params, factory) {
          _WorkerTransport_instances.add(this);
          _WorkerTransport_methodPromises.set(this, new Map());
          _WorkerTransport_pageCache.set(this, new Map());
          _WorkerTransport_pagePromises.set(this, new Map());
          _WorkerTransport_pageRefCache.set(this, new Map());
          _WorkerTransport_passwordCapability.set(this, null);
          this.messageHandler = messageHandler;
          this.loadingTask = loadingTask;
          this.commonObjs = new PDFObjects();
          this.fontLoader = new FontLoader({
              ownerDocument: params.ownerDocument,
              styleElement: params.styleElement
          });
          this.loadingParams = params.loadingParams;
          this._params = params;
          this.canvasFactory = factory.canvasFactory;
          this.filterFactory = factory.filterFactory;
          this.cMapReaderFactory = factory.cMapReaderFactory;
          this.standardFontDataFactory = factory.standardFontDataFactory;
          this.destroyed = false;
          this.destroyCapability = null;
          this._networkStream = networkStream;
          this._fullReader = null;
          this._lastProgress = null;
          this.downloadInfoCapability = Promise.withResolvers();
          this.setupMessageHandler();
      }
      Object.defineProperty(WorkerTransport.prototype, "annotationStorage", {
          get: function () {
              return shadow(this, "annotationStorage", new AnnotationStorage());
          },
          enumerable: false,
          configurable: true
      });
      WorkerTransport.prototype.getRenderingIntent = function (intent, annotationMode, printAnnotationStorage, isOpList) {
          if (annotationMode === void 0) { annotationMode = AnnotationMode.ENABLE; }
          if (printAnnotationStorage === void 0) { printAnnotationStorage = null; }
          if (isOpList === void 0) { isOpList = false; }
          var renderingIntent = RenderingIntentFlag.DISPLAY;
          var annotationStorageSerializable = SerializableEmpty;
          switch (intent) {
              case "any":
                  renderingIntent = RenderingIntentFlag.ANY;
                  break;
              case "display":
                  break;
              case "print":
                  renderingIntent = RenderingIntentFlag.PRINT;
                  break;
              default:
                  warn("getRenderingIntent - invalid intent: ".concat(intent));
          }
          switch (annotationMode) {
              case AnnotationMode.DISABLE:
                  renderingIntent += RenderingIntentFlag.ANNOTATIONS_DISABLE;
                  break;
              case AnnotationMode.ENABLE:
                  break;
              case AnnotationMode.ENABLE_FORMS:
                  renderingIntent += RenderingIntentFlag.ANNOTATIONS_FORMS;
                  break;
              case AnnotationMode.ENABLE_STORAGE:
                  renderingIntent += RenderingIntentFlag.ANNOTATIONS_STORAGE;
                  var annotationStorage = renderingIntent & RenderingIntentFlag.PRINT && printAnnotationStorage instanceof PrintAnnotationStorage ? printAnnotationStorage : this.annotationStorage;
                  annotationStorageSerializable = annotationStorage.serializable;
                  break;
              default:
                  warn("getRenderingIntent - invalid annotationMode: ".concat(annotationMode));
          }
          if (isOpList) {
              renderingIntent += RenderingIntentFlag.OPLIST;
          }
          return {
              renderingIntent: renderingIntent,
              cacheKey: "".concat(renderingIntent, "_").concat(annotationStorageSerializable.hash),
              annotationStorageSerializable: annotationStorageSerializable
          };
      };
      WorkerTransport.prototype.destroy = function () {
          var _this = this;
          var _k;
          if (this.destroyCapability) {
              return this.destroyCapability.promise;
          }
          this.destroyed = true;
          this.destroyCapability = Promise.withResolvers();
          (_k = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_passwordCapability, "f")) === null || _k === void 0 ? void 0 : _k.reject(new Error("Worker was destroyed during onPassword callback"));
          var waitOn = [];
          for (var _i = 0, _l = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pageCache, "f").values(); _i < _l.length; _i++) {
              var page = _l[_i];
              waitOn.push(page._destroy());
          }
          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pageCache, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pagePromises, "f").clear();
          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pageRefCache, "f").clear();
          if (this.hasOwnProperty("annotationStorage")) {
              this.annotationStorage.resetModified();
          }
          var terminated = this.messageHandler.sendWithPromise("Terminate", null);
          waitOn.push(terminated);
          Promise.all(waitOn).then(function () {
              var _k;
              _this.commonObjs.clear();
              _this.fontLoader.clear();
              tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_methodPromises, "f").clear();
              _this.filterFactory.destroy();
              TextLayer.cleanup();
              (_k = _this._networkStream) === null || _k === void 0 ? void 0 : _k.cancelAllRequests(new AbortException("Worker was terminated."));
              if (_this.messageHandler) {
                  _this.messageHandler.destroy();
                  _this.messageHandler = null;
              }
              _this.destroyCapability.resolve();
          }, this.destroyCapability.reject);
          return this.destroyCapability.promise;
      };
      WorkerTransport.prototype.setupMessageHandler = function () {
          var _this = this;
          var _k = this, messageHandler = _k.messageHandler, loadingTask = _k.loadingTask;
          messageHandler.on("GetReader", function (data, sink) {
              assert(_this._networkStream, "GetReader - no `IPDFStream` instance available.");
              _this._fullReader = _this._networkStream.getFullReader();
              _this._fullReader.onProgress = function (evt) {
                  _this._lastProgress = {
                      loaded: evt.loaded,
                      total: evt.total
                  };
              };
              sink.onPull = function () {
                  _this._fullReader.read().then(function (_k) {
                      var value = _k.value, done = _k.done;
                      if (done) {
                          sink.close();
                          return;
                      }
                      assert(value instanceof ArrayBuffer, "GetReader - expected an ArrayBuffer.");
                      sink.enqueue(new Uint8Array(value), 1, [value]);
                  }).catch(function (reason) {
                      sink.error(reason);
                  });
              };
              sink.onCancel = function (reason) {
                  _this._fullReader.cancel(reason);
                  sink.ready.catch(function (readyReason) {
                      if (_this.destroyed) {
                          return;
                      }
                      throw readyReason;
                  });
              };
          });
          messageHandler.on("ReaderHeadersReady", function (data) {
              var headersCapability = Promise.withResolvers();
              var fullReader = _this._fullReader;
              fullReader.headersReady.then(function () {
                  var _k;
                  if (!fullReader.isStreamingSupported || !fullReader.isRangeSupported) {
                      if (_this._lastProgress) {
                          (_k = loadingTask.onProgress) === null || _k === void 0 ? void 0 : _k.call(loadingTask, _this._lastProgress);
                      }
                      fullReader.onProgress = function (evt) {
                          var _k;
                          (_k = loadingTask.onProgress) === null || _k === void 0 ? void 0 : _k.call(loadingTask, {
                              loaded: evt.loaded,
                              total: evt.total
                          });
                      };
                  }
                  headersCapability.resolve({
                      isStreamingSupported: fullReader.isStreamingSupported,
                      isRangeSupported: fullReader.isRangeSupported,
                      contentLength: fullReader.contentLength
                  });
              }, headersCapability.reject);
              return headersCapability.promise;
          });
          messageHandler.on("GetRangeReader", function (data, sink) {
              assert(_this._networkStream, "GetRangeReader - no `IPDFStream` instance available.");
              var rangeReader = _this._networkStream.getRangeReader(data.begin, data.end);
              if (!rangeReader) {
                  sink.close();
                  return;
              }
              sink.onPull = function () {
                  rangeReader.read().then(function (_k) {
                      var value = _k.value, done = _k.done;
                      if (done) {
                          sink.close();
                          return;
                      }
                      assert(value instanceof ArrayBuffer, "GetRangeReader - expected an ArrayBuffer.");
                      sink.enqueue(new Uint8Array(value), 1, [value]);
                  }).catch(function (reason) {
                      sink.error(reason);
                  });
              };
              sink.onCancel = function (reason) {
                  rangeReader.cancel(reason);
                  sink.ready.catch(function (readyReason) {
                      if (_this.destroyed) {
                          return;
                      }
                      throw readyReason;
                  });
              };
          });
          messageHandler.on("GetDoc", function (_k) {
              var pdfInfo = _k.pdfInfo;
              _this._numPages = pdfInfo.numPages;
              _this._htmlForXfa = pdfInfo.htmlForXfa;
              delete pdfInfo.htmlForXfa;
              loadingTask._capability.resolve(new PDFDocumentProxy(pdfInfo, _this));
          });
          messageHandler.on("DocException", function (ex) {
              var reason;
              switch (ex.name) {
                  case "PasswordException":
                      reason = new PasswordException(ex.message, ex.code);
                      break;
                  case "InvalidPDFException":
                      reason = new InvalidPDFException(ex.message);
                      break;
                  case "MissingPDFException":
                      reason = new MissingPDFException(ex.message);
                      break;
                  case "UnexpectedResponseException":
                      reason = new UnexpectedResponseException(ex.message, ex.status);
                      break;
                  case "UnknownErrorException":
                      reason = new UnknownErrorException(ex.message, ex.details);
                      break;
                  default:
                      unreachable("DocException - expected a valid Error.");
              }
              loadingTask._capability.reject(reason);
          });
          messageHandler.on("PasswordRequest", function (exception) {
              tslib_1.__classPrivateFieldSet(_this, _WorkerTransport_passwordCapability, Promise.withResolvers(), "f");
              if (loadingTask.onPassword) {
                  var updatePassword = function (password) {
                      if (password instanceof Error) {
                          tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_passwordCapability, "f").reject(password);
                      }
                      else {
                          tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_passwordCapability, "f").resolve({
                              password: password
                          });
                      }
                  };
                  try {
                      loadingTask.onPassword(updatePassword, exception.code);
                  }
                  catch (ex) {
                      tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_passwordCapability, "f").reject(ex);
                  }
              }
              else {
                  tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_passwordCapability, "f").reject(new PasswordException(exception.message, exception.code));
              }
              return tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_passwordCapability, "f").promise;
          });
          messageHandler.on("DataLoaded", function (data) {
              var _k;
              (_k = loadingTask.onProgress) === null || _k === void 0 ? void 0 : _k.call(loadingTask, {
                  loaded: data.length,
                  total: data.length
              });
              _this.downloadInfoCapability.resolve(data);
          });
          messageHandler.on("StartRenderPage", function (data) {
              if (_this.destroyed) {
                  return;
              }
              var page = tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_pageCache, "f").get(data.pageIndex);
              page._startRenderPage(data.transparency, data.cacheKey);
          });
          messageHandler.on("commonobj", function (_k) {
              var _l;
              var id = _k[0], type = _k[1], exportedData = _k[2];
              if (_this.destroyed) {
                  return null;
              }
              if (_this.commonObjs.has(id)) {
                  return null;
              }
              switch (type) {
                  case "Font":
                      var _m = _this._params, disableFontFace = _m.disableFontFace, fontExtraProperties_1 = _m.fontExtraProperties, pdfBug = _m.pdfBug;
                      if ("error" in exportedData) {
                          var exportedError = exportedData.error;
                          warn("Error during font loading: ".concat(exportedError));
                          _this.commonObjs.resolve(id, exportedError);
                          break;
                      }
                      var inspectFont = pdfBug && ((_l = globalThis.FontInspector) === null || _l === void 0 ? void 0 : _l.enabled) ? function (font, url) { return globalThis.FontInspector.fontAdded(font, url); } : null;
                      var font_1 = new FontFaceObject(exportedData, {
                          disableFontFace: disableFontFace,
                          inspectFont: inspectFont
                      });
                      _this.fontLoader.bind(font_1).catch(function () { return messageHandler.sendWithPromise("FontFallback", {
                          id: id
                      }); }).finally(function () {
                          if (!fontExtraProperties_1 && font_1.data) {
                              font_1.data = null;
                          }
                          _this.commonObjs.resolve(id, font_1);
                      });
                      break;
                  case "CopyLocalImage":
                      var imageRef = exportedData.imageRef;
                      assert(imageRef, "The imageRef must be defined.");
                      for (var _i = 0, _o = tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_pageCache, "f").values(); _i < _o.length; _i++) {
                          var pageProxy = _o[_i];
                          for (var _p = 0, _q = pageProxy.objs; _p < _q.length; _p++) {
                              var _r = _q[_p], data = _r[1];
                              if ((data === null || data === void 0 ? void 0 : data.ref) !== imageRef) {
                                  continue;
                              }
                              if (!data.dataLen) {
                                  return null;
                              }
                              _this.commonObjs.resolve(id, structuredClone(data));
                              return data.dataLen;
                          }
                      }
                      break;
                  case "FontPath":
                  case "Image":
                  case "Pattern":
                      _this.commonObjs.resolve(id, exportedData);
                      break;
                  default:
                      throw new Error("Got unknown common object type ".concat(type));
              }
              return null;
          });
          messageHandler.on("obj", function (_k) {
              var _l;
              var id = _k[0], pageIndex = _k[1], type = _k[2], imageData = _k[3];
              if (_this.destroyed) {
                  return;
              }
              var pageProxy = tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_pageCache, "f").get(pageIndex);
              if (pageProxy.objs.has(id)) {
                  return;
              }
              if (pageProxy._intentStates.size === 0) {
                  (_l = imageData === null || imageData === void 0 ? void 0 : imageData.bitmap) === null || _l === void 0 ? void 0 : _l.close();
                  return;
              }
              switch (type) {
                  case "Image":
                      pageProxy.objs.resolve(id, imageData);
                      if ((imageData === null || imageData === void 0 ? void 0 : imageData.dataLen) > MAX_IMAGE_SIZE_TO_CACHE) {
                          pageProxy._maybeCleanupAfterRender = true;
                      }
                      break;
                  case "Pattern":
                      pageProxy.objs.resolve(id, imageData);
                      break;
                  default:
                      throw new Error("Got unknown object type ".concat(type));
              }
          });
          messageHandler.on("DocProgress", function (data) {
              var _k;
              if (_this.destroyed) {
                  return;
              }
              (_k = loadingTask.onProgress) === null || _k === void 0 ? void 0 : _k.call(loadingTask, {
                  loaded: data.loaded,
                  total: data.total
              });
          });
          messageHandler.on("FetchBuiltInCMap", function (data) {
              if (_this.destroyed) {
                  return Promise.reject(new Error("Worker was destroyed."));
              }
              if (!_this.cMapReaderFactory) {
                  return Promise.reject(new Error("CMapReaderFactory not initialized, see the `useWorkerFetch` parameter."));
              }
              return _this.cMapReaderFactory.fetch(data);
          });
          messageHandler.on("FetchStandardFontData", function (data) {
              if (_this.destroyed) {
                  return Promise.reject(new Error("Worker was destroyed."));
              }
              if (!_this.standardFontDataFactory) {
                  return Promise.reject(new Error("StandardFontDataFactory not initialized, see the `useWorkerFetch` parameter."));
              }
              return _this.standardFontDataFactory.fetch(data);
          });
      };
      WorkerTransport.prototype.getData = function () {
          return this.messageHandler.sendWithPromise("GetData", null);
      };
      WorkerTransport.prototype.saveDocument = function () {
          var _this = this;
          var _k, _l;
          if (this.annotationStorage.size <= 0) {
              warn("saveDocument called while `annotationStorage` is empty, " + "please use the getData-method instead.");
          }
          var _m = this.annotationStorage.serializable, map = _m.map, transfer = _m.transfer;
          return this.messageHandler.sendWithPromise("SaveDocument", {
              isPureXfa: !!this._htmlForXfa,
              numPages: this._numPages,
              annotationStorage: map,
              filename: (_l = (_k = this._fullReader) === null || _k === void 0 ? void 0 : _k.filename) !== null && _l !== void 0 ? _l : null
          }, transfer).finally(function () {
              _this.annotationStorage.resetModified();
          });
      };
      WorkerTransport.prototype.getPage = function (pageNumber) {
          var _this = this;
          if (!Number.isInteger(pageNumber) || pageNumber <= 0 || pageNumber > this._numPages) {
              return Promise.reject(new Error("Invalid page request."));
          }
          var pageIndex = pageNumber - 1, cachedPromise = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pagePromises, "f").get(pageIndex);
          if (cachedPromise) {
              return cachedPromise;
          }
          var promise = this.messageHandler.sendWithPromise("GetPage", {
              pageIndex: pageIndex
          }).then(function (pageInfo) {
              if (_this.destroyed) {
                  throw new Error("Transport destroyed");
              }
              if (pageInfo.refStr) {
                  tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_pageRefCache, "f").set(pageInfo.refStr, pageNumber);
              }
              var page = new PDFPageProxy(pageIndex, pageInfo, _this, _this._params.pdfBug);
              tslib_1.__classPrivateFieldGet(_this, _WorkerTransport_pageCache, "f").set(pageIndex, page);
              return page;
          });
          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pagePromises, "f").set(pageIndex, promise);
          return promise;
      };
      WorkerTransport.prototype.getPageIndex = function (ref) {
          if (!isRefProxy(ref)) {
              return Promise.reject(new Error("Invalid pageIndex request."));
          }
          return this.messageHandler.sendWithPromise("GetPageIndex", {
              num: ref.num,
              gen: ref.gen
          });
      };
      WorkerTransport.prototype.getAnnotations = function (pageIndex, intent) {
          return this.messageHandler.sendWithPromise("GetAnnotations", {
              pageIndex: pageIndex,
              intent: intent
          });
      };
      WorkerTransport.prototype.getFieldObjects = function () {
          return tslib_1.__classPrivateFieldGet(this, _WorkerTransport_instances, "m", _WorkerTransport_cacheSimpleMethod).call(this, "GetFieldObjects");
      };
      WorkerTransport.prototype.hasJSActions = function () {
          return tslib_1.__classPrivateFieldGet(this, _WorkerTransport_instances, "m", _WorkerTransport_cacheSimpleMethod).call(this, "HasJSActions");
      };
      WorkerTransport.prototype.getCalculationOrderIds = function () {
          return this.messageHandler.sendWithPromise("GetCalculationOrderIds", null);
      };
      WorkerTransport.prototype.getDestinations = function () {
          return this.messageHandler.sendWithPromise("GetDestinations", null);
      };
      WorkerTransport.prototype.getDestination = function (id) {
          if (typeof id !== "string") {
              return Promise.reject(new Error("Invalid destination request."));
          }
          return this.messageHandler.sendWithPromise("GetDestination", {
              id: id
          });
      };
      WorkerTransport.prototype.getPageLabels = function () {
          return this.messageHandler.sendWithPromise("GetPageLabels", null);
      };
      WorkerTransport.prototype.getPageLayout = function () {
          return this.messageHandler.sendWithPromise("GetPageLayout", null);
      };
      WorkerTransport.prototype.getPageMode = function () {
          return this.messageHandler.sendWithPromise("GetPageMode", null);
      };
      WorkerTransport.prototype.getViewerPreferences = function () {
          return this.messageHandler.sendWithPromise("GetViewerPreferences", null);
      };
      WorkerTransport.prototype.getOpenAction = function () {
          return this.messageHandler.sendWithPromise("GetOpenAction", null);
      };
      WorkerTransport.prototype.getAttachments = function () {
          return this.messageHandler.sendWithPromise("GetAttachments", null);
      };
      WorkerTransport.prototype.getDocJSActions = function () {
          return tslib_1.__classPrivateFieldGet(this, _WorkerTransport_instances, "m", _WorkerTransport_cacheSimpleMethod).call(this, "GetDocJSActions");
      };
      WorkerTransport.prototype.getPageJSActions = function (pageIndex) {
          return this.messageHandler.sendWithPromise("GetPageJSActions", {
              pageIndex: pageIndex
          });
      };
      WorkerTransport.prototype.getStructTree = function (pageIndex) {
          return this.messageHandler.sendWithPromise("GetStructTree", {
              pageIndex: pageIndex
          });
      };
      WorkerTransport.prototype.getOutline = function () {
          return this.messageHandler.sendWithPromise("GetOutline", null);
      };
      WorkerTransport.prototype.getOptionalContentConfig = function (renderingIntent) {
          return tslib_1.__classPrivateFieldGet(this, _WorkerTransport_instances, "m", _WorkerTransport_cacheSimpleMethod).call(this, "GetOptionalContentConfig").then(function (data) { return new OptionalContentConfig(data, renderingIntent); });
      };
      WorkerTransport.prototype.getPermissions = function () {
          return this.messageHandler.sendWithPromise("GetPermissions", null);
      };
      WorkerTransport.prototype.getMetadata = function () {
          var _this = this;
          var name = "GetMetadata", cachedPromise = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_methodPromises, "f").get(name);
          if (cachedPromise) {
              return cachedPromise;
          }
          var promise = this.messageHandler.sendWithPromise(name, null).then(function (results) {
              var _k, _l, _m, _o;
              return ({
                  info: results[0],
                  metadata: results[1] ? new Metadata(results[1]) : null,
                  contentDispositionFilename: (_l = (_k = _this._fullReader) === null || _k === void 0 ? void 0 : _k.filename) !== null && _l !== void 0 ? _l : null,
                  contentLength: (_o = (_m = _this._fullReader) === null || _m === void 0 ? void 0 : _m.contentLength) !== null && _o !== void 0 ? _o : null
              });
          });
          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_methodPromises, "f").set(name, promise);
          return promise;
      };
      WorkerTransport.prototype.getMarkInfo = function () {
          return this.messageHandler.sendWithPromise("GetMarkInfo", null);
      };
      WorkerTransport.prototype.startCleanup = function (keepLoadedFonts) {
          if (keepLoadedFonts === void 0) { keepLoadedFonts = false; }
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var _i, _k, page, cleanupSuccessful;
              return tslib_1.__generator(this, function (_l) {
                  switch (_l.label) {
                      case 0:
                          if (this.destroyed) {
                              return [2 /*return*/];
                          }
                          return [4 /*yield*/, this.messageHandler.sendWithPromise("Cleanup", null)];
                      case 1:
                          _l.sent();
                          for (_i = 0, _k = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pageCache, "f").values(); _i < _k.length; _i++) {
                              page = _k[_i];
                              cleanupSuccessful = page.cleanup();
                              if (!cleanupSuccessful) {
                                  throw new Error("startCleanup: Page ".concat(page.pageNumber, " is currently rendering."));
                              }
                          }
                          this.commonObjs.clear();
                          if (!keepLoadedFonts) {
                              this.fontLoader.clear();
                          }
                          tslib_1.__classPrivateFieldGet(this, _WorkerTransport_methodPromises, "f").clear();
                          this.filterFactory.destroy(true);
                          TextLayer.cleanup();
                          return [2 /*return*/];
                  }
              });
          });
      };
      WorkerTransport.prototype.cachedPageNumber = function (ref) {
          var _k;
          if (!isRefProxy(ref)) {
              return null;
          }
          var refStr = ref.gen === 0 ? "".concat(ref.num, "R") : "".concat(ref.num, "R").concat(ref.gen);
          return (_k = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_pageRefCache, "f").get(refStr)) !== null && _k !== void 0 ? _k : null;
      };
      return WorkerTransport;
  }());
  _WorkerTransport_methodPromises = new WeakMap(), _WorkerTransport_pageCache = new WeakMap(), _WorkerTransport_pagePromises = new WeakMap(), _WorkerTransport_pageRefCache = new WeakMap(), _WorkerTransport_passwordCapability = new WeakMap(), _WorkerTransport_instances = new WeakSet(), _WorkerTransport_cacheSimpleMethod = function _WorkerTransport_cacheSimpleMethod(name, data) {
      if (data === void 0) { data = null; }
      var cachedPromise = tslib_1.__classPrivateFieldGet(this, _WorkerTransport_methodPromises, "f").get(name);
      if (cachedPromise) {
          return cachedPromise;
      }
      var promise = this.messageHandler.sendWithPromise(name, data);
      tslib_1.__classPrivateFieldGet(this, _WorkerTransport_methodPromises, "f").set(name, promise);
      return promise;
  };
  var INITIAL_DATA = Symbol("INITIAL_DATA");
  var PDFObjects = /** @class */ (function () {
      function PDFObjects() {
          _PDFObjects_instances.add(this);
          _PDFObjects_objs.set(this, Object.create(null));
      }
      PDFObjects.prototype.get = function (objId, callback) {
          if (callback === void 0) { callback = null; }
          if (callback) {
              var obj_1 = tslib_1.__classPrivateFieldGet(this, _PDFObjects_instances, "m", _PDFObjects_ensureObj).call(this, objId);
              obj_1.promise.then(function () { return callback(obj_1.data); });
              return null;
          }
          var obj = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f")[objId];
          if (!obj || obj.data === INITIAL_DATA) {
              throw new Error("Requesting object that isn't resolved yet ".concat(objId, "."));
          }
          return obj.data;
      };
      PDFObjects.prototype.has = function (objId) {
          var obj = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f")[objId];
          return !!obj && obj.data !== INITIAL_DATA;
      };
      PDFObjects.prototype.resolve = function (objId, data) {
          if (data === void 0) { data = null; }
          var obj = tslib_1.__classPrivateFieldGet(this, _PDFObjects_instances, "m", _PDFObjects_ensureObj).call(this, objId);
          obj.data = data;
          obj.resolve();
      };
      PDFObjects.prototype.clear = function () {
          var _k;
          for (var objId in tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f")) {
              var data = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f")[objId].data;
              (_k = data === null || data === void 0 ? void 0 : data.bitmap) === null || _k === void 0 ? void 0 : _k.close();
          }
          tslib_1.__classPrivateFieldSet(this, _PDFObjects_objs, Object.create(null), "f");
      };
      PDFObjects.prototype[(_PDFObjects_objs = new WeakMap(), _PDFObjects_instances = new WeakSet(), _PDFObjects_ensureObj = function _PDFObjects_ensureObj(objId) {
          var _k;
          return (_k = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f"))[objId] || (_k[objId] = tslib_1.__assign(tslib_1.__assign({}, Promise.withResolvers()), { data: INITIAL_DATA }));
      }, Symbol.iterator)] = function () {
          var _k, _l, _m, _i, objId, data;
          return tslib_1.__generator(this, function (_o) {
              switch (_o.label) {
                  case 0:
                      _k = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f");
                      _l = [];
                      for (_m in _k)
                          _l.push(_m);
                      _i = 0;
                      _o.label = 1;
                  case 1:
                      if (!(_i < _l.length)) return [3 /*break*/, 4];
                      _m = _l[_i];
                      if (!(_m in _k)) return [3 /*break*/, 3];
                      objId = _m;
                      data = tslib_1.__classPrivateFieldGet(this, _PDFObjects_objs, "f")[objId].data;
                      if (data === INITIAL_DATA) {
                          return [3 /*break*/, 3];
                      }
                      return [4 /*yield*/, [objId, data]];
                  case 2:
                      _o.sent();
                      _o.label = 3;
                  case 3:
                      _i++;
                      return [3 /*break*/, 1];
                  case 4: return [2 /*return*/];
              }
          });
      };
      return PDFObjects;
  }());
  var RenderTask = /** @class */ (function () {
      function RenderTask(internalRenderTask) {
          _RenderTask_internalRenderTask.set(this, null);
          tslib_1.__classPrivateFieldSet(this, _RenderTask_internalRenderTask, internalRenderTask, "f");
          this.onContinue = null;
      }
      Object.defineProperty(RenderTask.prototype, "promise", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _RenderTask_internalRenderTask, "f").capability.promise;
          },
          enumerable: false,
          configurable: true
      });
      RenderTask.prototype.cancel = function (extraDelay) {
          if (extraDelay === void 0) { extraDelay = 0; }
          tslib_1.__classPrivateFieldGet(this, _RenderTask_internalRenderTask, "f").cancel(null, extraDelay);
      };
      Object.defineProperty(RenderTask.prototype, "separateAnnots", {
          get: function () {
              var separateAnnots = tslib_1.__classPrivateFieldGet(this, _RenderTask_internalRenderTask, "f").operatorList.separateAnnots;
              if (!separateAnnots) {
                  return false;
              }
              var annotationCanvasMap = tslib_1.__classPrivateFieldGet(this, _RenderTask_internalRenderTask, "f").annotationCanvasMap;
              return separateAnnots.form || separateAnnots.canvas && (annotationCanvasMap === null || annotationCanvasMap === void 0 ? void 0 : annotationCanvasMap.size) > 0;
          },
          enumerable: false,
          configurable: true
      });
      return RenderTask;
  }());
  _RenderTask_internalRenderTask = new WeakMap();
  var InternalRenderTask = /** @class */ (function () {
      function InternalRenderTask(_l) {
          var callback = _l.callback, params = _l.params, objs = _l.objs, commonObjs = _l.commonObjs, annotationCanvasMap = _l.annotationCanvasMap, operatorList = _l.operatorList, pageIndex = _l.pageIndex, canvasFactory = _l.canvasFactory, filterFactory = _l.filterFactory, _m = _l.useRequestAnimationFrame, useRequestAnimationFrame = _m === void 0 ? false : _m, _o = _l.pdfBug, pdfBug = _o === void 0 ? false : _o, _p = _l.pageColors, pageColors = _p === void 0 ? null : _p;
          this.callback = callback;
          this.params = params;
          this.objs = objs;
          this.commonObjs = commonObjs;
          this.annotationCanvasMap = annotationCanvasMap;
          this.operatorListIdx = null;
          this.operatorList = operatorList;
          this._pageIndex = pageIndex;
          this.canvasFactory = canvasFactory;
          this.filterFactory = filterFactory;
          this._pdfBug = pdfBug;
          this.pageColors = pageColors;
          this.running = false;
          this.graphicsReadyCallback = null;
          this.graphicsReady = false;
          this._useRequestAnimationFrame = useRequestAnimationFrame === true && typeof window !== "undefined";
          this.cancelled = false;
          this.capability = Promise.withResolvers();
          this.task = new RenderTask(this);
          this._cancelBound = this.cancel.bind(this);
          this._continueBound = this._continue.bind(this);
          this._scheduleNextBound = this._scheduleNext.bind(this);
          this._nextBound = this._next.bind(this);
          this._canvas = params.canvasContext.canvas;
      }
      Object.defineProperty(InternalRenderTask.prototype, "completed", {
          get: function () {
              return this.capability.promise.catch(function () { });
          },
          enumerable: false,
          configurable: true
      });
      InternalRenderTask.prototype.initializeGraphics = function (_l) {
          var _m, _o;
          var _p = _l.transparency, transparency = _p === void 0 ? false : _p, optionalContentConfig = _l.optionalContentConfig;
          if (this.cancelled) {
              return;
          }
          if (this._canvas) {
              if (tslib_1.__classPrivateFieldGet(InternalRenderTask, _k, "f", _InternalRenderTask_canvasInUse).has(this._canvas)) {
                  throw new Error("Cannot use the same canvas during multiple render() operations. " + "Use different canvas or ensure previous operations were " + "cancelled or completed.");
              }
              tslib_1.__classPrivateFieldGet(InternalRenderTask, _k, "f", _InternalRenderTask_canvasInUse).add(this._canvas);
          }
          if (this._pdfBug && ((_m = globalThis.StepperManager) === null || _m === void 0 ? void 0 : _m.enabled)) {
              this.stepper = globalThis.StepperManager.create(this._pageIndex);
              this.stepper.init(this.operatorList);
              this.stepper.nextBreakPoint = this.stepper.getNextBreakPoint();
          }
          var _q = this.params, canvasContext = _q.canvasContext, viewport = _q.viewport, transform = _q.transform, background = _q.background;
          this.gfx = new CanvasGraphics(canvasContext, this.commonObjs, this.objs, this.canvasFactory, this.filterFactory, {
              optionalContentConfig: optionalContentConfig
          }, this.annotationCanvasMap, this.pageColors);
          this.gfx.beginDrawing({
              transform: transform,
              viewport: viewport,
              transparency: transparency,
              background: background
          });
          this.operatorListIdx = 0;
          this.graphicsReady = true;
          (_o = this.graphicsReadyCallback) === null || _o === void 0 ? void 0 : _o.call(this);
      };
      InternalRenderTask.prototype.cancel = function (error, extraDelay) {
          var _l;
          if (error === void 0) { error = null; }
          if (extraDelay === void 0) { extraDelay = 0; }
          this.running = false;
          this.cancelled = true;
          (_l = this.gfx) === null || _l === void 0 ? void 0 : _l.endDrawing();
          tslib_1.__classPrivateFieldGet(InternalRenderTask, _k, "f", _InternalRenderTask_canvasInUse).delete(this._canvas);
          this.callback(error || new RenderingCancelledException("Rendering cancelled, page ".concat(this._pageIndex + 1), extraDelay));
      };
      InternalRenderTask.prototype.operatorListChanged = function () {
          var _l;
          if (!this.graphicsReady) {
              this.graphicsReadyCallback || (this.graphicsReadyCallback = this._continueBound);
              return;
          }
          (_l = this.stepper) === null || _l === void 0 ? void 0 : _l.updateOperatorList(this.operatorList);
          if (this.running) {
              return;
          }
          this._continue();
      };
      InternalRenderTask.prototype._continue = function () {
          this.running = true;
          if (this.cancelled) {
              return;
          }
          if (this.task.onContinue) {
              this.task.onContinue(this._scheduleNextBound);
          }
          else {
              this._scheduleNext();
          }
      };
      InternalRenderTask.prototype._scheduleNext = function () {
          var _this = this;
          if (this._useRequestAnimationFrame) {
              window.requestAnimationFrame(function () {
                  _this._nextBound().catch(_this._cancelBound);
              });
          }
          else {
              Promise.resolve().then(this._nextBound).catch(this._cancelBound);
          }
      };
      InternalRenderTask.prototype._next = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              return tslib_1.__generator(this, function (_l) {
                  if (this.cancelled) {
                      return [2 /*return*/];
                  }
                  this.operatorListIdx = this.gfx.executeOperatorList(this.operatorList, this.operatorListIdx, this._continueBound, this.stepper);
                  if (this.operatorListIdx === this.operatorList.argsArray.length) {
                      this.running = false;
                      if (this.operatorList.lastChunk) {
                          this.gfx.endDrawing();
                          tslib_1.__classPrivateFieldGet(InternalRenderTask, _k, "f", _InternalRenderTask_canvasInUse).delete(this._canvas);
                          this.callback();
                      }
                  }
                  return [2 /*return*/];
              });
          });
      };
      var _k, _InternalRenderTask_canvasInUse;
      _k = InternalRenderTask;
      _InternalRenderTask_canvasInUse = { value: new WeakSet() };
      return InternalRenderTask;
  }());
  var version = "4.3.136";
  var build = "0cec64437";
  ; // CONCATENATED MODULE: ./src/shared/scripting_utils.js
  function makeColorComp(n) {
      return Math.floor(Math.max(0, Math.min(1, n)) * 255).toString(16).padStart(2, "0");
  }
  function scaleAndClamp(x) {
      return Math.max(0, Math.min(255, 255 * x));
  }
  var ColorConverters = /** @class */ (function () {
      function ColorConverters() {
      }
      ColorConverters.CMYK_G = function (_l) {
          var c = _l[0], y = _l[1], m = _l[2], k = _l[3];
          return ["G", 1 - Math.min(1, 0.3 * c + 0.59 * m + 0.11 * y + k)];
      };
      ColorConverters.G_CMYK = function (_l) {
          var g = _l[0];
          return ["CMYK", 0, 0, 0, 1 - g];
      };
      ColorConverters.G_RGB = function (_l) {
          var g = _l[0];
          return ["RGB", g, g, g];
      };
      ColorConverters.G_rgb = function (_l) {
          var g = _l[0];
          g = scaleAndClamp(g);
          return [g, g, g];
      };
      ColorConverters.G_HTML = function (_l) {
          var g = _l[0];
          var G = makeColorComp(g);
          return "#".concat(G).concat(G).concat(G);
      };
      ColorConverters.RGB_G = function (_l) {
          var r = _l[0], g = _l[1], b = _l[2];
          return ["G", 0.3 * r + 0.59 * g + 0.11 * b];
      };
      ColorConverters.RGB_rgb = function (color) {
          return color.map(scaleAndClamp);
      };
      ColorConverters.RGB_HTML = function (color) {
          return "#".concat(color.map(makeColorComp).join(""));
      };
      ColorConverters.T_HTML = function () {
          return "#00000000";
      };
      ColorConverters.T_rgb = function () {
          return [null];
      };
      ColorConverters.CMYK_RGB = function (_l) {
          var c = _l[0], y = _l[1], m = _l[2], k = _l[3];
          return ["RGB", 1 - Math.min(1, c + k), 1 - Math.min(1, m + k), 1 - Math.min(1, y + k)];
      };
      ColorConverters.CMYK_rgb = function (_l) {
          var c = _l[0], y = _l[1], m = _l[2], k = _l[3];
          return [scaleAndClamp(1 - Math.min(1, c + k)), scaleAndClamp(1 - Math.min(1, m + k)), scaleAndClamp(1 - Math.min(1, y + k))];
      };
      ColorConverters.CMYK_HTML = function (components) {
          var rgb = this.CMYK_RGB(components).slice(1);
          return this.RGB_HTML(rgb);
      };
      ColorConverters.RGB_CMYK = function (_l) {
          var r = _l[0], g = _l[1], b = _l[2];
          var c = 1 - r;
          var m = 1 - g;
          var y = 1 - b;
          var k = Math.min(c, m, y);
          return ["CMYK", c, m, y, k];
      };
      return ColorConverters;
  }());
  ; // CONCATENATED MODULE: ./src/display/xfa_layer.js
  var XfaLayer = /** @class */ (function () {
      function XfaLayer() {
      }
      XfaLayer.setupStorage = function (html, id, element, storage, intent) {
          var storedData = storage.getValue(id, {
              value: null
          });
          switch (element.name) {
              case "textarea":
                  if (storedData.value !== null) {
                      html.textContent = storedData.value;
                  }
                  if (intent === "print") {
                      break;
                  }
                  html.addEventListener("input", function (event) {
                      storage.setValue(id, {
                          value: event.target.value
                      });
                  });
                  break;
              case "input":
                  if (element.attributes.type === "radio" || element.attributes.type === "checkbox") {
                      if (storedData.value === element.attributes.xfaOn) {
                          html.setAttribute("checked", true);
                      }
                      else if (storedData.value === element.attributes.xfaOff) {
                          html.removeAttribute("checked");
                      }
                      if (intent === "print") {
                          break;
                      }
                      html.addEventListener("change", function (event) {
                          storage.setValue(id, {
                              value: event.target.checked ? event.target.getAttribute("xfaOn") : event.target.getAttribute("xfaOff")
                          });
                      });
                  }
                  else {
                      if (storedData.value !== null) {
                          html.setAttribute("value", storedData.value);
                      }
                      if (intent === "print") {
                          break;
                      }
                      html.addEventListener("input", function (event) {
                          storage.setValue(id, {
                              value: event.target.value
                          });
                      });
                  }
                  break;
              case "select":
                  if (storedData.value !== null) {
                      html.setAttribute("value", storedData.value);
                      for (var _i = 0, _l = element.children; _i < _l.length; _i++) {
                          var option = _l[_i];
                          if (option.attributes.value === storedData.value) {
                              option.attributes.selected = true;
                          }
                          else if (option.attributes.hasOwnProperty("selected")) {
                              delete option.attributes.selected;
                          }
                      }
                  }
                  html.addEventListener("input", function (event) {
                      var options = event.target.options;
                      var value = options.selectedIndex === -1 ? "" : options[options.selectedIndex].value;
                      storage.setValue(id, {
                          value: value
                      });
                  });
                  break;
          }
      };
      XfaLayer.setAttributes = function (_l) {
          var html = _l.html, element = _l.element, _m = _l.storage, storage = _m === void 0 ? null : _m, intent = _l.intent, linkService = _l.linkService;
          var attributes = element.attributes;
          var isHTMLAnchorElement = html instanceof HTMLAnchorElement;
          if (attributes.type === "radio") {
              attributes.name = "".concat(attributes.name, "-").concat(intent);
          }
          for (var _i = 0, _o = Object.entries(attributes); _i < _o.length; _i++) {
              var _p = _o[_i], key = _p[0], value = _p[1];
              if (value === null || value === undefined) {
                  continue;
              }
              switch (key) {
                  case "class":
                      if (value.length) {
                          html.setAttribute(key, value.join(" "));
                      }
                      break;
                  case "dataId":
                      break;
                  case "id":
                      html.setAttribute("data-element-id", value);
                      break;
                  case "style":
                      Object.assign(html.style, value);
                      break;
                  case "textContent":
                      html.textContent = value;
                      break;
                  default:
                      if (!isHTMLAnchorElement || key !== "href" && key !== "newWindow") {
                          html.setAttribute(key, value);
                      }
              }
          }
          if (isHTMLAnchorElement) {
              linkService.addLinkAttributes(html, attributes.href, attributes.newWindow);
          }
          if (storage && attributes.dataId) {
              this.setupStorage(html, attributes.dataId, element, storage);
          }
      };
      XfaLayer.render = function (parameters) {
          var _l, _m;
          var storage = parameters.annotationStorage;
          var linkService = parameters.linkService;
          var root = parameters.xfaHtml;
          var intent = parameters.intent || "display";
          var rootHtml = document.createElement(root.name);
          if (root.attributes) {
              this.setAttributes({
                  html: rootHtml,
                  element: root,
                  intent: intent,
                  linkService: linkService
              });
          }
          var isNotForRichText = intent !== "richText";
          var rootDiv = parameters.div;
          rootDiv.append(rootHtml);
          if (parameters.viewport) {
              var transform = "matrix(".concat(parameters.viewport.transform.join(","), ")");
              rootDiv.style.transform = transform;
          }
          if (isNotForRichText) {
              rootDiv.setAttribute("class", "xfaLayer xfaFont");
          }
          var textDivs = [];
          if (root.children.length === 0) {
              if (root.value) {
                  var node = document.createTextNode(root.value);
                  rootHtml.append(node);
                  if (isNotForRichText && XfaText.shouldBuildText(root.name)) {
                      textDivs.push(node);
                  }
              }
              return {
                  textDivs: textDivs
              };
          }
          var stack = [[root, -1, rootHtml]];
          while (stack.length > 0) {
              var _o = stack.at(-1), parent = _o[0], i = _o[1], html = _o[2];
              if (i + 1 === parent.children.length) {
                  stack.pop();
                  continue;
              }
              var child = parent.children[++stack.at(-1)[1]];
              if (child === null) {
                  continue;
              }
              var name = child.name;
              if (name === "#text") {
                  var node = document.createTextNode(child.value);
                  textDivs.push(node);
                  html.append(node);
                  continue;
              }
              var childHtml = ((_l = child === null || child === void 0 ? void 0 : child.attributes) === null || _l === void 0 ? void 0 : _l.xmlns) ? document.createElementNS(child.attributes.xmlns, name) : document.createElement(name);
              html.append(childHtml);
              if (child.attributes) {
                  this.setAttributes({
                      html: childHtml,
                      element: child,
                      storage: storage,
                      intent: intent,
                      linkService: linkService
                  });
              }
              if (((_m = child.children) === null || _m === void 0 ? void 0 : _m.length) > 0) {
                  stack.push([child, -1, childHtml]);
              }
              else if (child.value) {
                  var node = document.createTextNode(child.value);
                  if (isNotForRichText && XfaText.shouldBuildText(name)) {
                      textDivs.push(node);
                  }
                  childHtml.append(node);
              }
          }
          for (var _i = 0, _p = rootDiv.querySelectorAll(".xfaNonInteractive input, .xfaNonInteractive textarea"); _i < _p.length; _i++) {
              var el = _p[_i];
              el.setAttribute("readOnly", true);
          }
          return {
              textDivs: textDivs
          };
      };
      XfaLayer.update = function (parameters) {
          var transform = "matrix(".concat(parameters.viewport.transform.join(","), ")");
          parameters.div.style.transform = transform;
          parameters.div.hidden = false;
      };
      return XfaLayer;
  }());
  ; // CONCATENATED MODULE: ./src/display/annotation_layer.js
  var DEFAULT_TAB_INDEX = 1000;
  var annotation_layer_DEFAULT_FONT_SIZE = 9;
  var GetElementsByNameSet = new WeakSet();
  function getRectDims(rect) {
      return {
          width: rect[2] - rect[0],
          height: rect[3] - rect[1]
      };
  }
  var AnnotationElementFactory = /** @class */ (function () {
      function AnnotationElementFactory() {
      }
      AnnotationElementFactory.create = function (parameters) {
          var subtype = parameters.data.annotationType;
          switch (subtype) {
              case AnnotationType.LINK:
                  return new LinkAnnotationElement(parameters);
              case AnnotationType.TEXT:
                  return new TextAnnotationElement(parameters);
              case AnnotationType.WIDGET:
                  var fieldType = parameters.data.fieldType;
                  switch (fieldType) {
                      case "Tx":
                          return new TextWidgetAnnotationElement(parameters);
                      case "Btn":
                          if (parameters.data.radioButton) {
                              return new RadioButtonWidgetAnnotationElement(parameters);
                          }
                          else if (parameters.data.checkBox) {
                              return new CheckboxWidgetAnnotationElement(parameters);
                          }
                          return new PushButtonWidgetAnnotationElement(parameters);
                      case "Ch":
                          return new ChoiceWidgetAnnotationElement(parameters);
                      case "Sig":
                          return new SignatureWidgetAnnotationElement(parameters);
                  }
                  return new WidgetAnnotationElement(parameters);
              case AnnotationType.POPUP:
                  return new PopupAnnotationElement(parameters);
              case AnnotationType.FREETEXT:
                  return new FreeTextAnnotationElement(parameters);
              case AnnotationType.LINE:
                  return new LineAnnotationElement(parameters);
              case AnnotationType.SQUARE:
                  return new SquareAnnotationElement(parameters);
              case AnnotationType.CIRCLE:
                  return new CircleAnnotationElement(parameters);
              case AnnotationType.POLYLINE:
                  return new PolylineAnnotationElement(parameters);
              case AnnotationType.CARET:
                  return new CaretAnnotationElement(parameters);
              case AnnotationType.INK:
                  return new InkAnnotationElement(parameters);
              case AnnotationType.POLYGON:
                  return new PolygonAnnotationElement(parameters);
              case AnnotationType.HIGHLIGHT:
                  return new HighlightAnnotationElement(parameters);
              case AnnotationType.UNDERLINE:
                  return new UnderlineAnnotationElement(parameters);
              case AnnotationType.SQUIGGLY:
                  return new SquigglyAnnotationElement(parameters);
              case AnnotationType.STRIKEOUT:
                  return new StrikeOutAnnotationElement(parameters);
              case AnnotationType.STAMP:
                  return new StampAnnotationElement(parameters);
              case AnnotationType.FILEATTACHMENT:
                  return new FileAttachmentAnnotationElement(parameters);
              default:
                  return new AnnotationElement(parameters);
          }
      };
      return AnnotationElementFactory;
  }());
  var AnnotationElement = /** @class */ (function () {
      function AnnotationElement(parameters, _l) {
          var _m = _l === void 0 ? {} : _l, _o = _m.isRenderable, isRenderable = _o === void 0 ? false : _o, _p = _m.ignoreBorder, ignoreBorder = _p === void 0 ? false : _p, _q = _m.createQuadrilaterals, createQuadrilaterals = _q === void 0 ? false : _q;
          _AnnotationElement_instances.add(this);
          _AnnotationElement_updates.set(this, null);
          _AnnotationElement_hasBorder.set(this, false);
          _AnnotationElement_popupElement.set(this, null);
          this.isRenderable = isRenderable;
          this.data = parameters.data;
          this.layer = parameters.layer;
          this.linkService = parameters.linkService;
          this.downloadManager = parameters.downloadManager;
          this.imageResourcesPath = parameters.imageResourcesPath;
          this.renderForms = parameters.renderForms;
          this.svgFactory = parameters.svgFactory;
          this.annotationStorage = parameters.annotationStorage;
          this.enableScripting = parameters.enableScripting;
          this.hasJSActions = parameters.hasJSActions;
          this._fieldObjects = parameters.fieldObjects;
          this.parent = parameters.parent;
          if (isRenderable) {
              this.container = this._createContainer(ignoreBorder);
          }
          if (createQuadrilaterals) {
              this._createQuadrilaterals();
          }
      }
      AnnotationElement._hasPopupData = function (_l) {
          var titleObj = _l.titleObj, contentsObj = _l.contentsObj, richText = _l.richText;
          return !!((titleObj === null || titleObj === void 0 ? void 0 : titleObj.str) || (contentsObj === null || contentsObj === void 0 ? void 0 : contentsObj.str) || (richText === null || richText === void 0 ? void 0 : richText.str));
      };
      Object.defineProperty(AnnotationElement.prototype, "hasPopupData", {
          get: function () {
              return AnnotationElement._hasPopupData(this.data);
          },
          enumerable: false,
          configurable: true
      });
      AnnotationElement.prototype.updateEdited = function (params) {
          var _l;
          if (!this.container) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _AnnotationElement_updates, tslib_1.__classPrivateFieldGet(this, _AnnotationElement_updates, "f") || {
              rect: this.data.rect.slice(0)
          }, "f");
          var rect = params.rect;
          if (rect) {
              tslib_1.__classPrivateFieldGet(this, _AnnotationElement_instances, "m", _AnnotationElement_setRectEdited).call(this, rect);
          }
          (_l = tslib_1.__classPrivateFieldGet(this, _AnnotationElement_popupElement, "f")) === null || _l === void 0 ? void 0 : _l.popup.updateEdited(params);
      };
      AnnotationElement.prototype.resetEdited = function () {
          var _l;
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationElement_updates, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _AnnotationElement_instances, "m", _AnnotationElement_setRectEdited).call(this, tslib_1.__classPrivateFieldGet(this, _AnnotationElement_updates, "f").rect);
          (_l = tslib_1.__classPrivateFieldGet(this, _AnnotationElement_popupElement, "f")) === null || _l === void 0 ? void 0 : _l.popup.resetEdited();
          tslib_1.__classPrivateFieldSet(this, _AnnotationElement_updates, null, "f");
      };
      AnnotationElement.prototype._createContainer = function (ignoreBorder) {
          var _l = this, data = _l.data, _m = _l.parent, page = _m.page, viewport = _m.viewport;
          var container = document.createElement("section");
          container.setAttribute("data-annotation-id", data.id);
          if (!(this instanceof WidgetAnnotationElement)) {
              container.tabIndex = DEFAULT_TAB_INDEX;
          }
          var style = container.style;
          style.zIndex = this.parent.zIndex++;
          if (data.popupRef) {
              container.setAttribute("aria-haspopup", "dialog");
          }
          if (data.alternativeText) {
              container.title = data.alternativeText;
          }
          if (data.noRotate) {
              container.classList.add("norotate");
          }
          if (!data.rect || this instanceof PopupAnnotationElement) {
              var rotation_1 = data.rotation;
              if (!data.hasOwnCanvas && rotation_1 !== 0) {
                  this.setRotation(rotation_1, container);
              }
              return container;
          }
          var _o = getRectDims(data.rect), width = _o.width, height = _o.height;
          if (!ignoreBorder && data.borderStyle.width > 0) {
              style.borderWidth = "".concat(data.borderStyle.width, "px");
              var horizontalRadius = data.borderStyle.horizontalCornerRadius;
              var verticalRadius = data.borderStyle.verticalCornerRadius;
              if (horizontalRadius > 0 || verticalRadius > 0) {
                  var radius = "calc(".concat(horizontalRadius, "px * var(--scale-factor)) / calc(").concat(verticalRadius, "px * var(--scale-factor))");
                  style.borderRadius = radius;
              }
              else if (this instanceof RadioButtonWidgetAnnotationElement) {
                  var radius = "calc(".concat(width, "px * var(--scale-factor)) / calc(").concat(height, "px * var(--scale-factor))");
                  style.borderRadius = radius;
              }
              switch (data.borderStyle.style) {
                  case AnnotationBorderStyleType.SOLID:
                      style.borderStyle = "solid";
                      break;
                  case AnnotationBorderStyleType.DASHED:
                      style.borderStyle = "dashed";
                      break;
                  case AnnotationBorderStyleType.BEVELED:
                      warn("Unimplemented border style: beveled");
                      break;
                  case AnnotationBorderStyleType.INSET:
                      warn("Unimplemented border style: inset");
                      break;
                  case AnnotationBorderStyleType.UNDERLINE:
                      style.borderBottomStyle = "solid";
                      break;
                  default:
                      break;
              }
              var borderColor = data.borderColor || null;
              if (borderColor) {
                  tslib_1.__classPrivateFieldSet(this, _AnnotationElement_hasBorder, true, "f");
                  style.borderColor = Util.makeHexColor(borderColor[0] | 0, borderColor[1] | 0, borderColor[2] | 0);
              }
              else {
                  style.borderWidth = 0;
              }
          }
          var rect = Util.normalizeRect([data.rect[0], page.view[3] - data.rect[1] + page.view[1], data.rect[2], page.view[3] - data.rect[3] + page.view[1]]);
          var _p = viewport.rawDims, pageWidth = _p.pageWidth, pageHeight = _p.pageHeight, pageX = _p.pageX, pageY = _p.pageY;
          style.left = "".concat(100 * (rect[0] - pageX) / pageWidth, "%");
          style.top = "".concat(100 * (rect[1] - pageY) / pageHeight, "%");
          var rotation = data.rotation;
          if (data.hasOwnCanvas || rotation === 0) {
              style.width = "".concat(100 * width / pageWidth, "%");
              style.height = "".concat(100 * height / pageHeight, "%");
          }
          else {
              this.setRotation(rotation, container);
          }
          return container;
      };
      AnnotationElement.prototype.setRotation = function (angle, container) {
          if (container === void 0) { container = this.container; }
          if (!this.data.rect) {
              return;
          }
          var _l = this.parent.viewport.rawDims, pageWidth = _l.pageWidth, pageHeight = _l.pageHeight;
          var _m = getRectDims(this.data.rect), width = _m.width, height = _m.height;
          var elementWidth, elementHeight;
          if (angle % 180 === 0) {
              elementWidth = 100 * width / pageWidth;
              elementHeight = 100 * height / pageHeight;
          }
          else {
              elementWidth = 100 * height / pageWidth;
              elementHeight = 100 * width / pageHeight;
          }
          container.style.width = "".concat(elementWidth, "%");
          container.style.height = "".concat(elementHeight, "%");
          container.setAttribute("data-main-rotation", (360 - angle) % 360);
      };
      Object.defineProperty(AnnotationElement.prototype, "_commonActions", {
          get: function () {
              var _this = this;
              var setColor = function (jsName, styleName, event) {
                  var _l;
                  var color = event.detail[jsName];
                  var colorType = color[0];
                  var colorArray = color.slice(1);
                  event.target.style[styleName] = ColorConverters["".concat(colorType, "_HTML")](colorArray);
                  _this.annotationStorage.setValue(_this.data.id, (_l = {},
                      _l[styleName] = ColorConverters["".concat(colorType, "_rgb")](colorArray),
                      _l));
              };
              return shadow(this, "_commonActions", {
                  display: function (event) {
                      var display = event.detail.display;
                      var hidden = display % 2 === 1;
                      _this.container.style.visibility = hidden ? "hidden" : "visible";
                      _this.annotationStorage.setValue(_this.data.id, {
                          noView: hidden,
                          noPrint: display === 1 || display === 2
                      });
                  },
                  print: function (event) {
                      _this.annotationStorage.setValue(_this.data.id, {
                          noPrint: !event.detail.print
                      });
                  },
                  hidden: function (event) {
                      var hidden = event.detail.hidden;
                      _this.container.style.visibility = hidden ? "hidden" : "visible";
                      _this.annotationStorage.setValue(_this.data.id, {
                          noPrint: hidden,
                          noView: hidden
                      });
                  },
                  focus: function (event) {
                      setTimeout(function () { return event.target.focus({
                          preventScroll: false
                      }); }, 0);
                  },
                  userName: function (event) {
                      event.target.title = event.detail.userName;
                  },
                  readonly: function (event) {
                      event.target.disabled = event.detail.readonly;
                  },
                  required: function (event) {
                      _this._setRequired(event.target, event.detail.required);
                  },
                  bgColor: function (event) {
                      setColor("bgColor", "backgroundColor", event);
                  },
                  fillColor: function (event) {
                      setColor("fillColor", "backgroundColor", event);
                  },
                  fgColor: function (event) {
                      setColor("fgColor", "color", event);
                  },
                  textColor: function (event) {
                      setColor("textColor", "color", event);
                  },
                  borderColor: function (event) {
                      setColor("borderColor", "borderColor", event);
                  },
                  strokeColor: function (event) {
                      setColor("strokeColor", "borderColor", event);
                  },
                  rotation: function (event) {
                      var angle = event.detail.rotation;
                      _this.setRotation(angle);
                      _this.annotationStorage.setValue(_this.data.id, {
                          rotation: angle
                      });
                  }
              });
          },
          enumerable: false,
          configurable: true
      });
      AnnotationElement.prototype._dispatchEventFromSandbox = function (actions, jsEvent) {
          var commonActions = this._commonActions;
          for (var _i = 0, _l = Object.keys(jsEvent.detail); _i < _l.length; _i++) {
              var name = _l[_i];
              var action = actions[name] || commonActions[name];
              action === null || action === void 0 ? void 0 : action(jsEvent);
          }
      };
      AnnotationElement.prototype._setDefaultPropertiesFromJS = function (element) {
          var _l;
          if (!this.enableScripting) {
              return;
          }
          var storedData = this.annotationStorage.getRawValue(this.data.id);
          if (!storedData) {
              return;
          }
          var commonActions = this._commonActions;
          for (var _i = 0, _m = Object.entries(storedData); _i < _m.length; _i++) {
              var _o = _m[_i], actionName = _o[0], detail = _o[1];
              var action = commonActions[actionName];
              if (action) {
                  var eventProxy = {
                      detail: (_l = {},
                          _l[actionName] = detail,
                          _l),
                      target: element
                  };
                  action(eventProxy);
                  delete storedData[actionName];
              }
          }
      };
      AnnotationElement.prototype._createQuadrilaterals = function () {
          if (!this.container) {
              return;
          }
          var quadPoints = this.data.quadPoints;
          if (!quadPoints) {
              return;
          }
          var _l = this.data.rect, rectBlX = _l[0], rectBlY = _l[1], rectTrX = _l[2], rectTrY = _l[3];
          if (quadPoints.length === 1) {
              var _m = quadPoints[0], _o = _m[1], trX = _o.x, trY = _o.y, _p = _m[2], blX = _p.x, blY = _p.y;
              if (rectTrX === trX && rectTrY === trY && rectBlX === blX && rectBlY === blY) {
                  return;
              }
          }
          var style = this.container.style;
          var svgBuffer;
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationElement_hasBorder, "f")) {
              var borderColor = style.borderColor, borderWidth = style.borderWidth;
              style.borderWidth = 0;
              svgBuffer = ["url('data:image/svg+xml;utf8,", "<svg xmlns=\"http://www.w3.org/2000/svg\"", " preserveAspectRatio=\"none\" viewBox=\"0 0 1 1\">", "<g fill=\"transparent\" stroke=\"".concat(borderColor, "\" stroke-width=\"").concat(borderWidth, "\">")];
              this.container.classList.add("hasBorder");
          }
          var width = rectTrX - rectBlX;
          var height = rectTrY - rectBlY;
          var svgFactory = this.svgFactory;
          var svg = svgFactory.createElement("svg");
          svg.classList.add("quadrilateralsContainer");
          svg.setAttribute("width", 0);
          svg.setAttribute("height", 0);
          var defs = svgFactory.createElement("defs");
          svg.append(defs);
          var clipPath = svgFactory.createElement("clipPath");
          var id = "clippath_".concat(this.data.id);
          clipPath.setAttribute("id", id);
          clipPath.setAttribute("clipPathUnits", "objectBoundingBox");
          defs.append(clipPath);
          for (var _i = 0, quadPoints_1 = quadPoints; _i < quadPoints_1.length; _i++) {
              var _q = quadPoints_1[_i], _r = _q[1], trX = _r.x, trY = _r.y, _s = _q[2], blX = _s.x, blY = _s.y;
              var rect = svgFactory.createElement("rect");
              var x = (blX - rectBlX) / width;
              var y = (rectTrY - trY) / height;
              var rectWidth = (trX - blX) / width;
              var rectHeight = (trY - blY) / height;
              rect.setAttribute("x", x);
              rect.setAttribute("y", y);
              rect.setAttribute("width", rectWidth);
              rect.setAttribute("height", rectHeight);
              clipPath.append(rect);
              svgBuffer === null || svgBuffer === void 0 ? void 0 : svgBuffer.push("<rect vector-effect=\"non-scaling-stroke\" x=\"".concat(x, "\" y=\"").concat(y, "\" width=\"").concat(rectWidth, "\" height=\"").concat(rectHeight, "\"/>"));
          }
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationElement_hasBorder, "f")) {
              svgBuffer.push("</g></svg>')");
              style.backgroundImage = svgBuffer.join("");
          }
          this.container.append(svg);
          this.container.style.clipPath = "url(#".concat(id, ")");
      };
      AnnotationElement.prototype._createPopup = function () {
          var _l = this, container = _l.container, data = _l.data;
          container.setAttribute("aria-haspopup", "dialog");
          var popup = tslib_1.__classPrivateFieldSet(this, _AnnotationElement_popupElement, new PopupAnnotationElement({
              data: {
                  color: data.color,
                  titleObj: data.titleObj,
                  modificationDate: data.modificationDate,
                  contentsObj: data.contentsObj,
                  richText: data.richText,
                  parentRect: data.rect,
                  borderStyle: 0,
                  id: "popup_".concat(data.id),
                  rotation: data.rotation
              },
              parent: this.parent,
              elements: [this]
          }), "f");
          this.parent.div.append(popup.render());
      };
      AnnotationElement.prototype.render = function () {
          unreachable("Abstract method `AnnotationElement.render` called");
      };
      AnnotationElement.prototype._getElementsByName = function (name, skipId) {
          if (skipId === void 0) { skipId = null; }
          var fields = [];
          if (this._fieldObjects) {
              var fieldObj = this._fieldObjects[name];
              if (fieldObj) {
                  for (var _i = 0, fieldObj_1 = fieldObj; _i < fieldObj_1.length; _i++) {
                      var _l = fieldObj_1[_i], page = _l.page, id = _l.id, exportValues = _l.exportValues;
                      if (page === -1) {
                          continue;
                      }
                      if (id === skipId) {
                          continue;
                      }
                      var exportValue = typeof exportValues === "string" ? exportValues : null;
                      var domElement = document.querySelector("[data-element-id=\"".concat(id, "\"]"));
                      if (domElement && !GetElementsByNameSet.has(domElement)) {
                          warn("_getElementsByName - element not allowed: ".concat(id));
                          continue;
                      }
                      fields.push({
                          id: id,
                          exportValue: exportValue,
                          domElement: domElement
                      });
                  }
              }
              return fields;
          }
          for (var _m = 0, _o = document.getElementsByName(name); _m < _o.length; _m++) {
              var domElement = _o[_m];
              var exportValue = domElement.exportValue;
              var id = domElement.getAttribute("data-element-id");
              if (id === skipId) {
                  continue;
              }
              if (!GetElementsByNameSet.has(domElement)) {
                  continue;
              }
              fields.push({
                  id: id,
                  exportValue: exportValue,
                  domElement: domElement
              });
          }
          return fields;
      };
      AnnotationElement.prototype.show = function () {
          var _l;
          if (this.container) {
              this.container.hidden = false;
          }
          (_l = this.popup) === null || _l === void 0 ? void 0 : _l.maybeShow();
      };
      AnnotationElement.prototype.hide = function () {
          var _l;
          if (this.container) {
              this.container.hidden = true;
          }
          (_l = this.popup) === null || _l === void 0 ? void 0 : _l.forceHide();
      };
      AnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return this.container;
      };
      AnnotationElement.prototype.addHighlightArea = function () {
          var triggers = this.getElementsToTriggerPopup();
          if (Array.isArray(triggers)) {
              for (var _i = 0, triggers_1 = triggers; _i < triggers_1.length; _i++) {
                  var element = triggers_1[_i];
                  element.classList.add("highlightArea");
              }
          }
          else {
              triggers.classList.add("highlightArea");
          }
      };
      Object.defineProperty(AnnotationElement.prototype, "_isEditable", {
          get: function () {
              return false;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationElement.prototype._editOnDoubleClick = function () {
          var _this = this;
          if (!this._isEditable) {
              return;
          }
          var _l = this, mode = _l.annotationEditorType, editId = _l.data.id;
          this.container.addEventListener("dblclick", function () {
              var _l;
              (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("switchannotationeditormode", {
                  source: _this,
                  mode: mode,
                  editId: editId
              });
          });
      };
      return AnnotationElement;
  }());
  _AnnotationElement_updates = new WeakMap(), _AnnotationElement_hasBorder = new WeakMap(), _AnnotationElement_popupElement = new WeakMap(), _AnnotationElement_instances = new WeakSet(), _AnnotationElement_setRectEdited = function _AnnotationElement_setRectEdited(rect) {
      var _l = this, style = _l.container.style, _m = _l.data, currentRect = _m.rect, rotation = _m.rotation, _o = _l.parent.viewport.rawDims, pageWidth = _o.pageWidth, pageHeight = _o.pageHeight, pageX = _o.pageX, pageY = _o.pageY;
      currentRect === null || currentRect === void 0 ? void 0 : currentRect.splice.apply(currentRect, tslib_1.__spreadArray([0, 4], rect, false));
      var _p = getRectDims(rect), width = _p.width, height = _p.height;
      style.left = "".concat(100 * (rect[0] - pageX) / pageWidth, "%");
      style.top = "".concat(100 * (pageHeight - rect[3] + pageY) / pageHeight, "%");
      if (rotation === 0) {
          style.width = "".concat(100 * width / pageWidth, "%");
          style.height = "".concat(100 * height / pageHeight, "%");
      }
      else {
          this.setRotation(rotation);
      }
  };
  var LinkAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(LinkAnnotationElement, _super);
      function LinkAnnotationElement(parameters, options) {
          if (options === void 0) { options = null; }
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: !!(options === null || options === void 0 ? void 0 : options.ignoreBorder),
              createQuadrilaterals: true
          }) || this;
          _LinkAnnotationElement_instances.add(_this);
          _this.isTooltipOnly = parameters.data.isTooltipOnly;
          return _this;
      }
      LinkAnnotationElement.prototype.render = function () {
          var _l = this, data = _l.data, linkService = _l.linkService;
          var link = document.createElement("a");
          link.setAttribute("data-element-id", data.id);
          var isBound = false;
          if (data.url) {
              linkService.addLinkAttributes(link, data.url, data.newWindow);
              isBound = true;
          }
          else if (data.action) {
              this._bindNamedAction(link, data.action);
              isBound = true;
          }
          else if (data.attachment) {
              tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_bindAttachment).call(this, link, data.attachment, data.attachmentDest);
              isBound = true;
          }
          else if (data.setOCGState) {
              tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_bindSetOCGState).call(this, link, data.setOCGState);
              isBound = true;
          }
          else if (data.dest) {
              this._bindLink(link, data.dest);
              isBound = true;
          }
          else {
              if (data.actions && (data.actions.Action || data.actions["Mouse Up"] || data.actions["Mouse Down"]) && this.enableScripting && this.hasJSActions) {
                  this._bindJSAction(link, data);
                  isBound = true;
              }
              if (data.resetForm) {
                  this._bindResetFormAction(link, data.resetForm);
                  isBound = true;
              }
              else if (this.isTooltipOnly && !isBound) {
                  this._bindLink(link, "");
                  isBound = true;
              }
          }
          this.container.classList.add("linkAnnotation");
          if (isBound) {
              this.container.append(link);
          }
          return this.container;
      };
      LinkAnnotationElement.prototype._bindLink = function (link, destination) {
          var _this = this;
          link.href = this.linkService.getDestinationHash(destination);
          link.onclick = function () {
              if (destination) {
                  _this.linkService.goToDestination(destination);
              }
              return false;
          };
          if (destination || destination === "") {
              tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
          }
      };
      LinkAnnotationElement.prototype._bindNamedAction = function (link, action) {
          var _this = this;
          link.href = this.linkService.getAnchorUrl("");
          link.onclick = function () {
              _this.linkService.executeNamedAction(action);
              return false;
          };
          tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
      };
      LinkAnnotationElement.prototype._bindJSAction = function (link, data) {
          var _this = this;
          link.href = this.linkService.getAnchorUrl("");
          var map = new Map([["Action", "onclick"], ["Mouse Up", "onmouseup"], ["Mouse Down", "onmousedown"]]);
          var _loop_4 = function (name) {
              var jsName = map.get(name);
              if (!jsName) {
                  return "continue";
              }
              link[jsName] = function () {
                  var _l;
                  (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                      source: _this,
                      detail: {
                          id: data.id,
                          name: name
                      }
                  });
                  return false;
              };
          };
          for (var _i = 0, _l = Object.keys(data.actions); _i < _l.length; _i++) {
              var name = _l[_i];
              _loop_4(name);
          }
          if (!link.onclick) {
              link.onclick = function () { return false; };
          }
          tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
      };
      LinkAnnotationElement.prototype._bindResetFormAction = function (link, resetForm) {
          var _this = this;
          var otherClickAction = link.onclick;
          if (!otherClickAction) {
              link.href = this.linkService.getAnchorUrl("");
          }
          tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
          if (!this._fieldObjects) {
              warn("_bindResetFormAction - \"resetForm\" action not supported, " + "ensure that the `fieldObjects` parameter is provided.");
              if (!otherClickAction) {
                  link.onclick = function () { return false; };
              }
              return;
          }
          link.onclick = function () {
              var _l;
              otherClickAction === null || otherClickAction === void 0 ? void 0 : otherClickAction();
              var resetFormFields = resetForm.fields, resetFormRefs = resetForm.refs, include = resetForm.include;
              var allFields = [];
              if (resetFormFields.length !== 0 || resetFormRefs.length !== 0) {
                  var fieldIds = new Set(resetFormRefs);
                  for (var _i = 0, resetFormFields_1 = resetFormFields; _i < resetFormFields_1.length; _i++) {
                      var fieldName = resetFormFields_1[_i];
                      var fields = _this._fieldObjects[fieldName] || [];
                      for (var _m = 0, fields_1 = fields; _m < fields_1.length; _m++) {
                          var id = fields_1[_m].id;
                          fieldIds.add(id);
                      }
                  }
                  for (var _o = 0, _p = Object.values(_this._fieldObjects); _o < _p.length; _o++) {
                      var fields = _p[_o];
                      for (var _q = 0, fields_2 = fields; _q < fields_2.length; _q++) {
                          var field = fields_2[_q];
                          if (fieldIds.has(field.id) === include) {
                              allFields.push(field);
                          }
                      }
                  }
              }
              else {
                  for (var _r = 0, _s = Object.values(_this._fieldObjects); _r < _s.length; _r++) {
                      var fields = _s[_r];
                      allFields.push.apply(allFields, fields);
                  }
              }
              var storage = _this.annotationStorage;
              var allIds = [];
              for (var _t = 0, allFields_1 = allFields; _t < allFields_1.length; _t++) {
                  var field = allFields_1[_t];
                  var id = field.id;
                  allIds.push(id);
                  switch (field.type) {
                      case "text":
                          {
                              var value = field.defaultValue || "";
                              storage.setValue(id, {
                                  value: value
                              });
                              break;
                          }
                      case "checkbox":
                      case "radiobutton":
                          {
                              var value = field.defaultValue === field.exportValues;
                              storage.setValue(id, {
                                  value: value
                              });
                              break;
                          }
                      case "combobox":
                      case "listbox":
                          {
                              var value = field.defaultValue || "";
                              storage.setValue(id, {
                                  value: value
                              });
                              break;
                          }
                      default:
                          continue;
                  }
                  var domElement = document.querySelector("[data-element-id=\"".concat(id, "\"]"));
                  if (!domElement) {
                      continue;
                  }
                  else if (!GetElementsByNameSet.has(domElement)) {
                      warn("_bindResetFormAction - element not allowed: ".concat(id));
                      continue;
                  }
                  domElement.dispatchEvent(new Event("resetform"));
              }
              if (_this.enableScripting) {
                  (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                      source: _this,
                      detail: {
                          id: "app",
                          ids: allIds,
                          name: "ResetForm"
                      }
                  });
              }
              return false;
          };
      };
      return LinkAnnotationElement;
  }(AnnotationElement));
  _LinkAnnotationElement_instances = new WeakSet(), _LinkAnnotationElement_setInternalLink = function _LinkAnnotationElement_setInternalLink() {
      this.container.setAttribute("data-internal-link", "");
  }, _LinkAnnotationElement_bindAttachment = function _LinkAnnotationElement_bindAttachment(link, attachment, dest) {
      var _this = this;
      if (dest === void 0) { dest = null; }
      link.href = this.linkService.getAnchorUrl("");
      if (attachment.description) {
          link.title = attachment.description;
      }
      link.onclick = function () {
          var _l;
          (_l = _this.downloadManager) === null || _l === void 0 ? void 0 : _l.openOrDownloadData(attachment.content, attachment.filename, dest);
          return false;
      };
      tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
  }, _LinkAnnotationElement_bindSetOCGState = function _LinkAnnotationElement_bindSetOCGState(link, action) {
      var _this = this;
      link.href = this.linkService.getAnchorUrl("");
      link.onclick = function () {
          _this.linkService.executeSetOCGState(action);
          return false;
      };
      tslib_1.__classPrivateFieldGet(this, _LinkAnnotationElement_instances, "m", _LinkAnnotationElement_setInternalLink).call(this);
  };
  var TextAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(TextAnnotationElement, _super);
      function TextAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true
          }) || this;
      }
      TextAnnotationElement.prototype.render = function () {
          this.container.classList.add("textAnnotation");
          var image = document.createElement("img");
          image.src = this.imageResourcesPath + "annotation-" + this.data.name.toLowerCase() + ".svg";
          image.setAttribute("data-l10n-id", "pdfjs-text-annotation-type");
          image.setAttribute("data-l10n-args", JSON.stringify({
              type: this.data.name
          }));
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this.container.append(image);
          return this.container;
      };
      return TextAnnotationElement;
  }(AnnotationElement));
  var WidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(WidgetAnnotationElement, _super);
      function WidgetAnnotationElement() {
          return _super !== null && _super.apply(this, arguments) || this;
      }
      WidgetAnnotationElement.prototype.render = function () {
          return this.container;
      };
      WidgetAnnotationElement.prototype.showElementAndHideCanvas = function (element) {
          var _l;
          if (this.data.hasOwnCanvas) {
              if (((_l = element.previousSibling) === null || _l === void 0 ? void 0 : _l.nodeName) === "CANVAS") {
                  element.previousSibling.hidden = true;
              }
              element.hidden = false;
          }
      };
      WidgetAnnotationElement.prototype._getKeyModifier = function (event) {
          return util_FeatureTest.platform.isMac ? event.metaKey : event.ctrlKey;
      };
      WidgetAnnotationElement.prototype._setEventListener = function (element, elementData, baseName, eventName, valueGetter) {
          var _this = this;
          if (baseName.includes("mouse")) {
              element.addEventListener(baseName, function (event) {
                  var _l;
                  (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                      source: _this,
                      detail: {
                          id: _this.data.id,
                          name: eventName,
                          value: valueGetter(event),
                          shift: event.shiftKey,
                          modifier: _this._getKeyModifier(event)
                      }
                  });
              });
          }
          else {
              element.addEventListener(baseName, function (event) {
                  var _l;
                  if (baseName === "blur") {
                      if (!elementData.focused || !event.relatedTarget) {
                          return;
                      }
                      elementData.focused = false;
                  }
                  else if (baseName === "focus") {
                      if (elementData.focused) {
                          return;
                      }
                      elementData.focused = true;
                  }
                  if (!valueGetter) {
                      return;
                  }
                  (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                      source: _this,
                      detail: {
                          id: _this.data.id,
                          name: eventName,
                          value: valueGetter(event)
                      }
                  });
              });
          }
      };
      WidgetAnnotationElement.prototype._setEventListeners = function (element, elementData, names, getter) {
          var _l, _m, _o;
          for (var _i = 0, names_2 = names; _i < names_2.length; _i++) {
              var _p = names_2[_i], baseName = _p[0], eventName = _p[1];
              if (eventName === "Action" || ((_l = this.data.actions) === null || _l === void 0 ? void 0 : _l[eventName])) {
                  if (eventName === "Focus" || eventName === "Blur") {
                      elementData || (elementData = {
                          focused: false
                      });
                  }
                  this._setEventListener(element, elementData, baseName, eventName, getter);
                  if (eventName === "Focus" && !((_m = this.data.actions) === null || _m === void 0 ? void 0 : _m.Blur)) {
                      this._setEventListener(element, elementData, "blur", "Blur", null);
                  }
                  else if (eventName === "Blur" && !((_o = this.data.actions) === null || _o === void 0 ? void 0 : _o.Focus)) {
                      this._setEventListener(element, elementData, "focus", "Focus", null);
                  }
              }
          }
      };
      WidgetAnnotationElement.prototype._setBackgroundColor = function (element) {
          var color = this.data.backgroundColor || null;
          element.style.backgroundColor = color === null ? "transparent" : Util.makeHexColor(color[0], color[1], color[2]);
      };
      WidgetAnnotationElement.prototype._setTextStyle = function (element) {
          var TEXT_ALIGNMENT = ["left", "center", "right"];
          var fontColor = this.data.defaultAppearanceData.fontColor;
          var fontSize = this.data.defaultAppearanceData.fontSize || annotation_layer_DEFAULT_FONT_SIZE;
          var style = element.style;
          var computedFontSize;
          var BORDER_SIZE = 2;
          var roundToOneDecimal = function (x) { return Math.round(10 * x) / 10; };
          if (this.data.multiLine) {
              var height = Math.abs(this.data.rect[3] - this.data.rect[1] - BORDER_SIZE);
              var numberOfLines = Math.round(height / (LINE_FACTOR * fontSize)) || 1;
              var lineHeight = height / numberOfLines;
              computedFontSize = Math.min(fontSize, roundToOneDecimal(lineHeight / LINE_FACTOR));
          }
          else {
              var height = Math.abs(this.data.rect[3] - this.data.rect[1] - BORDER_SIZE);
              computedFontSize = Math.min(fontSize, roundToOneDecimal(height / LINE_FACTOR));
          }
          style.fontSize = "calc(".concat(computedFontSize, "px * var(--scale-factor))");
          style.color = Util.makeHexColor(fontColor[0], fontColor[1], fontColor[2]);
          if (this.data.textAlignment !== null) {
              style.textAlign = TEXT_ALIGNMENT[this.data.textAlignment];
          }
      };
      WidgetAnnotationElement.prototype._setRequired = function (element, isRequired) {
          if (isRequired) {
              element.setAttribute("required", true);
          }
          else {
              element.removeAttribute("required");
          }
          element.setAttribute("aria-required", isRequired);
      };
      return WidgetAnnotationElement;
  }(AnnotationElement));
  var TextWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(TextWidgetAnnotationElement, _super);
      function TextWidgetAnnotationElement(parameters) {
          var isRenderable = parameters.renderForms || parameters.data.hasOwnCanvas || !parameters.data.hasAppearance && !!parameters.data.fieldValue;
          return _super.call(this, parameters, {
              isRenderable: isRenderable
          }) || this;
      }
      TextWidgetAnnotationElement.prototype.setPropertyOnSiblings = function (base, key, value, keyInStorage) {
          var _l;
          var storage = this.annotationStorage;
          for (var _i = 0, _m = this._getElementsByName(base.name, base.id); _i < _m.length; _i++) {
              var element = _m[_i];
              if (element.domElement) {
                  element.domElement[key] = value;
              }
              storage.setValue(element.id, (_l = {},
                  _l[keyInStorage] = value,
                  _l));
          }
      };
      TextWidgetAnnotationElement.prototype.render = function () {
          var _this = this;
          var _l, _m;
          var storage = this.annotationStorage;
          var id = this.data.id;
          this.container.classList.add("textWidgetAnnotation");
          var element = null;
          if (this.renderForms) {
              var storedData = storage.getValue(id, {
                  value: this.data.fieldValue
              });
              var textContent = storedData.value || "";
              var maxLen = storage.getValue(id, {
                  charLimit: this.data.maxLen
              }).charLimit;
              if (maxLen && textContent.length > maxLen) {
                  textContent = textContent.slice(0, maxLen);
              }
              var fieldFormattedValues = storedData.formattedValue || ((_l = this.data.textContent) === null || _l === void 0 ? void 0 : _l.join("\n")) || null;
              if (fieldFormattedValues && this.data.comb) {
                  fieldFormattedValues = fieldFormattedValues.replaceAll(/\s+/g, "");
              }
              var elementData_1 = {
                  userValue: textContent,
                  formattedValue: fieldFormattedValues,
                  lastCommittedValue: null,
                  commitKey: 1,
                  focused: false
              };
              if (this.data.multiLine) {
                  element = document.createElement("textarea");
                  element.textContent = fieldFormattedValues !== null && fieldFormattedValues !== void 0 ? fieldFormattedValues : textContent;
                  if (this.data.doNotScroll) {
                      element.style.overflowY = "hidden";
                  }
              }
              else {
                  element = document.createElement("input");
                  element.type = "text";
                  element.setAttribute("value", fieldFormattedValues !== null && fieldFormattedValues !== void 0 ? fieldFormattedValues : textContent);
                  if (this.data.doNotScroll) {
                      element.style.overflowX = "hidden";
                  }
              }
              if (this.data.hasOwnCanvas) {
                  element.hidden = true;
              }
              GetElementsByNameSet.add(element);
              element.setAttribute("data-element-id", id);
              element.disabled = this.data.readOnly;
              element.name = this.data.fieldName;
              element.tabIndex = DEFAULT_TAB_INDEX;
              this._setRequired(element, this.data.required);
              if (maxLen) {
                  element.maxLength = maxLen;
              }
              element.addEventListener("input", function (event) {
                  storage.setValue(id, {
                      value: event.target.value
                  });
                  _this.setPropertyOnSiblings(element, "value", event.target.value, "value");
                  elementData_1.formattedValue = null;
              });
              element.addEventListener("resetform", function (event) {
                  var _l;
                  var defaultValue = (_l = _this.data.defaultFieldValue) !== null && _l !== void 0 ? _l : "";
                  element.value = elementData_1.userValue = defaultValue;
                  elementData_1.formattedValue = null;
              });
              var blurListener = function (event) {
                  var formattedValue = elementData_1.formattedValue;
                  if (formattedValue !== null && formattedValue !== undefined) {
                      event.target.value = formattedValue;
                  }
                  event.target.scrollLeft = 0;
              };
              if (this.enableScripting && this.hasJSActions) {
                  element.addEventListener("focus", function (event) {
                      var _l;
                      if (elementData_1.focused) {
                          return;
                      }
                      var target = event.target;
                      if (elementData_1.userValue) {
                          target.value = elementData_1.userValue;
                      }
                      elementData_1.lastCommittedValue = target.value;
                      elementData_1.commitKey = 1;
                      if (!((_l = _this.data.actions) === null || _l === void 0 ? void 0 : _l.Focus)) {
                          elementData_1.focused = true;
                      }
                  });
                  element.addEventListener("updatefromsandbox", function (jsEvent) {
                      _this.showElementAndHideCanvas(jsEvent.target);
                      var actions = {
                          value: function (event) {
                              var _l;
                              elementData_1.userValue = (_l = event.detail.value) !== null && _l !== void 0 ? _l : "";
                              storage.setValue(id, {
                                  value: elementData_1.userValue.toString()
                              });
                              event.target.value = elementData_1.userValue;
                          },
                          formattedValue: function (event) {
                              var formattedValue = event.detail.formattedValue;
                              elementData_1.formattedValue = formattedValue;
                              if (formattedValue !== null && formattedValue !== undefined && event.target !== document.activeElement) {
                                  event.target.value = formattedValue;
                              }
                              storage.setValue(id, {
                                  formattedValue: formattedValue
                              });
                          },
                          selRange: function (event) {
                              var _l;
                              (_l = event.target).setSelectionRange.apply(_l, event.detail.selRange);
                          },
                          charLimit: function (event) {
                              var _l;
                              var charLimit = event.detail.charLimit;
                              var target = event.target;
                              if (charLimit === 0) {
                                  target.removeAttribute("maxLength");
                                  return;
                              }
                              target.setAttribute("maxLength", charLimit);
                              var value = elementData_1.userValue;
                              if (!value || value.length <= charLimit) {
                                  return;
                              }
                              value = value.slice(0, charLimit);
                              target.value = elementData_1.userValue = value;
                              storage.setValue(id, {
                                  value: value
                              });
                              (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                                  source: _this,
                                  detail: {
                                      id: id,
                                      name: "Keystroke",
                                      value: value,
                                      willCommit: true,
                                      commitKey: 1,
                                      selStart: target.selectionStart,
                                      selEnd: target.selectionEnd
                                  }
                              });
                          }
                      };
                      _this._dispatchEventFromSandbox(actions, jsEvent);
                  });
                  element.addEventListener("keydown", function (event) {
                      var _l;
                      elementData_1.commitKey = 1;
                      var commitKey = -1;
                      if (event.key === "Escape") {
                          commitKey = 0;
                      }
                      else if (event.key === "Enter" && !_this.data.multiLine) {
                          commitKey = 2;
                      }
                      else if (event.key === "Tab") {
                          elementData_1.commitKey = 3;
                      }
                      if (commitKey === -1) {
                          return;
                      }
                      var value = event.target.value;
                      if (elementData_1.lastCommittedValue === value) {
                          return;
                      }
                      elementData_1.lastCommittedValue = value;
                      elementData_1.userValue = value;
                      (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                          source: _this,
                          detail: {
                              id: id,
                              name: "Keystroke",
                              value: value,
                              willCommit: true,
                              commitKey: commitKey,
                              selStart: event.target.selectionStart,
                              selEnd: event.target.selectionEnd
                          }
                      });
                  });
                  var _blurListener_1 = blurListener;
                  blurListener = null;
                  element.addEventListener("blur", function (event) {
                      var _l, _m;
                      if (!elementData_1.focused || !event.relatedTarget) {
                          return;
                      }
                      if (!((_l = _this.data.actions) === null || _l === void 0 ? void 0 : _l.Blur)) {
                          elementData_1.focused = false;
                      }
                      var value = event.target.value;
                      elementData_1.userValue = value;
                      if (elementData_1.lastCommittedValue !== value) {
                          (_m = _this.linkService.eventBus) === null || _m === void 0 ? void 0 : _m.dispatch("dispatcheventinsandbox", {
                              source: _this,
                              detail: {
                                  id: id,
                                  name: "Keystroke",
                                  value: value,
                                  willCommit: true,
                                  commitKey: elementData_1.commitKey,
                                  selStart: event.target.selectionStart,
                                  selEnd: event.target.selectionEnd
                              }
                          });
                      }
                      _blurListener_1(event);
                  });
                  if ((_m = this.data.actions) === null || _m === void 0 ? void 0 : _m.Keystroke) {
                      element.addEventListener("beforeinput", function (event) {
                          var _l;
                          elementData_1.lastCommittedValue = null;
                          var data = event.data, target = event.target;
                          var value = target.value, selectionStart = target.selectionStart, selectionEnd = target.selectionEnd;
                          var selStart = selectionStart, selEnd = selectionEnd;
                          switch (event.inputType) {
                              case "deleteWordBackward":
                                  {
                                      var match = value.substring(0, selectionStart).match(/\w*[^\w]*$/);
                                      if (match) {
                                          selStart -= match[0].length;
                                      }
                                      break;
                                  }
                              case "deleteWordForward":
                                  {
                                      var match = value.substring(selectionStart).match(/^[^\w]*\w*/);
                                      if (match) {
                                          selEnd += match[0].length;
                                      }
                                      break;
                                  }
                              case "deleteContentBackward":
                                  if (selectionStart === selectionEnd) {
                                      selStart -= 1;
                                  }
                                  break;
                              case "deleteContentForward":
                                  if (selectionStart === selectionEnd) {
                                      selEnd += 1;
                                  }
                                  break;
                          }
                          event.preventDefault();
                          (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                              source: _this,
                              detail: {
                                  id: id,
                                  name: "Keystroke",
                                  value: value,
                                  change: data || "",
                                  willCommit: false,
                                  selStart: selStart,
                                  selEnd: selEnd
                              }
                          });
                      });
                  }
                  this._setEventListeners(element, elementData_1, [["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], function (event) { return event.target.value; });
              }
              if (blurListener) {
                  element.addEventListener("blur", blurListener);
              }
              if (this.data.comb) {
                  var fieldWidth = this.data.rect[2] - this.data.rect[0];
                  var combWidth = fieldWidth / maxLen;
                  element.classList.add("comb");
                  element.style.letterSpacing = "calc(".concat(combWidth, "px * var(--scale-factor) - 1ch)");
              }
          }
          else {
              element = document.createElement("div");
              element.textContent = this.data.fieldValue;
              element.style.verticalAlign = "middle";
              element.style.display = "table-cell";
              if (this.data.hasOwnCanvas) {
                  element.hidden = true;
              }
          }
          this._setTextStyle(element);
          this._setBackgroundColor(element);
          this._setDefaultPropertiesFromJS(element);
          this.container.append(element);
          return this.container;
      };
      return TextWidgetAnnotationElement;
  }(WidgetAnnotationElement));
  var SignatureWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(SignatureWidgetAnnotationElement, _super);
      function SignatureWidgetAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: !!parameters.data.hasOwnCanvas
          }) || this;
      }
      return SignatureWidgetAnnotationElement;
  }(WidgetAnnotationElement));
  var CheckboxWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(CheckboxWidgetAnnotationElement, _super);
      function CheckboxWidgetAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: parameters.renderForms
          }) || this;
      }
      CheckboxWidgetAnnotationElement.prototype.render = function () {
          var _this = this;
          var storage = this.annotationStorage;
          var data = this.data;
          var id = data.id;
          var value = storage.getValue(id, {
              value: data.exportValue === data.fieldValue
          }).value;
          if (typeof value === "string") {
              value = value !== "Off";
              storage.setValue(id, {
                  value: value
              });
          }
          this.container.classList.add("buttonWidgetAnnotation", "checkBox");
          var element = document.createElement("input");
          GetElementsByNameSet.add(element);
          element.setAttribute("data-element-id", id);
          element.disabled = data.readOnly;
          this._setRequired(element, this.data.required);
          element.type = "checkbox";
          element.name = data.fieldName;
          if (value) {
              element.setAttribute("checked", true);
          }
          element.setAttribute("exportValue", data.exportValue);
          element.tabIndex = DEFAULT_TAB_INDEX;
          element.addEventListener("change", function (event) {
              var _l = event.target, name = _l.name, checked = _l.checked;
              for (var _i = 0, _m = _this._getElementsByName(name, id); _i < _m.length; _i++) {
                  var checkbox = _m[_i];
                  var curChecked = checked && checkbox.exportValue === data.exportValue;
                  if (checkbox.domElement) {
                      checkbox.domElement.checked = curChecked;
                  }
                  storage.setValue(checkbox.id, {
                      value: curChecked
                  });
              }
              storage.setValue(id, {
                  value: checked
              });
          });
          element.addEventListener("resetform", function (event) {
              var defaultValue = data.defaultFieldValue || "Off";
              event.target.checked = defaultValue === data.exportValue;
          });
          if (this.enableScripting && this.hasJSActions) {
              element.addEventListener("updatefromsandbox", function (jsEvent) {
                  var actions = {
                      value: function (event) {
                          event.target.checked = event.detail.value !== "Off";
                          storage.setValue(id, {
                              value: event.target.checked
                          });
                      }
                  };
                  _this._dispatchEventFromSandbox(actions, jsEvent);
              });
              this._setEventListeners(element, null, [["change", "Validate"], ["change", "Action"], ["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], function (event) { return event.target.checked; });
          }
          this._setBackgroundColor(element);
          this._setDefaultPropertiesFromJS(element);
          this.container.append(element);
          return this.container;
      };
      return CheckboxWidgetAnnotationElement;
  }(WidgetAnnotationElement));
  var RadioButtonWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(RadioButtonWidgetAnnotationElement, _super);
      function RadioButtonWidgetAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: parameters.renderForms
          }) || this;
      }
      RadioButtonWidgetAnnotationElement.prototype.render = function () {
          var _this = this;
          this.container.classList.add("buttonWidgetAnnotation", "radioButton");
          var storage = this.annotationStorage;
          var data = this.data;
          var id = data.id;
          var value = storage.getValue(id, {
              value: data.fieldValue === data.buttonValue
          }).value;
          if (typeof value === "string") {
              value = value !== data.buttonValue;
              storage.setValue(id, {
                  value: value
              });
          }
          if (value) {
              for (var _i = 0, _l = this._getElementsByName(data.fieldName, id); _i < _l.length; _i++) {
                  var radio = _l[_i];
                  storage.setValue(radio.id, {
                      value: false
                  });
              }
          }
          var element = document.createElement("input");
          GetElementsByNameSet.add(element);
          element.setAttribute("data-element-id", id);
          element.disabled = data.readOnly;
          this._setRequired(element, this.data.required);
          element.type = "radio";
          element.name = data.fieldName;
          if (value) {
              element.setAttribute("checked", true);
          }
          element.tabIndex = DEFAULT_TAB_INDEX;
          element.addEventListener("change", function (event) {
              var _l = event.target, name = _l.name, checked = _l.checked;
              for (var _i = 0, _m = _this._getElementsByName(name, id); _i < _m.length; _i++) {
                  var radio = _m[_i];
                  storage.setValue(radio.id, {
                      value: false
                  });
              }
              storage.setValue(id, {
                  value: checked
              });
          });
          element.addEventListener("resetform", function (event) {
              var defaultValue = data.defaultFieldValue;
              event.target.checked = defaultValue !== null && defaultValue !== undefined && defaultValue === data.buttonValue;
          });
          if (this.enableScripting && this.hasJSActions) {
              var pdfButtonValue_1 = data.buttonValue;
              element.addEventListener("updatefromsandbox", function (jsEvent) {
                  var actions = {
                      value: function (event) {
                          var checked = pdfButtonValue_1 === event.detail.value;
                          for (var _i = 0, _l = _this._getElementsByName(event.target.name); _i < _l.length; _i++) {
                              var radio = _l[_i];
                              var curChecked = checked && radio.id === id;
                              if (radio.domElement) {
                                  radio.domElement.checked = curChecked;
                              }
                              storage.setValue(radio.id, {
                                  value: curChecked
                              });
                          }
                      }
                  };
                  _this._dispatchEventFromSandbox(actions, jsEvent);
              });
              this._setEventListeners(element, null, [["change", "Validate"], ["change", "Action"], ["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], function (event) { return event.target.checked; });
          }
          this._setBackgroundColor(element);
          this._setDefaultPropertiesFromJS(element);
          this.container.append(element);
          return this.container;
      };
      return RadioButtonWidgetAnnotationElement;
  }(WidgetAnnotationElement));
  var PushButtonWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(PushButtonWidgetAnnotationElement, _super);
      function PushButtonWidgetAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              ignoreBorder: parameters.data.hasAppearance
          }) || this;
      }
      PushButtonWidgetAnnotationElement.prototype.render = function () {
          var _this = this;
          var container = _super.prototype.render.call(this);
          container.classList.add("buttonWidgetAnnotation", "pushButton");
          var linkElement = container.lastChild;
          if (this.enableScripting && this.hasJSActions && linkElement) {
              this._setDefaultPropertiesFromJS(linkElement);
              linkElement.addEventListener("updatefromsandbox", function (jsEvent) {
                  _this._dispatchEventFromSandbox({}, jsEvent);
              });
          }
          return container;
      };
      return PushButtonWidgetAnnotationElement;
  }(LinkAnnotationElement));
  var ChoiceWidgetAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(ChoiceWidgetAnnotationElement, _super);
      function ChoiceWidgetAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: parameters.renderForms
          }) || this;
      }
      ChoiceWidgetAnnotationElement.prototype.render = function () {
          var _this = this;
          this.container.classList.add("choiceWidgetAnnotation");
          var storage = this.annotationStorage;
          var id = this.data.id;
          var storedData = storage.getValue(id, {
              value: this.data.fieldValue
          });
          var selectElement = document.createElement("select");
          GetElementsByNameSet.add(selectElement);
          selectElement.setAttribute("data-element-id", id);
          selectElement.disabled = this.data.readOnly;
          this._setRequired(selectElement, this.data.required);
          selectElement.name = this.data.fieldName;
          selectElement.tabIndex = DEFAULT_TAB_INDEX;
          var addAnEmptyEntry = this.data.combo && this.data.options.length > 0;
          if (!this.data.combo) {
              selectElement.size = this.data.options.length;
              if (this.data.multiSelect) {
                  selectElement.multiple = true;
              }
          }
          selectElement.addEventListener("resetform", function (event) {
              var defaultValue = _this.data.defaultFieldValue;
              for (var _i = 0, _l = selectElement.options; _i < _l.length; _i++) {
                  var option = _l[_i];
                  option.selected = option.value === defaultValue;
              }
          });
          for (var _i = 0, _l = this.data.options; _i < _l.length; _i++) {
              var option = _l[_i];
              var optionElement = document.createElement("option");
              optionElement.textContent = option.displayValue;
              optionElement.value = option.exportValue;
              if (storedData.value.includes(option.exportValue)) {
                  optionElement.setAttribute("selected", true);
                  addAnEmptyEntry = false;
              }
              selectElement.append(optionElement);
          }
          var removeEmptyEntry = null;
          if (addAnEmptyEntry) {
              var noneOptionElement_1 = document.createElement("option");
              noneOptionElement_1.value = " ";
              noneOptionElement_1.setAttribute("hidden", true);
              noneOptionElement_1.setAttribute("selected", true);
              selectElement.prepend(noneOptionElement_1);
              removeEmptyEntry = function () {
                  noneOptionElement_1.remove();
                  selectElement.removeEventListener("input", removeEmptyEntry);
                  removeEmptyEntry = null;
              };
              selectElement.addEventListener("input", removeEmptyEntry);
          }
          var getValue = function (isExport) {
              var name = isExport ? "value" : "textContent";
              var options = selectElement.options, multiple = selectElement.multiple;
              if (!multiple) {
                  return options.selectedIndex === -1 ? null : options[options.selectedIndex][name];
              }
              return Array.prototype.filter.call(options, function (option) { return option.selected; }).map(function (option) { return option[name]; });
          };
          var selectedValues = getValue(false);
          var getItems = function (event) {
              var options = event.target.options;
              return Array.prototype.map.call(options, function (option) { return ({
                  displayValue: option.textContent,
                  exportValue: option.value
              }); });
          };
          if (this.enableScripting && this.hasJSActions) {
              selectElement.addEventListener("updatefromsandbox", function (jsEvent) {
                  var actions = {
                      value: function (event) {
                          removeEmptyEntry === null || removeEmptyEntry === void 0 ? void 0 : removeEmptyEntry();
                          var value = event.detail.value;
                          var values = new Set(Array.isArray(value) ? value : [value]);
                          for (var _i = 0, _l = selectElement.options; _i < _l.length; _i++) {
                              var option = _l[_i];
                              option.selected = values.has(option.value);
                          }
                          storage.setValue(id, {
                              value: getValue(true)
                          });
                          selectedValues = getValue(false);
                      },
                      multipleSelection: function (event) {
                          selectElement.multiple = true;
                      },
                      remove: function (event) {
                          var options = selectElement.options;
                          var index = event.detail.remove;
                          options[index].selected = false;
                          selectElement.remove(index);
                          if (options.length > 0) {
                              var i = Array.prototype.findIndex.call(options, function (option) { return option.selected; });
                              if (i === -1) {
                                  options[0].selected = true;
                              }
                          }
                          storage.setValue(id, {
                              value: getValue(true),
                              items: getItems(event)
                          });
                          selectedValues = getValue(false);
                      },
                      clear: function (event) {
                          while (selectElement.length !== 0) {
                              selectElement.remove(0);
                          }
                          storage.setValue(id, {
                              value: null,
                              items: []
                          });
                          selectedValues = getValue(false);
                      },
                      insert: function (event) {
                          var _l = event.detail.insert, index = _l.index, displayValue = _l.displayValue, exportValue = _l.exportValue;
                          var selectChild = selectElement.children[index];
                          var optionElement = document.createElement("option");
                          optionElement.textContent = displayValue;
                          optionElement.value = exportValue;
                          if (selectChild) {
                              selectChild.before(optionElement);
                          }
                          else {
                              selectElement.append(optionElement);
                          }
                          storage.setValue(id, {
                              value: getValue(true),
                              items: getItems(event)
                          });
                          selectedValues = getValue(false);
                      },
                      items: function (event) {
                          var items = event.detail.items;
                          while (selectElement.length !== 0) {
                              selectElement.remove(0);
                          }
                          for (var _i = 0, items_2 = items; _i < items_2.length; _i++) {
                              var item = items_2[_i];
                              var displayValue = item.displayValue, exportValue = item.exportValue;
                              var optionElement = document.createElement("option");
                              optionElement.textContent = displayValue;
                              optionElement.value = exportValue;
                              selectElement.append(optionElement);
                          }
                          if (selectElement.options.length > 0) {
                              selectElement.options[0].selected = true;
                          }
                          storage.setValue(id, {
                              value: getValue(true),
                              items: getItems(event)
                          });
                          selectedValues = getValue(false);
                      },
                      indices: function (event) {
                          var indices = new Set(event.detail.indices);
                          for (var _i = 0, _l = event.target.options; _i < _l.length; _i++) {
                              var option = _l[_i];
                              option.selected = indices.has(option.index);
                          }
                          storage.setValue(id, {
                              value: getValue(true)
                          });
                          selectedValues = getValue(false);
                      },
                      editable: function (event) {
                          event.target.disabled = !event.detail.editable;
                      }
                  };
                  _this._dispatchEventFromSandbox(actions, jsEvent);
              });
              selectElement.addEventListener("input", function (event) {
                  var _l;
                  var exportValue = getValue(true);
                  var change = getValue(false);
                  storage.setValue(id, {
                      value: exportValue
                  });
                  event.preventDefault();
                  (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("dispatcheventinsandbox", {
                      source: _this,
                      detail: {
                          id: id,
                          name: "Keystroke",
                          value: selectedValues,
                          change: change,
                          changeEx: exportValue,
                          willCommit: false,
                          commitKey: 1,
                          keyDown: false
                      }
                  });
              });
              this._setEventListeners(selectElement, null, [["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"], ["input", "Action"], ["input", "Validate"]], function (event) { return event.target.value; });
          }
          else {
              selectElement.addEventListener("input", function (event) {
                  storage.setValue(id, {
                      value: getValue(true)
                  });
              });
          }
          if (this.data.combo) {
              this._setTextStyle(selectElement);
          }
          else { }
          this._setBackgroundColor(selectElement);
          this._setDefaultPropertiesFromJS(selectElement);
          this.container.append(selectElement);
          return this.container;
      };
      return ChoiceWidgetAnnotationElement;
  }(WidgetAnnotationElement));
  var PopupAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(PopupAnnotationElement, _super);
      function PopupAnnotationElement(parameters) {
          var _this = this;
          var data = parameters.data, elements = parameters.elements;
          _this = _super.call(this, parameters, {
              isRenderable: AnnotationElement._hasPopupData(data)
          }) || this;
          _this.elements = elements;
          _this.popup = null;
          return _this;
      }
      PopupAnnotationElement.prototype.render = function () {
          this.container.classList.add("popupAnnotation");
          var popup = this.popup = new PopupElement({
              container: this.container,
              color: this.data.color,
              titleObj: this.data.titleObj,
              modificationDate: this.data.modificationDate,
              contentsObj: this.data.contentsObj,
              richText: this.data.richText,
              rect: this.data.rect,
              parentRect: this.data.parentRect || null,
              parent: this.parent,
              elements: this.elements,
              open: this.data.open
          });
          var elementIds = [];
          for (var _i = 0, _l = this.elements; _i < _l.length; _i++) {
              var element = _l[_i];
              element.popup = popup;
              elementIds.push(element.data.id);
              element.addHighlightArea();
          }
          this.container.setAttribute("aria-controls", elementIds.map(function (id) { return "".concat(AnnotationPrefix).concat(id); }).join(","));
          return this.container;
      };
      return PopupAnnotationElement;
  }(AnnotationElement));
  var PopupElement = /** @class */ (function () {
      function PopupElement(_l) {
          var container = _l.container, color = _l.color, elements = _l.elements, titleObj = _l.titleObj, modificationDate = _l.modificationDate, contentsObj = _l.contentsObj, richText = _l.richText, parent = _l.parent, rect = _l.rect, parentRect = _l.parentRect, open = _l.open;
          var _m;
          _PopupElement_instances.add(this);
          _PopupElement_boundKeyDown.set(this, tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_keyDown).bind(this));
          _PopupElement_boundHide.set(this, tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_hide).bind(this));
          _PopupElement_boundShow.set(this, tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_show).bind(this));
          _PopupElement_boundToggle.set(this, tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_toggle).bind(this));
          _PopupElement_color.set(this, null);
          _PopupElement_container.set(this, null);
          _PopupElement_contentsObj.set(this, null);
          _PopupElement_dateObj.set(this, null);
          _PopupElement_elements.set(this, null);
          _PopupElement_parent.set(this, null);
          _PopupElement_parentRect.set(this, null);
          _PopupElement_pinned.set(this, false);
          _PopupElement_popup.set(this, null);
          _PopupElement_position.set(this, null);
          _PopupElement_rect.set(this, null);
          _PopupElement_richText.set(this, null);
          _PopupElement_titleObj.set(this, null);
          _PopupElement_updates.set(this, null);
          _PopupElement_wasVisible.set(this, false);
          tslib_1.__classPrivateFieldSet(this, _PopupElement_container, container, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_titleObj, titleObj, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_contentsObj, contentsObj, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_richText, richText, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_parent, parent, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_color, color, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_rect, rect, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_parentRect, parentRect, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_elements, elements, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_dateObj, PDFDateString.toDateObject(modificationDate), "f");
          this.trigger = elements.flatMap(function (e) { return e.getElementsToTriggerPopup(); });
          for (var _i = 0, _o = this.trigger; _i < _o.length; _i++) {
              var element = _o[_i];
              element.addEventListener("click", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundToggle, "f"));
              element.addEventListener("mouseenter", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundShow, "f"));
              element.addEventListener("mouseleave", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundHide, "f"));
              element.classList.add("popupTriggerArea");
          }
          for (var _p = 0, elements_1 = elements; _p < elements_1.length; _p++) {
              var element = elements_1[_p];
              (_m = element.container) === null || _m === void 0 ? void 0 : _m.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundKeyDown, "f"));
          }
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden = true;
          if (open) {
              tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_toggle).call(this);
          }
      }
      PopupElement.prototype.render = function () {
          var _l;
          if (tslib_1.__classPrivateFieldGet(this, _PopupElement_popup, "f")) {
              return;
          }
          var popup = tslib_1.__classPrivateFieldSet(this, _PopupElement_popup, document.createElement("div"), "f");
          popup.className = "popup";
          if (tslib_1.__classPrivateFieldGet(this, _PopupElement_color, "f")) {
              var baseColor = popup.style.outlineColor = Util.makeHexColor.apply(Util, tslib_1.__classPrivateFieldGet(this, _PopupElement_color, "f"));
              if (CSS.supports("background-color", "color-mix(in srgb, red 30%, white)")) {
                  popup.style.backgroundColor = "color-mix(in srgb, ".concat(baseColor, " 30%, white)");
              }
              else {
                  var BACKGROUND_ENLIGHT_1 = 0.7;
                  popup.style.backgroundColor = Util.makeHexColor.apply(Util, tslib_1.__classPrivateFieldGet(this, _PopupElement_color, "f").map(function (c) { return Math.floor(BACKGROUND_ENLIGHT_1 * (255 - c) + c); }));
              }
          }
          var header = document.createElement("span");
          header.className = "header";
          var title = document.createElement("h1");
          header.append(title);
          (_l = tslib_1.__classPrivateFieldGet(this, _PopupElement_titleObj, "f"), title.dir = _l.dir, title.textContent = _l.str);
          popup.append(header);
          if (tslib_1.__classPrivateFieldGet(this, _PopupElement_dateObj, "f")) {
              var modificationDate = document.createElement("span");
              modificationDate.classList.add("popupDate");
              modificationDate.setAttribute("data-l10n-id", "pdfjs-annotation-date-string");
              modificationDate.setAttribute("data-l10n-args", JSON.stringify({
                  date: tslib_1.__classPrivateFieldGet(this, _PopupElement_dateObj, "f").toLocaleDateString(),
                  time: tslib_1.__classPrivateFieldGet(this, _PopupElement_dateObj, "f").toLocaleTimeString()
              }));
              header.append(modificationDate);
          }
          var html = tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_html_get);
          if (html) {
              XfaLayer.render({
                  xfaHtml: html,
                  intent: "richText",
                  div: popup
              });
              popup.lastChild.classList.add("richText", "popupContent");
          }
          else {
              var contents = this._formatContents(tslib_1.__classPrivateFieldGet(this, _PopupElement_contentsObj, "f"));
              popup.append(contents);
          }
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").append(popup);
      };
      PopupElement.prototype._formatContents = function (_l) {
          var str = _l.str, dir = _l.dir;
          var p = document.createElement("p");
          p.classList.add("popupContent");
          p.dir = dir;
          var lines = str.split(/(?:\r\n?|\n)/);
          for (var i = 0, ii = lines.length; i < ii; ++i) {
              var line = lines[i];
              p.append(document.createTextNode(line));
              if (i < ii - 1) {
                  p.append(document.createElement("br"));
              }
          }
          return p;
      };
      PopupElement.prototype.updateEdited = function (_l) {
          var _m;
          var rect = _l.rect, popupContent = _l.popupContent;
          tslib_1.__classPrivateFieldSet(this, _PopupElement_updates, tslib_1.__classPrivateFieldGet(this, _PopupElement_updates, "f") || {
              contentsObj: tslib_1.__classPrivateFieldGet(this, _PopupElement_contentsObj, "f"),
              richText: tslib_1.__classPrivateFieldGet(this, _PopupElement_richText, "f")
          }, "f");
          if (rect) {
              tslib_1.__classPrivateFieldSet(this, _PopupElement_position, null, "f");
          }
          if (popupContent) {
              tslib_1.__classPrivateFieldSet(this, _PopupElement_richText, tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_makePopupContent).call(this, popupContent), "f");
              tslib_1.__classPrivateFieldSet(this, _PopupElement_contentsObj, null, "f");
          }
          (_m = tslib_1.__classPrivateFieldGet(this, _PopupElement_popup, "f")) === null || _m === void 0 ? void 0 : _m.remove();
          tslib_1.__classPrivateFieldSet(this, _PopupElement_popup, null, "f");
      };
      PopupElement.prototype.resetEdited = function () {
          var _l;
          var _m;
          var _o, _p;
          if (!tslib_1.__classPrivateFieldGet(this, _PopupElement_updates, "f")) {
              return;
          }
          (_o = this, _p = this, _l = tslib_1.__classPrivateFieldGet(this, _PopupElement_updates, "f"), ({ set value(_a) { tslib_1.__classPrivateFieldSet(_o, _PopupElement_contentsObj, _a, "f"); } }).value = _l.contentsObj, ({ set value(_a) { tslib_1.__classPrivateFieldSet(_p, _PopupElement_richText, _a, "f"); } }).value = _l.richText);
          tslib_1.__classPrivateFieldSet(this, _PopupElement_updates, null, "f");
          (_m = tslib_1.__classPrivateFieldGet(this, _PopupElement_popup, "f")) === null || _m === void 0 ? void 0 : _m.remove();
          tslib_1.__classPrivateFieldSet(this, _PopupElement_popup, null, "f");
          tslib_1.__classPrivateFieldSet(this, _PopupElement_position, null, "f");
      };
      PopupElement.prototype.forceHide = function () {
          tslib_1.__classPrivateFieldSet(this, _PopupElement_wasVisible, this.isVisible, "f");
          if (!tslib_1.__classPrivateFieldGet(this, _PopupElement_wasVisible, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden = true;
      };
      PopupElement.prototype.maybeShow = function () {
          if (!tslib_1.__classPrivateFieldGet(this, _PopupElement_wasVisible, "f")) {
              return;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _PopupElement_popup, "f")) {
              tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_show).call(this);
          }
          tslib_1.__classPrivateFieldSet(this, _PopupElement_wasVisible, false, "f");
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden = false;
      };
      Object.defineProperty(PopupElement.prototype, "isVisible", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden === false;
          },
          enumerable: false,
          configurable: true
      });
      return PopupElement;
  }());
  _PopupElement_boundKeyDown = new WeakMap(), _PopupElement_boundHide = new WeakMap(), _PopupElement_boundShow = new WeakMap(), _PopupElement_boundToggle = new WeakMap(), _PopupElement_color = new WeakMap(), _PopupElement_container = new WeakMap(), _PopupElement_contentsObj = new WeakMap(), _PopupElement_dateObj = new WeakMap(), _PopupElement_elements = new WeakMap(), _PopupElement_parent = new WeakMap(), _PopupElement_parentRect = new WeakMap(), _PopupElement_pinned = new WeakMap(), _PopupElement_popup = new WeakMap(), _PopupElement_position = new WeakMap(), _PopupElement_rect = new WeakMap(), _PopupElement_richText = new WeakMap(), _PopupElement_titleObj = new WeakMap(), _PopupElement_updates = new WeakMap(), _PopupElement_wasVisible = new WeakMap(), _PopupElement_instances = new WeakSet(), _PopupElement_html_get = function _PopupElement_html_get() {
      var richText = tslib_1.__classPrivateFieldGet(this, _PopupElement_richText, "f");
      var contentsObj = tslib_1.__classPrivateFieldGet(this, _PopupElement_contentsObj, "f");
      if ((richText === null || richText === void 0 ? void 0 : richText.str) && (!(contentsObj === null || contentsObj === void 0 ? void 0 : contentsObj.str) || contentsObj.str === richText.str)) {
          return tslib_1.__classPrivateFieldGet(this, _PopupElement_richText, "f").html || null;
      }
      return null;
  }, _PopupElement_fontSize_get = function _PopupElement_fontSize_get() {
      var _l, _m, _o;
      return ((_o = (_m = (_l = tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_html_get)) === null || _l === void 0 ? void 0 : _l.attributes) === null || _m === void 0 ? void 0 : _m.style) === null || _o === void 0 ? void 0 : _o.fontSize) || 0;
  }, _PopupElement_fontColor_get = function _PopupElement_fontColor_get() {
      var _l, _m, _o;
      return ((_o = (_m = (_l = tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_html_get)) === null || _l === void 0 ? void 0 : _l.attributes) === null || _m === void 0 ? void 0 : _m.style) === null || _o === void 0 ? void 0 : _o.color) || null;
  }, _PopupElement_makePopupContent = function _PopupElement_makePopupContent(text) {
      var popupLines = [];
      var popupContent = {
          str: text,
          html: {
              name: "div",
              attributes: {
                  dir: "auto"
              },
              children: [{
                      name: "p",
                      children: popupLines
                  }]
          }
      };
      var lineAttributes = {
          style: {
              color: tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_fontColor_get),
              fontSize: tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_fontSize_get) ? "calc(".concat(tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "a", _PopupElement_fontSize_get), "px * var(--scale-factor))") : ""
          }
      };
      for (var _i = 0, _l = text.split("\n"); _i < _l.length; _i++) {
          var line = _l[_i];
          popupLines.push({
              name: "span",
              value: line,
              attributes: lineAttributes
          });
      }
      return popupContent;
  }, _PopupElement_keyDown = function _PopupElement_keyDown(event) {
      if (event.altKey || event.shiftKey || event.ctrlKey || event.metaKey) {
          return;
      }
      if (event.key === "Enter" || event.key === "Escape" && tslib_1.__classPrivateFieldGet(this, _PopupElement_pinned, "f")) {
          tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_toggle).call(this);
      }
  }, _PopupElement_setPosition = function _PopupElement_setPosition() {
      if (tslib_1.__classPrivateFieldGet(this, _PopupElement_position, "f") !== null) {
          return;
      }
      var _l = tslib_1.__classPrivateFieldGet(this, _PopupElement_parent, "f"), view = _l.page.view, _m = _l.viewport.rawDims, pageWidth = _m.pageWidth, pageHeight = _m.pageHeight, pageX = _m.pageX, pageY = _m.pageY;
      var useParentRect = !!tslib_1.__classPrivateFieldGet(this, _PopupElement_parentRect, "f");
      var rect = useParentRect ? tslib_1.__classPrivateFieldGet(this, _PopupElement_parentRect, "f") : tslib_1.__classPrivateFieldGet(this, _PopupElement_rect, "f");
      for (var _i = 0, _o = tslib_1.__classPrivateFieldGet(this, _PopupElement_elements, "f"); _i < _o.length; _i++) {
          var element = _o[_i];
          if (!rect || Util.intersect(element.data.rect, rect) !== null) {
              rect = element.data.rect;
              useParentRect = true;
              break;
          }
      }
      var normalizedRect = Util.normalizeRect([rect[0], view[3] - rect[1] + view[1], rect[2], view[3] - rect[3] + view[1]]);
      var HORIZONTAL_SPACE_AFTER_ANNOTATION = 5;
      var parentWidth = useParentRect ? rect[2] - rect[0] + HORIZONTAL_SPACE_AFTER_ANNOTATION : 0;
      var popupLeft = normalizedRect[0] + parentWidth;
      var popupTop = normalizedRect[1];
      tslib_1.__classPrivateFieldSet(this, _PopupElement_position, [100 * (popupLeft - pageX) / pageWidth, 100 * (popupTop - pageY) / pageHeight], "f");
      var style = tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").style;
      style.left = "".concat(tslib_1.__classPrivateFieldGet(this, _PopupElement_position, "f")[0], "%");
      style.top = "".concat(tslib_1.__classPrivateFieldGet(this, _PopupElement_position, "f")[1], "%");
  }, _PopupElement_toggle = function _PopupElement_toggle() {
      tslib_1.__classPrivateFieldSet(this, _PopupElement_pinned, !tslib_1.__classPrivateFieldGet(this, _PopupElement_pinned, "f"), "f");
      if (tslib_1.__classPrivateFieldGet(this, _PopupElement_pinned, "f")) {
          tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_show).call(this);
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").addEventListener("click", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundToggle, "f"));
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundKeyDown, "f"));
      }
      else {
          tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_hide).call(this);
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").removeEventListener("click", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundToggle, "f"));
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").removeEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _PopupElement_boundKeyDown, "f"));
      }
  }, _PopupElement_show = function _PopupElement_show() {
      if (!tslib_1.__classPrivateFieldGet(this, _PopupElement_popup, "f")) {
          this.render();
      }
      if (!this.isVisible) {
          tslib_1.__classPrivateFieldGet(this, _PopupElement_instances, "m", _PopupElement_setPosition).call(this);
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden = false;
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").style.zIndex = parseInt(tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").style.zIndex) + 1000;
      }
      else if (tslib_1.__classPrivateFieldGet(this, _PopupElement_pinned, "f")) {
          tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").classList.add("focused");
      }
  }, _PopupElement_hide = function _PopupElement_hide() {
      tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").classList.remove("focused");
      if (tslib_1.__classPrivateFieldGet(this, _PopupElement_pinned, "f") || !this.isVisible) {
          return;
      }
      tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").hidden = true;
      tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").style.zIndex = parseInt(tslib_1.__classPrivateFieldGet(this, _PopupElement_container, "f").style.zIndex) - 1000;
  };
  var FreeTextAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(FreeTextAnnotationElement, _super);
      function FreeTextAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _this.textContent = parameters.data.textContent;
          _this.textPosition = parameters.data.textPosition;
          _this.annotationEditorType = AnnotationEditorType.FREETEXT;
          return _this;
      }
      FreeTextAnnotationElement.prototype.render = function () {
          this.container.classList.add("freeTextAnnotation");
          if (this.textContent) {
              var content = document.createElement("div");
              content.classList.add("annotationTextContent");
              content.setAttribute("role", "comment");
              for (var _i = 0, _l = this.textContent; _i < _l.length; _i++) {
                  var line = _l[_i];
                  var lineSpan = document.createElement("span");
                  lineSpan.textContent = line;
                  content.append(lineSpan);
              }
              this.container.append(content);
          }
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this._editOnDoubleClick();
          return this.container;
      };
      Object.defineProperty(FreeTextAnnotationElement.prototype, "_isEditable", {
          get: function () {
              return this.data.hasOwnCanvas;
          },
          enumerable: false,
          configurable: true
      });
      return FreeTextAnnotationElement;
  }(AnnotationElement));
  var LineAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(LineAnnotationElement, _super);
      function LineAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _LineAnnotationElement_line.set(_this, null);
          return _this;
      }
      LineAnnotationElement.prototype.render = function () {
          this.container.classList.add("lineAnnotation");
          var data = this.data;
          var _l = getRectDims(data.rect), width = _l.width, height = _l.height;
          var svg = this.svgFactory.create(width, height, true);
          var line = tslib_1.__classPrivateFieldSet(this, _LineAnnotationElement_line, this.svgFactory.createElement("svg:line"), "f");
          line.setAttribute("x1", data.rect[2] - data.lineCoordinates[0]);
          line.setAttribute("y1", data.rect[3] - data.lineCoordinates[1]);
          line.setAttribute("x2", data.rect[2] - data.lineCoordinates[2]);
          line.setAttribute("y2", data.rect[3] - data.lineCoordinates[3]);
          line.setAttribute("stroke-width", data.borderStyle.width || 1);
          line.setAttribute("stroke", "transparent");
          line.setAttribute("fill", "transparent");
          svg.append(line);
          this.container.append(svg);
          if (!data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      LineAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _LineAnnotationElement_line, "f");
      };
      LineAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return LineAnnotationElement;
  }(AnnotationElement));
  _LineAnnotationElement_line = new WeakMap();
  var SquareAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(SquareAnnotationElement, _super);
      function SquareAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _SquareAnnotationElement_square.set(_this, null);
          return _this;
      }
      SquareAnnotationElement.prototype.render = function () {
          this.container.classList.add("squareAnnotation");
          var data = this.data;
          var _l = getRectDims(data.rect), width = _l.width, height = _l.height;
          var svg = this.svgFactory.create(width, height, true);
          var borderWidth = data.borderStyle.width;
          var square = tslib_1.__classPrivateFieldSet(this, _SquareAnnotationElement_square, this.svgFactory.createElement("svg:rect"), "f");
          square.setAttribute("x", borderWidth / 2);
          square.setAttribute("y", borderWidth / 2);
          square.setAttribute("width", width - borderWidth);
          square.setAttribute("height", height - borderWidth);
          square.setAttribute("stroke-width", borderWidth || 1);
          square.setAttribute("stroke", "transparent");
          square.setAttribute("fill", "transparent");
          svg.append(square);
          this.container.append(svg);
          if (!data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      SquareAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _SquareAnnotationElement_square, "f");
      };
      SquareAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return SquareAnnotationElement;
  }(AnnotationElement));
  _SquareAnnotationElement_square = new WeakMap();
  var CircleAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(CircleAnnotationElement, _super);
      function CircleAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _CircleAnnotationElement_circle.set(_this, null);
          return _this;
      }
      CircleAnnotationElement.prototype.render = function () {
          this.container.classList.add("circleAnnotation");
          var data = this.data;
          var _l = getRectDims(data.rect), width = _l.width, height = _l.height;
          var svg = this.svgFactory.create(width, height, true);
          var borderWidth = data.borderStyle.width;
          var circle = tslib_1.__classPrivateFieldSet(this, _CircleAnnotationElement_circle, this.svgFactory.createElement("svg:ellipse"), "f");
          circle.setAttribute("cx", width / 2);
          circle.setAttribute("cy", height / 2);
          circle.setAttribute("rx", width / 2 - borderWidth / 2);
          circle.setAttribute("ry", height / 2 - borderWidth / 2);
          circle.setAttribute("stroke-width", borderWidth || 1);
          circle.setAttribute("stroke", "transparent");
          circle.setAttribute("fill", "transparent");
          svg.append(circle);
          this.container.append(svg);
          if (!data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      CircleAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _CircleAnnotationElement_circle, "f");
      };
      CircleAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return CircleAnnotationElement;
  }(AnnotationElement));
  _CircleAnnotationElement_circle = new WeakMap();
  var PolylineAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(PolylineAnnotationElement, _super);
      function PolylineAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _PolylineAnnotationElement_polyline.set(_this, null);
          _this.containerClassName = "polylineAnnotation";
          _this.svgElementName = "svg:polyline";
          return _this;
      }
      PolylineAnnotationElement.prototype.render = function () {
          this.container.classList.add(this.containerClassName);
          var data = this.data;
          var _l = getRectDims(data.rect), width = _l.width, height = _l.height;
          var svg = this.svgFactory.create(width, height, true);
          var points = [];
          for (var _i = 0, _m = data.vertices; _i < _m.length; _i++) {
              var coordinate = _m[_i];
              var x = coordinate.x - data.rect[0];
              var y = data.rect[3] - coordinate.y;
              points.push(x + "," + y);
          }
          points = points.join(" ");
          var polyline = tslib_1.__classPrivateFieldSet(this, _PolylineAnnotationElement_polyline, this.svgFactory.createElement(this.svgElementName), "f");
          polyline.setAttribute("points", points);
          polyline.setAttribute("stroke-width", data.borderStyle.width || 1);
          polyline.setAttribute("stroke", "transparent");
          polyline.setAttribute("fill", "transparent");
          svg.append(polyline);
          this.container.append(svg);
          if (!data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      PolylineAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _PolylineAnnotationElement_polyline, "f");
      };
      PolylineAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return PolylineAnnotationElement;
  }(AnnotationElement));
  _PolylineAnnotationElement_polyline = new WeakMap();
  var PolygonAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(PolygonAnnotationElement, _super);
      function PolygonAnnotationElement(parameters) {
          var _this = _super.call(this, parameters) || this;
          _this.containerClassName = "polygonAnnotation";
          _this.svgElementName = "svg:polygon";
          return _this;
      }
      return PolygonAnnotationElement;
  }(PolylineAnnotationElement));
  var CaretAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(CaretAnnotationElement, _super);
      function CaretAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
      }
      CaretAnnotationElement.prototype.render = function () {
          this.container.classList.add("caretAnnotation");
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      return CaretAnnotationElement;
  }(AnnotationElement));
  var InkAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(InkAnnotationElement, _super);
      function InkAnnotationElement(parameters) {
          var _this = _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
          _InkAnnotationElement_polylines.set(_this, []);
          _this.containerClassName = "inkAnnotation";
          _this.svgElementName = "svg:polyline";
          _this.annotationEditorType = AnnotationEditorType.INK;
          return _this;
      }
      InkAnnotationElement.prototype.render = function () {
          this.container.classList.add(this.containerClassName);
          var data = this.data;
          var _l = getRectDims(data.rect), width = _l.width, height = _l.height;
          var svg = this.svgFactory.create(width, height, true);
          for (var _i = 0, _m = data.inkLists; _i < _m.length; _i++) {
              var inkList = _m[_i];
              var points = [];
              for (var _o = 0, inkList_1 = inkList; _o < inkList_1.length; _o++) {
                  var coordinate = inkList_1[_o];
                  var x = coordinate.x - data.rect[0];
                  var y = data.rect[3] - coordinate.y;
                  points.push("".concat(x, ",").concat(y));
              }
              points = points.join(" ");
              var polyline = this.svgFactory.createElement(this.svgElementName);
              tslib_1.__classPrivateFieldGet(this, _InkAnnotationElement_polylines, "f").push(polyline);
              polyline.setAttribute("points", points);
              polyline.setAttribute("stroke-width", data.borderStyle.width || 1);
              polyline.setAttribute("stroke", "transparent");
              polyline.setAttribute("fill", "transparent");
              if (!data.popupRef && this.hasPopupData) {
                  this._createPopup();
              }
              svg.append(polyline);
          }
          this.container.append(svg);
          return this.container;
      };
      InkAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _InkAnnotationElement_polylines, "f");
      };
      InkAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return InkAnnotationElement;
  }(AnnotationElement));
  _InkAnnotationElement_polylines = new WeakMap();
  var HighlightAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(HighlightAnnotationElement, _super);
      function HighlightAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true,
              createQuadrilaterals: true
          }) || this;
      }
      HighlightAnnotationElement.prototype.render = function () {
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this.container.classList.add("highlightAnnotation");
          return this.container;
      };
      return HighlightAnnotationElement;
  }(AnnotationElement));
  var UnderlineAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(UnderlineAnnotationElement, _super);
      function UnderlineAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true,
              createQuadrilaterals: true
          }) || this;
      }
      UnderlineAnnotationElement.prototype.render = function () {
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this.container.classList.add("underlineAnnotation");
          return this.container;
      };
      return UnderlineAnnotationElement;
  }(AnnotationElement));
  var SquigglyAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(SquigglyAnnotationElement, _super);
      function SquigglyAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true,
              createQuadrilaterals: true
          }) || this;
      }
      SquigglyAnnotationElement.prototype.render = function () {
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this.container.classList.add("squigglyAnnotation");
          return this.container;
      };
      return SquigglyAnnotationElement;
  }(AnnotationElement));
  var StrikeOutAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(StrikeOutAnnotationElement, _super);
      function StrikeOutAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true,
              createQuadrilaterals: true
          }) || this;
      }
      StrikeOutAnnotationElement.prototype.render = function () {
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          this.container.classList.add("strikeoutAnnotation");
          return this.container;
      };
      return StrikeOutAnnotationElement;
  }(AnnotationElement));
  var StampAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(StampAnnotationElement, _super);
      function StampAnnotationElement(parameters) {
          return _super.call(this, parameters, {
              isRenderable: true,
              ignoreBorder: true
          }) || this;
      }
      StampAnnotationElement.prototype.render = function () {
          this.container.classList.add("stampAnnotation");
          if (!this.data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          return this.container;
      };
      return StampAnnotationElement;
  }(AnnotationElement));
  var FileAttachmentAnnotationElement = /** @class */ (function (_super) {
      tslib_1.__extends(FileAttachmentAnnotationElement, _super);
      function FileAttachmentAnnotationElement(parameters) {
          var _this = this;
          var _l;
          _this = _super.call(this, parameters, {
              isRenderable: true
          }) || this;
          _FileAttachmentAnnotationElement_instances.add(_this);
          _FileAttachmentAnnotationElement_trigger.set(_this, null);
          var file = _this.data.file;
          _this.filename = file.filename;
          _this.content = file.content;
          (_l = _this.linkService.eventBus) === null || _l === void 0 ? void 0 : _l.dispatch("fileattachmentannotation", tslib_1.__assign({ source: _this }, file));
          return _this;
      }
      FileAttachmentAnnotationElement.prototype.render = function () {
          var _this = this;
          this.container.classList.add("fileAttachmentAnnotation");
          var _l = this, container = _l.container, data = _l.data;
          var trigger;
          if (data.hasAppearance || data.fillAlpha === 0) {
              trigger = document.createElement("div");
          }
          else {
              trigger = document.createElement("img");
              trigger.src = "".concat(this.imageResourcesPath, "annotation-").concat(/paperclip/i.test(data.name) ? "paperclip" : "pushpin", ".svg");
              if (data.fillAlpha && data.fillAlpha < 1) {
                  trigger.style = "filter: opacity(".concat(Math.round(data.fillAlpha * 100), "%);");
              }
          }
          trigger.addEventListener("dblclick", tslib_1.__classPrivateFieldGet(this, _FileAttachmentAnnotationElement_instances, "m", _FileAttachmentAnnotationElement_download).bind(this));
          tslib_1.__classPrivateFieldSet(this, _FileAttachmentAnnotationElement_trigger, trigger, "f");
          var isMac = util_FeatureTest.platform.isMac;
          container.addEventListener("keydown", function (evt) {
              if (evt.key === "Enter" && (isMac ? evt.metaKey : evt.ctrlKey)) {
                  tslib_1.__classPrivateFieldGet(_this, _FileAttachmentAnnotationElement_instances, "m", _FileAttachmentAnnotationElement_download).call(_this);
              }
          });
          if (!data.popupRef && this.hasPopupData) {
              this._createPopup();
          }
          else {
              trigger.classList.add("popupTriggerArea");
          }
          container.append(trigger);
          return container;
      };
      FileAttachmentAnnotationElement.prototype.getElementsToTriggerPopup = function () {
          return tslib_1.__classPrivateFieldGet(this, _FileAttachmentAnnotationElement_trigger, "f");
      };
      FileAttachmentAnnotationElement.prototype.addHighlightArea = function () {
          this.container.classList.add("highlightArea");
      };
      return FileAttachmentAnnotationElement;
  }(AnnotationElement));
  _FileAttachmentAnnotationElement_trigger = new WeakMap(), _FileAttachmentAnnotationElement_instances = new WeakSet(), _FileAttachmentAnnotationElement_download = function _FileAttachmentAnnotationElement_download() {
      var _l;
      (_l = this.downloadManager) === null || _l === void 0 ? void 0 : _l.openOrDownloadData(this.content, this.filename);
  };
  var AnnotationLayer = /** @class */ (function () {
      function AnnotationLayer(_l) {
          var div = _l.div, accessibilityManager = _l.accessibilityManager, annotationCanvasMap = _l.annotationCanvasMap, annotationEditorUIManager = _l.annotationEditorUIManager, page = _l.page, viewport = _l.viewport;
          _AnnotationLayer_instances.add(this);
          _AnnotationLayer_accessibilityManager.set(this, null);
          _AnnotationLayer_annotationCanvasMap.set(this, null);
          _AnnotationLayer_editableAnnotations.set(this, new Map());
          this.div = div;
          tslib_1.__classPrivateFieldSet(this, _AnnotationLayer_accessibilityManager, accessibilityManager, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationLayer_annotationCanvasMap, annotationCanvasMap, "f");
          this.page = page;
          this.viewport = viewport;
          this.zIndex = 0;
          this._annotationEditorUIManager = annotationEditorUIManager;
      }
      AnnotationLayer.prototype.render = function (params) {
          var _l;
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var annotations, layer, popupToElements, elementParams, _i, annotations_1, data, isPopupAnnotation, _m, width, height, elements, element, elements, rendered;
              return tslib_1.__generator(this, function (_o) {
                  annotations = params.annotations;
                  layer = this.div;
                  setLayerDimensions(layer, this.viewport);
                  popupToElements = new Map();
                  elementParams = {
                      data: null,
                      layer: layer,
                      linkService: params.linkService,
                      downloadManager: params.downloadManager,
                      imageResourcesPath: params.imageResourcesPath || "",
                      renderForms: params.renderForms !== false,
                      svgFactory: new DOMSVGFactory(),
                      annotationStorage: params.annotationStorage || new AnnotationStorage(),
                      enableScripting: params.enableScripting === true,
                      hasJSActions: params.hasJSActions,
                      fieldObjects: params.fieldObjects,
                      parent: this,
                      elements: null
                  };
                  for (_i = 0, annotations_1 = annotations; _i < annotations_1.length; _i++) {
                      data = annotations_1[_i];
                      if (data.noHTML) {
                          continue;
                      }
                      isPopupAnnotation = data.annotationType === AnnotationType.POPUP;
                      if (!isPopupAnnotation) {
                          _m = getRectDims(data.rect), width = _m.width, height = _m.height;
                          if (width <= 0 || height <= 0) {
                              continue;
                          }
                      }
                      else {
                          elements = popupToElements.get(data.id);
                          if (!elements) {
                              continue;
                          }
                          elementParams.elements = elements;
                      }
                      elementParams.data = data;
                      element = AnnotationElementFactory.create(elementParams);
                      if (!element.isRenderable) {
                          continue;
                      }
                      if (!isPopupAnnotation && data.popupRef) {
                          elements = popupToElements.get(data.popupRef);
                          if (!elements) {
                              popupToElements.set(data.popupRef, [element]);
                          }
                          else {
                              elements.push(element);
                          }
                      }
                      rendered = element.render();
                      if (data.hidden) {
                          rendered.style.visibility = "hidden";
                      }
                      tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_instances, "m", _AnnotationLayer_appendElement).call(this, rendered, data.id);
                      if (element.annotationEditorType > 0) {
                          tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_editableAnnotations, "f").set(element.data.id, element);
                          (_l = this._annotationEditorUIManager) === null || _l === void 0 ? void 0 : _l.renderAnnotationElement(element);
                      }
                  }
                  tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_instances, "m", _AnnotationLayer_setAnnotationCanvasMap).call(this);
                  return [2 /*return*/];
              });
          });
      };
      AnnotationLayer.prototype.update = function (_l) {
          var viewport = _l.viewport;
          var layer = this.div;
          this.viewport = viewport;
          setLayerDimensions(layer, {
              rotation: viewport.rotation
          });
          tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_instances, "m", _AnnotationLayer_setAnnotationCanvasMap).call(this);
          layer.hidden = false;
      };
      AnnotationLayer.prototype.getEditableAnnotations = function () {
          return Array.from(tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_editableAnnotations, "f").values());
      };
      AnnotationLayer.prototype.getEditableAnnotation = function (id) {
          return tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_editableAnnotations, "f").get(id);
      };
      return AnnotationLayer;
  }());
  _AnnotationLayer_accessibilityManager = new WeakMap(), _AnnotationLayer_annotationCanvasMap = new WeakMap(), _AnnotationLayer_editableAnnotations = new WeakMap(), _AnnotationLayer_instances = new WeakSet(), _AnnotationLayer_appendElement = function _AnnotationLayer_appendElement(element, id) {
      var _l;
      var contentElement = element.firstChild || element;
      contentElement.id = "".concat(AnnotationPrefix).concat(id);
      this.div.append(element);
      (_l = tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_accessibilityManager, "f")) === null || _l === void 0 ? void 0 : _l.moveElementInDOM(this.div, element, contentElement, false);
  }, _AnnotationLayer_setAnnotationCanvasMap = function _AnnotationLayer_setAnnotationCanvasMap() {
      if (!tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_annotationCanvasMap, "f")) {
          return;
      }
      var layer = this.div;
      for (var _i = 0, _l = tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_annotationCanvasMap, "f"); _i < _l.length; _i++) {
          var _m = _l[_i], id = _m[0], canvas = _m[1];
          var element = layer.querySelector("[data-annotation-id=\"".concat(id, "\"]"));
          if (!element) {
              continue;
          }
          canvas.className = "annotationContent";
          var firstChild = element.firstChild;
          if (!firstChild) {
              element.append(canvas);
          }
          else if (firstChild.nodeName === "CANVAS") {
              firstChild.replaceWith(canvas);
          }
          else if (!firstChild.classList.contains("annotationContent")) {
              firstChild.before(canvas);
          }
          else {
              firstChild.after(canvas);
          }
      }
      tslib_1.__classPrivateFieldGet(this, _AnnotationLayer_annotationCanvasMap, "f").clear();
  };
  ; // CONCATENATED MODULE: ./src/display/editor/freetext.js
  var EOL_PATTERN = /\r\n?|\n/g;
  var FreeTextEditor = /** @class */ (function (_super) {
      tslib_1.__extends(FreeTextEditor, _super);
      function FreeTextEditor(params) {
          var _this = _super.call(this, tslib_1.__assign(tslib_1.__assign({}, params), { name: "freeTextEditor" })) || this;
          _FreeTextEditor_instances.add(_this);
          _FreeTextEditor_boundEditorDivBlur.set(_this, _this.editorDivBlur.bind(_this));
          _FreeTextEditor_boundEditorDivFocus.set(_this, _this.editorDivFocus.bind(_this));
          _FreeTextEditor_boundEditorDivInput.set(_this, _this.editorDivInput.bind(_this));
          _FreeTextEditor_boundEditorDivKeydown.set(_this, _this.editorDivKeydown.bind(_this));
          _FreeTextEditor_boundEditorDivPaste.set(_this, _this.editorDivPaste.bind(_this));
          _FreeTextEditor_color.set(_this, void 0);
          _FreeTextEditor_content.set(_this, "");
          _FreeTextEditor_editorDivId.set(_this, "".concat(_this.id, "-editor"));
          _FreeTextEditor_fontSize.set(_this, void 0);
          _FreeTextEditor_initialData.set(_this, null);
          tslib_1.__classPrivateFieldSet(_this, _FreeTextEditor_color, params.color || FreeTextEditor._defaultColor || AnnotationEditor._defaultLineColor, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeTextEditor_fontSize, params.fontSize || FreeTextEditor._defaultFontSize, "f");
          return _this;
      }
      Object.defineProperty(FreeTextEditor, "_keyboardManager", {
          get: function () {
              var proto = FreeTextEditor.prototype;
              var arrowChecker = function (self) { return self.isEmpty(); };
              var small = AnnotationEditorUIManager.TRANSLATE_SMALL;
              var big = AnnotationEditorUIManager.TRANSLATE_BIG;
              return shadow(this, "_keyboardManager", new KeyboardManager([[["ctrl+s", "mac+meta+s", "ctrl+p", "mac+meta+p"], proto.commitOrRemove, {
                          bubbles: true
                      }], [["ctrl+Enter", "mac+meta+Enter", "Escape", "mac+Escape"], proto.commitOrRemove], [["ArrowLeft", "mac+ArrowLeft"], proto._translateEmpty, {
                          args: [-small, 0],
                          checker: arrowChecker
                      }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], proto._translateEmpty, {
                          args: [-big, 0],
                          checker: arrowChecker
                      }], [["ArrowRight", "mac+ArrowRight"], proto._translateEmpty, {
                          args: [small, 0],
                          checker: arrowChecker
                      }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], proto._translateEmpty, {
                          args: [big, 0],
                          checker: arrowChecker
                      }], [["ArrowUp", "mac+ArrowUp"], proto._translateEmpty, {
                          args: [0, -small],
                          checker: arrowChecker
                      }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], proto._translateEmpty, {
                          args: [0, -big],
                          checker: arrowChecker
                      }], [["ArrowDown", "mac+ArrowDown"], proto._translateEmpty, {
                          args: [0, small],
                          checker: arrowChecker
                      }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], proto._translateEmpty, {
                          args: [0, big],
                          checker: arrowChecker
                      }]]));
          },
          enumerable: false,
          configurable: true
      });
      FreeTextEditor.initialize = function (l10n, uiManager) {
          AnnotationEditor.initialize(l10n, uiManager, {
              strings: ["pdfjs-free-text-default-content"]
          });
          var style = getComputedStyle(document.documentElement);
          this._internalPadding = parseFloat(style.getPropertyValue("--freetext-padding"));
      };
      FreeTextEditor.updateDefaultParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.FREETEXT_SIZE:
                  FreeTextEditor._defaultFontSize = value;
                  break;
              case AnnotationEditorParamsType.FREETEXT_COLOR:
                  FreeTextEditor._defaultColor = value;
                  break;
          }
      };
      FreeTextEditor.prototype.updateParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.FREETEXT_SIZE:
                  tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_updateFontSize).call(this, value);
                  break;
              case AnnotationEditorParamsType.FREETEXT_COLOR:
                  tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_updateColor).call(this, value);
                  break;
          }
      };
      Object.defineProperty(FreeTextEditor, "defaultPropertiesToUpdate", {
          get: function () {
              return [[AnnotationEditorParamsType.FREETEXT_SIZE, FreeTextEditor._defaultFontSize], [AnnotationEditorParamsType.FREETEXT_COLOR, FreeTextEditor._defaultColor || AnnotationEditor._defaultLineColor]];
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(FreeTextEditor.prototype, "propertiesToUpdate", {
          get: function () {
              return [[AnnotationEditorParamsType.FREETEXT_SIZE, tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f")], [AnnotationEditorParamsType.FREETEXT_COLOR, tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_color, "f")]];
          },
          enumerable: false,
          configurable: true
      });
      FreeTextEditor.prototype._translateEmpty = function (x, y) {
          this._uiManager.translateSelectedEditors(x, y, true);
      };
      FreeTextEditor.prototype.getInitialTranslation = function () {
          var scale = this.parentScale;
          return [-FreeTextEditor._internalPadding * scale, -(FreeTextEditor._internalPadding + tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f")) * scale];
      };
      FreeTextEditor.prototype.rebuild = function () {
          if (!this.parent) {
              return;
          }
          _super.prototype.rebuild.call(this);
          if (this.div === null) {
              return;
          }
          if (!this.isAttachedToDOM) {
              this.parent.add(this);
          }
      };
      FreeTextEditor.prototype.enableEditMode = function () {
          if (this.isInEditMode()) {
              return;
          }
          this.parent.setEditingState(false);
          this.parent.updateToolbar(AnnotationEditorType.FREETEXT);
          _super.prototype.enableEditMode.call(this);
          this.overlayDiv.classList.remove("enabled");
          this.editorDiv.contentEditable = true;
          this._isDraggable = false;
          this.div.removeAttribute("aria-activedescendant");
          this.editorDiv.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivKeydown, "f"));
          this.editorDiv.addEventListener("focus", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivFocus, "f"));
          this.editorDiv.addEventListener("blur", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivBlur, "f"));
          this.editorDiv.addEventListener("input", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivInput, "f"));
          this.editorDiv.addEventListener("paste", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivPaste, "f"));
      };
      FreeTextEditor.prototype.disableEditMode = function () {
          if (!this.isInEditMode()) {
              return;
          }
          this.parent.setEditingState(true);
          _super.prototype.disableEditMode.call(this);
          this.overlayDiv.classList.add("enabled");
          this.editorDiv.contentEditable = false;
          this.div.setAttribute("aria-activedescendant", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_editorDivId, "f"));
          this._isDraggable = true;
          this.editorDiv.removeEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivKeydown, "f"));
          this.editorDiv.removeEventListener("focus", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivFocus, "f"));
          this.editorDiv.removeEventListener("blur", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivBlur, "f"));
          this.editorDiv.removeEventListener("input", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivInput, "f"));
          this.editorDiv.removeEventListener("paste", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_boundEditorDivPaste, "f"));
          this.div.focus({
              preventScroll: true
          });
          this.isEditing = false;
          this.parent.div.classList.add("freetextEditing");
      };
      FreeTextEditor.prototype.focusin = function (event) {
          if (!this._focusEventsAllowed) {
              return;
          }
          _super.prototype.focusin.call(this, event);
          if (event.target !== this.editorDiv) {
              this.editorDiv.focus();
          }
      };
      FreeTextEditor.prototype.onceAdded = function () {
          var _m;
          if (this.width) {
              return;
          }
          this.enableEditMode();
          this.editorDiv.focus();
          if ((_m = this._initialOptions) === null || _m === void 0 ? void 0 : _m.isCentered) {
              this.center();
          }
          this._initialOptions = null;
      };
      FreeTextEditor.prototype.isEmpty = function () {
          return !this.editorDiv || this.editorDiv.innerText.trim() === "";
      };
      FreeTextEditor.prototype.remove = function () {
          this.isEditing = false;
          if (this.parent) {
              this.parent.setEditingState(true);
              this.parent.div.classList.add("freetextEditing");
          }
          _super.prototype.remove.call(this);
      };
      FreeTextEditor.prototype.commit = function () {
          var _this = this;
          if (!this.isInEditMode()) {
              return;
          }
          _super.prototype.commit.call(this);
          this.disableEditMode();
          var savedText = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f");
          var newText = tslib_1.__classPrivateFieldSet(this, _FreeTextEditor_content, tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_extractText).call(this).trimEnd(), "f");
          if (savedText === newText) {
              return;
          }
          var setText = function (text) {
              tslib_1.__classPrivateFieldSet(_this, _FreeTextEditor_content, text, "f");
              if (!text) {
                  _this.remove();
                  return;
              }
              tslib_1.__classPrivateFieldGet(_this, _FreeTextEditor_instances, "m", _FreeTextEditor_setContent).call(_this);
              _this._uiManager.rebuild(_this);
              tslib_1.__classPrivateFieldGet(_this, _FreeTextEditor_instances, "m", _FreeTextEditor_setEditorDimensions).call(_this);
          };
          this.addCommands({
              cmd: function () {
                  setText(newText);
              },
              undo: function () {
                  setText(savedText);
              },
              mustExec: false
          });
          tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_setEditorDimensions).call(this);
      };
      FreeTextEditor.prototype.shouldGetKeyboardEvents = function () {
          return this.isInEditMode();
      };
      FreeTextEditor.prototype.enterInEditMode = function () {
          this.enableEditMode();
          this.editorDiv.focus();
      };
      FreeTextEditor.prototype.dblclick = function (event) {
          this.enterInEditMode();
      };
      FreeTextEditor.prototype.keydown = function (event) {
          if (event.target === this.div && event.key === "Enter") {
              this.enterInEditMode();
              event.preventDefault();
          }
      };
      FreeTextEditor.prototype.editorDivKeydown = function (event) {
          FreeTextEditor._keyboardManager.exec(this, event);
      };
      FreeTextEditor.prototype.editorDivFocus = function (event) {
          this.isEditing = true;
      };
      FreeTextEditor.prototype.editorDivBlur = function (event) {
          this.isEditing = false;
      };
      FreeTextEditor.prototype.editorDivInput = function (event) {
          this.parent.div.classList.toggle("freetextEditing", this.isEmpty());
      };
      FreeTextEditor.prototype.disableEditing = function () {
          this.editorDiv.setAttribute("role", "comment");
          this.editorDiv.removeAttribute("aria-multiline");
      };
      FreeTextEditor.prototype.enableEditing = function () {
          this.editorDiv.setAttribute("role", "textbox");
          this.editorDiv.setAttribute("aria-multiline", true);
      };
      FreeTextEditor.prototype.render = function () {
          var _m, _o, _p, _q;
          var _this = this;
          if (this.div) {
              return this.div;
          }
          var baseX, baseY;
          if (this.width) {
              baseX = this.x;
              baseY = this.y;
          }
          _super.prototype.render.call(this);
          this.editorDiv = document.createElement("div");
          this.editorDiv.className = "internal";
          this.editorDiv.setAttribute("id", tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_editorDivId, "f"));
          this.editorDiv.setAttribute("data-l10n-id", "pdfjs-free-text");
          this.enableEditing();
          AnnotationEditor._l10nPromise.get("pdfjs-free-text-default-content").then(function (msg) { var _m; return (_m = _this.editorDiv) === null || _m === void 0 ? void 0 : _m.setAttribute("default-content", msg); });
          this.editorDiv.contentEditable = true;
          var style = this.editorDiv.style;
          style.fontSize = "calc(".concat(tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f"), "px * var(--scale-factor))");
          style.color = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_color, "f");
          this.div.append(this.editorDiv);
          this.overlayDiv = document.createElement("div");
          this.overlayDiv.classList.add("overlay", "enabled");
          this.div.append(this.overlayDiv);
          bindEvents(this, this.div, ["dblclick", "keydown"]);
          if (this.width) {
              var _r = this.parentDimensions, parentWidth = _r[0], parentHeight = _r[1];
              if (this.annotationElementId) {
                  var position = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_initialData, "f").position;
                  var _s = this.getInitialTranslation(), tx = _s[0], ty = _s[1];
                  _m = this.pageTranslationToScreen(tx, ty), tx = _m[0], ty = _m[1];
                  var _t = this.pageDimensions, pageWidth = _t[0], pageHeight = _t[1];
                  var _u = this.pageTranslation, pageX = _u[0], pageY = _u[1];
                  var posX = void 0, posY = void 0;
                  switch (this.rotation) {
                      case 0:
                          posX = baseX + (position[0] - pageX) / pageWidth;
                          posY = baseY + this.height - (position[1] - pageY) / pageHeight;
                          break;
                      case 90:
                          posX = baseX + (position[0] - pageX) / pageWidth;
                          posY = baseY - (position[1] - pageY) / pageHeight;
                          _o = [ty, -tx], tx = _o[0], ty = _o[1];
                          break;
                      case 180:
                          posX = baseX - this.width + (position[0] - pageX) / pageWidth;
                          posY = baseY - (position[1] - pageY) / pageHeight;
                          _p = [-tx, -ty], tx = _p[0], ty = _p[1];
                          break;
                      case 270:
                          posX = baseX + (position[0] - pageX - this.height * pageHeight) / pageWidth;
                          posY = baseY + (position[1] - pageY - this.width * pageWidth) / pageHeight;
                          _q = [-ty, tx], tx = _q[0], ty = _q[1];
                          break;
                  }
                  this.setAt(posX * parentWidth, posY * parentHeight, tx, ty);
              }
              else {
                  this.setAt(baseX * parentWidth, baseY * parentHeight, this.width * parentWidth, this.height * parentHeight);
              }
              tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_setContent).call(this);
              this._isDraggable = true;
              this.editorDiv.contentEditable = false;
          }
          else {
              this._isDraggable = false;
              this.editorDiv.contentEditable = true;
          }
          return this.div;
      };
      FreeTextEditor.prototype.editorDivPaste = function (event) {
          var clipboardData = event.clipboardData || window.clipboardData;
          var types = clipboardData.types;
          if (types.length === 1 && types[0] === "text/plain") {
              return;
          }
          event.preventDefault();
          var paste = tslib_1.__classPrivateFieldGet(FreeTextEditor, _l, "m", _FreeTextEditor_deserializeContent).call(FreeTextEditor, clipboardData.getData("text") || "").replaceAll(EOL_PATTERN, "\n");
          if (!paste) {
              return;
          }
          var selection = window.getSelection();
          if (!selection.rangeCount) {
              return;
          }
          this.editorDiv.normalize();
          selection.deleteFromDocument();
          var range = selection.getRangeAt(0);
          if (!paste.includes("\n")) {
              range.insertNode(document.createTextNode(paste));
              this.editorDiv.normalize();
              selection.collapseToStart();
              return;
          }
          var startContainer = range.startContainer, startOffset = range.startOffset;
          var bufferBefore = [];
          var bufferAfter = [];
          if (startContainer.nodeType === Node.TEXT_NODE) {
              var parent = startContainer.parentElement;
              bufferAfter.push(startContainer.nodeValue.slice(startOffset).replaceAll(EOL_PATTERN, ""));
              if (parent !== this.editorDiv) {
                  var buffer = bufferBefore;
                  for (var _i = 0, _m = this.editorDiv.childNodes; _i < _m.length; _i++) {
                      var child = _m[_i];
                      if (child === parent) {
                          buffer = bufferAfter;
                          continue;
                      }
                      buffer.push(tslib_1.__classPrivateFieldGet(FreeTextEditor, _l, "m", _FreeTextEditor_getNodeContent).call(FreeTextEditor, child));
                  }
              }
              bufferBefore.push(startContainer.nodeValue.slice(0, startOffset).replaceAll(EOL_PATTERN, ""));
          }
          else if (startContainer === this.editorDiv) {
              var buffer = bufferBefore;
              var i = 0;
              for (var _o = 0, _p = this.editorDiv.childNodes; _o < _p.length; _o++) {
                  var child = _p[_o];
                  if (i++ === startOffset) {
                      buffer = bufferAfter;
                  }
                  buffer.push(tslib_1.__classPrivateFieldGet(FreeTextEditor, _l, "m", _FreeTextEditor_getNodeContent).call(FreeTextEditor, child));
              }
          }
          tslib_1.__classPrivateFieldSet(this, _FreeTextEditor_content, "".concat(bufferBefore.join("\n")).concat(paste).concat(bufferAfter.join("\n")), "f");
          tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_setContent).call(this);
          var newRange = new Range();
          var beforeLength = bufferBefore.reduce(function (acc, line) { return acc + line.length; }, 0);
          for (var _q = 0, _r = this.editorDiv.childNodes; _q < _r.length; _q++) {
              var firstChild = _r[_q].firstChild;
              if (firstChild.nodeType === Node.TEXT_NODE) {
                  var length = firstChild.nodeValue.length;
                  if (beforeLength <= length) {
                      newRange.setStart(firstChild, beforeLength);
                      newRange.setEnd(firstChild, beforeLength);
                      break;
                  }
                  beforeLength -= length;
              }
          }
          selection.removeAllRanges();
          selection.addRange(newRange);
      };
      Object.defineProperty(FreeTextEditor.prototype, "contentDiv", {
          get: function () {
              return this.editorDiv;
          },
          enumerable: false,
          configurable: true
      });
      FreeTextEditor.deserialize = function (data, parent, uiManager) {
          var initialData = null;
          if (data instanceof FreeTextAnnotationElement) {
              var _m = data.data, _o = _m.defaultAppearanceData, fontSize = _o.fontSize, fontColor = _o.fontColor, rect = _m.rect, rotation = _m.rotation, id = _m.id, textContent = data.textContent, textPosition = data.textPosition, pageNumber = data.parent.page.pageNumber;
              if (!textContent || textContent.length === 0) {
                  return null;
              }
              initialData = data = {
                  annotationType: AnnotationEditorType.FREETEXT,
                  color: Array.from(fontColor),
                  fontSize: fontSize,
                  value: textContent.join("\n"),
                  position: textPosition,
                  pageIndex: pageNumber - 1,
                  rect: rect.slice(0),
                  rotation: rotation,
                  id: id,
                  deleted: false
              };
          }
          var editor = _super.deserialize.call(this, data, parent, uiManager);
          tslib_1.__classPrivateFieldSet(editor, _FreeTextEditor_fontSize, data.fontSize, "f");
          tslib_1.__classPrivateFieldSet(editor, _FreeTextEditor_color, Util.makeHexColor.apply(Util, data.color), "f");
          tslib_1.__classPrivateFieldSet(editor, _FreeTextEditor_content, tslib_1.__classPrivateFieldGet(FreeTextEditor, _l, "m", _FreeTextEditor_deserializeContent).call(FreeTextEditor, data.value), "f");
          editor.annotationElementId = data.id || null;
          tslib_1.__classPrivateFieldSet(editor, _FreeTextEditor_initialData, initialData, "f");
          return editor;
      };
      FreeTextEditor.prototype.serialize = function (isForCopying) {
          if (isForCopying === void 0) { isForCopying = false; }
          if (this.isEmpty()) {
              return null;
          }
          if (this.deleted) {
              return {
                  pageIndex: this.pageIndex,
                  id: this.annotationElementId,
                  deleted: true
              };
          }
          var padding = FreeTextEditor._internalPadding * this.parentScale;
          var rect = this.getRect(padding, padding);
          var color = AnnotationEditor._colorManager.convert(this.isAttachedToDOM ? getComputedStyle(this.editorDiv).color : tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_color, "f"));
          var serialized = {
              annotationType: AnnotationEditorType.FREETEXT,
              color: color,
              fontSize: tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f"),
              value: tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_serializeContent).call(this),
              pageIndex: this.pageIndex,
              rect: rect,
              rotation: this.rotation,
              structTreeParentId: this._structTreeParentId
          };
          if (isForCopying) {
              return serialized;
          }
          if (this.annotationElementId && !tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_instances, "m", _FreeTextEditor_hasElementChanged).call(this, serialized)) {
              return null;
          }
          serialized.id = this.annotationElementId;
          return serialized;
      };
      FreeTextEditor.prototype.renderAnnotationElement = function (annotation) {
          var content = _super.prototype.renderAnnotationElement.call(this, annotation);
          if (this.deleted) {
              return content;
          }
          var style = content.style;
          style.fontSize = "calc(".concat(tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f"), "px * var(--scale-factor))");
          style.color = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_color, "f");
          content.replaceChildren();
          for (var _i = 0, _m = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f").split("\n"); _i < _m.length; _i++) {
              var line = _m[_i];
              var div = document.createElement("div");
              div.append(line ? document.createTextNode(line) : document.createElement("br"));
              content.append(div);
          }
          var padding = FreeTextEditor._internalPadding * this.parentScale;
          annotation.updateEdited({
              rect: this.getRect(padding, padding),
              popupContent: tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f")
          });
          return content;
      };
      FreeTextEditor.prototype.resetAnnotationElement = function (annotation) {
          _super.prototype.resetAnnotationElement.call(this, annotation);
          annotation.resetEdited();
      };
      var _FreeTextEditor_instances, _l, _FreeTextEditor_boundEditorDivBlur, _FreeTextEditor_boundEditorDivFocus, _FreeTextEditor_boundEditorDivInput, _FreeTextEditor_boundEditorDivKeydown, _FreeTextEditor_boundEditorDivPaste, _FreeTextEditor_color, _FreeTextEditor_content, _FreeTextEditor_editorDivId, _FreeTextEditor_fontSize, _FreeTextEditor_initialData, _FreeTextEditor_updateFontSize, _FreeTextEditor_updateColor, _FreeTextEditor_extractText, _FreeTextEditor_setEditorDimensions, _FreeTextEditor_getNodeContent, _FreeTextEditor_setContent, _FreeTextEditor_serializeContent, _FreeTextEditor_deserializeContent, _FreeTextEditor_hasElementChanged;
      _l = FreeTextEditor, _FreeTextEditor_boundEditorDivBlur = new WeakMap(), _FreeTextEditor_boundEditorDivFocus = new WeakMap(), _FreeTextEditor_boundEditorDivInput = new WeakMap(), _FreeTextEditor_boundEditorDivKeydown = new WeakMap(), _FreeTextEditor_boundEditorDivPaste = new WeakMap(), _FreeTextEditor_color = new WeakMap(), _FreeTextEditor_content = new WeakMap(), _FreeTextEditor_editorDivId = new WeakMap(), _FreeTextEditor_fontSize = new WeakMap(), _FreeTextEditor_initialData = new WeakMap(), _FreeTextEditor_instances = new WeakSet(), _FreeTextEditor_updateFontSize = function _FreeTextEditor_updateFontSize(fontSize) {
          var _this = this;
          var setFontsize = function (size) {
              _this.editorDiv.style.fontSize = "calc(".concat(size, "px * var(--scale-factor))");
              _this.translate(0, -(size - tslib_1.__classPrivateFieldGet(_this, _FreeTextEditor_fontSize, "f")) * _this.parentScale);
              tslib_1.__classPrivateFieldSet(_this, _FreeTextEditor_fontSize, size, "f");
              tslib_1.__classPrivateFieldGet(_this, _FreeTextEditor_instances, "m", _FreeTextEditor_setEditorDimensions).call(_this);
          };
          var savedFontsize = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_fontSize, "f");
          this.addCommands({
              cmd: setFontsize.bind(this, fontSize),
              undo: setFontsize.bind(this, savedFontsize),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.FREETEXT_SIZE,
              overwriteIfSameType: true,
              keepUndo: true
          });
      }, _FreeTextEditor_updateColor = function _FreeTextEditor_updateColor(color) {
          var _this = this;
          var setColor = function (col) {
              tslib_1.__classPrivateFieldSet(_this, _FreeTextEditor_color, _this.editorDiv.style.color = col, "f");
          };
          var savedColor = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_color, "f");
          this.addCommands({
              cmd: setColor.bind(this, color),
              undo: setColor.bind(this, savedColor),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.FREETEXT_COLOR,
              overwriteIfSameType: true,
              keepUndo: true
          });
      }, _FreeTextEditor_extractText = function _FreeTextEditor_extractText() {
          var buffer = [];
          this.editorDiv.normalize();
          for (var _i = 0, _m = this.editorDiv.childNodes; _i < _m.length; _i++) {
              var child = _m[_i];
              buffer.push(tslib_1.__classPrivateFieldGet(FreeTextEditor, _l, "m", _FreeTextEditor_getNodeContent).call(FreeTextEditor, child));
          }
          return buffer.join("\n");
      }, _FreeTextEditor_setEditorDimensions = function _FreeTextEditor_setEditorDimensions() {
          var _m = this.parentDimensions, parentWidth = _m[0], parentHeight = _m[1];
          var rect;
          if (this.isAttachedToDOM) {
              rect = this.div.getBoundingClientRect();
          }
          else {
              var _o = this, currentLayer = _o.currentLayer, div = _o.div;
              var savedDisplay = div.style.display;
              var savedVisibility = div.classList.contains("hidden");
              div.classList.remove("hidden");
              div.style.display = "hidden";
              currentLayer.div.append(this.div);
              rect = div.getBoundingClientRect();
              div.remove();
              div.style.display = savedDisplay;
              div.classList.toggle("hidden", savedVisibility);
          }
          if (this.rotation % 180 === this.parentRotation % 180) {
              this.width = rect.width / parentWidth;
              this.height = rect.height / parentHeight;
          }
          else {
              this.width = rect.height / parentWidth;
              this.height = rect.width / parentHeight;
          }
          this.fixAndSetPosition();
      }, _FreeTextEditor_getNodeContent = function _FreeTextEditor_getNodeContent(node) {
          return (node.nodeType === Node.TEXT_NODE ? node.nodeValue : node.innerText).replaceAll(EOL_PATTERN, "");
      }, _FreeTextEditor_setContent = function _FreeTextEditor_setContent() {
          this.editorDiv.replaceChildren();
          if (!tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f")) {
              return;
          }
          for (var _i = 0, _m = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f").split("\n"); _i < _m.length; _i++) {
              var line = _m[_i];
              var div = document.createElement("div");
              div.append(line ? document.createTextNode(line) : document.createElement("br"));
              this.editorDiv.append(div);
          }
      }, _FreeTextEditor_serializeContent = function _FreeTextEditor_serializeContent() {
          return tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_content, "f").replaceAll("\xa0", " ");
      }, _FreeTextEditor_deserializeContent = function _FreeTextEditor_deserializeContent(content) {
          return content.replaceAll(" ", "\xa0");
      }, _FreeTextEditor_hasElementChanged = function _FreeTextEditor_hasElementChanged(serialized) {
          var _m = tslib_1.__classPrivateFieldGet(this, _FreeTextEditor_initialData, "f"), value = _m.value, fontSize = _m.fontSize, color = _m.color, pageIndex = _m.pageIndex;
          return this._hasBeenMoved || serialized.value !== value || serialized.fontSize !== fontSize || serialized.color.some(function (c, i) { return c !== color[i]; }) || serialized.pageIndex !== pageIndex;
      };
      FreeTextEditor._freeTextDefaultContent = "";
      FreeTextEditor._internalPadding = 0;
      FreeTextEditor._defaultColor = null;
      FreeTextEditor._defaultFontSize = 10;
      FreeTextEditor._type = "freetext";
      FreeTextEditor._editorType = AnnotationEditorType.FREETEXT;
      return FreeTextEditor;
  }(AnnotationEditor));
  ; // CONCATENATED MODULE: ./src/display/editor/outliner.js
  var Outliner = /** @class */ (function () {
      function Outliner(boxes, borderWidth, innerMargin, isLTR) {
          if (borderWidth === void 0) { borderWidth = 0; }
          if (innerMargin === void 0) { innerMargin = 0; }
          if (isLTR === void 0) { isLTR = true; }
          _Outliner_instances.add(this);
          _Outliner_box.set(this, void 0);
          _Outliner_verticalEdges.set(this, []);
          _Outliner_intervals.set(this, []);
          var minX = Infinity;
          var maxX = -Infinity;
          var minY = Infinity;
          var maxY = -Infinity;
          var NUMBER_OF_DIGITS = 4;
          var EPSILON = Math.pow(10, -NUMBER_OF_DIGITS);
          for (var _i = 0, boxes_2 = boxes; _i < boxes_2.length; _i++) {
              var _m = boxes_2[_i], x = _m.x, y = _m.y, width = _m.width, height = _m.height;
              var x1 = Math.floor((x - borderWidth) / EPSILON) * EPSILON;
              var x2 = Math.ceil((x + width + borderWidth) / EPSILON) * EPSILON;
              var y1 = Math.floor((y - borderWidth) / EPSILON) * EPSILON;
              var y2 = Math.ceil((y + height + borderWidth) / EPSILON) * EPSILON;
              var left = [x1, y1, y2, true];
              var right = [x2, y1, y2, false];
              tslib_1.__classPrivateFieldGet(this, _Outliner_verticalEdges, "f").push(left, right);
              minX = Math.min(minX, x1);
              maxX = Math.max(maxX, x2);
              minY = Math.min(minY, y1);
              maxY = Math.max(maxY, y2);
          }
          var bboxWidth = maxX - minX + 2 * innerMargin;
          var bboxHeight = maxY - minY + 2 * innerMargin;
          var shiftedMinX = minX - innerMargin;
          var shiftedMinY = minY - innerMargin;
          var lastEdge = tslib_1.__classPrivateFieldGet(this, _Outliner_verticalEdges, "f").at(isLTR ? -1 : -2);
          var lastPoint = [lastEdge[0], lastEdge[2]];
          for (var _o = 0, _p = tslib_1.__classPrivateFieldGet(this, _Outliner_verticalEdges, "f"); _o < _p.length; _o++) {
              var edge = _p[_o];
              var x = edge[0], y1 = edge[1], y2 = edge[2];
              edge[0] = (x - shiftedMinX) / bboxWidth;
              edge[1] = (y1 - shiftedMinY) / bboxHeight;
              edge[2] = (y2 - shiftedMinY) / bboxHeight;
          }
          tslib_1.__classPrivateFieldSet(this, _Outliner_box, {
              x: shiftedMinX,
              y: shiftedMinY,
              width: bboxWidth,
              height: bboxHeight,
              lastPoint: lastPoint
          }, "f");
      }
      Outliner.prototype.getOutlines = function () {
          tslib_1.__classPrivateFieldGet(this, _Outliner_verticalEdges, "f").sort(function (a, b) { return a[0] - b[0] || a[1] - b[1] || a[2] - b[2]; });
          var outlineVerticalEdges = [];
          for (var _i = 0, _m = tslib_1.__classPrivateFieldGet(this, _Outliner_verticalEdges, "f"); _i < _m.length; _i++) {
              var edge = _m[_i];
              if (edge[3]) {
                  outlineVerticalEdges.push.apply(outlineVerticalEdges, tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_breakEdge).call(this, edge));
                  tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_insert).call(this, edge);
              }
              else {
                  tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_remove).call(this, edge);
                  outlineVerticalEdges.push.apply(outlineVerticalEdges, tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_breakEdge).call(this, edge));
              }
          }
          return tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_getOutlines).call(this, outlineVerticalEdges);
      };
      return Outliner;
  }());
  _Outliner_box = new WeakMap(), _Outliner_verticalEdges = new WeakMap(), _Outliner_intervals = new WeakMap(), _Outliner_instances = new WeakSet(), _Outliner_getOutlines = function _Outliner_getOutlines(outlineVerticalEdges) {
      var edges = [];
      var allEdges = new Set();
      for (var _i = 0, outlineVerticalEdges_1 = outlineVerticalEdges; _i < outlineVerticalEdges_1.length; _i++) {
          var edge = outlineVerticalEdges_1[_i];
          var x = edge[0], y1 = edge[1], y2 = edge[2];
          edges.push([x, y1, edge], [x, y2, edge]);
      }
      edges.sort(function (a, b) { return a[1] - b[1] || a[0] - b[0]; });
      for (var i = 0, ii = edges.length; i < ii; i += 2) {
          var edge1 = edges[i][2];
          var edge2 = edges[i + 1][2];
          edge1.push(edge2);
          edge2.push(edge1);
          allEdges.add(edge1);
          allEdges.add(edge2);
      }
      var outlines = [];
      var outline;
      while (allEdges.size > 0) {
          var edge = allEdges.values().next().value;
          var x = edge[0], y1 = edge[1], y2 = edge[2], edge1 = edge[3], edge2 = edge[4];
          allEdges.delete(edge);
          var lastPointX = x;
          var lastPointY = y1;
          outline = [x, y2];
          outlines.push(outline);
          while (true) {
              var e = void 0;
              if (allEdges.has(edge1)) {
                  e = edge1;
              }
              else if (allEdges.has(edge2)) {
                  e = edge2;
              }
              else {
                  break;
              }
              allEdges.delete(e);
              x = e[0], y1 = e[1], y2 = e[2], edge1 = e[3], edge2 = e[4];
              if (lastPointX !== x) {
                  outline.push(lastPointX, lastPointY, x, lastPointY === y1 ? y1 : y2);
                  lastPointX = x;
              }
              lastPointY = lastPointY === y1 ? y2 : y1;
          }
          outline.push(lastPointX, lastPointY);
      }
      return new HighlightOutline(outlines, tslib_1.__classPrivateFieldGet(this, _Outliner_box, "f"));
  }, _Outliner_binarySearch = function _Outliner_binarySearch(y) {
      var array = tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f");
      var start = 0;
      var end = array.length - 1;
      while (start <= end) {
          var middle = start + end >> 1;
          var y1 = array[middle][0];
          if (y1 === y) {
              return middle;
          }
          if (y1 < y) {
              start = middle + 1;
          }
          else {
              end = middle - 1;
          }
      }
      return end + 1;
  }, _Outliner_insert = function _Outliner_insert(_m) {
      var y1 = _m[1], y2 = _m[2];
      var index = tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_binarySearch).call(this, y1);
      tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f").splice(index, 0, [y1, y2]);
  }, _Outliner_remove = function _Outliner_remove(_m) {
      var y1 = _m[1], y2 = _m[2];
      var index = tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_binarySearch).call(this, y1);
      for (var i = index; i < tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f").length; i++) {
          var _o = tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f")[i], start = _o[0], end = _o[1];
          if (start !== y1) {
              break;
          }
          if (start === y1 && end === y2) {
              tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f").splice(i, 1);
              return;
          }
      }
      for (var i = index - 1; i >= 0; i--) {
          var _p = tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f")[i], start = _p[0], end = _p[1];
          if (start !== y1) {
              break;
          }
          if (start === y1 && end === y2) {
              tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f").splice(i, 1);
              return;
          }
      }
  }, _Outliner_breakEdge = function _Outliner_breakEdge(edge) {
      var x = edge[0], y1 = edge[1], y2 = edge[2];
      var results = [[x, y1, y2]];
      var index = tslib_1.__classPrivateFieldGet(this, _Outliner_instances, "m", _Outliner_binarySearch).call(this, y2);
      for (var i = 0; i < index; i++) {
          var _m = tslib_1.__classPrivateFieldGet(this, _Outliner_intervals, "f")[i], start = _m[0], end = _m[1];
          for (var j = 0, jj = results.length; j < jj; j++) {
              var _o = results[j], y3 = _o[1], y4 = _o[2];
              if (end <= y3 || y4 <= start) {
                  continue;
              }
              if (y3 >= start) {
                  if (y4 > end) {
                      results[j][1] = end;
                  }
                  else {
                      if (jj === 1) {
                          return [];
                      }
                      results.splice(j, 1);
                      j--;
                      jj--;
                  }
                  continue;
              }
              results[j][2] = start;
              if (y4 > end) {
                  results.push([x, end, y4]);
              }
          }
      }
      return results;
  };
  var Outline = /** @class */ (function () {
      function Outline() {
      }
      Outline.prototype.toSVGPath = function () {
          throw new Error("Abstract method `toSVGPath` must be implemented.");
      };
      Object.defineProperty(Outline.prototype, "box", {
          get: function () {
              throw new Error("Abstract getter `box` must be implemented.");
          },
          enumerable: false,
          configurable: true
      });
      Outline.prototype.serialize = function (_bbox, _rotation) {
          throw new Error("Abstract method `serialize` must be implemented.");
      };
      Object.defineProperty(Outline.prototype, "free", {
          get: function () {
              return this instanceof FreeHighlightOutline;
          },
          enumerable: false,
          configurable: true
      });
      return Outline;
  }());
  var HighlightOutline = /** @class */ (function (_super) {
      tslib_1.__extends(HighlightOutline, _super);
      function HighlightOutline(outlines, box) {
          var _this = _super.call(this) || this;
          _HighlightOutline_box.set(_this, void 0);
          _HighlightOutline_outlines.set(_this, void 0);
          tslib_1.__classPrivateFieldSet(_this, _HighlightOutline_outlines, outlines, "f");
          tslib_1.__classPrivateFieldSet(_this, _HighlightOutline_box, box, "f");
          return _this;
      }
      HighlightOutline.prototype.toSVGPath = function () {
          var buffer = [];
          for (var _i = 0, _m = tslib_1.__classPrivateFieldGet(this, _HighlightOutline_outlines, "f"); _i < _m.length; _i++) {
              var polygon = _m[_i];
              var prevX = polygon[0], prevY = polygon[1];
              buffer.push("M".concat(prevX, " ").concat(prevY));
              for (var i = 2; i < polygon.length; i += 2) {
                  var x = polygon[i];
                  var y = polygon[i + 1];
                  if (x === prevX) {
                      buffer.push("V".concat(y));
                      prevY = y;
                  }
                  else if (y === prevY) {
                      buffer.push("H".concat(x));
                      prevX = x;
                  }
              }
              buffer.push("Z");
          }
          return buffer.join(" ");
      };
      HighlightOutline.prototype.serialize = function (_m, _rotation) {
          var blX = _m[0], blY = _m[1], trX = _m[2], trY = _m[3];
          var outlines = [];
          var width = trX - blX;
          var height = trY - blY;
          for (var _i = 0, _o = tslib_1.__classPrivateFieldGet(this, _HighlightOutline_outlines, "f"); _i < _o.length; _i++) {
              var outline = _o[_i];
              var points = new Array(outline.length);
              for (var i = 0; i < outline.length; i += 2) {
                  points[i] = blX + outline[i] * width;
                  points[i + 1] = trY - outline[i + 1] * height;
              }
              outlines.push(points);
          }
          return outlines;
      };
      Object.defineProperty(HighlightOutline.prototype, "box", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _HighlightOutline_box, "f");
          },
          enumerable: false,
          configurable: true
      });
      return HighlightOutline;
  }(Outline));
  _HighlightOutline_box = new WeakMap(), _HighlightOutline_outlines = new WeakMap();
  var FreeOutliner = /** @class */ (function () {
      function FreeOutliner(_o, box, scaleFactor, thickness, isLTR, innerMargin) {
          var x = _o.x, y = _o.y;
          if (innerMargin === void 0) { innerMargin = 0; }
          _FreeOutliner_instances.add(this);
          _FreeOutliner_box.set(this, void 0);
          _FreeOutliner_bottom.set(this, []);
          _FreeOutliner_innerMargin.set(this, void 0);
          _FreeOutliner_isLTR.set(this, void 0);
          _FreeOutliner_top.set(this, []);
          _FreeOutliner_last.set(this, new Float64Array(18));
          _FreeOutliner_lastX.set(this, void 0);
          _FreeOutliner_lastY.set(this, void 0);
          _FreeOutliner_min.set(this, void 0);
          _FreeOutliner_min_dist.set(this, void 0);
          _FreeOutliner_scaleFactor.set(this, void 0);
          _FreeOutliner_thickness.set(this, void 0);
          _FreeOutliner_points.set(this, []);
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_box, box, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_thickness, thickness * scaleFactor, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_isLTR, isLTR, "f");
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([NaN, NaN, NaN, NaN, x, y], 6);
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_innerMargin, innerMargin, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_min_dist, tslib_1.__classPrivateFieldGet(FreeOutliner, _m, "f", _FreeOutliner_MIN_DIST) * scaleFactor, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_min, tslib_1.__classPrivateFieldGet(FreeOutliner, _m, "f", _FreeOutliner_MIN) * scaleFactor, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_scaleFactor, scaleFactor, "f");
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_points, "f").push(x, y);
      }
      Object.defineProperty(FreeOutliner.prototype, "free", {
          get: function () {
              return true;
          },
          enumerable: false,
          configurable: true
      });
      FreeOutliner.prototype.isEmpty = function () {
          return isNaN(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[8]);
      };
      FreeOutliner.prototype.add = function (_o) {
          var _p, _q, _r, _s;
          var _t;
          var x = _o.x, y = _o.y;
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_lastX, x, "f");
          tslib_1.__classPrivateFieldSet(this, _FreeOutliner_lastY, y, "f");
          var _u = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), layerX = _u[0], layerY = _u[1], layerWidth = _u[2], layerHeight = _u[3];
          var _v = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(8, 12), x1 = _v[0], y1 = _v[1], x2 = _v[2], y2 = _v[3];
          var diffX = x - x2;
          var diffY = y - y2;
          var d = Math.hypot(diffX, diffY);
          if (d < tslib_1.__classPrivateFieldGet(this, _FreeOutliner_min, "f")) {
              return false;
          }
          var diffD = d - tslib_1.__classPrivateFieldGet(this, _FreeOutliner_min_dist, "f");
          var K = diffD / d;
          var shiftX = K * diffX;
          var shiftY = K * diffY;
          var x0 = x1;
          var y0 = y1;
          x1 = x2;
          y1 = y2;
          x2 += shiftX;
          y2 += shiftY;
          (_t = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_points, "f")) === null || _t === void 0 ? void 0 : _t.push(x, y);
          var nX = -shiftY / diffD;
          var nY = shiftX / diffD;
          var thX = nX * tslib_1.__classPrivateFieldGet(this, _FreeOutliner_thickness, "f");
          var thY = nY * tslib_1.__classPrivateFieldGet(this, _FreeOutliner_thickness, "f");
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(2, 8), 0);
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x2 + thX, y2 + thY], 4);
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(14, 18), 12);
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x2 - thX, y2 - thY], 16);
          if (isNaN(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[6])) {
              if (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f").length === 0) {
                  tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x1 + thX, y1 + thY], 2);
                  tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f").push(NaN, NaN, NaN, NaN, (x1 + thX - layerX) / layerWidth, (y1 + thY - layerY) / layerHeight);
                  tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x1 - thX, y1 - thY], 14);
                  tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f").push(NaN, NaN, NaN, NaN, (x1 - thX - layerX) / layerWidth, (y1 - thY - layerY) / layerHeight);
              }
              tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x0, y0, x1, y1, x2, y2], 6);
              return !this.isEmpty();
          }
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").set([x0, y0, x1, y1, x2, y2], 6);
          var angle = Math.abs(Math.atan2(y0 - y1, x0 - x1) - Math.atan2(shiftY, shiftX));
          if (angle < Math.PI / 2) {
              _p = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(2, 6), x1 = _p[0], y1 = _p[1], x2 = _p[2], y2 = _p[3];
              tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f").push(NaN, NaN, NaN, NaN, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
              _q = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(14, 18), x1 = _q[0], y1 = _q[1], x0 = _q[2], y0 = _q[3];
              tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f").push(NaN, NaN, NaN, NaN, ((x0 + x1) / 2 - layerX) / layerWidth, ((y0 + y1) / 2 - layerY) / layerHeight);
              return true;
          }
          _r = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(0, 6), x0 = _r[0], y0 = _r[1], x1 = _r[2], y1 = _r[3], x2 = _r[4], y2 = _r[5];
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f").push(((x0 + 5 * x1) / 6 - layerX) / layerWidth, ((y0 + 5 * y1) / 6 - layerY) / layerHeight, ((5 * x1 + x2) / 6 - layerX) / layerWidth, ((5 * y1 + y2) / 6 - layerY) / layerHeight, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
          _s = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(12, 18), x2 = _s[0], y2 = _s[1], x1 = _s[2], y1 = _s[3], x0 = _s[4], y0 = _s[5];
          tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f").push(((x0 + 5 * x1) / 6 - layerX) / layerWidth, ((y0 + 5 * y1) / 6 - layerY) / layerHeight, ((5 * x1 + x2) / 6 - layerX) / layerWidth, ((5 * y1 + y2) / 6 - layerY) / layerHeight, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
          return true;
      };
      FreeOutliner.prototype.toSVGPath = function () {
          if (this.isEmpty()) {
              return "";
          }
          var top = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f");
          var bottom = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f");
          var lastTop = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(4, 6);
          var lastBottom = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(16, 18);
          var _o = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), x = _o[0], y = _o[1], width = _o[2], height = _o[3];
          var _p = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_instances, "m", _FreeOutliner_getLastCoords).call(this), lastTopX = _p[0], lastTopY = _p[1], lastBottomX = _p[2], lastBottomY = _p[3];
          if (isNaN(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[6]) && !this.isEmpty()) {
              return "M".concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[2] - x) / width, " ").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[3] - y) / height, " L").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[4] - x) / width, " ").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[5] - y) / height, " L").concat(lastTopX, " ").concat(lastTopY, " L").concat(lastBottomX, " ").concat(lastBottomY, " L").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[16] - x) / width, " ").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[17] - y) / height, " L").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[14] - x) / width, " ").concat((tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f")[15] - y) / height, " Z");
          }
          var buffer = [];
          buffer.push("M".concat(top[4], " ").concat(top[5]));
          for (var i = 6; i < top.length; i += 6) {
              if (isNaN(top[i])) {
                  buffer.push("L".concat(top[i + 4], " ").concat(top[i + 5]));
              }
              else {
                  buffer.push("C".concat(top[i], " ").concat(top[i + 1], " ").concat(top[i + 2], " ").concat(top[i + 3], " ").concat(top[i + 4], " ").concat(top[i + 5]));
              }
          }
          buffer.push("L".concat((lastTop[0] - x) / width, " ").concat((lastTop[1] - y) / height, " L").concat(lastTopX, " ").concat(lastTopY, " L").concat(lastBottomX, " ").concat(lastBottomY, " L").concat((lastBottom[0] - x) / width, " ").concat((lastBottom[1] - y) / height));
          for (var i = bottom.length - 6; i >= 6; i -= 6) {
              if (isNaN(bottom[i])) {
                  buffer.push("L".concat(bottom[i + 4], " ").concat(bottom[i + 5]));
              }
              else {
                  buffer.push("C".concat(bottom[i], " ").concat(bottom[i + 1], " ").concat(bottom[i + 2], " ").concat(bottom[i + 3], " ").concat(bottom[i + 4], " ").concat(bottom[i + 5]));
              }
          }
          buffer.push("L".concat(bottom[4], " ").concat(bottom[5], " Z"));
          return buffer.join(" ");
      };
      FreeOutliner.prototype.getOutlines = function () {
          var _o, _p;
          var top = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f");
          var bottom = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f");
          var last = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f");
          var lastTop = last.subarray(4, 6);
          var lastBottom = last.subarray(16, 18);
          var _q = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), layerX = _q[0], layerY = _q[1], layerWidth = _q[2], layerHeight = _q[3];
          var points = new Float64Array(((_p = (_o = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_points, "f")) === null || _o === void 0 ? void 0 : _o.length) !== null && _p !== void 0 ? _p : 0) + 2);
          for (var i = 0, ii = points.length - 2; i < ii; i += 2) {
              points[i] = (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_points, "f")[i] - layerX) / layerWidth;
              points[i + 1] = (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_points, "f")[i + 1] - layerY) / layerHeight;
          }
          points[points.length - 2] = (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastX, "f") - layerX) / layerWidth;
          points[points.length - 1] = (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastY, "f") - layerY) / layerHeight;
          var _r = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_instances, "m", _FreeOutliner_getLastCoords).call(this), lastTopX = _r[0], lastTopY = _r[1], lastBottomX = _r[2], lastBottomY = _r[3];
          if (isNaN(last[6]) && !this.isEmpty()) {
              var outline_1 = new Float64Array(36);
              outline_1.set([NaN, NaN, NaN, NaN, (last[2] - layerX) / layerWidth, (last[3] - layerY) / layerHeight, NaN, NaN, NaN, NaN, (last[4] - layerX) / layerWidth, (last[5] - layerY) / layerHeight, NaN, NaN, NaN, NaN, lastTopX, lastTopY, NaN, NaN, NaN, NaN, lastBottomX, lastBottomY, NaN, NaN, NaN, NaN, (last[16] - layerX) / layerWidth, (last[17] - layerY) / layerHeight, NaN, NaN, NaN, NaN, (last[14] - layerX) / layerWidth, (last[15] - layerY) / layerHeight], 0);
              return new FreeHighlightOutline(outline_1, points, tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_scaleFactor, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_innerMargin, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_isLTR, "f"));
          }
          var outline = new Float64Array(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_top, "f").length + 24 + tslib_1.__classPrivateFieldGet(this, _FreeOutliner_bottom, "f").length);
          var N = top.length;
          for (var i = 0; i < N; i += 2) {
              if (isNaN(top[i])) {
                  outline[i] = outline[i + 1] = NaN;
                  continue;
              }
              outline[i] = top[i];
              outline[i + 1] = top[i + 1];
          }
          outline.set([NaN, NaN, NaN, NaN, (lastTop[0] - layerX) / layerWidth, (lastTop[1] - layerY) / layerHeight, NaN, NaN, NaN, NaN, lastTopX, lastTopY, NaN, NaN, NaN, NaN, lastBottomX, lastBottomY, NaN, NaN, NaN, NaN, (lastBottom[0] - layerX) / layerWidth, (lastBottom[1] - layerY) / layerHeight], N);
          N += 24;
          for (var i = bottom.length - 6; i >= 6; i -= 6) {
              for (var j = 0; j < 6; j += 2) {
                  if (isNaN(bottom[i + j])) {
                      outline[N] = outline[N + 1] = NaN;
                      N += 2;
                      continue;
                  }
                  outline[N] = bottom[i + j];
                  outline[N + 1] = bottom[i + j + 1];
                  N += 2;
              }
          }
          outline.set([NaN, NaN, NaN, NaN, bottom[4], bottom[5]], N);
          return new FreeHighlightOutline(outline, points, tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_scaleFactor, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_innerMargin, "f"), tslib_1.__classPrivateFieldGet(this, _FreeOutliner_isLTR, "f"));
      };
      var _FreeOutliner_instances, _m, _FreeOutliner_box, _FreeOutliner_bottom, _FreeOutliner_innerMargin, _FreeOutliner_isLTR, _FreeOutliner_top, _FreeOutliner_last, _FreeOutliner_lastX, _FreeOutliner_lastY, _FreeOutliner_min, _FreeOutliner_min_dist, _FreeOutliner_scaleFactor, _FreeOutliner_thickness, _FreeOutliner_points, _FreeOutliner_MIN_DIST, _FreeOutliner_MIN_DIFF, _FreeOutliner_MIN, _FreeOutliner_getLastCoords;
      _m = FreeOutliner, _FreeOutliner_box = new WeakMap(), _FreeOutliner_bottom = new WeakMap(), _FreeOutliner_innerMargin = new WeakMap(), _FreeOutliner_isLTR = new WeakMap(), _FreeOutliner_top = new WeakMap(), _FreeOutliner_last = new WeakMap(), _FreeOutliner_lastX = new WeakMap(), _FreeOutliner_lastY = new WeakMap(), _FreeOutliner_min = new WeakMap(), _FreeOutliner_min_dist = new WeakMap(), _FreeOutliner_scaleFactor = new WeakMap(), _FreeOutliner_thickness = new WeakMap(), _FreeOutliner_points = new WeakMap(), _FreeOutliner_instances = new WeakSet(), _FreeOutliner_getLastCoords = function _FreeOutliner_getLastCoords() {
          var lastTop = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(4, 6);
          var lastBottom = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_last, "f").subarray(16, 18);
          var _o = tslib_1.__classPrivateFieldGet(this, _FreeOutliner_box, "f"), x = _o[0], y = _o[1], width = _o[2], height = _o[3];
          return [(tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastX, "f") + (lastTop[0] - lastBottom[0]) / 2 - x) / width, (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastY, "f") + (lastTop[1] - lastBottom[1]) / 2 - y) / height, (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastX, "f") + (lastBottom[0] - lastTop[0]) / 2 - x) / width, (tslib_1.__classPrivateFieldGet(this, _FreeOutliner_lastY, "f") + (lastBottom[1] - lastTop[1]) / 2 - y) / height];
      };
      _FreeOutliner_MIN_DIST = { value: 8 };
      _FreeOutliner_MIN_DIFF = { value: 2 };
      _FreeOutliner_MIN = { value: tslib_1.__classPrivateFieldGet(FreeOutliner, _m, "f", _FreeOutliner_MIN_DIST) + tslib_1.__classPrivateFieldGet(FreeOutliner, _m, "f", _FreeOutliner_MIN_DIFF) };
      return FreeOutliner;
  }());
  var FreeHighlightOutline = /** @class */ (function (_super) {
      tslib_1.__extends(FreeHighlightOutline, _super);
      function FreeHighlightOutline(outline, points, box, scaleFactor, innerMargin, isLTR) {
          var _this = _super.call(this) || this;
          _FreeHighlightOutline_instances.add(_this);
          _FreeHighlightOutline_box.set(_this, void 0);
          _FreeHighlightOutline_bbox.set(_this, null);
          _FreeHighlightOutline_innerMargin.set(_this, void 0);
          _FreeHighlightOutline_isLTR.set(_this, void 0);
          _FreeHighlightOutline_points.set(_this, void 0);
          _FreeHighlightOutline_scaleFactor.set(_this, void 0);
          _FreeHighlightOutline_outline.set(_this, void 0);
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_outline, outline, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_points, points, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_box, box, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_scaleFactor, scaleFactor, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_innerMargin, innerMargin, "f");
          tslib_1.__classPrivateFieldSet(_this, _FreeHighlightOutline_isLTR, isLTR, "f");
          tslib_1.__classPrivateFieldGet(_this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_computeMinMax).call(_this, isLTR);
          var _o = tslib_1.__classPrivateFieldGet(_this, _FreeHighlightOutline_bbox, "f"), x = _o.x, y = _o.y, width = _o.width, height = _o.height;
          for (var i = 0, ii = outline.length; i < ii; i += 2) {
              outline[i] = (outline[i] - x) / width;
              outline[i + 1] = (outline[i + 1] - y) / height;
          }
          for (var i = 0, ii = points.length; i < ii; i += 2) {
              points[i] = (points[i] - x) / width;
              points[i + 1] = (points[i + 1] - y) / height;
          }
          return _this;
      }
      FreeHighlightOutline.prototype.toSVGPath = function () {
          var buffer = ["M".concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[4], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[5])];
          for (var i = 6, ii = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f").length; i < ii; i += 6) {
              if (isNaN(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i])) {
                  buffer.push("L".concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 4], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 5]));
                  continue;
              }
              buffer.push("C".concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 1], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 2], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 3], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 4], " ").concat(tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f")[i + 5]));
          }
          buffer.push("Z");
          return buffer.join(" ");
      };
      FreeHighlightOutline.prototype.serialize = function (_o, rotation) {
          var blX = _o[0], blY = _o[1], trX = _o[2], trY = _o[3];
          var width = trX - blX;
          var height = trY - blY;
          var outline;
          var points;
          switch (rotation) {
              case 0:
                  outline = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescale).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f"), blX, trY, width, -height);
                  points = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescale).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f"), blX, trY, width, -height);
                  break;
              case 90:
                  outline = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescaleAndSwap).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f"), blX, blY, width, height);
                  points = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescaleAndSwap).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f"), blX, blY, width, height);
                  break;
              case 180:
                  outline = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescale).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f"), trX, blY, -width, height);
                  points = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescale).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f"), trX, blY, -width, height);
                  break;
              case 270:
                  outline = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescaleAndSwap).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f"), trX, trY, -width, -height);
                  points = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_instances, "m", _FreeHighlightOutline_rescaleAndSwap).call(this, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f"), trX, trY, -width, -height);
                  break;
          }
          return {
              outline: Array.from(outline),
              points: [Array.from(points)]
          };
      };
      Object.defineProperty(FreeHighlightOutline.prototype, "box", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_bbox, "f");
          },
          enumerable: false,
          configurable: true
      });
      FreeHighlightOutline.prototype.getNewOutline = function (thickness, innerMargin) {
          var _o = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_bbox, "f"), x = _o.x, y = _o.y, width = _o.width, height = _o.height;
          var _p = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_box, "f"), layerX = _p[0], layerY = _p[1], layerWidth = _p[2], layerHeight = _p[3];
          var sx = width * layerWidth;
          var sy = height * layerHeight;
          var tx = x * layerWidth + layerX;
          var ty = y * layerHeight + layerY;
          var outliner = new FreeOutliner({
              x: tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f")[0] * sx + tx,
              y: tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f")[1] * sy + ty
          }, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_box, "f"), tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_scaleFactor, "f"), thickness, tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_isLTR, "f"), innerMargin !== null && innerMargin !== void 0 ? innerMargin : tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_innerMargin, "f"));
          for (var i = 2; i < tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f").length; i += 2) {
              outliner.add({
                  x: tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f")[i] * sx + tx,
                  y: tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_points, "f")[i + 1] * sy + ty
              });
          }
          return outliner.getOutlines();
      };
      return FreeHighlightOutline;
  }(Outline));
  _FreeHighlightOutline_box = new WeakMap(), _FreeHighlightOutline_bbox = new WeakMap(), _FreeHighlightOutline_innerMargin = new WeakMap(), _FreeHighlightOutline_isLTR = new WeakMap(), _FreeHighlightOutline_points = new WeakMap(), _FreeHighlightOutline_scaleFactor = new WeakMap(), _FreeHighlightOutline_outline = new WeakMap(), _FreeHighlightOutline_instances = new WeakSet(), _FreeHighlightOutline_rescale = function _FreeHighlightOutline_rescale(src, tx, ty, sx, sy) {
      var dest = new Float64Array(src.length);
      for (var i = 0, ii = src.length; i < ii; i += 2) {
          dest[i] = tx + src[i] * sx;
          dest[i + 1] = ty + src[i + 1] * sy;
      }
      return dest;
  }, _FreeHighlightOutline_rescaleAndSwap = function _FreeHighlightOutline_rescaleAndSwap(src, tx, ty, sx, sy) {
      var dest = new Float64Array(src.length);
      for (var i = 0, ii = src.length; i < ii; i += 2) {
          dest[i] = tx + src[i + 1] * sx;
          dest[i + 1] = ty + src[i] * sy;
      }
      return dest;
  }, _FreeHighlightOutline_computeMinMax = function _FreeHighlightOutline_computeMinMax(isLTR) {
      var outline = tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_outline, "f");
      var lastX = outline[4];
      var lastY = outline[5];
      var minX = lastX;
      var minY = lastY;
      var maxX = lastX;
      var maxY = lastY;
      var lastPointX = lastX;
      var lastPointY = lastY;
      var ltrCallback = isLTR ? Math.max : Math.min;
      for (var i = 6, ii = outline.length; i < ii; i += 6) {
          if (isNaN(outline[i])) {
              minX = Math.min(minX, outline[i + 4]);
              minY = Math.min(minY, outline[i + 5]);
              maxX = Math.max(maxX, outline[i + 4]);
              maxY = Math.max(maxY, outline[i + 5]);
              if (lastPointY < outline[i + 5]) {
                  lastPointX = outline[i + 4];
                  lastPointY = outline[i + 5];
              }
              else if (lastPointY === outline[i + 5]) {
                  lastPointX = ltrCallback(lastPointX, outline[i + 4]);
              }
          }
          else {
              var bbox = Util.bezierBoundingBox.apply(Util, tslib_1.__spreadArray([lastX, lastY], outline.slice(i, i + 6), false));
              minX = Math.min(minX, bbox[0]);
              minY = Math.min(minY, bbox[1]);
              maxX = Math.max(maxX, bbox[2]);
              maxY = Math.max(maxY, bbox[3]);
              if (lastPointY < bbox[3]) {
                  lastPointX = bbox[2];
                  lastPointY = bbox[3];
              }
              else if (lastPointY === bbox[3]) {
                  lastPointX = ltrCallback(lastPointX, bbox[2]);
              }
          }
          lastX = outline[i + 4];
          lastY = outline[i + 5];
      }
      var x = minX - tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_innerMargin, "f"), y = minY - tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_innerMargin, "f"), width = maxX - minX + 2 * tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_innerMargin, "f"), height = maxY - minY + 2 * tslib_1.__classPrivateFieldGet(this, _FreeHighlightOutline_innerMargin, "f");
      tslib_1.__classPrivateFieldSet(this, _FreeHighlightOutline_bbox, {
          x: x,
          y: y,
          width: width,
          height: height,
          lastPoint: [lastPointX, lastPointY]
      }, "f");
  };
  ; // CONCATENATED MODULE: ./src/display/editor/color_picker.js
  var ColorPicker = /** @class */ (function () {
      function ColorPicker(_o) {
          var _p = _o.editor, editor = _p === void 0 ? null : _p, _q = _o.uiManager, uiManager = _q === void 0 ? null : _q;
          var _r;
          _ColorPicker_instances.add(this);
          _ColorPicker_boundKeyDown.set(this, tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_keyDown).bind(this));
          _ColorPicker_boundPointerDown.set(this, tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_pointerDown).bind(this));
          _ColorPicker_button.set(this, null);
          _ColorPicker_buttonSwatch.set(this, null);
          _ColorPicker_defaultColor.set(this, void 0);
          _ColorPicker_dropdown.set(this, null);
          _ColorPicker_dropdownWasFromKeyboard.set(this, false);
          _ColorPicker_isMainColorPicker.set(this, false);
          _ColorPicker_editor.set(this, null);
          _ColorPicker_eventBus.set(this, void 0);
          _ColorPicker_uiManager.set(this, null);
          _ColorPicker_type.set(this, void 0);
          if (editor) {
              tslib_1.__classPrivateFieldSet(this, _ColorPicker_isMainColorPicker, false, "f");
              tslib_1.__classPrivateFieldSet(this, _ColorPicker_type, AnnotationEditorParamsType.HIGHLIGHT_COLOR, "f");
              tslib_1.__classPrivateFieldSet(this, _ColorPicker_editor, editor, "f");
          }
          else {
              tslib_1.__classPrivateFieldSet(this, _ColorPicker_isMainColorPicker, true, "f");
              tslib_1.__classPrivateFieldSet(this, _ColorPicker_type, AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR, "f");
          }
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_uiManager, (editor === null || editor === void 0 ? void 0 : editor._uiManager) || uiManager, "f");
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_eventBus, tslib_1.__classPrivateFieldGet(this, _ColorPicker_uiManager, "f")._eventBus, "f");
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_defaultColor, (editor === null || editor === void 0 ? void 0 : editor.color) || ((_r = tslib_1.__classPrivateFieldGet(this, _ColorPicker_uiManager, "f")) === null || _r === void 0 ? void 0 : _r.highlightColors.values().next().value) || "#FFFF98", "f");
      }
      Object.defineProperty(ColorPicker, "_keyboardManager", {
          get: function () {
              return shadow(this, "_keyboardManager", new KeyboardManager([[["Escape", "mac+Escape"], ColorPicker.prototype._hideDropdownFromKeyboard], [[" ", "mac+ "], ColorPicker.prototype._colorSelectFromKeyboard], [["ArrowDown", "ArrowRight", "mac+ArrowDown", "mac+ArrowRight"], ColorPicker.prototype._moveToNext], [["ArrowUp", "ArrowLeft", "mac+ArrowUp", "mac+ArrowLeft"], ColorPicker.prototype._moveToPrevious], [["Home", "mac+Home"], ColorPicker.prototype._moveToBeginning], [["End", "mac+End"], ColorPicker.prototype._moveToEnd]]));
          },
          enumerable: false,
          configurable: true
      });
      ColorPicker.prototype.renderButton = function () {
          var button = tslib_1.__classPrivateFieldSet(this, _ColorPicker_button, document.createElement("button"), "f");
          button.className = "colorPicker";
          button.tabIndex = "0";
          button.setAttribute("data-l10n-id", "pdfjs-editor-colorpicker-button");
          button.setAttribute("aria-haspopup", true);
          button.addEventListener("click", tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).bind(this));
          button.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _ColorPicker_boundKeyDown, "f"));
          var swatch = tslib_1.__classPrivateFieldSet(this, _ColorPicker_buttonSwatch, document.createElement("span"), "f");
          swatch.className = "swatch";
          swatch.setAttribute("aria-hidden", true);
          swatch.style.backgroundColor = tslib_1.__classPrivateFieldGet(this, _ColorPicker_defaultColor, "f");
          button.append(swatch);
          return button;
      };
      ColorPicker.prototype.renderMainDropdown = function () {
          var dropdown = tslib_1.__classPrivateFieldSet(this, _ColorPicker_dropdown, tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_getDropdownRoot).call(this), "f");
          dropdown.setAttribute("aria-orientation", "horizontal");
          dropdown.setAttribute("aria-labelledby", "highlightColorPickerLabel");
          return dropdown;
      };
      ColorPicker.prototype._colorSelectFromKeyboard = function (event) {
          if (event.target === tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f")) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).call(this, event);
              return;
          }
          var color = event.target.getAttribute("data-color");
          if (!color) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_colorSelect).call(this, color, event);
      };
      ColorPicker.prototype._moveToNext = function (event) {
          var _o, _p;
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).call(this, event);
              return;
          }
          if (event.target === tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f")) {
              (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").firstChild) === null || _o === void 0 ? void 0 : _o.focus();
              return;
          }
          (_p = event.target.nextSibling) === null || _p === void 0 ? void 0 : _p.focus();
      };
      ColorPicker.prototype._moveToPrevious = function (event) {
          var _o, _p;
          if (event.target === ((_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) === null || _o === void 0 ? void 0 : _o.firstChild) || event.target === tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f")) {
              if (tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
                  this._hideDropdownFromKeyboard();
              }
              return;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).call(this, event);
          }
          (_p = event.target.previousSibling) === null || _p === void 0 ? void 0 : _p.focus();
      };
      ColorPicker.prototype._moveToBeginning = function (event) {
          var _o;
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).call(this, event);
              return;
          }
          (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").firstChild) === null || _o === void 0 ? void 0 : _o.focus();
      };
      ColorPicker.prototype._moveToEnd = function (event) {
          var _o;
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_openDropdown).call(this, event);
              return;
          }
          (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").lastChild) === null || _o === void 0 ? void 0 : _o.focus();
      };
      ColorPicker.prototype.hideDropdown = function () {
          var _o;
          (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) === null || _o === void 0 ? void 0 : _o.classList.add("hidden");
          window.removeEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _ColorPicker_boundPointerDown, "f"));
      };
      ColorPicker.prototype._hideDropdownFromKeyboard = function () {
          var _o;
          if (tslib_1.__classPrivateFieldGet(this, _ColorPicker_isMainColorPicker, "f")) {
              return;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
              (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_editor, "f")) === null || _o === void 0 ? void 0 : _o.unselect();
              return;
          }
          this.hideDropdown();
          tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f").focus({
              preventScroll: true,
              focusVisible: tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdownWasFromKeyboard, "f")
          });
      };
      ColorPicker.prototype.updateColor = function (color) {
          if (tslib_1.__classPrivateFieldGet(this, _ColorPicker_buttonSwatch, "f")) {
              tslib_1.__classPrivateFieldGet(this, _ColorPicker_buttonSwatch, "f").style.backgroundColor = color;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) {
              return;
          }
          var i = tslib_1.__classPrivateFieldGet(this, _ColorPicker_uiManager, "f").highlightColors.values();
          for (var _i = 0, _o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").children; _i < _o.length; _i++) {
              var child = _o[_i];
              child.setAttribute("aria-selected", i.next().value === color);
          }
      };
      ColorPicker.prototype.destroy = function () {
          var _o, _p;
          (_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f")) === null || _o === void 0 ? void 0 : _o.remove();
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_button, null, "f");
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_buttonSwatch, null, "f");
          (_p = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) === null || _p === void 0 ? void 0 : _p.remove();
          tslib_1.__classPrivateFieldSet(this, _ColorPicker_dropdown, null, "f");
      };
      return ColorPicker;
  }());
  _ColorPicker_boundKeyDown = new WeakMap(), _ColorPicker_boundPointerDown = new WeakMap(), _ColorPicker_button = new WeakMap(), _ColorPicker_buttonSwatch = new WeakMap(), _ColorPicker_defaultColor = new WeakMap(), _ColorPicker_dropdown = new WeakMap(), _ColorPicker_dropdownWasFromKeyboard = new WeakMap(), _ColorPicker_isMainColorPicker = new WeakMap(), _ColorPicker_editor = new WeakMap(), _ColorPicker_eventBus = new WeakMap(), _ColorPicker_uiManager = new WeakMap(), _ColorPicker_type = new WeakMap(), _ColorPicker_instances = new WeakSet(), _ColorPicker_getDropdownRoot = function _ColorPicker_getDropdownRoot() {
      var div = document.createElement("div");
      div.addEventListener("contextmenu", noContextMenu);
      div.className = "dropdown";
      div.role = "listbox";
      div.setAttribute("aria-multiselectable", false);
      div.setAttribute("aria-orientation", "vertical");
      div.setAttribute("data-l10n-id", "pdfjs-editor-colorpicker-dropdown");
      for (var _i = 0, _o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_uiManager, "f").highlightColors; _i < _o.length; _i++) {
          var _p = _o[_i], name = _p[0], color = _p[1];
          var button = document.createElement("button");
          button.tabIndex = "0";
          button.role = "option";
          button.setAttribute("data-color", color);
          button.title = name;
          button.setAttribute("data-l10n-id", "pdfjs-editor-colorpicker-".concat(name));
          var swatch = document.createElement("span");
          button.append(swatch);
          swatch.className = "swatch";
          swatch.style.backgroundColor = color;
          button.setAttribute("aria-selected", color === tslib_1.__classPrivateFieldGet(this, _ColorPicker_defaultColor, "f"));
          button.addEventListener("click", tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_colorSelect).bind(this, color));
          div.append(button);
      }
      div.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _ColorPicker_boundKeyDown, "f"));
      return div;
  }, _ColorPicker_colorSelect = function _ColorPicker_colorSelect(color, event) {
      event.stopPropagation();
      tslib_1.__classPrivateFieldGet(this, _ColorPicker_eventBus, "f").dispatch("switchannotationeditorparams", {
          source: this,
          type: tslib_1.__classPrivateFieldGet(this, _ColorPicker_type, "f"),
          value: color
      });
  }, _ColorPicker_keyDown = function _ColorPicker_keyDown(event) {
      ColorPicker._keyboardManager.exec(this, event);
  }, _ColorPicker_openDropdown = function _ColorPicker_openDropdown(event) {
      if (tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "a", _ColorPicker_isDropdownVisible_get)) {
          this.hideDropdown();
          return;
      }
      tslib_1.__classPrivateFieldSet(this, _ColorPicker_dropdownWasFromKeyboard, event.detail === 0, "f");
      window.addEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _ColorPicker_boundPointerDown, "f"));
      if (tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) {
          tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").classList.remove("hidden");
          return;
      }
      var root = tslib_1.__classPrivateFieldSet(this, _ColorPicker_dropdown, tslib_1.__classPrivateFieldGet(this, _ColorPicker_instances, "m", _ColorPicker_getDropdownRoot).call(this), "f");
      tslib_1.__classPrivateFieldGet(this, _ColorPicker_button, "f").append(root);
  }, _ColorPicker_pointerDown = function _ColorPicker_pointerDown(event) {
      var _o;
      if ((_o = tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f")) === null || _o === void 0 ? void 0 : _o.contains(event.target)) {
          return;
      }
      this.hideDropdown();
  }, _ColorPicker_isDropdownVisible_get = function _ColorPicker_isDropdownVisible_get() {
      return tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f") && !tslib_1.__classPrivateFieldGet(this, _ColorPicker_dropdown, "f").classList.contains("hidden");
  };
  ; // CONCATENATED MODULE: ./src/display/editor/highlight.js
  var HighlightEditor = /** @class */ (function (_super) {
      tslib_1.__extends(HighlightEditor, _super);
      function HighlightEditor(params) {
          var _this = _super.call(this, tslib_1.__assign(tslib_1.__assign({}, params), { name: "highlightEditor" })) || this;
          _HighlightEditor_instances.add(_this);
          _HighlightEditor_anchorNode.set(_this, null);
          _HighlightEditor_anchorOffset.set(_this, 0);
          _HighlightEditor_boxes.set(_this, void 0);
          _HighlightEditor_clipPathId.set(_this, null);
          _HighlightEditor_colorPicker.set(_this, null);
          _HighlightEditor_focusOutlines.set(_this, null);
          _HighlightEditor_focusNode.set(_this, null);
          _HighlightEditor_focusOffset.set(_this, 0);
          _HighlightEditor_highlightDiv.set(_this, null);
          _HighlightEditor_highlightOutlines.set(_this, null);
          _HighlightEditor_id.set(_this, null);
          _HighlightEditor_isFreeHighlight.set(_this, false);
          _HighlightEditor_boundKeydown.set(_this, tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_keydown).bind(_this));
          _HighlightEditor_lastPoint.set(_this, null);
          _HighlightEditor_opacity.set(_this, void 0);
          _HighlightEditor_outlineId.set(_this, null);
          _HighlightEditor_text.set(_this, "");
          _HighlightEditor_thickness.set(_this, void 0);
          _HighlightEditor_methodOfCreation.set(_this, "");
          _this.color = params.color || HighlightEditor._defaultColor;
          tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_thickness, params.thickness || HighlightEditor._defaultThickness, "f");
          tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_opacity, params.opacity || HighlightEditor._defaultOpacity, "f");
          tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_boxes, params.boxes || null, "f");
          tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_methodOfCreation, params.methodOfCreation || "", "f");
          tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_text, params.text || "", "f");
          _this._isDraggable = false;
          if (params.highlightId > -1) {
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_isFreeHighlight, true, "f");
              tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_createFreeOutlines).call(_this, params);
              tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_addToDrawLayer).call(_this);
          }
          else {
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_anchorNode, params.anchorNode, "f");
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_anchorOffset, params.anchorOffset, "f");
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_focusNode, params.focusNode, "f");
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_focusOffset, params.focusOffset, "f");
              tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_createOutlines).call(_this);
              tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_addToDrawLayer).call(_this);
              _this.rotate(_this.rotation);
          }
          return _this;
      }
      Object.defineProperty(HighlightEditor, "_keyboardManager", {
          get: function () {
              var proto = HighlightEditor.prototype;
              return shadow(this, "_keyboardManager", new KeyboardManager([[["ArrowLeft", "mac+ArrowLeft"], proto._moveCaret, {
                          args: [0]
                      }], [["ArrowRight", "mac+ArrowRight"], proto._moveCaret, {
                          args: [1]
                      }], [["ArrowUp", "mac+ArrowUp"], proto._moveCaret, {
                          args: [2]
                      }], [["ArrowDown", "mac+ArrowDown"], proto._moveCaret, {
                          args: [3]
                      }]]));
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(HighlightEditor.prototype, "telemetryInitialData", {
          get: function () {
              return {
                  action: "added",
                  type: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f") ? "free_highlight" : "highlight",
                  color: this._uiManager.highlightColorNames.get(this.color),
                  thickness: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_thickness, "f"),
                  methodOfCreation: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_methodOfCreation, "f")
              };
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(HighlightEditor.prototype, "telemetryFinalData", {
          get: function () {
              return {
                  type: "highlight",
                  color: this._uiManager.highlightColorNames.get(this.color)
              };
          },
          enumerable: false,
          configurable: true
      });
      HighlightEditor.computeTelemetryFinalData = function (data) {
          return {
              numberOfColors: data.get("color").size
          };
      };
      HighlightEditor.initialize = function (l10n, uiManager) {
          var _p;
          AnnotationEditor.initialize(l10n, uiManager);
          HighlightEditor._defaultColor || (HighlightEditor._defaultColor = ((_p = uiManager.highlightColors) === null || _p === void 0 ? void 0 : _p.values().next().value) || "#fff066");
      };
      HighlightEditor.updateDefaultParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR:
                  HighlightEditor._defaultColor = value;
                  break;
              case AnnotationEditorParamsType.HIGHLIGHT_THICKNESS:
                  HighlightEditor._defaultThickness = value;
                  break;
          }
      };
      HighlightEditor.prototype.translateInPage = function (x, y) { };
      Object.defineProperty(HighlightEditor.prototype, "toolbarPosition", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _HighlightEditor_lastPoint, "f");
          },
          enumerable: false,
          configurable: true
      });
      HighlightEditor.prototype.updateParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.HIGHLIGHT_COLOR:
                  tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_updateColor).call(this, value);
                  break;
              case AnnotationEditorParamsType.HIGHLIGHT_THICKNESS:
                  tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_updateThickness).call(this, value);
                  break;
          }
      };
      Object.defineProperty(HighlightEditor, "defaultPropertiesToUpdate", {
          get: function () {
              return [[AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR, HighlightEditor._defaultColor], [AnnotationEditorParamsType.HIGHLIGHT_THICKNESS, HighlightEditor._defaultThickness]];
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(HighlightEditor.prototype, "propertiesToUpdate", {
          get: function () {
              return [[AnnotationEditorParamsType.HIGHLIGHT_COLOR, this.color || HighlightEditor._defaultColor], [AnnotationEditorParamsType.HIGHLIGHT_THICKNESS, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_thickness, "f") || HighlightEditor._defaultThickness], [AnnotationEditorParamsType.HIGHLIGHT_FREE, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")]];
          },
          enumerable: false,
          configurable: true
      });
      HighlightEditor.prototype.addEditToolbar = function () {
          return tslib_1.__awaiter(this, void 0, void 0, function () {
              var toolbar;
              return tslib_1.__generator(this, function (_p) {
                  switch (_p.label) {
                      case 0: return [4 /*yield*/, _super.prototype.addEditToolbar.call(this)];
                      case 1:
                          toolbar = _p.sent();
                          if (!toolbar) {
                              return [2 /*return*/, null];
                          }
                          if (this._uiManager.highlightColors) {
                              tslib_1.__classPrivateFieldSet(this, _HighlightEditor_colorPicker, new ColorPicker({
                                  editor: this
                              }), "f");
                              toolbar.addColorPicker(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_colorPicker, "f"));
                          }
                          return [2 /*return*/, toolbar];
                  }
              });
          });
      };
      HighlightEditor.prototype.disableEditing = function () {
          _super.prototype.disableEditing.call(this);
          this.div.classList.toggle("disabled", true);
      };
      HighlightEditor.prototype.enableEditing = function () {
          _super.prototype.enableEditing.call(this);
          this.div.classList.toggle("disabled", false);
      };
      HighlightEditor.prototype.fixAndSetPosition = function () {
          return _super.prototype.fixAndSetPosition.call(this, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_getRotation).call(this));
      };
      HighlightEditor.prototype.getBaseTranslation = function () {
          return [0, 0];
      };
      HighlightEditor.prototype.getRect = function (tx, ty) {
          return _super.prototype.getRect.call(this, tx, ty, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_getRotation).call(this));
      };
      HighlightEditor.prototype.onceAdded = function () {
          this.parent.addUndoableEditor(this);
          this.div.focus();
      };
      HighlightEditor.prototype.remove = function () {
          tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_cleanDrawLayer).call(this);
          this._reportTelemetry({
              action: "deleted"
          });
          _super.prototype.remove.call(this);
      };
      HighlightEditor.prototype.rebuild = function () {
          if (!this.parent) {
              return;
          }
          _super.prototype.rebuild.call(this);
          if (this.div === null) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_addToDrawLayer).call(this);
          if (!this.isAttachedToDOM) {
              this.parent.add(this);
          }
      };
      HighlightEditor.prototype.setParent = function (parent) {
          var _p;
          var mustBeSelected = false;
          if (this.parent && !parent) {
              tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_cleanDrawLayer).call(this);
          }
          else if (parent) {
              tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_addToDrawLayer).call(this, parent);
              mustBeSelected = !this.parent && ((_p = this.div) === null || _p === void 0 ? void 0 : _p.classList.contains("selectedEditor"));
          }
          _super.prototype.setParent.call(this, parent);
          this.show(this._isVisible);
          if (mustBeSelected) {
              this.select();
          }
      };
      HighlightEditor.prototype.rotate = function (angle) {
          var drawLayer = this.parent.drawLayer;
          var box;
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")) {
              angle = (angle - this.rotation + 360) % 360;
              box = tslib_1.__classPrivateFieldGet(HighlightEditor, _o, "m", _HighlightEditor_rotateBbox).call(HighlightEditor, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f").box, angle);
          }
          else {
              box = tslib_1.__classPrivateFieldGet(HighlightEditor, _o, "m", _HighlightEditor_rotateBbox).call(HighlightEditor, this, angle);
          }
          drawLayer.rotate(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"), angle);
          drawLayer.rotate(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), angle);
          drawLayer.updateBox(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"), box);
          drawLayer.updateBox(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), tslib_1.__classPrivateFieldGet(HighlightEditor, _o, "m", _HighlightEditor_rotateBbox).call(HighlightEditor, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f").box, angle));
      };
      HighlightEditor.prototype.render = function () {
          if (this.div) {
              return this.div;
          }
          var div = _super.prototype.render.call(this);
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_text, "f")) {
              div.setAttribute("aria-label", tslib_1.__classPrivateFieldGet(this, _HighlightEditor_text, "f"));
              div.setAttribute("role", "mark");
          }
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")) {
              div.classList.add("free");
          }
          else {
              this.div.addEventListener("keydown", tslib_1.__classPrivateFieldGet(this, _HighlightEditor_boundKeydown, "f"));
          }
          var highlightDiv = tslib_1.__classPrivateFieldSet(this, _HighlightEditor_highlightDiv, document.createElement("div"), "f");
          div.append(highlightDiv);
          highlightDiv.setAttribute("aria-hidden", "true");
          highlightDiv.className = "internal";
          highlightDiv.style.clipPath = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_clipPathId, "f");
          var _p = this.parentDimensions, parentWidth = _p[0], parentHeight = _p[1];
          this.setDims(this.width * parentWidth, this.height * parentHeight);
          bindEvents(this, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightDiv, "f"), ["pointerover", "pointerleave"]);
          this.enableEditing();
          return div;
      };
      HighlightEditor.prototype.pointerover = function () {
          this.parent.drawLayer.addClass(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), "hovered");
      };
      HighlightEditor.prototype.pointerleave = function () {
          this.parent.drawLayer.removeClass(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), "hovered");
      };
      HighlightEditor.prototype._moveCaret = function (direction) {
          this.parent.unselect(this);
          switch (direction) {
              case 0:
              case 2:
                  tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_setCaret).call(this, true);
                  break;
              case 1:
              case 3:
                  tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_setCaret).call(this, false);
                  break;
          }
      };
      HighlightEditor.prototype.select = function () {
          var _p, _q;
          _super.prototype.select.call(this);
          if (!tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f")) {
              return;
          }
          (_p = this.parent) === null || _p === void 0 ? void 0 : _p.drawLayer.removeClass(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), "hovered");
          (_q = this.parent) === null || _q === void 0 ? void 0 : _q.drawLayer.addClass(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), "selected");
      };
      HighlightEditor.prototype.unselect = function () {
          var _p;
          _super.prototype.unselect.call(this);
          if (!tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f")) {
              return;
          }
          (_p = this.parent) === null || _p === void 0 ? void 0 : _p.drawLayer.removeClass(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), "selected");
          if (!tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")) {
              tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_setCaret).call(this, false);
          }
      };
      Object.defineProperty(HighlightEditor.prototype, "_mustFixPosition", {
          get: function () {
              return !tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f");
          },
          enumerable: false,
          configurable: true
      });
      HighlightEditor.prototype.show = function (visible) {
          if (visible === void 0) { visible = this._isVisible; }
          _super.prototype.show.call(this, visible);
          if (this.parent) {
              this.parent.drawLayer.show(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"), visible);
              this.parent.drawLayer.show(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), visible);
          }
      };
      HighlightEditor.startHighlighting = function (parent, isLTR, _p) {
          var _q;
          var _this = this;
          var textLayer = _p.target, x = _p.x, y = _p.y;
          var _r = textLayer.getBoundingClientRect(), layerX = _r.x, layerY = _r.y, parentWidth = _r.width, parentHeight = _r.height;
          var pointerMove = function (e) {
              tslib_1.__classPrivateFieldGet(_this, _o, "m", _HighlightEditor_highlightMove).call(_this, parent, e);
          };
          var pointerDownOptions = {
              capture: true,
              passive: false
          };
          var pointerDown = function (e) {
              e.preventDefault();
              e.stopPropagation();
          };
          var pointerUpCallback = function (e) {
              textLayer.removeEventListener("pointermove", pointerMove);
              window.removeEventListener("blur", pointerUpCallback);
              window.removeEventListener("pointerup", pointerUpCallback);
              window.removeEventListener("pointerdown", pointerDown, pointerDownOptions);
              window.removeEventListener("contextmenu", noContextMenu);
              tslib_1.__classPrivateFieldGet(_this, _o, "m", _HighlightEditor_endHighlight).call(_this, parent, e);
          };
          window.addEventListener("blur", pointerUpCallback);
          window.addEventListener("pointerup", pointerUpCallback);
          window.addEventListener("pointerdown", pointerDown, pointerDownOptions);
          window.addEventListener("contextmenu", noContextMenu);
          textLayer.addEventListener("pointermove", pointerMove);
          this._freeHighlight = new FreeOutliner({
              x: x,
              y: y
          }, [layerX, layerY, parentWidth, parentHeight], parent.scale, this._defaultThickness / 2, isLTR, 0.001);
          (_q = parent.drawLayer.highlight(this._freeHighlight, this._defaultColor, this._defaultOpacity, true), this._freeHighlightId = _q.id, this._freeHighlightClipId = _q.clipPathId);
      };
      HighlightEditor.deserialize = function (data, parent, uiManager) {
          var editor = _super.deserialize.call(this, data, parent, uiManager);
          var _p = data.rect, blX = _p[0], blY = _p[1], trX = _p[2], trY = _p[3], color = data.color, quadPoints = data.quadPoints;
          editor.color = Util.makeHexColor.apply(Util, color);
          tslib_1.__classPrivateFieldSet(editor, _HighlightEditor_opacity, data.opacity, "f");
          var _q = editor.pageDimensions, pageWidth = _q[0], pageHeight = _q[1];
          editor.width = (trX - blX) / pageWidth;
          editor.height = (trY - blY) / pageHeight;
          var boxes = tslib_1.__classPrivateFieldSet(editor, _HighlightEditor_boxes, [], "f");
          for (var i = 0; i < quadPoints.length; i += 8) {
              boxes.push({
                  x: (quadPoints[4] - trX) / pageWidth,
                  y: (trY - (1 - quadPoints[i + 5])) / pageHeight,
                  width: (quadPoints[i + 2] - quadPoints[i]) / pageWidth,
                  height: (quadPoints[i + 5] - quadPoints[i + 1]) / pageHeight
              });
          }
          tslib_1.__classPrivateFieldGet(editor, _HighlightEditor_instances, "m", _HighlightEditor_createOutlines).call(editor);
          return editor;
      };
      HighlightEditor.prototype.serialize = function (isForCopying) {
          if (isForCopying === void 0) { isForCopying = false; }
          if (this.isEmpty() || isForCopying) {
              return null;
          }
          var rect = this.getRect(0, 0);
          var color = AnnotationEditor._colorManager.convert(this.color);
          return {
              annotationType: AnnotationEditorType.HIGHLIGHT,
              color: color,
              opacity: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_opacity, "f"),
              thickness: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_thickness, "f"),
              quadPoints: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_serializeBoxes).call(this),
              outlines: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_serializeOutlines).call(this, rect),
              pageIndex: this.pageIndex,
              rect: rect,
              rotation: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_getRotation).call(this),
              structTreeParentId: this._structTreeParentId
          };
      };
      HighlightEditor.canCreateNewEmptyEditor = function () {
          return false;
      };
      var _HighlightEditor_instances, _o, _HighlightEditor_anchorNode, _HighlightEditor_anchorOffset, _HighlightEditor_boxes, _HighlightEditor_clipPathId, _HighlightEditor_colorPicker, _HighlightEditor_focusOutlines, _HighlightEditor_focusNode, _HighlightEditor_focusOffset, _HighlightEditor_highlightDiv, _HighlightEditor_highlightOutlines, _HighlightEditor_id, _HighlightEditor_isFreeHighlight, _HighlightEditor_boundKeydown, _HighlightEditor_lastPoint, _HighlightEditor_opacity, _HighlightEditor_outlineId, _HighlightEditor_text, _HighlightEditor_thickness, _HighlightEditor_methodOfCreation, _HighlightEditor_createOutlines, _HighlightEditor_createFreeOutlines, _HighlightEditor_updateColor, _HighlightEditor_updateThickness, _HighlightEditor_changeThickness, _HighlightEditor_cleanDrawLayer, _HighlightEditor_addToDrawLayer, _HighlightEditor_rotateBbox, _HighlightEditor_keydown, _HighlightEditor_setCaret, _HighlightEditor_getRotation, _HighlightEditor_serializeBoxes, _HighlightEditor_serializeOutlines, _HighlightEditor_highlightMove, _HighlightEditor_endHighlight;
      _o = HighlightEditor, _HighlightEditor_anchorNode = new WeakMap(), _HighlightEditor_anchorOffset = new WeakMap(), _HighlightEditor_boxes = new WeakMap(), _HighlightEditor_clipPathId = new WeakMap(), _HighlightEditor_colorPicker = new WeakMap(), _HighlightEditor_focusOutlines = new WeakMap(), _HighlightEditor_focusNode = new WeakMap(), _HighlightEditor_focusOffset = new WeakMap(), _HighlightEditor_highlightDiv = new WeakMap(), _HighlightEditor_highlightOutlines = new WeakMap(), _HighlightEditor_id = new WeakMap(), _HighlightEditor_isFreeHighlight = new WeakMap(), _HighlightEditor_boundKeydown = new WeakMap(), _HighlightEditor_lastPoint = new WeakMap(), _HighlightEditor_opacity = new WeakMap(), _HighlightEditor_outlineId = new WeakMap(), _HighlightEditor_text = new WeakMap(), _HighlightEditor_thickness = new WeakMap(), _HighlightEditor_methodOfCreation = new WeakMap(), _HighlightEditor_instances = new WeakSet(), _HighlightEditor_createOutlines = function _HighlightEditor_createOutlines() {
          var _p;
          var outliner = new Outliner(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_boxes, "f"), 0.001);
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_highlightOutlines, outliner.getOutlines(), "f");
          (_p = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f").box, this.x = _p.x, this.y = _p.y, this.width = _p.width, this.height = _p.height);
          var outlinerForOutline = new Outliner(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_boxes, "f"), 0.0025, 0.001, this._uiManager.direction === "ltr");
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_focusOutlines, outlinerForOutline.getOutlines(), "f");
          var lastPoint = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f").box.lastPoint;
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_lastPoint, [(lastPoint[0] - this.x) / this.width, (lastPoint[1] - this.y) / this.height], "f");
      }, _HighlightEditor_createFreeOutlines = function _HighlightEditor_createFreeOutlines(_p) {
          var highlightOutlines = _p.highlightOutlines, highlightId = _p.highlightId, clipPathId = _p.clipPathId;
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_highlightOutlines, highlightOutlines, "f");
          var extraThickness = 1.5;
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_focusOutlines, highlightOutlines.getNewOutline(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_thickness, "f") / 2 + extraThickness, 0.0025), "f");
          if (highlightId >= 0) {
              tslib_1.__classPrivateFieldSet(this, _HighlightEditor_id, highlightId, "f");
              tslib_1.__classPrivateFieldSet(this, _HighlightEditor_clipPathId, clipPathId, "f");
              this.parent.drawLayer.finalizeLine(highlightId, highlightOutlines);
              tslib_1.__classPrivateFieldSet(this, _HighlightEditor_outlineId, this.parent.drawLayer.highlightOutline(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f")), "f");
          }
          else if (this.parent) {
              var angle = this.parent.viewport.rotation;
              this.parent.drawLayer.updateLine(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"), highlightOutlines);
              this.parent.drawLayer.updateBox(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"), tslib_1.__classPrivateFieldGet(HighlightEditor, _o, "m", _HighlightEditor_rotateBbox).call(HighlightEditor, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f").box, (angle - this.rotation + 360) % 360));
              this.parent.drawLayer.updateLine(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f"));
              this.parent.drawLayer.updateBox(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"), tslib_1.__classPrivateFieldGet(HighlightEditor, _o, "m", _HighlightEditor_rotateBbox).call(HighlightEditor, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f").box, angle));
          }
          var _q = highlightOutlines.box, x = _q.x, y = _q.y, width = _q.width, height = _q.height;
          switch (this.rotation) {
              case 0:
                  this.x = x;
                  this.y = y;
                  this.width = width;
                  this.height = height;
                  break;
              case 90:
                  {
                      var _r = this.parentDimensions, pageWidth = _r[0], pageHeight = _r[1];
                      this.x = y;
                      this.y = 1 - x;
                      this.width = width * pageHeight / pageWidth;
                      this.height = height * pageWidth / pageHeight;
                      break;
                  }
              case 180:
                  this.x = 1 - x;
                  this.y = 1 - y;
                  this.width = width;
                  this.height = height;
                  break;
              case 270:
                  {
                      var _s = this.parentDimensions, pageWidth = _s[0], pageHeight = _s[1];
                      this.x = 1 - y;
                      this.y = x;
                      this.width = width * pageHeight / pageWidth;
                      this.height = height * pageWidth / pageHeight;
                      break;
                  }
          }
          var lastPoint = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f").box.lastPoint;
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_lastPoint, [(lastPoint[0] - x) / width, (lastPoint[1] - y) / height], "f");
      }, _HighlightEditor_updateColor = function _HighlightEditor_updateColor(color) {
          var _this = this;
          var setColor = function (col) {
              var _p, _q;
              _this.color = col;
              (_p = _this.parent) === null || _p === void 0 ? void 0 : _p.drawLayer.changeColor(tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_id, "f"), col);
              (_q = tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_colorPicker, "f")) === null || _q === void 0 ? void 0 : _q.updateColor(col);
          };
          var savedColor = this.color;
          this.addCommands({
              cmd: setColor.bind(this, color),
              undo: setColor.bind(this, savedColor),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.HIGHLIGHT_COLOR,
              overwriteIfSameType: true,
              keepUndo: true
          });
          this._reportTelemetry({
              action: "color_changed",
              color: this._uiManager.highlightColorNames.get(color)
          }, true);
      }, _HighlightEditor_updateThickness = function _HighlightEditor_updateThickness(thickness) {
          var _this = this;
          var savedThickness = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_thickness, "f");
          var setThickness = function (th) {
              tslib_1.__classPrivateFieldSet(_this, _HighlightEditor_thickness, th, "f");
              tslib_1.__classPrivateFieldGet(_this, _HighlightEditor_instances, "m", _HighlightEditor_changeThickness).call(_this, th);
          };
          this.addCommands({
              cmd: setThickness.bind(this, thickness),
              undo: setThickness.bind(this, savedThickness),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.INK_THICKNESS,
              overwriteIfSameType: true,
              keepUndo: true
          });
          this._reportTelemetry({
              action: "thickness_changed",
              thickness: thickness
          }, true);
      }, _HighlightEditor_changeThickness = function _HighlightEditor_changeThickness(thickness) {
          if (!tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_createFreeOutlines).call(this, {
              highlightOutlines: tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f").getNewOutline(thickness / 2)
          });
          this.fixAndSetPosition();
          var _p = this.parentDimensions, parentWidth = _p[0], parentHeight = _p[1];
          this.setDims(this.width * parentWidth, this.height * parentHeight);
      }, _HighlightEditor_cleanDrawLayer = function _HighlightEditor_cleanDrawLayer() {
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f") === null || !this.parent) {
              return;
          }
          this.parent.drawLayer.remove(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f"));
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_id, null, "f");
          this.parent.drawLayer.remove(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_outlineId, "f"));
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_outlineId, null, "f");
      }, _HighlightEditor_addToDrawLayer = function _HighlightEditor_addToDrawLayer(parent) {
          var _p;
          var _q, _r;
          if (parent === void 0) { parent = this.parent; }
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_id, "f") !== null) {
              return;
          }
          (_q = this, _r = this, _p = parent.drawLayer.highlight(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f"), this.color, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_opacity, "f")), ({ set value(_a) { tslib_1.__classPrivateFieldSet(_q, _HighlightEditor_id, _a, "f"); } }).value = _p.id, ({ set value(_a) { tslib_1.__classPrivateFieldSet(_r, _HighlightEditor_clipPathId, _a, "f"); } }).value = _p.clipPathId);
          tslib_1.__classPrivateFieldSet(this, _HighlightEditor_outlineId, parent.drawLayer.highlightOutline(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOutlines, "f")), "f");
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightDiv, "f")) {
              tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightDiv, "f").style.clipPath = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_clipPathId, "f");
          }
      }, _HighlightEditor_rotateBbox = function _HighlightEditor_rotateBbox(_p, angle) {
          var x = _p.x, y = _p.y, width = _p.width, height = _p.height;
          switch (angle) {
              case 90:
                  return {
                      x: 1 - y - height,
                      y: x,
                      width: height,
                      height: width
                  };
              case 180:
                  return {
                      x: 1 - x - width,
                      y: 1 - y - height,
                      width: width,
                      height: height
                  };
              case 270:
                  return {
                      x: y,
                      y: 1 - x - width,
                      width: height,
                      height: width
                  };
          }
          return {
              x: x,
              y: y,
              width: width,
              height: height
          };
      }, _HighlightEditor_keydown = function _HighlightEditor_keydown(event) {
          HighlightEditor._keyboardManager.exec(this, event);
      }, _HighlightEditor_setCaret = function _HighlightEditor_setCaret(start) {
          if (!tslib_1.__classPrivateFieldGet(this, _HighlightEditor_anchorNode, "f")) {
              return;
          }
          var selection = window.getSelection();
          if (start) {
              selection.setPosition(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_anchorNode, "f"), tslib_1.__classPrivateFieldGet(this, _HighlightEditor_anchorOffset, "f"));
          }
          else {
              selection.setPosition(tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusNode, "f"), tslib_1.__classPrivateFieldGet(this, _HighlightEditor_focusOffset, "f"));
          }
      }, _HighlightEditor_getRotation = function _HighlightEditor_getRotation() {
          return tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f") ? this.rotation : 0;
      }, _HighlightEditor_serializeBoxes = function _HighlightEditor_serializeBoxes() {
          if (tslib_1.__classPrivateFieldGet(this, _HighlightEditor_isFreeHighlight, "f")) {
              return null;
          }
          var _p = this.pageDimensions, pageWidth = _p[0], pageHeight = _p[1];
          var boxes = tslib_1.__classPrivateFieldGet(this, _HighlightEditor_boxes, "f");
          var quadPoints = new Array(boxes.length * 8);
          var i = 0;
          for (var _i = 0, boxes_3 = boxes; _i < boxes_3.length; _i++) {
              var _q = boxes_3[_i], x = _q.x, y = _q.y, width = _q.width, height = _q.height;
              var sx = x * pageWidth;
              var sy = (1 - y - height) * pageHeight;
              quadPoints[i] = quadPoints[i + 4] = sx;
              quadPoints[i + 1] = quadPoints[i + 3] = sy;
              quadPoints[i + 2] = quadPoints[i + 6] = sx + width * pageWidth;
              quadPoints[i + 5] = quadPoints[i + 7] = sy + height * pageHeight;
              i += 8;
          }
          return quadPoints;
      }, _HighlightEditor_serializeOutlines = function _HighlightEditor_serializeOutlines(rect) {
          return tslib_1.__classPrivateFieldGet(this, _HighlightEditor_highlightOutlines, "f").serialize(rect, tslib_1.__classPrivateFieldGet(this, _HighlightEditor_instances, "m", _HighlightEditor_getRotation).call(this));
      }, _HighlightEditor_highlightMove = function _HighlightEditor_highlightMove(parent, event) {
          if (this._freeHighlight.add(event)) {
              parent.drawLayer.updatePath(this._freeHighlightId, this._freeHighlight);
          }
      }, _HighlightEditor_endHighlight = function _HighlightEditor_endHighlight(parent, event) {
          if (!this._freeHighlight.isEmpty()) {
              parent.createAndAddNewEditor(event, false, {
                  highlightId: this._freeHighlightId,
                  highlightOutlines: this._freeHighlight.getOutlines(),
                  clipPathId: this._freeHighlightClipId,
                  methodOfCreation: "main_toolbar"
              });
          }
          else {
              parent.drawLayer.removeFreeHighlight(this._freeHighlightId);
          }
          this._freeHighlightId = -1;
          this._freeHighlight = null;
          this._freeHighlightClipId = "";
      };
      HighlightEditor._defaultColor = null;
      HighlightEditor._defaultOpacity = 1;
      HighlightEditor._defaultThickness = 12;
      HighlightEditor._type = "highlight";
      HighlightEditor._editorType = AnnotationEditorType.HIGHLIGHT;
      HighlightEditor._freeHighlightId = -1;
      HighlightEditor._freeHighlight = null;
      HighlightEditor._freeHighlightClipId = "";
      return HighlightEditor;
  }(AnnotationEditor));
  ; // CONCATENATED MODULE: ./src/display/editor/ink.js
  var InkEditor = /** @class */ (function (_super) {
      tslib_1.__extends(InkEditor, _super);
      function InkEditor(params) {
          var _this = _super.call(this, tslib_1.__assign(tslib_1.__assign({}, params), { name: "inkEditor" })) || this;
          _InkEditor_instances.add(_this);
          _InkEditor_baseHeight.set(_this, 0);
          _InkEditor_baseWidth.set(_this, 0);
          _InkEditor_boundCanvasPointermove.set(_this, _this.canvasPointermove.bind(_this));
          _InkEditor_boundCanvasPointerleave.set(_this, _this.canvasPointerleave.bind(_this));
          _InkEditor_boundCanvasPointerup.set(_this, _this.canvasPointerup.bind(_this));
          _InkEditor_boundCanvasPointerdown.set(_this, _this.canvasPointerdown.bind(_this));
          _InkEditor_canvasContextMenuTimeoutId.set(_this, null);
          _InkEditor_currentPath2D.set(_this, new Path2D());
          _InkEditor_disableEditing.set(_this, false);
          _InkEditor_hasSomethingToDraw.set(_this, false);
          _InkEditor_isCanvasInitialized.set(_this, false);
          _InkEditor_observer.set(_this, null);
          _InkEditor_realWidth.set(_this, 0);
          _InkEditor_realHeight.set(_this, 0);
          _InkEditor_requestFrameCallback.set(_this, null);
          _this.color = params.color || null;
          _this.thickness = params.thickness || null;
          _this.opacity = params.opacity || null;
          _this.paths = [];
          _this.bezierPath2D = [];
          _this.allRawPaths = [];
          _this.currentPath = [];
          _this.scaleFactor = 1;
          _this.translationX = _this.translationY = 0;
          _this.x = 0;
          _this.y = 0;
          _this._willKeepAspectRatio = true;
          return _this;
      }
      InkEditor.initialize = function (l10n, uiManager) {
          AnnotationEditor.initialize(l10n, uiManager);
      };
      InkEditor.updateDefaultParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.INK_THICKNESS:
                  InkEditor._defaultThickness = value;
                  break;
              case AnnotationEditorParamsType.INK_COLOR:
                  InkEditor._defaultColor = value;
                  break;
              case AnnotationEditorParamsType.INK_OPACITY:
                  InkEditor._defaultOpacity = value / 100;
                  break;
          }
      };
      InkEditor.prototype.updateParams = function (type, value) {
          switch (type) {
              case AnnotationEditorParamsType.INK_THICKNESS:
                  tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateThickness).call(this, value);
                  break;
              case AnnotationEditorParamsType.INK_COLOR:
                  tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateColor).call(this, value);
                  break;
              case AnnotationEditorParamsType.INK_OPACITY:
                  tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateOpacity).call(this, value);
                  break;
          }
      };
      Object.defineProperty(InkEditor, "defaultPropertiesToUpdate", {
          get: function () {
              return [[AnnotationEditorParamsType.INK_THICKNESS, InkEditor._defaultThickness], [AnnotationEditorParamsType.INK_COLOR, InkEditor._defaultColor || AnnotationEditor._defaultLineColor], [AnnotationEditorParamsType.INK_OPACITY, Math.round(InkEditor._defaultOpacity * 100)]];
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(InkEditor.prototype, "propertiesToUpdate", {
          get: function () {
              var _q;
              return [[AnnotationEditorParamsType.INK_THICKNESS, this.thickness || InkEditor._defaultThickness], [AnnotationEditorParamsType.INK_COLOR, this.color || InkEditor._defaultColor || AnnotationEditor._defaultLineColor], [AnnotationEditorParamsType.INK_OPACITY, Math.round(100 * ((_q = this.opacity) !== null && _q !== void 0 ? _q : InkEditor._defaultOpacity))]];
          },
          enumerable: false,
          configurable: true
      });
      InkEditor.prototype.rebuild = function () {
          if (!this.parent) {
              return;
          }
          _super.prototype.rebuild.call(this);
          if (this.div === null) {
              return;
          }
          if (!this.canvas) {
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_createCanvas).call(this);
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_createObserver).call(this);
          }
          if (!this.isAttachedToDOM) {
              this.parent.add(this);
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setCanvasDims).call(this);
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_fitToContent).call(this);
      };
      InkEditor.prototype.remove = function () {
          if (this.canvas === null) {
              return;
          }
          if (!this.isEmpty()) {
              this.commit();
          }
          this.canvas.width = this.canvas.height = 0;
          this.canvas.remove();
          this.canvas = null;
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_canvasContextMenuTimeoutId, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _InkEditor_canvasContextMenuTimeoutId, "f"));
              tslib_1.__classPrivateFieldSet(this, _InkEditor_canvasContextMenuTimeoutId, null, "f");
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_observer, "f").disconnect();
          tslib_1.__classPrivateFieldSet(this, _InkEditor_observer, null, "f");
          _super.prototype.remove.call(this);
      };
      InkEditor.prototype.setParent = function (parent) {
          if (!this.parent && parent) {
              this._uiManager.removeShouldRescale(this);
          }
          else if (this.parent && parent === null) {
              this._uiManager.addShouldRescale(this);
          }
          _super.prototype.setParent.call(this, parent);
      };
      InkEditor.prototype.onScaleChanging = function () {
          var _q = this.parentDimensions, parentWidth = _q[0], parentHeight = _q[1];
          var width = this.width * parentWidth;
          var height = this.height * parentHeight;
          this.setDimensions(width, height);
      };
      InkEditor.prototype.enableEditMode = function () {
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f") || this.canvas === null) {
              return;
          }
          _super.prototype.enableEditMode.call(this);
          this._isDraggable = false;
          this.canvas.addEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerdown, "f"));
      };
      InkEditor.prototype.disableEditMode = function () {
          if (!this.isInEditMode() || this.canvas === null) {
              return;
          }
          _super.prototype.disableEditMode.call(this);
          this._isDraggable = !this.isEmpty();
          this.div.classList.remove("editing");
          this.canvas.removeEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerdown, "f"));
      };
      InkEditor.prototype.onceAdded = function () {
          this._isDraggable = !this.isEmpty();
      };
      InkEditor.prototype.isEmpty = function () {
          return this.paths.length === 0 || this.paths.length === 1 && this.paths[0].length === 0;
      };
      InkEditor.prototype.commit = function () {
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f")) {
              return;
          }
          _super.prototype.commit.call(this);
          this.isEditing = false;
          this.disableEditMode();
          this.setInForeground();
          tslib_1.__classPrivateFieldSet(this, _InkEditor_disableEditing, true, "f");
          this.div.classList.add("disabled");
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_fitToContent).call(this, true);
          this.select();
          this.parent.addInkEditorIfNeeded(true);
          this.moveInDOM();
          this.div.focus({
              preventScroll: true
          });
      };
      InkEditor.prototype.focusin = function (event) {
          if (!this._focusEventsAllowed) {
              return;
          }
          _super.prototype.focusin.call(this, event);
          this.enableEditMode();
      };
      InkEditor.prototype.canvasPointerdown = function (event) {
          if (event.button !== 0 || !this.isInEditMode() || tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f")) {
              return;
          }
          this.setInForeground();
          event.preventDefault();
          if (!this.div.contains(document.activeElement)) {
              this.div.focus({
                  preventScroll: true
              });
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_startDrawing).call(this, event.offsetX, event.offsetY);
      };
      InkEditor.prototype.canvasPointermove = function (event) {
          event.preventDefault();
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_draw).call(this, event.offsetX, event.offsetY);
      };
      InkEditor.prototype.canvasPointerup = function (event) {
          event.preventDefault();
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_endDrawing).call(this, event);
      };
      InkEditor.prototype.canvasPointerleave = function (event) {
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_endDrawing).call(this, event);
      };
      Object.defineProperty(InkEditor.prototype, "isResizable", {
          get: function () {
              return !this.isEmpty() && tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f");
          },
          enumerable: false,
          configurable: true
      });
      InkEditor.prototype.render = function () {
          if (this.div) {
              return this.div;
          }
          var baseX, baseY;
          if (this.width) {
              baseX = this.x;
              baseY = this.y;
          }
          _super.prototype.render.call(this);
          this.div.setAttribute("data-l10n-id", "pdfjs-ink");
          var _q = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_getInitialBBox).call(this), x = _q[0], y = _q[1], w = _q[2], h = _q[3];
          this.setAt(x, y, 0, 0);
          this.setDims(w, h);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_createCanvas).call(this);
          if (this.width) {
              var _r = this.parentDimensions, parentWidth = _r[0], parentHeight = _r[1];
              this.setAspectRatio(this.width * parentWidth, this.height * parentHeight);
              this.setAt(baseX * parentWidth, baseY * parentHeight, this.width * parentWidth, this.height * parentHeight);
              tslib_1.__classPrivateFieldSet(this, _InkEditor_isCanvasInitialized, true, "f");
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setCanvasDims).call(this);
              this.setDims(this.width * parentWidth, this.height * parentHeight);
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_redraw).call(this);
              this.div.classList.add("disabled");
          }
          else {
              this.div.classList.add("editing");
              this.enableEditMode();
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_createObserver).call(this);
          return this.div;
      };
      InkEditor.prototype.setDimensions = function (width, height) {
          var roundedWidth = Math.round(width);
          var roundedHeight = Math.round(height);
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_realWidth, "f") === roundedWidth && tslib_1.__classPrivateFieldGet(this, _InkEditor_realHeight, "f") === roundedHeight) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _InkEditor_realWidth, roundedWidth, "f");
          tslib_1.__classPrivateFieldSet(this, _InkEditor_realHeight, roundedHeight, "f");
          this.canvas.style.visibility = "hidden";
          var _q = this.parentDimensions, parentWidth = _q[0], parentHeight = _q[1];
          this.width = width / parentWidth;
          this.height = height / parentHeight;
          this.fixAndSetPosition();
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f")) {
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setScaleFactor).call(this, width, height);
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setCanvasDims).call(this);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_redraw).call(this);
          this.canvas.style.visibility = "visible";
          this.fixDims();
      };
      InkEditor.deserialize = function (data, parent, uiManager) {
          if (data instanceof InkAnnotationElement) {
              return null;
          }
          var editor = _super.deserialize.call(this, data, parent, uiManager);
          editor.thickness = data.thickness;
          editor.color = Util.makeHexColor.apply(Util, data.color);
          editor.opacity = data.opacity;
          var _q = editor.pageDimensions, pageWidth = _q[0], pageHeight = _q[1];
          var width = editor.width * pageWidth;
          var height = editor.height * pageHeight;
          var scaleFactor = editor.parentScale;
          var padding = data.thickness / 2;
          tslib_1.__classPrivateFieldSet(editor, _InkEditor_disableEditing, true, "f");
          tslib_1.__classPrivateFieldSet(editor, _InkEditor_realWidth, Math.round(width), "f");
          tslib_1.__classPrivateFieldSet(editor, _InkEditor_realHeight, Math.round(height), "f");
          var paths = data.paths, rect = data.rect, rotation = data.rotation;
          for (var _i = 0, paths_2 = paths; _i < paths_2.length; _i++) {
              var bezier = paths_2[_i].bezier;
              bezier = tslib_1.__classPrivateFieldGet(InkEditor, _p, "m", _InkEditor_fromPDFCoordinates).call(InkEditor, bezier, rect, rotation);
              var path = [];
              editor.paths.push(path);
              var p0 = scaleFactor * (bezier[0] - padding);
              var p1 = scaleFactor * (bezier[1] - padding);
              for (var i = 2, ii = bezier.length; i < ii; i += 6) {
                  var p10 = scaleFactor * (bezier[i] - padding);
                  var p11 = scaleFactor * (bezier[i + 1] - padding);
                  var p20 = scaleFactor * (bezier[i + 2] - padding);
                  var p21 = scaleFactor * (bezier[i + 3] - padding);
                  var p30 = scaleFactor * (bezier[i + 4] - padding);
                  var p31 = scaleFactor * (bezier[i + 5] - padding);
                  path.push([[p0, p1], [p10, p11], [p20, p21], [p30, p31]]);
                  p0 = p30;
                  p1 = p31;
              }
              var path2D = tslib_1.__classPrivateFieldGet(this, _p, "m", _InkEditor_buildPath2D).call(this, path);
              editor.bezierPath2D.push(path2D);
          }
          var bbox = tslib_1.__classPrivateFieldGet(editor, _InkEditor_instances, "m", _InkEditor_getBbox).call(editor);
          tslib_1.__classPrivateFieldSet(editor, _InkEditor_baseWidth, Math.max(AnnotationEditor.MIN_SIZE, bbox[2] - bbox[0]), "f");
          tslib_1.__classPrivateFieldSet(editor, _InkEditor_baseHeight, Math.max(AnnotationEditor.MIN_SIZE, bbox[3] - bbox[1]), "f");
          tslib_1.__classPrivateFieldGet(editor, _InkEditor_instances, "m", _InkEditor_setScaleFactor).call(editor, width, height);
          return editor;
      };
      InkEditor.prototype.serialize = function () {
          if (this.isEmpty()) {
              return null;
          }
          var rect = this.getRect(0, 0);
          var color = AnnotationEditor._colorManager.convert(this.ctx.strokeStyle);
          return {
              annotationType: AnnotationEditorType.INK,
              color: color,
              thickness: this.thickness,
              opacity: this.opacity,
              paths: tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_serializePaths).call(this, this.scaleFactor / this.parentScale, this.translationX, this.translationY, rect),
              pageIndex: this.pageIndex,
              rect: rect,
              rotation: this.rotation,
              structTreeParentId: this._structTreeParentId
          };
      };
      var _InkEditor_instances, _p, _InkEditor_baseHeight, _InkEditor_baseWidth, _InkEditor_boundCanvasPointermove, _InkEditor_boundCanvasPointerleave, _InkEditor_boundCanvasPointerup, _InkEditor_boundCanvasPointerdown, _InkEditor_canvasContextMenuTimeoutId, _InkEditor_currentPath2D, _InkEditor_disableEditing, _InkEditor_hasSomethingToDraw, _InkEditor_isCanvasInitialized, _InkEditor_observer, _InkEditor_realWidth, _InkEditor_realHeight, _InkEditor_requestFrameCallback, _InkEditor_updateThickness, _InkEditor_updateColor, _InkEditor_updateOpacity, _InkEditor_getInitialBBox, _InkEditor_setStroke, _InkEditor_startDrawing, _InkEditor_draw, _InkEditor_endPath, _InkEditor_stopDrawing, _InkEditor_drawPoints, _InkEditor_makeBezierCurve, _InkEditor_generateBezierPoints, _InkEditor_redraw, _InkEditor_endDrawing, _InkEditor_createCanvas, _InkEditor_createObserver, _InkEditor_setCanvasDims, _InkEditor_setScaleFactor, _InkEditor_updateTransform, _InkEditor_buildPath2D, _InkEditor_toPDFCoordinates, _InkEditor_fromPDFCoordinates, _InkEditor_serializePaths, _InkEditor_getBbox, _InkEditor_getPadding, _InkEditor_fitToContent;
      _p = InkEditor, _InkEditor_baseHeight = new WeakMap(), _InkEditor_baseWidth = new WeakMap(), _InkEditor_boundCanvasPointermove = new WeakMap(), _InkEditor_boundCanvasPointerleave = new WeakMap(), _InkEditor_boundCanvasPointerup = new WeakMap(), _InkEditor_boundCanvasPointerdown = new WeakMap(), _InkEditor_canvasContextMenuTimeoutId = new WeakMap(), _InkEditor_currentPath2D = new WeakMap(), _InkEditor_disableEditing = new WeakMap(), _InkEditor_hasSomethingToDraw = new WeakMap(), _InkEditor_isCanvasInitialized = new WeakMap(), _InkEditor_observer = new WeakMap(), _InkEditor_realWidth = new WeakMap(), _InkEditor_realHeight = new WeakMap(), _InkEditor_requestFrameCallback = new WeakMap(), _InkEditor_instances = new WeakSet(), _InkEditor_updateThickness = function _InkEditor_updateThickness(thickness) {
          var _this = this;
          var setThickness = function (th) {
              _this.thickness = th;
              tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_fitToContent).call(_this);
          };
          var savedThickness = this.thickness;
          this.addCommands({
              cmd: setThickness.bind(this, thickness),
              undo: setThickness.bind(this, savedThickness),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.INK_THICKNESS,
              overwriteIfSameType: true,
              keepUndo: true
          });
      }, _InkEditor_updateColor = function _InkEditor_updateColor(color) {
          var _this = this;
          var setColor = function (col) {
              _this.color = col;
              tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_redraw).call(_this);
          };
          var savedColor = this.color;
          this.addCommands({
              cmd: setColor.bind(this, color),
              undo: setColor.bind(this, savedColor),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.INK_COLOR,
              overwriteIfSameType: true,
              keepUndo: true
          });
      }, _InkEditor_updateOpacity = function _InkEditor_updateOpacity(opacity) {
          var _this = this;
          var setOpacity = function (op) {
              _this.opacity = op;
              tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_redraw).call(_this);
          };
          opacity /= 100;
          var savedOpacity = this.opacity;
          this.addCommands({
              cmd: setOpacity.bind(this, opacity),
              undo: setOpacity.bind(this, savedOpacity),
              post: this._uiManager.updateUI.bind(this._uiManager, this),
              mustExec: true,
              type: AnnotationEditorParamsType.INK_OPACITY,
              overwriteIfSameType: true,
              keepUndo: true
          });
      }, _InkEditor_getInitialBBox = function _InkEditor_getInitialBBox() {
          var _q = this, parentRotation = _q.parentRotation, _r = _q.parentDimensions, width = _r[0], height = _r[1];
          switch (parentRotation) {
              case 90:
                  return [0, height, height, width];
              case 180:
                  return [width, height, width, height];
              case 270:
                  return [width, 0, height, width];
              default:
                  return [0, 0, width, height];
          }
      }, _InkEditor_setStroke = function _InkEditor_setStroke() {
          var _q = this, ctx = _q.ctx, color = _q.color, opacity = _q.opacity, thickness = _q.thickness, parentScale = _q.parentScale, scaleFactor = _q.scaleFactor;
          ctx.lineWidth = thickness * parentScale / scaleFactor;
          ctx.lineCap = "round";
          ctx.lineJoin = "round";
          ctx.miterLimit = 10;
          ctx.strokeStyle = "".concat(color).concat(opacityToHex(opacity));
      }, _InkEditor_startDrawing = function _InkEditor_startDrawing(x, y) {
          var _this = this;
          var _q;
          this.canvas.addEventListener("contextmenu", noContextMenu);
          this.canvas.addEventListener("pointerleave", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerleave, "f"));
          this.canvas.addEventListener("pointermove", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointermove, "f"));
          this.canvas.addEventListener("pointerup", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerup, "f"));
          this.canvas.removeEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerdown, "f"));
          this.isEditing = true;
          if (!tslib_1.__classPrivateFieldGet(this, _InkEditor_isCanvasInitialized, "f")) {
              tslib_1.__classPrivateFieldSet(this, _InkEditor_isCanvasInitialized, true, "f");
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setCanvasDims).call(this);
              this.thickness || (this.thickness = InkEditor._defaultThickness);
              this.color || (this.color = InkEditor._defaultColor || AnnotationEditor._defaultLineColor);
              (_q = this.opacity) !== null && _q !== void 0 ? _q : (this.opacity = InkEditor._defaultOpacity);
          }
          this.currentPath.push([x, y]);
          tslib_1.__classPrivateFieldSet(this, _InkEditor_hasSomethingToDraw, false, "f");
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setStroke).call(this);
          tslib_1.__classPrivateFieldSet(this, _InkEditor_requestFrameCallback, function () {
              tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_drawPoints).call(_this);
              if (tslib_1.__classPrivateFieldGet(_this, _InkEditor_requestFrameCallback, "f")) {
                  window.requestAnimationFrame(tslib_1.__classPrivateFieldGet(_this, _InkEditor_requestFrameCallback, "f"));
              }
          }, "f");
          window.requestAnimationFrame(tslib_1.__classPrivateFieldGet(this, _InkEditor_requestFrameCallback, "f"));
      }, _InkEditor_draw = function _InkEditor_draw(x, y) {
          var _q;
          var _r = this.currentPath.at(-1), lastX = _r[0], lastY = _r[1];
          if (this.currentPath.length > 1 && x === lastX && y === lastY) {
              return;
          }
          var currentPath = this.currentPath;
          var path2D = tslib_1.__classPrivateFieldGet(this, _InkEditor_currentPath2D, "f");
          currentPath.push([x, y]);
          tslib_1.__classPrivateFieldSet(this, _InkEditor_hasSomethingToDraw, true, "f");
          if (currentPath.length <= 2) {
              path2D.moveTo.apply(path2D, currentPath[0]);
              path2D.lineTo(x, y);
              return;
          }
          if (currentPath.length === 3) {
              tslib_1.__classPrivateFieldSet(this, _InkEditor_currentPath2D, path2D = new Path2D(), "f");
              path2D.moveTo.apply(path2D, currentPath[0]);
          }
          (_q = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_makeBezierCurve)).call.apply(_q, tslib_1.__spreadArray(tslib_1.__spreadArray(tslib_1.__spreadArray([this, path2D], currentPath.at(-3), false), currentPath.at(-2), false), [x, y], false));
      }, _InkEditor_endPath = function _InkEditor_endPath() {
          var _q;
          if (this.currentPath.length === 0) {
              return;
          }
          var lastPoint = this.currentPath.at(-1);
          (_q = tslib_1.__classPrivateFieldGet(this, _InkEditor_currentPath2D, "f")).lineTo.apply(_q, lastPoint);
      }, _InkEditor_stopDrawing = function _InkEditor_stopDrawing(x, y) {
          var _this = this;
          tslib_1.__classPrivateFieldSet(this, _InkEditor_requestFrameCallback, null, "f");
          x = Math.min(Math.max(x, 0), this.canvas.width);
          y = Math.min(Math.max(y, 0), this.canvas.height);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_draw).call(this, x, y);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_endPath).call(this);
          var bezier;
          if (this.currentPath.length !== 1) {
              bezier = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_generateBezierPoints).call(this);
          }
          else {
              var xy = [x, y];
              bezier = [[xy, xy.slice(), xy.slice(), xy]];
          }
          var path2D = tslib_1.__classPrivateFieldGet(this, _InkEditor_currentPath2D, "f");
          var currentPath = this.currentPath;
          this.currentPath = [];
          tslib_1.__classPrivateFieldSet(this, _InkEditor_currentPath2D, new Path2D(), "f");
          var cmd = function () {
              _this.allRawPaths.push(currentPath);
              _this.paths.push(bezier);
              _this.bezierPath2D.push(path2D);
              _this._uiManager.rebuild(_this);
          };
          var undo = function () {
              _this.allRawPaths.pop();
              _this.paths.pop();
              _this.bezierPath2D.pop();
              if (_this.paths.length === 0) {
                  _this.remove();
              }
              else {
                  if (!_this.canvas) {
                      tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_createCanvas).call(_this);
                      tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_createObserver).call(_this);
                  }
                  tslib_1.__classPrivateFieldGet(_this, _InkEditor_instances, "m", _InkEditor_fitToContent).call(_this);
              }
          };
          this.addCommands({
              cmd: cmd,
              undo: undo,
              mustExec: true
          });
      }, _InkEditor_drawPoints = function _InkEditor_drawPoints() {
          if (!tslib_1.__classPrivateFieldGet(this, _InkEditor_hasSomethingToDraw, "f")) {
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _InkEditor_hasSomethingToDraw, false, "f");
          var thickness = Math.ceil(this.thickness * this.parentScale);
          var lastPoints = this.currentPath.slice(-3);
          var x = lastPoints.map(function (xy) { return xy[0]; });
          var y = lastPoints.map(function (xy) { return xy[1]; });
          var xMin = Math.min.apply(Math, x) - thickness;
          var xMax = Math.max.apply(Math, x) + thickness;
          var yMin = Math.min.apply(Math, y) - thickness;
          var yMax = Math.max.apply(Math, y) + thickness;
          var ctx = this.ctx;
          ctx.save();
          ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);
          for (var _i = 0, _q = this.bezierPath2D; _i < _q.length; _i++) {
              var path = _q[_i];
              ctx.stroke(path);
          }
          ctx.stroke(tslib_1.__classPrivateFieldGet(this, _InkEditor_currentPath2D, "f"));
          ctx.restore();
      }, _InkEditor_makeBezierCurve = function _InkEditor_makeBezierCurve(path2D, x0, y0, x1, y1, x2, y2) {
          var prevX = (x0 + x1) / 2;
          var prevY = (y0 + y1) / 2;
          var x3 = (x1 + x2) / 2;
          var y3 = (y1 + y2) / 2;
          path2D.bezierCurveTo(prevX + 2 * (x1 - prevX) / 3, prevY + 2 * (y1 - prevY) / 3, x3 + 2 * (x1 - x3) / 3, y3 + 2 * (y1 - y3) / 3, x3, y3);
      }, _InkEditor_generateBezierPoints = function _InkEditor_generateBezierPoints() {
          var _q;
          var path = this.currentPath;
          if (path.length <= 2) {
              return [[path[0], path[0], path.at(-1), path.at(-1)]];
          }
          var bezierPoints = [];
          var i;
          var _r = path[0], x0 = _r[0], y0 = _r[1];
          for (i = 1; i < path.length - 2; i++) {
              var _s = path[i], x1_1 = _s[0], y1_1 = _s[1];
              var _t = path[i + 1], x2_1 = _t[0], y2_1 = _t[1];
              var x3 = (x1_1 + x2_1) / 2;
              var y3 = (y1_1 + y2_1) / 2;
              var control1_1 = [x0 + 2 * (x1_1 - x0) / 3, y0 + 2 * (y1_1 - y0) / 3];
              var control2_1 = [x3 + 2 * (x1_1 - x3) / 3, y3 + 2 * (y1_1 - y3) / 3];
              bezierPoints.push([[x0, y0], control1_1, control2_1, [x3, y3]]);
              _q = [x3, y3], x0 = _q[0], y0 = _q[1];
          }
          var _u = path[i], x1 = _u[0], y1 = _u[1];
          var _v = path[i + 1], x2 = _v[0], y2 = _v[1];
          var control1 = [x0 + 2 * (x1 - x0) / 3, y0 + 2 * (y1 - y0) / 3];
          var control2 = [x2 + 2 * (x1 - x2) / 3, y2 + 2 * (y1 - y2) / 3];
          bezierPoints.push([[x0, y0], control1, control2, [x2, y2]]);
          return bezierPoints;
      }, _InkEditor_redraw = function _InkEditor_redraw() {
          if (this.isEmpty()) {
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateTransform).call(this);
              return;
          }
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setStroke).call(this);
          var _q = this, canvas = _q.canvas, ctx = _q.ctx;
          ctx.setTransform(1, 0, 0, 1, 0, 0);
          ctx.clearRect(0, 0, canvas.width, canvas.height);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateTransform).call(this);
          for (var _i = 0, _r = this.bezierPath2D; _i < _r.length; _i++) {
              var path = _r[_i];
              ctx.stroke(path);
          }
      }, _InkEditor_endDrawing = function _InkEditor_endDrawing(event) {
          var _this = this;
          this.canvas.removeEventListener("pointerleave", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerleave, "f"));
          this.canvas.removeEventListener("pointermove", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointermove, "f"));
          this.canvas.removeEventListener("pointerup", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerup, "f"));
          this.canvas.addEventListener("pointerdown", tslib_1.__classPrivateFieldGet(this, _InkEditor_boundCanvasPointerdown, "f"));
          if (tslib_1.__classPrivateFieldGet(this, _InkEditor_canvasContextMenuTimeoutId, "f")) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _InkEditor_canvasContextMenuTimeoutId, "f"));
          }
          tslib_1.__classPrivateFieldSet(this, _InkEditor_canvasContextMenuTimeoutId, setTimeout(function () {
              tslib_1.__classPrivateFieldSet(_this, _InkEditor_canvasContextMenuTimeoutId, null, "f");
              _this.canvas.removeEventListener("contextmenu", noContextMenu);
          }, 10), "f");
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_stopDrawing).call(this, event.offsetX, event.offsetY);
          this.addToAnnotationStorage();
          this.setInBackground();
      }, _InkEditor_createCanvas = function _InkEditor_createCanvas() {
          this.canvas = document.createElement("canvas");
          this.canvas.width = this.canvas.height = 0;
          this.canvas.className = "inkEditorCanvas";
          this.canvas.setAttribute("data-l10n-id", "pdfjs-ink-canvas");
          this.div.append(this.canvas);
          this.ctx = this.canvas.getContext("2d");
      }, _InkEditor_createObserver = function _InkEditor_createObserver() {
          var _this = this;
          tslib_1.__classPrivateFieldSet(this, _InkEditor_observer, new ResizeObserver(function (entries) {
              var rect = entries[0].contentRect;
              if (rect.width && rect.height) {
                  _this.setDimensions(rect.width, rect.height);
              }
          }), "f");
          tslib_1.__classPrivateFieldGet(this, _InkEditor_observer, "f").observe(this.div);
      }, _InkEditor_setCanvasDims = function _InkEditor_setCanvasDims() {
          if (!tslib_1.__classPrivateFieldGet(this, _InkEditor_isCanvasInitialized, "f")) {
              return;
          }
          var _q = this.parentDimensions, parentWidth = _q[0], parentHeight = _q[1];
          this.canvas.width = Math.ceil(this.width * parentWidth);
          this.canvas.height = Math.ceil(this.height * parentHeight);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_updateTransform).call(this);
      }, _InkEditor_setScaleFactor = function _InkEditor_setScaleFactor(width, height) {
          var padding = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_getPadding).call(this);
          var scaleFactorW = (width - padding) / tslib_1.__classPrivateFieldGet(this, _InkEditor_baseWidth, "f");
          var scaleFactorH = (height - padding) / tslib_1.__classPrivateFieldGet(this, _InkEditor_baseHeight, "f");
          this.scaleFactor = Math.min(scaleFactorW, scaleFactorH);
      }, _InkEditor_updateTransform = function _InkEditor_updateTransform() {
          var padding = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_getPadding).call(this) / 2;
          this.ctx.setTransform(this.scaleFactor, 0, 0, this.scaleFactor, this.translationX * this.scaleFactor + padding, this.translationY * this.scaleFactor + padding);
      }, _InkEditor_buildPath2D = function _InkEditor_buildPath2D(bezier) {
          var path2D = new Path2D();
          for (var i = 0, ii = bezier.length; i < ii; i++) {
              var _q = bezier[i], first = _q[0], control1 = _q[1], control2 = _q[2], second = _q[3];
              if (i === 0) {
                  path2D.moveTo.apply(path2D, first);
              }
              path2D.bezierCurveTo(control1[0], control1[1], control2[0], control2[1], second[0], second[1]);
          }
          return path2D;
      }, _InkEditor_toPDFCoordinates = function _InkEditor_toPDFCoordinates(points, rect, rotation) {
          var blX = rect[0], blY = rect[1], trX = rect[2], trY = rect[3];
          switch (rotation) {
              case 0:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      points[i] += blX;
                      points[i + 1] = trY - points[i + 1];
                  }
                  break;
              case 90:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      var x = points[i];
                      points[i] = points[i + 1] + blX;
                      points[i + 1] = x + blY;
                  }
                  break;
              case 180:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      points[i] = trX - points[i];
                      points[i + 1] += blY;
                  }
                  break;
              case 270:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      var x = points[i];
                      points[i] = trX - points[i + 1];
                      points[i + 1] = trY - x;
                  }
                  break;
              default:
                  throw new Error("Invalid rotation");
          }
          return points;
      }, _InkEditor_fromPDFCoordinates = function _InkEditor_fromPDFCoordinates(points, rect, rotation) {
          var blX = rect[0], blY = rect[1], trX = rect[2], trY = rect[3];
          switch (rotation) {
              case 0:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      points[i] -= blX;
                      points[i + 1] = trY - points[i + 1];
                  }
                  break;
              case 90:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      var x = points[i];
                      points[i] = points[i + 1] - blY;
                      points[i + 1] = x - blX;
                  }
                  break;
              case 180:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      points[i] = trX - points[i];
                      points[i + 1] -= blY;
                  }
                  break;
              case 270:
                  for (var i = 0, ii = points.length; i < ii; i += 2) {
                      var x = points[i];
                      points[i] = trY - points[i + 1];
                      points[i + 1] = trX - x;
                  }
                  break;
              default:
                  throw new Error("Invalid rotation");
          }
          return points;
      }, _InkEditor_serializePaths = function _InkEditor_serializePaths(s, tx, ty, rect) {
          var paths = [];
          var padding = this.thickness / 2;
          var shiftX = s * tx + padding;
          var shiftY = s * ty + padding;
          for (var _i = 0, _q = this.paths; _i < _q.length; _i++) {
              var bezier = _q[_i];
              var buffer = [];
              var points = [];
              for (var j = 0, jj = bezier.length; j < jj; j++) {
                  var _r = bezier[j], first = _r[0], control1 = _r[1], control2 = _r[2], second = _r[3];
                  if (first[0] === second[0] && first[1] === second[1] && jj === 1) {
                      var p0 = s * first[0] + shiftX;
                      var p1 = s * first[1] + shiftY;
                      buffer.push(p0, p1);
                      points.push(p0, p1);
                      break;
                  }
                  var p10 = s * first[0] + shiftX;
                  var p11 = s * first[1] + shiftY;
                  var p20 = s * control1[0] + shiftX;
                  var p21 = s * control1[1] + shiftY;
                  var p30 = s * control2[0] + shiftX;
                  var p31 = s * control2[1] + shiftY;
                  var p40 = s * second[0] + shiftX;
                  var p41 = s * second[1] + shiftY;
                  if (j === 0) {
                      buffer.push(p10, p11);
                      points.push(p10, p11);
                  }
                  buffer.push(p20, p21, p30, p31, p40, p41);
                  points.push(p20, p21);
                  if (j === jj - 1) {
                      points.push(p40, p41);
                  }
              }
              paths.push({
                  bezier: tslib_1.__classPrivateFieldGet(InkEditor, _p, "m", _InkEditor_toPDFCoordinates).call(InkEditor, buffer, rect, this.rotation),
                  points: tslib_1.__classPrivateFieldGet(InkEditor, _p, "m", _InkEditor_toPDFCoordinates).call(InkEditor, points, rect, this.rotation)
              });
          }
          return paths;
      }, _InkEditor_getBbox = function _InkEditor_getBbox() {
          var xMin = Infinity;
          var xMax = -Infinity;
          var yMin = Infinity;
          var yMax = -Infinity;
          for (var _i = 0, _q = this.paths; _i < _q.length; _i++) {
              var path = _q[_i];
              for (var _r = 0, path_1 = path; _r < path_1.length; _r++) {
                  var _s = path_1[_r], first = _s[0], control1 = _s[1], control2 = _s[2], second = _s[3];
                  var bbox = Util.bezierBoundingBox.apply(Util, tslib_1.__spreadArray(tslib_1.__spreadArray(tslib_1.__spreadArray(tslib_1.__spreadArray([], first, false), control1, false), control2, false), second, false));
                  xMin = Math.min(xMin, bbox[0]);
                  yMin = Math.min(yMin, bbox[1]);
                  xMax = Math.max(xMax, bbox[2]);
                  yMax = Math.max(yMax, bbox[3]);
              }
          }
          return [xMin, yMin, xMax, yMax];
      }, _InkEditor_getPadding = function _InkEditor_getPadding() {
          return tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f") ? Math.ceil(this.thickness * this.parentScale) : 0;
      }, _InkEditor_fitToContent = function _InkEditor_fitToContent(firstTime) {
          if (firstTime === void 0) { firstTime = false; }
          if (this.isEmpty()) {
              return;
          }
          if (!tslib_1.__classPrivateFieldGet(this, _InkEditor_disableEditing, "f")) {
              tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_redraw).call(this);
              return;
          }
          var bbox = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_getBbox).call(this);
          var padding = tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_getPadding).call(this);
          tslib_1.__classPrivateFieldSet(this, _InkEditor_baseWidth, Math.max(AnnotationEditor.MIN_SIZE, bbox[2] - bbox[0]), "f");
          tslib_1.__classPrivateFieldSet(this, _InkEditor_baseHeight, Math.max(AnnotationEditor.MIN_SIZE, bbox[3] - bbox[1]), "f");
          var width = Math.ceil(padding + tslib_1.__classPrivateFieldGet(this, _InkEditor_baseWidth, "f") * this.scaleFactor);
          var height = Math.ceil(padding + tslib_1.__classPrivateFieldGet(this, _InkEditor_baseHeight, "f") * this.scaleFactor);
          var _q = this.parentDimensions, parentWidth = _q[0], parentHeight = _q[1];
          this.width = width / parentWidth;
          this.height = height / parentHeight;
          this.setAspectRatio(width, height);
          var prevTranslationX = this.translationX;
          var prevTranslationY = this.translationY;
          this.translationX = -bbox[0];
          this.translationY = -bbox[1];
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_setCanvasDims).call(this);
          tslib_1.__classPrivateFieldGet(this, _InkEditor_instances, "m", _InkEditor_redraw).call(this);
          tslib_1.__classPrivateFieldSet(this, _InkEditor_realWidth, width, "f");
          tslib_1.__classPrivateFieldSet(this, _InkEditor_realHeight, height, "f");
          this.setDims(width, height);
          var unscaledPadding = firstTime ? padding / this.scaleFactor / 2 : 0;
          this.translate(prevTranslationX - this.translationX - unscaledPadding, prevTranslationY - this.translationY - unscaledPadding);
      };
      InkEditor._defaultColor = null;
      InkEditor._defaultOpacity = 1;
      InkEditor._defaultThickness = 1;
      InkEditor._type = "ink";
      InkEditor._editorType = AnnotationEditorType.INK;
      return InkEditor;
  }(AnnotationEditor));
  ; // CONCATENATED MODULE: ./src/display/editor/stamp.js
  var StampEditor = /** @class */ (function (_super) {
      tslib_1.__extends(StampEditor, _super);
      function StampEditor(params) {
          var _this = _super.call(this, tslib_1.__assign(tslib_1.__assign({}, params), { name: "stampEditor" })) || this;
          _StampEditor_instances.add(_this);
          _StampEditor_bitmap.set(_this, null);
          _StampEditor_bitmapId.set(_this, null);
          _StampEditor_bitmapPromise.set(_this, null);
          _StampEditor_bitmapUrl.set(_this, null);
          _StampEditor_bitmapFile.set(_this, null);
          _StampEditor_bitmapFileName.set(_this, "");
          _StampEditor_canvas.set(_this, null);
          _StampEditor_observer.set(_this, null);
          _StampEditor_resizeTimeoutId.set(_this, null);
          _StampEditor_isSvg.set(_this, false);
          _StampEditor_hasBeenAddedInUndoStack.set(_this, false);
          tslib_1.__classPrivateFieldSet(_this, _StampEditor_bitmapUrl, params.bitmapUrl, "f");
          tslib_1.__classPrivateFieldSet(_this, _StampEditor_bitmapFile, params.bitmapFile, "f");
          return _this;
      }
      StampEditor.initialize = function (l10n, uiManager) {
          AnnotationEditor.initialize(l10n, uiManager);
      };
      Object.defineProperty(StampEditor, "supportedTypes", {
          get: function () {
              var types = ["apng", "avif", "bmp", "gif", "jpeg", "png", "svg+xml", "webp", "x-icon"];
              return shadow(this, "supportedTypes", types.map(function (type) { return "image/".concat(type); }));
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(StampEditor, "supportedTypesStr", {
          get: function () {
              return shadow(this, "supportedTypesStr", this.supportedTypes.join(","));
          },
          enumerable: false,
          configurable: true
      });
      StampEditor.isHandlingMimeForPasting = function (mime) {
          return this.supportedTypes.includes(mime);
      };
      StampEditor.paste = function (item, parent) {
          parent.pasteEditor(AnnotationEditorType.STAMP, {
              bitmapFile: item.getAsFile()
          });
      };
      StampEditor.prototype.remove = function () {
          var _q, _r;
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f")) {
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmap, null, "f");
              this._uiManager.imageManager.deleteId(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"));
              (_q = tslib_1.__classPrivateFieldGet(this, _StampEditor_canvas, "f")) === null || _q === void 0 ? void 0 : _q.remove();
              tslib_1.__classPrivateFieldSet(this, _StampEditor_canvas, null, "f");
              (_r = tslib_1.__classPrivateFieldGet(this, _StampEditor_observer, "f")) === null || _r === void 0 ? void 0 : _r.disconnect();
              tslib_1.__classPrivateFieldSet(this, _StampEditor_observer, null, "f");
              if (tslib_1.__classPrivateFieldGet(this, _StampEditor_resizeTimeoutId, "f")) {
                  clearTimeout(tslib_1.__classPrivateFieldGet(this, _StampEditor_resizeTimeoutId, "f"));
                  tslib_1.__classPrivateFieldSet(this, _StampEditor_resizeTimeoutId, null, "f");
              }
          }
          _super.prototype.remove.call(this);
      };
      StampEditor.prototype.rebuild = function () {
          if (!this.parent) {
              if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f")) {
                  tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_getBitmap).call(this);
              }
              return;
          }
          _super.prototype.rebuild.call(this);
          if (this.div === null) {
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f") && tslib_1.__classPrivateFieldGet(this, _StampEditor_canvas, "f") === null) {
              tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_getBitmap).call(this);
          }
          if (!this.isAttachedToDOM) {
              this.parent.add(this);
          }
      };
      StampEditor.prototype.onceAdded = function () {
          this._isDraggable = true;
          this.div.focus();
      };
      StampEditor.prototype.isEmpty = function () {
          return !(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapPromise, "f") || tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f") || tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapUrl, "f") || tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapFile, "f") || tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"));
      };
      Object.defineProperty(StampEditor.prototype, "isResizable", {
          get: function () {
              return true;
          },
          enumerable: false,
          configurable: true
      });
      StampEditor.prototype.render = function () {
          if (this.div) {
              return this.div;
          }
          var baseX, baseY;
          if (this.width) {
              baseX = this.x;
              baseY = this.y;
          }
          _super.prototype.render.call(this);
          this.div.hidden = true;
          this.addAltTextButton();
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f")) {
              tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_createCanvas).call(this);
          }
          else {
              tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_getBitmap).call(this);
          }
          if (this.width) {
              var _q = this.parentDimensions, parentWidth = _q[0], parentHeight = _q[1];
              this.setAt(baseX * parentWidth, baseY * parentHeight, this.width * parentWidth, this.height * parentHeight);
          }
          return this.div;
      };
      StampEditor.prototype.getImageForAltText = function () {
          return tslib_1.__classPrivateFieldGet(this, _StampEditor_canvas, "f");
      };
      StampEditor.deserialize = function (data, parent, uiManager) {
          if (data instanceof StampAnnotationElement) {
              return null;
          }
          var editor = _super.deserialize.call(this, data, parent, uiManager);
          var rect = data.rect, bitmapUrl = data.bitmapUrl, bitmapId = data.bitmapId, isSvg = data.isSvg, accessibilityData = data.accessibilityData;
          if (bitmapId && uiManager.imageManager.isValidId(bitmapId)) {
              tslib_1.__classPrivateFieldSet(editor, _StampEditor_bitmapId, bitmapId, "f");
          }
          else {
              tslib_1.__classPrivateFieldSet(editor, _StampEditor_bitmapUrl, bitmapUrl, "f");
          }
          tslib_1.__classPrivateFieldSet(editor, _StampEditor_isSvg, isSvg, "f");
          var _q = editor.pageDimensions, parentWidth = _q[0], parentHeight = _q[1];
          editor.width = (rect[2] - rect[0]) / parentWidth;
          editor.height = (rect[3] - rect[1]) / parentHeight;
          if (accessibilityData) {
              editor.altTextData = accessibilityData;
          }
          return editor;
      };
      StampEditor.prototype.serialize = function (isForCopying, context) {
          if (isForCopying === void 0) { isForCopying = false; }
          if (context === void 0) { context = null; }
          if (this.isEmpty()) {
              return null;
          }
          var serialized = {
              annotationType: AnnotationEditorType.STAMP,
              bitmapId: tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"),
              pageIndex: this.pageIndex,
              rect: this.getRect(0, 0),
              rotation: this.rotation,
              isSvg: tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f"),
              structTreeParentId: this._structTreeParentId
          };
          if (isForCopying) {
              serialized.bitmapUrl = tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_serializeBitmap).call(this, true);
              serialized.accessibilityData = this.altTextData;
              return serialized;
          }
          var _q = this.altTextData, decorative = _q.decorative, altText = _q.altText;
          if (!decorative && altText) {
              serialized.accessibilityData = {
                  type: "Figure",
                  alt: altText
              };
          }
          if (context === null) {
              return serialized;
          }
          context.stamps || (context.stamps = new Map());
          var area = tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f") ? (serialized.rect[2] - serialized.rect[0]) * (serialized.rect[3] - serialized.rect[1]) : null;
          if (!context.stamps.has(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"))) {
              context.stamps.set(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"), {
                  area: area,
                  serialized: serialized
              });
              serialized.bitmap = tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_serializeBitmap).call(this, false);
          }
          else if (tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f")) {
              var prevData = context.stamps.get(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"));
              if (area > prevData.area) {
                  prevData.area = area;
                  prevData.serialized.bitmap.close();
                  prevData.serialized.bitmap = tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_serializeBitmap).call(this, false);
              }
          }
          return serialized;
      };
      var _StampEditor_instances, _StampEditor_bitmap, _StampEditor_bitmapId, _StampEditor_bitmapPromise, _StampEditor_bitmapUrl, _StampEditor_bitmapFile, _StampEditor_bitmapFileName, _StampEditor_canvas, _StampEditor_observer, _StampEditor_resizeTimeoutId, _StampEditor_isSvg, _StampEditor_hasBeenAddedInUndoStack, _StampEditor_getBitmapFetched, _StampEditor_getBitmapDone, _StampEditor_getBitmap, _StampEditor_createCanvas, _StampEditor_setDimensions, _StampEditor_scaleBitmap, _StampEditor_drawBitmap, _StampEditor_serializeBitmap, _StampEditor_createObserver;
      _StampEditor_bitmap = new WeakMap(), _StampEditor_bitmapId = new WeakMap(), _StampEditor_bitmapPromise = new WeakMap(), _StampEditor_bitmapUrl = new WeakMap(), _StampEditor_bitmapFile = new WeakMap(), _StampEditor_bitmapFileName = new WeakMap(), _StampEditor_canvas = new WeakMap(), _StampEditor_observer = new WeakMap(), _StampEditor_resizeTimeoutId = new WeakMap(), _StampEditor_isSvg = new WeakMap(), _StampEditor_hasBeenAddedInUndoStack = new WeakMap(), _StampEditor_instances = new WeakSet(), _StampEditor_getBitmapFetched = function _StampEditor_getBitmapFetched(data, fromId) {
          if (fromId === void 0) { fromId = false; }
          if (!data) {
              this.remove();
              return;
          }
          tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmap, data.bitmap, "f");
          if (!fromId) {
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapId, data.id, "f");
              tslib_1.__classPrivateFieldSet(this, _StampEditor_isSvg, data.isSvg, "f");
          }
          if (data.file) {
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapFileName, data.file.name, "f");
          }
          tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_createCanvas).call(this);
      }, _StampEditor_getBitmapDone = function _StampEditor_getBitmapDone() {
          tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapPromise, null, "f");
          this._uiManager.enableWaiting(false);
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_canvas, "f")) {
              this.div.focus();
          }
      }, _StampEditor_getBitmap = function _StampEditor_getBitmap() {
          var _this = this;
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f")) {
              this._uiManager.enableWaiting(true);
              this._uiManager.imageManager.getFromId(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f")).then(function (data) { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapFetched).call(_this, data, true); }).finally(function () { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapDone).call(_this); });
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapUrl, "f")) {
              var url = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapUrl, "f");
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapUrl, null, "f");
              this._uiManager.enableWaiting(true);
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapPromise, this._uiManager.imageManager.getFromUrl(url).then(function (data) { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapFetched).call(_this, data); }).finally(function () { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapDone).call(_this); }), "f");
              return;
          }
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapFile, "f")) {
              var file = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapFile, "f");
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapFile, null, "f");
              this._uiManager.enableWaiting(true);
              tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapPromise, this._uiManager.imageManager.getFromFile(file).then(function (data) { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapFetched).call(_this, data); }).finally(function () { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapDone).call(_this); }), "f");
              return;
          }
          var input = document.createElement("input");
          input.type = "file";
          input.accept = StampEditor.supportedTypesStr;
          tslib_1.__classPrivateFieldSet(this, _StampEditor_bitmapPromise, new Promise(function (resolve) {
              input.addEventListener("change", function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                  var data;
                  return tslib_1.__generator(this, function (_q) {
                      switch (_q.label) {
                          case 0:
                              if (!(!input.files || input.files.length === 0)) return [3 /*break*/, 1];
                              this.remove();
                              return [3 /*break*/, 3];
                          case 1:
                              this._uiManager.enableWaiting(true);
                              return [4 /*yield*/, this._uiManager.imageManager.getFromFile(input.files[0])];
                          case 2:
                              data = _q.sent();
                              tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_getBitmapFetched).call(this, data);
                              _q.label = 3;
                          case 3:
                              resolve();
                              return [2 /*return*/];
                      }
                  });
              }); });
              input.addEventListener("cancel", function () {
                  _this.remove();
                  resolve();
              });
          }).finally(function () { return tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_getBitmapDone).call(_this); }), "f");
          input.click();
      }, _StampEditor_createCanvas = function _StampEditor_createCanvas() {
          var div = this.div;
          var _q = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"), width = _q.width, height = _q.height;
          var _r = this.pageDimensions, pageWidth = _r[0], pageHeight = _r[1];
          var MAX_RATIO = 0.75;
          if (this.width) {
              width = this.width * pageWidth;
              height = this.height * pageHeight;
          }
          else if (width > MAX_RATIO * pageWidth || height > MAX_RATIO * pageHeight) {
              var factor = Math.min(MAX_RATIO * pageWidth / width, MAX_RATIO * pageHeight / height);
              width *= factor;
              height *= factor;
          }
          var _s = this.parentDimensions, parentWidth = _s[0], parentHeight = _s[1];
          this.setDims(width * parentWidth / pageWidth, height * parentHeight / pageHeight);
          this._uiManager.enableWaiting(false);
          var canvas = tslib_1.__classPrivateFieldSet(this, _StampEditor_canvas, document.createElement("canvas"), "f");
          div.append(canvas);
          div.hidden = false;
          tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_drawBitmap).call(this, width, height);
          tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_createObserver).call(this);
          if (!tslib_1.__classPrivateFieldGet(this, _StampEditor_hasBeenAddedInUndoStack, "f")) {
              this.parent.addUndoableEditor(this);
              tslib_1.__classPrivateFieldSet(this, _StampEditor_hasBeenAddedInUndoStack, true, "f");
          }
          this._reportTelemetry({
              action: "inserted_image"
          });
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapFileName, "f")) {
              canvas.setAttribute("aria-label", tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapFileName, "f"));
          }
      }, _StampEditor_setDimensions = function _StampEditor_setDimensions(width, height) {
          var _this = this;
          var _q;
          var _r = this.parentDimensions, parentWidth = _r[0], parentHeight = _r[1];
          this.width = width / parentWidth;
          this.height = height / parentHeight;
          this.setDims(width, height);
          if ((_q = this._initialOptions) === null || _q === void 0 ? void 0 : _q.isCentered) {
              this.center();
          }
          else {
              this.fixAndSetPosition();
          }
          this._initialOptions = null;
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_resizeTimeoutId, "f") !== null) {
              clearTimeout(tslib_1.__classPrivateFieldGet(this, _StampEditor_resizeTimeoutId, "f"));
          }
          var TIME_TO_WAIT = 200;
          tslib_1.__classPrivateFieldSet(this, _StampEditor_resizeTimeoutId, setTimeout(function () {
              tslib_1.__classPrivateFieldSet(_this, _StampEditor_resizeTimeoutId, null, "f");
              tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_drawBitmap).call(_this, width, height);
          }, TIME_TO_WAIT), "f");
      }, _StampEditor_scaleBitmap = function _StampEditor_scaleBitmap(width, height) {
          var _q = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"), bitmapWidth = _q.width, bitmapHeight = _q.height;
          var newWidth = bitmapWidth;
          var newHeight = bitmapHeight;
          var bitmap = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f");
          while (newWidth > 2 * width || newHeight > 2 * height) {
              var prevWidth = newWidth;
              var prevHeight = newHeight;
              if (newWidth > 2 * width) {
                  newWidth = newWidth >= 16384 ? Math.floor(newWidth / 2) - 1 : Math.ceil(newWidth / 2);
              }
              if (newHeight > 2 * height) {
                  newHeight = newHeight >= 16384 ? Math.floor(newHeight / 2) - 1 : Math.ceil(newHeight / 2);
              }
              var offscreen = new OffscreenCanvas(newWidth, newHeight);
              var ctx = offscreen.getContext("2d");
              ctx.drawImage(bitmap, 0, 0, prevWidth, prevHeight, 0, 0, newWidth, newHeight);
              bitmap = offscreen.transferToImageBitmap();
          }
          return bitmap;
      }, _StampEditor_drawBitmap = function _StampEditor_drawBitmap(width, height) {
          var _this = this;
          width = Math.ceil(width);
          height = Math.ceil(height);
          var canvas = tslib_1.__classPrivateFieldGet(this, _StampEditor_canvas, "f");
          if (!canvas || canvas.width === width && canvas.height === height) {
              return;
          }
          canvas.width = width;
          canvas.height = height;
          var bitmap = tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f") ? tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f") : tslib_1.__classPrivateFieldGet(this, _StampEditor_instances, "m", _StampEditor_scaleBitmap).call(this, width, height);
          if (this._uiManager.hasMLManager && !this.hasAltText()) {
              var offscreen = new OffscreenCanvas(width, height);
              var ctx_1 = offscreen.getContext("2d");
              ctx_1.drawImage(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0, width, height);
              this._uiManager.mlGuess({
                  service: "image-to-text",
                  request: {
                      data: ctx_1.getImageData(0, 0, width, height).data,
                      width: width,
                      height: height,
                      channels: 4
                  }
              }).then(function (response) {
                  var altText = (response === null || response === void 0 ? void 0 : response.output) || "";
                  if (_this.parent && altText && !_this.hasAltText()) {
                      _this.altTextData = {
                          altText: altText,
                          decorative: false
                      };
                  }
              });
          }
          var ctx = canvas.getContext("2d");
          ctx.filter = this._uiManager.hcmFilter;
          ctx.drawImage(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0, width, height);
      }, _StampEditor_serializeBitmap = function _StampEditor_serializeBitmap(toUrl) {
          var _q;
          if (toUrl) {
              if (tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f")) {
                  var url = this._uiManager.imageManager.getSvgUrl(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmapId, "f"));
                  if (url) {
                      return url;
                  }
              }
              var canvas = document.createElement("canvas");
              (_q = tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"), canvas.width = _q.width, canvas.height = _q.height);
              var ctx = canvas.getContext("2d");
              ctx.drawImage(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"), 0, 0);
              return canvas.toDataURL();
          }
          if (tslib_1.__classPrivateFieldGet(this, _StampEditor_isSvg, "f")) {
              var _r = this.pageDimensions, pageWidth = _r[0], pageHeight = _r[1];
              var width = Math.round(this.width * pageWidth * PixelsPerInch.PDF_TO_CSS_UNITS);
              var height = Math.round(this.height * pageHeight * PixelsPerInch.PDF_TO_CSS_UNITS);
              var offscreen = new OffscreenCanvas(width, height);
              var ctx = offscreen.getContext("2d");
              ctx.drawImage(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"), 0, 0, tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f").width, tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f").height, 0, 0, width, height);
              return offscreen.transferToImageBitmap();
          }
          return structuredClone(tslib_1.__classPrivateFieldGet(this, _StampEditor_bitmap, "f"));
      }, _StampEditor_createObserver = function _StampEditor_createObserver() {
          var _this = this;
          tslib_1.__classPrivateFieldSet(this, _StampEditor_observer, new ResizeObserver(function (entries) {
              var rect = entries[0].contentRect;
              if (rect.width && rect.height) {
                  tslib_1.__classPrivateFieldGet(_this, _StampEditor_instances, "m", _StampEditor_setDimensions).call(_this, rect.width, rect.height);
              }
          }), "f");
          tslib_1.__classPrivateFieldGet(this, _StampEditor_observer, "f").observe(this.div);
      };
      StampEditor._type = "stamp";
      StampEditor._editorType = AnnotationEditorType.STAMP;
      return StampEditor;
  }(AnnotationEditor));
  ; // CONCATENATED MODULE: ./src/display/editor/annotation_editor_layer.js
  var AnnotationEditorLayer = /** @class */ (function () {
      function AnnotationEditorLayer(_r) {
          var uiManager = _r.uiManager, pageIndex = _r.pageIndex, div = _r.div, accessibilityManager = _r.accessibilityManager, annotationLayer = _r.annotationLayer, drawLayer = _r.drawLayer, textLayer = _r.textLayer, viewport = _r.viewport, l10n = _r.l10n;
          _AnnotationEditorLayer_instances.add(this);
          _AnnotationEditorLayer_accessibilityManager.set(this, void 0);
          _AnnotationEditorLayer_allowClick.set(this, false);
          _AnnotationEditorLayer_annotationLayer.set(this, null);
          _AnnotationEditorLayer_boundPointerup.set(this, null);
          _AnnotationEditorLayer_boundPointerdown.set(this, null);
          _AnnotationEditorLayer_boundTextLayerPointerDown.set(this, null);
          _AnnotationEditorLayer_editorFocusTimeoutId.set(this, null);
          _AnnotationEditorLayer_editors.set(this, new Map());
          _AnnotationEditorLayer_hadPointerDown.set(this, false);
          _AnnotationEditorLayer_isCleaningUp.set(this, false);
          _AnnotationEditorLayer_isDisabling.set(this, false);
          _AnnotationEditorLayer_textLayer.set(this, null);
          _AnnotationEditorLayer_uiManager.set(this, void 0);
          var editorTypes = tslib_1.__spreadArray([], tslib_1.__classPrivateFieldGet(AnnotationEditorLayer, _q, "f", _AnnotationEditorLayer_editorTypes).values(), true);
          if (!AnnotationEditorLayer._initialized) {
              AnnotationEditorLayer._initialized = true;
              for (var _i = 0, editorTypes_1 = editorTypes; _i < editorTypes_1.length; _i++) {
                  var editorType = editorTypes_1[_i];
                  editorType.initialize(l10n, uiManager);
              }
          }
          uiManager.registerEditorTypes(editorTypes);
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorLayer_uiManager, uiManager, "f");
          this.pageIndex = pageIndex;
          this.div = div;
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorLayer_accessibilityManager, accessibilityManager, "f");
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorLayer_annotationLayer, annotationLayer, "f");
          this.viewport = viewport;
          tslib_1.__classPrivateFieldSet(this, _AnnotationEditorLayer_textLayer, textLayer, "f");
          this.drawLayer = drawLayer;
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").addLayer(this);
      }
      Object.defineProperty(AnnotationEditorLayer.prototype, "isEmpty", {
          get: function () {
              return tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_editors, "f").size === 0;
          },
          enumerable: false,
          configurable: true
      });
      Object.defineProperty(AnnotationEditorLayer.prototype, "isInvisible", {
          get: function () {
              return this.isEmpty && tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").getMode() === AnnotationEditorType.NONE;
          },
          enumerable: false,
          configurable: true
      });
      AnnotationEditorLayer.prototype.updateToolbar = function (mode) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").updateToolbar(mode);
      };
      AnnotationEditorLayer.prototype.updateMode = function (mode) {
          if (mode === void 0) { mode = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").getMode(); }
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_instances, "m", _AnnotationEditorLayer_cleanup).call(this);
          switch (mode) {
              case AnnotationEditorType.NONE:
                  this.disableTextSelection();
                  this.togglePointerEvents(false);
                  this.toggleAnnotationLayerPointerEvents(true);
                  this.disableClick();
                  return;
              case AnnotationEditorType.INK:
                  this.addInkEditorIfNeeded(false);
                  this.disableTextSelection();
                  this.togglePointerEvents(true);
                  this.disableClick();
                  break;
              case AnnotationEditorType.HIGHLIGHT:
                  this.enableTextSelection();
                  this.togglePointerEvents(false);
                  this.disableClick();
                  break;
              default:
                  this.disableTextSelection();
                  this.togglePointerEvents(true);
                  this.enableClick();
          }
          this.toggleAnnotationLayerPointerEvents(false);
          var classList = this.div.classList;
          for (var _i = 0, _r = tslib_1.__classPrivateFieldGet(AnnotationEditorLayer, _q, "f", _AnnotationEditorLayer_editorTypes).values(); _i < _r.length; _i++) {
              var editorType = _r[_i];
              classList.toggle("".concat(editorType._type, "Editing"), mode === editorType._editorType);
          }
          this.div.hidden = false;
      };
      AnnotationEditorLayer.prototype.hasTextLayer = function (textLayer) {
          var _r;
          return textLayer === ((_r = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_textLayer, "f")) === null || _r === void 0 ? void 0 : _r.div);
      };
      AnnotationEditorLayer.prototype.addInkEditorIfNeeded = function (isCommitting) {
          if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").getMode() !== AnnotationEditorType.INK) {
              return;
          }
          if (!isCommitting) {
              for (var _i = 0, _r = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_editors, "f").values(); _i < _r.length; _i++) {
                  var editor_1 = _r[_i];
                  if (editor_1.isEmpty()) {
                      editor_1.setInBackground();
                      return;
                  }
              }
          }
          var editor = this.createAndAddNewEditor({
              offsetX: 0,
              offsetY: 0
          }, false);
          editor.setInBackground();
      };
      AnnotationEditorLayer.prototype.setEditingState = function (isEditing) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").setEditingState(isEditing);
      };
      AnnotationEditorLayer.prototype.addCommands = function (params) {
          tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").addCommands(params);
      };
      AnnotationEditorLayer.prototype.togglePointerEvents = function (enabled) {
          if (enabled === void 0) { enabled = false; }
          this.div.classList.toggle("disabled", !enabled);
      };
      AnnotationEditorLayer.prototype.toggleAnnotationLayerPointerEvents = function (enabled) {
          var _r;
          if (enabled === void 0) { enabled = false; }
          (_r = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_annotationLayer, "f")) === null || _r === void 0 ? void 0 : _r.div.classList.toggle("disabled", !enabled);
      };
      AnnotationEditorLayer.prototype.enable = function () {
          this.div.tabIndex = 0;
          this.togglePointerEvents(true);
          var annotationElementIds = new Set();
          for (var _i = 0, _r = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_editors, "f").values(); _i < _r.length; _i++) {
              var editor = _r[_i];
              editor.enableEditing();
              editor.show(true);
              if (editor.annotationElementId) {
                  tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").removeChangedExistingAnnotation(editor);
                  annotationElementIds.add(editor.annotationElementId);
              }
          }
          if (!tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_annotationLayer, "f")) {
              return;
          }
          var editables = tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_annotationLayer, "f").getEditableAnnotations();
          for (var _s = 0, editables_1 = editables; _s < editables_1.length; _s++) {
              var editable = editables_1[_s];
              editable.hide();
              if (tslib_1.__classPrivateFieldGet(this, _AnnotationEditorLayer_uiManager, "f").isDeletedAnnotationElement(editable.data.id)) {
                  continue;
              }
              if (annotationElementIds.has(editable.data.id)) {
                  continue;
              }
              var editor = this.deserialize(editable);
              if (!editor) {
                  continue;
  