/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import xyz.erupt.linq.consts.JoinExchange;
import xyz.erupt.linq.consts.OrderByDirection;
import xyz.erupt.linq.engine.Engine;
import xyz.erupt.linq.exception.LinqException;
import xyz.erupt.linq.schema.Column;
import xyz.erupt.linq.schema.Dql;
import xyz.erupt.linq.schema.JoinSchema;
import xyz.erupt.linq.schema.OrderBySchema;
import xyz.erupt.linq.schema.Row;
import xyz.erupt.linq.util.Columns;
import xyz.erupt.linq.util.RowUtil;

public class EruptEngine
extends Engine {
    @Override
    public List<Row> query(Dql dql) {
        this.removeAmbiguousColumn(dql);
        List<Row> dataset = RowUtil.listToTable(dql.getFrom());
        if (!dql.getJoinSchemas().isEmpty()) {
            this.join(dql, dataset);
        }
        if (!dql.getWheres().isEmpty()) {
            dataset.removeIf(it -> {
                for (Function<Row, Boolean> condition : dql.getWheres()) {
                    if (condition.apply((Row)it).booleanValue()) continue;
                    return true;
                }
                return false;
            });
        }
        if (null != dql.getGroupBys() && !dql.getGroupBys().isEmpty()) {
            dataset = this.groupBy(dql, dataset);
        } else {
            ArrayList<Row> $table = new ArrayList<Row>(dataset.size());
            boolean existGroupFun = false;
            for (Row row : dataset) {
                Row newRow = new Row(dql.getColumns().size());
                for (Column column : dql.getColumns()) {
                    if (null != column.getGroupByFun()) {
                        existGroupFun = true;
                        newRow.put(column, column.getGroupByFun().apply(dataset));
                    } else {
                        newRow.put(column, row.get(column.getRawColumn()));
                    }
                    if (null == column.getRowConvert()) continue;
                    newRow.put(column, column.getRowConvert().apply(row));
                }
                $table.add(newRow);
                if (!existGroupFun) continue;
                break;
            }
            dataset.clear();
            dataset.addAll($table);
        }
        if (!dql.getHaving().isEmpty()) {
            dataset.removeIf(it -> {
                for (Function<Row, Boolean> condition : dql.getHaving()) {
                    if (condition.apply((Row)it).booleanValue()) continue;
                    return true;
                }
                return false;
            });
        }
        if (!dql.getOrderBys().isEmpty()) {
            this.orderBy(dql, dataset);
        }
        if (null != dql.getOffset()) {
            List<Row> list = dataset = dql.getOffset() > dataset.size() ? new ArrayList<Row>(0) : dataset.subList(dql.getOffset(), dataset.size());
        }
        if (null != dql.getLimit()) {
            dataset = dataset.subList(0, dql.getLimit() > dataset.size() ? dataset.size() : dql.getLimit().intValue());
        }
        if (dql.isDistinct()) {
            dataset = dataset.stream().distinct().collect(Collectors.toList());
        }
        return dataset;
    }

    private void removeAmbiguousColumn(Dql dql) {
        HashMap<String, Column> uniqueColumns = new HashMap<String, Column>();
        for (Column column : dql.getColumns()) {
            uniqueColumns.put(column.getAlias(), column);
        }
        dql.getColumns().clear();
        dql.getColumns().addAll(uniqueColumns.values());
    }

    public void join(Dql dql, List<Row> dataset) {
        for (JoinSchema<?> joinSchema : dql.getJoinSchemas()) {
            Column lon = Columns.of(joinSchema.getLon());
            Column ron = Columns.of(joinSchema.getRon());
            if (joinSchema.getJoinExchange() == JoinExchange.HASH) {
                List<Row> targetData = RowUtil.listToTable(joinSchema.getTarget());
                switch (joinSchema.getJoinMethod()) {
                    case LEFT: {
                        this.crossHashJoin(dataset, ron, targetData, lon);
                        break;
                    }
                    case RIGHT: {
                        this.crossHashJoin(targetData, lon, dataset, ron);
                        dataset.clear();
                        dataset.addAll(targetData);
                        break;
                    }
                    case INNER: {
                        this.crossHashJoin(dataset, ron, targetData, lon);
                        dataset.removeIf(it -> !it.containsKey(lon));
                        break;
                    }
                    case FULL: {
                        this.crossHashJoin(dataset, ron, targetData, lon);
                        this.crossHashJoin(targetData, lon, dataset, ron);
                        targetData.removeIf(it -> it.containsKey(ron));
                        dataset.addAll(targetData);
                    }
                }
                continue;
            }
            throw new LinqException(joinSchema.getJoinExchange().name() + " is not supported yet");
        }
    }

    private void crossHashJoin(List<Row> source, Column sourceColumn, List<Row> target, Column targetColumn) {
        HashMap rightMap = new HashMap();
        for (Row row : target) {
            if (!rightMap.containsKey(row.get(targetColumn))) {
                rightMap.put(row.get(targetColumn), new LinkedList());
            }
            ((List)rightMap.get(row.get(targetColumn))).add(row);
        }
        ListIterator<Row> iterator = source.listIterator();
        while (iterator.hasNext()) {
            Row row;
            row = iterator.next();
            if (!rightMap.containsKey(row.get(sourceColumn))) continue;
            for (int i = ((List)rightMap.get(row.get(sourceColumn))).size() - 1; i >= 0; --i) {
                if (i == 0) {
                    row.putAll((Map)((List)rightMap.get(row.get(sourceColumn))).get(i));
                    continue;
                }
                Row cartesianRow = new Row(row);
                cartesianRow.putAll((Map)((List)rightMap.get(row.get(sourceColumn))).get(i));
                iterator.add(cartesianRow);
            }
        }
    }

    public List<Row> groupBy(Dql dql, List<Row> dataset) {
        HashMap groupMap = new HashMap();
        for (Row row : dataset) {
            StringBuilder key = new StringBuilder();
            for (Column groupBy : dql.getGroupBys()) {
                if (null != groupBy.getRowConvert()) {
                    key.append(groupBy.getRawColumn().getRowConvert().apply(row));
                    continue;
                }
                key.append(row.get(groupBy.getRawColumn()));
            }
            if (!groupMap.containsKey(key.toString())) {
                groupMap.put(key.toString(), new ArrayList());
            }
            ((List)groupMap.get(key.toString())).add(row);
        }
        ArrayList<Row> result = new ArrayList<Row>(groupMap.size());
        for (Map.Entry entry : groupMap.entrySet()) {
            Row values = new Row(dql.getColumns().size());
            result.add(values);
            for (Column column : dql.getColumns()) {
                Object val = null;
                if (null != column.getGroupByFun()) {
                    val = column.getRawColumn().getGroupByFun().apply((List)entry.getValue());
                } else if (!((List)entry.getValue()).isEmpty()) {
                    val = ((Row)((List)entry.getValue()).get(0)).get(column.getRawColumn());
                }
                values.put(column, val);
            }
        }
        return result;
    }

    public void orderBy(Dql dql, List<Row> dataset) {
        dataset.sort((a, b) -> {
            int i = 0;
            for (OrderBySchema orderBy : dql.getOrderBys()) {
                if (null == a.get(orderBy.getColumn()) || null == b.get(orderBy.getColumn())) {
                    return 0;
                }
                if (a.get(orderBy.getColumn()) instanceof Comparable) {
                    Comparable comparable = (Comparable)a.get(orderBy.getColumn());
                    i = comparable.compareTo(b.get(orderBy.getColumn()));
                    if (orderBy.getDirection() == OrderByDirection.DESC) {
                        i = ~i + 1;
                    }
                    if (i == 0) continue;
                    return i;
                }
                throw new LinqException(orderBy.getColumn().getTable() + "." + orderBy.getColumn().getField() + " sort does not implement the Comparable interface");
            }
            return i;
        });
    }
}

