/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.grammar;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import xyz.erupt.linq.Linq;
import xyz.erupt.linq.consts.CompareSymbol;
import xyz.erupt.linq.lambda.SFunction;
import xyz.erupt.linq.schema.Row;
import xyz.erupt.linq.util.CompareUtil;

public interface Where {
    default public <R> Linq eq(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> null != value && value.equals(f));
    }

    default public <R> Linq ne(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> null != value && !value.equals(f));
    }

    default public <R> Linq between(SFunction<R, ?> column, Object start, Object end) {
        return this.where(column, row -> CompareUtil.compare(row, start, CompareSymbol.GTE) && CompareUtil.compare(row, end, CompareSymbol.LTE));
    }

    default public <R> Linq gt(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> CompareUtil.compare(f, value, CompareSymbol.GT));
    }

    default public <R> Linq lt(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> CompareUtil.compare(f, value, CompareSymbol.LT));
    }

    default public <R> Linq gte(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> CompareUtil.compare(f, value, CompareSymbol.GTE));
    }

    default public <R> Linq lte(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> CompareUtil.compare(f, value, CompareSymbol.LTE));
    }

    default public <R> Linq like(SFunction<R, ?> column, Object value) {
        return this.where(column, f -> f != null && value != null && f.toString().contains(value.toString()));
    }

    default public <R> Linq in(SFunction<R, ?> column, Object ... value) {
        return this.where(column, f -> f != null && Arrays.stream(value).anyMatch(it -> null != it && it.equals(f)));
    }

    default public <R> Linq in(SFunction<R, ?> column, List<Object> value) {
        return this.in(column, value.toArray());
    }

    default public <R> Linq notIn(SFunction<R, ?> column, Object ... value) {
        return this.where(column, f -> f != null && Arrays.stream(value).noneMatch(it -> null != it && it.equals(f)));
    }

    default public <R> Linq notIn(SFunction<R, ?> column, List<Object> value) {
        return this.notIn(column, value.toArray());
    }

    default public <R> Linq isNull(SFunction<R, ?> column) {
        return this.where(column, Objects::isNull);
    }

    default public <R> Linq isNotNull(SFunction<R, ?> column) {
        return this.where(column, Objects::nonNull);
    }

    default public <R> Linq isBlank(SFunction<R, ?> column) {
        return this.where(column, f -> f == null || f.toString().trim().isEmpty());
    }

    default public <R> Linq isNotBlank(SFunction<R, ?> column) {
        return this.where(column, f -> f != null && !f.toString().trim().isEmpty());
    }

    default public <R, S> Linq where(SFunction<R, S> column, Function<S, Boolean> process) {
        return this.where(f -> (Boolean)process.apply(f.get(column)));
    }

    public Linq where(Function<Row, Boolean> var1);
}

