/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.lambda;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.erupt.linq.exception.LinqException;
import xyz.erupt.linq.lambda.LambdaInfo;
import xyz.erupt.linq.lambda.SFunction;

public class LambdaSee {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String WRITE_REPLACE = "writeReplace";
    private static final Pattern CLASS_TYPE_PATTERN = Pattern.compile("\\(L(.*);\\).*");
    private static final Map<SFunction<?, ?>, LambdaInfo> S_FUNCTION_CACHE = new ConcurrentHashMap();

    public static <T, R> String field(SFunction<T, R> func) {
        return LambdaSee.info(func).getField();
    }

    public static <T, R> String method(SFunction<T, R> func) {
        return LambdaSee.info(func).getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> LambdaInfo info(SFunction<T, R> func) {
        try {
            if (S_FUNCTION_CACHE.containsKey(func)) {
                return S_FUNCTION_CACHE.get(func);
            }
            Class<LambdaSee> clazz = LambdaSee.class;
            synchronized (LambdaSee.class) {
                if (S_FUNCTION_CACHE.containsKey(func)) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return S_FUNCTION_CACHE.get(func);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (!func.getClass().isSynthetic()) {
                    throw new LinqException("Synthetic classes produced by non-lambda expressions");
                }
                Method method = func.getClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
                method.setAccessible(true);
                SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
                Matcher matcher = CLASS_TYPE_PATTERN.matcher(serializedLambda.getInstantiatedMethodType());
                if (!matcher.find() || matcher.groupCount() != 1) {
                    throw new RuntimeException("Failed to get Lambda information");
                }
                Class<?> clazz2 = Class.forName(matcher.group(1).replace("/", "."));
                LambdaInfo lambdaInfo = LambdaSee.getserializedLambdaInfo(serializedLambda, clazz2);
                S_FUNCTION_CACHE.put(func, lambdaInfo);
                return lambdaInfo;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static LambdaInfo getserializedLambdaInfo(SerializedLambda serializedLambda, Class<?> clazz) {
        String methodName = serializedLambda.getImplMethodName();
        if (clazz.isInterface()) {
            return new LambdaInfo(clazz, methodName, null);
        }
        String field = methodName;
        if (methodName.startsWith(GET) && methodName.length() != GET.length()) {
            field = methodName.substring(GET.length());
        }
        if (methodName.startsWith(IS) && methodName.length() != IS.length()) {
            field = methodName.substring(IS.length());
        }
        return new LambdaInfo(clazz, methodName, field.substring(0, 1).toLowerCase() + field.substring(1));
    }
}

