/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.linq.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectField {
    private static final Map<Class<?>, List<Field>> FIELDS_CACHE = new ConcurrentHashMap();

    public static List<Field> getFields(Class<?> clazz) throws SecurityException {
        return FIELDS_CACHE.computeIfAbsent(clazz, it -> ReflectField.getFieldsDirectly(it, true, true));
    }

    public static List<Field> getFieldsDirectly(Class<?> clazz, boolean distinctField, boolean withSuperClassFields) throws SecurityException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        HashMap distinctFieldMap = new HashMap(0);
        Class<?> searchType = clazz;
        while (searchType != null) {
            if (distinctField) {
                for (Field field : searchType.getDeclaredFields()) {
                    if (distinctFieldMap.containsKey(field.getName())) continue;
                    allFields.add(field);
                    distinctFieldMap.put(field.getName(), null);
                }
            } else {
                allFields.addAll(Arrays.asList(searchType.getDeclaredFields()));
            }
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }
}

